/* ml-spectra-processing 14.18.1 | MIT | https://github.com/mljs/spectra-processing#readme */
function t(t){const e=t.re.length,r=t.re,n=t.im,o=new Float64Array(e);for(let t=0;t<e;t++)o[t]=Math.hypot(r[t],n[t]);return o}const e=Object.prototype.toString;function r(t){const r=e.call(t);return r.endsWith("Array]")&&!r.includes("Big")}function n(t,e){if(void 0!==t){if(!r(t))throw new TypeError("output option must be an array if specified");if(t.length!==e)throw new TypeError("the output array does not have the correct length");return t}return new Float64Array(e)}function o(t){const e=t.slice();for(let t=0;t<e.length;t++)e[t]<0&&(e[t]*=-1);return e}function s(t,e={}){if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const{exact:n=!1}=e||{},o=t.slice(),s=h(0,o.length-1),l=i(o,s);if(o.length%2==1||!n)return l;return(l+i(o,s+1))/2}function i(t,e){let r=0,n=t.length-1,o=0,s=0,i=0;for(;;){if(n<=r)return t[e];if(n===r+1)return t[r]>t[n]&&l(t,r,n),t[e];for(o=h(r,n),t[o]>t[n]&&l(t,o,n),t[r]>t[n]&&l(t,r,n),t[o]>t[r]&&l(t,o,r),l(t,o,r+1),s=r+1,i=n;;){do{s++}while(t[r]>t[s]);do{i--}while(t[i]>t[r]);if(i<s)break;l(t,s,i)}l(t,r,i),i<=e&&(r=s),i>=e&&(n=i-1)}}function l(t,e,r){const n=t[r];t[r]=t[e],t[e]=n}function h(t,e){return Math.floor((t+e)/2)}function a(t){return s(o(t))}function u(t,e={}){const{minLength:n}=e;if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if("number"!=typeof t[0])throw new TypeError("input must contain numbers");if(n&&t.length<n)throw new Error(`input must have a length of at least ${n}`)}function f(t,e,r={}){const{sorted:n=!0}=r;if(n){let r=0,n=t.length-1,o=0;for(;n-r>1;)if(o=r+(n-r>>1),t[o]<e)r=o;else{if(!(t[o]>e))return o;n=o}return r<t.length-1?Math.abs(e-t[r])<Math.abs(t[r+1]-e)?r:r+1:r}{let r=0,n=Number.POSITIVE_INFINITY;for(let o=0;o<t.length;o++){const s=Math.abs(t[o]-e);s<n&&(n=s,r=o)}return r}}function c(t,e={}){let{fromIndex:r,toIndex:n}=e;const{from:o,to:s}=e;return void 0===r&&(r=void 0!==o?f(t,o):0),void 0===n&&(n=void 0!==s?f(t,s):t.length-1),r<0&&(r=0),n<0&&(n=0),r>=t.length&&(r=t.length-1),n>=t.length&&(n=t.length-1),r>n&&([r,n]=[n,r]),{fromIndex:r,toIndex:n}}function g(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=0;for(let e=r;e<=n;e++)o+=Math.abs(t[e]);return o}function m(t,e){let n=!1,o=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else n=!0,o=e;const s=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)s[e]=t[e]+o;else for(let r=0;r<t.length;r++)s[r]=t[r]+e[r];return s}function w(t,e={}){const{variableLabel:r="x",fctString:n=r}=e,o=new Function(r,`return Number(${n.replaceAll(/(?<before>^|\W)(?<after>[\da-z]{2,}\()/g,"$<before>Math.$<after>").replaceAll("Math.Math","Math")})`),s=Float64Array.from(t);for(let e=0;e<t.length;e++)if(s[e]=o(t[e]),Number.isNaN(s[e]))throw new Error(`The callback ${n} does not return a number: ${t[e]}`);return s}function y(t,e,o={}){let s=!1,i=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else s=!0,i=e;const l=n(o.output,t.length);if(s)for(let e=0;e<t.length;e++)l[e]=t[e]*i;else for(let r=0;r<t.length;r++)l[r]=t[r]*e[r];return l}function p(t,e){const r=y(t,e);let n=0;for(let e=0;e<t.length;e++)n+=r[e];return n}function d(t,e,r={}){const{tau:n=1,lag:o=t.length-1}=r,s=new Float64Array(1+2*o/n);if(t.length===e.length){const r=e.length,i=new Float64Array(2*r),l=new Float64Array(2*r);for(let t=0;t<r;t++)l[r+t]=e[t];for(let e=2*r-(n-1);e>0;e-=n){let h=0;for(let t=e;t<2*r;t++)i[h]=l[t],h++;const a=[];for(let t=0;t<r;t++)a[t]=i[t];s[(h-(r-o))/n]=p(t,a)}}return s}function x(t,e={}){return d(t,t,e)}function b(t){if(u(t),(t=Float64Array.from(t)).sort(),t.at(-1)-t[0]<=Number.EPSILON){const e=String(t[0]).length<String(t.at(-1)).length?t[0]:t.at(-1);return{min:t[0],q1:e,median:e,q3:e,max:t.at(-1)}}const e=(t.length-1)/4,r=(t.length-1)*(3/4),n=(t.length-1)/2,o=e%1,s=r%1,i=n%1;return{min:t[0],q1:0===o?t[e]:t[e|0]*(1-o)+t[1+(e|0)]*o,median:0===i?t[n]:t[n|0]*(1-i)+t[1+(n|0)]*i,q3:0===s?t[r]:t[r|0]*(1-s)+t[1+(r|0)]*s,max:t.at(-1)}}function M(t){const e=b(t);if(e.max-e.min<=Number.EPSILON)return{...e,lowerWhisker:e.min,upperWhisker:e.max,minWhisker:e.min,maxWhisker:e.max,iqr:0,outliers:[]};const r=e.q3-e.q1,n=e.q1-1.5*r,o=e.q3+1.5*r,s=[];let i=e.median,l=e.median;for(const e of t)e<n||e>o?s.push(e):(e<i&&(i=e),e>l&&(l=e));return{...e,lowerWhisker:n,upperWhisker:o,minWhisker:i,maxWhisker:l,iqr:r,outliers:s}}function v(t,e){if(t.length!==e.length)throw new TypeError("length of array1 and array2 must be identical")}function A(t,e){const r=t.length;let n=0,o=0,s=0,i=0,l=0;for(let h=0;h<r;h++){const r=t[h],a=e[h];n+=r,o+=r**2,s+=a,i+=a**2,l+=r*a}return(r*l-n*s)/(Math.sqrt(r*o-n**2)*Math.sqrt(r*i-s**2))}function E(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function I(t){if(Object.prototype.hasOwnProperty.call(t,"__esModule"))return t;var e=t.default;if("function"==typeof e){var r=function t(){var r=!1;try{r=this instanceof t}catch{}return r?Reflect.construct(e,arguments,this.constructor):e.apply(this,arguments)};r.prototype=e.prototype}else r={};return Object.defineProperty(r,"__esModule",{value:!0}),Object.keys(t).forEach(function(e){var n=Object.getOwnPropertyDescriptor(t,e);Object.defineProperty(r,e,n.get?n:{enumerable:!0,get:function(){return t[e]}})}),r}var S={},N=I(Object.freeze({__proto__:null,isAnyArray:r}));var R=I(Object.freeze({__proto__:null,default:function(t){var e,n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==n.output){if(!r(n.output))throw new TypeError("output option must be an array if specified");e=n.output}else e=new Array(t.length);var o=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,o=void 0===n?0:n,s=e.toIndex,i=void 0===s?t.length:s;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var l=t[o],h=o+1;h<i;h++)t[h]<l&&(l=t[h]);return l}(t),s=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!r(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var n=e.fromIndex,o=void 0===n?0:n,s=e.toIndex,i=void 0===s?t.length:s;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var l=t[o],h=o+1;h<i;h++)t[h]>l&&(l=t[h]);return l}(t);if(o===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var i=n.min,l=void 0===i?n.autoMinMax?o:0:i,h=n.max,a=void 0===h?n.autoMinMax?s:1:h;if(l>=a)throw new RangeError("min option must be smaller than max option");for(var u=(a-l)/(s-o),f=0;f<t.length;f++)e[f]=(t[f]-o)*u+l;return e}}));Object.defineProperty(S,"__esModule",{value:!0});var F=N,T=R;const _=" ".repeat(2),k=" ".repeat(4);function C(t,e={}){const{maxRows:r=15,maxColumns:n=10,maxNumSize:o=8,padMinus:s="auto"}=e;return`${t.constructor.name} {\n${_}[\n${k}${function(t,e,r,n,o){const{rows:s,columns:i}=t,l=Math.min(s,e),h=Math.min(i,r),a=[];if("auto"===o){o=!1;t:for(let e=0;e<l;e++)for(let r=0;r<h;r++)if(t.get(e,r)<0){o=!0;break t}}for(let e=0;e<l;e++){let r=[];for(let s=0;s<h;s++)r.push(q(t.get(e,s),n,o));a.push(`${r.join(" ")}`)}h!==i&&(a[a.length-1]+=` ... ${i-r} more columns`);l!==s&&a.push(`... ${s-e} more rows`);return a.join(`\n${k}`)}(t,r,n,o,s)}\n${_}]\n${_}rows: ${t.rows}\n${_}columns: ${t.columns}\n}`}function q(t,e,r){return(t>=0&&r?` ${V(t,e-1)}`:V(t,e)).padEnd(e)}function V(t,e){let r=t.toString();if(r.length<=e)return r;let n=t.toFixed(e);if(n.length>e&&(n=t.toFixed(Math.max(0,e-(n.length-e)))),n.length<=e&&!n.startsWith("0.000")&&!n.startsWith("-0.000"))return n;let o=t.toExponential(e);return o.length>e&&(o=t.toExponential(Math.max(0,e-(o.length-e)))),o.slice(0)}function P(t,e,r){let n=r?t.rows:t.rows-1;if(e<0||e>n)throw new RangeError("Row index out of range")}function z(t,e,r){let n=r?t.columns:t.columns-1;if(e<0||e>n)throw new RangeError("Column index out of range")}function O(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function $(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function j(t,e){if(!F.isAnyArray(e))throw new TypeError("row indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.rows)throw new RangeError("row indices are out of range")}function D(t,e){if(!F.isAnyArray(e))throw new TypeError("column indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.columns)throw new RangeError("column indices are out of range")}function L(t,e,r,n,o){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(U("startRow",e),U("endRow",r),U("startColumn",n),U("endColumn",o),e>r||n>o||e<0||e>=t.rows||r<0||r>=t.rows||n<0||n>=t.columns||o<0||o>=t.columns)throw new RangeError("Submatrix indices are out of range")}function Y(t,e=0){let r=[];for(let n=0;n<t;n++)r.push(e);return r}function U(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function X(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}class W{static from1DArray(t,e,r){if(t*e!==r.length)throw new RangeError("data length does not match given dimensions");let n=new Q(t,e);for(let o=0;o<t;o++)for(let t=0;t<e;t++)n.set(o,t,r[o*e+t]);return n}static rowVector(t){let e=new Q(1,t.length);for(let r=0;r<t.length;r++)e.set(0,r,t[r]);return e}static columnVector(t){let e=new Q(t.length,1);for(let r=0;r<t.length;r++)e.set(r,0,t[r]);return e}static zeros(t,e){return new Q(t,e)}static ones(t,e){return new Q(t,e).fill(1)}static rand(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{random:n=Math.random}=r;let o=new Q(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++)o.set(r,t,n());return o}static randInt(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{min:n=0,max:o=1e3,random:s=Math.random}=r;if(!Number.isInteger(n))throw new TypeError("min must be an integer");if(!Number.isInteger(o))throw new TypeError("max must be an integer");if(n>=o)throw new RangeError("min must be smaller than max");let i=o-n,l=new Q(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++){let e=n+Math.round(s()*i);l.set(r,t,e)}return l}static eye(t,e,r){void 0===e&&(e=t),void 0===r&&(r=1);let n=Math.min(t,e),o=this.zeros(t,e);for(let t=0;t<n;t++)o.set(t,t,r);return o}static diag(t,e,r){let n=t.length;void 0===e&&(e=n),void 0===r&&(r=e);let o=Math.min(n,e,r),s=this.zeros(e,r);for(let e=0;e<o;e++)s.set(e,e,t[e]);return s}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,n=t.columns,o=new Q(r,n);for(let s=0;s<r;s++)for(let r=0;r<n;r++)o.set(s,r,Math.min(t.get(s,r),e.get(s,r)));return o}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,n=t.columns,o=new this(r,n);for(let s=0;s<r;s++)for(let r=0;r<n;r++)o.set(s,r,Math.max(t.get(s,r),e.get(s,r)));return o}static checkMatrix(t){return W.isMatrix(t)?t:new Q(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.call(this,e,r);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.push(this.get(e,r));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let r=0;r<this.columns;r++)t[e].push(this.get(e,r))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let t=0;t<this.rows;t++)if(0!==this.get(t,t))return!1;return!0}isEchelonForm(){let t=0,e=0,r=-1,n=!0,o=!1;for(;t<this.rows&&n;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(o=!0,r=e):(n=!1,o=!0);t++}return n}isReducedEchelonForm(){let t=0,e=0,r=-1,n=!0,o=!1;for(;t<this.rows&&n;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(o=!0,r=e):(n=!1,o=!0);for(let r=e+1;r<this.rows;r++)0!==this.get(t,r)&&(n=!1);t++}return n}echelonForm(){let t=this.clone(),e=0,r=0;for(;e<t.rows&&r<t.columns;){let n=e;for(let o=e;o<t.rows;o++)t.get(o,r)>t.get(n,r)&&(n=o);if(0===t.get(n,r))r++;else{t.swapRows(e,n);let o=t.get(e,r);for(let n=r;n<t.columns;n++)t.set(e,n,t.get(e,n)/o);for(let n=e+1;n<t.rows;n++){let o=t.get(n,r)/t.get(e,r);t.set(n,r,0);for(let s=r+1;s<t.columns;s++)t.set(n,s,t.get(n,s)-t.get(e,s)*o)}e++,r++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,r=t.rows,n=r-1;for(;n>=0;)if(0===t.maxRow(n))n--;else{let o=0,s=!1;for(;o<r&&!1===s;)1===t.get(n,o)?s=!0:o++;for(let r=0;r<n;r++){let s=t.get(r,o);for(let i=o;i<e;i++){let e=t.get(r,i)-s*t.get(n,i);t.set(r,i,e)}}n--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:r=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(r)||r<=0)throw new TypeError("columns must be a positive integer");let n=new Q(this.rows*e,this.columns*r);for(let t=0;t<e;t++)for(let e=0;e<r;e++)n.setSubMatrix(this,this.rows*t,this.columns*e);return n}fill(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,t);return this}neg(){return this.mulS(-1)}getRow(t){P(this,t);let e=[];for(let r=0;r<this.columns;r++)e.push(this.get(t,r));return e}getRowVector(t){return Q.rowVector(this.getRow(t))}setRow(t,e){P(this,t),e=O(this,e);for(let r=0;r<this.columns;r++)this.set(t,r,e[r]);return this}swapRows(t,e){P(this,t),P(this,e);for(let r=0;r<this.columns;r++){let n=this.get(t,r);this.set(t,r,this.get(e,r)),this.set(e,r,n)}return this}getColumn(t){z(this,t);let e=[];for(let r=0;r<this.rows;r++)e.push(this.get(r,t));return e}getColumnVector(t){return Q.columnVector(this.getColumn(t))}setColumn(t,e){z(this,t),e=$(this,e);for(let r=0;r<this.rows;r++)this.set(r,t,e[r]);return this}swapColumns(t,e){z(this,t),z(this,e);for(let r=0;r<this.rows;r++){let n=this.get(r,t);this.set(r,t,this.get(r,e)),this.set(r,e,n)}return this}addRowVector(t){t=O(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[r]);return this}subRowVector(t){t=O(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[r]);return this}mulRowVector(t){t=O(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[r]);return this}divRowVector(t){t=O(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[r]);return this}addColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[e]);return this}subColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[e]);return this}mulColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[e]);return this}divColumnVector(t){t=$(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[e]);return this}mulRow(t,e){P(this,t);for(let r=0;r<this.columns;r++)this.set(t,r,this.get(t,r)*e);return this}mulColumn(t,e){z(this,t);for(let r=0;r<this.rows;r++)this.set(r,t,this.get(r,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){X(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let n=0;n<this.columns;n++)this.get(r,n)>t&&(t=this.get(r,n),e[0]=r,e[1]=n);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){X(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let n=0;n<this.columns;n++)this.get(r,n)<t&&(t=this.get(r,n),e[0]=r,e[1]=n);return e}maxRow(t){if(P(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)>e&&(e=this.get(t,r));return e}maxRowIndex(t){P(this,t),X(this);let e=this.get(t,0),r=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)>e&&(e=this.get(t,n),r[1]=n);return r}minRow(t){if(P(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)<e&&(e=this.get(t,r));return e}minRowIndex(t){P(this,t),X(this);let e=this.get(t,0),r=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)<e&&(e=this.get(t,n),r[1]=n);return r}maxColumn(t){if(z(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)>e&&(e=this.get(r,t));return e}maxColumnIndex(t){z(this,t),X(this);let e=this.get(0,t),r=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)>e&&(e=this.get(n,t),r[0]=n);return r}minColumn(t){if(z(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)<e&&(e=this.get(r,t));return e}minColumnIndex(t){z(this,t),X(this);let e=this.get(0,t),r=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)<e&&(e=this.get(n,t),r[0]=n);return r}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let r=0;r<t;r++)e.push(this.get(r,r));return e}norm(t="frobenius"){switch(t){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${t}`)}}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t+=this.get(e,r),this.set(e,r,t);return this}dot(t){W.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let r=0;for(let n=0;n<e.length;n++)r+=e[n]*t[n];return r}mmul(t){t=Q.checkMatrix(t);let e=this.rows,r=this.columns,n=t.columns,o=new Q(e,n),s=new Float64Array(r);for(let i=0;i<n;i++){for(let e=0;e<r;e++)s[e]=t.get(e,i);for(let t=0;t<e;t++){let e=0;for(let n=0;n<r;n++)e+=this.get(t,n)*s[n];o.set(t,i,e)}}return o}mpow(t){if(!this.isSquare())throw new RangeError("Matrix must be square");if(!Number.isInteger(t)||t<0)throw new RangeError("Exponent must be a non-negative integer");let e=Q.eye(this.rows),r=this;for(let n=t;n>=1;n/=2)1&n&&(e=e.mmul(r)),r=r.mmul(r);return e}strassen2x2(t){t=Q.checkMatrix(t);let e=new Q(2,2);const r=this.get(0,0),n=t.get(0,0),o=this.get(0,1),s=t.get(0,1),i=this.get(1,0),l=t.get(1,0),h=this.get(1,1),a=t.get(1,1),u=(r+h)*(n+a),f=(i+h)*n,c=r*(s-a),g=h*(l-n),m=(r+o)*a,w=u+g-m+(o-h)*(l+a),y=c+m,p=f+g,d=u-f+c+(i-r)*(n+s);return e.set(0,0,w),e.set(0,1,y),e.set(1,0,p),e.set(1,1,d),e}strassen3x3(t){t=Q.checkMatrix(t);let e=new Q(3,3);const r=this.get(0,0),n=this.get(0,1),o=this.get(0,2),s=this.get(1,0),i=this.get(1,1),l=this.get(1,2),h=this.get(2,0),a=this.get(2,1),u=this.get(2,2),f=t.get(0,0),c=t.get(0,1),g=t.get(0,2),m=t.get(1,0),w=t.get(1,1),y=t.get(1,2),p=t.get(2,0),d=t.get(2,1),x=t.get(2,2),b=(r-s)*(-c+w),M=(-r+s+i)*(f-c+w),v=(s+i)*(-f+c),A=r*f,E=(-r+h+a)*(f-g+y),I=(-r+h)*(g-y),S=(h+a)*(-f+g),N=(-o+a+u)*(w+p-d),R=(o-u)*(w-d),F=o*p,T=(a+u)*(-p+d),_=(-o+i+l)*(y+p-x),k=(o-l)*(y-x),C=(i+l)*(-p+x),q=A+F+n*m,V=(r+n+o-s-i-a-u)*w+M+v+A+N+F+T,P=A+E+S+(r+n+o-i-l-h-a)*y+F+_+C,z=b+i*(-f+c+m-w-y-p+x)+M+A+F+_+k,O=b+M+v+A+l*d,$=F+_+k+C+s*g,j=A+E+I+a*(-f+g+m-w-y-p+d)+N+R+F,D=N+R+F+T+h*c,L=A+E+I+S+u*x;return e.set(0,0,q),e.set(0,1,V),e.set(0,2,P),e.set(1,0,z),e.set(1,1,O),e.set(1,2,$),e.set(2,0,j),e.set(2,1,D),e.set(2,2,L),e}mmulStrassen(t){t=Q.checkMatrix(t);let e=this.clone(),r=e.rows,n=e.columns,o=t.rows,s=t.columns;function i(t,e,r){let n=t.rows,o=t.columns;if(n===e&&o===r)return t;{let n=W.zeros(e,r);return n=n.setSubMatrix(t,0,0),n}}n!==o&&console.warn(`Multiplying ${r} x ${n} and ${o} x ${s} matrix: dimensions do not match.`);let l=Math.max(r,o),h=Math.max(n,s);return e=i(e,l,h),function t(e,r,n,o){if(n<=512||o<=512)return e.mmul(r);n%2==1&&o%2==1?(e=i(e,n+1,o+1),r=i(r,n+1,o+1)):n%2==1?(e=i(e,n+1,o),r=i(r,n+1,o)):o%2==1&&(e=i(e,n,o+1),r=i(r,n,o+1));let s=parseInt(e.rows/2,10),l=parseInt(e.columns/2,10),h=e.subMatrix(0,s-1,0,l-1),a=r.subMatrix(0,s-1,0,l-1),u=e.subMatrix(0,s-1,l,e.columns-1),f=r.subMatrix(0,s-1,l,r.columns-1),c=e.subMatrix(s,e.rows-1,0,l-1),g=r.subMatrix(s,r.rows-1,0,l-1),m=e.subMatrix(s,e.rows-1,l,e.columns-1),w=r.subMatrix(s,r.rows-1,l,r.columns-1),y=t(W.add(h,m),W.add(a,w),s,l),p=t(W.add(c,m),a,s,l),d=t(h,W.sub(f,w),s,l),x=t(m,W.sub(g,a),s,l),b=t(W.add(h,u),w,s,l),M=t(W.sub(c,h),W.add(a,f),s,l),v=t(W.sub(u,m),W.add(g,w),s,l),A=W.add(y,x);A.sub(b),A.add(v);let E=W.add(d,b),I=W.add(p,x),S=W.sub(y,p);S.add(d),S.add(M);let N=W.zeros(2*A.rows,2*A.columns);return N=N.setSubMatrix(A,0,0),N=N.setSubMatrix(E,A.rows,0),N=N.setSubMatrix(I,0,A.columns),N=N.setSubMatrix(S,A.rows,A.columns),N.subMatrix(0,n-1,0,o-1)}(e,t=i(t,l,h),l,h)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let n=new Q(this.rows,this.columns);for(let t=0;t<this.rows;t++){const o=this.getRow(t);o.length>0&&T(o,{min:e,max:r,output:o}),n.setRow(t,o)}return n}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let n=new Q(this.rows,this.columns);for(let t=0;t<this.columns;t++){const o=this.getColumn(t);o.length&&T(o,{min:e,max:r,output:o}),n.setColumn(t,o)}return n}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let r=0;r<t;r++){let t=this.get(e,r),n=this.get(e,this.columns-1-r);this.set(e,r,n),this.set(e,this.columns-1-r,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let r=0;r<t;r++){let t=this.get(r,e),n=this.get(this.rows-1-r,e);this.set(r,e,n),this.set(this.rows-1-r,e,t)}return this}kroneckerProduct(t){t=Q.checkMatrix(t);let e=this.rows,r=this.columns,n=t.rows,o=t.columns,s=new Q(e*n,r*o);for(let i=0;i<e;i++)for(let e=0;e<r;e++)for(let r=0;r<n;r++)for(let l=0;l<o;l++)s.set(n*i+r,o*e+l,this.get(i,e)*t.get(r,l));return s}kroneckerSum(t){if(t=Q.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,r=t.rows,n=this.kroneckerProduct(Q.eye(r,r)),o=Q.eye(e,e).kroneckerProduct(t);return n.add(o)}transpose(){let t=new Q(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.set(r,e,this.get(e,r));return t}sortRows(t=G){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=G){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,r,n){L(this,t,e,r,n);let o=new Q(e-t+1,n-r+1);for(let s=t;s<=e;s++)for(let e=r;e<=n;e++)o.set(s-t,e-r,this.get(s,e));return o}subMatrixRow(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.columns-1),e>r||e<0||e>=this.columns||r<0||r>=this.columns)throw new RangeError("Argument out of range");let n=new Q(t.length,r-e+1);for(let o=0;o<t.length;o++)for(let s=e;s<=r;s++){if(t[o]<0||t[o]>=this.rows)throw new RangeError(`Row index out of range: ${t[o]}`);n.set(o,s-e,this.get(t[o],s))}return n}subMatrixColumn(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.rows-1),e>r||e<0||e>=this.rows||r<0||r>=this.rows)throw new RangeError("Argument out of range");let n=new Q(r-e+1,t.length);for(let o=0;o<t.length;o++)for(let s=e;s<=r;s++){if(t[o]<0||t[o]>=this.columns)throw new RangeError(`Column index out of range: ${t[o]}`);n.set(s-e,o,this.get(s,t[o]))}return n}setSubMatrix(t,e,r){if((t=Q.checkMatrix(t)).isEmpty())return this;L(this,e,e+t.rows-1,r,r+t.columns-1);for(let n=0;n<t.rows;n++)for(let o=0;o<t.columns;o++)this.set(e+n,r+o,t.get(n,o));return this}selection(t,e){j(this,t),D(this,e);let r=new Q(t.length,e.length);for(let n=0;n<t.length;n++){let o=t[n];for(let t=0;t<e.length;t++){let s=e[t];r.set(n,t,this.get(o,s))}}return r}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let r=0;r<t;r++)e+=this.get(r,r);return e}clone(){return this.constructor.copy(this,new Q(this.rows,this.columns))}static copy(t,e){for(const[r,n,o]of t.entries())e.set(r,n,o);return e}sum(t){switch(t){case"row":return function(t){let e=Y(t.rows);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[r]+=t.get(r,n);return e}(this);case"column":return function(t){let e=Y(t.columns);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[n]+=t.get(r,n);return e}(this);case void 0:return function(t){let e=0;for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)e+=t.get(r,n);return e}(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return function(t){let e=Y(t.rows,1);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[r]*=t.get(r,n);return e}(this);case"column":return function(t){let e=Y(t.columns,1);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[n]*=t.get(r,n);return e}(this);case void 0:return function(t){let e=1;for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)e*=t.get(r,n);return e}(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:r=!0,mean:n=this.mean(t)}=e;if("boolean"!=typeof r)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!F.isAnyArray(n))throw new TypeError("mean must be an array");return function(t,e,r){const n=t.rows,o=t.columns,s=[];for(let i=0;i<n;i++){let n=0,l=0,h=0;for(let e=0;e<o;e++)h=t.get(i,e)-r[i],n+=h,l+=h*h;e?s.push((l-n*n/o)/(o-1)):s.push((l-n*n/o)/o)}return s}(this,r,n);case"column":if(!F.isAnyArray(n))throw new TypeError("mean must be an array");return function(t,e,r){const n=t.rows,o=t.columns,s=[];for(let i=0;i<o;i++){let o=0,l=0,h=0;for(let e=0;e<n;e++)h=t.get(e,i)-r[i],o+=h,l+=h*h;e?s.push((l-o*o/n)/(n-1)):s.push((l-o*o/n)/n)}return s}(this,r,n);case void 0:if("number"!=typeof n)throw new TypeError("mean must be a number");return function(t,e,r){const n=t.rows,o=t.columns,s=n*o;let i=0,l=0,h=0;for(let e=0;e<n;e++)for(let n=0;n<o;n++)h=t.get(e,n)-r,i+=h,l+=h*h;return e?(l-i*i/s)/(s-1):(l-i*i/s)/s}(this,r,n);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const r=this.variance(t,e);if(void 0===t)return Math.sqrt(r);for(let t=0;t<r.length;t++)r[t]=Math.sqrt(r[t]);return r}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:r=this.mean(t)}=e;switch(t){case"row":if(!F.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e[r])}(this,r),this;case"column":if(!F.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e[n])}(this,r),this;case void 0:if("number"!=typeof r)throw new TypeError("center must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let r=e.scale;switch(t){case"row":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.rows;r++){let n=0;for(let e=0;e<t.columns;e++)n+=t.get(r,e)**2/(t.columns-1);e.push(Math.sqrt(n))}return e}(this);else if(!F.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e[r])}(this,r),this;case"column":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.columns;r++){let n=0;for(let e=0;e<t.rows;e++)n+=t.get(e,r)**2/(t.rows-1);e.push(Math.sqrt(n))}return e}(this);else if(!F.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e[n])}(this,r),this;case void 0:if(void 0===r)r=function(t){const e=t.size-1;let r=0;for(let n=0;n<t.columns;n++)for(let o=0;o<t.rows;o++)r+=t.get(o,n)**2/e;return Math.sqrt(r)}(this);else if("number"!=typeof r)throw new TypeError("scale must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return C(this,t)}[Symbol.iterator](){return this.entries()}*entries(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield[t,e,this.get(t,e)]}*values(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield this.get(t,e)}}function G(t,e){return t-e}function B(t){return t.every(t=>"number"==typeof t)}W.prototype.klass="Matrix","undefined"!=typeof Symbol&&(W.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return C(this)}),W.random=W.rand,W.randomInt=W.randInt,W.diagonal=W.diag,W.prototype.diagonal=W.prototype.diag,W.identity=W.eye,W.prototype.negate=W.prototype.neg,W.prototype.tensorProduct=W.prototype.kroneckerProduct;let Q=class t extends W{data;#t(t,e){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let r=0;r<t;r++)this.data.push(new Float64Array(e));this.rows=t,this.columns=e}constructor(e,r){if(super(),t.isMatrix(e))this.#t(e.rows,e.columns),t.copy(e,this);else if(Number.isInteger(e)&&e>=0)this.#t(e,r);else{if(!F.isAnyArray(e))throw new TypeError("First argument must be a positive number or an array");{const t=e;if("number"!=typeof(r=(e=t.length)?t[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let n=0;n<e;n++){if(t[n].length!==r)throw new RangeError("Inconsistent array dimensions");if(!B(t[n]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(t[n]))}this.rows=e,this.columns=r}}}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}removeRow(t){return P(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),P(this,t,!0),e=Float64Array.from(O(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){z(this,t);for(let e=0;e<this.rows;e++){const r=new Float64Array(this.columns-1);for(let n=0;n<t;n++)r[n]=this.data[e][n];for(let n=t+1;n<this.columns;n++)r[n-1]=this.data[e][n];this.data[e]=r}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),z(this,t,!0),e=$(this,e);for(let r=0;r<this.rows;r++){const n=new Float64Array(this.columns+1);let o=0;for(;o<t;o++)n[o]=this.data[r][o];for(n[o++]=e[r];o<this.columns+1;o++)n[o]=this.data[r][o-1];this.data[r]=n}return this.columns+=1,this}};!function(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t.get(e,r));return this},t.add=function(t,r){return new e(t).add(r)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t.get(e,r));return this},t.sub=function(t,r){return new e(t).sub(r)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t.get(e,r));return this},t.mul=function(t,r){return new e(t).mul(r)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t.get(e,r));return this},t.div=function(t,r){return new e(t).div(r)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t.get(e,r));return this},t.mod=function(t,r){return new e(t).mod(r)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t.get(e,r));return this},t.and=function(t,r){return new e(t).and(r)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t.get(e,r));return this},t.or=function(t,r){return new e(t).or(r)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t.get(e,r));return this},t.xor=function(t,r){return new e(t).xor(r)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t.get(e,r));return this},t.leftShift=function(t,r){return new e(t).leftShift(r)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t.get(e,r));return this},t.signPropagatingRightShift=function(t,r){return new e(t).signPropagatingRightShift(r)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t.get(e,r));return this},t.rightShift=function(t,r){return new e(t).rightShift(r)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,r){return new e(t).pow(r)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t);return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t.get(e,r));return this}}(W,Q);class J extends W{#e;get size(){return this.#e.size}get rows(){return this.#e.rows}get columns(){return this.#e.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(t){return Q.isMatrix(t)&&"SymmetricMatrix"===t.klassType}static zeros(t){return new this(t)}static ones(t){return new this(t).fill(1)}constructor(t){if(super(),Q.isMatrix(t)){if(!t.isSymmetric())throw new TypeError("not symmetric data");this.#e=Q.copy(t,new Q(t.rows,t.rows))}else if(Number.isInteger(t)&&t>=0)this.#e=new Q(t,t);else if(this.#e=new Q(t),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const t=new J(this.diagonalSize);for(const[e,r,n]of this.upperRightEntries())t.set(e,r,n);return t}toMatrix(){return new Q(this)}get(t,e){return this.#e.get(t,e)}set(t,e,r){return this.#e.set(t,e,r),this.#e.set(e,t,r),this}removeCross(t){return this.#e.removeRow(t),this.#e.removeColumn(t),this}addCross(t,e){void 0===e&&(e=t,t=this.diagonalSize);const r=e.slice();return r.splice(t,1),this.#e.addRow(t,r),this.#e.addColumn(t,e),this}applyMask(t){if(t.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const e=[];for(const[r,n]of t.entries())n||e.push(r);e.reverse();for(const t of e)this.removeCross(t);return this}toCompact(){const{diagonalSize:t}=this,e=new Array(t*(t+1)/2);for(let r=0,n=0,o=0;o<e.length;o++)e[o]=this.get(n,r),++r>=t&&(r=++n);return e}static fromCompact(t){const e=t.length,r=(Math.sqrt(8*e+1)-1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(t)}`);const n=new J(r);for(let o=0,s=0,i=0;i<e;i++)n.set(o,s,t[i]),++o>=r&&(o=++s);return n}*upperRightEntries(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield[t,e,r],++e>=this.diagonalSize&&(e=++t)}}*upperRightValues(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield r,++e>=this.diagonalSize&&(e=++t)}}}J.prototype.klassType="SymmetricMatrix";class H extends J{static isDistanceMatrix(t){return J.isSymmetricMatrix(t)&&"DistanceMatrix"===t.klassSubType}constructor(t){if(super(t),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(t,e,r){return t===e&&(r=0),super.set(t,e,r)}addCross(t,e){return void 0===e&&(e=t,t=this.diagonalSize),(e=e.slice())[t]=0,super.addCross(t,e)}toSymmetricMatrix(){return new J(this)}clone(){const t=new H(this.diagonalSize);for(const[e,r,n]of this.upperRightEntries())e!==r&&t.set(e,r,n);return t}toCompact(){const{diagonalSize:t}=this,e=new Array((t-1)*t/2);for(let r=1,n=0,o=0;o<e.length;o++)e[o]=this.get(n,r),++r>=t&&(r=1+ ++n);return e}static fromCompact(t){const e=t.length;if(0===e)return new this(0);const r=(Math.sqrt(8*e+1)+1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(t)}`);const n=new this(r);for(let o=1,s=0,i=0;i<e;i++)n.set(o,s,t[i]),++o>=r&&(o=1+ ++s);return n}}H.prototype.klassSubType="DistanceMatrix";class Z extends W{constructor(t,e,r){super(),this.matrix=t,this.rows=e,this.columns=r}}class K extends Z{constructor(t,e,r){j(t,e),D(t,r),super(t,e.length,r.length),this.rowIndices=e,this.columnIndices=r}set(t,e,r){return this.matrix.set(this.rowIndices[t],this.columnIndices[e],r),this}get(t,e){return this.matrix.get(this.rowIndices[t],this.columnIndices[e])}}class tt extends W{constructor(t,e={}){const{rows:r=1}=e;if(t.length%r!==0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=r,this.columns=t.length/r,this.data=t}set(t,e,r){let n=this._calculateIndex(t,e);return this.data[n]=r,this}get(t,e){let r=this._calculateIndex(t,e);return this.data[r]}_calculateIndex(t,e){return t*this.columns+e}}class et extends W{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}}class rt{constructor(t){let e,r,n,o,s,i,l,h,a,u=(t=et.checkMatrix(t)).clone(),f=u.rows,c=u.columns,g=new Float64Array(f),m=1;for(e=0;e<f;e++)g[e]=e;for(h=new Float64Array(f),r=0;r<c;r++){for(e=0;e<f;e++)h[e]=u.get(e,r);for(e=0;e<f;e++){for(a=Math.min(e,r),s=0,n=0;n<a;n++)s+=u.get(e,n)*h[n];h[e]-=s,u.set(e,r,h[e])}for(o=r,e=r+1;e<f;e++)Math.abs(h[e])>Math.abs(h[o])&&(o=e);if(o!==r){for(n=0;n<c;n++)i=u.get(o,n),u.set(o,n,u.get(r,n)),u.set(r,n,i);l=g[o],g[o]=g[r],g[r]=l,m=-m}if(r<f&&0!==u.get(r,r))for(e=r+1;e<f;e++)u.set(e,r,u.get(e,r)/u.get(r,r))}this.LU=u,this.pivotVector=g,this.pivotSign=m}isSingular(){let t=this.LU,e=t.columns;for(let r=0;r<e;r++)if(0===t.get(r,r))return!0;return!1}solve(t){t=Q.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let r,n,o,s=t.columns,i=t.subMatrixRow(this.pivotVector,0,s-1),l=e.columns;for(o=0;o<l;o++)for(r=o+1;r<l;r++)for(n=0;n<s;n++)i.set(r,n,i.get(r,n)-i.get(o,n)*e.get(r,o));for(o=l-1;o>=0;o--){for(n=0;n<s;n++)i.set(o,n,i.get(o,n)/e.get(o,o));for(r=0;r<o;r++)for(n=0;n<s;n++)i.set(r,n,i.get(r,n)-i.get(o,n)*e.get(r,o))}return i}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,r=t.columns;for(let n=0;n<r;n++)e*=t.get(n,n);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,n=new Q(e,r);for(let o=0;o<e;o++)for(let e=0;e<r;e++)o>e?n.set(o,e,t.get(o,e)):o===e?n.set(o,e,1):n.set(o,e,0);return n}get upperTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,n=new Q(e,r);for(let o=0;o<e;o++)for(let e=0;e<r;e++)o<=e?n.set(o,e,t.get(o,e)):n.set(o,e,0);return n}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function nt(t,e){let r=0;return Math.abs(t)>Math.abs(e)?(r=e/t,Math.abs(t)*Math.sqrt(1+r*r)):0!==e?(r=t/e,Math.abs(e)*Math.sqrt(1+r*r)):0}class ot{constructor(t){let e,r,n,o,s=(t=et.checkMatrix(t)).clone(),i=t.rows,l=t.columns,h=new Float64Array(l);for(n=0;n<l;n++){let t=0;for(e=n;e<i;e++)t=nt(t,s.get(e,n));if(0!==t){for(s.get(n,n)<0&&(t=-t),e=n;e<i;e++)s.set(e,n,s.get(e,n)/t);for(s.set(n,n,s.get(n,n)+1),r=n+1;r<l;r++){for(o=0,e=n;e<i;e++)o+=s.get(e,n)*s.get(e,r);for(o=-o/s.get(n,n),e=n;e<i;e++)s.set(e,r,s.get(e,r)+o*s.get(e,n))}}h[n]=-t}this.QR=s,this.Rdiag=h}solve(t){t=Q.checkMatrix(t);let e=this.QR,r=e.rows;if(t.rows!==r)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let n,o,s,i,l=t.columns,h=t.clone(),a=e.columns;for(s=0;s<a;s++)for(o=0;o<l;o++){for(i=0,n=s;n<r;n++)i+=e.get(n,s)*h.get(n,o);for(i=-i/e.get(s,s),n=s;n<r;n++)h.set(n,o,h.get(n,o)+i*e.get(n,s))}for(s=a-1;s>=0;s--){for(o=0;o<l;o++)h.set(s,o,h.get(s,o)/this.Rdiag[s]);for(n=0;n<s;n++)for(o=0;o<l;o++)h.set(n,o,h.get(n,o)-h.get(s,o)*e.get(n,s))}return h.subMatrix(0,a-1,0,l-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,r=this.QR,n=r.columns,o=new Q(n,n);for(t=0;t<n;t++)for(e=0;e<n;e++)t<e?o.set(t,e,r.get(t,e)):t===e?o.set(t,e,this.Rdiag[t]):o.set(t,e,0);return o}get orthogonalMatrix(){let t,e,r,n,o=this.QR,s=o.rows,i=o.columns,l=new Q(s,i);for(r=i-1;r>=0;r--){for(t=0;t<s;t++)l.set(t,r,0);for(l.set(r,r,1),e=r;e<i;e++)if(0!==o.get(r,r)){for(n=0,t=r;t<s;t++)n+=o.get(t,r)*l.get(t,e);for(n=-n/o.get(r,r),t=r;t<s;t++)l.set(t,e,l.get(t,e)+n*o.get(t,r))}}return l}}class st{constructor(t,e={}){if((t=et.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let r=t.rows,n=t.columns;const{computeLeftSingularVectors:o=!0,computeRightSingularVectors:s=!0,autoTranspose:i=!1}=e;let l,h=Boolean(o),a=Boolean(s),u=!1;if(r<n)if(i){l=t.transpose(),r=l.rows,n=l.columns,u=!0;let e=h;h=a,a=e}else l=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else l=t.clone();let f=Math.min(r,n),c=Math.min(r+1,n),g=new Float64Array(c),m=new Q(r,f),w=new Q(n,n),y=new Float64Array(n),p=new Float64Array(r),d=new Float64Array(c);for(let t=0;t<c;t++)d[t]=t;let x=Math.min(r-1,n),b=Math.max(0,Math.min(n-2,r)),M=Math.max(x,b);for(let t=0;t<M;t++){if(t<x){g[t]=0;for(let e=t;e<r;e++)g[t]=nt(g[t],l.get(e,t));if(0!==g[t]){l.get(t,t)<0&&(g[t]=-g[t]);for(let e=t;e<r;e++)l.set(e,t,l.get(e,t)/g[t]);l.set(t,t,l.get(t,t)+1)}g[t]=-g[t]}for(let e=t+1;e<n;e++){if(t<x&&0!==g[t]){let n=0;for(let o=t;o<r;o++)n+=l.get(o,t)*l.get(o,e);n=-n/l.get(t,t);for(let o=t;o<r;o++)l.set(o,e,l.get(o,e)+n*l.get(o,t))}y[e]=l.get(t,e)}if(h&&t<x)for(let e=t;e<r;e++)m.set(e,t,l.get(e,t));if(t<b){y[t]=0;for(let e=t+1;e<n;e++)y[t]=nt(y[t],y[e]);if(0!==y[t]){y[t+1]<0&&(y[t]=0-y[t]);for(let e=t+1;e<n;e++)y[e]/=y[t];y[t+1]+=1}if(y[t]=-y[t],t+1<r&&0!==y[t]){for(let e=t+1;e<r;e++)p[e]=0;for(let e=t+1;e<r;e++)for(let r=t+1;r<n;r++)p[e]+=y[r]*l.get(e,r);for(let e=t+1;e<n;e++){let n=-y[e]/y[t+1];for(let o=t+1;o<r;o++)l.set(o,e,l.get(o,e)+n*p[o])}}if(a)for(let e=t+1;e<n;e++)w.set(e,t,y[e])}}let v=Math.min(n,r+1);if(x<n&&(g[x]=l.get(x,x)),r<v&&(g[v-1]=0),b+1<v&&(y[b]=l.get(b,v-1)),y[v-1]=0,h){for(let t=x;t<f;t++){for(let e=0;e<r;e++)m.set(e,t,0);m.set(t,t,1)}for(let t=x-1;t>=0;t--)if(0!==g[t]){for(let e=t+1;e<f;e++){let n=0;for(let o=t;o<r;o++)n+=m.get(o,t)*m.get(o,e);n=-n/m.get(t,t);for(let o=t;o<r;o++)m.set(o,e,m.get(o,e)+n*m.get(o,t))}for(let e=t;e<r;e++)m.set(e,t,-m.get(e,t));m.set(t,t,1+m.get(t,t));for(let e=0;e<t-1;e++)m.set(e,t,0)}else{for(let e=0;e<r;e++)m.set(e,t,0);m.set(t,t,1)}}if(a)for(let t=n-1;t>=0;t--){if(t<b&&0!==y[t])for(let e=t+1;e<n;e++){let r=0;for(let o=t+1;o<n;o++)r+=w.get(o,t)*w.get(o,e);r=-r/w.get(t+1,t);for(let o=t+1;o<n;o++)w.set(o,e,w.get(o,e)+r*w.get(o,t))}for(let e=0;e<n;e++)w.set(e,t,0);w.set(t,t,1)}let A=v-1,E=Number.EPSILON;for(;v>0;){let t,e;for(t=v-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+E*Math.abs(g[t]+Math.abs(g[t+1]));if(Math.abs(y[t])<=e||Number.isNaN(y[t])){y[t]=0;break}}if(t===v-2)e=4;else{let r;for(r=v-1;r>=t&&r!==t;r--){let e=(r!==v?Math.abs(y[r]):0)+(r!==t+1?Math.abs(y[r-1]):0);if(Math.abs(g[r])<=E*e){g[r]=0;break}}r===t?e=3:r===v-1?e=1:(e=2,t=r)}switch(t++,e){case 1:{let e=y[v-2];y[v-2]=0;for(let r=v-2;r>=t;r--){let o=nt(g[r],e),s=g[r]/o,i=e/o;if(g[r]=o,r!==t&&(e=-i*y[r-1],y[r-1]=s*y[r-1]),a)for(let t=0;t<n;t++)o=s*w.get(t,r)+i*w.get(t,v-1),w.set(t,v-1,-i*w.get(t,r)+s*w.get(t,v-1)),w.set(t,r,o)}break}case 2:{let e=y[t-1];y[t-1]=0;for(let n=t;n<v;n++){let o=nt(g[n],e),s=g[n]/o,i=e/o;if(g[n]=o,e=-i*y[n],y[n]=s*y[n],h)for(let e=0;e<r;e++)o=s*m.get(e,n)+i*m.get(e,t-1),m.set(e,t-1,-i*m.get(e,n)+s*m.get(e,t-1)),m.set(e,n,o)}break}case 3:{const e=Math.max(Math.abs(g[v-1]),Math.abs(g[v-2]),Math.abs(y[v-2]),Math.abs(g[t]),Math.abs(y[t])),o=g[v-1]/e,s=g[v-2]/e,i=y[v-2]/e,l=g[t]/e,u=y[t]/e,f=((s+o)*(s-o)+i*i)/2,c=o*i*(o*i);let p=0;0===f&&0===c||(p=f<0?0-Math.sqrt(f*f+c):Math.sqrt(f*f+c),p=c/(f+p));let d=(l+o)*(l-o)+p,x=l*u;for(let e=t;e<v-1;e++){let o=nt(d,x);0===o&&(o=Number.MIN_VALUE);let s=d/o,i=x/o;if(e!==t&&(y[e-1]=o),d=s*g[e]+i*y[e],y[e]=s*y[e]-i*g[e],x=i*g[e+1],g[e+1]=s*g[e+1],a)for(let t=0;t<n;t++)o=s*w.get(t,e)+i*w.get(t,e+1),w.set(t,e+1,-i*w.get(t,e)+s*w.get(t,e+1)),w.set(t,e,o);if(o=nt(d,x),0===o&&(o=Number.MIN_VALUE),s=d/o,i=x/o,g[e]=o,d=s*y[e]+i*g[e+1],g[e+1]=-i*y[e]+s*g[e+1],x=i*y[e+1],y[e+1]=s*y[e+1],h&&e<r-1)for(let t=0;t<r;t++)o=s*m.get(t,e)+i*m.get(t,e+1),m.set(t,e+1,-i*m.get(t,e)+s*m.get(t,e+1)),m.set(t,e,o)}y[v-2]=d;break}case 4:if(g[t]<=0&&(g[t]=g[t]<0?-g[t]:0,a))for(let e=0;e<=A;e++)w.set(e,t,-w.get(e,t));for(;t<A&&!(g[t]>=g[t+1]);){let e=g[t];if(g[t]=g[t+1],g[t+1]=e,a&&t<n-1)for(let r=0;r<n;r++)e=w.get(r,t+1),w.set(r,t+1,w.get(r,t)),w.set(r,t,e);if(h&&t<r-1)for(let n=0;n<r;n++)e=m.get(n,t+1),m.set(n,t+1,m.get(n,t)),m.set(n,t,e);t++}v--}}if(u){let t=w;w=m,m=t}this.m=r,this.n=n,this.s=g,this.U=m,this.V=w}solve(t){let e=t,r=this.threshold,n=this.s.length,o=Q.zeros(n,n);for(let t=0;t<n;t++)Math.abs(this.s[t])<=r?o.set(t,t,0):o.set(t,t,1/this.s[t]);let s=this.U,i=this.rightSingularVectors,l=i.mmul(o),h=i.rows,a=s.rows,u=Q.zeros(h,a);for(let t=0;t<h;t++)for(let e=0;e<a;e++){let r=0;for(let o=0;o<n;o++)r+=l.get(t,o)*s.get(e,o);u.set(t,e,r)}return u.mmul(e)}solveForDiagonal(t){return this.solve(Q.diag(t))}inverse(){let t=this.V,e=this.threshold,r=t.rows,n=t.columns,o=new Q(r,this.s.length);for(let s=0;s<r;s++)for(let r=0;r<n;r++)Math.abs(this.s[r])>e&&o.set(s,r,t.get(s,r)/this.s[r]);let s=this.U,i=s.rows,l=s.columns,h=new Q(r,i);for(let t=0;t<r;t++)for(let e=0;e<i;e++){let r=0;for(let n=0;n<l;n++)r+=o.get(t,n)*s.get(e,n);h.set(t,e,r)}return h}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,r=this.s;for(let n=0,o=r.length;n<o;n++)r[n]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Q.diag(this.s)}}function it(t,e,r=!1){return t=et.checkMatrix(t),e=et.checkMatrix(e),r?new st(t).solve(e):t.isSquare()?new rt(t).solve(e):new ot(t).solve(e)}function lt(t,e){let r=[];for(let n=0;n<t;n++)n!==e&&r.push(n);return r}function ht(t,e,r,n=1e-9,o=1e-9){if(t>o)return new Array(e.rows+1).fill(0);{let t=e.addRow(r,[0]);for(let e=0;e<t.rows;e++)Math.abs(t.get(e,0))<n&&t.set(e,0,0);return t.to1DArray()}}class at{constructor(t,e={}){const{assumeSymmetric:r=!1}=e;if(!(t=et.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let n,o,s=t.columns,i=new Q(s,s),l=new Float64Array(s),h=new Float64Array(s),a=t,u=!1;if(u=!!r||t.isSymmetric(),u){for(n=0;n<s;n++)for(o=0;o<s;o++)i.set(n,o,a.get(n,o));!function(t,e,r,n){let o,s,i,l,h,a,u,f;for(h=0;h<t;h++)r[h]=n.get(t-1,h);for(l=t-1;l>0;l--){for(f=0,i=0,a=0;a<l;a++)f+=Math.abs(r[a]);if(0===f)for(e[l]=r[l-1],h=0;h<l;h++)r[h]=n.get(l-1,h),n.set(l,h,0),n.set(h,l,0);else{for(a=0;a<l;a++)r[a]/=f,i+=r[a]*r[a];for(o=r[l-1],s=Math.sqrt(i),o>0&&(s=-s),e[l]=f*s,i-=o*s,r[l-1]=o-s,h=0;h<l;h++)e[h]=0;for(h=0;h<l;h++){for(o=r[h],n.set(h,l,o),s=e[h]+n.get(h,h)*o,a=h+1;a<=l-1;a++)s+=n.get(a,h)*r[a],e[a]+=n.get(a,h)*o;e[h]=s}for(o=0,h=0;h<l;h++)e[h]/=i,o+=e[h]*r[h];for(u=o/(i+i),h=0;h<l;h++)e[h]-=u*r[h];for(h=0;h<l;h++){for(o=r[h],s=e[h],a=h;a<=l-1;a++)n.set(a,h,n.get(a,h)-(o*e[a]+s*r[a]));r[h]=n.get(l-1,h),n.set(l,h,0)}}r[l]=i}for(l=0;l<t-1;l++){if(n.set(t-1,l,n.get(l,l)),n.set(l,l,1),i=r[l+1],0!==i){for(a=0;a<=l;a++)r[a]=n.get(a,l+1)/i;for(h=0;h<=l;h++){for(s=0,a=0;a<=l;a++)s+=n.get(a,l+1)*n.get(a,h);for(a=0;a<=l;a++)n.set(a,h,n.get(a,h)-s*r[a])}}for(a=0;a<=l;a++)n.set(a,l+1,0)}for(h=0;h<t;h++)r[h]=n.get(t-1,h),n.set(t-1,h,0);n.set(t-1,t-1,1),e[0]=0}(s,h,l,i),function(t,e,r,n){let o,s,i,l,h,a,u,f,c,g,m,w,y,p,d,x;for(i=1;i<t;i++)e[i-1]=e[i];e[t-1]=0;let b=0,M=0,v=Number.EPSILON;for(a=0;a<t;a++){for(M=Math.max(M,Math.abs(r[a])+Math.abs(e[a])),u=a;u<t&&!(Math.abs(e[u])<=v*M);)u++;if(u>a)do{for(o=r[a],f=(r[a+1]-o)/(2*e[a]),c=nt(f,1),f<0&&(c=-c),r[a]=e[a]/(f+c),r[a+1]=e[a]*(f+c),g=r[a+1],s=o-r[a],i=a+2;i<t;i++)r[i]-=s;for(b+=s,f=r[u],m=1,w=m,y=m,p=e[a+1],d=0,x=0,i=u-1;i>=a;i--)for(y=w,w=m,x=d,o=m*e[i],s=m*f,c=nt(f,e[i]),e[i+1]=d*c,d=e[i]/c,m=f/c,f=m*r[i]-d*o,r[i+1]=s+d*(m*o+d*r[i]),h=0;h<t;h++)s=n.get(h,i+1),n.set(h,i+1,d*n.get(h,i)+m*s),n.set(h,i,m*n.get(h,i)-d*s);f=-d*x*y*p*e[a]/g,e[a]=d*f,r[a]=m*f}while(Math.abs(e[a])>v*M);r[a]=r[a]+b,e[a]=0}for(i=0;i<t-1;i++){for(h=i,f=r[i],l=i+1;l<t;l++)r[l]<f&&(h=l,f=r[l]);if(h!==i)for(r[h]=r[i],r[i]=f,l=0;l<t;l++)f=n.get(l,i),n.set(l,i,n.get(l,h)),n.set(l,h,f)}}(s,h,l,i)}else{let t=new Q(s,s),e=new Float64Array(s);for(o=0;o<s;o++)for(n=0;n<s;n++)t.set(n,o,a.get(n,o));!function(t,e,r,n){let o,s,i,l,h,a,u,f=0,c=t-1;for(a=f+1;a<=c-1;a++){for(u=0,l=a;l<=c;l++)u+=Math.abs(e.get(l,a-1));if(0!==u){for(i=0,l=c;l>=a;l--)r[l]=e.get(l,a-1)/u,i+=r[l]*r[l];for(s=Math.sqrt(i),r[a]>0&&(s=-s),i-=r[a]*s,r[a]=r[a]-s,h=a;h<t;h++){for(o=0,l=c;l>=a;l--)o+=r[l]*e.get(l,h);for(o/=i,l=a;l<=c;l++)e.set(l,h,e.get(l,h)-o*r[l])}for(l=0;l<=c;l++){for(o=0,h=c;h>=a;h--)o+=r[h]*e.get(l,h);for(o/=i,h=a;h<=c;h++)e.set(l,h,e.get(l,h)-o*r[h])}r[a]=u*r[a],e.set(a,a-1,u*s)}}for(l=0;l<t;l++)for(h=0;h<t;h++)n.set(l,h,l===h?1:0);for(a=c-1;a>=f+1;a--)if(0!==e.get(a,a-1)){for(l=a+1;l<=c;l++)r[l]=e.get(l,a-1);for(h=a;h<=c;h++){for(s=0,l=a;l<=c;l++)s+=r[l]*n.get(l,h);for(s=s/r[a]/e.get(a,a-1),l=a;l<=c;l++)n.set(l,h,n.get(l,h)+s*r[l])}}}(s,t,e,i),function(t,e,r,n,o){let s,i,l,h,a,u,f,c,g,m,w,y,p,d,x,b=t-1,M=0,v=t-1,A=Number.EPSILON,E=0,I=0,S=0,N=0,R=0,F=0,T=0,_=0;for(s=0;s<t;s++)for((s<M||s>v)&&(r[s]=o.get(s,s),e[s]=0),i=Math.max(s-1,0);i<t;i++)I+=Math.abs(o.get(s,i));for(;b>=M;){for(h=b;h>M&&(F=Math.abs(o.get(h-1,h-1))+Math.abs(o.get(h,h)),0===F&&(F=I),!(Math.abs(o.get(h,h-1))<A*F));)h--;if(h===b)o.set(b,b,o.get(b,b)+E),r[b]=o.get(b,b),e[b]=0,b--,_=0;else if(h===b-1){if(f=o.get(b,b-1)*o.get(b-1,b),S=(o.get(b-1,b-1)-o.get(b,b))/2,N=S*S+f,T=Math.sqrt(Math.abs(N)),o.set(b,b,o.get(b,b)+E),o.set(b-1,b-1,o.get(b-1,b-1)+E),c=o.get(b,b),N>=0){for(T=S>=0?S+T:S-T,r[b-1]=c+T,r[b]=r[b-1],0!==T&&(r[b]=c-f/T),e[b-1]=0,e[b]=0,c=o.get(b,b-1),F=Math.abs(c)+Math.abs(T),S=c/F,N=T/F,R=Math.sqrt(S*S+N*N),S/=R,N/=R,i=b-1;i<t;i++)T=o.get(b-1,i),o.set(b-1,i,N*T+S*o.get(b,i)),o.set(b,i,N*o.get(b,i)-S*T);for(s=0;s<=b;s++)T=o.get(s,b-1),o.set(s,b-1,N*T+S*o.get(s,b)),o.set(s,b,N*o.get(s,b)-S*T);for(s=M;s<=v;s++)T=n.get(s,b-1),n.set(s,b-1,N*T+S*n.get(s,b)),n.set(s,b,N*n.get(s,b)-S*T)}else r[b-1]=c+S,r[b]=c+S,e[b-1]=T,e[b]=-T;b-=2,_=0}else{if(c=o.get(b,b),g=0,f=0,h<b&&(g=o.get(b-1,b-1),f=o.get(b,b-1)*o.get(b-1,b)),10===_){for(E+=c,s=M;s<=b;s++)o.set(s,s,o.get(s,s)-c);F=Math.abs(o.get(b,b-1))+Math.abs(o.get(b-1,b-2)),c=g=.75*F,f=-.4375*F*F}if(30===_&&(F=(g-c)/2,F=F*F+f,F>0)){for(F=Math.sqrt(F),g<c&&(F=-F),F=c-f/((g-c)/2+F),s=M;s<=b;s++)o.set(s,s,o.get(s,s)-F);E+=F,c=g=f=.964}for(_+=1,a=b-2;a>=h&&(T=o.get(a,a),R=c-T,F=g-T,S=(R*F-f)/o.get(a+1,a)+o.get(a,a+1),N=o.get(a+1,a+1)-T-R-F,R=o.get(a+2,a+1),F=Math.abs(S)+Math.abs(N)+Math.abs(R),S/=F,N/=F,R/=F,a!==h)&&!(Math.abs(o.get(a,a-1))*(Math.abs(N)+Math.abs(R))<A*(Math.abs(S)*(Math.abs(o.get(a-1,a-1))+Math.abs(T)+Math.abs(o.get(a+1,a+1)))));)a--;for(s=a+2;s<=b;s++)o.set(s,s-2,0),s>a+2&&o.set(s,s-3,0);for(l=a;l<=b-1&&(d=l!==b-1,l!==a&&(S=o.get(l,l-1),N=o.get(l+1,l-1),R=d?o.get(l+2,l-1):0,c=Math.abs(S)+Math.abs(N)+Math.abs(R),0!==c&&(S/=c,N/=c,R/=c)),0!==c);l++)if(F=Math.sqrt(S*S+N*N+R*R),S<0&&(F=-F),0!==F){for(l!==a?o.set(l,l-1,-F*c):h!==a&&o.set(l,l-1,-o.get(l,l-1)),S+=F,c=S/F,g=N/F,T=R/F,N/=S,R/=S,i=l;i<t;i++)S=o.get(l,i)+N*o.get(l+1,i),d&&(S+=R*o.get(l+2,i),o.set(l+2,i,o.get(l+2,i)-S*T)),o.set(l,i,o.get(l,i)-S*c),o.set(l+1,i,o.get(l+1,i)-S*g);for(s=0;s<=Math.min(b,l+3);s++)S=c*o.get(s,l)+g*o.get(s,l+1),d&&(S+=T*o.get(s,l+2),o.set(s,l+2,o.get(s,l+2)-S*R)),o.set(s,l,o.get(s,l)-S),o.set(s,l+1,o.get(s,l+1)-S*N);for(s=M;s<=v;s++)S=c*n.get(s,l)+g*n.get(s,l+1),d&&(S+=T*n.get(s,l+2),n.set(s,l+2,n.get(s,l+2)-S*R)),n.set(s,l,n.get(s,l)-S),n.set(s,l+1,n.get(s,l+1)-S*N)}}}if(0===I)return;for(b=t-1;b>=0;b--)if(S=r[b],N=e[b],0===N)for(h=b,o.set(b,b,1),s=b-1;s>=0;s--){for(f=o.get(s,s)-S,R=0,i=h;i<=b;i++)R+=o.get(s,i)*o.get(i,b);if(e[s]<0)T=f,F=R;else if(h=s,0===e[s]?o.set(s,b,0!==f?-R/f:-R/(A*I)):(c=o.get(s,s+1),g=o.get(s+1,s),N=(r[s]-S)*(r[s]-S)+e[s]*e[s],u=(c*F-T*R)/N,o.set(s,b,u),o.set(s+1,b,Math.abs(c)>Math.abs(T)?(-R-f*u)/c:(-F-g*u)/T)),u=Math.abs(o.get(s,b)),A*u*u>1)for(i=s;i<=b;i++)o.set(i,b,o.get(i,b)/u)}else if(N<0)for(h=b-1,Math.abs(o.get(b,b-1))>Math.abs(o.get(b-1,b))?(o.set(b-1,b-1,N/o.get(b,b-1)),o.set(b-1,b,-(o.get(b,b)-S)/o.get(b,b-1))):(x=ut(0,-o.get(b-1,b),o.get(b-1,b-1)-S,N),o.set(b-1,b-1,x[0]),o.set(b-1,b,x[1])),o.set(b,b-1,0),o.set(b,b,1),s=b-2;s>=0;s--){for(m=0,w=0,i=h;i<=b;i++)m+=o.get(s,i)*o.get(i,b-1),w+=o.get(s,i)*o.get(i,b);if(f=o.get(s,s)-S,e[s]<0)T=f,R=m,F=w;else if(h=s,0===e[s]?(x=ut(-m,-w,f,N),o.set(s,b-1,x[0]),o.set(s,b,x[1])):(c=o.get(s,s+1),g=o.get(s+1,s),y=(r[s]-S)*(r[s]-S)+e[s]*e[s]-N*N,p=2*(r[s]-S)*N,0===y&&0===p&&(y=A*I*(Math.abs(f)+Math.abs(N)+Math.abs(c)+Math.abs(g)+Math.abs(T))),x=ut(c*R-T*m+N*w,c*F-T*w-N*m,y,p),o.set(s,b-1,x[0]),o.set(s,b,x[1]),Math.abs(c)>Math.abs(T)+Math.abs(N)?(o.set(s+1,b-1,(-m-f*o.get(s,b-1)+N*o.get(s,b))/c),o.set(s+1,b,(-w-f*o.get(s,b)-N*o.get(s,b-1))/c)):(x=ut(-R-g*o.get(s,b-1),-F-g*o.get(s,b),T,N),o.set(s+1,b-1,x[0]),o.set(s+1,b,x[1]))),u=Math.max(Math.abs(o.get(s,b-1)),Math.abs(o.get(s,b))),A*u*u>1)for(i=s;i<=b;i++)o.set(i,b-1,o.get(i,b-1)/u),o.set(i,b,o.get(i,b)/u)}for(s=0;s<t;s++)if(s<M||s>v)for(i=s;i<t;i++)n.set(s,i,o.get(s,i));for(i=t-1;i>=M;i--)for(s=M;s<=v;s++){for(T=0,l=M;l<=Math.min(i,v);l++)T+=n.get(s,l)*o.get(l,i);n.set(s,i,T)}}(s,h,l,i,t)}this.n=s,this.e=h,this.d=l,this.V=i}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,r=this.n,n=this.e,o=this.d,s=new Q(r,r);for(t=0;t<r;t++){for(e=0;e<r;e++)s.set(t,e,0);s.set(t,t,o[t]),n[t]>0?s.set(t,t+1,n[t]):n[t]<0&&s.set(t,t-1,n[t])}return s}}function ut(t,e,r,n){let o,s;return Math.abs(r)>Math.abs(n)?(o=n/r,s=r+o*n,[(t+o*e)/s,(e-o*t)/s]):(o=r/n,s=n+o*r,[(o*t+e)/s,(o*e-t)/s])}class ft{constructor(t){if(!(t=et.checkMatrix(t)).isSymmetric())throw new Error("Matrix is not symmetric");let e,r,n,o=t,s=o.rows,i=new Q(s,s),l=!0;for(r=0;r<s;r++){let t=0;for(n=0;n<r;n++){let s=0;for(e=0;e<n;e++)s+=i.get(n,e)*i.get(r,e);s=(o.get(r,n)-s)/i.get(n,n),i.set(r,n,s),t+=s*s}for(t=o.get(r,r)-t,l&&=t>0,i.set(r,r,Math.sqrt(Math.max(t,0))),n=r+1;n<s;n++)i.set(r,n,0)}this.L=i,this.positiveDefinite=l}isPositiveDefinite(){return this.positiveDefinite}solve(t){t=et.checkMatrix(t);let e=this.L,r=e.rows;if(t.rows!==r)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let n,o,s,i=t.columns,l=t.clone();for(s=0;s<r;s++)for(o=0;o<i;o++){for(n=0;n<s;n++)l.set(s,o,l.get(s,o)-l.get(n,o)*e.get(s,n));l.set(s,o,l.get(s,o)/e.get(s,s))}for(s=r-1;s>=0;s--)for(o=0;o<i;o++){for(n=s+1;n<r;n++)l.set(s,o,l.get(s,o)-l.get(n,o)*e.get(n,s));l.set(s,o,l.get(s,o)/e.get(s,s))}return l}get lowerTriangularMatrix(){return this.L}}class ct{constructor(t,e={}){t=et.checkMatrix(t);let{Y:r}=e;const{scaleScores:n=!1,maxIterations:o=1e3,terminationCriteria:s=1e-10}=e;let i;if(r){if(r=F.isAnyArray(r)&&"number"==typeof r[0]?Q.columnVector(r):et.checkMatrix(r),r.rows!==t.rows)throw new Error("Y should have the same number of rows as X");i=r.getColumnVector(0)}else i=t.getColumnVector(0);let l,h,a,u,f=1;for(let e=0;e<o&&f>s;e++)a=t.transpose().mmul(i).div(i.transpose().mmul(i).get(0,0)),a=a.div(a.norm()),l=t.mmul(a).div(a.transpose().mmul(a).get(0,0)),e>0&&(f=l.clone().sub(u).pow(2).sum()),u=l.clone(),r?(h=r.transpose().mmul(l).div(l.transpose().mmul(l).get(0,0)),h=h.div(h.norm()),i=r.mmul(h).div(h.transpose().mmul(h).get(0,0))):i=l;if(r){let e=t.transpose().mmul(l).div(l.transpose().mmul(l).get(0,0));e=e.div(e.norm());let n=t.clone().sub(l.clone().mmul(e.transpose())),o=i.transpose().mmul(l).div(l.transpose().mmul(l).get(0,0)),s=r.clone().sub(l.clone().mulS(o.get(0,0)).mmul(h.transpose()));this.t=l,this.p=e.transpose(),this.w=a.transpose(),this.q=h,this.u=i,this.s=l.transpose().mmul(l),this.xResidual=n,this.yResidual=s,this.betas=o}else this.w=a.transpose(),this.s=l.transpose().mmul(l).sqrt(),this.t=n?l.clone().div(this.s.get(0,0)):l,this.xResidual=t.sub(l.mmul(a.transpose()))}}S.AbstractMatrix=W,S.CHO=ft,S.CholeskyDecomposition=ft,S.DistanceMatrix=H,S.EVD=at,S.EigenvalueDecomposition=at,S.LU=rt,S.LuDecomposition=rt;var gt=S.Matrix=Q;S.MatrixColumnSelectionView=class extends Z{constructor(t,e){D(t,e),super(t,t.rows,e.length),this.columnIndices=e}set(t,e,r){return this.matrix.set(t,this.columnIndices[e],r),this}get(t,e){return this.matrix.get(t,this.columnIndices[e])}},S.MatrixColumnView=class extends Z{constructor(t,e){z(t,e),super(t,t.rows,1),this.column=e}set(t,e,r){return this.matrix.set(t,this.column,r),this}get(t){return this.matrix.get(t,this.column)}},S.MatrixFlipColumnView=class extends Z{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(t,this.columns-e-1,r),this}get(t,e){return this.matrix.get(t,this.columns-e-1)}},S.MatrixFlipRowView=class extends Z{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(this.rows-t-1,e,r),this}get(t,e){return this.matrix.get(this.rows-t-1,e)}},S.MatrixRowSelectionView=class extends Z{constructor(t,e){j(t,e),super(t,e.length,t.columns),this.rowIndices=e}set(t,e,r){return this.matrix.set(this.rowIndices[t],e,r),this}get(t,e){return this.matrix.get(this.rowIndices[t],e)}},S.MatrixRowView=class extends Z{constructor(t,e){P(t,e),super(t,1,t.columns),this.row=e}set(t,e,r){return this.matrix.set(this.row,e,r),this}get(t,e){return this.matrix.get(this.row,e)}},S.MatrixSelectionView=K,S.MatrixSubView=class extends Z{constructor(t,e,r,n,o){L(t,e,r,n,o),super(t,r-e+1,o-n+1),this.startRow=e,this.startColumn=n}set(t,e,r){return this.matrix.set(this.startRow+t,this.startColumn+e,r),this}get(t,e){return this.matrix.get(this.startRow+t,this.startColumn+e)}},S.MatrixTransposeView=class extends Z{constructor(t){super(t,t.columns,t.rows)}set(t,e,r){return this.matrix.set(e,t,r),this}get(t,e){return this.matrix.get(e,t)}},S.NIPALS=ct,S.Nipals=ct,S.QR=ot,S.QrDecomposition=ot,S.SVD=st,S.SingularValueDecomposition=st,S.SymmetricMatrix=J,S.WrapperMatrix1D=tt,S.WrapperMatrix2D=et,S.correlation=function(t,e=t,r={}){t=new Q(t);let n=!1;if("object"!=typeof e||Q.isMatrix(e)||F.isAnyArray(e)?e=new Q(e):(r=e,e=t,n=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:o=!0,scale:s=!0}=r;o&&(t.center("column"),n||e.center("column")),s&&(t.scale("column"),n||e.scale("column"));const i=t.standardDeviation("column",{unbiased:!0}),l=n?i:e.standardDeviation("column",{unbiased:!0}),h=t.transpose().mmul(e);for(let e=0;e<h.rows;e++)for(let r=0;r<h.columns;r++)h.set(e,r,h.get(e,r)*(1/(i[e]*l[r]))*(1/(t.rows-1)));return h},S.covariance=function(t,e=t,r={}){t=new Q(t);let n=!1;if("object"!=typeof e||Q.isMatrix(e)||F.isAnyArray(e)?e=new Q(e):(r=e,e=t,n=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:o=!0}=r;o&&(t=t.center("column"),n||(e=e.center("column")));const s=t.transpose().mmul(e);for(let e=0;e<s.rows;e++)for(let r=0;r<s.columns;r++)s.set(e,r,s.get(e,r)*(1/(t.rows-1)));return s};var mt=S.default=Q;S.determinant=function t(e){if((e=Q.checkMatrix(e)).isSquare()){if(0===e.columns)return 1;let r,n,o,s;if(2===e.columns)return r=e.get(0,0),n=e.get(0,1),o=e.get(1,0),s=e.get(1,1),r*s-n*o;if(3===e.columns){let s,i,l;return s=new K(e,[1,2],[1,2]),i=new K(e,[1,2],[0,2]),l=new K(e,[1,2],[0,1]),r=e.get(0,0),n=e.get(0,1),o=e.get(0,2),r*t(s)-n*t(i)+o*t(l)}return new rt(e).determinant}throw Error("determinant can only be calculated for a square matrix")},S.inverse=function(t,e=!1){return t=et.checkMatrix(t),e?new st(t).inverse():it(t,Q.eye(t.rows))},S.linearDependencies=function(t,e={}){const{thresholdValue:r=1e-9,thresholdError:n=1e-9}=e;let o=(t=Q.checkMatrix(t)).rows,s=new Q(o,o);for(let e=0;e<o;e++){let i=Q.columnVector(t.getRow(e)),l=t.subMatrixRow(lt(o,e)).transpose(),h=new st(l).solve(i),a=Q.sub(i,l.mmul(h)).abs().max();s.setRow(e,ht(a,h,e,r,n))}return s},S.pseudoInverse=function(t,e=Number.EPSILON){if((t=Q.checkMatrix(t)).isEmpty())return t.transpose();let r=new st(t,{autoTranspose:!0}),n=r.leftSingularVectors,o=r.rightSingularVectors,s=r.diagonal;for(let t=0;t<s.length;t++)Math.abs(s[t])>e?s[t]=1/s[t]:s[t]=0;return o.mmul(Q.diag(s).mmul(n.transpose()))},S.solve=it,S.wrap=function(t,e){if(F.isAnyArray(t))return t[0]&&F.isAnyArray(t[0])?new et(t):new tt(t,e);throw new Error("the argument is not an array")};const wt=gt;mt.Matrix&&mt.Matrix;const yt=(t,e)=>Math.abs(t-e);function pt(t,e,r={}){const{fct:n=yt}=r,o=t.length,s=e.length,i=new wt(o,s);for(let r=0;r<o;r++)for(let o=0;o<s;o++)i.set(r,o,n(t[r],e[o]));return i}function dt(t){if(!r(t))throw new TypeError("input must be an array");const e=new Float64Array(t.length);if(0===t.length)return e;e[0]=t[0];for(let r=1;r<t.length;r++)e[r]=e[r-1]+t[r];return e}function xt(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=t[r];for(let e=r+1;e<=n;e++)o+=t[e];return o/(n-r+1)}function bt(t,e={}){if(!r(t))throw new TypeError("input must be an array");const{unbiased:n=!0,mean:o=xt(t)}=e;let s=0;for(const e of t){const t=e-o;s+=t*t}return n?s/(t.length-1):s/t.length}function Mt(t,e={}){return Math.sqrt(bt(t,e))}function vt(t){return{...M(t),mean:xt(t),sd:Mt(t),nb:t.length}}function At(t,e,o={}){let s=!1,i=0;if(r(e)){if(t.length!==e.length)throw new RangeError("size of array1 and array2 must be identical")}else s=!0,i=e;const l=n(o.output,t.length);if(s)for(let e=0;e<t.length;e++)l[e]=t[e]/i;else for(let r=0;r<t.length;r++)l[r]=t[r]/e[r];return l}function Et(t){return u(t),t instanceof Float64Array?t.slice(0):Float64Array.from(t)}function It(t,e={}){const{target:r,targetIndex:n}=e;return void 0===n?void 0!==r?f(t,r):0:n}function St(t){if(this.size=0|t,this.size<=1||this.size&this.size-1)throw new Error("FFT size must be a power of two and bigger than 1");this._csize=t<<1;for(var e=new Array(2*this.size),r=0;r<e.length;r+=2){const t=Math.PI*r/this.size;e[r]=Math.cos(t),e[r+1]=-Math.sin(t)}this.table=e;for(var n=0,o=1;this.size>o;o<<=1)n++;this._width=n%2==0?n-1:n,this._bitrev=new Array(1<<this._width);for(var s=0;s<this._bitrev.length;s++){this._bitrev[s]=0;for(var i=0;i<this._width;i+=2){var l=this._width-i-2;this._bitrev[s]|=(s>>>i&3)<<l}}this._out=null,this._data=null,this._inv=0}var Nt=St;St.prototype.fromComplexArray=function(t,e){for(var r=e||new Array(t.length>>>1),n=0;n<t.length;n+=2)r[n>>>1]=t[n];return r},St.prototype.createComplexArray=function(){const t=new Array(this._csize);for(var e=0;e<t.length;e++)t[e]=0;return t},St.prototype.toComplexArray=function(t,e){for(var r=e||this.createComplexArray(),n=0;n<r.length;n+=2)r[n]=t[n>>>1],r[n+1]=0;return r},St.prototype.completeSpectrum=function(t){for(var e=this._csize,r=e>>>1,n=2;n<r;n+=2)t[e-n]=t[n],t[e-n+1]=-t[n+1]},St.prototype.transform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._transform4(),this._out=null,this._data=null},St.prototype.realTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._realTransform4(),this._out=null,this._data=null},St.prototype.inverseTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=1,this._transform4();for(var r=0;r<t.length;r++)t[r]/=this.size;this._out=null,this._data=null},St.prototype._transform4=function(){var t,e,r=this._out,n=this._csize,o=1<<this._width,s=n/o<<1,i=this._bitrev;if(4===s)for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleTransform2(t,r,o)}else for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleTransform4(t,r,o)}var l=this._inv?-1:1,h=this.table;for(o>>=2;o>=2;o>>=2){var a=(s=n/o<<1)>>>2;for(t=0;t<n;t+=s)for(var u=t+a,f=t,c=0;f<u;f+=2,c+=o){const t=f,e=t+a,n=e+a,o=n+a,s=r[t],i=r[t+1],u=r[e],g=r[e+1],m=r[n],w=r[n+1],y=r[o],p=r[o+1],d=s,x=i,b=h[c],M=l*h[c+1],v=u*b-g*M,A=u*M+g*b,E=h[2*c],I=l*h[2*c+1],S=m*E-w*I,N=m*I+w*E,R=h[3*c],F=l*h[3*c+1],T=y*R-p*F,_=y*F+p*R,k=d+S,C=x+N,q=d-S,V=x-N,P=v+T,z=A+_,O=l*(v-T),$=l*(A-_),j=k+P,D=C+z,L=k-P,Y=C-z,U=q+$,X=V-O,W=q-$,G=V+O;r[t]=j,r[t+1]=D,r[e]=U,r[e+1]=X,r[n]=L,r[n+1]=Y,r[o]=W,r[o+1]=G}}},St.prototype._singleTransform2=function(t,e,r){const n=this._out,o=this._data,s=o[e],i=o[e+1],l=o[e+r],h=o[e+r+1],a=s+l,u=i+h,f=s-l,c=i-h;n[t]=a,n[t+1]=u,n[t+2]=f,n[t+3]=c},St.prototype._singleTransform4=function(t,e,r){const n=this._out,o=this._data,s=this._inv?-1:1,i=2*r,l=3*r,h=o[e],a=o[e+1],u=o[e+r],f=o[e+r+1],c=o[e+i],g=o[e+i+1],m=o[e+l],w=o[e+l+1],y=h+c,p=a+g,d=h-c,x=a-g,b=u+m,M=f+w,v=s*(u-m),A=s*(f-w),E=y+b,I=p+M,S=d+A,N=x-v,R=y-b,F=p-M,T=d-A,_=x+v;n[t]=E,n[t+1]=I,n[t+2]=S,n[t+3]=N,n[t+4]=R,n[t+5]=F,n[t+6]=T,n[t+7]=_},St.prototype._realTransform4=function(){var t,e,r=this._out,n=this._csize,o=1<<this._width,s=n/o<<1,i=this._bitrev;if(4===s)for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleRealTransform2(t,r>>>1,o>>>1)}else for(t=0,e=0;t<n;t+=s,e++){const r=i[e];this._singleRealTransform4(t,r>>>1,o>>>1)}var l=this._inv?-1:1,h=this.table;for(o>>=2;o>=2;o>>=2){var a=(s=n/o<<1)>>>1,u=a>>>1,f=u>>>1;for(t=0;t<n;t+=s)for(var c=0,g=0;c<=f;c+=2,g+=o){var m=t+c,w=m+u,y=w+u,p=y+u,d=r[m],x=r[m+1],b=r[w],M=r[w+1],v=r[y],A=r[y+1],E=r[p],I=r[p+1],S=d,N=x,R=h[g],F=l*h[g+1],T=b*R-M*F,_=b*F+M*R,k=h[2*g],C=l*h[2*g+1],q=v*k-A*C,V=v*C+A*k,P=h[3*g],z=l*h[3*g+1],O=E*P-I*z,$=E*z+I*P,j=S+q,D=N+V,L=S-q,Y=N-V,U=T+O,X=_+$,W=l*(T-O),G=l*(_-$),B=j+U,Q=D+X,J=L+G,H=Y-W;if(r[m]=B,r[m+1]=Q,r[w]=J,r[w+1]=H,0!==c){if(c!==f){var Z=L+-l*G,K=-Y+-l*W,tt=j+-l*U,et=-D- -l*X,rt=t+u-c,nt=t+a-c;r[rt]=Z,r[rt+1]=K,r[nt]=tt,r[nt+1]=et}}else{var ot=j-U,st=D-X;r[y]=ot,r[y+1]=st}}}},St.prototype._singleRealTransform2=function(t,e,r){const n=this._out,o=this._data,s=o[e],i=o[e+r],l=s+i,h=s-i;n[t]=l,n[t+1]=0,n[t+2]=h,n[t+3]=0},St.prototype._singleRealTransform4=function(t,e,r){const n=this._out,o=this._data,s=this._inv?-1:1,i=2*r,l=3*r,h=o[e],a=o[e+r],u=o[e+i],f=o[e+l],c=h+u,g=h-u,m=a+f,w=s*(a-f),y=c+m,p=g,d=-w,x=c-m,b=g,M=w;n[t]=y,n[t+1]=0,n[t+2]=p,n[t+3]=d,n[t+4]=x,n[t+5]=0,n[t+6]=b,n[t+7]=M};var Rt=E(Nt);function Ft(t,e){return t===Array?new t(e).fill(0):new t(e)}function Tt(t,e){return t===Array?new t(e).fill(0):new t(e)}function _t(t={}){const{from:e=0,to:r=1,length:n=1e3,includeFrom:o=!0,includeTo:s=!0,distribution:i="uniform"}=t,l=new Float64Array(n);let h=n;o&&s?h=n-1:!o&&s||o&&!s?h=n:o||s||(h=n+1);const a=(r-e)/h;if("uniform"===i)if(o){let t=0;for(;t<n;)l[t]=e+a*t,t++}else{let t=0;for(;t<n;)l[t]=e+a*(t+1),t++}else{if("log"!==i)throw new Error("distribution must be uniform or log");{const t=(r/e)**(1/h),s=Math.log(e)/Math.log(t);if(o){let e=0;for(;e<n;)l[e]=t**(s+e),e++}else{let e=0;for(;e<n;)l[e]=t**(s+e+1),e++}}}return l}const kt=1/16777216;function Ct(t,e){const r=65535&(t>>>=0);return((t-r)*(e>>>=0)>>>0)+r*e>>>0}class qt{random;state;constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*kt}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<8;t++)this.state[3&t]^=t+Ct(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<8;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<15,t^=t>>>18,t^=this.state[3]<<11,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}function Vt(t={}){const{mean:e=0,standardDeviation:r=1,length:n=1e3,range:o=1,seed:s,distribution:i="normal"}=t,l=new qt(s),h=new Float64Array(n);switch(i){case"normal":{const t=new Pt(e,r,l);for(let e=0;e<n;e++)h[e]=t.generateGaussian();break}case"uniform":for(let t=0;t<n;t++)h[t]=(l.random()-.5)*o+e;break;default:throw new Error(`unknown distribution: ${String(i)}`)}return h}class Pt{#r=0;#n=!1;#o;#s;#i;constructor(t,e,r){this.#o=t,this.#s=e,this.#i=r}generateGaussian(){let t,e,r,n;if(this.#n)this.#n=!1,t=this.#r*this.#s+this.#o;else{do{e=2*this.#i.random()-1,r=2*this.#i.random()-1,n=e*e+r*r}while(n>=1||0===n);n=Math.sqrt(-2*Math.log(n)/n),this.#r=r*n,this.#n=!0,t=this.#o+this.#s*e*n}return t}}function zt(t={}){const{from:e=0,step:r=1,length:n=1e3}=t,o=new Float64Array(n);let s=0;for(;s<n;)o[s]=e+r*s,s++;return o}function Ot(t={}){const{targetMin:e=0,targetMax:r=1,clamp:n=!0,algorithmOptions:o={},algorithm:s="linear"}=t;let{originalMin:i=0,originalMax:l=1}=t;const h=function(t="linear",e={}){return r=>{switch(t){case"linear":return r;case"logarithmic":return Math.log10(r);case"power":return r**(e.power||2);default:throw new Error(`Unknown kind ${String(t)}`)}}}(s,o);i=h(i),l=h(l);const a=l-i,u=r-e;return function(t){t=function(t,e,r,n=!0){if(t<e){if(n)return e;throw new RangeError(`Value ${t} is out of range [${e}, ${r}]`)}if(t>r){if(n)return r;throw new RangeError(`Value ${t} is out of range [${e}, ${r}]`)}return t}(t=h(t),i,l,n);return e+(t-i)/a*u}}function $t(t){return 0!==t&&!(t&t-1)}function jt(t){return 0===t?1:(t--,t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,(t|=t>>16)+1)}async function Dt(t){if("object"!=typeof t)return t;const e=[];return await Lt(t,e),await Promise.all(e),t}function Lt(t,e){if("object"!=typeof t)return t;for(const r in t)"function"==typeof t[r].then?e.push(t[r].then(e=>t[r]=e)):"object"==typeof t[r]&&Lt(t[r],e);return t}function Yt(t){return"object"!=typeof t?t:t=Ut(t)}function Ut(t){if("object"!=typeof t)return t;if(ArrayBuffer.isView(t))return Array.from(t);for(const e in t)ArrayBuffer.isView(t[e])?t[e]=Array.from(t[e]):"object"==typeof t[e]&&Ut(t[e]);return t}function Xt(t,e,r){return JSON.stringify(t,(t,r)=>(ArrayBuffer.isView(r)&&(r=Array.from(r)),e?e(t,r):r),r)}function Wt(t,e){let n=!1,o=0;if(r(e)){if(t.length!==e.length)throw new Error("size of array1 and array2 must be identical")}else n=!0,o=e;const s=new Float64Array(t.length);if(n)for(let e=0;e<t.length;e++)s[e]=t[e]-o;else for(let r=0;r<t.length;r++)s[r]=t[r]-e[r];return s}function Gt(t,e,r,n){const{controlPoints:i,factorStd:l=3,learningRate:h=.5,minWeight:a=.01}=n,u=o(Wt(t,e)),f=l*(1.4826*s(u)),c=new Float64Array(u.length);for(let t=0;t<u.length;t++)c[t]=Math.exp(-((u[t]/f)**2));let g=Number.MIN_SAFE_INTEGER;const m=Float64Array.from(r),w=1-h;for(let t=0;t<m.length;t++){if(i&&i[t]>0)continue;const e=Math.max(a,w*r[t]+h*c[t]);m[t]=e,g=Math.max(g,e)}return m[0]=g,m[r.length-1]=g,m}function Bt(t,e={}){const{propertiesToRemove:r=[],...n}=e;if(r.length>0)for(const e of r)Qt(t,e,n);else Qt(t,"",n);return t}function Qt(t,e,r={}){const n=new WeakMap;!function t(o,s,i){if(Zt(o)){if(n.has(o))return;n.set(o,null);for(const r of Reflect.ownKeys(o))e&&r===e||!e&&Kt(o[r])?Reflect.deleteProperty(o,r):t(o[r],o,r);!e&&Kt(o)&&s&&Reflect.deleteProperty(s,i)}else if(Ht(o)){if(n.has(o))return;n.set(o,null);for(let e=0;e<o.length;e++)t(o[e],o,e);for(let t=o.length-1;t>=0;t--){const e=o[t];!Kt(e)||Ht(e)&&0===e.length&&!1===r?.removeEmptyArrayAndObject||o.splice(t,1)}for(const r of Reflect.ownKeys(o)){if(!("string"==typeof r&&/^\d+$/.test(r))){const n=o[r];e&&r===e||!e&&Kt(n)?Reflect.deleteProperty(o,r):t(n,o,r)}}!e&&0===o.length&&s&&r?.removeEmptyArrayAndObject&&Reflect.deleteProperty(s,i)}}(t)}function Jt(t){return Object.prototype.toString.call(t)}function Ht(t){return Array.isArray?Array.isArray(t):"[object Array]"===Jt(t)}function Zt(t){return"[object Object]"===Jt(t)}function Kt(t){return function(t){return void 0===t}(t)||function(t){return"[object Null]"===Jt(t)}(t)||function(t){return"[object String]"===Jt(t)}(t)&&0===t.length||Ht(t)&&0===t.length||Zt(t)&&0===Object.keys(t).length}function te(t,e={}){u(t);const{forceFFT:r=!1}=e,n=t.length;return $t(n)?ee(t):r?re(ee(re(t,jt(n))),n):function(t,e={}){const{inClockwise:r=!0}=e,n=[0,...t,0],o=new Float64Array(t.length);for(let t=1;t<n.length-1;t++){let e=0;for(let r=0;r<t-1;r++){const o=Math.log((t-r)/(t-r-1));e+=n[r]*o+(n[r+1]-n[r])*((t-r)*o-1)}const s=n[t-1]-n[t+1];let i=0;for(let e=t+1;e<n.length-1;e++){const r=Math.log((e-t)/(e-t+1));i+=n[e]*r+(n[e-1]-n[e])*(1+(e-t)*r)}o[t-1]=(r?1:-1)*(e+s+i)/Math.PI}return o}(t)}function ee(t){const e=t.length,r=new Rt(e),n=new Float64Array(2*e);r.realTransform(n,t),r.completeSpectrum(n);const o=new Float64Array(e);for(let t=1;t<e;t++)o[t]=Math.sign(e/2-t);for(let t=0;t<e;t++)n[2*t]*=o[t],n[2*t+1]*=o[t];const s=new Float64Array(2*e);r.inverseTransform(s,n);const i=new Float64Array(e);for(let t=0;t<e;t++)i[t]=s[2*t+1];return i}function re(t,e){u(t);const r=t.length,n=(r-1)/(e-1),o=new Float64Array(e);let s=0,i=Math.floor(s),l=Math.min(Math.ceil(s),r-1),h=s-i;for(let a=0;a<e;a++)o[a]=t[i]*(1-h)+t[l]*h,s+=n,i=Math.floor(s),l=Math.min(Math.ceil(s),r-1),h=s-i;return o}function ne(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=t[r];for(let e=r+1;e<=n;e++)t[e]>o&&(o=t[e]);return o}function oe(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=t[r];for(let e=r+1;e<=n;e++)t[e]<o&&(o=t[e]);return o}function se(t,e={}){u(t);const r=e.histogram,{centerX:n=!0,nbSlots:s=(void 0===r?256:r.x.length),logBaseX:i,logBaseY:l,absolute:h=!1}=e;if(h&&(t=o(t)),i){t=t.slice();const e=Math.log10(i);for(let r=0;r<t.length;r++)t[r]=Math.log10(t[r])/e}const{min:a=oe(t),max:f=ne(t)}=e,c=(f-a)/(s+Number.EPSILON),g=void 0===r?new Float64Array(s):r.y,m=void 0===r?Array.from(_t({from:a+(n?c/2:0),to:f-(n?c/2:0),length:s})):r.x;for(const e of t){g[Math.max(Math.min(Math.floor((e-a-Number.EPSILON)/c),s-1),0)]++}if(l){const t=Math.log10(l);for(let e=0;e<g.length;e++)g[e]=Math.log10(g[e]+1)/t}return{x:m,y:g}}function ie(t,e={}){if(t.length<3)return!0;const{tolerance:r=.05}=e;let n=0,o=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){const r=t[e+1]-t[e];r<o&&(o=r),r>n&&(n=r)}return(n-o)/n<r}function le(t){if(t.length<=2)return 1;if(t[0]===t[1]){for(let e=1;e<t.length-1;e++)if(t[e]!==t[e+1])return 0;return 1}if(t[0]<t.at(-1)){for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return 0;return 1}for(let e=0;e<t.length-1;e++)if(t[e]<=t[e+1])return 0;return-1}function he(t,e,r={}){const{recenter:n=!0,similarityFct:o=(t,e)=>t===e?1:0}=r,s=ue(t),i=ue(e),l=Math.min(s,i);n&&(t=t.slice());let h=0;for(let r=0;r<l;r++){const s=1/l/(1<<r);for(let i=0;i<1<<r;i++){const a=(1<<r)-1+i,u=t[a],f=e[a];h+=o(u,f)*s,n&&ae(t,l,r,i,f-u)}}return h}function ae(t,e,r,n,o){for(let s=r;s<e;s++){const e=n*(1<<s-r),i=(1<<s)-1,l=1<<s-r;for(let r=e;r<e+l;r++){t[i+r]+=o}}}function ue(t){const e=Math.log2(t.length+1);if(e%1!=0)throw new Error("the array length is not a power of 2 minus 1");return e}function fe(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=t[r];for(let e=r+1;e<=n;e++)t[e]>=0?t[e]>o&&(o=t[e]):-t[e]>o&&(o=-t[e]);return o}function ce(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=r;for(let e=r+1;e<=n;e++)t[e]>t[o]&&(o=e);return o}function ge(t,e){v(t,e);let r=0;for(let n=0;n<t.length;n++)r+=Math.abs(t[n]-e[n]);return r/t.length}function me(t,e){v(t,e);let r=0;for(let n=0;n<t.length;n++)r+=(t[n]-e[n])**2;return r/t.length}function we(t,e,r={}){if(u(t,{minLength:1}),u(e),t.length!==e.length)throw new Error("array and weights must have the same length");const{fromIndex:n,toIndex:o}=c(t,r);let s=0,i=t[n]*e[n];s+=e[n];for(let r=n+1;r<=o;r++)i+=t[r]*e[r],s+=e[r];if(0===s)throw new Error("sum of weights must be > 0");return i/s}function ye(t){const e=s(t),r=new Float64Array(t.length);for(let n=0;n<t.length;n++)r[n]=Math.abs(t[n]-e);return{median:e,mad:s(r)}}function pe(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=r;for(let e=r+1;e<=n;e++)t[e]<t[o]&&(o=e);return o}function de(t){u(t,{minLength:2});let e=t[1]-t[0],r=e;for(let n=0;n<t.length-1;n++){const o=t[n+1]-t[n];o<e&&(e=o),o>r&&(r=o)}return{min:e,max:r}}function xe(t){u(t);let e=t[0],r=t[0];for(const n of t)n<e&&(e=n),n>r&&(r=n);return{min:e,max:r}}function be(t){if(0===t.length)throw new TypeError("input must not be empty");let e=0,r=0,n=0;const o={};for(const s of t)n=o[s],n?(o[s]++,n++):(o[s]=1,n=1),n>r&&(r=n,e=s);return e}const Me=[-.005387729650712429,.008226878746769157,.02198786811111689,-.03656379714117627,-.012692614766297404,.03348066254097446,-.008368748197417368,-.0005087819496582806],ve=[.0008862163904564247,-.0023339375937419,.07952836873415717,-.05273963823400997,-.7122890234154284,.662328840472003,1.5622155839842302,-1.5657455823417585,-.9700050433032906,1],Ae=[-3.6719225470772936,21.12946554483405,17.445385985570866,-44.6382324441787,-18.851064805871424,17.644729840837403,8.3705032834312,.10526468069939171,-.20243350835593876],Ee=[1.7211476576120028,-22.643693341313973,10.826866735546016,48.560921310873994,-20.14326346804852,-28.66081804998,3.971343795334387,6.242641248542475,1],Ie=[-6.81149956853777e-10,2.8522533178221704e-8,-6.794655751811263e-7,.0021455899538880526,.029015791000532906,.14286953440815717,.3377855389120359,.38707973897260434,.11703015634199525,-.16379404719331705,-.1311027816799519],Se=[.011059242293464892,.15226433829533179,.848854343457902,2.5930192162362027,4.778465929458438,5.381683457070069,3.4662540724256723,1],Ne=[26633922742578204e-28,-2.304047769118826e-10,460469890584318e-20,.00015754461742496055,.0018712349281955923,.009508047013259196,.018557330651423107,-.0022242652921344794,-.0350353787183178],Re=[7646752923027944e-20,.00263861676657016,.03415891436709477,.22009110576413124,.7620591645536234,1.3653349817554064,1],Fe=[9905570997331033e-32,-2811287356288318e-29,4.625961635228786e-9,4.4969678992770644e-7,14962478375834237e-21,.00020938631748758808,.001056288621524929,-.0011295143874558028,-.016743100507663373],Te=[2.82243172016108e-7,27533547476472603e-21,.0009640118070051656,.016074608709367652,.1381518657490833,.5914293448864175,1];function _e(t,e){let r=0;for(const n of t)r=r*e+n;return r}function ke(t,e,r,n,o){const s=t-e;return o*t+_e(r,s)/_e(n,s)*t}function Ce(t){let e,r,n,o,s=!1;if(Number.isNaN(t))return Number.NaN;if(t<0||t>2)throw new RangeError(`erfcinv()::invalid input argument. Value must be on the interval [0,2]. Value: \`${t}\`.`);return 0===t?Number.POSITIVE_INFINITY:2===t?Number.NEGATIVE_INFINITY:1===t?0:(t>1?(r=2-t,t=1-r,s=!0):(r=t,t=1-t),t<=.5?(n=t*(t+10),o=_e(Me,t)/_e(ve,t),e=.08913147449493408*n+n*o,s?-e:e):r>=.25?(n=Math.sqrt(-2*Math.log(r)),r-=.25,o=_e(Ae,r)/_e(Ee,r),e=n/(2.249481201171875+o),s?-e:e):(r=Math.sqrt(-Math.log(r)),r<3?ke(r,1.125,Ie,Se,.807220458984375):r<6?ke(r,3,Ne,Re,.9399557113647461):ke(r,6,Fe,Te,.9836282730102539)))}function qe(t,e={}){return function(t,e={}){const{magnitudeMode:r=!1}=e,n=new Float64Array(t.length);if(r)for(let e=0;e<n.length;e++)n[e]=-Math.sqrt(-2*Math.log(1-t[e]));else for(let e=0;e<n.length;e++)n[e]=-1*Math.SQRT2*Ce(2*t[e]);return n}([t],e)[0]}function Ve(t,e={}){const{mask:n,cutOff:o,refine:s=!0,magnitudeMode:i=!1,scaleFactor:l=1,factorStd:h=5,fixOffset:a=!0}=e,u=function(t,e){const{scaleFactor:n,mask:o}=e,s=Et(r(o)&&o.length===t.length?t.filter((t,e)=>!o[e]):t);if(n>1)for(let t=0;t<s.length;t++)s[t]*=n;return s.sort(),s.reverse(),s}(t,{scaleFactor:l,mask:n});if(a&&!i){const t=Math.floor(u.length/2),e=u.length%2==0?.5*(u[t-1]+u[t]):u[t];for(let t=0;t<u.length;t++)u[t]-=e}const f=u.at(-1)>=0?u.length:u.findIndex(t=>t<0);let c=f-1;for(let t=c;t>=0;t--)if(u[t]>0){c=t;break}const g=u.slice(0,c+1),m=u.slice(f),w=o||function(t,e={}){const{magnitudeMode:r=!1,considerList:n={from:.5,step:.1,to:.9}}=e,o=[],s=t.length-1;for(let e=.01;e<=.99;e+=.01){const n=-t[Math.round(s*e)]/qe(e/2,{magnitudeMode:r});o.push([e,n])}let i=Number.MAX_SAFE_INTEGER;const{from:l,to:h,step:a}=n,u=a/2;let f=.5;for(let t=l;t<=h;t+=a){const e=t-u,r=t+u,n=o.filter(t=>t[0]<r&&t[0]>e);let s=0;for(const t of n)s+=Math.abs(t[1]);let l=0;for(const t of n)l+=(t[1]-s)**2;l<i&&(i=l,f=t)}return f}(g,{magnitudeMode:i}),y=g[Math.floor(g.length*w)],p=g[0];let d;if(m.length>0){d=-1*m[Math.floor(m.length*(1-w))]}else d=0;let x=y,b=d,M=g.slice(),v=m.slice(),A=0,E=2;if(s){let t=x*h;A=g.findIndex(e=>e<t),A>-1&&(M=g.slice(A),x=M[Math.floor(M.length*w)]),t=b*h,E=m.findIndex(e=>e<t),E>-1&&(v=m.slice(E),b=M[Math.floor(v.length*(1-w))])}const I=-qe(w/2,{magnitudeMode:i});let S,N;return s&&A>-1?(S=(w*M.length+A)/(M.length+A),N=-1*qe(S/2,{magnitudeMode:i}),x/=N,E>-1&&(S=(w*v.length+E)/(v.length+E),N=-1*qe(S/2,{magnitudeMode:i}),0!==b&&(b/=N))):(x/=I,b/=I),{positive:x,negative:b,snr:p/x,sanplot:Pe(u,{fromTo:{positive:{from:0,to:c},negative:{from:f,to:u.length}}})}}function Pe(t,e={}){const{fromTo:r,logBaseY:n=2}=e,o={};for(const e in r){const{from:s,to:i}=r[e];o[e]=s!==i?ze(t.slice(s,i),{logBaseY:n}):{x:[],y:[]},"negative"===e&&o[e].y.reverse()}return o}function ze(t,e={}){const{log10:r,abs:n}=Math,{logBaseY:o}=e;if(o){t=t.slice(0);const e=r(o);for(let o=0;o<t.length;o++)t[o]=r(n(t[o]))/e}return{x:_t({from:0,to:t.length-1,length:t.length}),y:t}}function Oe(t){const{mad:e,median:r}=ye(t);return{sd:e/.6744897501960817,mad:e,median:r}}function $e(t){let e=0;for(const r of t)e+=r**2;return Math.sqrt(e)}function je(t,e={}){u(t);const{fromIndex:r,toIndex:n}=c(t,e);let o=t[r];for(let e=r+1;e<=n;e++)o+=t[e];return o}function De(t,e={}){const{algorithm:r="absolute",value:o=1}=e;u(t);const s=n(e.output,t.length);if(0===t.length)throw new Error("input must not be empty");switch(r){case"absolute":{const e=function(t){let e=0;for(const r of t)e+=Math.abs(r);return e}(t)/o;if(0===e)throw new Error("trying to divide by 0");for(let r=0;r<t.length;r++)s[r]=t[r]/e;return s}case"max":{const e=ne(t);if(0===e)throw new Error("trying to divide by 0");const r=o/e;for(let e=0;e<t.length;e++)s[e]=t[e]*r;return s}case"sum":{const e=je(t)/o;if(0===e)throw new Error("trying to divide by 0");for(let r=0;r<t.length;r++)s[r]=t[r]/e;return s}default:throw new Error(`unknown algorithm: ${String(r)}`)}}function Le(t,e={}){const{size:r=0,value:n=0,algorithm:o}=e;if(u(t),!o)return Et(t);const s=new Float64Array(t.length+2*r);for(let e=0;e<t.length;e++)s[e+r]=t[e];const i=r+t.length,l=2*r+t.length;switch(o){case"value":for(let t=0;t<r;t++)s[t]=n;for(let t=i;t<l;t++)s[t]=n;break;case"duplicate":for(let e=0;e<r;e++)s[e]=t[0];for(let e=i;e<l;e++)s[e]=t.at(-1);break;case"circular":for(let e=0;e<r;e++)s[e]=t[(t.length-r%t.length+e)%t.length];for(let e=0;e<r;e++)s[e+i]=t[e%t.length];break;default:throw new Error(`unknown algorithm ${String(o)}`)}return s}function Ye(t){u(t);const e=new Float64Array(t.length),r=Math.sqrt(Mt(t));for(let n=0;n<t.length;n++)e[n]=t[n]/r;return e}function Ue(t){const e=M(t);let r;if(e.max-e.min<=Number.EPSILON)return{...e,mean:e.median,sd:1===t.length?Number.NaN:0,nb:t.length};if(0===e.outliers.length)r=t;else{r=new Float64Array(t.length-e.outliers.length);let n=0;for(const o of t)o>=e.min&&o<=e.max&&(r[n++]=o)}return{...e,mean:xt(r),sd:Mt(r),nb:r.length}}function Xe(t){if(!r(t))throw new TypeError("input must be an array");if(0===t.length)return t;const e=b(t),n=e.q3-e.q1,o=e.q1-1.5*n,s=e.q3+1.5*n;if(e.min>=o&&e.max<=s)return t;const i=[];for(const e of t)e>=o&&e<=s&&i.push(e);return i}function We(t,e={}){u(t);const r=n(e.output,t.length),o=oe(t),s=ne(t);if(o===s)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");const{min:i=0,max:l=1}=e;if(i>=l)throw new RangeError("min option must be smaller than max option");const h=(l-i)/(s-o);for(let e=0;e<t.length;e++)r[e]=(t[e]-o)*h+i;return r}function Ge(t,e,r={}){if(u(t),"function"!=typeof e)throw new TypeError("fct must be a function");const{window:n=5,padding:o={}}=r,{size:s=n-1,algorithm:i,value:l}=o,h=Le(t,{size:s,algorithm:i,value:l}),a=[];for(let t=0;t<h.length-n+1;t++)a.push(e(h.subarray(t,t+n)));return a}function Be(t,e={}){return Ge(t,xt,e)}function Qe(t,e={}){return Ge(t,ne,e)}function Je(t,e={}){return Ge(t,s,e)}function He(t,e={}){return Ge(t,oe,e)}function Ze(t,e){(e%=t.length)<0&&(e+=t.length);const r=new Float64Array(t.length);return r.set(t.slice(t.length-e)),r.set(t.slice(0,t.length-e),e),r}function Ke(t,e={}){const{length:r=10}=e;if(u(t),r===t.length)return Float64Array.from(t);if(r>t.length)throw new RangeError("length must be smaller than the array length");return function(t,e){const r=new Float64Array(e),n=(t.length-1)/(e-1);for(let o=0;o<e;o++)r[o]=t[Math.round(o*n)];return r}(t,r)}function tr(t,e={}){const{from:r,step:n,size:o}=t,{ArrayConstructor:s=Float64Array}=e,i=Ft(s,o);for(let t=0;t<o;t++)i[t]=r+t*n;return i}function er(t,e={}){const{from:r,to:n,size:o}=t;return tr({from:r,step:(n-r)/(o-1),size:o},e)}function rr(t){if(ArrayBuffer.isView(t))return t.sort(),t;if(Array.isArray(t))return t.sort((t,e)=>t-e),t;throw new Error("trying to sort non array")}function nr(t){if(ArrayBuffer.isView(t))return t.sort(),t.reverse(),t;if(Array.isArray(t))return t.sort((t,e)=>e-t),t;throw new Error("trying to sort non array")}function or(t){const e=Float64Array.from(new Set(t));return e.sort(),e}function sr(t){const e=t[0].length,r=new Float64Array(t.length*e);for(let n=0;n<t.length;n++){const o=n*e;for(let s=0;s<e;s++){const e=t[n][s];r[o+s]=Math.abs(e)}}return s(r)}function ir(t){const{matrix:e,nbRows:r=e?.length||1,nbColumns:n=e?.[0].length||1,ArrayConstructor:o=Float64Array}=t,s=[];for(let t=0;t<r;t++)s.push(Ft(o,n));return s}function lr(t,e){const r=ir({nbRows:t.length,nbColumns:t[0].length,ArrayConstructor:Array}),n=[];for(const t in e)n.push(e[t]);let o=ne(n);for(const t of r)for(let n=0;n<r[0].length;n++)"string"==typeof t[n]&&(t[n]in e?t[n]=e[t[n]]:(o++,e[t[n]]=o,t[n]=o));return r}function hr(t,e=0){const r=t.length,n=t[0].length;if(r<2)throw new Error("can not calculate info if matrix contains less than 2 rows");const o=new Float64Array(r),s=new Float64Array(r),i=new Float64Array(n);for(let n=0;n<r;n++)o[n]=t[n][e];for(let e=0;e<n;e++){for(let n=0;n<r;n++)s[n]=t[n][e];i[e]=A(o,s)}return i}function ar(t){const e=t.length,r=t[0].length;if(e<5)throw new Error("can not calculate info if matrix contains less than 5 rows");const n={q1:new Float64Array(r),median:new Float64Array(r),q3:new Float64Array(r),min:Float64Array.from(t[0]),max:Float64Array.from(t.at(-1))},o=new Float64Array(t.length);for(let s=0;s<r;s++){for(let r=0;r<e;r++)o[r]=t[r][s];let r=0,i=0;if(e%2==1){const t=(e-1)/2;n.median[s]=o[t],r=t-1,i=t+1}else i=e/2,r=i-1,n.median[s]=(o[r]+o[i])/2;if(r%2==0)n.q1[s]=o[r/2],n.q3[s]=o[(e+i-1)/2];else{n.q1[s]=(o[(r+1)/2]+o[(r-1)/2])/2;const t=(o.length+i)/2;n.q3[s]=(o[t]+o[t-1])/2}}return n}function ur(t){const e=t[0].length,r=t.length,n=ir({nbColumns:e,nbRows:r});for(let o=0;o<e;o++){let e=0;for(let n=0;n<r;n++)e+=t[n][o];e/=r;for(let s=0;s<r;s++)n[s][o]=t[s][o]-e}return n}function fr(t){if(0===t.length||0===t[0].length)throw new RangeError("matrix must contain data");const e=t[0].length;for(let r=1;r<t.length;r++)if(t[r].length!==e)throw new RangeError("all rows must has the same length")}function cr(t,e,r){if(r){const n=new Array(e);for(let t=0;t<e;t++)n[r[t]]=t;const o=new Array(t.length);for(let e=0;e<t.length;++e){const[r,s,i]=t[e],[l,h]=[n[r],n[s]];o[e]=h<l?[h,l,i]:[l,h,i]}t=o}else{r=[];for(let t=0;t<e;++t)r[t]=t}const n=new Array(e+1),o=new Array(t.length),s=new Array(t.length),i=[];for(let t=0;t<e;++t)i[t]=0;for(const e of t)i[e[1]]++;n[0]=0;for(let t=0;t<e;++t)n[t+1]=n[t]+i[t];const l=[];for(let t=0;t<e;++t)l[t]=0;for(const e of t){const t=e[1],r=n[t]+l[t];o[r]=e[0],s[r]=e[2],l[t]++}const h=new Array(e),a=new Array(e),u=new Array(e+1),f=new Array(e),c=new Array(e),g=new Array(e),m=new Array(e),w=new Array(e),y=new Array(e);!function(t,e,r,n,o,s,i){for(let n=0;n<t;n++){o[n]=-1,i[n]=n,s[n]=0;const t=n,l=e[t+1];for(let h=e[t];h<l;h++){let t=r[h];if(t<n)for(;i[t]!==n;t=o[t])-1===o[t]&&(o[t]=n),s[t]++,i[t]=n}}n[0]=0;for(let e=0;e<t;e++)n[e+1]=n[e]+s[e]}(e,n,o,u,f,c,g);const p=new Array(u[e]),d=new Array(u[e]),x=function(t,e,r,n,o,s,i,l,h,a,u,f,c){let g,m,w,y,p,d,x,b,M;for(y=0;y<t;y++){for(u[y]=0,M=t,c[y]=y,i[y]=0,d=y,x=e[d+1],p=e[d];p<x;p++)if(w=r[p],w<=y){for(u[w]+=n[p],b=0;c[w]!==y;w=s[w])f[b++]=w,c[w]=y;for(;b>0;)f[--M]=f[--b]}for(a[y]=u[y],u[y]=0;M<t;M++){for(w=f[M],g=u[w],u[w]=0,x=o[w]+i[w],p=o[w];p<x;p++)u[l[p]]-=h[p]*g;m=g/a[w],a[y]-=m*g,l[p]=y,h[p]=m,i[w]++}if(0===a[y])return y}return t}(e,n,o,s,u,f,c,d,p,h,a,m,g);return x===e?t=>(function(t,e,r,n){let o;for(o=0;o<t;o++)e[o]=r[n[o]]}(e,w,t,r),function(t,e,r,n,o){let s,i,l;for(s=0;s<t;s++)for(l=r[s+1],i=r[s];i<l;i++)e[n[i]]-=o[i]*e[s]}(e,w,u,d,p),function(t,e,r){for(let n=0;n<t;n++)e[n]/=r[n]}(e,w,h),function(t,e,r,n,o){let s,i,l;for(s=t-1;s>=0;s--)for(l=r[s+1],i=r[s];i<l;i++)e[s]-=o[i]*e[n[i]]}(e,w,u,d,p),function(t,e,r,n){let o;for(o=0;o<t;o++)e[n[o]]=r[o]}(e,y,w,r),y):null}function gr(t){return t.map(t=>t.slice(0))}function mr(t){const e=new wt(t).transpose(),r=[];for(let t=0;t<e.rows;t++)r.push(new Float64Array(e.rows));for(let t=0;t<e.rows;t++)for(let n=t;n<e.rows;n++){const o=A(e.getRow(t),e.getRow(n));r[t][n]=o,r[n][t]=o}return r}function wr(t,e){const r=new Array(e),n=new Array(e).fill(!1);for(let t=0;t<e;++t)r[t]=[];for(const e of t)r[e[0]].push(e[1]);const o=new Float64Array(e);let s=0,i=0;for(let t=0;t<e;++t)if(!n[t])for(o[s++]=t,n[t]=!0;i<s;){const t=o[i++],e=Float64Array.from(r[t]);e.sort();for(const t of e)n[t]||(n[t]=!0,o[s++]=t)}const l=new Float64Array(e);for(let t=0;t<e;++t)l[o[t]]=t;return l}function yr(t,e){const{startRow:r,endRow:n,startColumn:o,endColumn:s}=e;if(r>n||o>s||r<0||r>=t.length||n<0||n>=t.length||o<0||o>=t[0].length||s<0||s>=t[0].length)throw new RangeError("submatrix indices are out of range")}function pr(t,e){const{startRow:r=0,endRow:n=t.length-1,startColumn:o=0,endColumn:s=t[0].length-1,duplicate:i=!0}=e;yr(t,{startColumn:o,startRow:r,endColumn:s,endRow:n});const l=n-r+1,h=[];if(i)for(let e=0;e<l;e++)h.push(t[r+e].slice(o,s+1));else for(let e=0;e<l;e++)h.push(t[r+e].subarray(o,s+1));return h}function dr(t){if(0===t.length||0===t[0].length)throw new Error("matrixMinMaxAbsoluteZ requires at least 1 row and 1 column");const e=t.length,r=t[0].length;let n=Number.POSITIVE_INFINITY,o=Number.NEGATIVE_INFINITY;for(let s=0;s<r;s++)for(let r=0;r<e;r++){let e=t[r][s];e<0&&(e*=-1),e<n&&(n=e),e>o&&(o=e)}return{min:n,max:o}}function xr(t){fr(t);const e=t.length,r=t[0].length;let n=t[0][0],o=t[0][0];for(let s=0;s<r;s++)for(let r=0;r<e;r++)t[r][s]<n&&(n=t[r][s]),t[r][s]>o&&(o=t[r][s]);return{min:n,max:o}}function br(t,e={}){let{min:r,max:n}=e;const{absolute:o,logBaseX:s,logBaseY:i,histogram:l,nbSlots:h,centerX:a}=e;if(0===t.length||0===t[0].length)throw new Error("matrix must have at least one column and one row");if(void 0===r||void 0===n){const e=o?dr(t):xr(t);void 0===r&&(r=s&&e.min?Math.log(e.min)/Math.log(s):e.min),void 0===n&&(n=s&&e.max?Math.log(e.max)/Math.log(s):e.max)}const u={histogram:l,nbSlots:h,centerX:a,absolute:o,logBaseX:s,min:r,max:n},f=se(t[0],u);u.histogram=f;const c=t.length;for(let e=1;e<c;e++)se(t[e],u);const g=f.y;if(i){const t=Math.log10(i);for(let e=0;e<g.length;e++)g[e]=Math.log10(g[e]+1)/t}return f}function Mr(t){if(0===t.length||0===t[0].length)throw new Error("matrix must have at least 1 row and 1 column");const e=t.length,r=t[0].length;let n=Number.NEGATIVE_INFINITY;for(let o=0;o<r;o++)for(let r=0;r<e;r++){const e=Math.abs(t[r][o]);e>n&&(n=e)}return n}function vr(t){fr(t);const e=t[0].length,r=new Float64Array(t.length*e);for(let n=0;n<t.length;n++){const o=n*e;for(let s=0;s<e;s++)r[o+s]=t[n][s]}return r}function Ar(t){return s(vr(t))}function Er(t){return Oe(vr(t))}function Ir(t,e){const r=gr(t),n=function(t){const e={};for(const r in t)e[t[r]]=r;return e}(e);for(const t of r)for(let e=0;e<r[0].length;e++){const r=t[e];"number"==typeof r&&r in n&&(t[e]=n[r])}return r}function Sr(t){const e=gr(t),r=e.length,n=e[0].length;let o=0;for(let t=0;t<r;t++)for(let r=0;r<n;r++){const n=e[t][r];"number"==typeof n&&n>o&&(o=n)}const s={};for(let t=0;t<r;t++)for(let r=0;r<n;r++){const n=e[t][r];"string"==typeof n&&(n in s?e[t][r]=s[n]:(o++,s[n]=o,e[t][r]=o))}return{matrix:e,dictCategoricalToNumerical:s}}function Nr(t,e={}){const{max:r=100}=e,n=new wt(t);for(let t=0;t<n.rows;t++){const e=n.getRowVector(t).norm("frobenius")/r,o=n.getRowVector(t).div(e);n.setRow(t,o)}const o=[];for(let t=0;t<n.columns;t++){const e=n.getColumn(t);o.push(s(e))}const i=[];for(let t=0;t<n.columns;t++){const e=n.getColumnVector(t).div(o[t]);i.push(s(e.getColumn(0)))}for(let t=0;t<n.rows;t++)n.mulRow(t,1/i[t]);return{data:n.to2DArray(),medianOfQuotients:i}}function Rr(t,e,r,n){yr(t,{startRow:r,endRow:r+e.length-1,startColumn:n,endColumn:n+e[0].length-1});for(let o=0;o<e.length;o++)for(let s=0;s<e[0].length;s++)t[r+o][n+s]=e[o][s];return t}function Fr(t,e={}){const{max:r=1,ArrayConstructor:n}=e,o=t[0].length,s=t.length,i=ir({nbColumns:o,nbRows:s,ArrayConstructor:n}),l=Mr(t);for(let e=0;e<o;e++){const n=r/l;for(let r=0;r<s;r++)i[r][e]=t[r][e]*n}return i}function Tr(t,e={}){const{min:r=0,max:n=1,ArrayConstructor:o}=e,s=t[0].length,i=t.length,l=ir({nbColumns:s,nbRows:i,ArrayConstructor:o}),{min:h,max:a}=xr(t),u=(n-r)/(a-h);for(let e=0;e<s;e++)for(let n=0;n<i;n++)l[n][e]=(t[n][e]-h)*u+r;return l}function _r(t,e={}){const{min:r=0,max:n=1}=e,o=t[0].length,s=t.length,i=ir({nbColumns:o,nbRows:s});for(let e=0;e<o;e++){let o=t[0][e],l=t[0][e];for(let r=1;r<s;r++)t[r][e]<o&&(o=t[r][e]),t[r][e]>l&&(l=t[r][e]);const h=(n-r)/(l-o);for(let n=0;n<s;n++)i[n][e]=(t[n][e]-o)*h+r}return i}function kr(t,e={}){fr(t);const{ArrayConstructor:r}=e,n=t.length,o=t[0].length,s=ir({nbColumns:n,nbRows:o,ArrayConstructor:r});for(let e=0;e<n;e++)for(let r=0;r<o;r++)s[r][e]=t[e][r];return s}function Cr(t,e,r){const n=e.length,o=n-1,s=new Array(t.length),i=new Float64Array(n);for(let n=0;n<o;n++){const o=r[n],l=2*n,h=l+1;s[l]=t[l].slice(),s[h]=t[h].slice(),i[n]=e[n]*o,s[l][2]+=o}return i[o]=e[o]*r[o],s[2*o]=t[2*o].slice(),s[2*o][2]+=r[o],{leftHandSide:s,rightHandSide:i}}function qr(t,e={}){const{lambda:r=100,maxIterations:n=100,tolerance:o=1e-6,factorStd:s=3,learningRate:i=.5,minWeight:l=.01}=e,h=t.length;let{controlPoints:a,weights:u}=function(t,e={}){const{length:r}=t,{controlPoints:n}=e,{weights:o=Float64Array.from({length:r}).fill(1)}=e;if(n&&n.length!==t.length)throw new RangeError("controlPoints should match the length with X");if(o.length!==t.length)throw new RangeError("weights should match the length with X");return{weights:n?y(o,n):o,controlPoints:n}}(t,e);const f=new Float64Array(h);let c=0,g=1/0,m=Et(t);const w=function(t,e){const r=[],n=t-1;for(let t=0;t<n;t++)r.push([t,t,2*e],[t,t+1,-1*e]);return r[0][2]=e,r.push([n,n,e]),r}(h,r);for(;c<n&&g>o;){const{leftHandSide:e,rightHandSide:r}=Cr(w,t,u),n=cr(e,h);if(!n)return m;const o=n(r);u=Gt(t,o,u,{controlPoints:a,minWeight:l,learningRate:i,factorStd:s}),g=Vr(o,f,h),f.set(o),m=Et(o),c++}return m}function Vr(t,e,r){let n=0;for(let o=0;o<r;o++)n+=(t[o]-e[o])**2;return Math.sqrt(n/r)}const Pr=qr;function zr(t,e=0,r=0,n={}){const{reverse:o=!1}=n;e=Number.isFinite(e)?e:0,r=Number.isFinite(r)?r:0;const s=t.re,i=t.im,l=t.re.length;let h=e,a=r/l;o&&(a*=-1,h+=r);const u=2*Math.sin(a/2)**2,f=Math.sin(a);let c=Math.cos(h),g=Math.sin(h);const m=new Float64Array(l),w=new Float64Array(l);for(let t=0;t<l;t++){m[t]=s[t]*c-i[t]*g,w[t]=i[t]*c+s[t]*g;const e=g-(u*g-f*c);c=c-(u*c+f*g),g=e}return{re:m,im:w}}function Or(e,r={}){const{magnitudeMode:n=!0,minRegSize:o=30,factorNoise:s=3,maxDistanceToJoin:i=256,reverse:l=!1}=r,h=function(e,r){const n=r.magnitudeMode?t(e):e.re,o=Dr(function(t){const e=new Float64Array(t.length);for(let r=5;r<t.length-5;r++)e[r]=(42*(t[r+1]-t[r-1])+48*(t[r+2]-t[r-2])+27*(t[r+3]+t[r-3])+8*(t[r+4]-t[r-4])+t[r+5]-t[r-5])/512;for(let r=0;r<5;r++)e[r]=e[5],e[t.length-r-1]=e[t.length-6];return e}(n),r),s=Dr(n,r);return s.map((t,e)=>t&&o[e])}(e,{maxDistanceToJoin:i,magnitudeMode:n,factorNoise:s}),{re:a,im:u}=e,f=a.length,c=l?t=>f-1-t:t=>t;let g=0,m=-1;const w=[];for(;m<f;){const t=[],e=[];for(;!h[c(++m)]&&m<f;)g=m;for(;h[c(m)]&&m<f;m+=2)t.push(a[c(m)]),e.push(u[c(m)]);t.length>o&&w.push(jr(t,e,g))}const{ph1:y,ph0:p}=$r(w.map(t=>t.x0/f),w.map(t=>t.ph0),w.map(t=>t.area/1e11));return{data:zr({re:a,im:u},Lr(p),Lr(y),{reverse:l}),ph0:p,ph1:y}}function $r(t,e,r){if(0===t.length)return{ph0:0,ph1:0};if(1===t.length)return{ph0:e[0],ph1:0};const[n,o]=function(t,e,r){let n=0,o=0,s=0,i=0,l=0;for(let h=0;h<t.length;h++)n+=t[h]*t[h]*r[h],o+=t[h]*r[h],s+=r[h],i+=t[h]*r[h]*e[h],l+=r[h]*e[h];const h=n*s-o*o,a=[[s/h,-o/h],[-o/h,n/h]];return[a[0][0]*i+a[0][1]*l,a[1][0]*i+a[1][1]*l]}(t,e,r);let s=-1,i=Number.MIN_SAFE_INTEGER;for(let r=0;r<t.length;r++){const l=t[r]*n+o,h=Math.abs(e[r]-l);h>34&&i<h&&(s=r,i=h)}return s>-1?(t.splice(s,1),e.splice(s,1),r.splice(s,1),$r(t,e,r)):{ph0:o,ph1:n}}function jr(t,e,r){let n=-180,o=180;let s=10,i=0,l=Number.MAX_SAFE_INTEGER;for(;s>0;){const r=(o-n)/7;for(let s=n;s<=o;s+=r){const r=Yr(zr({re:t,im:e},Lr(s),0).re);r<l&&([l,i]=[r,s])}n=i-r,o=i+r,s--}const h=zr({re:t,im:e},Lr(i),0);let a=0,u=0;for(let e=0;e<t.length;e++)a+=h.re[e],u+=h.re[e]*(e+r);return{ph0:i,area:a,x0:u/a}}function Dr(t,e){const{maxDistanceToJoin:r,magnitudeMode:n,factorNoise:o}=e,s=new Uint8Array(t.length);for(let e=0;e<t.length;e++)s[e]=0;let i=!0;for(;i;){const e=o*Ve(t,{magnitudeMode:n}).positive;i=!1;for(let r=0;r<t.length;r++)Math.abs(t[r])>e&&!s[r]&&(i=!0,s[r]=1)}let l=0,h=0;for(let e=0;e<t.length;e++)if(s[e]){if(l<r)for(let t=0;t<=l;t++)s[h+t]=1;for(;s[++e]&&e<t.length;);h=e,l=0}else l++;return s}function Lr(t){return t*Math.PI/180}function Yr(t){let e=0;for(const r of t)r<0&&(e-=r);return e}function Ur(t,e={}){const{inverse:r=!1,applyZeroShift:n=!1}=e,{re:o,im:s}=t,i=o.length,l=i<<1;let h=new Float64Array(l);for(let t=0;t<l;t+=2)h[t]=o[t>>>1],h[t+1]=s[t>>>1];const a=new Rt(i);let u=new Float64Array(l);r?(n&&(h=Xr(h,!0)),a.inverseTransform(u,h)):(a.transform(u,h),n&&(u=Xr(u)));const f=new Float64Array(i),c=new Float64Array(i);for(let t=0;t<l;t+=2)f[t>>>1]=u[t],c[t>>>1]=u[t+1];return{re:f,im:c}}function Xr(t,e){return Ze(t,e?Math.ceil(t.length/2):Math.floor(t.length/2))}function Wr(t,e){if(!Number.isInteger(e)||e<0)throw new RangeError("totalLength must be a non-negative integer");const{re:r,im:n}=t,o=r.length;if(0===e||o===e)return t;if(o>e)return{re:r.slice(0,e),im:n.slice(0,e)};const s=new Float64Array(e),i=new Float64Array(e);return s.set(r),i.set(n),{re:s,im:i}}function Gr(t,e,r={}){const{delta:n=1,common:o=!0,x:s="x1"}=r,i={x:[],y1:[],y2:[]};let l=0,h=0;const a=t.x.length,u=e.x.length;for(;l<a&&h<u;){let r=0;if("function"==typeof n){r=n((t.x[l]+e.x[h])/2)}else r=n;const f=t.x[l]-e.x[h];if(Math.abs(f)>r)if(f>0){if(!o&&(i.x.push(e.x[h]),i.y1.push(0),i.y2.push(e.y[h]),h===u-1))for(;l<a;)i.x.push(t.x[l]),i.y1.push(t.y[l]),i.y2.push(0),l++;h++}else{if(!o&&(i.x.push(t.x[l]),i.y1.push(t.y[l]),i.y2.push(0),l===a-1))for(;h<u;)i.x.push(e.x[h]),i.y1.push(0),i.y2.push(e.y[h]),h++;l++}else{const r=(t.x[l]*t.y[l]+e.x[h]*e.y[h])/(t.y[l]+e.y[h]);switch(s){case"x1":i.x.push(t.x[l]);break;case"x2":i.x.push(e.x[h]);break;case"weighted":i.x.push(r);break;default:throw new Error(`unknown x option value: ${String(s)}`)}i.y1.push(t.y[l]),i.y2.push(e.y[h]),l++,h++}}return i}function Br(t,e={}){const{minLength:n}=e;if(null===t||"object"!=typeof t||!r(t.x)||!r(t.y))throw new Error("data must be an object of x and y arrays");if(t.x.length!==t.y.length)throw new Error("the x and y arrays must have the same length");if(n&&t.x.length<n)throw new Error(`data.x must have a length of at least ${n}`)}function Qr(t,e={}){const{x:r,y:n}=t,{unbiased:o=!0}=e,s=xt(r),i=xt(n);let l=0;for(let t=0;t<r.length;t++)l+=(r[t]-s)*(n[t]-i);return o?l/(r.length-1):l/r.length}function Jr(t,e={}){Br(t,{minLength:1});const{x:r,y:n}=t;if(1===r.length)return{x:r[0],y:n[0],index:0};const{fromIndex:o,toIndex:s}=c(r,e);let i={x:r[o],y:n[o],index:o};for(let t=o;t<=s;t++)n[t]>i.y&&(i={x:r[t],y:n[t],index:t});return i}const Hr=[.25,.5,.75];function Zr(t){Br(t,{minLength:1});const{x:e,y:r}=t,n=dt(r),o=ne(n);for(let t=0;t<n.length;t++)n[t]/=o;const s={x0:0,x25:0,x50:0,x75:0,x100:0,xMode:0,xMean:0};s.x0=e[0],s.x100=e.at(-1);let i=0;t:for(let t=1;t<n.length;t++)for(;Hr[i]<n[t];){if(s["x"+100*Hr[i]]=e[t-1]+(e[t]-e[t-1])*((Hr[i]-n[t-1])/(n[t]-n[t-1])),i++,i===Hr.length)break t}s.xMode=Jr(t).x;let l=0,h=0;for(let t=0;t<e.length;t++)l+=e[t]*r[t],h+=r[t];return s.xMean=l/h,s}function Kr(t){return{x:Et(t.x),y:Et(t.y)}}function tn(t){if(Br(t),1===le(t.x))return t;const e=Array.from(t.x),r=Array.from(t.y);let n=Number.NEGATIVE_INFINITY,o=0;for(let t=0;t<e.length;t++)n<e[t]&&(o<t&&(e[o]=e[t],r[o]=r[t]),o++,n=e[t]);return e.length=o,r.length=o,{x:e,y:r}}function en(t=[],e={}){const{exclusions:r=[]}=e;let{from:n=Number.NEGATIVE_INFINITY,to:o=Number.POSITIVE_INFINITY}=e;n>o&&([n,o]=[o,n]),(t=t.map(t=>t.from>t.to?{from:t.to,to:t.from}:{...t})).sort((t,e)=>t.from!==e.from?t.from-e.from:t.to-e.to),0===t.length&&t.push({from:n,to:o});for(const e of t)n>e.from&&(e.from=n),o<e.to&&(e.to=o);if(0===(t=t.filter(t=>t.from<=t.to)).length)return[];let s=t[0];const i=[s];for(let e=1;e<t.length;e++){const r=t[e];r.from<=s.to?s.to<r.to&&(s.to=r.to):(s=r,i.push(s))}if(0===r.length)return i;const l=en(r);let h=0;const a=[];for(let t=0;t<i.length;t++){const e=i[t];if(h!==l.length){for(;h<l.length&&l[h].to<=e.from;)h++;if(h!==l.length)if(e.to<l[h].from)a.push(e);else{if(l[h].to>=e.to){if(l[h].from<=e.from)continue;a.push({from:l[h].to,to:e.to})}l[h].from>e.from&&a.push({from:e.from,to:l[h].from}),e.from=l[h].to,t--}else a.push(e)}else a.push(e)}return a}function rn(t=[],e=10,r={}){if(0===t.length)return[];const n=en(t,r),o=[],s=n.reduce((t,e)=>t+(e.to-e.from),0)/e;let i=0;for(let t=0;t<n.length-1;t++){const r=n[t],l=Math.min(Math.round((r.to-r.from)/s),e-i);o.push({...r,numberOfPoints:l}),i+=l}return o.push({...n.at(-1),numberOfPoints:e-i}),o}function nn(t,e,r,n){return.5*r*e*e+n*e-(.5*r*t*t+n*t)}function on(t,e,r,n){return(n-e)/(r-t)}function sn(t,e={}){const{x:r,y:n}=t,o=r.length,{from:s=r[0],to:i=r[o-1],variant:l="smooth",numberOfPoints:h=100,exclusions:a=[],zones:u=[{from:s,to:i}]}=e;if(s>i)throw new RangeError("from should be larger than to");if(Br(t),h<2)throw new RangeError("'numberOfPoints' option must be greater than 1");const f=rn(en(u,{from:s,to:i,exclusions:a}),h,{from:s,to:i}).filter(t=>t.numberOfPoints);let c=[],g=[];for(const t of f){t.numberOfPoints||(t.numberOfPoints=0);const e=ln(Array.from(r),Array.from(n),t.from,t.to,t.numberOfPoints,l);c=c.concat(e.x),g=g.concat(e.y)}return{x:c,y:g}}function ln(t,e,r,n,o,s){if(o<1)throw new RangeError("the number of points must be at least 1");const i="slot"===s?Array.from(function(t,e,r,n,o){const s=t.length;if(s<2)return Float64Array.from(t);const i=(n-r)/(o>1?o-1:1),l=i/2,h=t.at(-1)-t.at(-2),a=r-l,u=new Float64Array(o);let f=a,c=a+i,g=-Number.MAX_VALUE,m=0,w=t[0],y=e[0],p=0,d=!0,x=0,b=0,M=1,v=0;t:for(;;){if(g>=w)throw new Error("x must be a growing series");for(;g-c>0;){if(d&&(b++,d=!1),u[v]=b<=0?0:x/b,v++,v===o)break t;f=c,c+=i,x=0,b=0}g>f&&(x+=m,b++),(g===-Number.MAX_VALUE||p>1)&&b--,g=w,m=y,M<s?(w=t[M],y=e[M],M++):(w+=h,y=0,p++)}return u}(t,e,r,n,o)):Array.from(function(t,e,r,n,o){const s=t.length,i=(n-r)/(o>1?o-1:1),l=i/2,h=new Float64Array(o),a=t[1]-t[0],u=t[s-1]-t[s-2];let f=r-l,c=r+l,g=Number.MIN_SAFE_INTEGER,m=0,w=t[0]-a,y=0,p=0,d=0,x=0,b=0,M=0,v=0,A=0,E=0;t:for(;;){if(g>=w)throw new Error("x must be a growing series");for(g<=f&&f<=w&&(E=nn(0,f-g,d,m),b=p+E);w-c>=0;){if(E=nn(0,c-g,d,m),M=p+E,h[A++]=(M-b)/i,A===o)break t;f=c,c+=i,b=M}p+=nn(g,w,d,x),g=w,m=y,v<s?(w=t[v],y=e[v],v++):v===s&&(w+=u,y=0),d=on(g,m,w,y),x=-d*g+m}return h}(t,e,r,n,o));return{x:Array.from(_t({from:r,to:n,length:o})),y:i}}function hn(t,e={}){Br(t);const{x:r,y:n}=t;let{zones:o}=e;if(o=en(o),void 0===r||void 0===n||!Array.isArray(o)||0===o.length)return t;const s=[],i=[];let l=o[0],h=0;t:for(let t=0;t<r.length;t++){for(;l.to<r[t];)if(h++,l=o[h],!l){t=r.length;break t}r[t]>=l.from&&(s.push(r[t]),i.push(n[t]))}return{x:s,y:i}}function an(t,e={}){const{x:r,y:n}=t,{filter:o}=e,s=[],i=[];for(let t=0;t<r.length;t++)o&&!o(r[t],n[t])||(s.push(r[t]),i.push(n[t]));return{x:s,y:i}}function un(t,e){if(void 0===e)return t;const{x:r,y:n}=t,{min:o,max:s}=xe(n),i=s*e;if(o>=i)return t;const l=[],h=[];for(let t=0;t<r.length;t++)n[t]>=i&&(l.push(r[t]),h.push(n[t]));return{x:l,y:h}}function fn(t,e){if(void 0===e)return t;if(e>t.x.length)return t;const{x:r,y:n}=t,o=[],s=[],i=nr(n.slice()),l=i[e-1];let h=0;for(let t=0;t<e;t++)i[t]===l&&h++;for(let t=0;t<r.length;t++)n[t]>l?(o.push(r[t]),s.push(n[t])):n[t]===l&&(h--,h>=0&&(o.push(r[t]),s.push(n[t])));return{x:o,y:s}}function cn(t,e={}){const{x:r,y:n}=t;if(0===r.length)return{x:Array.from(r),y:Array.from(n)};const{from:o=r[0],to:s=r.at(-1),zones:i=[{from:o,to:s}],exclusions:l=[]}=e,h=en(i,{from:o,to:s,exclusions:l});let a=0;const u=[],f=[];let c=0;for(;c<r.length;){if(r[c]<=h[a].to&&r[c]>=h[a].from)u.push(r[c]),f.push(n[c]);else if(r[c]>h[a].to&&(a++,!h[a]))break;c++}return{x:u,y:f}}function gn(t){Br(t);const{x:e,y:r}=t,n=[],o=[];if(void 0===e||void 0===r)return{x:n,y:o};for(let t=0;t<e.length;t++)e[t]>0&&(n.push(e[t]),o.push(r[t]));return{x:n,y:o}}function mn(t,e){const{x:r,y:n}=t,o=f(r,e);return{x:r[o],y:n[o]}}function wn(t,e){if(Br(t),t.x.length<=e)return t;{const r=new Float64Array(e),n=new Float64Array(e),o=Float64Array.from(t.y);o.sort(),o.reverse();const s=o[e-1];let i=0;for(let o=0;o<t.x.length;o++)if(t.y[o]>=s&&(r[i]=t.x[o],n[i]=t.y[o],i++),i===e)return{x:r,y:n};return t}}function yn(t){const{x:e,y:r}=t;if(e.length!==r.length)throw new TypeError("length of x and y must be identical");return e.length<2||e[0]<e.at(-1)?t:{x:e.toReversed(),y:r.toReversed()}}function pn(t,e={}){const{reverse:r=!1}=e;Br(t,{minLength:1});const{x:n,y:o}=t,{fromIndex:s,toIndex:i}=c(n,e);let l=0;const h={x:new Float64Array(i-s+1),y:new Float64Array(i-s+1)};let a=0;if(r){h.y[a]=0,h.x[a++]=n[i];for(let t=i;t>s;t--)l+=(n[t]-n[t-1])*(o[t-1]+o[t])/2,h.x[a]=n[t-1],h.y[a++]=l;h.x.reverse(),h.y.reverse()}else{h.y[a]=0,h.x[a++]=n[s];for(let t=s;t<i;t++)l+=(n[t+1]-n[t])*(o[t+1]+o[t])/2,h.x[a]=n[t+1],h.y[a++]=l}return h}function dn(t,e={}){Br(t,{minLength:1});const{x:r,y:n}=t;if(1===r.length)return 0;const{fromIndex:o,toIndex:s}=c(r,e);let i=0;for(let t=o;t<s;t++)i+=(r[t+1]-r[t])*(n[t+1]+n[t])/2;return i}function xn(t,e={}){Br(t);const{delta:r=1}=e,n="function"==typeof r,o=Array.from(t.x),s=Array.from(t.y);if(o.length<2)return{x:o,y:s};let i=0;for(let t=1;t<o.length;t++){o[t]-o[t-1]<=(n?r((o[t]+o[t-1])/2):r)?0===s[i]&&0===s[t]||(o[i]=(o[i]*s[i]+o[t]*s[t])/(s[i]+s[t]),s[i]+=s[t]):(i++,o[i]=o[t],s[i]=s[t])}return o.length=i+1,s.length=i+1,{x:o,y:s}}function bn(t,e={}){Br(t,{minLength:1});const{x:r,y:n}=t,{fromIndex:o,toIndex:s}=c(r,e);let i=0,l=0;for(let t=o;t<=s;t++)l+=r[t]*n[t],i+=n[t];if(0===i)throw new Error("Sum of Ys can not be zero.");return l/i}function Mn(t,e={}){Br(t,{minLength:2});const{depth:r=5}=e,{weightedIntegral:n,integral:o}=function(t){const{x:e,y:r}=t,n=new Float64Array(e.length),o=new Float64Array(e.length),s=(e[1]-e[0])*r[0];let i=s;o[0]=i;let l=s*e[0];n[0]=l;for(let t=1;t<e.length-1;t++){const s=(e[t+1]-e[t-1])*r[t]/2,h=e[t];i+=s,o[t]=i,l+=s*h,n[t]=l}const h=(e.at(-1)-e.at(-2))*r.at(-1);return i+=h,o[e.length-1]=i,l+=h*e.at(-1),n[e.length-1]=l,{integral:o,weightedIntegral:n}}(t),s=new Float64Array((1<<r)-1),i=new Int32Array((1<<r)-1);i[0]=t.x.length-1;const l=new Int32Array((1<<r)-1);l[0]=-1;let h=0;for(let e=0;e<r;e++)for(let a=0;a<1<<e;a++){const u=l[h],c=i[h],g=-1===u?o[c]:o[c]-o[u];let m=0;if(m=0!==g?-1===u?n[c]/g:(n[c]-n[u])/g:(t.x[c]+t.x[u])/2,s[h++]=m,e<r-1){const r=(1<<e+1)+2*a-1;let n=f(t.x,m);n===u&&n++,l[r]=u,i[r]=n,n===c&&n--,l[r+1]=n,i[r+1]=c}}return s}function vn(t,e={}){Br(t);const{x:r,y:n}=t,{target:o}=e;let{targetIndex:s}=e;void 0===s&&(s=void 0!==o?f(r,o):0);let i=Number.MIN_SAFE_INTEGER,l=s,h=n[s];for(;l!==i;)i=l,l>0&&n[l-1]>h?l--:l<r.length-1&&n[l+1]>h&&l++,h=n[l];return{x:r[l],y:n[l],index:l}}function An(t,e={}){Br(t,{minLength:2});const{x:r,y:n}=t,{fromIndex:o,toIndex:s}=c(r,e),i=[];let l=-1;for(let t=o+1;t<s;t++)if(n[t-1]<n[t]&&n[t+1]<n[t])i.push({x:r[t],y:n[t],index:t});else if(n[t-1]<n[t]&&n[t+1]===n[t])l=t;else if(n[t-1]===n[t]&&n[t+1]<n[t]){const e=Math.floor((t+l)/2);i.push({x:r[e],y:n[e],index:e})}return i}function En(t,e={}){const{x:r,y:n}=t,{groupWidth:o=.001}=e,s={x:[],y:[]},i={x:[],y:[]};let l=0,h=0;for(;h<r.length;)0===l||r[h]-s.x[l-1]>o?(i.x.push(r[h]),i.y.push(n[h]),s.x.push(r[h]),s.y.push(n[h]),h++,l++):(n[h]>i.y[l-1]&&(i.x[l-1]=r[h],i.y[l-1]=n[h]),s.x[l-1]=r[h],s.y[l-1]+=n[h],h++);return s.x=i.x.slice(),s}function In(t,e={}){Br(t);const{x:r,y:n}=t,{fromIndex:o,toIndex:s}=c(r,e);let i=n[o];for(let t=o;t<=s;t++)n[t]>i&&(i=n[t]);return i}function Sn(t){const{x:e,y:r}=t;let n,o=0,s=0;if(0===e.length)return Number.NaN;if(1===e.length)return e[0];for(n=0;n<r.length;n++)o+=r[n];for(n=0;n<r.length;n++){if(s+=r[n],s>o/2)return e[n];if(s===o/2)return.5*(e[n]+e[n+1])}return Number.NaN}function Nn(t,e,r={}){const{window:n=.01}=r,o={x:Float64Array.from(e),y:new Float64Array(e.length).fill(0)};let s=0,i=0;for(;s<t.x.length&&i<e.length;){const r=t.x[s]-e[i];Math.abs(r)<n?o.y[i]+=t.y[s++]:r<0?s++:i++}return o}function Rn(t,e={}){Br(t);const{x:r,y:n}=t,{target:o}=e;let{targetIndex:s}=e;void 0===s&&(s=void 0!==o?f(r,o):0);let i=Number.MIN_SAFE_INTEGER,l=s,h=n[s];for(;l!==i;)i=l,l>0&&n[l-1]<h?l--:l<r.length-1&&n[l+1]<h&&l++,h=n[l];return{x:r[l],y:n[l],index:l}}function Fn(t,e={}){Br(t,{minLength:2});const{x:r,y:n}=t,{fromIndex:o,toIndex:s}=c(r,e),i=[];let l=-1;for(let t=o+1;t<s;t++)if(n[t-1]>n[t]&&n[t+1]>n[t])i.push({x:r[t],y:n[t],index:t});else if(n[t-1]>n[t]&&n[t+1]===n[t])l=t;else if(n[t-1]===n[t]&&n[t+1]>n[t]){const e=Math.floor((t+l)/2);i.push({x:r[e],y:n[e],index:e})}return i}function Tn(t,e={}){Br(t,{minLength:1});const{x:r,y:n}=t;if(1===r.length)return{x:r[0],y:n[0],index:0};const{fromIndex:o,toIndex:s}=c(r,e);let i={x:r[o],y:n[o],index:o};for(let t=o;t<=s;t++)n[t]<i.y&&(i={x:r[t],y:n[t],index:t});return i}function _n(t,e={}){Br(t);const{x:r,y:n}=t;if(void 0===r||void 0===n||r.length<3)return;const{target:o}=e;let{targetIndex:s}=e;if(void 0===s&&void 0!==o&&(s=f(r,o)),void 0===s)throw new Error("must specify target or targetIndex");let i=s,l=n[i]-n[i+1];const h=l<0?-1:1;for(l*=h;i<r.length-1;){i++;const t=(n[i]-n[i+1])*h;if(t<l)break;l=t}const a={x:r[i],y:n[i]};for(i=s,l=(n[i]-n[i-1])*h;i>1;){i--;const t=(n[i]-n[i-1])*h;if(t<l)break;l=t}const u={x:r[i],y:n[i]};return{inflectionBefore:u,inflectionAfter:a,extrema:{x:r[s],y:n[s]},inflectionMiddle:{x:(u.x+a.x)/2,y:(u.y+a.y)/2},width:Math.abs(u.x-a.x)}}function kn(t,e={}){Br(t);const{x:r,y:n}=t,o=It(r,e);if(n[o-1]>0&&n[o+1]>0&&n[o]>=n[o-1]&&n[o]>=n[o+1]){const t=20*Math.log10(n[o-1]),e=20*Math.log10(n[o]),s=20*Math.log10(n[o+1]),i=.5*(t-s)/(t-2*e+s);return{x:r[o]+(r[o]-r[o-1])*i,y:n[o]-.25*(n[o-1]-n[o+1])*i,index:o}}return{x:r[o],y:n[o],index:o}}function Cn(t,e={}){Br(t);const{x:r,y:n}=t,o=It(r,e);if(n[o-1]<0&&n[o+1]<0&&n[o]<=n[o-1]&&n[o]<=n[o+1]){const t=20*Math.log10(-n[o-1]),e=20*Math.log10(-n[o]),s=20*Math.log10(-n[o+1]),i=.5*(t-s)/(t-2*e+s);return{x:r[o]+(r[o]-r[o-1])*i,y:n[o]-.25*(n[o-1]-n[o+1])*i,index:o}}return{x:r[o],y:n[o],index:o}}function qn(t,e={}){if(Br(t),t.x.length<2)return{x:Float64Array.from(t.x),y:Float64Array.from(t.y)};const{x:r,y:n}=t,{from:o=r[0],to:s=r.at(-1),nbPoints:i=4001,optimize:l=!1}=e;let{zones:h=[]}=e;h=en(h,{from:o,to:s}),0===h.length&&(h=[{from:o,to:s}]);const{internalZones:a,totalPoints:u}=Pn(h,r);if(u<=i)return Vn(r,n,a,u);const f=i/u;let c=0;for(let t=0;t<a.length-1;t++){const e=a[t];e.nbPoints=Math.round(e.nbPoints*f),c+=e.nbPoints}a.at(-1).nbPoints=i-c;const g=[],m=[];for(const t of a)t.nbPoints&&w(t.fromIndex,t.toIndex,t.nbPoints);return{x:g,y:m};function w(t,e,o){if(1===o)return g.push(r[Math.round((e-t)/2)]),void m.push(n[Math.round((e-t)/2)]);if(2===o)return g.push(r[t],r[e]),void m.push(n[t],n[e]);g.push(r[t]),m.push(n[t]),o=o%2==0?o/2+1:(o-1)/2+1;const s=(r[e]-r[t])/(o-1);let i=r[t]+s,h=!0,a=Number.POSITIVE_INFINITY,u=Number.NEGATIVE_INFINITY;for(let o=t+1;o<=e;o++)h?(a=n[o],u=n[o],h=!1):(n[o]<a&&(a=n[o]),n[o]>u&&(u=n[o])),(r[o]>=i||o===e)&&(l?a>m[g.length-1]||(u<m[g.length-1]?u=a:(g.push(i-s/2),m.push(a))):(g.push(i-s/2),m.push(a)),g.push(i),m.push(u),i+=s,h=!0)}}function Vn(t,e,r,n){const o=new Float64Array(n),s=new Float64Array(n);let i=0;for(const n of r)for(let r=n.fromIndex;r<n.toIndex+1;r++)o[i]=t[r],s[i]=e[r],i++;return{x:o,y:s}}function Pn(t,e){const r=[];let n=0;for(const o of t){let t=f(e,o.from),s=f(e,o.to);t>0&&e[t]>o.from&&t--,s<e.length-1&&e[s]<o.to&&s++;const i=s-t+1;r.push({from:o.from,to:o.to,fromIndex:t,toIndex:s,nbPoints:i}),n+=i}return{internalZones:r,totalPoints:n}}function zn(t,e={}){if(Br(t),t.x.length<2)return{x:Float64Array.from(t.x),y:Float64Array.from(t.y)};const{x:r,y:n}=t,{from:o=r[0],to:s=r.at(-1),maxApproximateNbPoints:i=4001}=e;let{zones:l=[]}=e;l=en(l,{from:o,to:s}),0===l.length&&(l=[{from:o,to:s}]);const{internalZones:h,totalPoints:a}=Pn(l,r);if(a<=i)return Vn(r,n,h,a);const u=(s-o)/(i-1),f=[],c=[];for(const t of h){const e=Math.ceil((t.to-t.from)/u)+1,o=t.fromIndex,s=t.toIndex;if(s-o+1<=e)for(let t=o;t<=s;t++)f.push(r[t]),c.push(n[t]);else{let t=r[o],e=n[o],i=t+u;f.push(t),c.push(e);for(let l=o;l<=s;l++)r[l]>i&&(t=r[l],e=n[l],f.push(t),c.push(e),i+=u),n[l]>e&&(e=n[l],c[c.length-1]=e)}}return{x:f,y:c}}function On(t,e,r={}){let{x:n,y:o}=t;return o=Ge(o,e,r),n.length!==o.length&&(n=Be(n,r)),{x:n,y:o}}function $n(t,e={}){const{x:r}=t;let{y:n}=t;const{radius:o=1,position:s="top",shifted:i=!0}=e;if("top"!==s&&"bottom"!==s)throw new Error(`Invalid position: ${String(s)}`);if("bottom"===s){n=n.slice();for(let t=0;t<n.length;t++)n[t]=-n[t]}if(0===r.length||0===n.length)return new Float64Array;const l=new Float64Array(r.length);for(let t=0;t<r.length;t++){const e=r[t],s=f(r,e-o),i=f(r,e+o);let h=n[t]+o;for(let t=s;t<=i;t++){const s=r[t];if(s<e-o||s>e+o)continue;const i=n[t]+Math.sqrt(o**2-(s-e)**2);i>h&&(h=i)}l[t]=h}if(!i)for(let t=0;t<l.length;t++)l[t]-=o;if("bottom"===s)for(let t=0;t<l.length;t++)l[t]=-l[t];return l}function jn(t,e={}){Br(t);const{x:r,y:n}=t,{value:o=0}=e;let{zones:s}=e;if(!Array.isArray(s)||0===s.length)return t;s=en(s);const i=r.slice(),l=n.slice();let h=s[0],a=0;t:for(let t=0;t<r.length;t++){for(;h.to<r[t];)if(a++,h=s[a],!h){t=r.length;break t}r[t]>=h.from&&(l[t]=o)}return{x:i,y:l}}function Dn(t){const{x:e,y:r}=t;if(le(e)&&e.length>1){const t=Float64Array.from(e),n=Float64Array.from(r);return t.at(-1)<t[0]&&(t.reverse(),n.reverse()),{x:t,y:n}}const n=Array.from(e,(t,e)=>({x:t,y:r[e]}));n.sort((t,e)=>t.x-e.x);const o={x:new Float64Array(e.length),y:new Float64Array(r.length)};for(let t=0;t<e.length;t++)o.x[t]=n[t].x,o.y[t]=n[t].y;return o}function Ln(t){Br(t);const{x:e,y:r}=t,n=[];for(let t=0;t<e.length;t++)n.push([e[t],r[t]]);return n}function Yn(t){Br(t);const{x:e,y:r}=t,n=[];for(let t=0;t<e.length;t++)n.push({x:e[t],y:r[t]});return n}function Un(t,e={}){if(Br(t),0===t.x.length)return{x:[],y:[]};const{algorithm:r="average",isSorted:n=!0}=e;switch(n||(t=Dn(t)),r){case"average":return function(t){const e=[],r=[];let n=t.y[0],o=1;for(let s=1;s<t.x.length;s++)t.x[s]!==t.x[s-1]&&(e.push(t.x[s-1]),r.push(n/o),n=0,o=0),n+=t.y[s],o++;return e.push(t.x.at(-1)),r.push(n/o),{x:e,y:r}}(t);case"sum":return function(t){const e=[],r=[];let n=t.y[0];for(let o=1;o<t.x.length;o++)t.x[o]!==t.x[o-1]&&(e.push(t.x[o-1]),r.push(n),n=0),n+=t.y[o];return e.push(t.x.at(-1)),r.push(n),{x:e,y:r}}(t);default:throw new Error(`unknown algorithm: ${String(r)}`)}}function Xn(t,e={}){const{x:r,y:n}=t,{groupWidth:o=.001}=e,s={x:[],y:[]},i={x:[],y:[]};let l=0,h=0;for(;h<r.length;)0===l||r[h]-s.x[l-1]>o?(i.x.push(r[h]*n[h]),i.y.push(n[h]),s.x.push(r[h]),s.y.push(n[h]),h++,l++):(i.x[l-1]+=r[h]*n[h],i.y[l-1]+=n[h],s.x[l-1]=r[h],s.y[l-1]+=n[h],h++);for(let t=0;t<s.x.length;t++)s.x[t]=i.x[t]/i.y[t];return s}function Wn(t){const e={x:[],y:[]};for(const r of t)e.x.push(r[0]),e.y.push(r[1]);return e}function Gn(t){const{x:e,re:r,im:n}=t;if(e.length!==r.length||e.length!==n.length)throw new TypeError("length of x, re and im must be identical");return e.length<2||e[0]<e[1]?t:{x:e.toReversed(),re:r.toReversed(),im:n.toReversed()}}function Bn(t,e){const{x:r,re:n,im:o}=t,s=r.length;if(0===e||s===e)return t;if(s>e)return{x:r.slice(0,e),re:n.slice(0,e),im:o.slice(0,e)};const i=new Float64Array(e);i.set(r);const l=(r.at(-1)-r[0])/(s-1);for(let t=s;t<e;t++)i[t]=i[t-1]+l;return{x:i,...Wr({re:n,im:o},e)}}function Qn(t,e={}){const{delta:r=1}=e,n="function"==typeof r,o=Float64Array.from(t.flatMap(t=>t.x));if(o.sort(),0===o.length)throw new Error("can not process empty arrays");let s={from:o[0],to:o[0],average:o[0],sum:o[0],number:1};const i=[s];for(let t=1;t<o.length;t++){const e=n?r(o[t]):r;o[t]-s.to<=e?(s.to=o[t],s.number++,s.sum+=o[t],s.average=s.sum/s.number):(s={from:o[t],to:o[t],average:o[t],sum:o[t],number:1},i.push(s))}return i}function Jn(t,e={}){const{delta:r=1,requiredY:n=!1}=e,o=Qn(t=t.map(t=>xn(t,{delta:r})),{delta:r}),s=Float64Array.from(o.map(t=>t.average)),i=Array.from(t,()=>new Float64Array(s.length)),l=new Uint32Array(t.length);for(let e=0;e<o.length;e++){const r=o[e];for(let n=0;n<t.length;n++){const o=t[n];for(;l[n]<o.x.length&&o.x[l[n]]<=r.to;)i[n][e]+=o.y[l[n]],l[n]++}}return n?function(t,e){const r=[],n=Array.from(e,()=>[]);for(let o=0;o<t.length;o++)if(e.every(t=>0!==t[o])){r.push(t[o]);for(let t=0;t<e.length;t++)n[t].push(e[t][o])}return{x:r,ys:n}}(s,i):{x:s,ys:i}}function Hn(t,e={}){let{delta:r=1}=e;if("number"==typeof r){const t=r;r=()=>t}if(0===(t=t.filter(t=>t.x.length>0)).length)return{x:[],y:[]};const n=[],o=[],s=new Array(t.length).fill(0),i={x:0,y:0};Zn(t,s,i);const l={maxX:i.x+r(i.x),sumY:i.y,sumXY:i.y*i.x};for(;t.length>0;){Zn(t,s,i);i.x<=l.maxX||(l.sumY>0&&(n.push(l.sumXY/l.sumY),o.push(l.sumY)),l.sumY=0,l.sumXY=0),l.sumY+=i.y,l.sumXY+=i.x*i.y,l.maxX=i.x+r(i.x),0===t.length&&l.sumY>0&&(n.push(l.sumXY/l.sumY),o.push(l.sumY))}return{x:n,y:o}}function Zn(t,e,r){let n=0,o=t[0].x[e[0]];for(let r=1;r<t.length;r++){const s=t[r].x[e[r]];s<o&&(o=s,n=r)}r.x=o,r.y=t[n].y[e[n]],e[n]++,e[n]===t[n].x.length&&(e.splice(n,1),t.splice(n,1))}function Kn(t,e={}){const{delta:r=1}=e,n=function(t,e={}){const{delta:r=1}=e,n="function"==typeof r,o=t[0].x,s=[];for(const t of o){const e=n?r(t):r;s.push({from:t-e,to:t+e,value:t})}const i=Hn(t.slice(1),e).x;let l=0;for(const t of s)for(;i[l]<t.to&&l<i.length;){if(i[l]<t.from){const t=n?r(i[l]):r;s.push({from:i[l]-t,to:i[l]+t,value:i[l]})}l++}for(let t=l;t<i.length;t++){const e=n?r(i[t]):r;s.push({from:i[t]-e,to:i[t]+e,value:i[t]})}s.sort((t,e)=>t.value-e.value);for(let t=0;t<s.length-1;t++)if(s[t].to>s[t+1].from){const e=(s[t].value+s[t+1].value)/2;s[t].to=e,s[t+1].from=e}return s}(t,{delta:r}),o=Float64Array.from(n.map(t=>t.value)),s=Array.from(t,()=>new Float64Array(o.length)),i=new Uint32Array(t.length);for(let e=0;e<n.length;e++){const r=n[e];for(let n=0;n<t.length;n++){const o=t[n];for(;i[n]<o.x.length&&o.x[i[n]]<r.to;)s[n][e]+=o.y[i[n]],i[n]++}}return{x:o,ys:s}}function to(t,e={}){const{delta:r=1}=e,n=Qn(t=t.map(t=>xn(t,{delta:r})),{delta:r}),o=Float64Array.from(n.map(t=>t.average)),s=new Float64Array(o.length),i=new Uint32Array(t.length);for(let e=0;e<n.length;e++){const r=n[e];for(let n=0;n<t.length;n++){const o=t[n];for(;i[n]<o.x.length&&o.x[i[n]]<=r.to;)s[e]+=o.y[i[n]],i[n]++}}return{x:o,y:s}}function eo(t,e={}){const{minLength:r=0}=e;if(!Array.isArray(t))throw new Error("points must be an array of {x,y} objects");if(t.length>0&&("number"!=typeof t[0].x||"number"!=typeof t[0].y))throw new Error("points must be an array of {x,y} objects");if(r&&t.length<r)throw new Error(`points must have a length of at least ${r}`)}function ro(t=[]){if(eo(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].x>e.x&&(e={x:t[r].x,y:t[r].y,index:r});return e}function no(t=[]){if(eo(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].x<e.x&&(e={x:t[r].x,y:t[r].y,index:r});return e}function oo(t,e={}){const{from:r=no(t).x,to:n=ro(t).x,limit:o=20,threshold:s=.01,numberCloseSlots:i=50,numberSlots:l=10}=e,h=(n-r)/l,a=(n-r)/i,u=t.filter(t=>t.x>=r&&t.x<=n).map(t=>({point:t}));u.sort((t,e)=>e.point.y-t.point.y);const f=[];if(0===u.length)return[];const c=u[0].point.y*s;t:for(const t of u){if(t.point.y<c)break;let e=!1;for(const r of f){if(Math.abs(r.x-t.point.x)<a)continue t;Math.abs(r.x-t.point.x)<h&&(e=!0)}const r={...t.point,close:e};if(f.push(r),f.length===o)break}return f.sort((t,e)=>t.x-e.x),f}function so(t,e={}){const{xError:r=Number.EPSILON}=e,n=[];let o={x:Number.MIN_SAFE_INTEGER,y:0};for(const e of t)e.x-o.x<=r?0===o.y&&0===e.y||(o.x=e.y/(o.y+e.y)*(e.x-o.x)+o.x,o.y+=e.y):(o={x:e.x,y:e.y},n.push(o));return n}function io(t=[]){if(eo(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].y>e.y&&(e={x:t[r].x,y:t[r].y,index:r});return e}function lo(t){eo(t,{minLength:1});let e=t[0].x,r=e,n=t[0].y,o=n;for(const s of t)s.x<e&&(e=s.x),s.x>r&&(r=s.x),s.y<n&&(n=s.y),s.y>o&&(o=s.y);return{minX:e,maxX:r,minY:n,maxY:o}}function ho(t=[]){if(eo(t),0===t.length)return{x:0,y:0};let e={x:t[0].x,y:t[0].y,index:0};for(let r=1;r<t.length;r++)t[r].y<e.y&&(e={x:t[r].x,y:t[r].y,index:r});return e}function ao(t,e){const r=De((t=structuredClone(t)).map(t=>t.y),e);for(let e=0;e<t.length;e++)t[e].y=r[e];return t}function uo(t,e={}){const{slotWidth:r=1}=e,n=r/2,o=[];let s={x:Number.NEGATIVE_INFINITY,y:0};for(const e of t){const t=e.x-(e.x+n)%r+n;Math.abs(s.x-t)>Number.EPSILON&&(s={x:t,y:0},o.push(s)),s.y+=e.y}return o}function fo(t){return t.sort((t,e)=>t.x-e.x),t}function co(t=[]){eo(t);let e=0;for(const r of t)e+=r.y;return e}function go(t){return{x:t.map(t=>t.x),y:t.map(t=>t.y)}}export{Gt as calculateAdaptiveWeights,Tt as createDoubleArray,_t as createFromToArray,Ft as createNumberArray,Vt as createRandomArray,zt as createStepArray,n as getOutputArray,Ot as getRescaler,$t as isPowerOfTwo,sr as matrixAbsoluteMedian,lr as matrixApplyNumericalEncoding,hr as matrixAutoCorrelation,ar as matrixBoxPlot,ur as matrixCenterZMean,fr as matrixCheck,cr as matrixCholeskySolver,gr as matrixClone,mr as matrixColumnsCorrelation,ir as matrixCreateEmpty,wr as matrixCuthillMckee,pr as matrixGetSubMatrix,br as matrixHistogram,Mr as matrixMaxAbsoluteZ,Ar as matrixMedian,dr as matrixMinMaxAbsoluteZ,xr as matrixMinMaxZ,Er as matrixNoiseStandardDeviation,Ir as matrixNumericalDecoding,Sr as matrixNumericalEncoding,Nr as matrixPQN,Rr as matrixSetSubMatrix,vr as matrixToArray,kr as matrixTranspose,Fr as matrixZPivotRescale,Tr as matrixZRescale,_r as matrixZRescalePerColumn,jt as nextPowerOfTwo,Bt as recursiveRemoveEmptyAndNull,Dt as recursiveResolve,Yt as recursiveUntypeArrays,t as reimAbsolute,Or as reimAutoPhaseCorrection,Ur as reimFFT,zr as reimPhaseCorrection,Wr as reimZeroFilling,Xt as stringify,o as xAbsolute,a as xAbsoluteMedian,g as xAbsoluteSum,m as xAdd,w as xApplyFunctionStr,x as xAutoCorrelation,b as xBoxPlot,M as xBoxPlotWithOutliers,u as xCheck,v as xCheckLengths,A as xCorrelation,pt as xCostMatrix,d as xCrossCorrelation,dt as xCumulative,vt as xDistributionStats,At as xDivide,p as xDotProduct,Et as xEnsureFloat64,f as xFindClosestIndex,c as xGetFromToIndex,It as xGetTargetIndex,te as xHilbertTransform,se as xHistogram,ie as xIsEquallySpaced,le as xIsMonotonic,he as xMassCenterVectorSimilarity,fe as xMaxAbsoluteValue,ce as xMaxIndex,ne as xMaxValue,xt as xMean,ge as xMeanAbsoluteError,me as xMeanSquaredError,we as xMeanWeighted,s as xMedian,ye as xMedianAbsoluteDeviation,pe as xMinIndex,de as xMinMaxDelta,xe as xMinMaxValues,oe as xMinValue,be as xMode,y as xMultiply,Ve as xNoiseSanPlot,Oe as xNoiseStandardDeviation,$e as xNorm,De as xNormed,Le as xPadding,Ye as xParetoNormalization,Xe as xRemoveOutliersIQR,We as xRescale,Ue as xRobustDistributionStats,Ge as xRolling,Be as xRollingAverage,Qe as xRollingMax,Je as xRollingMedian,He as xRollingMin,Ze as xRotate,Ke as xSampling,tr as xSequentialFillFromStep,er as xSequentialFillFromTo,rr as xSortAscending,nr as xSortDescending,Mt as xStandardDeviation,Wt as xSubtract,je as xSum,or as xUniqueSorted,bt as xVariance,Pr as xWhitakerSmoother,qr as xWhittakerSmoother,Gn as xreimSortX,Bn as xreimZeroFilling,Wn as xy2ToXY,Gr as xyAlign,Jn as xyArrayAlign,Kn as xyArrayAlignToFirst,to as xyArrayMerge,Hn as xyArrayWeightedMerge,Br as xyCheck,Qr as xyCovariance,Zr as xyCumulativeDistributionStatistics,Kr as xyEnsureFloat64,tn as xyEnsureGrowingX,sn as xyEquallySpaced,hn as xyExtract,an as xyFilter,un as xyFilterMinYValue,fn as xyFilterTopYValues,cn as xyFilterX,gn as xyFilterXPositive,mn as xyFindClosestPoint,wn as xyGetNMaxY,yn as xyGrowingX,pn as xyIntegral,dn as xyIntegration,xn as xyJoinX,bn as xyMassCenter,Mn as xyMassCenterVector,vn as xyMaxClosestYPoint,En as xyMaxMerge,In as xyMaxY,Jr as xyMaxYPoint,An as xyMaximaY,Sn as xyMedian,Nn as xyMergeByCentroids,Rn as xyMinClosestYPoint,Tn as xyMinYPoint,Fn as xyMinimaY,oo as xyObjectBestPoints,eo as xyObjectCheck,so as xyObjectJoinX,ro as xyObjectMaxXPoint,io as xyObjectMaxYPoint,lo as xyObjectMinMaxValues,no as xyObjectMinXPoint,ho as xyObjectMinYPoint,ao as xyObjectNormedY,uo as xyObjectSlotX,fo as xyObjectSortX,co as xyObjectSumY,go as xyObjectToXY,_n as xyPeakInfo,kn as xyRealMaxYPoint,Cn as xyRealMinYPoint,qn as xyReduce,zn as xyReduceNonContinuous,On as xyRolling,$n as xyRollingCircleTransform,jn as xySetYValue,Dn as xySortX,Ln as xyToXYArray,Yn as xyToXYObject,Un as xyUniqueX,Xn as xyWeightedMerge,en as zonesNormalize,rn as zonesWithPoints};
//# sourceMappingURL=ml-spectra-processing.esm.min.js.map
