/* image-js 1.3.0 | MIT | https://github.com/image-js/image-js#readme */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).IJS={})}(this,function(exports){"use strict";var _documentCurrentScript="undefined"!=typeof document?document.currentScript:null;function getDefaultExportFromCjs(t){return t&&t.__esModule&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t}function getAugmentedNamespace(t){if(Object.prototype.hasOwnProperty.call(t,"__esModule"))return t;var e=t.default;if("function"==typeof e){var r=function t(){var r=!1;try{r=this instanceof t}catch{}return r?Reflect.construct(e,arguments,this.constructor):e.apply(this,arguments)};r.prototype=e.prototype}else r={};return Object.defineProperty(r,"__esModule",{value:!0}),Object.keys(t).forEach(function(e){var n=Object.getOwnPropertyDescriptor(t,e);Object.defineProperty(r,e,n.get?n:{enumerable:!0,get:function(){return t[e]}})}),r}var matrix={};const toString$2=Object.prototype.toString;function isAnyArray$1(t){const e=toString$2.call(t);return e.endsWith("Array]")&&!e.includes("Big")}var libEsm=Object.freeze({__proto__:null,isAnyArray:isAnyArray$1}),require$$0=getAugmentedNamespace(libEsm);function max$1(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var r=e.fromIndex,n=void 0===r?0:r,i=e.toIndex,o=void 0===i?t.length:i;if(n<0||n>=t.length||!Number.isInteger(n))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=n||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var s=t[n],a=n+1;a<o;a++)t[a]>s&&(s=t[a]);return s}function min$1(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var r=e.fromIndex,n=void 0===r?0:r,i=e.toIndex,o=void 0===i?t.length:i;if(n<0||n>=t.length||!Number.isInteger(n))throw new Error("fromIndex must be a positive integer smaller than length");if(o<=n||o>t.length||!Number.isInteger(o))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var s=t[n],a=n+1;a<o;a++)t[a]<s&&(s=t[a]);return s}function rescale$1(t){var e,r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!isAnyArray$1(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==r.output){if(!isAnyArray$1(r.output))throw new TypeError("output option must be an array if specified");e=r.output}else e=new Array(t.length);var n=min$1(t),i=max$1(t);if(n===i)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var o=r.min,s=void 0===o?r.autoMinMax?n:0:o,a=r.max,l=void 0===a?r.autoMinMax?i:1:a;if(s>=l)throw new RangeError("min option must be smaller than max option");for(var h=(l-s)/(i-n),c=0;c<t.length;c++)e[c]=(t[c]-n)*h+s;return e}var libEs6=Object.freeze({__proto__:null,default:rescale$1}),require$$1=getAugmentedNamespace(libEs6);Object.defineProperty(matrix,"__esModule",{value:!0});var isAnyArray=require$$0,rescale=require$$1;const indent=" ".repeat(2),indentData=" ".repeat(4);function inspectMatrix(){return inspectMatrixWithOptions(this)}function inspectMatrixWithOptions(t,e={}){const{maxRows:r=15,maxColumns:n=10,maxNumSize:i=8,padMinus:o="auto"}=e;return`${t.constructor.name} {\n${indent}[\n${indentData}${inspectData(t,r,n,i,o)}\n${indent}]\n${indent}rows: ${t.rows}\n${indent}columns: ${t.columns}\n}`}function inspectData(t,e,r,n,i){const{rows:o,columns:s}=t,a=Math.min(o,e),l=Math.min(s,r),h=[];if("auto"===i){i=!1;t:for(let e=0;e<a;e++)for(let r=0;r<l;r++)if(t.get(e,r)<0){i=!0;break t}}for(let e=0;e<a;e++){let r=[];for(let o=0;o<l;o++)r.push(formatNumber(t.get(e,o),n,i));h.push(`${r.join(" ")}`)}return l!==s&&(h[h.length-1]+=` ... ${s-r} more columns`),a!==o&&h.push(`... ${o-e} more rows`),h.join(`\n${indentData}`)}function formatNumber(t,e,r){return(t>=0&&r?` ${formatNumber2(t,e-1)}`:formatNumber2(t,e)).padEnd(e)}function formatNumber2(t,e){let r=t.toString();if(r.length<=e)return r;let n=t.toFixed(e);if(n.length>e&&(n=t.toFixed(Math.max(0,e-(n.length-e)))),n.length<=e&&!n.startsWith("0.000")&&!n.startsWith("-0.000"))return n;let i=t.toExponential(e);return i.length>e&&(i=t.toExponential(Math.max(0,e-(i.length-e)))),i.slice(0)}function installMathOperations(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t.get(e,r));return this},t.add=function(t,r){return new e(t).add(r)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t.get(e,r));return this},t.sub=function(t,r){return new e(t).sub(r)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t.get(e,r));return this},t.mul=function(t,r){return new e(t).mul(r)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t.get(e,r));return this},t.div=function(t,r){return new e(t).div(r)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t.get(e,r));return this},t.mod=function(t,r){return new e(t).mod(r)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t.get(e,r));return this},t.and=function(t,r){return new e(t).and(r)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t.get(e,r));return this},t.or=function(t,r){return new e(t).or(r)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t.get(e,r));return this},t.xor=function(t,r){return new e(t).xor(r)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t.get(e,r));return this},t.leftShift=function(t,r){return new e(t).leftShift(r)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t.get(e,r));return this},t.signPropagatingRightShift=function(t,r){return new e(t).signPropagatingRightShift(r)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t.get(e,r));return this},t.rightShift=function(t,r){return new e(t).rightShift(r)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,r){return new e(t).pow(r)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t);return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t.get(e,r));return this}}function checkRowIndex(t,e,r){let n=r?t.rows:t.rows-1;if(e<0||e>n)throw new RangeError("Row index out of range")}function checkColumnIndex(t,e,r){let n=r?t.columns:t.columns-1;if(e<0||e>n)throw new RangeError("Column index out of range")}function checkRowVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function checkColumnVector(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function checkRowIndices(t,e){if(!isAnyArray.isAnyArray(e))throw new TypeError("row indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.rows)throw new RangeError("row indices are out of range")}function checkColumnIndices(t,e){if(!isAnyArray.isAnyArray(e))throw new TypeError("column indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.columns)throw new RangeError("column indices are out of range")}function checkRange$1(t,e,r,n,i){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(checkNumber("startRow",e),checkNumber("endRow",r),checkNumber("startColumn",n),checkNumber("endColumn",i),e>r||n>i||e<0||e>=t.rows||r<0||r>=t.rows||n<0||n>=t.columns||i<0||i>=t.columns)throw new RangeError("Submatrix indices are out of range")}function newArray(t,e=0){let r=[];for(let n=0;n<t;n++)r.push(e);return r}function checkNumber(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function checkNonEmpty(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}function sumByRow(t){let e=newArray(t.rows);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[r]+=t.get(r,n);return e}function sumByColumn(t){let e=newArray(t.columns);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[n]+=t.get(r,n);return e}function sumAll(t){let e=0;for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)e+=t.get(r,n);return e}function productByRow(t){let e=newArray(t.rows,1);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[r]*=t.get(r,n);return e}function productByColumn(t){let e=newArray(t.columns,1);for(let r=0;r<t.rows;++r)for(let n=0;n<t.columns;++n)e[n]*=t.get(r,n);return e}function productAll(t){let e=1;for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)e*=t.get(r,n);return e}function varianceByRow(t,e,r){const n=t.rows,i=t.columns,o=[];for(let s=0;s<n;s++){let n=0,a=0,l=0;for(let e=0;e<i;e++)l=t.get(s,e)-r[s],n+=l,a+=l*l;e?o.push((a-n*n/i)/(i-1)):o.push((a-n*n/i)/i)}return o}function varianceByColumn(t,e,r){const n=t.rows,i=t.columns,o=[];for(let s=0;s<i;s++){let i=0,a=0,l=0;for(let e=0;e<n;e++)l=t.get(e,s)-r[s],i+=l,a+=l*l;e?o.push((a-i*i/n)/(n-1)):o.push((a-i*i/n)/n)}return o}function varianceAll(t,e,r){const n=t.rows,i=t.columns,o=n*i;let s=0,a=0,l=0;for(let e=0;e<n;e++)for(let n=0;n<i;n++)l=t.get(e,n)-r,s+=l,a+=l*l;return e?(a-s*s/o)/(o-1):(a-s*s/o)/o}function centerByRow(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e[r])}function centerByColumn(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e[n])}function centerAll(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)-e)}function getScaleByRow(t){const e=[];for(let r=0;r<t.rows;r++){let n=0;for(let e=0;e<t.columns;e++)n+=t.get(r,e)**2/(t.columns-1);e.push(Math.sqrt(n))}return e}function scaleByRow(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e[r])}function getScaleByColumn(t){const e=[];for(let r=0;r<t.columns;r++){let n=0;for(let e=0;e<t.rows;e++)n+=t.get(e,r)**2/(t.rows-1);e.push(Math.sqrt(n))}return e}function scaleByColumn(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e[n])}function getScaleAll(t){const e=t.size-1;let r=0;for(let n=0;n<t.columns;n++)for(let i=0;i<t.rows;i++)r+=t.get(i,n)**2/e;return Math.sqrt(r)}function scaleAll(t,e){for(let r=0;r<t.rows;r++)for(let n=0;n<t.columns;n++)t.set(r,n,t.get(r,n)/e)}class AbstractMatrix{static from1DArray(t,e,r){if(t*e!==r.length)throw new RangeError("data length does not match given dimensions");let n=new Matrix$2(t,e);for(let i=0;i<t;i++)for(let t=0;t<e;t++)n.set(i,t,r[i*e+t]);return n}static rowVector(t){let e=new Matrix$2(1,t.length);for(let r=0;r<t.length;r++)e.set(0,r,t[r]);return e}static columnVector(t){let e=new Matrix$2(t.length,1);for(let r=0;r<t.length;r++)e.set(r,0,t[r]);return e}static zeros(t,e){return new Matrix$2(t,e)}static ones(t,e){return new Matrix$2(t,e).fill(1)}static rand(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{random:n=Math.random}=r;let i=new Matrix$2(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++)i.set(r,t,n());return i}static randInt(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{min:n=0,max:i=1e3,random:o=Math.random}=r;if(!Number.isInteger(n))throw new TypeError("min must be an integer");if(!Number.isInteger(i))throw new TypeError("max must be an integer");if(n>=i)throw new RangeError("min must be smaller than max");let s=i-n,a=new Matrix$2(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++){let e=n+Math.round(o()*s);a.set(r,t,e)}return a}static eye(t,e,r){void 0===e&&(e=t),void 0===r&&(r=1);let n=Math.min(t,e),i=this.zeros(t,e);for(let t=0;t<n;t++)i.set(t,t,r);return i}static diag(t,e,r){let n=t.length;void 0===e&&(e=n),void 0===r&&(r=e);let i=Math.min(n,e,r),o=this.zeros(e,r);for(let e=0;e<i;e++)o.set(e,e,t[e]);return o}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,n=t.columns,i=new Matrix$2(r,n);for(let o=0;o<r;o++)for(let r=0;r<n;r++)i.set(o,r,Math.min(t.get(o,r),e.get(o,r)));return i}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,n=t.columns,i=new this(r,n);for(let o=0;o<r;o++)for(let r=0;r<n;r++)i.set(o,r,Math.max(t.get(o,r),e.get(o,r)));return i}static checkMatrix(t){return AbstractMatrix.isMatrix(t)?t:new Matrix$2(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.call(this,e,r);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.push(this.get(e,r));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let r=0;r<this.columns;r++)t[e].push(this.get(e,r))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let t=0;t<this.rows;t++)if(0!==this.get(t,t))return!1;return!0}isEchelonForm(){let t=0,e=0,r=-1,n=!0,i=!1;for(;t<this.rows&&n;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(i=!0,r=e):(n=!1,i=!0);t++}return n}isReducedEchelonForm(){let t=0,e=0,r=-1,n=!0,i=!1;for(;t<this.rows&&n;){for(e=0,i=!1;e<this.columns&&!1===i;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(i=!0,r=e):(n=!1,i=!0);for(let r=e+1;r<this.rows;r++)0!==this.get(t,r)&&(n=!1);t++}return n}echelonForm(){let t=this.clone(),e=0,r=0;for(;e<t.rows&&r<t.columns;){let n=e;for(let i=e;i<t.rows;i++)t.get(i,r)>t.get(n,r)&&(n=i);if(0===t.get(n,r))r++;else{t.swapRows(e,n);let i=t.get(e,r);for(let n=r;n<t.columns;n++)t.set(e,n,t.get(e,n)/i);for(let n=e+1;n<t.rows;n++){let i=t.get(n,r)/t.get(e,r);t.set(n,r,0);for(let o=r+1;o<t.columns;o++)t.set(n,o,t.get(n,o)-t.get(e,o)*i)}e++,r++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,r=t.rows,n=r-1;for(;n>=0;)if(0===t.maxRow(n))n--;else{let i=0,o=!1;for(;i<r&&!1===o;)1===t.get(n,i)?o=!0:i++;for(let r=0;r<n;r++){let o=t.get(r,i);for(let s=i;s<e;s++){let e=t.get(r,s)-o*t.get(n,s);t.set(r,s,e)}}n--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:r=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(r)||r<=0)throw new TypeError("columns must be a positive integer");let n=new Matrix$2(this.rows*e,this.columns*r);for(let t=0;t<e;t++)for(let e=0;e<r;e++)n.setSubMatrix(this,this.rows*t,this.columns*e);return n}fill(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,t);return this}neg(){return this.mulS(-1)}getRow(t){checkRowIndex(this,t);let e=[];for(let r=0;r<this.columns;r++)e.push(this.get(t,r));return e}getRowVector(t){return Matrix$2.rowVector(this.getRow(t))}setRow(t,e){checkRowIndex(this,t),e=checkRowVector(this,e);for(let r=0;r<this.columns;r++)this.set(t,r,e[r]);return this}swapRows(t,e){checkRowIndex(this,t),checkRowIndex(this,e);for(let r=0;r<this.columns;r++){let n=this.get(t,r);this.set(t,r,this.get(e,r)),this.set(e,r,n)}return this}getColumn(t){checkColumnIndex(this,t);let e=[];for(let r=0;r<this.rows;r++)e.push(this.get(r,t));return e}getColumnVector(t){return Matrix$2.columnVector(this.getColumn(t))}setColumn(t,e){checkColumnIndex(this,t),e=checkColumnVector(this,e);for(let r=0;r<this.rows;r++)this.set(r,t,e[r]);return this}swapColumns(t,e){checkColumnIndex(this,t),checkColumnIndex(this,e);for(let r=0;r<this.rows;r++){let n=this.get(r,t);this.set(r,t,this.get(r,e)),this.set(r,e,n)}return this}addRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[r]);return this}subRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[r]);return this}mulRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[r]);return this}divRowVector(t){t=checkRowVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[r]);return this}addColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[e]);return this}subColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[e]);return this}mulColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[e]);return this}divColumnVector(t){t=checkColumnVector(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[e]);return this}mulRow(t,e){checkRowIndex(this,t);for(let r=0;r<this.columns;r++)this.set(t,r,this.get(t,r)*e);return this}mulColumn(t,e){checkColumnIndex(this,t);for(let r=0;r<this.rows;r++)this.set(r,t,this.get(r,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let n=0;n<this.columns;n++)this.get(r,n)>t&&(t=this.get(r,n),e[0]=r,e[1]=n);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){checkNonEmpty(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let n=0;n<this.columns;n++)this.get(r,n)<t&&(t=this.get(r,n),e[0]=r,e[1]=n);return e}maxRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)>e&&(e=this.get(t,r));return e}maxRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),r=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)>e&&(e=this.get(t,n),r[1]=n);return r}minRow(t){if(checkRowIndex(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)<e&&(e=this.get(t,r));return e}minRowIndex(t){checkRowIndex(this,t),checkNonEmpty(this);let e=this.get(t,0),r=[t,0];for(let n=1;n<this.columns;n++)this.get(t,n)<e&&(e=this.get(t,n),r[1]=n);return r}maxColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)>e&&(e=this.get(r,t));return e}maxColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),r=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)>e&&(e=this.get(n,t),r[0]=n);return r}minColumn(t){if(checkColumnIndex(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)<e&&(e=this.get(r,t));return e}minColumnIndex(t){checkColumnIndex(this,t),checkNonEmpty(this);let e=this.get(0,t),r=[0,t];for(let n=1;n<this.rows;n++)this.get(n,t)<e&&(e=this.get(n,t),r[0]=n);return r}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let r=0;r<t;r++)e.push(this.get(r,r));return e}norm(t="frobenius"){switch(t){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${t}`)}}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t+=this.get(e,r),this.set(e,r,t);return this}dot(t){AbstractMatrix.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let r=0;for(let n=0;n<e.length;n++)r+=e[n]*t[n];return r}mmul(t){t=Matrix$2.checkMatrix(t);let e=this.rows,r=this.columns,n=t.columns,i=new Matrix$2(e,n),o=new Float64Array(r);for(let s=0;s<n;s++){for(let e=0;e<r;e++)o[e]=t.get(e,s);for(let t=0;t<e;t++){let e=0;for(let n=0;n<r;n++)e+=this.get(t,n)*o[n];i.set(t,s,e)}}return i}mpow(t){if(!this.isSquare())throw new RangeError("Matrix must be square");if(!Number.isInteger(t)||t<0)throw new RangeError("Exponent must be a non-negative integer");let e=Matrix$2.eye(this.rows),r=this;for(let n=t;n>=1;n/=2)1&n&&(e=e.mmul(r)),r=r.mmul(r);return e}strassen2x2(t){t=Matrix$2.checkMatrix(t);let e=new Matrix$2(2,2);const r=this.get(0,0),n=t.get(0,0),i=this.get(0,1),o=t.get(0,1),s=this.get(1,0),a=t.get(1,0),l=this.get(1,1),h=t.get(1,1),c=(r+l)*(n+h),u=(s+l)*n,f=r*(o-h),d=l*(a-n),m=(r+i)*h,g=c+d-m+(i-l)*(a+h),p=f+m,w=u+d,b=c-u+f+(s-r)*(n+o);return e.set(0,0,g),e.set(0,1,p),e.set(1,0,w),e.set(1,1,b),e}strassen3x3(t){t=Matrix$2.checkMatrix(t);let e=new Matrix$2(3,3);const r=this.get(0,0),n=this.get(0,1),i=this.get(0,2),o=this.get(1,0),s=this.get(1,1),a=this.get(1,2),l=this.get(2,0),h=this.get(2,1),c=this.get(2,2),u=t.get(0,0),f=t.get(0,1),d=t.get(0,2),m=t.get(1,0),g=t.get(1,1),p=t.get(1,2),w=t.get(2,0),b=t.get(2,1),_=t.get(2,2),y=(r-o)*(-f+g),x=(-r+o+s)*(u-f+g),M=(o+s)*(-u+f),E=r*u,v=(-r+l+h)*(u-d+p),I=(-r+l)*(d-p),A=(l+h)*(-u+d),S=(-i+h+c)*(g+w-b),R=(i-c)*(g-b),k=i*w,T=(h+c)*(-w+b),$=(-i+s+a)*(p+w-_),C=(i-a)*(p-_),D=(s+a)*(-w+_),B=E+k+n*m,P=(r+n+i-o-s-h-c)*g+x+M+E+S+k+T,O=E+v+A+(r+n+i-s-a-l-h)*p+k+$+D,N=y+s*(-u+f+m-g-p-w+_)+x+E+k+$+C,F=y+x+M+E+a*b,L=k+$+C+D+o*d,V=E+v+I+h*(-u+d+m-g-p-w+b)+S+R+k,U=S+R+k+T+l*f,z=E+v+I+A+c*_;return e.set(0,0,B),e.set(0,1,P),e.set(0,2,O),e.set(1,0,N),e.set(1,1,F),e.set(1,2,L),e.set(2,0,V),e.set(2,1,U),e.set(2,2,z),e}mmulStrassen(t){t=Matrix$2.checkMatrix(t);let e=this.clone(),r=e.rows,n=e.columns,i=t.rows,o=t.columns;function s(t,e,r){let n=t.rows,i=t.columns;if(n===e&&i===r)return t;{let n=AbstractMatrix.zeros(e,r);return n=n.setSubMatrix(t,0,0),n}}n!==i&&console.warn(`Multiplying ${r} x ${n} and ${i} x ${o} matrix: dimensions do not match.`);let a=Math.max(r,i),l=Math.max(n,o);return e=s(e,a,l),function t(e,r,n,i){if(n<=512||i<=512)return e.mmul(r);n%2==1&&i%2==1?(e=s(e,n+1,i+1),r=s(r,n+1,i+1)):n%2==1?(e=s(e,n+1,i),r=s(r,n+1,i)):i%2==1&&(e=s(e,n,i+1),r=s(r,n,i+1));let o=parseInt(e.rows/2,10),a=parseInt(e.columns/2,10),l=e.subMatrix(0,o-1,0,a-1),h=r.subMatrix(0,o-1,0,a-1),c=e.subMatrix(0,o-1,a,e.columns-1),u=r.subMatrix(0,o-1,a,r.columns-1),f=e.subMatrix(o,e.rows-1,0,a-1),d=r.subMatrix(o,r.rows-1,0,a-1),m=e.subMatrix(o,e.rows-1,a,e.columns-1),g=r.subMatrix(o,r.rows-1,a,r.columns-1),p=t(AbstractMatrix.add(l,m),AbstractMatrix.add(h,g),o,a),w=t(AbstractMatrix.add(f,m),h,o,a),b=t(l,AbstractMatrix.sub(u,g),o,a),_=t(m,AbstractMatrix.sub(d,h),o,a),y=t(AbstractMatrix.add(l,c),g,o,a),x=t(AbstractMatrix.sub(f,l),AbstractMatrix.add(h,u),o,a),M=t(AbstractMatrix.sub(c,m),AbstractMatrix.add(d,g),o,a),E=AbstractMatrix.add(p,_);E.sub(y),E.add(M);let v=AbstractMatrix.add(b,y),I=AbstractMatrix.add(w,_),A=AbstractMatrix.sub(p,w);A.add(b),A.add(x);let S=AbstractMatrix.zeros(2*E.rows,2*E.columns);return S=S.setSubMatrix(E,0,0),S=S.setSubMatrix(v,E.rows,0),S=S.setSubMatrix(I,0,E.columns),S=S.setSubMatrix(A,E.rows,E.columns),S.subMatrix(0,n-1,0,i-1)}(e,t=s(t,a,l),a,l)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let n=new Matrix$2(this.rows,this.columns);for(let t=0;t<this.rows;t++){const i=this.getRow(t);i.length>0&&rescale(i,{min:e,max:r,output:i}),n.setRow(t,i)}return n}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let n=new Matrix$2(this.rows,this.columns);for(let t=0;t<this.columns;t++){const i=this.getColumn(t);i.length&&rescale(i,{min:e,max:r,output:i}),n.setColumn(t,i)}return n}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let r=0;r<t;r++){let t=this.get(e,r),n=this.get(e,this.columns-1-r);this.set(e,r,n),this.set(e,this.columns-1-r,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let r=0;r<t;r++){let t=this.get(r,e),n=this.get(this.rows-1-r,e);this.set(r,e,n),this.set(this.rows-1-r,e,t)}return this}kroneckerProduct(t){t=Matrix$2.checkMatrix(t);let e=this.rows,r=this.columns,n=t.rows,i=t.columns,o=new Matrix$2(e*n,r*i);for(let s=0;s<e;s++)for(let e=0;e<r;e++)for(let r=0;r<n;r++)for(let a=0;a<i;a++)o.set(n*s+r,i*e+a,this.get(s,e)*t.get(r,a));return o}kroneckerSum(t){if(t=Matrix$2.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,r=t.rows,n=this.kroneckerProduct(Matrix$2.eye(r,r)),i=Matrix$2.eye(e,e).kroneckerProduct(t);return n.add(i)}transpose(){let t=new Matrix$2(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.set(r,e,this.get(e,r));return t}sortRows(t=compareNumbers){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=compareNumbers){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,r,n){checkRange$1(this,t,e,r,n);let i=new Matrix$2(e-t+1,n-r+1);for(let o=t;o<=e;o++)for(let e=r;e<=n;e++)i.set(o-t,e-r,this.get(o,e));return i}subMatrixRow(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.columns-1),e>r||e<0||e>=this.columns||r<0||r>=this.columns)throw new RangeError("Argument out of range");let n=new Matrix$2(t.length,r-e+1);for(let i=0;i<t.length;i++)for(let o=e;o<=r;o++){if(t[i]<0||t[i]>=this.rows)throw new RangeError(`Row index out of range: ${t[i]}`);n.set(i,o-e,this.get(t[i],o))}return n}subMatrixColumn(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.rows-1),e>r||e<0||e>=this.rows||r<0||r>=this.rows)throw new RangeError("Argument out of range");let n=new Matrix$2(r-e+1,t.length);for(let i=0;i<t.length;i++)for(let o=e;o<=r;o++){if(t[i]<0||t[i]>=this.columns)throw new RangeError(`Column index out of range: ${t[i]}`);n.set(o-e,i,this.get(o,t[i]))}return n}setSubMatrix(t,e,r){if((t=Matrix$2.checkMatrix(t)).isEmpty())return this;checkRange$1(this,e,e+t.rows-1,r,r+t.columns-1);for(let n=0;n<t.rows;n++)for(let i=0;i<t.columns;i++)this.set(e+n,r+i,t.get(n,i));return this}selection(t,e){checkRowIndices(this,t),checkColumnIndices(this,e);let r=new Matrix$2(t.length,e.length);for(let n=0;n<t.length;n++){let i=t[n];for(let t=0;t<e.length;t++){let o=e[t];r.set(n,t,this.get(i,o))}}return r}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let r=0;r<t;r++)e+=this.get(r,r);return e}clone(){return this.constructor.copy(this,new Matrix$2(this.rows,this.columns))}static copy(t,e){for(const[r,n,i]of t.entries())e.set(r,n,i);return e}sum(t){switch(t){case"row":return sumByRow(this);case"column":return sumByColumn(this);case void 0:return sumAll(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return productByRow(this);case"column":return productByColumn(this);case void 0:return productAll(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:r=!0,mean:n=this.mean(t)}=e;if("boolean"!=typeof r)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!isAnyArray.isAnyArray(n))throw new TypeError("mean must be an array");return varianceByRow(this,r,n);case"column":if(!isAnyArray.isAnyArray(n))throw new TypeError("mean must be an array");return varianceByColumn(this,r,n);case void 0:if("number"!=typeof n)throw new TypeError("mean must be a number");return varianceAll(this,r,n);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const r=this.variance(t,e);if(void 0===t)return Math.sqrt(r);for(let t=0;t<r.length;t++)r[t]=Math.sqrt(r[t]);return r}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:r=this.mean(t)}=e;switch(t){case"row":if(!isAnyArray.isAnyArray(r))throw new TypeError("center must be an array");return centerByRow(this,r),this;case"column":if(!isAnyArray.isAnyArray(r))throw new TypeError("center must be an array");return centerByColumn(this,r),this;case void 0:if("number"!=typeof r)throw new TypeError("center must be a number");return centerAll(this,r),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let r=e.scale;switch(t){case"row":if(void 0===r)r=getScaleByRow(this);else if(!isAnyArray.isAnyArray(r))throw new TypeError("scale must be an array");return scaleByRow(this,r),this;case"column":if(void 0===r)r=getScaleByColumn(this);else if(!isAnyArray.isAnyArray(r))throw new TypeError("scale must be an array");return scaleByColumn(this,r),this;case void 0:if(void 0===r)r=getScaleAll(this);else if("number"!=typeof r)throw new TypeError("scale must be a number");return scaleAll(this,r),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return inspectMatrixWithOptions(this,t)}[Symbol.iterator](){return this.entries()}*entries(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield[t,e,this.get(t,e)]}*values(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield this.get(t,e)}}function compareNumbers(t,e){return t-e}function isArrayOfNumbers(t){return t.every(t=>"number"==typeof t)}AbstractMatrix.prototype.klass="Matrix","undefined"!=typeof Symbol&&(AbstractMatrix.prototype[Symbol.for("nodejs.util.inspect.custom")]=inspectMatrix),AbstractMatrix.random=AbstractMatrix.rand,AbstractMatrix.randomInt=AbstractMatrix.randInt,AbstractMatrix.diagonal=AbstractMatrix.diag,AbstractMatrix.prototype.diagonal=AbstractMatrix.prototype.diag,AbstractMatrix.identity=AbstractMatrix.eye,AbstractMatrix.prototype.negate=AbstractMatrix.prototype.neg,AbstractMatrix.prototype.tensorProduct=AbstractMatrix.prototype.kroneckerProduct;let Matrix$2=class t extends AbstractMatrix{data;#t(t,e){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let r=0;r<t;r++)this.data.push(new Float64Array(e));this.rows=t,this.columns=e}constructor(e,r){if(super(),t.isMatrix(e))this.#t(e.rows,e.columns),t.copy(e,this);else if(Number.isInteger(e)&&e>=0)this.#t(e,r);else{if(!isAnyArray.isAnyArray(e))throw new TypeError("First argument must be a positive number or an array");{const t=e;if("number"!=typeof(r=(e=t.length)?t[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let n=0;n<e;n++){if(t[n].length!==r)throw new RangeError("Inconsistent array dimensions");if(!isArrayOfNumbers(t[n]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(t[n]))}this.rows=e,this.columns=r}}}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}removeRow(t){return checkRowIndex(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),checkRowIndex(this,t,!0),e=Float64Array.from(checkRowVector(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){checkColumnIndex(this,t);for(let e=0;e<this.rows;e++){const r=new Float64Array(this.columns-1);for(let n=0;n<t;n++)r[n]=this.data[e][n];for(let n=t+1;n<this.columns;n++)r[n-1]=this.data[e][n];this.data[e]=r}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),checkColumnIndex(this,t,!0),e=checkColumnVector(this,e);for(let r=0;r<this.rows;r++){const n=new Float64Array(this.columns+1);let i=0;for(;i<t;i++)n[i]=this.data[r][i];for(n[i++]=e[r];i<this.columns+1;i++)n[i]=this.data[r][i-1];this.data[r]=n}return this.columns+=1,this}};installMathOperations(AbstractMatrix,Matrix$2);class SymmetricMatrix extends AbstractMatrix{#e;get size(){return this.#e.size}get rows(){return this.#e.rows}get columns(){return this.#e.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(t){return Matrix$2.isMatrix(t)&&"SymmetricMatrix"===t.klassType}static zeros(t){return new this(t)}static ones(t){return new this(t).fill(1)}constructor(t){if(super(),Matrix$2.isMatrix(t)){if(!t.isSymmetric())throw new TypeError("not symmetric data");this.#e=Matrix$2.copy(t,new Matrix$2(t.rows,t.rows))}else if(Number.isInteger(t)&&t>=0)this.#e=new Matrix$2(t,t);else if(this.#e=new Matrix$2(t),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const t=new SymmetricMatrix(this.diagonalSize);for(const[e,r,n]of this.upperRightEntries())t.set(e,r,n);return t}toMatrix(){return new Matrix$2(this)}get(t,e){return this.#e.get(t,e)}set(t,e,r){return this.#e.set(t,e,r),this.#e.set(e,t,r),this}removeCross(t){return this.#e.removeRow(t),this.#e.removeColumn(t),this}addCross(t,e){void 0===e&&(e=t,t=this.diagonalSize);const r=e.slice();return r.splice(t,1),this.#e.addRow(t,r),this.#e.addColumn(t,e),this}applyMask(t){if(t.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const e=[];for(const[r,n]of t.entries())n||e.push(r);e.reverse();for(const t of e)this.removeCross(t);return this}toCompact(){const{diagonalSize:t}=this,e=new Array(t*(t+1)/2);for(let r=0,n=0,i=0;i<e.length;i++)e[i]=this.get(n,r),++r>=t&&(r=++n);return e}static fromCompact(t){const e=t.length,r=(Math.sqrt(8*e+1)-1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(t)}`);const n=new SymmetricMatrix(r);for(let i=0,o=0,s=0;s<e;s++)n.set(i,o,t[s]),++i>=r&&(i=++o);return n}*upperRightEntries(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield[t,e,r],++e>=this.diagonalSize&&(e=++t)}}*upperRightValues(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield r,++e>=this.diagonalSize&&(e=++t)}}}SymmetricMatrix.prototype.klassType="SymmetricMatrix";class DistanceMatrix extends SymmetricMatrix{static isDistanceMatrix(t){return SymmetricMatrix.isSymmetricMatrix(t)&&"DistanceMatrix"===t.klassSubType}constructor(t){if(super(t),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(t,e,r){return t===e&&(r=0),super.set(t,e,r)}addCross(t,e){return void 0===e&&(e=t,t=this.diagonalSize),(e=e.slice())[t]=0,super.addCross(t,e)}toSymmetricMatrix(){return new SymmetricMatrix(this)}clone(){const t=new DistanceMatrix(this.diagonalSize);for(const[e,r,n]of this.upperRightEntries())e!==r&&t.set(e,r,n);return t}toCompact(){const{diagonalSize:t}=this,e=new Array((t-1)*t/2);for(let r=1,n=0,i=0;i<e.length;i++)e[i]=this.get(n,r),++r>=t&&(r=1+ ++n);return e}static fromCompact(t){const e=t.length;if(0===e)return new this(0);const r=(Math.sqrt(8*e+1)+1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(t)}`);const n=new this(r);for(let i=1,o=0,s=0;s<e;s++)n.set(i,o,t[s]),++i>=r&&(i=1+ ++o);return n}}DistanceMatrix.prototype.klassSubType="DistanceMatrix";class BaseView extends AbstractMatrix{constructor(t,e,r){super(),this.matrix=t,this.rows=e,this.columns=r}}class MatrixColumnView extends BaseView{constructor(t,e){checkColumnIndex(t,e),super(t,t.rows,1),this.column=e}set(t,e,r){return this.matrix.set(t,this.column,r),this}get(t){return this.matrix.get(t,this.column)}}class MatrixColumnSelectionView extends BaseView{constructor(t,e){checkColumnIndices(t,e),super(t,t.rows,e.length),this.columnIndices=e}set(t,e,r){return this.matrix.set(t,this.columnIndices[e],r),this}get(t,e){return this.matrix.get(t,this.columnIndices[e])}}class MatrixFlipColumnView extends BaseView{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(t,this.columns-e-1,r),this}get(t,e){return this.matrix.get(t,this.columns-e-1)}}class MatrixFlipRowView extends BaseView{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(this.rows-t-1,e,r),this}get(t,e){return this.matrix.get(this.rows-t-1,e)}}class MatrixRowView extends BaseView{constructor(t,e){checkRowIndex(t,e),super(t,1,t.columns),this.row=e}set(t,e,r){return this.matrix.set(this.row,e,r),this}get(t,e){return this.matrix.get(this.row,e)}}class MatrixRowSelectionView extends BaseView{constructor(t,e){checkRowIndices(t,e),super(t,e.length,t.columns),this.rowIndices=e}set(t,e,r){return this.matrix.set(this.rowIndices[t],e,r),this}get(t,e){return this.matrix.get(this.rowIndices[t],e)}}class MatrixSelectionView extends BaseView{constructor(t,e,r){checkRowIndices(t,e),checkColumnIndices(t,r),super(t,e.length,r.length),this.rowIndices=e,this.columnIndices=r}set(t,e,r){return this.matrix.set(this.rowIndices[t],this.columnIndices[e],r),this}get(t,e){return this.matrix.get(this.rowIndices[t],this.columnIndices[e])}}class MatrixSubView extends BaseView{constructor(t,e,r,n,i){checkRange$1(t,e,r,n,i),super(t,r-e+1,i-n+1),this.startRow=e,this.startColumn=n}set(t,e,r){return this.matrix.set(this.startRow+t,this.startColumn+e,r),this}get(t,e){return this.matrix.get(this.startRow+t,this.startColumn+e)}}class MatrixTransposeView extends BaseView{constructor(t){super(t,t.columns,t.rows)}set(t,e,r){return this.matrix.set(e,t,r),this}get(t,e){return this.matrix.get(e,t)}}let WrapperMatrix1D$1=class extends AbstractMatrix{constructor(t,e={}){const{rows:r=1}=e;if(t.length%r!==0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=r,this.columns=t.length/r,this.data=t}set(t,e,r){let n=this._calculateIndex(t,e);return this.data[n]=r,this}get(t,e){let r=this._calculateIndex(t,e);return this.data[r]}_calculateIndex(t,e){return t*this.columns+e}};class WrapperMatrix2D extends AbstractMatrix{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}}function wrap(t,e){if(isAnyArray.isAnyArray(t))return t[0]&&isAnyArray.isAnyArray(t[0])?new WrapperMatrix2D(t):new WrapperMatrix1D$1(t,e);throw new Error("the argument is not an array")}class LuDecomposition{constructor(t){let e,r,n,i,o,s,a,l,h,c=(t=WrapperMatrix2D.checkMatrix(t)).clone(),u=c.rows,f=c.columns,d=new Float64Array(u),m=1;for(e=0;e<u;e++)d[e]=e;for(l=new Float64Array(u),r=0;r<f;r++){for(e=0;e<u;e++)l[e]=c.get(e,r);for(e=0;e<u;e++){for(h=Math.min(e,r),o=0,n=0;n<h;n++)o+=c.get(e,n)*l[n];l[e]-=o,c.set(e,r,l[e])}for(i=r,e=r+1;e<u;e++)Math.abs(l[e])>Math.abs(l[i])&&(i=e);if(i!==r){for(n=0;n<f;n++)s=c.get(i,n),c.set(i,n,c.get(r,n)),c.set(r,n,s);a=d[i],d[i]=d[r],d[r]=a,m=-m}if(r<u&&0!==c.get(r,r))for(e=r+1;e<u;e++)c.set(e,r,c.get(e,r)/c.get(r,r))}this.LU=c,this.pivotVector=d,this.pivotSign=m}isSingular(){let t=this.LU,e=t.columns;for(let r=0;r<e;r++)if(0===t.get(r,r))return!0;return!1}solve(t){t=Matrix$2.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let r,n,i,o=t.columns,s=t.subMatrixRow(this.pivotVector,0,o-1),a=e.columns;for(i=0;i<a;i++)for(r=i+1;r<a;r++)for(n=0;n<o;n++)s.set(r,n,s.get(r,n)-s.get(i,n)*e.get(r,i));for(i=a-1;i>=0;i--){for(n=0;n<o;n++)s.set(i,n,s.get(i,n)/e.get(i,i));for(r=0;r<i;r++)for(n=0;n<o;n++)s.set(r,n,s.get(r,n)-s.get(i,n)*e.get(r,i))}return s}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,r=t.columns;for(let n=0;n<r;n++)e*=t.get(n,n);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,n=new Matrix$2(e,r);for(let i=0;i<e;i++)for(let e=0;e<r;e++)i>e?n.set(i,e,t.get(i,e)):i===e?n.set(i,e,1):n.set(i,e,0);return n}get upperTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,n=new Matrix$2(e,r);for(let i=0;i<e;i++)for(let e=0;e<r;e++)i<=e?n.set(i,e,t.get(i,e)):n.set(i,e,0);return n}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function hypotenuse$1(t,e){let r=0;return Math.abs(t)>Math.abs(e)?(r=e/t,Math.abs(t)*Math.sqrt(1+r*r)):0!==e?(r=t/e,Math.abs(e)*Math.sqrt(1+r*r)):0}class QrDecomposition{constructor(t){let e,r,n,i,o=(t=WrapperMatrix2D.checkMatrix(t)).clone(),s=t.rows,a=t.columns,l=new Float64Array(a);for(n=0;n<a;n++){let t=0;for(e=n;e<s;e++)t=hypotenuse$1(t,o.get(e,n));if(0!==t){for(o.get(n,n)<0&&(t=-t),e=n;e<s;e++)o.set(e,n,o.get(e,n)/t);for(o.set(n,n,o.get(n,n)+1),r=n+1;r<a;r++){for(i=0,e=n;e<s;e++)i+=o.get(e,n)*o.get(e,r);for(i=-i/o.get(n,n),e=n;e<s;e++)o.set(e,r,o.get(e,r)+i*o.get(e,n))}}l[n]=-t}this.QR=o,this.Rdiag=l}solve(t){t=Matrix$2.checkMatrix(t);let e=this.QR,r=e.rows;if(t.rows!==r)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let n,i,o,s,a=t.columns,l=t.clone(),h=e.columns;for(o=0;o<h;o++)for(i=0;i<a;i++){for(s=0,n=o;n<r;n++)s+=e.get(n,o)*l.get(n,i);for(s=-s/e.get(o,o),n=o;n<r;n++)l.set(n,i,l.get(n,i)+s*e.get(n,o))}for(o=h-1;o>=0;o--){for(i=0;i<a;i++)l.set(o,i,l.get(o,i)/this.Rdiag[o]);for(n=0;n<o;n++)for(i=0;i<a;i++)l.set(n,i,l.get(n,i)-l.get(o,i)*e.get(n,o))}return l.subMatrix(0,h-1,0,a-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,r=this.QR,n=r.columns,i=new Matrix$2(n,n);for(t=0;t<n;t++)for(e=0;e<n;e++)t<e?i.set(t,e,r.get(t,e)):t===e?i.set(t,e,this.Rdiag[t]):i.set(t,e,0);return i}get orthogonalMatrix(){let t,e,r,n,i=this.QR,o=i.rows,s=i.columns,a=new Matrix$2(o,s);for(r=s-1;r>=0;r--){for(t=0;t<o;t++)a.set(t,r,0);for(a.set(r,r,1),e=r;e<s;e++)if(0!==i.get(r,r)){for(n=0,t=r;t<o;t++)n+=i.get(t,r)*a.get(t,e);for(n=-n/i.get(r,r),t=r;t<o;t++)a.set(t,e,a.get(t,e)+n*i.get(t,r))}}return a}}let SingularValueDecomposition$1=class{constructor(t,e={}){if((t=WrapperMatrix2D.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let r=t.rows,n=t.columns;const{computeLeftSingularVectors:i=!0,computeRightSingularVectors:o=!0,autoTranspose:s=!1}=e;let a,l=Boolean(i),h=Boolean(o),c=!1;if(r<n)if(s){a=t.transpose(),r=a.rows,n=a.columns,c=!0;let e=l;l=h,h=e}else a=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else a=t.clone();let u=Math.min(r,n),f=Math.min(r+1,n),d=new Float64Array(f),m=new Matrix$2(r,u),g=new Matrix$2(n,n),p=new Float64Array(n),w=new Float64Array(r),b=new Float64Array(f);for(let t=0;t<f;t++)b[t]=t;let _=Math.min(r-1,n),y=Math.max(0,Math.min(n-2,r)),x=Math.max(_,y);for(let t=0;t<x;t++){if(t<_){d[t]=0;for(let e=t;e<r;e++)d[t]=hypotenuse$1(d[t],a.get(e,t));if(0!==d[t]){a.get(t,t)<0&&(d[t]=-d[t]);for(let e=t;e<r;e++)a.set(e,t,a.get(e,t)/d[t]);a.set(t,t,a.get(t,t)+1)}d[t]=-d[t]}for(let e=t+1;e<n;e++){if(t<_&&0!==d[t]){let n=0;for(let i=t;i<r;i++)n+=a.get(i,t)*a.get(i,e);n=-n/a.get(t,t);for(let i=t;i<r;i++)a.set(i,e,a.get(i,e)+n*a.get(i,t))}p[e]=a.get(t,e)}if(l&&t<_)for(let e=t;e<r;e++)m.set(e,t,a.get(e,t));if(t<y){p[t]=0;for(let e=t+1;e<n;e++)p[t]=hypotenuse$1(p[t],p[e]);if(0!==p[t]){p[t+1]<0&&(p[t]=0-p[t]);for(let e=t+1;e<n;e++)p[e]/=p[t];p[t+1]+=1}if(p[t]=-p[t],t+1<r&&0!==p[t]){for(let e=t+1;e<r;e++)w[e]=0;for(let e=t+1;e<r;e++)for(let r=t+1;r<n;r++)w[e]+=p[r]*a.get(e,r);for(let e=t+1;e<n;e++){let n=-p[e]/p[t+1];for(let i=t+1;i<r;i++)a.set(i,e,a.get(i,e)+n*w[i])}}if(h)for(let e=t+1;e<n;e++)g.set(e,t,p[e])}}let M=Math.min(n,r+1);if(_<n&&(d[_]=a.get(_,_)),r<M&&(d[M-1]=0),y+1<M&&(p[y]=a.get(y,M-1)),p[M-1]=0,l){for(let t=_;t<u;t++){for(let e=0;e<r;e++)m.set(e,t,0);m.set(t,t,1)}for(let t=_-1;t>=0;t--)if(0!==d[t]){for(let e=t+1;e<u;e++){let n=0;for(let i=t;i<r;i++)n+=m.get(i,t)*m.get(i,e);n=-n/m.get(t,t);for(let i=t;i<r;i++)m.set(i,e,m.get(i,e)+n*m.get(i,t))}for(let e=t;e<r;e++)m.set(e,t,-m.get(e,t));m.set(t,t,1+m.get(t,t));for(let e=0;e<t-1;e++)m.set(e,t,0)}else{for(let e=0;e<r;e++)m.set(e,t,0);m.set(t,t,1)}}if(h)for(let t=n-1;t>=0;t--){if(t<y&&0!==p[t])for(let e=t+1;e<n;e++){let r=0;for(let i=t+1;i<n;i++)r+=g.get(i,t)*g.get(i,e);r=-r/g.get(t+1,t);for(let i=t+1;i<n;i++)g.set(i,e,g.get(i,e)+r*g.get(i,t))}for(let e=0;e<n;e++)g.set(e,t,0);g.set(t,t,1)}let E=M-1,v=Number.EPSILON;for(;M>0;){let t,e;for(t=M-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+v*Math.abs(d[t]+Math.abs(d[t+1]));if(Math.abs(p[t])<=e||Number.isNaN(p[t])){p[t]=0;break}}if(t===M-2)e=4;else{let r;for(r=M-1;r>=t&&r!==t;r--){let e=(r!==M?Math.abs(p[r]):0)+(r!==t+1?Math.abs(p[r-1]):0);if(Math.abs(d[r])<=v*e){d[r]=0;break}}r===t?e=3:r===M-1?e=1:(e=2,t=r)}switch(t++,e){case 1:{let e=p[M-2];p[M-2]=0;for(let r=M-2;r>=t;r--){let i=hypotenuse$1(d[r],e),o=d[r]/i,s=e/i;if(d[r]=i,r!==t&&(e=-s*p[r-1],p[r-1]=o*p[r-1]),h)for(let t=0;t<n;t++)i=o*g.get(t,r)+s*g.get(t,M-1),g.set(t,M-1,-s*g.get(t,r)+o*g.get(t,M-1)),g.set(t,r,i)}break}case 2:{let e=p[t-1];p[t-1]=0;for(let n=t;n<M;n++){let i=hypotenuse$1(d[n],e),o=d[n]/i,s=e/i;if(d[n]=i,e=-s*p[n],p[n]=o*p[n],l)for(let e=0;e<r;e++)i=o*m.get(e,n)+s*m.get(e,t-1),m.set(e,t-1,-s*m.get(e,n)+o*m.get(e,t-1)),m.set(e,n,i)}break}case 3:{const e=Math.max(Math.abs(d[M-1]),Math.abs(d[M-2]),Math.abs(p[M-2]),Math.abs(d[t]),Math.abs(p[t])),i=d[M-1]/e,o=d[M-2]/e,s=p[M-2]/e,a=d[t]/e,c=p[t]/e,u=((o+i)*(o-i)+s*s)/2,f=i*s*(i*s);let w=0;0===u&&0===f||(w=u<0?0-Math.sqrt(u*u+f):Math.sqrt(u*u+f),w=f/(u+w));let b=(a+i)*(a-i)+w,_=a*c;for(let e=t;e<M-1;e++){let i=hypotenuse$1(b,_);0===i&&(i=Number.MIN_VALUE);let o=b/i,s=_/i;if(e!==t&&(p[e-1]=i),b=o*d[e]+s*p[e],p[e]=o*p[e]-s*d[e],_=s*d[e+1],d[e+1]=o*d[e+1],h)for(let t=0;t<n;t++)i=o*g.get(t,e)+s*g.get(t,e+1),g.set(t,e+1,-s*g.get(t,e)+o*g.get(t,e+1)),g.set(t,e,i);if(i=hypotenuse$1(b,_),0===i&&(i=Number.MIN_VALUE),o=b/i,s=_/i,d[e]=i,b=o*p[e]+s*d[e+1],d[e+1]=-s*p[e]+o*d[e+1],_=s*p[e+1],p[e+1]=o*p[e+1],l&&e<r-1)for(let t=0;t<r;t++)i=o*m.get(t,e)+s*m.get(t,e+1),m.set(t,e+1,-s*m.get(t,e)+o*m.get(t,e+1)),m.set(t,e,i)}p[M-2]=b;break}case 4:if(d[t]<=0&&(d[t]=d[t]<0?-d[t]:0,h))for(let e=0;e<=E;e++)g.set(e,t,-g.get(e,t));for(;t<E&&!(d[t]>=d[t+1]);){let e=d[t];if(d[t]=d[t+1],d[t+1]=e,h&&t<n-1)for(let r=0;r<n;r++)e=g.get(r,t+1),g.set(r,t+1,g.get(r,t)),g.set(r,t,e);if(l&&t<r-1)for(let n=0;n<r;n++)e=m.get(n,t+1),m.set(n,t+1,m.get(n,t)),m.set(n,t,e);t++}M--}}if(c){let t=g;g=m,m=t}this.m=r,this.n=n,this.s=d,this.U=m,this.V=g}solve(t){let e=t,r=this.threshold,n=this.s.length,i=Matrix$2.zeros(n,n);for(let t=0;t<n;t++)Math.abs(this.s[t])<=r?i.set(t,t,0):i.set(t,t,1/this.s[t]);let o=this.U,s=this.rightSingularVectors,a=s.mmul(i),l=s.rows,h=o.rows,c=Matrix$2.zeros(l,h);for(let t=0;t<l;t++)for(let e=0;e<h;e++){let r=0;for(let i=0;i<n;i++)r+=a.get(t,i)*o.get(e,i);c.set(t,e,r)}return c.mmul(e)}solveForDiagonal(t){return this.solve(Matrix$2.diag(t))}inverse(){let t=this.V,e=this.threshold,r=t.rows,n=t.columns,i=new Matrix$2(r,this.s.length);for(let o=0;o<r;o++)for(let r=0;r<n;r++)Math.abs(this.s[r])>e&&i.set(o,r,t.get(o,r)/this.s[r]);let o=this.U,s=o.rows,a=o.columns,l=new Matrix$2(r,s);for(let t=0;t<r;t++)for(let e=0;e<s;e++){let r=0;for(let n=0;n<a;n++)r+=i.get(t,n)*o.get(e,n);l.set(t,e,r)}return l}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,r=this.s;for(let n=0,i=r.length;n<i;n++)r[n]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return Matrix$2.diag(this.s)}};function inverse$1(t,e=!1){return t=WrapperMatrix2D.checkMatrix(t),e?new SingularValueDecomposition$1(t).inverse():solve(t,Matrix$2.eye(t.rows))}function solve(t,e,r=!1){return t=WrapperMatrix2D.checkMatrix(t),e=WrapperMatrix2D.checkMatrix(e),r?new SingularValueDecomposition$1(t).solve(e):t.isSquare()?new LuDecomposition(t).solve(e):new QrDecomposition(t).solve(e)}function determinant$1(t){if((t=Matrix$2.checkMatrix(t)).isSquare()){if(0===t.columns)return 1;let e,r,n,i;if(2===t.columns)return e=t.get(0,0),r=t.get(0,1),n=t.get(1,0),i=t.get(1,1),e*i-r*n;if(3===t.columns){let i,o,s;return i=new MatrixSelectionView(t,[1,2],[1,2]),o=new MatrixSelectionView(t,[1,2],[0,2]),s=new MatrixSelectionView(t,[1,2],[0,1]),e=t.get(0,0),r=t.get(0,1),n=t.get(0,2),e*determinant$1(i)-r*determinant$1(o)+n*determinant$1(s)}return new LuDecomposition(t).determinant}throw Error("determinant can only be calculated for a square matrix")}function xrange(t,e){let r=[];for(let n=0;n<t;n++)n!==e&&r.push(n);return r}function dependenciesOneRow(t,e,r,n=1e-9,i=1e-9){if(t>i)return new Array(e.rows+1).fill(0);{let t=e.addRow(r,[0]);for(let e=0;e<t.rows;e++)Math.abs(t.get(e,0))<n&&t.set(e,0,0);return t.to1DArray()}}function linearDependencies(t,e={}){const{thresholdValue:r=1e-9,thresholdError:n=1e-9}=e;let i=(t=Matrix$2.checkMatrix(t)).rows,o=new Matrix$2(i,i);for(let e=0;e<i;e++){let s=Matrix$2.columnVector(t.getRow(e)),a=t.subMatrixRow(xrange(i,e)).transpose(),l=new SingularValueDecomposition$1(a).solve(s),h=Matrix$2.sub(s,a.mmul(l)).abs().max();o.setRow(e,dependenciesOneRow(h,l,e,r,n))}return o}function pseudoInverse$1(t,e=Number.EPSILON){if((t=Matrix$2.checkMatrix(t)).isEmpty())return t.transpose();let r=new SingularValueDecomposition$1(t,{autoTranspose:!0}),n=r.leftSingularVectors,i=r.rightSingularVectors,o=r.diagonal;for(let t=0;t<o.length;t++)Math.abs(o[t])>e?o[t]=1/o[t]:o[t]=0;return i.mmul(Matrix$2.diag(o).mmul(n.transpose()))}function covariance(t,e=t,r={}){t=new Matrix$2(t);let n=!1;if("object"!=typeof e||Matrix$2.isMatrix(e)||isAnyArray.isAnyArray(e)?e=new Matrix$2(e):(r=e,e=t,n=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:i=!0}=r;i&&(t=t.center("column"),n||(e=e.center("column")));const o=t.transpose().mmul(e);for(let e=0;e<o.rows;e++)for(let r=0;r<o.columns;r++)o.set(e,r,o.get(e,r)*(1/(t.rows-1)));return o}function correlation(t,e=t,r={}){t=new Matrix$2(t);let n=!1;if("object"!=typeof e||Matrix$2.isMatrix(e)||isAnyArray.isAnyArray(e)?e=new Matrix$2(e):(r=e,e=t,n=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:i=!0,scale:o=!0}=r;i&&(t.center("column"),n||e.center("column")),o&&(t.scale("column"),n||e.scale("column"));const s=t.standardDeviation("column",{unbiased:!0}),a=n?s:e.standardDeviation("column",{unbiased:!0}),l=t.transpose().mmul(e);for(let e=0;e<l.rows;e++)for(let r=0;r<l.columns;r++)l.set(e,r,l.get(e,r)*(1/(s[e]*a[r]))*(1/(t.rows-1)));return l}let EigenvalueDecomposition$1=class{constructor(t,e={}){const{assumeSymmetric:r=!1}=e;if(!(t=WrapperMatrix2D.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let n,i,o=t.columns,s=new Matrix$2(o,o),a=new Float64Array(o),l=new Float64Array(o),h=t,c=!1;if(c=!!r||t.isSymmetric(),c){for(n=0;n<o;n++)for(i=0;i<o;i++)s.set(n,i,h.get(n,i));tred2(o,l,a,s),tql2(o,l,a,s)}else{let t=new Matrix$2(o,o),e=new Float64Array(o);for(i=0;i<o;i++)for(n=0;n<o;n++)t.set(n,i,h.get(n,i));orthes(o,t,e,s),hqr2(o,l,a,s,t)}this.n=o,this.e=l,this.d=a,this.V=s}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,r=this.n,n=this.e,i=this.d,o=new Matrix$2(r,r);for(t=0;t<r;t++){for(e=0;e<r;e++)o.set(t,e,0);o.set(t,t,i[t]),n[t]>0?o.set(t,t+1,n[t]):n[t]<0&&o.set(t,t-1,n[t])}return o}};function tred2(t,e,r,n){let i,o,s,a,l,h,c,u;for(l=0;l<t;l++)r[l]=n.get(t-1,l);for(a=t-1;a>0;a--){for(u=0,s=0,h=0;h<a;h++)u+=Math.abs(r[h]);if(0===u)for(e[a]=r[a-1],l=0;l<a;l++)r[l]=n.get(a-1,l),n.set(a,l,0),n.set(l,a,0);else{for(h=0;h<a;h++)r[h]/=u,s+=r[h]*r[h];for(i=r[a-1],o=Math.sqrt(s),i>0&&(o=-o),e[a]=u*o,s-=i*o,r[a-1]=i-o,l=0;l<a;l++)e[l]=0;for(l=0;l<a;l++){for(i=r[l],n.set(l,a,i),o=e[l]+n.get(l,l)*i,h=l+1;h<=a-1;h++)o+=n.get(h,l)*r[h],e[h]+=n.get(h,l)*i;e[l]=o}for(i=0,l=0;l<a;l++)e[l]/=s,i+=e[l]*r[l];for(c=i/(s+s),l=0;l<a;l++)e[l]-=c*r[l];for(l=0;l<a;l++){for(i=r[l],o=e[l],h=l;h<=a-1;h++)n.set(h,l,n.get(h,l)-(i*e[h]+o*r[h]));r[l]=n.get(a-1,l),n.set(a,l,0)}}r[a]=s}for(a=0;a<t-1;a++){if(n.set(t-1,a,n.get(a,a)),n.set(a,a,1),s=r[a+1],0!==s){for(h=0;h<=a;h++)r[h]=n.get(h,a+1)/s;for(l=0;l<=a;l++){for(o=0,h=0;h<=a;h++)o+=n.get(h,a+1)*n.get(h,l);for(h=0;h<=a;h++)n.set(h,l,n.get(h,l)-o*r[h])}}for(h=0;h<=a;h++)n.set(h,a+1,0)}for(l=0;l<t;l++)r[l]=n.get(t-1,l),n.set(t-1,l,0);n.set(t-1,t-1,1),e[0]=0}function tql2(t,e,r,n){let i,o,s,a,l,h,c,u,f,d,m,g,p,w,b,_;for(s=1;s<t;s++)e[s-1]=e[s];e[t-1]=0;let y=0,x=0,M=Number.EPSILON;for(h=0;h<t;h++){for(x=Math.max(x,Math.abs(r[h])+Math.abs(e[h])),c=h;c<t&&!(Math.abs(e[c])<=M*x);)c++;if(c>h)do{for(i=r[h],u=(r[h+1]-i)/(2*e[h]),f=hypotenuse$1(u,1),u<0&&(f=-f),r[h]=e[h]/(u+f),r[h+1]=e[h]*(u+f),d=r[h+1],o=i-r[h],s=h+2;s<t;s++)r[s]-=o;for(y+=o,u=r[c],m=1,g=m,p=m,w=e[h+1],b=0,_=0,s=c-1;s>=h;s--)for(p=g,g=m,_=b,i=m*e[s],o=m*u,f=hypotenuse$1(u,e[s]),e[s+1]=b*f,b=e[s]/f,m=u/f,u=m*r[s]-b*i,r[s+1]=o+b*(m*i+b*r[s]),l=0;l<t;l++)o=n.get(l,s+1),n.set(l,s+1,b*n.get(l,s)+m*o),n.set(l,s,m*n.get(l,s)-b*o);u=-b*_*p*w*e[h]/d,e[h]=b*u,r[h]=m*u}while(Math.abs(e[h])>M*x);r[h]=r[h]+y,e[h]=0}for(s=0;s<t-1;s++){for(l=s,u=r[s],a=s+1;a<t;a++)r[a]<u&&(l=a,u=r[a]);if(l!==s)for(r[l]=r[s],r[s]=u,a=0;a<t;a++)u=n.get(a,s),n.set(a,s,n.get(a,l)),n.set(a,l,u)}}function orthes(t,e,r,n){let i,o,s,a,l,h,c,u=t-1;for(h=1;h<=u-1;h++){for(c=0,a=h;a<=u;a++)c+=Math.abs(e.get(a,h-1));if(0!==c){for(s=0,a=u;a>=h;a--)r[a]=e.get(a,h-1)/c,s+=r[a]*r[a];for(o=Math.sqrt(s),r[h]>0&&(o=-o),s-=r[h]*o,r[h]=r[h]-o,l=h;l<t;l++){for(i=0,a=u;a>=h;a--)i+=r[a]*e.get(a,l);for(i/=s,a=h;a<=u;a++)e.set(a,l,e.get(a,l)-i*r[a])}for(a=0;a<=u;a++){for(i=0,l=u;l>=h;l--)i+=r[l]*e.get(a,l);for(i/=s,l=h;l<=u;l++)e.set(a,l,e.get(a,l)-i*r[l])}r[h]=c*r[h],e.set(h,h-1,c*o)}}for(a=0;a<t;a++)for(l=0;l<t;l++)n.set(a,l,a===l?1:0);for(h=u-1;h>=1;h--)if(0!==e.get(h,h-1)){for(a=h+1;a<=u;a++)r[a]=e.get(a,h-1);for(l=h;l<=u;l++){for(o=0,a=h;a<=u;a++)o+=r[a]*n.get(a,l);for(o=o/r[h]/e.get(h,h-1),a=h;a<=u;a++)n.set(a,l,n.get(a,l)+o*r[a])}}}function hqr2(t,e,r,n,i){let o,s,a,l,h,c,u,f,d,m,g,p,w,b,_,y=t-1,x=t-1,M=Number.EPSILON,E=0,v=0,I=0,A=0,S=0,R=0,k=0,T=0;for(o=0;o<t;o++)for((o<0||o>x)&&(r[o]=i.get(o,o),e[o]=0),s=Math.max(o-1,0);s<t;s++)v+=Math.abs(i.get(o,s));for(;y>=0;){for(l=y;l>0&&(R=Math.abs(i.get(l-1,l-1))+Math.abs(i.get(l,l)),0===R&&(R=v),!(Math.abs(i.get(l,l-1))<M*R));)l--;if(l===y)i.set(y,y,i.get(y,y)+E),r[y]=i.get(y,y),e[y]=0,y--,T=0;else if(l===y-1){if(u=i.get(y,y-1)*i.get(y-1,y),I=(i.get(y-1,y-1)-i.get(y,y))/2,A=I*I+u,k=Math.sqrt(Math.abs(A)),i.set(y,y,i.get(y,y)+E),i.set(y-1,y-1,i.get(y-1,y-1)+E),f=i.get(y,y),A>=0){for(k=I>=0?I+k:I-k,r[y-1]=f+k,r[y]=r[y-1],0!==k&&(r[y]=f-u/k),e[y-1]=0,e[y]=0,f=i.get(y,y-1),R=Math.abs(f)+Math.abs(k),I=f/R,A=k/R,S=Math.sqrt(I*I+A*A),I/=S,A/=S,s=y-1;s<t;s++)k=i.get(y-1,s),i.set(y-1,s,A*k+I*i.get(y,s)),i.set(y,s,A*i.get(y,s)-I*k);for(o=0;o<=y;o++)k=i.get(o,y-1),i.set(o,y-1,A*k+I*i.get(o,y)),i.set(o,y,A*i.get(o,y)-I*k);for(o=0;o<=x;o++)k=n.get(o,y-1),n.set(o,y-1,A*k+I*n.get(o,y)),n.set(o,y,A*n.get(o,y)-I*k)}else r[y-1]=f+I,r[y]=f+I,e[y-1]=k,e[y]=-k;y-=2,T=0}else{if(f=i.get(y,y),d=0,u=0,l<y&&(d=i.get(y-1,y-1),u=i.get(y,y-1)*i.get(y-1,y)),10===T){for(E+=f,o=0;o<=y;o++)i.set(o,o,i.get(o,o)-f);R=Math.abs(i.get(y,y-1))+Math.abs(i.get(y-1,y-2)),f=d=.75*R,u=-.4375*R*R}if(30===T&&(R=(d-f)/2,R=R*R+u,R>0)){for(R=Math.sqrt(R),d<f&&(R=-R),R=f-u/((d-f)/2+R),o=0;o<=y;o++)i.set(o,o,i.get(o,o)-R);E+=R,f=d=u=.964}for(T+=1,h=y-2;h>=l&&(k=i.get(h,h),S=f-k,R=d-k,I=(S*R-u)/i.get(h+1,h)+i.get(h,h+1),A=i.get(h+1,h+1)-k-S-R,S=i.get(h+2,h+1),R=Math.abs(I)+Math.abs(A)+Math.abs(S),I/=R,A/=R,S/=R,h!==l)&&!(Math.abs(i.get(h,h-1))*(Math.abs(A)+Math.abs(S))<M*(Math.abs(I)*(Math.abs(i.get(h-1,h-1))+Math.abs(k)+Math.abs(i.get(h+1,h+1)))));)h--;for(o=h+2;o<=y;o++)i.set(o,o-2,0),o>h+2&&i.set(o,o-3,0);for(a=h;a<=y-1&&(b=a!==y-1,a!==h&&(I=i.get(a,a-1),A=i.get(a+1,a-1),S=b?i.get(a+2,a-1):0,f=Math.abs(I)+Math.abs(A)+Math.abs(S),0!==f&&(I/=f,A/=f,S/=f)),0!==f);a++)if(R=Math.sqrt(I*I+A*A+S*S),I<0&&(R=-R),0!==R){for(a!==h?i.set(a,a-1,-R*f):l!==h&&i.set(a,a-1,-i.get(a,a-1)),I+=R,f=I/R,d=A/R,k=S/R,A/=I,S/=I,s=a;s<t;s++)I=i.get(a,s)+A*i.get(a+1,s),b&&(I+=S*i.get(a+2,s),i.set(a+2,s,i.get(a+2,s)-I*k)),i.set(a,s,i.get(a,s)-I*f),i.set(a+1,s,i.get(a+1,s)-I*d);for(o=0;o<=Math.min(y,a+3);o++)I=f*i.get(o,a)+d*i.get(o,a+1),b&&(I+=k*i.get(o,a+2),i.set(o,a+2,i.get(o,a+2)-I*S)),i.set(o,a,i.get(o,a)-I),i.set(o,a+1,i.get(o,a+1)-I*A);for(o=0;o<=x;o++)I=f*n.get(o,a)+d*n.get(o,a+1),b&&(I+=k*n.get(o,a+2),n.set(o,a+2,n.get(o,a+2)-I*S)),n.set(o,a,n.get(o,a)-I),n.set(o,a+1,n.get(o,a+1)-I*A)}}}if(0!==v){for(y=t-1;y>=0;y--)if(I=r[y],A=e[y],0===A)for(l=y,i.set(y,y,1),o=y-1;o>=0;o--){for(u=i.get(o,o)-I,S=0,s=l;s<=y;s++)S+=i.get(o,s)*i.get(s,y);if(e[o]<0)k=u,R=S;else if(l=o,0===e[o]?i.set(o,y,0!==u?-S/u:-S/(M*v)):(f=i.get(o,o+1),d=i.get(o+1,o),A=(r[o]-I)*(r[o]-I)+e[o]*e[o],c=(f*R-k*S)/A,i.set(o,y,c),i.set(o+1,y,Math.abs(f)>Math.abs(k)?(-S-u*c)/f:(-R-d*c)/k)),c=Math.abs(i.get(o,y)),M*c*c>1)for(s=o;s<=y;s++)i.set(s,y,i.get(s,y)/c)}else if(A<0)for(l=y-1,Math.abs(i.get(y,y-1))>Math.abs(i.get(y-1,y))?(i.set(y-1,y-1,A/i.get(y,y-1)),i.set(y-1,y,-(i.get(y,y)-I)/i.get(y,y-1))):(_=cdiv(0,-i.get(y-1,y),i.get(y-1,y-1)-I,A),i.set(y-1,y-1,_[0]),i.set(y-1,y,_[1])),i.set(y,y-1,0),i.set(y,y,1),o=y-2;o>=0;o--){for(m=0,g=0,s=l;s<=y;s++)m+=i.get(o,s)*i.get(s,y-1),g+=i.get(o,s)*i.get(s,y);if(u=i.get(o,o)-I,e[o]<0)k=u,S=m,R=g;else if(l=o,0===e[o]?(_=cdiv(-m,-g,u,A),i.set(o,y-1,_[0]),i.set(o,y,_[1])):(f=i.get(o,o+1),d=i.get(o+1,o),p=(r[o]-I)*(r[o]-I)+e[o]*e[o]-A*A,w=2*(r[o]-I)*A,0===p&&0===w&&(p=M*v*(Math.abs(u)+Math.abs(A)+Math.abs(f)+Math.abs(d)+Math.abs(k))),_=cdiv(f*S-k*m+A*g,f*R-k*g-A*m,p,w),i.set(o,y-1,_[0]),i.set(o,y,_[1]),Math.abs(f)>Math.abs(k)+Math.abs(A)?(i.set(o+1,y-1,(-m-u*i.get(o,y-1)+A*i.get(o,y))/f),i.set(o+1,y,(-g-u*i.get(o,y)-A*i.get(o,y-1))/f)):(_=cdiv(-S-d*i.get(o,y-1),-R-d*i.get(o,y),k,A),i.set(o+1,y-1,_[0]),i.set(o+1,y,_[1]))),c=Math.max(Math.abs(i.get(o,y-1)),Math.abs(i.get(o,y))),M*c*c>1)for(s=o;s<=y;s++)i.set(s,y-1,i.get(s,y-1)/c),i.set(s,y,i.get(s,y)/c)}for(o=0;o<t;o++)if(o<0||o>x)for(s=o;s<t;s++)n.set(o,s,i.get(o,s));for(s=t-1;s>=0;s--)for(o=0;o<=x;o++){for(k=0,a=0;a<=Math.min(s,x);a++)k+=n.get(o,a)*i.get(a,s);n.set(o,s,k)}}}function cdiv(t,e,r,n){let i,o;return Math.abs(r)>Math.abs(n)?(i=n/r,o=r+i*n,[(t+i*e)/o,(e-i*t)/o]):(i=r/n,o=n+i*r,[(i*t+e)/o,(i*e-t)/o])}class CholeskyDecomposition{constructor(t){if(!(t=WrapperMatrix2D.checkMatrix(t)).isSymmetric())throw new Error("Matrix is not symmetric");let e,r,n,i=t,o=i.rows,s=new Matrix$2(o,o),a=!0;for(r=0;r<o;r++){let t=0;for(n=0;n<r;n++){let o=0;for(e=0;e<n;e++)o+=s.get(n,e)*s.get(r,e);o=(i.get(r,n)-o)/s.get(n,n),s.set(r,n,o),t+=o*o}for(t=i.get(r,r)-t,a&&=t>0,s.set(r,r,Math.sqrt(Math.max(t,0))),n=r+1;n<o;n++)s.set(r,n,0)}this.L=s,this.positiveDefinite=a}isPositiveDefinite(){return this.positiveDefinite}solve(t){t=WrapperMatrix2D.checkMatrix(t);let e=this.L,r=e.rows;if(t.rows!==r)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let n,i,o,s=t.columns,a=t.clone();for(o=0;o<r;o++)for(i=0;i<s;i++){for(n=0;n<o;n++)a.set(o,i,a.get(o,i)-a.get(n,i)*e.get(o,n));a.set(o,i,a.get(o,i)/e.get(o,o))}for(o=r-1;o>=0;o--)for(i=0;i<s;i++){for(n=o+1;n<r;n++)a.set(o,i,a.get(o,i)-a.get(n,i)*e.get(n,o));a.set(o,i,a.get(o,i)/e.get(o,o))}return a}get lowerTriangularMatrix(){return this.L}}class nipals{constructor(t,e={}){t=WrapperMatrix2D.checkMatrix(t);let{Y:r}=e;const{scaleScores:n=!1,maxIterations:i=1e3,terminationCriteria:o=1e-10}=e;let s;if(r){if(r=isAnyArray.isAnyArray(r)&&"number"==typeof r[0]?Matrix$2.columnVector(r):WrapperMatrix2D.checkMatrix(r),r.rows!==t.rows)throw new Error("Y should have the same number of rows as X");s=r.getColumnVector(0)}else s=t.getColumnVector(0);let a,l,h,c,u=1;for(let e=0;e<i&&u>o;e++)h=t.transpose().mmul(s).div(s.transpose().mmul(s).get(0,0)),h=h.div(h.norm()),a=t.mmul(h).div(h.transpose().mmul(h).get(0,0)),e>0&&(u=a.clone().sub(c).pow(2).sum()),c=a.clone(),r?(l=r.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),l=l.div(l.norm()),s=r.mmul(l).div(l.transpose().mmul(l).get(0,0))):s=a;if(r){let e=t.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0));e=e.div(e.norm());let n=t.clone().sub(a.clone().mmul(e.transpose())),i=s.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),o=r.clone().sub(a.clone().mulS(i.get(0,0)).mmul(l.transpose()));this.t=a,this.p=e.transpose(),this.w=h.transpose(),this.q=l,this.u=s,this.s=a.transpose().mmul(a),this.xResidual=n,this.yResidual=o,this.betas=i}else this.w=h.transpose(),this.s=a.transpose().mmul(a).sqrt(),this.t=n?a.clone().div(this.s.get(0,0)):a,this.xResidual=t.sub(a.mmul(h.transpose()))}}matrix.AbstractMatrix=AbstractMatrix,matrix.CHO=CholeskyDecomposition,matrix.CholeskyDecomposition=CholeskyDecomposition,matrix.DistanceMatrix=DistanceMatrix,matrix.EVD=EigenvalueDecomposition$1;var EigenvalueDecomposition_1=matrix.EigenvalueDecomposition=EigenvalueDecomposition$1;matrix.LU=LuDecomposition,matrix.LuDecomposition=LuDecomposition;var Matrix_1=matrix.Matrix=Matrix$2;matrix.MatrixColumnSelectionView=MatrixColumnSelectionView,matrix.MatrixColumnView=MatrixColumnView,matrix.MatrixFlipColumnView=MatrixFlipColumnView,matrix.MatrixFlipRowView=MatrixFlipRowView,matrix.MatrixRowSelectionView=MatrixRowSelectionView,matrix.MatrixRowView=MatrixRowView,matrix.MatrixSelectionView=MatrixSelectionView,matrix.MatrixSubView=MatrixSubView,matrix.MatrixTransposeView=MatrixTransposeView,matrix.NIPALS=nipals,matrix.Nipals=nipals,matrix.QR=QrDecomposition,matrix.QrDecomposition=QrDecomposition;var SVD$1=matrix.SVD=SingularValueDecomposition$1,SingularValueDecomposition_1=matrix.SingularValueDecomposition=SingularValueDecomposition$1;matrix.SymmetricMatrix=SymmetricMatrix;var WrapperMatrix1D_1=matrix.WrapperMatrix1D=WrapperMatrix1D$1;matrix.WrapperMatrix2D=WrapperMatrix2D,matrix.correlation=correlation,matrix.covariance=covariance;var _default=matrix.default=Matrix$2,determinant_1=matrix.determinant=determinant$1,inverse_1=matrix.inverse=inverse$1;matrix.linearDependencies=linearDependencies;var pseudoInverse_1=matrix.pseudoInverse=pseudoInverse$1;matrix.solve=solve,matrix.wrap=wrap;const EigenvalueDecomposition=EigenvalueDecomposition_1,Matrix=Matrix_1,SVD=SVD$1,SingularValueDecomposition=SingularValueDecomposition_1,WrapperMatrix1D=WrapperMatrix1D_1;var Matrix$1=_default.Matrix?_default.Matrix:Matrix_1;const determinant=determinant_1,inverse=inverse_1,pseudoInverse=pseudoInverse_1;function getCentroid(t){let e=new Matrix$1(3,1);const r=t.columns;let n=0,i=0;for(let e=0;e<r;e++)n+=t.get(0,e),i+=t.get(1,e);return e.set(0,0,n/r),e.set(1,0,i/r),e}function getAffineTransform$1(t,e){if(t.columns!==e.columns)throw new Error("Source and destination matrices should have same dimensions (same number of points).");if(t.columns<2)throw new Error("Matrices should contain at least two points for the algorithm to run properly.");const r=getCentroid(t),n=getCentroid(e),i=t.clone().subColumnVector(r),o=e.clone().subColumnVector(n);let s=0;const a=t.columns;for(let t=0;t<a;t++){const e=i.getColumn(t);s+=getDistanceToOrigin(o.getColumn(t))/getDistanceToOrigin(e)}const l=s/a,h=Matrix$1.mul(i,l).mmul(o.transpose()),c=new SingularValueDecomposition(h),u=c.leftSingularVectors,f=c.rightSingularVectors;let d=f.mmul(u.transpose());if(determinant(d)<0){d=f.mulColumn(2,-1).mmul(u.transpose())}let m=180*Math.atan2(d.get(1,0),d.get(0,0))/Math.PI;-180===m&&(m=180);const g=Matrix$1.sub(n,Matrix$1.mul(d.mmul(r),l));return{translation:{x:g.get(0,0),y:g.get(1,0)},rotation:m,scale:l}}function getDistanceToOrigin(t){return Math.hypot(t[0],t[1])}var medianQuickselect_min={exports:{}};!function(t){!function(){function e(t){for(var e=0,i=t.length-1,o=void 0,s=void 0,a=void 0,l=n(e,i);;){if(i<=e)return t[l];if(i==e+1)return t[e]>t[i]&&r(t,e,i),t[l];for(t[o=n(e,i)]>t[i]&&r(t,o,i),t[e]>t[i]&&r(t,e,i),t[o]>t[e]&&r(t,o,e),r(t,o,e+1),s=e+1,a=i;;){do{s++}while(t[e]>t[s]);do{a--}while(t[a]>t[e]);if(a<s)break;r(t,s,a)}r(t,e,a),a<=l&&(e=s),a>=l&&(i=a-1)}}var r=function(t,e,r){var n;return n=[t[r],t[e]],t[e]=n[0],t[r]=n[1],n},n=function(t,e){return~~((t+e)/2)};t.exports?t.exports=e:window.median=e}()}(medianQuickselect_min);var medianQuickselect_minExports=medianQuickselect_min.exports,quickMedian=getDefaultExportFromCjs(medianQuickselect_minExports);function median$1(t){if(!isAnyArray$1(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");return quickMedian(t.slice())}const LOOP$1=8,FLOAT_MUL$1=1/16777216,sh1$1=15,sh2$1=18,sh3$1=11;function multiply_uint32(t,e){const r=65535&(t>>>=0);return((t-r)*(e>>>=0)>>>0)+r*e>>>0}let XSadd$1=class{constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL$1}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP$1;t++)this.state[3&t]^=t+multiply_uint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP$1;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1$1,t^=t>>>sh2$1,t^=this.state[3]<<sh3$1,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}};const PROB_TOLERANCE=1e-8;function randomChoice(t,e={},r=Math.random){const{size:n=1,replace:i=!1,probabilities:o}=e;let s,a;if(s="number"==typeof t?getArray(t):t.slice(),o){if(!i)throw new Error("choice with probabilities and no replacement is not implemented");if(o.length!==s.length)throw new Error("the length of probabilities option should be equal to the number of choices");a=[o[0]];for(let t=1;t<o.length;t++)a[t]=a[t-1]+o[t];if(Math.abs(1-a[a.length-1])>PROB_TOLERANCE)throw new Error(`probabilities should sum to 1, but instead sums to ${a[a.length-1]}`)}if(!1===i&&n>s.length)throw new Error("size option is too large");const l=[];for(let t=0;t<n;t++){const t=randomIndex(s.length,r,a);l.push(s[t]),i||s.splice(t,1)}return l}function getArray(t){const e=[];for(let r=0;r<t;r++)e.push(r);return e}function randomIndex(t,e,r){const n=e();if(r){let t=0;for(;n>r[t];)t++;return t}return Math.floor(n*t)}class Random{constructor(t=Math.random){if("number"==typeof t){const e=new XSadd$1(t);this.randomGenerator=e.random}else this.randomGenerator=t}choice(t,e){return randomChoice(t,e,this.randomGenerator)}random(){return this.randomGenerator()}randInt(t,e){return void 0===e&&(e=t,t=0),t+Math.floor(this.randomGenerator()*(e-t))}randomSample(t){const e=[];for(let r=0;r<t;r++)e.push(this.random());return e}}function getNbIterations(t,e,r){const n=Math.log10(1-t)/Math.log10(1-(1-e)**r);return Math.ceil(n)}function ransac(t,e,r){let n=0;n=r.minNbInliers?getNbValues(r.minNbInliers,t.length):t.length;const{sampleSize:i=2,threshold:o=1,fitFunction:s,distanceFunction:a,modelFunction:l,seed:h}=r;if(t.length!==e.length)throw new Error("source and destination data should have the same length");let c;if("outliersFraction"in r){const{stopProbabilty:t=.99}=r;c=getNbIterations(t,r.outliersFraction,i)}else c=r.maxNbIterations?r.maxNbIterations:100;let u=0,f=0,d=[],m=[],g=0,p=[];for(void 0!==h&&(p=new Random(h).choice(c,{size:c}));u<c;){let r;u++,r=void 0!==h?new Random(p[u]).choice(t.length,{size:i}):(new Random).choice(t.length,{size:i});const c=[],w=[];for(let n of r)c.push(t[n]),w.push(e[n]);const b=s(c,w),_=l(b);let y=[];for(let e of t)y.push(_(e));let x=0,M=[],E=[],v=0;for(let t=0;t<e.length;t++){if(r.includes(t)){x++,M.push(t);continue}const n=a(e[t],y[t]);E.push(n),n<o&&(x++,M.push(t))}if(v=median$1(E),x>f&&(f=x,d=M,m=b,g=v,x>=n))return{modelParameters:b,inliers:M,nbIterations:u,error:v}}return{modelParameters:m,inliers:d,nbIterations:c,error:g}}function getNbValues(t,e){return Number.isInteger(t)?t:Math.ceil(t*e)}function getDistanceMatrix(t){const e=t.length,r=new Array(e);for(let t=0;t<e;t++)r[t]=new Float64Array(e).fill(0);for(let n=0;n<e;n++){const i=t[n].origin;for(let o=n;o<e;o++){n===o&&(r[n][o]=0);const e=t[o].origin,s=(i.row-e.row)**2+(i.column-e.column)**2;r[n][o]=s,r[o][n]=s}}return r}function getKeypointsInRadius(t,e){const r=t.length,n=getDistanceMatrix(t),i=e**2,o=[];for(let t=0;t<r;t++){const e=[];for(let o=0;o<r;o++)t!==o&&n[t][o]<=i&&e.push(o);o.push(e)}return o}function getBestKeypointsInRadius(t,e=5){const r=t.length,n=getKeypointsInRadius(t,e),i=new Uint8Array(r).fill(0);for(let e=0;e<r;e++){const r=t[e];for(const o of n[e]){const n=t[o];r.score<n.score&&(i[e]=1)}}const o=[];for(let e=0;e<r;e++)i[e]||o.push(t[e]);return o}function difference(t,e){return{column:t.column-e.column,row:t.row-e.row}}function sum$1(t,e){return{column:t.column+e.column,row:t.row+e.row}}function normalize(t){const e=Math.hypot(t.column,t.row);return{column:t.column/e,row:t.row/e}}function rotate$1(t,e){const r=[],n=Math.cos(t),i=Math.sin(t);for(const t of e)r.push({column:n*t.column-i*t.row,row:i*t.column+n*t.row});return r}function sortByColumnRow(t){const e=t.slice();return e.sort((t,e)=>t.column<e.column?-1:t.column>e.column?1:t.row-e.row),e}function getAngle(t,e){const r=normalize(difference(e,t)),n=Math.acos(r.column);return r.row<0?-n:n}function getClockwiseAngle(t,e){const r=normalize(difference(e,t)),n=-Math.atan(r.row/r.column);return r.column<0?r.row<0?n-Math.PI:n+Math.PI:n}function toDegrees(t){return 180*t/Math.PI}function getRadius(t){if(t%2!=1||t<0)throw new RangeError("size must be positive and odd");return(t-1)/2}function checkBorderDistance(t,e,r){return e.column>=r&&e.row>=r&&t.width-e.column>r&&t.height-e.row>r}const t$2=Symbol.for("@ts-pattern/matcher"),e$2=Symbol.for("@ts-pattern/isVariadic"),n$2="@ts-pattern/anonymous-select-key",r$2=t=>Boolean(t&&"object"==typeof t),i$2=t=>t&&!!t[t$2],o$2=(t,e,r)=>{if(i$2(t)){const n=t[t$2](),{matched:i,selections:o}=n.match(e);return i&&o&&Object.keys(o).forEach(t=>r(t,o[t])),i}if(r$2(t)){if(!r$2(e))return!1;if(Array.isArray(t)){if(!Array.isArray(e))return!1;let n=[],i=[],o=[];for(const e of t.keys()){const r=t[e];i$2(r)&&r[e$2]?o.push(r):o.length?i.push(r):n.push(r)}if(o.length){if(o.length>1)throw new Error("Pattern error: Using `...P.array(...)` several times in a single pattern is not allowed.");if(e.length<n.length+i.length)return!1;const t=e.slice(0,n.length),s=0===i.length?[]:e.slice(-i.length),a=e.slice(n.length,0===i.length?1/0:-i.length);return n.every((e,n)=>o$2(e,t[n],r))&&i.every((t,e)=>o$2(t,s[e],r))&&(0===o.length||o$2(o[0],a,r))}return t.length===e.length&&t.every((t,n)=>o$2(t,e[n],r))}return Reflect.ownKeys(t).every(n=>{const i=t[n];return(n in e||i$2(o=i)&&"optional"===o[t$2]().matcherType)&&o$2(i,e[n],r);var o})}return Object.is(e,t)},s$1=t=>{var e,r,n;return r$2(t)?i$2(t)?null!=(e=null==(r=(n=t[t$2]()).getSelectionKeys)?void 0:r.call(n))?e:[]:Array.isArray(t)?c$1(t,s$1):c$1(Object.values(t),s$1):[]},c$1=(t,e)=>t.reduce((t,r)=>t.concat(e(r)),[]);function u$2(...t){if(1===t.length){const[e]=t;return t=>o$2(e,t,()=>{})}if(2===t.length){const[e,r]=t;return o$2(e,r,()=>{})}throw new Error(`isMatching wasn't given the right number of arguments: expected 1 or 2, received ${t.length}.`)}function a$2(t){return Object.assign(t,{optional:()=>h$2(t),and:e=>d$1(t,e),or:e=>y$1(t,e),select:e=>void 0===e?v$1(t):v$1(e,t)})}function l$2(t){return Object.assign((t=>Object.assign(t,{[Symbol.iterator](){let e=0;const r=[{value:Object.assign(t,{[e$2]:!0}),done:!1},{done:!0,value:void 0}];return{next:()=>{var t;return null!=(t=r[e++])?t:r.at(-1)}}}}))(t),{optional:()=>l$2(h$2(t)),select:e=>l$2(void 0===e?v$1(t):v$1(e,t))})}function h$2(t){return a$2({[t$2]:()=>({match:e=>{let r={};const n=(t,e)=>{r[t]=e};return void 0===e?(s$1(t).forEach(t=>n(t,void 0)),{matched:!0,selections:r}):{matched:o$2(t,e,n),selections:r}},getSelectionKeys:()=>s$1(t),matcherType:"optional"})})}const f$1=(t,e)=>{for(const r of t)if(!e(r))return!1;return!0},g$1=(t,e)=>{for(const[r,n]of t.entries())if(!e(n,r))return!1;return!0},m$1=(t,e)=>{const r=Reflect.ownKeys(t);for(const n of r)if(!e(n,t[n]))return!1;return!0};function d$1(...t){return a$2({[t$2]:()=>({match:e=>{let r={};const n=(t,e)=>{r[t]=e};return{matched:t.every(t=>o$2(t,e,n)),selections:r}},getSelectionKeys:()=>c$1(t,s$1),matcherType:"and"})})}function y$1(...t){return a$2({[t$2]:()=>({match:e=>{let r={};const n=(t,e)=>{r[t]=e};return c$1(t,s$1).forEach(t=>n(t,void 0)),{matched:t.some(t=>o$2(t,e,n)),selections:r}},getSelectionKeys:()=>c$1(t,s$1),matcherType:"or"})})}function p$2(t){return{[t$2]:()=>({match:e=>({matched:Boolean(t(e))})})}}function v$1(...t){const e="string"==typeof t[0]?t[0]:void 0,r=2===t.length?t[1]:"string"==typeof t[0]?void 0:t[0];return a$2({[t$2]:()=>({match:t=>{let n={[null!=e?e:n$2]:t};return{matched:void 0===r||o$2(r,t,(t,e)=>{n[t]=e}),selections:n}},getSelectionKeys:()=>[null!=e?e:n$2].concat(void 0===r?[]:s$1(r))})})}function b$2(t){return!0}function w$2(t){return"number"==typeof t}function S$1(t){return"string"==typeof t}function j$1(t){return"bigint"==typeof t}const K=a$2(p$2(b$2)),O=a$2(p$2(b$2)),E=K,x$1=t=>Object.assign(a$2(t),{startsWith:e=>{return x$1(d$1(t,(r=e,p$2(t=>S$1(t)&&t.startsWith(r)))));var r},endsWith:e=>{return x$1(d$1(t,(r=e,p$2(t=>S$1(t)&&t.endsWith(r)))));var r},minLength:e=>x$1(d$1(t,(t=>p$2(e=>S$1(e)&&e.length>=t))(e))),length:e=>x$1(d$1(t,(t=>p$2(e=>S$1(e)&&e.length===t))(e))),maxLength:e=>x$1(d$1(t,(t=>p$2(e=>S$1(e)&&e.length<=t))(e))),includes:e=>{return x$1(d$1(t,(r=e,p$2(t=>S$1(t)&&t.includes(r)))));var r},regex:e=>{return x$1(d$1(t,(r=e,p$2(t=>S$1(t)&&Boolean(t.match(r))))));var r}}),A=x$1(p$2(S$1)),N$1=t=>Object.assign(a$2(t),{between:(e,r)=>N$1(d$1(t,((t,e)=>p$2(r=>w$2(r)&&t<=r&&e>=r))(e,r))),lt:e=>N$1(d$1(t,(t=>p$2(e=>w$2(e)&&e<t))(e))),gt:e=>N$1(d$1(t,(t=>p$2(e=>w$2(e)&&e>t))(e))),lte:e=>N$1(d$1(t,(t=>p$2(e=>w$2(e)&&e<=t))(e))),gte:e=>N$1(d$1(t,(t=>p$2(e=>w$2(e)&&e>=t))(e))),int:()=>N$1(d$1(t,p$2(t=>w$2(t)&&Number.isInteger(t)))),finite:()=>N$1(d$1(t,p$2(t=>w$2(t)&&Number.isFinite(t)))),positive:()=>N$1(d$1(t,p$2(t=>w$2(t)&&t>0))),negative:()=>N$1(d$1(t,p$2(t=>w$2(t)&&t<0)))}),P=N$1(p$2(w$2)),k$1=t=>Object.assign(a$2(t),{between:(e,r)=>k$1(d$1(t,((t,e)=>p$2(r=>j$1(r)&&t<=r&&e>=r))(e,r))),lt:e=>k$1(d$1(t,(t=>p$2(e=>j$1(e)&&e<t))(e))),gt:e=>k$1(d$1(t,(t=>p$2(e=>j$1(e)&&e>t))(e))),lte:e=>k$1(d$1(t,(t=>p$2(e=>j$1(e)&&e<=t))(e))),gte:e=>k$1(d$1(t,(t=>p$2(e=>j$1(e)&&e>=t))(e))),positive:()=>k$1(d$1(t,p$2(t=>j$1(t)&&t>0))),negative:()=>k$1(d$1(t,p$2(t=>j$1(t)&&t<0)))}),T=k$1(p$2(j$1)),B=a$2(p$2(function(t){return"boolean"==typeof t})),_=a$2(p$2(function(t){return"symbol"==typeof t})),W=a$2(p$2(function(t){return null==t})),$$1=a$2(p$2(function(t){return null!=t}));var z={__proto__:null,matcher:t$2,optional:h$2,array:function(...t){return l$2({[t$2]:()=>({match:e=>{if(!Array.isArray(e))return{matched:!1};if(0===t.length)return{matched:!0};const r=t[0];let n={};if(0===e.length)return s$1(r).forEach(t=>{n[t]=[]}),{matched:!0,selections:n};const i=(t,e)=>{n[t]=(n[t]||[]).concat([e])};return{matched:e.every(t=>o$2(r,t,i)),selections:n}},getSelectionKeys:()=>0===t.length?[]:s$1(t[0])})})},set:function(...t){return a$2({[t$2]:()=>({match:e=>{if(!(e instanceof Set))return{matched:!1};let r={};if(0===e.size)return{matched:!0,selections:r};if(0===t.length)return{matched:!0};const n=(t,e)=>{r[t]=(r[t]||[]).concat([e])},i=t[0];return{matched:f$1(e,t=>o$2(i,t,n)),selections:r}},getSelectionKeys:()=>0===t.length?[]:s$1(t[0])})})},map:function(...t){return a$2({[t$2]:()=>({match:e=>{if(!(e instanceof Map))return{matched:!1};let r={};if(0===e.size)return{matched:!0,selections:r};const n=(t,e)=>{r[t]=(r[t]||[]).concat([e])};if(0===t.length)return{matched:!0};var i;if(1===t.length)throw new Error(`\`P.map\` wasn't given enough arguments. Expected (key, value), received ${null==(i=t[0])?void 0:i.toString()}`);const[o,s]=t;return{matched:g$1(e,(t,e)=>{const r=o$2(o,e,n),i=o$2(s,t,n);return r&&i}),selections:r}},getSelectionKeys:()=>0===t.length?[]:[...s$1(t[0]),...s$1(t[1])]})})},record:function(...t){return a$2({[t$2]:()=>({match:e=>{if(null===e||"object"!=typeof e||Array.isArray(e))return{matched:!1};var r;if(0===t.length)throw new Error(`\`P.record\` wasn't given enough arguments. Expected (value) or (key, value), received ${null==(r=t[0])?void 0:r.toString()}`);let n={};const i=(t,e)=>{n[t]=(n[t]||[]).concat([e])},[o,s]=1===t.length?[A,t[0]]:t;return{matched:m$1(e,(t,e)=>{const r="string"!=typeof t||Number.isNaN(Number(t))?null:Number(t),n=null!==r&&o$2(o,r,i),a=o$2(o,t,i),l=o$2(s,e,i);return(a||n)&&l}),selections:n}},getSelectionKeys:()=>0===t.length?[]:[...s$1(t[0]),...s$1(t[1])]})})},intersection:d$1,union:y$1,not:function(t){return a$2({[t$2]:()=>({match:e=>({matched:!o$2(t,e,()=>{})}),getSelectionKeys:()=>[],matcherType:"not"})})},when:p$2,select:v$1,any:K,unknown:O,_:E,string:A,number:P,bigint:T,boolean:B,symbol:_,nullish:W,nonNullable:$$1,instanceOf:function(t){return a$2(p$2(function(t){return e=>e instanceof t}(t)))},shape:function(t){return a$2(p$2(u$2(t)))}};class I extends Error{constructor(t){let e;try{e=JSON.stringify(t)}catch(r){e=t}super(`Pattern matching error: no pattern matches value ${e}`),this.input=void 0,this.input=t}}const L={matched:!1,value:void 0};function M$2(t){return new R(t,L)}class R{constructor(t,e){this.input=void 0,this.state=void 0,this.input=t,this.state=e}with(...t){if(this.state.matched)return this;const e=t[t.length-1],r=[t[0]];let n;3===t.length&&"function"==typeof t[1]?n=t[1]:t.length>2&&r.push(...t.slice(1,t.length-1));let i=!1,o={};const s=(t,e)=>{i=!0,o[t]=e},a=!r.some(t=>o$2(t,this.input,s))||n&&!Boolean(n(this.input))?L:{matched:!0,value:e(i?n$2 in o?o[n$2]:o:this.input,this.input)};return new R(this.input,a)}when(t,e){if(this.state.matched)return this;const r=Boolean(t(this.input));return new R(this.input,r?{matched:!0,value:e(this.input,this.input)}:L)}otherwise(t){return this.state.matched?this.state.value:t(this.input)}exhaustive(t=F){return this.state.matched?this.state.value:t(this.input)}run(){return this.exhaustive()}returnType(){return this}narrow(){return this}}function F(t){throw new I(t)}var index_umd$1={exports:{}},index_umd=index_umd$1.exports,exports$1;exports$1=index_umd$1.exports,function(t){function e(t,e,r,n,i){const o=Math.abs(r-t),s=t<r?1:-1,a=-Math.abs(n-e),l=e<n?1:-1;let h,c=o+a;for(;;){if(i(t,e),h=2*c,h>=a){if(t===r)break;c+=a,t+=s}if(h<=o){if(e===n)break;c+=o,e+=l}}}function r(t,e,r,n,i){const o=t<r?1:-1,s=e<n?1:-1;let a,l=Math.abs(r-t),h=Math.abs(n-e),c=l*l+h*h,u=0===c?1:1/Math.sqrt(c);for(l*=u,h*=u,c=l-h;;){if(i(t,e,Math.abs(c-(l+h))>>16),u=c,a=t,2*u>=-l){if(t===r)break;u+h<16711680&&i(t,e+s,u+h>>16),c-=h,t+=o}if(2*u<=h){if(e===n)break;l-u<16711680&&i(a+o,e,l-u>>16),c+=l,e+=s}}}function n(t,e,r,n,i,o){let s,a,l,h=Math.abs(r-t),c=t<r?1:-1,u=Math.abs(n-e),f=e<n?1:-1,d=h-u,m=h+u==0?1:Math.sqrt(h*h+u*u);for(i=(i+1)/2;;){if(o(t,e,Math.max(0,255*(Math.abs(d-h+u)/m-i+1))),s=d,a=t,2*s>=-h){for(s+=u,l=e;s<m*i&&(n!=l||h>u);s+=h)o(t,l+=f,Math.max(0,255*(Math.abs(s)/m-i+1)));if(t==r)break;s=d,d-=u,t+=c}if(2*s<=u){for(s=h-s;s<m*i&&(r!=a||h<u);s+=u)o(a+=c,e,Math.max(0,255*(Math.abs(s)/m-i+1)));if(e==n)break;d+=h,e+=f}}}function i(t,e="assert error"){if(!t)throw new Error(e)}function o(t,e,r,n,o,a,l,h){var c,u,f,d=t-2*r+o,m=e-2*n+a,g=t-r,p=e-n;i(l>=0,"width is negative"),g*(o-r)>0&&(p*(a-n)>0&&Math.abs(g*m)>Math.abs(p*d)&&(t=o,o=g+r,e=a,a=p+n),t==o||1==l?u=(t-r)/d:(f=Math.sqrt(4*l*l*(t-r)*(o-r)+(o-t)*(o-t)),r<t&&(f=-f),u=(2*l*(t-r)-t+o+f)/(2*(1-l)*(o-t))),g=(u*u*(t-2*l*r+o)+2*u*(l*r-t)+t)*(f=1/(2*u*(1-u)*(l-1)+1)),p=(u*u*(e-2*l*n+a)+2*u*(l*n-e)+e)*f,c=u*(l-1)+1,c*=c*f,l=((1-u)*(l-1)+1)*Math.sqrt(f),d=Math.floor(g+.5),m=Math.floor(p+.5),p=(g-t)*(n-e)/(r-t)+e,s(t,e,d,Math.floor(p+.5),d,m,c,h),p=(g-o)*(n-a)/(r-o)+a,n=Math.floor(p+.5),t=r=d,e=m),(e-n)*(a-n)>0&&(e==a||1==l?u=(e-n)/(e-2*n+a):(f=Math.sqrt(4*l*l*(e-n)*(a-n)+(a-e)*(a-e)),n<e&&(f=-f),u=(2*l*(e-n)-e+a+f)/(2*(1-l)*(a-e))),g=(u*u*(t-2*l*r+o)+2*u*(l*r-t)+t)*(f=1/(2*u*(1-u)*(l-1)+1)),p=(u*u*(e-2*l*n+a)+2*u*(l*n-e)+e)*f,c=u*(l-1)+1,c*=c*f,l=((1-u)*(l-1)+1)*Math.sqrt(f),d=Math.floor(g+.5),m=Math.floor(p+.5),g=(r-t)*(p-e)/(n-e)+t,s(t,e,Math.floor(g+.5),m,d,m,c,h),g=(r-o)*(p-a)/(n-a)+o,r=Math.floor(g+.5),t=d,e=n=m),s(t,e,r,n,o,a,l*l,h)}function s(t,r,n,o,a,l,h,c){var u,f=a-n,d=l-o,m=t-a,g=r-l,p=t-n,w=r-o,b=p*d+w*f,_=p*d-w*f;if(i(p*f<=0&&w*d<=0,"sign of gradient must not change"),0!=_&&h>0){if(f*f+d*d>p*p+w*w&&(a=t,t-=m,l=r,r-=g,_=-_),p=2*(4*h*f*p+m*m),w=2*(4*h*d*w+g*g),b=-2*(f=t<a?1:-1)*(d=r<l?1:-1)*(2*h*b+m*g),_*f*d<0&&(p=-p,w=-w,b=-b,_=-_),m=4*h*(n-t)*d*_+p/2+b,g=4*h*(r-o)*f*_+w/2+b,h<.5&&(g>b||m<b))return _=(h+1)/2,b=1/((h=Math.sqrt(h))+1),f=Math.floor((t+2*h*n+a)*b/2+.5),d=Math.floor((r+2*h*o+l)*b/2+.5),s(t,r,m=Math.floor((h*n+t)*b+.5),g=Math.floor((o*h+r)*b+.5),f,d,_,c),void s(f,d,m=Math.floor((h*n+a)*b+.5),g=Math.floor((o*h+l)*b+.5),a,l,_,c);u=m+g-b;do{if(c(t,r),t==a&&r==l)return;n=2*u>g?1:0,o=2*(u+w)<-g?1:0,(2*u<m||o)&&(r+=d,g+=b,u+=m+=p),(2*u>m||n)&&(t+=f,m+=b,u+=g+=w)}while(g<=b&&m>=b)}e(t,r,a,l,c)}function a(t,e,n,o,s,l,h,c){var u,f,d,m=s-n,g=l-o,p=t-s,w=e-l,b=t-n,_=e-o,y=b*g+_*m,x=b*g-_*m;if(i(b*m<=0&&_*g<=0),0!=x&&h>0){if(m*m+g*g>b*b+_*_&&(s=t,t-=p,l=e,e-=w,x=-x),b=2*(4*h*m*b+p*p),_=2*(4*h*g*_+w*w),y=-2*(m=t<s?1:-1)*(g=e<l?1:-1)*(2*h*y+p*w),x*m*g<0&&(b=-b,_=-_,x=-x,y=-y),p=4*h*(n-t)*g*x+b/2+y,w=4*h*(e-o)*m*x+_/2+y,h<.5&&w>p)return x=(h+1)/2,y=1/((h=Math.sqrt(h))+1),m=Math.floor((t+2*h*n+s)*y/2+.5),g=Math.floor((e+2*h*o+l)*y/2+.5),a(t,e,p=Math.floor((h*n+t)*y+.5),w=Math.floor((o*h+e)*y+.5),m,g,x,c),a(m,g,p=Math.floor((h*n+s)*y+.5),w=Math.floor((o*h+l)*y+.5),s,l,x,c);u=p+w-y;do{if(x=Math.min(p-y,y-w),f=Math.max(p-y,y-w),f+=2*f*x*x/(4*f*f+x*x),(n=255*Math.abs(u-p-w+y)/f)<256&&c(t,e,n),d=2*u+w<0){if(e==l)return;p-u<f&&c(t+m,e,255*Math.abs(p-u)/f)}if(2*u+p>0){if(t==s)return;u-w<f&&c(t,e+g,255*Math.abs(u-w)/f),t+=m,p+=y,u+=w+=_}d&&(e+=g,w+=y,u+=p+=b)}while(w<p)}r(t,e,s,l,c)}function l(t,e,r,n,i){let o=-r,s=0,a=n*n,l=o*(2*a+o)+a;do{i(t-o,e+s),i(t+o,e+s),i(t+o,e-s),i(t-o,e-s),a=2*l,a>=(2*o+1)*n*n&&(l+=(2*++o+1)*n*n),a<=(2*s+1)*r*r&&(l+=(2*++s+1)*r*r)}while(o<=0);for(;s++<n;)i(t,e+s),i(t,e-s)}function h(t,e,r,n,i,o){let s=r*r,a=n*n;const l=Math.sin(i);let h=(s-a)*l;s=Math.sqrt(s-h*l),a=Math.sqrt(a+h*l),h=h*(r=s+.5)*(n=a+.5)/(s*a),c(t-r,e-n,t+r,e+n,4*h*Math.cos(i),o)}function c(t,e,r,n,o,a){let l=r-t,h=n-e,c=l*h;if(0===o)return u(t,e,r,n,a);0!==c&&(c=(c-o)/(c+c)),i(c<=1&&c>=0,"limit angle to |zd|<=xd*yd"),l=Math.floor(l*c+.5),h=Math.floor(h*c+.5),s(t,e+h,t,e,t+l,e,1-c,a),s(t,e+h,t,n,r-l,n,c,a),s(r,n-h,r,n,r-l,n,1-c,a),s(r,n-h,r,e,t+l,e,c,a)}function u(t,e,r,n,i){let o,s=Math.abs(r-t),a=Math.abs(n-e),l=1&a,h=4*(1-s)*a*a,c=4*(l+1)*s*s,u=h+c+l*s*s;t>r&&(t=r,r+=s),e>n&&(e=n),n=(e+=(a+1)/2)-l,s*=8*s,l=8*a*a;do{i(r,e),i(t,e),i(t,n),i(r,n),o=2*u,o<=c&&(e++,n--,u+=c+=s),(o>=h||2*u>c)&&(t++,r--,u+=h+=l)}while(t<=r);for(;e-n<=a;)i(t-1,e),i(r+1,e++),i(t-1,n),i(r+1,n--)}function f(t,e,r,n){var i=-r,o=0,s=2-2*r;do{n(t-i,e+o),n(t-o,e-i),n(t+i,e-o),n(t+o,e+i),(r=s)<=o&&(s+=2*++o+1),(r>i||s>o)&&(s+=2*++i+1)}while(i<0)}function d(t,e,r,n){var i,o,s,a=-r,l=0,h=2-2*r;r=1-h;do{n(t-a,e+l,i=255*Math.abs(h-2*(a+l)-2)/r),n(t-l,e-a,i),n(t+a,e-l,i),n(t+l,e+a,i),s=h,o=a,h+l>0&&((i=255*(h-2*a-1)/r)<256&&(n(t-a,e+l+1,i),n(t-l-1,e-a,i),n(t+a,e-l-1,i),n(t+l+1,e+a,i)),h+=2*++a+1),s+o<=0&&((i=255*(2*l+3-s)/r)<256&&(n(t-o-1,e+l,i),n(t-l,e-o-1,i),n(t+o+1,e-l,i),n(t+l,e+o+1,i)),h+=2*++l+1)}while(a<0)}function m(t,e,r,n,i,o,s){var a,l=t-r,h=e-n,c=t-2*r+i;l*(i-r)>0&&(h*(o-n)>0&&Math.abs((e-2*n+o)/c*l)>Math.abs(h)&&(t=i,i=l+r,e=o,o=h+n),a=(1-(c=(t-r)/c))*((1-c)*e+2*c*n)+c*c*o,c=(t*i-r*r)*c/(t-r),l=Math.floor(c+.5),h=Math.floor(a+.5),a=(n-e)*(c-t)/(r-t)+e,g(t,e,l,Math.floor(a+.5),l,h,s),a=(n-o)*(c-i)/(r-i)+o,t=r=l,e=h,n=Math.floor(a+.5)),(e-n)*(o-n)>0&&(a=(1-(c=(e-n)/(c=e-2*n+o)))*((1-c)*t+2*c*r)+c*c*i,c=(e*o-n*n)*c/(e-n),l=Math.floor(a+.5),h=Math.floor(c+.5),a=(r-t)*(c-e)/(n-e)+t,g(t,e,Math.floor(a+.5),h,l,h,s),a=(r-i)*(c-o)/(n-o)+i,t=l,r=Math.floor(a+.5),e=n=h),g(t,e,r,n,i,o,s)}function g(t,r,n,o,s,a,l){var h,c,u,f,d=s-n,m=a-o,g=t-n,p=r-o,w=g*m-p*d;if(i(g*d<=0&&p*m<=0,"sign of gradient must not change"),d*d+m*m>g*g+p*p&&(s=t,t=d+n,a=r,r=m+o,w=-w),0!=w){g+=d,p+=m,h=2*(g*=d=t<s?1:-1)*(p*=m=r<a?1:-1),g*=g,p*=p,w*d*m<0&&(g=-g,p=-p,h=-h,w=-w),c=4*m*w*(n-t)+g-h,u=4*d*w*(r-o)+p-h,g+=g,p+=p,f=c+u+h;do{if(l(t,r),t==s&&r==a)return;o=+(2*f<c),2*f>u&&(t+=d,c-=h,f+=u+=p),o&&(r+=m,u-=h,f+=c+=g)}while(u<0&&c>0)}e(t,r,s,a,l)}function p(t,e,r,n,i,o,s){var a,l=t-r,h=e-n,c=t-2*r+i;l*(i-r)>0&&(h*(o-n)>0&&Math.abs((e-2*n+o)/c*l)>Math.abs(h)&&(t=i,i=l+r,e=o,o=h+n),a=(1-(c=(t-r)/c))*((1-c)*e+2*c*n)+c*c*o,c=(t*i-r*r)*c/(t-r),l=Math.floor(c+.5),h=Math.floor(a+.5),a=(n-e)*(c-t)/(r-t)+e,w(t,e,l,Math.floor(a+.5),l,h,s),a=(n-o)*(c-i)/(r-i)+o,t=r=l,e=h,n=Math.floor(a+.5)),(e-n)*(o-n)>0&&(a=(1-(c=(e-n)/(c=e-2*n+o)))*((1-c)*t+2*c*r)+c*c*i,c=(e*o-n*n)*c/(e-n),l=Math.floor(a+.5),h=Math.floor(c+.5),a=(r-t)*(c-e)/(n-e)+t,w(t,e,Math.floor(a+.5),h,l,h,s),a=(r-i)*(c-o)/(n-o)+i,t=l,r=Math.floor(a+.5),e=n=h),w(t,e,r,n,i,o,s)}function w(t,e,n,i,o,s,a){var l,h,c,u,f,d=o-n,m=s-i,g=t-n,p=e-i,w=g*m-p*d;if(d*d+m*m>g*g+p*p&&(o=t,t=d+n,s=e,e=m+i,w=-w),0!=w){g+=d,p+=m,l=2*(g*=d=t<o?1:-1)*(p*=m=e<s?1:-1),g*=g,p*=p,w*d*m<0&&(g=-g,p=-p,l=-l,w=-w),h=4*m*(n-t)*w+g-l,c=4*d*(e-i)*w+p-l,g+=g,p+=p,u=h+c+l;do{if(w=Math.min(h+l,-l-c),f=Math.max(h+l,-l-c),f+=2*f*w*w/(4*f*f+w*w),a(t,e,255*Math.abs(u-h-c-l)/f),t==o||e==s)break;n=t,w=h-u,i=+(2*u+c<0),2*u+h>0&&(u-c<f&&a(t,e+m,255*Math.abs(u-c)/f),t+=d,h-=l,u+=c+=p),i&&(w<f&&a(n+d,e,255*Math.abs(w)/f),e+=m,c-=l,u+=h+=g)}while(c<h)}r(t,e,o,s,a)}function b(t,r,n,o,s,a,l,h,c){var u,f,d,m=1;let p,w,b,_,y,x,M,E,v,I,A,S=t<l?1:-1,R=r<h?1:-1,k=-Math.abs(t+n-s-l),T=k-4*S*(n-s),$=S*(t-n-s+l),C=-Math.abs(r+o-a-h),D=C-4*R*(o-a),B=R*(r-o-a+h),P=.01;if(i((n-t)*(s-l)<P&&((l-t)*(n-s)<P||$*$<T*k+P),"slope change"),i((o-r)*(a-h)<P&&((h-r)*(o-a)<P||B*B<D*C+P),"slope change"),0==T&&0==D)return S=Math.floor((3*n-t+1)/2),R=Math.floor((3*o-r+1)/2),g(t,r,S,R,l,h,c);n=(n-t)*(n-t)+(o-r)*(o-r)+1,s=(s-l)*(s-l)+(a-h)*(a-h)+1;do{p=T*B-$*D,w=T*C-k*D,b=$*C-k*B,I=p*(p+w-3*b)+w*w,p*=u=I>0?1:Math.sqrt(1+1024/n),w*=u,b*=u,I*=u*u,x=9*(p+w+b)/8,_=8*(T-D),E=27*(8*p*(B*B-D*C)+I*(D+2*B+C))/64-D*D*(x-D),v=27*(8*p*($*$-T*k)-I*(T+2*$+k))/64-T*T*(x+T),y=3*(3*p*(3*B*B-D*D-2*D*C)-D*(3*w*(D+B)+D*_))/4,M=3*(3*p*(3*$*$-T*T-2*T*k)-T*(3*w*(T+$)+T*_))/4,x=T*D*(6*p+6*w-3*b+_),w=D*D,_=T*T,x=3*(x+9*u*(_*B*C-$*k*w)-18*$*B*p)/8,I<0&&(E=-E,v=-v,y=-y,M=-M,x=-x,w=-w,_=-_),p=6*D*w,w*=-6*T,b=6*D*_,_*=-6*T,E+=x,I=E+v,v+=x;t:for(A=x,f=d=u;t!=l&&r!=h;){c(t,r);do{if(E>A||v<A)break t;o=2*I-v,2*I>=E&&(f--,I+=E+=y,v+=x+=w,M+=b,y+=p),o<=0&&(d--,I+=v+=M,E+=x+=b,y+=w,M+=_)}while(f>0&&d>0);2*f<=u&&(t+=S,f+=u),2*d<=u&&(r+=R,d+=u),A==x&&E<0&&v>0&&(A=P)}y=t,t=l,l=y,S=-S,$=-$,M=r,r=h,h=M,R=-R,B=-B,n=s}while(m--);e(t,r,l,h,c)}function _(t,e,n,o,s,a,l,h,c){let u,f,d,m,g,p,b,_,y,x,M,E,v,I,A,S,R,k=1,T=t<l?1:-1,$=e<h?1:-1,C=-Math.abs(t+n-s-l),D=C-4*T*(n-s),B=T*(t-n-s+l),P=-Math.abs(e+o-a-h),O=P-4*$*(o-a),N=$*(e-o-a+h);const F=.01;if(i((n-t)*(s-l)<F&&((l-t)*(n-s)<F||B*B<D*C+F)),i((o-e)*(a-h)<F&&((h-e)*(o-a)<F||N*N<O*P+F)),0===D&&0===O)return T=Math.floor((3*n-t+1)/2),$=Math.floor((3*o-e+1)/2),w(t,e,T,$,l,h,c);n=(n-t)*(n-t)+(o-e)*(o-e)+1,s=(s-l)*(s-l)+(a-h)*(a-h)+1;do{m=D*N-B*O,g=D*P-C*O,p=B*P-C*N,R=4*m*p-g*g,v=m*(m+g-3*p)+g*g,u=v>0?1:Math.sqrt(1+1024/n),m*=u,g*=u,p*=u,v*=u*u,y=9*(m+g+p)/8,b=8*(D-O),M=27*(8*m*(N*N-O*P)+v*(O+2*N+P))/64-O*O*(y-O),E=27*(8*m*(B*B-D*C)-v*(D+2*B+C))/64-D*D*(y+D),_=3*(3*m*(3*N*N-O*O-2*O*P)-O*(3*g*(O+N)+O*b))/4,x=3*(3*m*(3*B*B-D*D-2*D*C)-D*(3*g*(D+B)+D*b))/4,y=D*O*(6*m+6*g-3*p+b),g=O*O,b=D*D,y=3*(y+9*u*(b*N*P-B*C*g)-18*B*N*m)/8,v<0&&(M=-M,E=-E,_=-_,x=-x,y=-y,g=-g,b=-b),m=6*O*g,g*=-6*D,p=6*O*b,b*=-6*D,M+=y,v=M+E,E+=y;let r=!1;t:for(f=d=u;t!==l&&e!==h;){o=Math.min(Math.abs(y-M),Math.abs(E-y)),S=Math.max(Math.abs(y-M),Math.abs(E-y)),S=u*(S+2*S*o*o/(4*S*S+o*o)),(o=255*Math.abs(v-(u-f+1)*M-(u-d+1)*E+u*y)/S)<256&&c(t,e,o),I=Math.abs(v-(u-f+1)*M+(d-1)*E),A=Math.abs(v+(f-1)*M-(u-d+1)*E),a=e;do{if(R>=-F&&(M+_>y||E+x<y)){r=!0;break t}if(o=2*v+M,2*v+E>0)f--,v+=M+=_,E+=y+=g,x+=p,_+=m;else if(o>0){r=!0;break t}o<=0&&(d--,v+=E+=x,M+=y+=p,_+=g,x+=b)}while(f>0&&d>0);2*d<=u&&(A<S&&c(t+T,e,255*A/S),e+=$,d+=u),2*f<=u&&(I<S&&c(t,a+$,255*I/S),t+=T,f+=u)}r&&(2*v<E&&2*d<=u+2&&(A<S&&c(t+T,e,255*A/S),e+=$),2*v>M&&2*f<=u+2&&(I<S&&c(t,a+$,255*I/S),t+=T),_=t,t=l,l=_,T=-T,B=-B,x=e,e=h,h=x,$=-$,N=-N,n=s);break}while(k--);r(Math.floor(t),Math.floor(e),Math.floor(l),Math.floor(h),c)}function y(t,e,r,n,i,o,s,a,l,h){let c=0,u=0,f=t+r-i-s,d=f-4*(r-i),m=t-r-i+s,g=m+4*(r+i),p=e+n-o-a,w=p-4*(n-o),b=e-n-o+a,_=b+4*(n+o);var y,x,M,E,v,I,A=t,S=e;let R,k=m*m-d*f;const T=[0,0,0,0,0];for(0==d?Math.abs(f)<2*Math.abs(m)&&(T[c++]=f/(2*m)):k>0&&(R=Math.sqrt(k),k=(m-R)/d,Math.abs(k)<1&&(T[c++]=k),k=(m+R)/d,Math.abs(k)<1&&(T[c++]=k)),k=b*b-w*p,0==w?Math.abs(p)<2*Math.abs(b)&&(T[c++]=p/(2*b)):k>0&&(R=Math.sqrt(k),k=(b-R)/w,Math.abs(k)<1&&(T[c++]=k),k=(b+R)/w,Math.abs(k)<1&&(T[c++]=k)),u=1;u<c;u++)(k=T[u-1])>T[u]&&(T[u-1]=T[u],T[u]=k,u=0);for(k=-1,T[c]=1,u=0;u<=c;u++)R=T[u],y=(k*(k*m-2*f)-R*(k*(k*d-2*m)+f)+g)/8-A,E=(k*(k*b-2*p)-R*(k*(k*w-2*b)+p)+_)/8-S,x=(R*(R*m-2*f)-k*(R*(R*d-2*m)+f)+g)/8-A,v=(R*(R*b-2*p)-k*(R*(R*w-2*b)+p)+_)/8-S,A-=M=(R*(R*(3*m-R*d)-3*f)+g)/8,S-=I=(R*(R*(3*b-R*w)-3*p)+_)/8,s=Math.floor(M+.5),a=Math.floor(I+.5),0!=A&&(y*=A=(t-s)/A,x*=A),0!=S&&(E*=S=(e-a)/S,v*=S),(t!=s||e!=a)&&l(t,e,t+y,e+E,t+x,e+v,s,a,h),t=s,e=a,A=M,S=I,k=R}function x(t,e,r,n,i,o,s,a,l){y(t,e,r,n,i,o,s,a,b,l)}function M(t,e,r,n,i,o,s,a,l){y(t,e,r,n,i,o,s,a,_,l)}t.circle=f,t.circleAA=d,t.cubicBezier=x,t.cubicBezierAA=M,t.cubicBezierSegment=b,t.cubicBezierSegmentAA=_,t.ellipse=l,t.ellipseRect=u,t.line=e,t.lineAA=r,t.lineWidth=n,t.quadBezier=m,t.quadBezierAA=p,t.quadBezierSegment=g,t.quadBezierSegmentAA=w,t.quadRationalBezier=o,t.quadRationalBezierSegment=s,t.quadRationalBezierSegmentAA=a,t.rotatedEllipse=h,t.rotatedEllipseRect=c,Object.defineProperty(t,Symbol.toStringTag,{value:"Module"})}(exports$1);var index_umdExports=index_umd$1.exports;function deleteDuplicates(t){const e=[];for(let r=0;r<t.length;r++)t[r].column===t[(r+1)%t.length].column&&t[r].row===t[(r+1)%t.length].row||e.push(t[r]);return e}function getCirclePoints(t){const e=[];index_umdExports.circle(t,t,t,(r,n)=>{e.push({row:n-t,column:r-t})});const r=[],n=[],i=[],o=[];for(let t=0;t<e.length;t+=4)r.push(e[t%e.length]),n.push(e[(t+1)%e.length]),i.push(e[(t+2)%e.length]),o.push(e[(t+3)%e.length]);return r.concat(n,i,o)}const zeroPoint={row:0,column:0};function getFilledCirclePoints(t,e=zeroPoint){const r=[];if(0===t)return[e];1===t&&r.push(e),index_umdExports.circle(e.column,e.row,t,(t,n)=>{r.push({row:n,column:t}),t-1>e.column?r.push(...getLinePoints({row:n,column:t-1},{row:n,column:e.column})):t+1<e.column&&r.push(...getLinePoints({row:n,column:t+1},{row:n,column:e.column}))});return deleteDuplicates(sortByColumnRow(r))}function getLinePoints(t,e){const r=[];return index_umdExports.line(t.column,t.row,e.column,e.row,(t,e)=>{r.push({row:e,column:t})}),r}function getCompassPoints(t){return index_umdExports.circle(t,t,t,(t,e)=>{}),[{row:0,column:t},{row:t,column:0},{row:0,column:-t},{row:-t,column:0}]}function getIndex(t,e,r,n=0){return(e*r.width+t)*r.channels+n}const surroundingPixels=[{row:0,column:1},{row:1,column:1},{row:1,column:0},{row:1,column:-1},{row:0,column:-1},{row:-1,column:-1},{row:-1,column:0},{row:-1,column:1}],formatter=new Intl.ListFormat("en",{type:"disjunction"});function checkProcessable$1(t,e={}){let{bitDepth:r,alpha:n,colorModel:i,components:o,channels:s}=e;if(r&&(Array.isArray(r)||(r=[r]),!r.includes(t.bitDepth)))throw new RangeError(`image bitDepth must be ${format(r)} to apply this algorithm`);if(n&&(Array.isArray(n)||(n=[n]),!n.includes(t.alpha)))throw new RangeError(`image alpha must be ${format(n)} to apply this algorithm`);if(i&&(Array.isArray(i)||(i=[i]),!i.includes(t.colorModel)))throw new RangeError(`image colorModel must be ${format(i)} to apply this algorithm`);if(o&&(Array.isArray(o)||(o=[o]),!o.includes(t.components))){const t=`image components must be ${format(o)} to apply this algorithm`;throw 1===o.length&&1===o[0]?new RangeError(`${t}. The image can be converted using "image.grey()"`):new RangeError(t)}if(s&&(Array.isArray(s)||(s=[s]),!s.includes(t.channels)))throw new RangeError(`image channels must be ${format(s)} to apply this algorithm`)}function format(t){return formatter.format(t.map(String))}function getFastScore(t,e,r,n){const i=t.getValueByPoint(e,0);let o=0,s=0;for(const a of n){const n=t.getValue(e.column+a.column,e.row+a.row,0);n>=i+r?o+=Math.abs(n-i)-r:n<=i-r&&(s+=Math.abs(i-n)-r)}return Math.max(o,s)}const SOBEL_X=[[-1,0,1],[-2,0,2],[-1,0,1]],SOBEL_Y=[[-1,-2,-1],[0,0,0],[1,2,1]],SCHARR_X=[[3,0,-3],[10,0,-10],[3,0,-3]],SCHARR_Y=[[3,10,3],[0,0,0],[-3,-10,-3]],PREWITT_X=[[1,0,-1],[1,0,-1],[1,0,-1]],PREWITT_Y=[[1,1,1],[0,0,0],[-1,-1,-1]];function getHarrisScore(t,e,r={}){const{windowSize:n=7,harrisConstant:i=.04}=r;if(!(n%2))throw new TypeError("windowSize must be an odd integer");const o={row:e.row-(n-1)/2,column:e.column-(n-1)/2},s=t.crop({origin:o,width:n,height:n}),a=s.gradientFilter({kernelX:SOBEL_X}),l=s.gradientFilter({kernelY:SOBEL_Y}),h=new WrapperMatrix1D(a.getRawImage().data,{rows:a.height}),c=new WrapperMatrix1D(l.getRawImage().data,{rows:l.height}),u=h.mmul(h),f=c.mmul(h),d=c.mmul(c),m=u.sum(),g=f.sum(),p=d.sum(),w=new Matrix([[m,g],[g,p]]),b=new EigenvalueDecomposition(w).realEigenvalues;return b[0]*b[1]-i*(b[0]+b[1])**2}function isFastKeypoint(t,e,r,n,i={}){const{nbContiguousPixels:o=12,threshold:s=20}=i,a=e.getValueByPoint(t,0);let l=0,h=0;if(o>=12){for(const r of n){const n=e.getValue(t.column+r.column,t.row+r.row,0);a-n>s?h++:n-a>s&&l++}if(h<3&&l<3)return!1}const c=[];for(const n of r){const r=e.getValue(t.column+n.column,t.row+n.row,0);a+s<=r?c.push(-1):r<=a-s?c.push(1):c.push(0)}let u=1;const f=[];for(let t=0;t<c.length;t++){c[t]===c[(t+1)%c.length]?t===c.length-1?0===f.length?f.push(u):f[0]+=u:u++:(f.push(u),u=1)}return Math.max(...f)>=o}function getFastKeypoints(t,e={}){const{fastRadius:r=3,scoreAlgorithm:n="FAST",harrisScoreOptions:i}=e,o=getCirclePoints(r),s=getCompassPoints(r),{maxNbFeatures:a=500,nbContiguousPixels:l=3/4*o.length,threshold:h=20,nonMaxSuppression:c=!0}=e;checkProcessable$1(t,{channels:[1],alpha:!1});const u=M$2(n).with("HARRIS",()=>(t,e)=>getHarrisScore(t,e,i)).with("FAST",()=>(t,e)=>getFastScore(t,e,h,o)).exhaustive(),f=[],d=new Float64Array(t.size).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<t.height;e++)for(let r=0;r<t.width;r++){const n={row:e,column:r};if(isFastKeypoint(n,t,o,s,{nbContiguousPixels:l,threshold:h})){const e=u(t,n);d[getIndex(n.column,n.row,t,0)]=e,f.push({origin:n,score:e})}}let m=[];if(c)for(const e of f){const r=d[getIndex(e.origin.column,e.origin.row,t,0)];for(let n=0;n<surroundingPixels.length;n++){const i=surroundingPixels[n];if(d[getIndex(e.origin.column+i.column,e.origin.row+i.row,t,0)]>r)break;n===surroundingPixels.length-1&&m.push(e)}}else m=f;return m.sort((t,e)=>e.score-t.score),m.slice(0,a)}function getPatchIntensityMoment(t,e,r,n={}){const{center:i=t.getCoordinates("center"),radius:o=3}=n;if(!checkBorderDistance(t,i,o))throw new RangeError("desired patch is too close to image border");const s=new Array(t.channels).fill(0),a=getFilledCirclePoints(o);for(const n of a)for(let o=0;o<t.channels;o++){const a=t.getValue(n.column+i.column,n.row+i.row,o);s[o]+=n.column**e*n.row**r*a}return s}function getPatchIntensityCentroid(t,e={}){const r=getPatchIntensityMoment(t,1,0,e),n=getPatchIntensityMoment(t,0,1,e),i=getPatchIntensityMoment(t,0,0,e),o=[];for(let e=0;e<t.channels;e++)0===i[e]?o.push({column:0,row:0}):o.push({column:r[e]/i[e],row:n[e]/i[e]});return o}function getOrientedFastKeypoints(t,e={}){const{centroidPatchDiameter:r=7}=e,n=getFastKeypoints(t,e),i=getRadius(r),o=[];for(const e of n)checkBorderDistance(t,e.origin,i)&&o.push(e);const s=[];for(const e of o){const r=toDegrees(getClockwiseAngle({column:0,row:0},getPatchIntensityCentroid(t,{center:e.origin,radius:i})[0]));s.push({...e,angle:r})}return s}function compareIntensity(t,e,r,n={}){const{origin:i=t.getCoordinates("center")}=n,o=sum$1(e,i),s=sum$1(r,i);return t.getValueByPoint(o,0)<t.getValueByPoint(s,0)}function xMedian(t,e={}){if(!isAnyArray$1(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const{exact:r=!1}=e||{},n=t.slice(),i=calcMiddle(0,n.length-1),o=quickSelect(n,i);if(n.length%2==1||!r)return o;return(o+quickSelect(n,i+1))/2}function quickSelect(t,e){let r=0,n=t.length-1,i=0,o=0,s=0;for(;;){if(n<=r)return t[e];if(n===r+1)return t[r]>t[n]&&swap(t,r,n),t[e];for(i=calcMiddle(r,n),t[i]>t[n]&&swap(t,i,n),t[r]>t[n]&&swap(t,r,n),t[i]>t[r]&&swap(t,i,r),swap(t,i,r+1),o=r+1,s=n;;){do{o++}while(t[r]>t[o]);do{s--}while(t[s]>t[r]);if(s<o)break;swap(t,o,s)}swap(t,r,s),s<=e&&(r=o),s>=e&&(n=s-1)}}function swap(t,e,r){const n=t[r];t[r]=t[e],t[e]=n}function calcMiddle(t,e){return Math.floor((t+e)/2)}function xCheck(t,e={}){const{minLength:r}=e;if(!isAnyArray$1(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if("number"!=typeof t[0])throw new TypeError("input must contain numbers");if(r&&t.length<r)throw new Error(`input must have a length of at least ${r}`)}function xFindClosestIndex(t,e,r={}){const{sorted:n=!0}=r;if(n){let r=0,n=t.length-1,i=0;for(;n-r>1;)if(i=r+(n-r>>1),t[i]<e)r=i;else{if(!(t[i]>e))return i;n=i}return r<t.length-1?Math.abs(e-t[r])<Math.abs(t[r+1]-e)?r:r+1:r}{let r=0,n=Number.POSITIVE_INFINITY;for(let i=0;i<t.length;i++){const o=Math.abs(t[i]-e);o<n&&(n=o,r=i)}return r}}function xGetFromToIndex(t,e={}){let{fromIndex:r,toIndex:n}=e;const{from:i,to:o}=e;return void 0===r&&(r=void 0!==i?xFindClosestIndex(t,i):0),void 0===n&&(n=void 0!==o?xFindClosestIndex(t,o):t.length-1),r<0&&(r=0),n<0&&(n=0),r>=t.length&&(r=t.length-1),n>=t.length&&(n=t.length-1),r>n&&([r,n]=[n,r]),{fromIndex:r,toIndex:n}}function xMean(t,e={}){xCheck(t);const{fromIndex:r,toIndex:n}=xGetFromToIndex(t,e);let i=t[r];for(let e=r+1;e<=n;e++)i+=t[e];return i/(n-r+1)}function xVariance(t,e={}){if(!isAnyArray$1(t))throw new TypeError("input must be an array");const{unbiased:r=!0,mean:n=xMean(t)}=e;let i=0;for(const e of t){const t=e-n;i+=t*t}return r?i/(t.length-1):i/t.length}function FFT(t){if(this.size=0|t,this.size<=1||this.size&this.size-1)throw new Error("FFT size must be a power of two and bigger than 1");this._csize=t<<1;for(var e=new Array(2*this.size),r=0;r<e.length;r+=2){const t=Math.PI*r/this.size;e[r]=Math.cos(t),e[r+1]=-Math.sin(t)}this.table=e;for(var n=0,i=1;this.size>i;i<<=1)n++;this._width=n%2==0?n-1:n,this._bitrev=new Array(1<<this._width);for(var o=0;o<this._bitrev.length;o++){this._bitrev[o]=0;for(var s=0;s<this._width;s+=2){var a=this._width-s-2;this._bitrev[o]|=(o>>>s&3)<<a}}this._out=null,this._data=null,this._inv=0}FFT.prototype.fromComplexArray=function(t,e){for(var r=e||new Array(t.length>>>1),n=0;n<t.length;n+=2)r[n>>>1]=t[n];return r},FFT.prototype.createComplexArray=function(){const t=new Array(this._csize);for(var e=0;e<t.length;e++)t[e]=0;return t},FFT.prototype.toComplexArray=function(t,e){for(var r=e||this.createComplexArray(),n=0;n<r.length;n+=2)r[n]=t[n>>>1],r[n+1]=0;return r},FFT.prototype.completeSpectrum=function(t){for(var e=this._csize,r=e>>>1,n=2;n<r;n+=2)t[e-n]=t[n],t[e-n+1]=-t[n+1]},FFT.prototype.transform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._transform4(),this._out=null,this._data=null},FFT.prototype.realTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=0,this._realTransform4(),this._out=null,this._data=null},FFT.prototype.inverseTransform=function(t,e){if(t===e)throw new Error("Input and output buffers must be different");this._out=t,this._data=e,this._inv=1,this._transform4();for(var r=0;r<t.length;r++)t[r]/=this.size;this._out=null,this._data=null},FFT.prototype._transform4=function(){var t,e,r=this._out,n=this._csize,i=1<<this._width,o=n/i<<1,s=this._bitrev;if(4===o)for(t=0,e=0;t<n;t+=o,e++){const r=s[e];this._singleTransform2(t,r,i)}else for(t=0,e=0;t<n;t+=o,e++){const r=s[e];this._singleTransform4(t,r,i)}var a=this._inv?-1:1,l=this.table;for(i>>=2;i>=2;i>>=2){var h=(o=n/i<<1)>>>2;for(t=0;t<n;t+=o)for(var c=t+h,u=t,f=0;u<c;u+=2,f+=i){const t=u,e=t+h,n=e+h,i=n+h,o=r[t],s=r[t+1],c=r[e],d=r[e+1],m=r[n],g=r[n+1],p=r[i],w=r[i+1],b=o,_=s,y=l[f],x=a*l[f+1],M=c*y-d*x,E=c*x+d*y,v=l[2*f],I=a*l[2*f+1],A=m*v-g*I,S=m*I+g*v,R=l[3*f],k=a*l[3*f+1],T=p*R-w*k,$=p*k+w*R,C=b+A,D=_+S,B=b-A,P=_-S,O=M+T,N=E+$,F=a*(M-T),L=a*(E-$),V=C+O,U=D+N,z=C-O,H=D-N,G=B+L,Z=P-F,Y=B-L,K=P+F;r[t]=V,r[t+1]=U,r[e]=G,r[e+1]=Z,r[n]=z,r[n+1]=H,r[i]=Y,r[i+1]=K}}},FFT.prototype._singleTransform2=function(t,e,r){const n=this._out,i=this._data,o=i[e],s=i[e+1],a=i[e+r],l=i[e+r+1],h=o+a,c=s+l,u=o-a,f=s-l;n[t]=h,n[t+1]=c,n[t+2]=u,n[t+3]=f},FFT.prototype._singleTransform4=function(t,e,r){const n=this._out,i=this._data,o=this._inv?-1:1,s=2*r,a=3*r,l=i[e],h=i[e+1],c=i[e+r],u=i[e+r+1],f=i[e+s],d=i[e+s+1],m=i[e+a],g=i[e+a+1],p=l+f,w=h+d,b=l-f,_=h-d,y=c+m,x=u+g,M=o*(c-m),E=o*(u-g),v=p+y,I=w+x,A=b+E,S=_-M,R=p-y,k=w-x,T=b-E,$=_+M;n[t]=v,n[t+1]=I,n[t+2]=A,n[t+3]=S,n[t+4]=R,n[t+5]=k,n[t+6]=T,n[t+7]=$},FFT.prototype._realTransform4=function(){var t,e,r=this._out,n=this._csize,i=1<<this._width,o=n/i<<1,s=this._bitrev;if(4===o)for(t=0,e=0;t<n;t+=o,e++){const r=s[e];this._singleRealTransform2(t,r>>>1,i>>>1)}else for(t=0,e=0;t<n;t+=o,e++){const r=s[e];this._singleRealTransform4(t,r>>>1,i>>>1)}var a=this._inv?-1:1,l=this.table;for(i>>=2;i>=2;i>>=2){var h=(o=n/i<<1)>>>1,c=h>>>1,u=c>>>1;for(t=0;t<n;t+=o)for(var f=0,d=0;f<=u;f+=2,d+=i){var m=t+f,g=m+c,p=g+c,w=p+c,b=r[m],_=r[m+1],y=r[g],x=r[g+1],M=r[p],E=r[p+1],v=r[w],I=r[w+1],A=b,S=_,R=l[d],k=a*l[d+1],T=y*R-x*k,$=y*k+x*R,C=l[2*d],D=a*l[2*d+1],B=M*C-E*D,P=M*D+E*C,O=l[3*d],N=a*l[3*d+1],F=v*O-I*N,L=v*N+I*O,V=A+B,U=S+P,z=A-B,H=S-P,G=T+F,Z=$+L,Y=a*(T-F),K=a*($-L),q=V+G,j=U+Z,X=z+K,W=H-Y;if(r[m]=q,r[m+1]=j,r[g]=X,r[g+1]=W,0!==f){if(f!==u){var J=z+-a*K,Q=-H+-a*Y,tt=V+-a*G,et=-U- -a*Z,rt=t+c-f,nt=t+h-f;r[rt]=J,r[rt+1]=Q,r[nt]=tt,r[nt+1]=et}}else{var it=V-G,ot=U-Z;r[p]=it,r[p+1]=ot}}}},FFT.prototype._singleRealTransform2=function(t,e,r){const n=this._out,i=this._data,o=i[e],s=i[e+r],a=o+s,l=o-s;n[t]=a,n[t+1]=0,n[t+2]=l,n[t+3]=0},FFT.prototype._singleRealTransform4=function(t,e,r){const n=this._out,i=this._data,o=this._inv?-1:1,s=2*r,a=3*r,l=i[e],h=i[e+r],c=i[e+s],u=i[e+a],f=l+c,d=l-c,m=h+u,g=o*(h-u),p=f+m,w=d,b=-g,_=f-m,y=d,x=g;n[t]=p,n[t+1]=0,n[t+2]=w,n[t+3]=b,n[t+4]=_,n[t+5]=0,n[t+6]=y,n[t+7]=x};const LOOP=8,FLOAT_MUL=1/16777216,sh1=15,sh2=18,sh3=11;function multiplyUint32(t,e){const r=65535&(t>>>=0);return((t-r)*(e>>>=0)>>>0)+r*e>>>0}class XSadd{random;state;constructor(t=Date.now()){this.state=new Uint32Array(4),this.init(t),this.random=this.getFloat.bind(this)}getUint32(){return this.nextState(),this.state[3]+this.state[2]>>>0}getFloat(){return(this.getUint32()>>>8)*FLOAT_MUL}init(t){if(!Number.isInteger(t))throw new TypeError("seed must be an integer");this.state[0]=t,this.state[1]=0,this.state[2]=0,this.state[3]=0;for(let t=1;t<LOOP;t++)this.state[3&t]^=t+multiplyUint32(1812433253,this.state[t-1&3]^this.state[t-1&3]>>>30>>>0)>>>0;this.periodCertification();for(let t=0;t<LOOP;t++)this.nextState()}periodCertification(){0===this.state[0]&&0===this.state[1]&&0===this.state[2]&&0===this.state[3]&&(this.state[0]=88,this.state[1]=83,this.state[2]=65,this.state[3]=68)}nextState(){let t=this.state[0];t^=t<<sh1,t^=t>>>sh2,t^=this.state[3]<<sh3,this.state[0]=this.state[1],this.state[1]=this.state[2],this.state[2]=this.state[3],this.state[3]=t}}function createRandomArray(t={}){const{mean:e=0,standardDeviation:r=1,length:n=1e3,range:i=1,seed:o,distribution:s="normal"}=t,a=new XSadd(o),l=new Float64Array(n);switch(s){case"normal":{const t=new GaussianGenerator(e,r,a);for(let e=0;e<n;e++)l[e]=t.generateGaussian();break}case"uniform":for(let t=0;t<n;t++)l[t]=(a.random()-.5)*i+e;break;default:throw new Error(`unknown distribution: ${String(s)}`)}return l}class GaussianGenerator{#r=0;#n=!1;#i;#o;#s;constructor(t,e,r){this.#i=t,this.#o=e,this.#s=r}generateGaussian(){let t,e,r,n;if(this.#n)this.#n=!1,t=this.#r*this.#o+this.#i;else{do{e=2*this.#s.random()-1,r=2*this.#s.random()-1,n=e*e+r*r}while(n>=1||0===n);n=Math.sqrt(-2*Math.log(n)/n),this.#r=r*n,this.#n=!0,t=this.#i+this.#o*e*n}return t}}function xyCovariance(t,e={}){const{x:r,y:n}=t,{unbiased:i=!0}=e,o=xMean(r),s=xMean(n);let a=0;for(let t=0;t<r.length;t++)a+=(r[t]-o)*(n[t]-s);return i?a/(r.length-1):a/r.length}function assert(t,e){if(!t)throw new Error(e||"unreachable")}function assertUnreachable(t){throw new Error(`unreachable: ${String(t)}`)}function getClamp(t){return 255===t.maxValue?clamp255:(assert(65535===t.maxValue),clamp65535)}function clamp255(t){return Math.min(Math.max(t,0),255)}function clamp65535(t){return Math.min(Math.max(t,0),65535)}function getClampFromTo(t,e){return function(r){return Math.max(Math.min(r,e),t)}}function getGaussianPoints(t,e,r={}){const{nbPoints:n=1024,xSeed:i=0,ySeed:o=1,sigma:s}=r,a=getGaussianValues(t,i,n,s),l=getGaussianValues(e,o,n,s),h=[];for(let t=0;t<n;t++)h.push({column:a[t],row:l[t]});return h}function getGaussianValues(t,e,r,n=t/5){const i=(t-1)/2,o=createRandomArray({distribution:"normal",seed:e,length:r,standardDeviation:n,mean:0}),s=getClampFromTo(-i,i);return o.map(t=>{const e=Math.round(t);return s(e)})}function extractSquareImage(t,e,r){const n=(r-1)/2,i={column:e.column-n,row:e.row-n};return t.crop({origin:i,width:r,height:r})}function getKeypointPatch(t,e,r={}){const{patchSize:n=31}=r,i=e.angle*Math.PI/180,o=Math.floor(n*(Math.abs(Math.cos(i))+Math.abs(Math.sin(i)))),s=o%2?o:o+1,a=getRadius(s);if(!checkBorderDistance(t,e.origin,a))throw new RangeError("keypoint is too close to border for given patch size");const l=extractSquareImage(t,e.origin,s).transformRotate(-e.angle,{center:"center",interpolationType:"nearest"}),h=l.getCoordinates("center");return extractSquareImage(l,h,n)}function getBriefDescriptors(t,e,r={}){const{patchSize:n=31,descriptorLength:i=256,smoothingOptions:o={sigma:Math.sqrt(2),size:Math.min(t.height,t.width,9)},pointsDistributionOptions:s}=r;if(checkProcessable$1(t,{alpha:!1,colorModel:"GREY"}),!(n%2))throw new TypeError("patchSize must be an odd integer");if(Math.min(t.width,t.height)<n)throw new RangeError(`image is too small for patchSize = ${n}`);const a=getGaussianPoints(n,n,{...s,nbPoints:2*i}),l=t.gaussianBlur(o),h=[],c=[];for(const t of e){let e;try{e=getKeypointPatch(l,t,{patchSize:n})}catch{continue}if(null===e)continue;const r=new Uint8Array(i);for(let t=0;t<i;t++){const n=a[t],o=a[t+i];r[t]=Number(compareIntensity(e,n,o))}h.push(r),c.push(t)}return{keypoints:c,descriptors:h}}function getBrief(t,e={}){const{centroidPatchDiameter:r=15,bestKptRadius:n=10,minScore:i}=e,o=getBriefDescriptors(t,getBestKeypointsInRadius(getOrientedFastKeypoints(t,{centroidPatchDiameter:r}),n));if(i)for(let t=0;t<o.keypoints.length;t++)if(o.keypoints[t].score<i)return{keypoints:o.keypoints.slice(0,t-1),descriptors:o.descriptors.slice(0,t-1)};return o}function getIntensityMoment(t,e,r,n={}){const{origin:i=t.getCoordinates("center")}=n,o=new Array(t.channels).fill(0);for(let n=0;n<t.height;n++)for(let s=0;s<t.width;s++){const a=s-i.column,l=n-i.row;for(let i=0;i<t.channels;i++){const h=t.getValue(s,n,i);o[i]+=a**e*l**r*h}}return o}function getIntensityCentroid(t){const e=getIntensityMoment(t,1,0),r=getIntensityMoment(t,0,1),n=getIntensityMoment(t,0,0),i=[];for(let o=0;o<t.channels;o++)0===n[o]?i.push({column:0,row:0}):i.push({column:e[o]/n[o],row:r[o]/n[o]});return i}function getHammingDistance(t,e){let r=0;for(let n=0;n<t.length;n++)r+=t[n]^e[n];return r}function bruteForceOneMatch(t,e,r={}){const{sort:n=!!r.nbBestMatches,nbBestMatches:i=t.length}=r,o=[];for(let r=0;r<t.length;r++){let n=Number.POSITIVE_INFINITY,i=0;for(let o=0;o<e.length;o++){const s=getHammingDistance(t[r],e[o]);s<n&&(n=s,i=o)}o.push({sourceIndex:r,destinationIndex:i,distance:n})}return n&&o.sort((t,e)=>t.distance-e.distance),o.slice(0,i)}function sortBySourceDest(t){const e=t.slice();return e.sort((t,e)=>t.sourceIndex<e.sourceIndex?-1:t.sourceIndex>e.sourceIndex?1:t.destinationIndex-e.destinationIndex),e}function sortByDestSource(t){const e=t.slice();return e.sort((t,e)=>t.destinationIndex<e.destinationIndex?-1:t.destinationIndex>e.destinationIndex?1:t.sourceIndex-e.sourceIndex),e}function getCrosscheckMatches(t,e){return crosscheck(bruteForceOneMatch(t,e),bruteForceOneMatch(e,t))}function crosscheck(t,e){const r=[],n=sortBySourceDest(t),i=sortByDestSource(e);let o=0,s=0;for(;o<n.length&&s<i.length;){const t=n[o],e=i[s];t.sourceIndex>e.destinationIndex?s++:t.sourceIndex<e.destinationIndex?o++:t.destinationIndex>e.sourceIndex?s++:t.destinationIndex<e.sourceIndex?o++:(r.push({distance:Math.max(t.distance,e.distance),sourceIndex:t.sourceIndex,destinationIndex:t.destinationIndex}),o++,s++)}return r}function validateChannels(t,e){for(const r of t)validateChannel(r,e)}function validateChannel(t,e){if(!Number.isInteger(t)||t>=e.channels||t<0)throw new RangeError(`invalid channel: ${t}. It must be a positive integer smaller than ${e.channels}`)}function validateValues(t,e){for(const r of t)validateValue(r,e)}function validateValue(t,e){if(t>e.maxValue||t<0)throw new RangeError(`invalid value: ${t}. It must be a positive value smaller than ${e.maxValue+1}`)}function validateForComparison(t,e){if(t.width!==e.width||t.height!==e.height)throw new RangeError("both images must have the same size");if(t.alpha!==e.alpha||t.bitDepth!==e.bitDepth)throw new RangeError("both images must have the same alpha and bitDepth");if(t.channels!==e.channels)throw new RangeError("both images must have the same number of channels")}function validateColor(t,e){validateChannel(t.length-1,e),validateValues(t,e)}function divide(t,e,r={}){const{channels:n=new Array(t.channels).fill(0).map((t,e)=>e)}=r;if(validateChannels(n,t),0===e)throw new TypeError("Cannot divide by 0");const i=getOutputImage(t,r,{clone:!0});if(0===n.length)return i;for(const t of n)for(let r=0;r<i.height;r++)for(let n=0;n<i.width;n++){const o=i.getValue(n,r,t)/e;i.setClampedValue(n,r,t,o)}return i}function computeRmse(t,e){const r=computeMse(t,e);return Math.sqrt(r)}function computeMse(t,e){const r=t.subtract(e,{absolute:!0});let n=0;for(let e=0;e<t.size;e++)for(let i=0;i<t.channels;i++){n+=r.getValueByIndex(e,i)**2}return n/(t.size*t.channels)}function computePsnr(t,e){const r=computeRmse(t,e);return 20*Math.log10(t.maxValue/(r+Number.MIN_VALUE))}function getDefaultColor(t){return M$2(t.colorModel).with("GREY",()=>[0]).with("GREYA",()=>[0,t.maxValue]).with("RGB",()=>[0,0,0]).with("RGBA",()=>[0,0,0,t.maxValue]).with("BINARY",()=>[1]).exhaustive()}function setBlendedPixel(t,e,r,n){if(n=n??getDefaultColor(t),t.alpha){assert(t instanceof Image);const i=n.at(-1);if(i===t.maxValue)return void t.setPixel(e,r,n);const o=t.getValue(e,r,t.channels-1),s=i+o*(1-i/t.maxValue);t.setValue(e,r,t.channels-1,s);for(let a=0;a<t.components;a++){const l=(n[a]*i+t.getValue(e,r,a)*o*(1-i/t.maxValue))/s;t.setValue(e,r,a,l)}}else t.setPixel(e,r,n)}function setBlendedVisiblePixel(t,e,r,n){e>=0&&e<t.width&&r>=0&&r<t.height&&setBlendedPixel(t,e,r,n)}function roundPoint(t){return{row:Math.round(t.row),column:Math.round(t.column)}}function drawCircleOnImage(t,e,r,n={}){const i=getOutputImage(t,n,{clone:!0}),{strokeColor:o=getDefaultColor(i),fillColor:s}=n;if(validateColor(o,i),checkProcessable$1(i,{bitDepth:[8,16]}),r<0)throw new RangeError("circle radius must be positive");if(e=roundPoint(e),0===(r=Math.round(r)))return setBlendedVisiblePixel(i,e.column,e.row,o),i;if(s){1===r&&setBlendedVisiblePixel(i,e.column,e.row,s);let t=e.row+r,n=0;index_umdExports.circle(e.column,e.row,r,(r,a)=>{setBlendedVisiblePixel(i,r,a,o),0===n&&i.drawLine({row:a,column:r-1},{row:a,column:e.column-(r-e.column-1)},{strokeColor:s,out:i}),n%4==1&&t!==a&&(i.drawLine({row:a,column:r+1},{row:a,column:e.column-(r-e.column+1)},{strokeColor:s,out:i}),t=a,i.drawLine({row:e.row-(a-e.row),column:r+1},{row:e.row-(a-e.row),column:e.column-(r-e.column+1)},{strokeColor:s,out:i})),n++})}else index_umdExports.circle(e.column,e.row,r,(t,e)=>{setBlendedVisiblePixel(i,t,e,o)});return i}function drawLineOnImage(t,e,r,n={}){const i=getOutputImage(t,n,{clone:!0}),{strokeColor:o=getDefaultColor(i),origin:s={column:0,row:0}}=n;return validateColor(o,i),checkProcessable$1(i,{bitDepth:[8,16]}),index_umdExports.line(Math.round(s.column+e.column),Math.round(s.row+e.row),Math.round(s.column+r.column),Math.round(s.row+r.row),(t,e)=>{setBlendedVisiblePixel(i,t,e,o)}),i}function drawLineOnMask(t,e,r,n={}){const{origin:i={column:0,row:0}}=n,o=maskToOutputMask(t,n,{clone:!0});return index_umdExports.line(Math.round(i.column+e.column),Math.round(i.row+e.row),Math.round(i.column+r.column),Math.round(i.row+r.row),(t,e)=>{o.setVisiblePixel(t,e,[1])}),o}function drawPolylineOnImage(t,e,r={}){const{strokeColor:n=getDefaultColor(t),origin:i={column:0,row:0}}=r;checkProcessable$1(t,{bitDepth:[8,16]});const o=getOutputImage(t,r,{clone:!0});validateColor(n,o);for(let t=0;t<e.length-1;t++){const r=e[t],s=e[t+1];o.drawLine(r,s,{out:o,strokeColor:n,origin:i})}return o}function drawPolylineOnMask(t,e,r={}){const n=maskToOutputMask(t,r,{clone:!0});for(let t=0;t<e.length-1;t++){const i=e[t],o=e[t+1];n.drawLine(i,o,{out:n,origin:r.origin})}return n}var orientation={exports:{}},twoProduct_1=twoProduct$1,SPLITTER=+(Math.pow(2,27)+1);function twoProduct$1(t,e,r){var n=t*e,i=SPLITTER*t,o=i-(i-t),s=t-o,a=SPLITTER*e,l=a-(a-e),h=e-l,c=s*h-(n-o*l-s*l-o*h);return r?(r[0]=c,r[1]=n,r):[c,n]}var robustSum=linearExpansionSum;function scalarScalar$1(t,e){var r=t+e,n=r-t,i=t-(r-n)+(e-n);return i?[i,r]:[r]}function linearExpansionSum(t,e){var r=0|t.length,n=0|e.length;if(1===r&&1===n)return scalarScalar$1(t[0],e[0]);var i,o,s=new Array(r+n),a=0,l=0,h=0,c=Math.abs,u=t[l],f=c(u),d=e[h],m=c(d);f<m?(o=u,(l+=1)<r&&(f=c(u=t[l]))):(o=d,(h+=1)<n&&(m=c(d=e[h]))),l<r&&f<m||h>=n?(i=u,(l+=1)<r&&(f=c(u=t[l]))):(i=d,(h+=1)<n&&(m=c(d=e[h])));for(var g,p,w=i+o,b=w-i,_=o-b,y=_,x=w;l<r&&h<n;)f<m?(i=u,(l+=1)<r&&(f=c(u=t[l]))):(i=d,(h+=1)<n&&(m=c(d=e[h]))),(_=(o=y)-(b=(w=i+o)-i))&&(s[a++]=_),y=x-((g=x+w)-(p=g-x))+(w-p),x=g;for(;l<r;)(_=(o=y)-(b=(w=(i=u)+o)-i))&&(s[a++]=_),y=x-((g=x+w)-(p=g-x))+(w-p),x=g,(l+=1)<r&&(u=t[l]);for(;h<n;)(_=(o=y)-(b=(w=(i=d)+o)-i))&&(s[a++]=_),y=x-((g=x+w)-(p=g-x))+(w-p),x=g,(h+=1)<n&&(d=e[h]);return y&&(s[a++]=y),x&&(s[a++]=x),a||(s[a++]=0),s.length=a,s}var twoSum$1=fastTwoSum;function fastTwoSum(t,e,r){var n=t+e,i=n-t,o=e-i,s=t-(n-i);return r?(r[0]=s+o,r[1]=n,r):[s+o,n]}var twoProduct=twoProduct_1,twoSum=twoSum$1,robustScale=scaleLinearExpansion;function scaleLinearExpansion(t,e){var r=t.length;if(1===r){var n=twoProduct(t[0],e);return n[0]?n:[n[1]]}var i=new Array(2*r),o=[.1,.1],s=[.1,.1],a=0;twoProduct(t[0],e,o),o[0]&&(i[a++]=o[0]);for(var l=1;l<r;++l){twoProduct(t[l],e,s);var h=o[1];twoSum(h,s[0],o),o[0]&&(i[a++]=o[0]);var c=s[1],u=o[1],f=c+u,d=u-(f-c);o[1]=f,d&&(i[a++]=d)}return o[1]&&(i[a++]=o[1]),0===a&&(i[a++]=0),i.length=a,i}var robustDiff=robustSubtract;function scalarScalar(t,e){var r=t+e,n=r-t,i=t-(r-n)+(e-n);return i?[i,r]:[r]}function robustSubtract(t,e){var r=0|t.length,n=0|e.length;if(1===r&&1===n)return scalarScalar(t[0],-e[0]);var i,o,s=new Array(r+n),a=0,l=0,h=0,c=Math.abs,u=t[l],f=c(u),d=-e[h],m=c(d);f<m?(o=u,(l+=1)<r&&(f=c(u=t[l]))):(o=d,(h+=1)<n&&(m=c(d=-e[h]))),l<r&&f<m||h>=n?(i=u,(l+=1)<r&&(f=c(u=t[l]))):(i=d,(h+=1)<n&&(m=c(d=-e[h])));for(var g,p,w=i+o,b=w-i,_=o-b,y=_,x=w;l<r&&h<n;)f<m?(i=u,(l+=1)<r&&(f=c(u=t[l]))):(i=d,(h+=1)<n&&(m=c(d=-e[h]))),(_=(o=y)-(b=(w=i+o)-i))&&(s[a++]=_),y=x-((g=x+w)-(p=g-x))+(w-p),x=g;for(;l<r;)(_=(o=y)-(b=(w=(i=u)+o)-i))&&(s[a++]=_),y=x-((g=x+w)-(p=g-x))+(w-p),x=g,(l+=1)<r&&(u=t[l]);for(;h<n;)(_=(o=y)-(b=(w=(i=d)+o)-i))&&(s[a++]=_),y=x-((g=x+w)-(p=g-x))+(w-p),x=g,(h+=1)<n&&(d=-e[h]);return y&&(s[a++]=y),x&&(s[a++]=x),a||(s[a++]=0),s.length=a,s}!function(t){var e=twoProduct_1,r=robustSum,n=robustScale,i=robustDiff;function o(t,e,r,n){return function(r,i,o){var s=t(t(e(i[1],o[0]),e(-o[1],i[0])),t(e(r[1],i[0]),e(-i[1],r[0]))),a=t(e(r[1],o[0]),e(-o[1],r[0])),l=n(s,a);return l[l.length-1]}}function s(t,e,r,n){return function(i,o,s,a){var l=t(t(r(t(e(s[1],a[0]),e(-a[1],s[0])),o[2]),t(r(t(e(o[1],a[0]),e(-a[1],o[0])),-s[2]),r(t(e(o[1],s[0]),e(-s[1],o[0])),a[2]))),t(r(t(e(o[1],a[0]),e(-a[1],o[0])),i[2]),t(r(t(e(i[1],a[0]),e(-a[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),a[2])))),h=t(t(r(t(e(s[1],a[0]),e(-a[1],s[0])),i[2]),t(r(t(e(i[1],a[0]),e(-a[1],i[0])),-s[2]),r(t(e(i[1],s[0]),e(-s[1],i[0])),a[2]))),t(r(t(e(o[1],s[0]),e(-s[1],o[0])),i[2]),t(r(t(e(i[1],s[0]),e(-s[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),s[2])))),c=n(l,h);return c[c.length-1]}}function a(t,e,r,n){return function(i,o,s,a,l){var h=t(t(t(r(t(r(t(e(a[1],l[0]),e(-l[1],a[0])),s[2]),t(r(t(e(s[1],l[0]),e(-l[1],s[0])),-a[2]),r(t(e(s[1],a[0]),e(-a[1],s[0])),l[2]))),o[3]),t(r(t(r(t(e(a[1],l[0]),e(-l[1],a[0])),o[2]),t(r(t(e(o[1],l[0]),e(-l[1],o[0])),-a[2]),r(t(e(o[1],a[0]),e(-a[1],o[0])),l[2]))),-s[3]),r(t(r(t(e(s[1],l[0]),e(-l[1],s[0])),o[2]),t(r(t(e(o[1],l[0]),e(-l[1],o[0])),-s[2]),r(t(e(o[1],s[0]),e(-s[1],o[0])),l[2]))),a[3]))),t(r(t(r(t(e(s[1],a[0]),e(-a[1],s[0])),o[2]),t(r(t(e(o[1],a[0]),e(-a[1],o[0])),-s[2]),r(t(e(o[1],s[0]),e(-s[1],o[0])),a[2]))),-l[3]),t(r(t(r(t(e(a[1],l[0]),e(-l[1],a[0])),o[2]),t(r(t(e(o[1],l[0]),e(-l[1],o[0])),-a[2]),r(t(e(o[1],a[0]),e(-a[1],o[0])),l[2]))),i[3]),r(t(r(t(e(a[1],l[0]),e(-l[1],a[0])),i[2]),t(r(t(e(i[1],l[0]),e(-l[1],i[0])),-a[2]),r(t(e(i[1],a[0]),e(-a[1],i[0])),l[2]))),-o[3])))),t(t(r(t(r(t(e(o[1],l[0]),e(-l[1],o[0])),i[2]),t(r(t(e(i[1],l[0]),e(-l[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),l[2]))),a[3]),t(r(t(r(t(e(o[1],a[0]),e(-a[1],o[0])),i[2]),t(r(t(e(i[1],a[0]),e(-a[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),a[2]))),-l[3]),r(t(r(t(e(s[1],a[0]),e(-a[1],s[0])),o[2]),t(r(t(e(o[1],a[0]),e(-a[1],o[0])),-s[2]),r(t(e(o[1],s[0]),e(-s[1],o[0])),a[2]))),i[3]))),t(r(t(r(t(e(s[1],a[0]),e(-a[1],s[0])),i[2]),t(r(t(e(i[1],a[0]),e(-a[1],i[0])),-s[2]),r(t(e(i[1],s[0]),e(-s[1],i[0])),a[2]))),-o[3]),t(r(t(r(t(e(o[1],a[0]),e(-a[1],o[0])),i[2]),t(r(t(e(i[1],a[0]),e(-a[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),a[2]))),s[3]),r(t(r(t(e(o[1],s[0]),e(-s[1],o[0])),i[2]),t(r(t(e(i[1],s[0]),e(-s[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),s[2]))),-a[3]))))),c=t(t(t(r(t(r(t(e(a[1],l[0]),e(-l[1],a[0])),s[2]),t(r(t(e(s[1],l[0]),e(-l[1],s[0])),-a[2]),r(t(e(s[1],a[0]),e(-a[1],s[0])),l[2]))),i[3]),r(t(r(t(e(a[1],l[0]),e(-l[1],a[0])),i[2]),t(r(t(e(i[1],l[0]),e(-l[1],i[0])),-a[2]),r(t(e(i[1],a[0]),e(-a[1],i[0])),l[2]))),-s[3])),t(r(t(r(t(e(s[1],l[0]),e(-l[1],s[0])),i[2]),t(r(t(e(i[1],l[0]),e(-l[1],i[0])),-s[2]),r(t(e(i[1],s[0]),e(-s[1],i[0])),l[2]))),a[3]),r(t(r(t(e(s[1],a[0]),e(-a[1],s[0])),i[2]),t(r(t(e(i[1],a[0]),e(-a[1],i[0])),-s[2]),r(t(e(i[1],s[0]),e(-s[1],i[0])),a[2]))),-l[3]))),t(t(r(t(r(t(e(s[1],l[0]),e(-l[1],s[0])),o[2]),t(r(t(e(o[1],l[0]),e(-l[1],o[0])),-s[2]),r(t(e(o[1],s[0]),e(-s[1],o[0])),l[2]))),i[3]),r(t(r(t(e(s[1],l[0]),e(-l[1],s[0])),i[2]),t(r(t(e(i[1],l[0]),e(-l[1],i[0])),-s[2]),r(t(e(i[1],s[0]),e(-s[1],i[0])),l[2]))),-o[3])),t(r(t(r(t(e(o[1],l[0]),e(-l[1],o[0])),i[2]),t(r(t(e(i[1],l[0]),e(-l[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),l[2]))),s[3]),r(t(r(t(e(o[1],s[0]),e(-s[1],o[0])),i[2]),t(r(t(e(i[1],s[0]),e(-s[1],i[0])),-o[2]),r(t(e(i[1],o[0]),e(-o[1],i[0])),s[2]))),-l[3])))),u=n(h,c);return u[u.length-1]}}function l(t){return(3===t?o:4===t?s:a)(r,e,n,i)}var h=l(3),c=l(4),u=[function(){return 0},function(){return 0},function(t,e){return e[0]-t[0]},function(t,e,r){var n,i=(t[1]-r[1])*(e[0]-r[0]),o=(t[0]-r[0])*(e[1]-r[1]),s=i-o;if(i>0){if(o<=0)return s;n=i+o}else{if(!(i<0))return s;if(o>=0)return s;n=-(i+o)}var a=33306690738754716e-32*n;return s>=a||s<=-a?s:h(t,e,r)},function(t,e,r,n){var i=t[0]-n[0],o=e[0]-n[0],s=r[0]-n[0],a=t[1]-n[1],l=e[1]-n[1],h=r[1]-n[1],u=t[2]-n[2],f=e[2]-n[2],d=r[2]-n[2],m=o*h,g=s*l,p=s*a,w=i*h,b=i*l,_=o*a,y=u*(m-g)+f*(p-w)+d*(b-_),x=7771561172376103e-31*((Math.abs(m)+Math.abs(g))*Math.abs(u)+(Math.abs(p)+Math.abs(w))*Math.abs(f)+(Math.abs(b)+Math.abs(_))*Math.abs(d));return y>x||-y>x?y:c(t,e,r,n)}];function f(t){var e=u[t.length];return e||(e=u[t.length]=l(t.length)),e.apply(void 0,t)}function d(t,e,r,n,i,o,s){return function(e,r,a,l,h){switch(arguments.length){case 0:case 1:return 0;case 2:return n(e,r);case 3:return i(e,r,a);case 4:return o(e,r,a,l);case 5:return s(e,r,a,l,h)}for(var c=new Array(arguments.length),u=0;u<arguments.length;++u)c[u]=arguments[u];return t(c)}}!function(){for(;u.length<=5;)u.push(l(u.length));t.exports=d.apply(void 0,[f].concat(u));for(var e=0;e<=5;++e)t.exports[e]=u[e]}()}(orientation);var orientationExports=orientation.exports,robustPnp=robustPointInPolygon,orient=orientationExports;function robustPointInPolygon(t,e){for(var r=e[0],n=e[1],i=t.length,o=1,s=i,a=0,l=i-1;a<s;l=a++){var h=t[a],c=t[l],u=h[1],f=c[1];if(f<u){if(f<n&&n<u){if(0===(d=orient(h,c,e)))return 0;o^=0<d|0}else if(n===u){if(u<t[(a+1)%i][1]){if(0===(d=orient(h,c,e)))return 0;o^=0<d|0}}}else if(u<f){if(u<n&&n<f){if(0===(d=orient(h,c,e)))return 0;o^=d<0|0}else if(n===u){if(t[(a+1)%i][1]<u){var d;if(0===(d=orient(h,c,e)))return 0;o^=d<0|0}}}else if(n===u){var m=Math.min(h[0],c[0]),g=Math.max(h[0],c[0]);if(0===a){for(;l>0;){var p=(l+i-1)%i;if((_=t[p])[1]!==n)break;var w=_[0];m=Math.min(m,w),g=Math.max(g,w),l=p}if(0===l)return m<=r&&r<=g?0:1;s=l+1}for(var b=t[(l+i-1)%i][1];a+1<s;){var _;if((_=t[a+1])[1]!==n)break;w=_[0];m=Math.min(m,w),g=Math.max(g,w),a+=1}if(m<=r&&r<=g)return 0;var y=t[(a+1)%i][1];r<m&&b<n!=y<n&&(o^=1)}}return 2*o-1}var robustPointInPolygon$1=getDefaultExportFromCjs(robustPnp);function arrayPointsToObjects(t){const e=[];for(const r of t)e.push([r.column,r.row]);return e}function drawPolygonOnImage(t,e,r={}){const{fillColor:n,origin:i={column:0,row:0},...o}=r;checkProcessable$1(t,{bitDepth:[8,16]});const s=getOutputImage(t,r,{clone:!0});if(void 0===n)return s.drawPolyline([...e,e[0]],{origin:i,...o});{validateColor(n,s);const t=arrayPointsToObjects(deleteDuplicates(e));for(let e=0;e<s.height;e++)for(let r=0;r<s.width;r++)-1===robustPointInPolygon$1(t,[r,e])&&setBlendedVisiblePixel(s,Math.round(i.column)+r,Math.round(i.row)+e,n)}return s.drawPolyline([...e,e[0]],{origin:i,...o})}function drawPolygonOnMask(t,e,r={}){const{filled:n=!1,origin:i={column:0,row:0},...o}=r,s=maskToOutputMask(t,r,{clone:!0});if(!n)return s.drawPolyline([...e,e[0]],{origin:i,...o});const a=arrayPointsToObjects(deleteDuplicates(e));for(let t=0;t<s.height;t++)for(let e=0;e<s.width;e++)-1===robustPointInPolygon$1(a,[e,t])&&s.setBit(Math.round(i.column)+e,Math.round(i.row)+t,1);return s.drawPolyline([...e,e[0]],{origin:i,...o})}function drawRectangle(t,e={}){const{width:r=t.width,height:n=t.height,origin:i={column:0,row:0},strokeColor:o=getDefaultColor(t),fillColor:s}=e,a=Math.round(r),l=Math.round(n),h=Math.round(i.column),c=Math.round(i.row);let u;t instanceof Image?(checkProcessable$1(t,{bitDepth:[8,16]}),validateColor(o,t),s&&validateColor(s,t),u=getOutputImage(t,e,{clone:!0})):u=maskToOutputMask(t,e,{clone:!0});for(let t=h;t<h+a;t++)setBlendedVisiblePixel(u,t,c,o),setBlendedVisiblePixel(u,t,c+l-1,o);for(let t=c+1;t<c+l-1;t++)setBlendedVisiblePixel(u,h,t,o),setBlendedVisiblePixel(u,h+a-1,t,o);if(s)for(let t=c+1;t<c+l-1;t++)for(let e=h+1;e<h+a-1;e++)setBlendedVisiblePixel(u,e,t,s);return u}function drawPoints(t,e,r={}){const{color:n=getDefaultColor(t),origin:i={row:0,column:0}}=r;let o;t instanceof Image?(o=getOutputImage(t,r,{clone:!0}),validateColor(n,o)):o=maskToOutputMask(t,r,{clone:!0}),checkProcessable$1(o,{bitDepth:[1,8,16]});for(const t of e)setBlendedVisiblePixel(o,Math.round(i.column+t.column),Math.round(i.row+t.row),n);return o}function drawMarker(t,e,r){const n=getOutputImage(t,r,{clone:!0}),{strokeColor:i=getDefaultColor(n),fillColor:o,shape:s="cross",size:a=1}=r,l=Math.round(a);if(validateColor(i,n),o&&validateColor(o,n),checkProcessable$1(n,{bitDepth:[8,16]}),"circle"===s&&n.drawCircle(e,l,{strokeColor:i,fillColor:o,out:n}),"triangle"===s){const t=[{row:e.row-l,column:e.column},{row:e.row,column:e.column+l},{row:e.row,column:e.column-l}];n.drawPolygon(t,{strokeColor:i,fillColor:o,out:n})}if("cross"===s&&(n.drawLine({row:e.row-l,column:e.column},{row:e.row+l,column:e.column},{strokeColor:i,out:n}),n.drawLine({row:e.row,column:e.column-l},{row:e.row,column:e.column+l},{strokeColor:i,out:n})),"square"===s){const t={row:e.row-(l-1)/2,column:e.column-(l-1)/2};n.drawRectangle({origin:t,width:l,height:l,strokeColor:i,fillColor:o,out:n})}return n}function drawMarkers(t,e,r={}){const n=getOutputImage(t,r,{clone:!0});for(const t of e)drawMarker(n,t,{...r,out:n});return n}function and(t,e,r){const n=maskToOutputMask(t,r);if(t.width!==e.width||t.height!==e.height)throw new RangeError("both masks must have the same size");for(let r=0;r<n.size;r++)t.getBitByIndex(r)&&e.getBitByIndex(r)?n.setBitByIndex(r,1):n.setBitByIndex(r,0);return n}function checkSize(t){if(!Number.isInteger(t)||t<1)throw new TypeError(`size must be a positive integer. Got ${t}`)}function checkKernel$1(t){if(0===t.length||t.length%2!=1)throw new RangeError(`kernel must have an odd positive length. Got ${t.length}`)}function checkBorderType(t){if("CONSTANT"!==t&&"CUT"!==t)throw new RangeError(`unexpected border type: ${t}`)}function checkInputLength(t,e){if(t!==e)throw new RangeError(`input length (${t}) does not match setup size (${e})`)}function createArray(t){const e=[];for(var r=0;r<t;r++)e.push(0);return e}class DirectConvolution{constructor(t,e,r="CONSTANT"){checkSize(t),checkKernel$1(e),checkBorderType(r),this.size=t,this.kernelOffset=(e.length-1)/2,this.outputSize="CONSTANT"===r?t:t-2*this.kernelOffset,this.output=createArray(this.outputSize),this.kernel=e,this.kernelSize=e.length,this.borderType=r}convolve(t){return checkInputLength(t.length,this.size),this.output.fill(0),"CONSTANT"===this.borderType?this._convolutionBorder0(t):this._convolutionBorderCut(t),this.output}_convolutionBorder0(t){for(let e=0;e<this.size;e++)for(let r=0;r<this.kernelSize;r++)this.output[e]+=interpolateInput(t,e-this.kernelOffset+r)*this.kernel[r]}_convolutionBorderCut(t){for(let e=this.kernelOffset;e<this.size-this.kernelOffset;e++){const r=e-this.kernelOffset;for(let e=0;e<this.kernelSize;e++)this.output[r]+=t[r+e]*this.kernel[e]}}}function interpolateInput(t,e){return e<0||e>=t.length?0:t[e]}const BorderType$1={CUT:"CUT"},BorderType={CONSTANT:"constant",REPLICATE:"replicate",REFLECT:"reflect",WRAP:"wrap",REFLECT_101:"reflect101"};function getBorderInterpolation(t,e){return M$2(t).with("constant",()=>getInterpolateConstant(e)).with("replicate",()=>interpolateReplicate).with("reflect",()=>interpolateReflect).with("reflect101",()=>interpolateReflect101).with("wrap",()=>interpolateWrap).exhaustive()}function checkRange(t,e){if(t<=0-e||t>=e+e-1)throw new RangeError("border must be smaller than the original image")}function getInterpolateConstant(t){return function(e,r,n,i){const o=interpolateConstantPoint(e,i.width),s=interpolateConstantPoint(r,i.height);return-1===o||-1===s?t:i.getValue(o,s,n)}}function interpolateConstantPoint(t,e){return t>=0&&t<e?t:-1}function interpolateReplicate(t,e,r,n){return n.getValue(interpolateReplicatePoint(t,n.width),interpolateReplicatePoint(e,n.height),r)}function interpolateReplicatePoint(t,e){return t>=0&&t<e?t:(checkRange(t,e),t<0?0:e-1)}function interpolateReflect(t,e,r,n){return n.getValue(interpolateReflectPoint(t,n.width),interpolateReflectPoint(e,n.height),r)}function interpolateReflectPoint(t,e){return t>=0&&t<e?t:(checkRange(t,e),t<0?-1-t:e+e-1-t)}function interpolateWrap(t,e,r,n){return n.getValue(interpolateWrapPoint(t,n.width),interpolateWrapPoint(e,n.height),r)}function interpolateWrapPoint(t,e){return t>=0&&t<e?t:(checkRange(t,e),t<0?e+t:t-e)}function interpolateReflect101(t,e,r,n){return n.getValue(interpolateReflect101Point(t,n.width),interpolateReflect101Point(e,n.height),r)}function interpolateReflect101Point(t,e){return t>=0&&t<e?t:(checkRange(t,e),t<0?0-t:e+e-2-t)}function extendBorders(t,e){const{horizontal:r,vertical:n,borderType:i="reflect101",borderValue:o=0}=e,s=getBorderInterpolation(i,o),a=Image.createFrom(t,{width:t.width+2*r,height:t.height+2*n});t.copyTo(a,{origin:{column:r,row:n},out:a});for(let e=0;e<n;e++)for(let i=0;i<a.width;i++)for(let o=0;o<t.channels;o++){const l=s(i-r,e-n,o,t);a.setValue(i,e,o,l)}for(let e=a.height-n;e<a.height;e++)for(let i=0;i<a.width;i++)for(let o=0;o<t.channels;o++){const l=s(i-r,e-n,o,t);a.setValue(i,e,o,l)}for(let e=n;e<a.height-n;e++)for(let i=0;i<r;i++)for(let o=0;o<t.channels;o++){const l=s(i-r,e-n,o,t);a.setValue(i,e,o,l)}for(let e=n;e<a.height-n;e++)for(let i=a.width-r;i<a.width;i++)for(let o=0;o<t.channels;o++){const l=s(i-r,e-n,o,t);a.setValue(i,e,o,l)}return a}function round(t){const e=Math.trunc(t),r=t-e;return r<.5?e:r>.5?e+1:e%2==0?e:e+1}function directConvolution(t,e,r={}){const{borderType:n="reflect101",borderValue:i=0}=r,o=rawDirectConvolution(t,e,{borderType:n,borderValue:i}),s=getOutputImage(t,r),a=getClamp(s);for(let e=0;e<t.size;e++)for(let r=0;r<t.channels;r++){const n=round(a(o[e*t.channels+r]));s.setValueByIndex(e,r,n)}return s}function rawDirectConvolution(t,e,r={}){const{borderType:n="reflect101",borderValue:i=0}=r,o=getBorderInterpolation(n,i),s=new Float64Array(t.size*t.channels);for(let r=0;r<t.channels;r++)for(let n=0;n<t.height;n++)for(let i=0;i<t.width;i++){s[getIndex(i,n,t,r)]=computeConvolutionValue(i,n,r,t,e,o,{returnRawValue:!0})}return s}function separableConvolution(t,e,r,n={}){const{normalize:i,borderType:o="reflect101",borderValue:s=0}=n;i&&([e,r]=normalizeSeparatedKernel(e,r));const a=extendBorders(t,{horizontal:(e.length-1)/2,vertical:(r.length-1)/2,borderType:o,borderValue:s}),l=Image.createFrom(t),h=getClamp(l),c=new DirectConvolution(a.width,e,BorderType$1.CUT),u=new DirectConvolution(a.height,r,BorderType$1.CUT),f=new Float64Array(a.width),d=new Float64Array(a.height),m=new Float64Array(t.width*a.height);for(let e=0;e<a.channels;e++){for(let r=0;r<a.height;r++){for(let t=0;t<a.width;t++)f[t]=a.getValue(t,r,e);const n=c.convolve(f);for(let e=0;e<t.width;e++)m[r*t.width+e]=n[e]}for(let r=0;r<t.width;r++){for(let e=0;e<a.height;e++)d[e]=m[e*t.width+r];const n=u.convolve(d);for(let i=0;i<t.height;i++)l.setValue(r,i,e,round(h(n[i])))}}return l}function computeConvolutionValue(t,e,r,n,i,o,s={}){let{clamp:a}=s;const{returnRawValue:l=!1}=s;l&&(a=void 0);let h=0;const c=i[0].length,u=i.length,f=(c-1)/2,d=(u-1)/2;for(let s=0;s<u;s++)for(let a=0;a<c;a++){h+=i[s][a]*o(t+a-f,e+s-d,r,n)}return a?round(a(h)):h}function normalizeSeparatedKernel(t,e){const r=t.reduce((t,e)=>t+e,0)*e.reduce((t,e)=>t+e,0);if(r<0)throw new RangeError("this separated kernel cannot be normalized");const n=1/Math.sqrt(Math.abs(r));return[t.map(t=>t*n),e.map(t=>t*n)]}function blur(t,e){const{width:r,height:n}=e;if(r<1||r%2==0)throw new RangeError(`Invalid property "width". Must be an odd number greater than 0. Received ${r}.`);if(n<1||n%2==0)throw new RangeError(`Invalid property "height". Must be an odd number greater than 0. Received ${n}.`);return separableConvolution(t,new Array(r).fill(1),new Array(n).fill(1),{normalize:!0,...e})}const DerivativeFilter={SOBEL:"sobel",SCHARR:"scharr",PREWITT:"prewitt"};function derivativeFilter(t,e={}){const{filter:r="sobel"}=e,n=M$2(r).with("sobel",()=>({kernelX:SOBEL_X,kernelY:SOBEL_Y})).with("scharr",()=>({kernelX:SCHARR_X,kernelY:SCHARR_Y})).with("prewitt",()=>({kernelX:PREWITT_X,kernelY:PREWITT_Y})).exhaustive();return t.gradientFilter({...n,...e})}const ImageColorModel={GREY:"GREY",GREYA:"GREYA",RGB:"RGB",RGBA:"RGBA",BINARY:"BINARY"},colorModels={GREY:{components:1,alpha:!1,channels:1},GREYA:{components:1,alpha:!0,channels:2},RGB:{components:3,alpha:!1,channels:3},RGBA:{components:3,alpha:!0,channels:4},BINARY:{components:1,alpha:!1,channels:1}};function increaseContrast(t,e={}){const{uniform:r=!1}=e;checkProcessable$1(t,{bitDepth:[8,16]});const n=t.minMax();let i=n.min,o=n.max;if(r){let t=-1,e=-1;for(let r=0;r<n.max.length;r++){const i=n.max[r]-n.min[r];i>e&&(t=r,e=i)}i=n.min[t],o=n.max[t]}let s=new Array(t.components).fill(0).map((t,e)=>e);return t.colorModel===ImageColorModel.GREYA?s=[0]:t.colorModel===ImageColorModel.RGBA&&(s=[0,1,2]),t.level({inputMin:i,inputMax:o,outputMin:0,outputMax:t.maxValue,channels:s,...e})}function gaussianBlur(t,e){if("sigma"in e){const{sigma:r,size:n=getSize$1(r),borderType:i}=e,o=getKernel(getRadius(n),r);return separableConvolution(t,o,o,{borderType:i})}if("sigmaX"in e&&"sigmaY"in e){const{sigmaX:r,sigmaY:n,sizeX:i=getSize$1(r),sizeY:o=getSize$1(n),borderType:s}=e,a=getRadius(i),l=getRadius(o);return separableConvolution(t,getKernel(a,r),getKernel(l,n),{borderType:s})}throw new TypeError("you must either define sigma or sigmaX and sigmaY in the options argument")}function getKernel(t,e){const r=2*t+1,n=new Array(r),i=e||.3*(.5*(r-1)-1)+.8,o=-.5/(i*i);let s=0;for(let e=0;e<r;e++){const r=e-t,i=Math.exp(o*r*r);n[e]=i,s+=i}for(let t=0;t<r;t++)n[t]/=s;return n}function getSize$1(t){return 2*Math.ceil(2*t)+1}function gradientFilter(t,e){const{borderType:r="replicate",borderValue:n=0}=e;if(checkProcessable$1(t,{bitDepth:[8,16],colorModel:"GREY"}),"kernelX"in e&&"kernelY"in e){const{kernelX:i,kernelY:o}=e,s=t.rawDirectConvolution(i,{borderType:r,borderValue:n}),a=t.rawDirectConvolution(o,{borderType:r,borderValue:n}),l=new Image(t.width,t.height,{colorModel:"GREY"});for(let e=0;e<t.size;e++)l.setValueByIndex(e,0,Math.hypot(s[e],a[e]));return l}if("kernelX"in e)return t.directConvolution(e.kernelX,{borderType:r,borderValue:n});if("kernelY"in e)return t.directConvolution(e.kernelY,{borderType:r,borderValue:n});throw new TypeError("kernelX and KernelY are not defined")}function hypotenuse(t,e,r={}){const{channels:n=new Array(t.components).fill(0).map((t,e)=>e)}=r;if(checkProcessable$1(t,{bitDepth:[8,16]}),t.width!==e.width||t.height!==e.height)throw new RangeError("both images must have the same size");if(t.alpha!==e.alpha||t.bitDepth!==e.bitDepth)throw new RangeError("both images must have the same alpha and bitDepth");if(t.channels!==e.channels)throw new RangeError("both images must have the same number of channels");validateChannels(n,t);const i=getOutputImage(t,{},{clone:!0});for(const r of n)for(let n=0;n<t.size;n++){const o=Math.hypot(t.getValueByIndex(n,r),e.getValueByIndex(n,r));i.setValueByIndex(n,r,Math.min(o,i.maxValue))}return i}function convertColor(t,e,r={}){const n=new Map([["GREY",["GREYA","RGB","RGBA"]],["GREYA",["GREY","RGB","RGBA"]],["RGB",["GREY","GREYA","RGBA"]],["RGBA",["GREY","GREYA","RGB"]],["BINARY",["GREY","RGB","RGBA"]]]);if(t.colorModel===e&&"BINARY"!==e)return getOutputImage(t,{out:r.out},{clone:!0});const i=n.get(t.colorModel);if(!i?.includes(e))throw new RangeError(`conversion from ${t.colorModel} to ${e} not implemented`);if(t instanceof Image){const n=getOutputImage(t,r,{newParameters:{colorModel:e}});return"GREY"!==t.colorModel&&"GREYA"!==t.colorModel||convertGreyToAny(t,n),"RGB"!==t.colorModel&&"RGBA"!==t.colorModel||("RGB"===e||"RGBA"===e?convertRgbToRgb(t,n):convertRgbToGrey(t,n)),!t.alpha&&n.alpha&&n.fillAlpha(n.maxValue),t.alpha&&n.alpha&&copyAlpha(t,n),n}if("GREY"===e){const e=maskToOutputImage(t,r);return convertBinaryToGrey(t,e),e}{const r=new Image(t.width,t.height,{colorModel:e});return convertBinaryToRgb(t,r),r}}function copyAlpha(t,e){if(t.size!==e.size)throw new RangeError("source and destination have different sizes");if(!t.alpha)throw new RangeError("source image does not have alpha");if(!e.alpha)throw new RangeError("destination does not have alpha");for(let r=0;r<e.size;r++)e.setValueByIndex(r,e.channels-1,t.getValueByIndex(r,t.channels-1))}function convertGreyToAny(t,e){for(let r=0;r<t.size;r++)for(let n=0;n<e.components;n++)e.setValueByIndex(r,n,t.getValueByIndex(r,0))}function convertRgbToRgb(t,e){for(let r=0;r<t.size;r++)for(let n=0;n<3;n++)e.setValueByIndex(r,n,t.getValueByIndex(r,n))}function convertRgbToGrey(t,e){for(let r=0;r<t.size;r++){const n=t.getValueByIndex(r,0),i=t.getValueByIndex(r,1),o=t.getValueByIndex(r,2);e.setValueByIndex(r,0,Math.round(.299*n+.587*i+.114*o))}}function convertBinaryToGrey(t,e){for(let r=0;r<t.size;r++)e.setValueByIndex(r,0,t.getBitByIndex(r)?e.maxValue:0)}function convertBinaryToRgb(t,e){const r=new Array(e.components).fill(0),n=new Array(e.components).fill(e.maxValue);e.alpha&&(r.push(e.maxValue),n.push(e.maxValue));for(let i=0;i<t.size;i++)e.setPixelByIndex(i,t.getBitByIndex(i)?n:r)}function convertBitDepth(t,e,r={}){if(t.bitDepth===e)return getOutputImage(t,r,{clone:!0});if(8!==e&&16!==e)throw new RangeError(`This image bit depth is not supported: ${e}`);const n=getOutputImage(t,r,{clone:!1,newParameters:{bitDepth:e,colorModel:t.colorModel}});return 8===e?convertToUint8(t,n):convertToUint16(t,n)}function convertToUint16(t,e){for(let r=0;r<t.size;r++)for(let n=0;n<e.channels;n++)e.setValueByIndex(r,n,t.getValueByIndex(r,n)<<8);return e}function convertToUint8(t,e){for(let r=0;r<t.size;r++)for(let n=0;n<e.channels;n++)e.setValueByIndex(r,n,t.getValueByIndex(r,n)>>8);return e}function checkPointIsInteger(t,e="Point"){if(!Number.isInteger(t.row)||!Number.isInteger(t.column))throw new TypeError(`${e} row and column must be integers`)}function extract(t,e,r={}){const{origin:n={row:0,column:0}}=r,{row:i,column:o}=n;assert(i<t.height&&o<t.width&&i+e.width>0&&o+e.height>0,"extract: image and mask have no overlap"),checkPointIsInteger(n,"Origin");const s=Math.min(t.width,e.width+o)-Math.max(0,o),a=Math.min(t.height,e.height+i)-Math.max(0,i);let l=new Image(s,a,{colorModel:t.colorModel,origin:n});l.alpha&&(l=l.fillAlpha(0));const h=Math.max(0,i),c=Math.max(0,o),u=i<0?-i:0,f=o<0?-o:0;for(let r=0;r<a;r++)for(let n=0;n<s;n++)e.getBit(f+n,u+r)&&l.setPixel(n,r,t.getPixel(c+n,h+r));return l}function merge(t){const e=t.length;let r;switch(e){case 2:r="GREYA";break;case 3:r="RGB";break;case 4:r="RGBA";break;default:throw new RangeError(`merge expects an array of two to four images. Received ${e}`)}const n=t[0];if(1!==n.channels)throw new RangeError(`each image must have one channel. Received ${n.channels}`);for(let r=1;r<e;r++){const e=t[r];if(1!==e.channels)throw new RangeError(`each image must have one channel. Received ${e.channels}`);if(e.width!==n.width||e.height!==n.height||e.bitDepth!==n.bitDepth)throw new RangeError("all images must have the same width, height and bitDepth")}const i=Image.createFrom(n,{colorModel:r});for(let r=0;r<e;r++){const e=t[r];for(let t=0;t<i.size;t++)i.setValueByIndex(t,r,e.getValueByIndex(t,0))}return i}function split(t){const e=[];for(let r=0;r<t.channels;r++){const n=Image.createFrom(t,{colorModel:"GREY"});for(let e=0;e<n.size;e++)n.setValueByIndex(e,0,t.getValueByIndex(e,r));e.push(n)}return e}function huang(t){let e=0;for(let r=0;r<t.length;r++)if(0!==t[r]){e=r;break}let r=t.length-1;for(let n=t.length-1;n>=e;n--)if(0!==t[n]){r=n;break}const n=1/(r-e),i=new Array(t.length);let o=0,s=0;for(let r=e;r<t.length;r++)o+=r*t[r],s+=t[r],i[r]=o/s;const a=new Array(t.length);o=0,s=0;for(let e=r;e>0;e--)o+=e*t[e],s+=t[e],a[e-1]=o/s;let l=-1,h=Number.MAX_VALUE;for(let e=0;e<t.length;e++){let r,o=0;for(let s=0;s<=e;s++)r=1/(1+n*Math.abs(s-i[e])),r<1e-6||r>.999999||(o+=t[s]*(-r*Math.log(r)-(1-r)*Math.log(1-r)));for(let i=e+1;i<t.length;i++)r=1/(1+n*Math.abs(i-a[e])),r<1e-6||r>.999999||(o+=t[i]*(-r*Math.log(r)-(1-r)*Math.log(1-r)));o<h&&(h=o,l=e)}return l}function intermodes(t){const e=t.slice();let r=0;for(;!bimodalTest$1(e);){let n=0,i=0,o=e[0];for(let r=0;r<t.length-1;r++)n=i,i=o,o=e[r+1],e[r]=(n+i+o)/3;e[t.length-1]=(i+o)/3,r++,assert(r<1e3,"Intermodes threshold not found after 1000 iterations")}let n=0;for(let r=1;r<t.length-1;r++)e[r-1]<e[r]&&e[r+1]<e[r]&&(n+=r);return Math.floor(n/2)}function bimodalTest$1(t){let e=!1,r=0;for(let e=1;e<t.length-1;e++)if(t[e-1]<t[e]&&t[e+1]<t[e]&&(r++,r>2))return!1;return 2===r&&(e=!0),e}function isodata(t){let e,r,n,i,o=0;for(let e=1;e<t.length;e++)if(t[e]>0){o=e+1;break}for(;;){e=0,n=0;for(let r=0;r<o;r++)n+=t[r],e+=t[r]*r;i=0,r=0;for(let e=o+1;e<t.length;e++)r+=t[e],i+=t[e]*e;if(n>0&&r>0&&(e/=n,i/=r,o===Math.round((e+i)/2)))break;o++,assert(o<=t.length-2,"Threshold not found")}return o}function li(t,e){let r,n,i,o,s,a,l,h,c,u;let f;u=0;for(let e=0;e<t.length;e++)u+=e*t[e];u/=e,l=u;do{a=l,r=a+.5|0,n=0,o=0;for(let e=0;e<=r;e++)n+=e*t[e],o+=t[e];h=0===o?0:n/o,i=0,s=0;for(let e=r+1;e<t.length;e++)i+=e*t[e],s+=t[e];c=0===s?0:i/s,f=(h-c)/(Math.log(h)-Math.log(c)),l=f<-Number.EPSILON?f-.5|0:f+.5|0}while(Math.abs(l-a)>.5);return r}function maxEntropy(t,e){const r=new Array(t.length);for(let n=0;n<t.length;n++)r[n]=t[n]/e;const n=new Array(t.length),i=new Array(t.length);n[0]=r[0],i[0]=1-n[0];for(let e=1;e<t.length;e++)n[e]=n[e-1]+r[e],i[e]=1-n[e];let o=0;for(let e=0;e<t.length;e++)if(Math.abs(n[e])>=Number.EPSILON){o=e;break}let s=t.length-1;for(let e=t.length-1;e>=o;e--)if(Math.abs(i[e])>=Number.EPSILON){s=e;break}let a,l,h,c=-1,u=Number.MIN_VALUE;for(let e=o;e<=s;e++){l=0;for(let i=0;i<=e;i++)0!==t[i]&&(l-=r[i]/n[e]*Math.log(r[i]/n[e]));h=0;for(let n=e+1;n<t.length;n++)0!==t[n]&&(h-=r[n]/i[e]*Math.log(r[n]/i[e]));a=l+h,u<a&&(u=a,c=e)}return c}function mean$1(t,e){let r=0;for(let e=0;e<t.length;e++)r+=e*t[e];return Math.floor(r/e)}function minError(t,e){let r,n,i,o,s,a,l,h,c,u,f,d,m=-2,g=0;for(let e=0;e<t.length;e++)g+=e*t[e];for(g/=e,r=g;r!==m;){const e=sumA(t,r),g=sumA(t,t.length-1),p=sumB(t,r),w=sumB(t,t.length-1),b=sumC(t,r);if(n=p/e,i=(w-p)/(g-e),o=e/g,s=(g-e)/g,a=b/e-n*n,l=(sumC(t,t.length-1)-b)/(g-e)-i*i,h=1/a-1/l,c=n/a-i/l,u=n*n/a-i*i/l+Math.log10(a*(s*s)/(l*(o*o))),f=c*c-h*u,f<0)return r;m=r,d=(c+Math.sqrt(f))/h,r=Number.isNaN(d)?m:Math.floor(d)}return r}function sumA(t,e){let r=0;for(let n=0;n<=e;n++)r+=t[n];return r}function sumB(t,e){let r=0;for(let n=0;n<=e;n++)r+=n*t[n];return r}function sumC(t,e){let r=0;for(let n=0;n<=e;n++)r+=n*n*t[n];return r}function minimum(t){if(t.length<2)return 0;let e=0,r=-1,n=-1,i=new Array(t.length);for(let e=0;e<t.length;e++)i[e]=t[e],t[e]>0&&(n=e);for(;!bimodalTest(i);)if(i=smoothed(i),e++,e>1e4)return r;for(let t=1;t<n;t++)if(i[t-1]>i[t]&&i[t+1]>=i[t]){r=t;break}return r}function smoothed(t){const e=new Array(t.length);for(let r=1;r<t.length-1;r++)e[r]=(t[r-1]+t[r]+t[r+1])/3;return e[0]=(t[0]+t[1])/3,e[t.length-1]=(t.at(-2)+t.at(-1))/3,e}function bimodalTest(t){const e=t.length;let r=!1,n=0;for(let r=1;r<e-1;r++)if(t[r-1]<t[r]&&t[r+1]<t[r]&&(n++,n>2))return!1;return 2===n&&(r=!0),r}function moments(t,e){let r=0,n=0,i=0,o=0,s=-1;const a=t.length,l=[];for(let r=0;r<a;r++)l.push(t[r]/e);for(let t=0;t<a;t++)r+=t*l[t],n+=t*t*l[t],i+=t*t*t*l[t];const h=1*n-r*r,c=(-n*n+r*i)/h,u=(1*-i+n*r)/h,f=.5*(-u-Math.sqrt(u*u-4*c)),d=.5*(-u+Math.sqrt(u*u-4*c)),m=(d-r)/(d-f);for(let t=0;t<a;t++)if(o+=l[t],o>m){s=t;break}return s}function otsu(t,e){let r=0,n=0,i=0,o=0,s=0;for(let e=0;e<t.length;e++)s+=e*t[e];for(let a=0;a<t.length;a++){n+=t[a];const l=e-n;if(0===n||0===l)continue;r+=a*t[a];const h=(s-r)/l,c=n*l*(r/n-h)*(r/n-h);c>=i&&(o=a,i=c)}return o}function percentile(t){let e=-1;const r=new Array(t.length),n=partialSum(t,t.length-1);let i=1;for(let o=0;o<t.length;o++)r[o]=Math.abs(partialSum(t,o)/n-.5),r[o]<i&&(i=r[o],e=o);return e}function partialSum(t,e){let r=0;for(let n=0;n<=e;n++)r+=t[n];return r}function renyiEntropy(t,e){let r,n;const i=new Array(t.length),o=new Array(t.length),s=new Array(t.length);let a=0,l=0,h=0,c=0,u=0,f=0;for(let r=0;r<t.length;r++)i[r]=t[r]/e;o[0]=i[0],s[0]=1-o[0];for(let e=1;e<t.length;e++)o[e]=o[e-1]+i[e],s[e]=1-o[e];r=0;for(let e=0;e<t.length;e++)if(Math.abs(o[e])>=Number.EPSILON){r=e;break}n=t.length-1;for(let e=t.length-1;e>=r;e--)if(Math.abs(s[e])>=Number.EPSILON){n=e;break}for(let e=r;e<=n;e++){let r=0,n=0,d=0;for(let s=0;s<=e;s++)0!==t[s]&&(r-=i[s]/o[e]*Math.log(i[s]/o[e])),n+=Math.sqrt(i[s]/o[e]),d+=i[s]*i[s]/(o[e]*o[e]);let m=0,g=0,p=0;for(let r=e+1;r<t.length;r++)0!==t[r]&&(m-=i[r]/s[e]*Math.log(i[r]/s[e])),g+=Math.sqrt(i[r]/s[e]),p+=i[r]*i[r]/(s[e]*s[e]);const w=r+m,b=2*(n*g>0?Math.log(n*g):0),_=-1*(d*p>0?Math.log(d*p):0);w>c&&(c=w,a=e),b>u&&(u=b,l=e),_>f&&(f=_,h=e)}const d=new Uint32Array([a,l,h]);let m;d.sort(),m=Math.abs(d[0]-d[1])<=5?Math.abs(d[1]-d[2])<=5?[1,2,1]:[0,1,3]:Math.abs(d[1]-d[2])<=5?[3,1,0]:[1,2,1];const g=o[d[2]]-o[d[0]];return Math.round(d[0]*(o[d[0]]+.25*g*m[0])+.25*d[1]*g*m[1]+d[2]*(s[d[2]]+.25*g*m[2]))}function shanbhag(t,e){const r=new Array(t.length);for(let n=0;n<t.length;n++)r[n]=t[n]/e;const n=new Array(t.length),i=new Array(t.length);n[0]=r[0],i[0]=1-n[0];for(let e=1;e<t.length;e++)n[e]=n[e-1]+r[e],i[e]=1-n[e];let o=0;for(let e=0;e<t.length;e++)if(Math.abs(n[e])>=Number.EPSILON){o=e;break}let s=t.length-1;for(let e=t.length-1;e>=o;e--)if(Math.abs(i[e])>=Number.EPSILON){s=e;break}let a,l,h,c,u=-1,f=Number.MAX_VALUE;for(let e=o;e<=s;e++){h=0,a=.5/n[e];for(let t=1;t<=e;t++)h-=r[t]*Math.log(1-a*n[t-1]);h*=a,c=0,a=.5/i[e];for(let n=e+1;n<t.length;n++)c-=r[n]*Math.log(1-a*i[n]);c*=a,l=Math.abs(h-c),l<f&&(f=l,u=e)}return u}function triangle(t){let e=0,r=0,n=0,i=0;for(let r=0;r<t.length;r++)if(t[r]>0){e=r;break}e>0&&e--;for(let e=t.length-1;e>0;e--)if(t[e]>0){i=e;break}i<t.length-1&&i++;for(let e=0;e<t.length;e++)t[e]>r&&(n=e,r=t[e]);let o,s,a,l=!1;if(n-e<i-n){l=!0;let r=0,o=t.length-1;for(;r<o;){const e=t[r];t[r]=t[o],t[o]=e,r++,o--}e=t.length-1-i,n=t.length-1-n}if(e===n)return e;o=t[n],s=e-n,a=Math.hypot(o,s),o/=a,s/=a,a=o*e+s*t[e];let h=e,c=0;for(let r=e+1;r<=n;r++){const e=o*r+s*t[r]-a;e>c&&(h=r,c=e)}if(h--,l){let e=0,r=t.length-1;for(;e<r;){const n=t[e];t[e]=t[r],t[r]=n,e++,r--}return t.length-1-h}return h}function yen(t,e){const r=new Array(t.length);for(let n=0;n<t.length;n++)r[n]=t[n]/e;const n=new Array(t.length);n[0]=r[0];for(let e=1;e<t.length;e++)n[e]=n[e-1]+r[e];const i=new Array(t.length);i[0]=r[0]*r[0];for(let e=1;e<t.length;e++)i[e]=i[e-1]+r[e]*r[e];const o=new Array(t.length);o[t.length-1]=0;for(let e=t.length-2;e>=0;e--)o[e]=o[e+1]+r[e+1]*r[e+1];let s,a=-1,l=Number.MIN_VALUE;for(let e=0;e<t.length;e++)s=-1*(i[e]*o[e]>0?Math.log(i[e]*o[e]):0)+2*(n[e]*(1-n[e])>0?Math.log(n[e]*(1-n[e])):0),s>l&&(l=s,a=e);return a}const ThresholdAlgorithm={HUANG:"huang",INTERMODES:"intermodes",ISODATA:"isodata",LI:"li",MAX_ENTROPY:"maxEntropy",MEAN:"mean",MIN_ERROR:"minError",MINIMUM:"minimum",MOMENTS:"moments",OTSU:"otsu",PERCENTILE:"percentile",RENYI_ENTROPY:"renyiEntropy",SHANBHAG:"shanbhag",TRIANGLE:"triangle",YEN:"yen"};function computeThreshold(t,e={}){const{algorithm:r="otsu",slots:n}=e;if(1!==t.channels)throw new TypeError("threshold can only be computed on images with one channel");const i=t.histogram({slots:n}),o=n?2**t.bitDepth/n:1;return M$2(r).with("huang",()=>huang(i)*o).with("intermodes",()=>intermodes(i)*o).with("isodata",()=>isodata(i)*o).with("li",()=>li(i,t.size)*o).with("maxEntropy",()=>maxEntropy(i,t.size)*o).with("mean",()=>mean$1(i,t.size)*o).with("minimum",()=>minimum(i)*o).with("minError",()=>minError(i,t.size)*o).with("moments",()=>moments(i,t.size)*o).with("otsu",()=>otsu(i,t.size)*o).with("percentile",()=>percentile(i)*o).with("renyiEntropy",()=>renyiEntropy(i,t.size)*o).with("shanbhag",()=>shanbhag(i,t.size)*o).with("triangle",()=>triangle(i)*o).with("yen",()=>yen(i,t.size)*o).exhaustive()}function threshold(t,e={}){let r;if("threshold"in e){const n=e.threshold;if(n<0||n>1)throw new RangeError("threshold must be a value between 0 and 1");r=n*t.maxValue}else r=computeThreshold(t,e);const n=imageToOutputMask(t,e);for(let e=0;e<t.size;e++)n.setBitByIndex(e,t.getValueByIndex(e,0)>r?1:0);return n}function luma709(t,e,r){return 6966*t+23436*e+2366*r>>15}function luma601(t,e,r){return 9798*t+19235*e+3735*r>>15}function max(t,e,r){return Math.max(t,e,r)}function min(t,e,r){return Math.min(t,e,r)}function average(t,e,r){return(t+e+r)/3|0}function minmax(t,e,r){return(Math.max(t,e,r)+Math.min(t,e,r))/2}function red(t){return t}function green(t,e){return e}function blue(t,e,r){return r}function black(t,e,r,n){return Math.min(n.maxValue-t,n.maxValue-e,n.maxValue-r)}function cyan(t,e,r,n){const i=black(t,e,r,n);return(n.maxValue-t-i)/(1-i/n.maxValue)|0}function magenta(t,e,r,n){const i=black(t,e,r,n);return(n.maxValue-e-i)/(1-i/n.maxValue)|0}function yellow(t,e,r,n){const i=black(t,e,r,n);return(n.maxValue-r-i)/(1-i/n.maxValue)|0}function hue(t,e,r,n){const i=min(t,e,r),o=max(t,e,r);if(o===i)return 0;let s=0;const a=o-i;return o===t?s=(e-r)/a+(e<r?6:0):o===e?s=(r-t)/a+2:(assert(o===r),s=(t-e)/a+4),s/6*n.maxValue|0}function saturation(t,e,r,n){const i=min(t,e,r),o=max(t,e,r);return 0===o?0:(o-i)/o*n.maxValue}function lightness(t,e,r){const n=min(t,e,r);return(max(t,e,r)+n)/2}var greyAlgorithms=Object.freeze({__proto__:null,average:average,black:black,blue:blue,cyan:cyan,green:green,hue:hue,lightness:lightness,luma601:luma601,luma709:luma709,magenta:magenta,max:max,min:min,minmax:minmax,red:red,saturation:saturation,yellow:yellow});const GreyAlgorithm={LUMA_709:"luma709",LUMA_601:"luma601",MAX:"max",MIN:"min",AVERAGE:"average",MINMAX:"minmax",RED:"red",GREEN:"green",BLUE:"blue",BLACK:"black",CYAN:"cyan",MAGENTA:"magenta",YELLOW:"yellow",HUE:"hue",SATURATION:"saturation",LIGHTNESS:"lightness"};{const t=new Set(Object.values(GreyAlgorithm));for(const e of Object.keys(greyAlgorithms))assert(t.has(e),`Grey algorithm ${e} is missing in the GreyAlgorithm enum`)}function grey(t,e={}){let{keepAlpha:r=!1,mergeAlpha:n=!0}=e;const{algorithm:i="luma709"}=e;checkProcessable$1(t,{colorModel:["RGB","RGBA"]}),r=r&&t.alpha,n=n&&t.alpha,r&&(n=!1);const o=getOutputImage(t,e,{newParameters:{colorModel:r?"GREYA":"GREY"}});let s;s="function"==typeof i?i:greyAlgorithms[i];const a=getClamp(o);for(let e=0;e<t.size;e++){const i=t.getValueByIndex(e,0),l=t.getValueByIndex(e,1),h=t.getValueByIndex(e,2);let c;if(n){const r=t.getValueByIndex(e,3);c=a(s(i,l,h,t)*r/t.maxValue)}else if(c=a(s(i,l,h,t)),r){const r=t.getValueByIndex(e,3);o.setValueByIndex(e,1,r)}o.setValueByIndex(e,0,c)}return o}function copyTo(t,e,r={}){const{origin:n={column:0,row:0}}=r,{column:i,row:o}=n;if(t.colorModel!==e.colorModel)throw new RangeError("source and target must have the same color model");let s;checkPointIsInteger(n,"Origin"),s=e instanceof Image?getOutputImage(e,r,{clone:!0}):maskToOutputMask(e,r,{clone:!0});for(let r=Math.max(o,0);r<Math.min(t.height+o,e.height);r++)for(let n=Math.max(i,0);n<Math.min(t.width+i,e.width);n++){setBlendedPixel(s,n,r,t.getPixel(n-i,r-o))}return s}function crop(t,e={}){const{origin:r={row:0,column:0},width:n=t.width-r.column,height:i=t.height-r.row}=e,{column:o,row:s}=r;if(checkProcessable$1(t,{bitDepth:[8,16]}),checkPointIsInteger(r,"Origin"),!Number.isInteger(n)||!Number.isInteger(i))throw new RangeError(`Width and height (width:${n}; height:${i}) must be integers`);if(s>t.height-1||o>t.width-1)throw new RangeError(`Origin (row:${s}, column:${o}) out of range (${t.width-1}; ${t.height-1})`);if(n<=0||i<=0)throw new RangeError(`Width and height (width:${n}; height:${i}) must be positive numbers`);if(s<0||o<0)throw new RangeError(`Row and column (row:${s}, column:${o}) must be positive numbers`);if(n>t.width-o||i>t.height-s)throw new RangeError(`Size is out of range (row:${s}, column:${o}, width:${n}, height:${i})`);const a=Image.createFrom(t,{width:n,height:i});for(let e=0;e<i;e++)for(let r=0;r<n;r++)a.setPixel(r,e,t.getPixel(o+r,s+e));return a}function cropAlpha(t,e={}){checkProcessable$1(t,{alpha:!0});const{threshold:r=t.maxValue}=e,n=findLeft(t,r,t.components);if(-1===n)throw new RangeError(`could not find new dimensions. Threshold may be too high: ${r}`);const i=findTop(t,r,t.components,n),o=findBottom(t,r,t.components,n),s=findRight(t,r,t.components,n,i,o);return t.crop({origin:{column:n,row:i},width:s-n+1,height:o-i+1})}function findLeft(t,e,r){for(let n=0;n<t.width;n++)for(let i=0;i<t.height;i++)if(t.getValue(n,i,r)>=e)return n;return-1}function findTop(t,e,r,n){for(let i=0;i<t.height;i++)for(let o=n;o<t.width;o++)if(t.getValue(o,i,r)>=e)return i;return-1}function findBottom(t,e,r,n){for(let i=t.height-1;i>=0;i--)for(let o=n;o<t.width;o++)if(t.getValue(o,i,r)>=e)return i;return-1}function findRight(t,e,r,n,i,o){for(let s=t.width-1;s>=n;s--)for(let n=i;n<=o;n++)if(t.getValue(s,n,r)>=e)return s;return-1}const InterpolationType={NEAREST:"nearest",BILINEAR:"bilinear",BICUBIC:"bicubic"};function getInterpolationFunction(t){return M$2(t).with("nearest",()=>interpolateNearest).with("bilinear",()=>interpolateBilinear).with("bicubic",()=>interpolateBicubic).exhaustive()}function interpolateNearest(t,e,r,n,i){return i(e=Math.round(e),r=Math.round(r),n,t)}function interpolateBilinear(t,e,r,n,i){const o=Math.floor(e),s=Math.floor(r),a=o+1,l=s+1;if(a<t.width&&l<t.height&&o>=0&&s>=0){return round((l-r)*((a-e)*t.getValue(o,s,n)+(e-o)*t.getValue(a,s,n))+(r-s)*((a-e)*t.getValue(o,l,n)+(e-o)*t.getValue(a,l,n)))}return round((l-r)*((a-e)*i(o,s,n,t)+(e-o)*i(a,s,n,t))+(r-s)*((a-e)*i(o,l,n,t)+(e-o)*i(a,l,n,t)))}function interpolateBicubic(t,e,r,n,i,o){const s=Math.floor(e),a=Math.floor(r);if(s===e&&a===r)return i(s,a,n,t);const l=e-s,h=r-a,c=cubic(i(s-1,a-1,n,t),i(s,a-1,n,t),i(s+1,a-1,n,t),i(s+2,a-1,n,t),l),u=cubic(i(s-1,a,n,t),i(s,a,n,t),i(s+1,a,n,t),i(s+2,a,n,t),l),f=cubic(i(s-1,a+1,n,t),i(s,a+1,n,t),i(s+1,a+1,n,t),i(s+2,a+1,n,t),l),d=cubic(i(s-1,a+2,n,t),i(s,a+2,n,t),i(s+1,a+2,n,t),i(s+2,a+2,n,t),l);return round(o(cubic(c,u,f,d,h)))}function cubic(t,e,r,n,i){return e+.5*i*(r-t+i*(2*t-5*e+4*r-n+i*(3*(e-r)+n-t)))}function transform(t,e,r={}){const{borderType:n="constant",borderValue:i=0,interpolationType:o="bilinear",fullImage:s}=r;let{width:a=t.width,height:l=t.height}=r;if(!isValidMatrix(e))throw new TypeError(`transformation matrix must be 2x3 or 3x3. Received ${e.length}x${e[1].length}`);if(2===e.length&&e.push([0,0,1]),s){(e=e.map(t=>t.slice()))[0][2]=0,e[1][2]=0;const r=[t.getCoordinates("top-left"),t.getCoordinates("top-right"),t.getCoordinates("bottom-right"),t.getCoordinates("bottom-left")];r[1].column+=1,r[2].column+=1,r[2].row+=1,r[3].row+=1;const n=r.map(t=>[transformPoint(e[0],e[2],t.column,t.row),transformPoint(e[1],e[2],t.column,t.row)]),i=n.map(t=>t[0]),o=n.map(t=>t[1]),s=Math.max(...i),h=Math.max(...o),c=Math.min(...i),u=Math.min(...o),f=[(t.width-1)/2,(t.height-1)/2];a=s-c,l=h-u;const d=(a-1)/2-transformPoint(e[0],e[2],f[0],f[1]),m=(l-1)/2-transformPoint(e[1],e[2],f[0],f[1]);e[0][2]=d,e[1][2]=m,a=Math.round(a),l=Math.round(l)}r.inverse||(e=inverse(new Matrix(e)).to2DArray());const h=Image.createFrom(t,{width:a,height:l}),c=getBorderInterpolation(n,i),u=getClamp(h),f=getInterpolationFunction(o);for(let r=0;r<h.height;r++)for(let n=0;n<h.width;n++){const i=transformPoint(e[0],e[2],n,r),o=transformPoint(e[1],e[2],n,r);for(let e=0;e<h.channels;e++){const s=f(t,i,o,e,c,u);h.setValue(n,r,e,s)}}return h}function transformPoint(t,e,r,n){return(t[0]*r+t[1]*n+t[2])/(e[0]*r+e[1]*n+e[2])}function isValidMatrix(t){return 3===t.length&&3===t[0].length&&3===t[1].length&&3===t[2].length||2===t.length&&3===t[0].length&&3===t[1].length}function resize(t,e){const{interpolationType:r="bilinear",borderType:n="replicate",borderValue:i=0}=e,{width:o,height:s,xFactor:a,yFactor:l}=checkOptions(t,e);return transform(t,[[a,0,a/2],[0,l,l/2]],{interpolationType:r,borderType:n,borderValue:i,height:s,width:o})}function checkOptions(t,e){const{width:r,height:n,xFactor:i,yFactor:o,preserveAspectRatio:s=!0}=e;if(void 0===r&&void 0===n&&void 0===i&&void 0===o)throw new TypeError("at least one of the width, height, xFactor or yFactor options must be passed");let a,l;const h=getSize(r,i,t.width,s),c=getSize(n,o,t.height,s);return void 0===h?(assert(void 0!==c),a=Math.round(c*(t.width/t.height))):a=h,void 0===c?(assert(void 0!==h),l=Math.round(h*(t.height/t.width))):l=c,{width:a,height:l,xFactor:i??a/t.width,yFactor:o??l/t.height}}function getSize(t,e,r,n){if(void 0!==t){if(void 0!==e)throw new TypeError("factor and size cannot be passed together");return t}return void 0!==e?Math.round(r*e):n?void 0:r}function rotate(t,e){const r=e%180==0?t.width:t.height,n=e%180==0?t.height:t.width,i=Image.createFrom(t,{width:r,height:n});if(90===e||-270===e)for(let e=0;e<t.width;e++)for(let r=0;r<t.height;r++)for(let n=0;n<t.channels;n++)i.setValue(i.width-r-1,e,n,t.getValue(e,r,n));else if(180===e||-180===e)for(let e=0;e<t.width;e++)for(let r=0;r<t.height;r++)for(let n=0;n<t.channels;n++)i.setValue(i.width-e-1,i.height-r-1,n,t.getValue(e,r,n));else{if(270!==e&&-90!==e)throw new RangeError(`invalid angle: ${e}`);for(let e=0;e<t.width;e++)for(let r=0;r<t.height;r++)for(let n=0;n<t.channels;n++)i.setValue(r,i.height-e-1,n,t.getValue(e,r,n))}return i}function transformRotate(t,e,r={}){const{center:n="center",scale:i=1,...o}=r;let s;s="string"==typeof n?t.getCoordinates(n):n;return transform(t,getRotationMatrix(e,s,i),o)}function getRotationMatrix(t,e,r){const n=t*Math.PI/180,i=r*Math.cos(n),o=r*Math.sin(n);return[[i,o,(1-i)*e.column-o*e.row],[-o,i,o*e.column+(1-i)*e.row],[0,0,1]]}function getPerspectiveWarp(t,e={}){if(4!==t.length)throw new Error(`The array pts must have four elements, which are the four corners. Currently, pts have ${t.length} elements`);const{width:r,height:n}=e,[i,o,s,a]=order4Points(t);let l,h;if(n&&r)l=r,h=n;else{if(n||r)throw new Error(`Invalid dimensions: ${r?"`height`":"`width`"} is missing. Either provide both width and height, or omit both to auto-calculate dimensions.`);l=Math.ceil(Math.max(distance2Points(i,o),distance2Points(a,s))),h=Math.ceil(Math.max(distance2Points(i,a),distance2Points(o,s)))}const[c,u]=[0,0],[f,d]=[l-1,0],[m,g]=[l-1,h-1],[p,w]=[0,h-1],b=new Matrix([[c,u,1,0,0,0,-c*i.column,-u*i.column],[f,d,1,0,0,0,-f*o.column,-d*o.column],[m,g,1,0,0,0,-m*s.column,-g*s.column],[p,w,1,0,0,0,-p*a.column,-w*a.column],[0,0,0,c,u,1,-c*i.row,-u*i.row],[0,0,0,f,d,1,-f*o.row,-d*o.row],[0,0,0,m,g,1,-m*s.row,-g*s.row],[0,0,0,p,w,1,-p*a.row,-w*a.row]]),_=Matrix.columnVector([i.column,o.column,s.column,a.column,i.row,o.row,s.row,a.row]),y=new SingularValueDecomposition(b).solve(_).to1DArray();y.push(1);const x=[];for(let t=0;t<3;t++){const e=[];for(let r=0;r<3;r++)e.push(y[3*t+r]);x.push(e)}return{matrix:x,width:l,height:h}}function order4Points(t){let e,r,n,i,o=t[0].column,s=0;for(let e=1;e<t.length;e++)t[e].column<o&&(o=t[e].column,s=e);let a=t[(s+1)%t.length].column,l=(s+1)%t.length;for(let e=0;e<t.length;e++)t[e].column<a&&e!==s&&(a=t[e].column,l=e);return t[l].row<t[s].row?(e=t[l],i=t[s],s!==(l+1)%4?(r=t[(l+1)%4],n=t[(l+2)%4]):(r=t[(l+2)%4],n=t[(l+3)%4])):(i=t[l],e=t[s],l!==(s+1)%4?(r=t[(s+1)%4],n=t[(s+2)%4]):(r=t[(s+2)%4],n=t[(s+3)%4])),[e,r,n,i]}function distance2Points(t,e){return Math.hypot(t.column-e.column,t.row-e.row)}function rotatePoint(t,e,r){const n=Math.cos(r),i=Math.sin(r);return{column:t.column*n-t.row*i+(1-n)*e.column+e.row*i,row:t.column*i+t.row*n+(1-n)*e.row-e.column*i}}function cropRectangle(t,e,r){if(4!==e.length)throw new Error("The points array must contain 4 points");const n=getSmallestAngle(e),i={row:(e[0].row+e[2].row)/2,column:(e[0].column+e[2].column)/2},o=e.map(t=>rotatePoint(t,i,n)),[s,a,l]=o,h=Math.max(Math.abs(s.column-a.column),Math.abs(a.column-l.column)),c=Math.max(Math.abs(s.row-a.row),Math.abs(a.row-l.row)),u=Math.min(Math.ceil(h),Math.ceil(h-1e-10)),f=Math.min(Math.ceil(c),Math.ceil(c-1e-10)),d={row:Math.min(...o.map(t=>t.row))-(f-c)/2,column:Math.min(...o.map(t=>t.column))-(u-h)/2},m=rotatePoint(d,i,-n),g=Math.cos(-n),p=Math.sin(-n);return transform(t,[[g,-p,m.column],[p,g,m.row]],{inverse:!0,width:u,height:f,...r})}function getSmallestAngle(t){let e=-getAngle(t[1],t[0]);e>Math.PI/2?e-=Math.PI:e<-Math.PI/2&&(e+=Math.PI);let r=e;return Math.abs(e)>Math.PI/4&&(r=e>0?-Math.PI/2+e:Math.PI/2+e),r}function paintMaskOnImage(t,e,r={}){const{origin:n={row:0,column:0},color:i=getDefaultColor(t),blend:o=!0}=r,{column:s,row:a}=n;if(i.length!==t.channels)throw new RangeError("the given color is not compatible with the image");checkPointIsInteger(n,"Origin");const l=getOutputImage(t,r,{clone:!0});if(o){checkColorIsNumberArray(i);for(let r=Math.max(a,0);r<Math.min(e.height+a,t.height);r++)for(let n=Math.max(s,0);n<Math.min(e.width+s,t.width);n++)e.getBit(n-s,r-a)&&setBlendedPixel(l,n,r,i)}else for(let r=Math.max(a,0);r<Math.min(e.height+a,t.height);r++)for(let n=Math.max(s,0);n<Math.min(e.width+s,t.width);n++)if(e.getBit(n-s,r-a))for(let e=0;e<t.channels;e++){const t=i[e];"number"==typeof t&&l.setValue(n,r,e,t)}return l}function checkColorIsNumberArray(t){for(const e of t)if("number"!=typeof e)throw new TypeError("cannot have null channels in color if blend is true")}function paintMaskOnMask(t,e,r={}){const{origin:n={row:0,column:0},value:i=1}=r,{column:o,row:s}=n;checkPointIsInteger(n,"Origin");const a=maskToOutputMask(t,r,{clone:!0});for(let r=Math.max(s,0);r<Math.min(e.height+s,t.height);r++)for(let n=Math.max(o,0);n<Math.min(e.width+o,t.width);n++)e.getBit(n-o,r-s)&&a.setBit(n,r,i);return a}function maybeToPrecision(t,e){return t<0?(t=0-t,"number"==typeof e?`- ${t.toPrecision(e)}`:`- ${t.toString()}`):"number"==typeof e?t.toPrecision(e):t.toString()}function checkArrayLength(t,e){if(!isAnyArray$1(t.x)||!isAnyArray$1(t.y)||!isAnyArray$1(e))throw new TypeError("x, y and outputs must be arrays");if(t.x.length<2)throw new RangeError("explanatory variable should be two element per point");if(t.x.length!==t.y.length)throw new RangeError("x and y data must have the same length");if(t.x.length!==e.length)throw new RangeError("input and outputs must have the same length")}class BaseRegression2D{constructor(){if(new.target===BaseRegression2D)throw new Error("BaseRegression must be subclassed")}predict(t){if(isOnePoint(t))return this._predict(t);if(isAnyArray$1(t.x)){const{x:e,y:r}=t,n=new Float64Array(e.length);for(let t=0;t<e.length;t++)n[t]=this._predict({x:e[t],y:r[t]});return n}throw new TypeError("x must be a number or array")}_predict(t){throw new Error("_predict must be implemented")}train(){}toString(t){return""}toLaTeX(t){return""}getScore(t,e){checkArrayLength(t,e);const r=this.predict(t);let n=0,i=0,o=0,s=0,a=0,l=0,h=0;const c=e.length;for(let t=0;t<c;t++)n+=r[t],i+=e[t],a+=r[t]*r[t],l+=e[t]*e[t],h+=r[t]*e[t],0!==e[t]&&(o+=(e[t]-r[t])*(e[t]-r[t])/e[t]),s+=(e[t]-r[t])*(e[t]-r[t]);const u=(c*h-n*i)/Math.sqrt((c*a-n*n)*(c*l-i*i));return{r:u,r2:u*u,chi2:o,rmsd:Math.sqrt(s/c)}}}function isOnePoint(t){return!isAnyArray$1(t.x)}class PolynomialRegression2D extends BaseRegression2D{order;coefficients;score;constructor(t,e,r={}){if(super(),!0===t)this.coefficients=Matrix.columnVector(e.coefficients),this.order=e.order,this.score=e.score;else{checkArrayLength(t,e);const{order:n=2}=r;this.order=n,this.coefficients=train(t,e,n),this.score=this.getScore(t,e)}}_predict(t){const{x:e,y:r}=t;let n=0,i=0;for(let t=0;t<=this.order;t++)for(let o=0;o<=this.order-t;o++)n+=e**t*r**o*this.coefficients.get(i,0),i++;return n}toString(t){return this._toFormula(t,!1)}toLaTeX(t){return this._toFormula(t,!0)}_toFormula(t,e){let r="^",n="",i=" * ";e&&(r="^{",n="}",i="");let o="",s="",a=0;for(let e=0;e<=this.order;e++)for(let l=0;l<=this.order-e;l++){s="";const h=this.coefficients.get(a,0);0!==h&&(s+=maybeToPrecision(h,t),1===e?s+=`${i}x`:e>1&&(s+=`${i}x${r}${e}${n}`),1===l?s+=`${i}y`:l>1&&(s+=`${i}y${r}${l}${n}`),s=h>0?` + ${s}`:` ${s}`),a++,o=s+o}return`f(x, y) = ${o.startsWith("+")?o.slice(1):o}`}toJSON(){return{name:"polyfit2D",order:this.order,score:this.score,coefficients:this.coefficients}}static load(t){if("polyfit2D"!==t.name)throw new TypeError("not a polyfit2D model");return new PolynomialRegression2D(!0,t)}}function powColVector(t,e){const r=t.clone();for(let n=0;n<t.rows;++n)r.set(n,0,r.get(n,0)**e);return r}function train(t,e,r){Matrix.isMatrix(e)||(e=Matrix.columnVector(e));const n=new Matrix(e.rows,2);if(n.setColumn(0,t.x),n.setColumn(1,t.y),e.rows!==n.rows&&(e=e.transpose()),2!==n.columns)throw new RangeError(`You give x with ${n.columns} columns and it must be 2`);if(n.rows!==e.rows)throw new RangeError("x and y must have the same rows");const i=n.rows,o=(r+2)*(r+1)/2;if(i<o)throw new TypeError("Insufficient number of points to create regression model.");const s=n.getColumnVector(0),a=n.getColumnVector(1),l=1/s.clone().abs().max(),h=1/a.clone().abs().max(),c=1/e.clone().abs().max();s.mulColumn(0,l),a.mulColumn(0,h),e.mulColumn(0,c);const u=new Matrix(i,o);let f=0;for(let t=0;t<=r;++t){const e=r-t;for(let r=0;r<=e;++r){const e=powColVector(s,t).mulColumnVector(powColVector(a,r));u.setColumn(f,e),f++}}const d=new SVD(u.transpose(),{computeLeftSingularVectors:!0,computeRightSingularVectors:!0,autoTranspose:!1});let m=Matrix.rowVector(d.diagonal);m=m.apply((t,e)=>{m.get(t,e)>=1e-15?m.set(t,e,1/m.get(t,e)):m.set(t,e,0)});const g=Matrix.zeros(i,o);for(let t=0;t<o;++t)g.set(t,t,m.get(0,t));m=g;const p=d.rightSingularVectors,w=d.leftSingularVectors.mmul(m.transpose()).mmul(p.transpose()).mmul(e);for(let t=0,e=0;t<=o;++t){const n=r-t;for(let r=0;r<=n;++r)w.set(e,0,w.get(e,0)*l**t*h**r/c),e++}return w}function correctBackground(t,e){const{background:r,order:n=2,backgroundKind:i="light"}=e;checkProcessable$1(t,{colorModel:["GREY"]});const o=new Array,s=new Array,a=new Array;for(const e of r)o.push(e.column),s.push(e.row),a.push(t.getValueByPoint(e,0));const l=new PolynomialRegression2D({x:o,y:s},a,{order:n}),h={x:[],y:[]};for(let e=0;e<t.height;e++)for(let r=0;r<t.width;r++)h.x.push(r),h.y.push(e);const c=l.predict(h);for(let e=0;e<t.height;e++)for(let r=0;r<t.width;r++){const n=Math.abs(t.getValue(r,e,0)-c[e*t.width+r]);t.setValue(r,e,0,n)}return"light"===i?t.invert():t}function invert(t,e){if(t instanceof Image){const r=getOutputImage(t,e);t.alpha&&copyAlpha(t,r);const{maxValue:n,size:i}=r;for(let e=0;e<i;e++)for(let i=0;i<t.components;i++)r.setValueByIndex(e,i,n-t.getValueByIndex(e,i));return r}{const r=maskToOutputMask(t,e);for(let e=0;e<r.size;e++)r.setBitByIndex(e,!t.getBitByIndex(e));return r}}function level(t,e={}){const r=t.minMax();let{inputMin:n=r.min,inputMax:i=r.max,outputMin:o=0,outputMax:s=t.maxValue,gamma:a=1}=e;const{channels:l=new Array(t.components).fill(0).map((t,e)=>e)}=e;validateChannels(l,t),checkProcessable$1(t,{bitDepth:[8,16]});const h=getOutputImage(t,e,{clone:!0}),c=getClamp(t);n=getValueArray(n,t.channels),i=getValueArray(i,t.channels),o=getValueArray(o,t.channels),s=getValueArray(s,t.channels),a=getValueArray(a,t.channels);for(let e=0;e<t.height;e++)for(let r=0;r<t.width;r++)for(const u of l){const l=t.getValue(r,e,u);let f=c((Math.max(Math.min(l,i[u]),n[u])-n[u])/(i[u]-n[u]));Number.isNaN(f)&&(f=0);const d=c(f**(1/a[u])*(s[u]-o[u])+o[u]);h.setValue(r,e,u,d)}return h}function getValueArray(t,e){if(Array.isArray(t)){if(t.length===e)return t;throw new RangeError("array length is not compatible with channel option")}return new Array(e).fill(t)}function or(t,e,r){const n=maskToOutputMask(t,r);if(t.width!==e.width||t.height!==e.height)throw new RangeError("both masks must have the same size");for(let r=0;r<n.size;r++)t.getBitByIndex(r)||e.getBitByIndex(r)?n.setBitByIndex(r,1):n.setBitByIndex(r,0);return n}function flipX(t){checkProcessable$1(t,{bitDepth:[8,16]});for(let e=0;e<t.height;e++)for(let r=0;r<Math.floor(t.width/2);r++){const n=r,i=t.width-r-1;for(let r=0;r<t.channels;r++){const o=t.getValue(n,e,r);t.setValue(n,e,r,t.getValue(i,e,r)),t.setValue(i,e,r,o)}}return t}function flipY(t){checkProcessable$1(t,{bitDepth:[8,16]});for(let e=0;e<Math.floor(t.height/2);e++)for(let r=0;r<t.width;r++){const n=e,i=t.height-e-1;for(let e=0;e<t.channels;e++){const o=t.getValue(r,n,e);t.setValue(r,n,e,t.getValue(r,i,e)),t.setValue(r,i,e,o)}}return t}function flip(t,e={}){const{axis:r="horizontal"}=e,n=getOutputImage(t,e,{clone:!0});return"horizontal"===r?flipX(n):flipY("vertical"===r?n:flipX(n))}function medianFilter(t,e){const{cellSize:r=3,borderType:n="reflect101",borderValue:i}=e;if(checkProcessable$1(t,{bitDepth:[8,16]}),r<1)throw new RangeError(`Invalid property "cellSize". Must be greater than 0. Received ${r}.`);if(r%2==0)throw new RangeError(`Invalid property "cellSize". Must be an odd number. Received ${r}.`);const o=getBorderInterpolation(n,i),s=Image.createFrom(t),a=new Uint16Array(r**2),l=(r-1)/2;for(let e=0;e<t.channels;e++)for(let r=0;r<t.height;r++)for(let n=0;n<t.width;n++){let i=0;for(let s=-l;s<=l;s++)for(let h=-l;h<=l;h++)a[i++]=o(n+h,r+s,e,t);s.setValue(n,r,e,xMedian(a))}return s}function pixelate(t,e){const{cellSize:r,algorithm:n="center"}=e;if(!Number.isInteger(r))throw new TypeError("cellSize must be an integer");if(r<2)throw new RangeError("cellSize must be greater than 1");const i=getOutputImage(t,e),o=getCellValueFunction(n);for(let e=0;e<t.channels;e++)for(let n=0;n<t.width;n+=r)for(let s=0;s<t.height;s+=r){const a=Math.min(r,t.width-n),l=Math.min(r,t.height-s),h=o(t,e,{width:a,height:l,origin:{column:n,row:s}});for(let t=n;t<n+a;t++)for(let r=s;r<s+l;r++)i.setValue(t,r,e,h)}return i}function getCellCenter(t,e,r){const n={column:Math.floor((r.origin.column+r.origin.column+r.width-1)/2),row:Math.floor((r.origin.row+r.origin.row+r.height-1)/2)};return t.getValue(n.column,n.row,e)}function getCellMean(t,e,r){let n=0;for(let i=r.origin.column;i<r.origin.column+r.width;i++)for(let o=r.origin.row;o<r.origin.row+r.height;o++)n+=t.getValue(i,o,e);return Math.round(n/(r.width*r.height))}function getCellMedian(t,e,r){const n=[];for(let i=r.origin.column;i<r.origin.column+r.width;i++)for(let o=r.origin.row;o<r.origin.row+r.height;o++)n.push(t.getValue(i,o,e));return xMedian(n)}function getCellValueFunction(t){switch(t){case"mean":return getCellMean;case"median":return getCellMedian;case"center":return getCellCenter;default:assertUnreachable(t)}}function getBorderPoints$1(t,e={}){const{innerBorders:r=!1,allowCorners:n=!1}=e;r||(t=t.solidFill());const i=[];for(let e=0;e<t.width;e++)t.getBit(e,0)&&i.push({column:e,row:0}),t.getBit(e,t.height-1)&&i.push({column:e,row:t.height-1});for(let e=0;e<t.height;e++)t.getBit(0,e)&&i.push({column:0,row:e}),t.getBit(t.width-1,e)&&i.push({column:t.width-1,row:e});for(let e=1;e<t.height-1;e++)for(let r=1;r<t.width-1;r++)t.getBit(r,e)&&(0!==t.getBit(r-1,e)&&0!==t.getBit(r,e-1)&&0!==t.getBit(r+1,e)&&0!==t.getBit(r,e+1)||i.push({column:r,row:e}),!n||0!==t.getBit(r-1,e-1)&&0!==t.getBit(r-1,e+1)&&0!==t.getBit(r+1,e-1)&&0!==t.getBit(r+1,e+1)||i.push({column:r,row:e}));return i}function getLineLength(t,e){return Math.hypot(t.column-e.column,t.row-e.row)}function getPolygonPerimeter(t){let e=0;for(let r=0;r<t.length;r++)e+=getLineLength(t[(r+1)%t.length],t[r]);return e}function getPolygonArea(t){let e=0;for(let r=0;r<t.length;r++){const n=(r+1)%t.length;e+=t[r].column*t[n].row,e-=t[r].row*t[n].column}return Math.abs(e/2)}function getExtendedBorderPoints(t){const e=t.getBorderPoints({allowCorners:!0,innerBorders:!1}),r=[];for(const t of e)r.push(t,{column:t.column+1,row:t.row},{column:t.column+1,row:t.row+1},{column:t.column,row:t.row+1});return r}function monotoneChainConvexHull(t,e={}){const{sorted:r=!1}=e;r||(t=t.slice()).sort(byXThenY);const n=t.length,i=new Array(2*n);let o=0;for(let e=0;e<n;e++){const r=t[e];for(;o>=2&&cw(i[o-2],i[o-1],r)<=0;)o--;i[o++]=r}const s=o+1;for(let e=n-2;e>=0;e--){const r=t[e];for(;o>=s&&cw(i[o-2],i[o-1],r)<=0;)o--;i[o++]=r}return i.slice(0,o-1)}function cw(t,e,r){return(e.row-t.row)*(r.column-t.column)-(e.column-t.column)*(r.row-t.row)}function byXThenY(t,e){return t.column===e.column?t.row-e.row:t.column-e.column}function getConvexHull(t){const e=getExtendedBorderPoints(t);if(0===e.length)return{points:[],surface:0,perimeter:0};const r=monotoneChainConvexHull(e);return{points:r,perimeter:getPolygonPerimeter(r),surface:getPolygonArea(r)}}function getFeret(t){const e=t.getConvexHull(),r=e.points;if(0===e.surface)return{minDiameter:{length:0,points:[{column:0,row:0},{column:0,row:0}],angle:0,calliperLines:[[{column:0,row:0},{column:0,row:0}],[{column:0,row:0},{column:0,row:0}]]},maxDiameter:{length:0,points:[{column:0,row:0},{column:0,row:0}],angle:0,calliperLines:[[{column:0,row:0},{column:0,row:0}],[{column:0,row:0},{column:0,row:0}]]},aspectRatio:1};let n,i=Number.POSITIVE_INFINITY,o=0,s=[];for(let t=0;t<r.length;t++){const e=getAngle(r[t],r[(t+1)%r.length]),a=rotate$1(-e,r);let l=0,h=[];for(let e=0;e<r.length;e++){const r=Math.abs(a[t].row-a[e].row);r>l&&(l=r,h=[a[t],a[e]])}if(l<i){i=l,o=e,s=h;const{minIndex:t,maxIndex:r}=findPointIndexesOfExtremeColumns(a);n=getMinLines(o,t,r,a,s)}}const a={points:rotate$1(o,s),length:i,angle:toDegrees(o),calliperLines:n};let l=[],h=0,c=[];for(let t=0;t<r.length-1;t++)for(let e=t+1;e<r.length;e++){const n=(r[t].column-r[e].column)**2+(r[t].row-r[e].row)**2;n>h&&(h=n,l=[r[t],r[e]],c=[t,e])}const u=getAngle(l[0],l[1]),f=rotate$1(-u,r),{minIndex:d,maxIndex:m}=findPointsIndexesOfExtremeRows(f),g=getMaxLines(u,d,m,f,c),p={length:Math.sqrt(h),angle:toDegrees(getAngle(l[0],l[1])),points:l,calliperLines:g};return{minDiameter:a,maxDiameter:p,aspectRatio:a.length/p.length}}function findPointIndexesOfExtremeColumns(t){let e=0,r=0;for(let n=0;n<t.length;n++)t[n].column>t[e].column&&(e=n),t[n].column<t[r].column&&(r=n);return{minIndex:r,maxIndex:e}}function findPointsIndexesOfExtremeRows(t){let e=0,r=0;for(let n=0;n<t.length;n++)t[n].row>t[e].row&&(e=n),t[n].row<t[r].row&&(r=n);return{minIndex:r,maxIndex:e}}function getMinLines(t,e,r,n,i){const o=[{column:n[e].column,row:i[0].row},{column:n[r].column,row:i[0].row}],s=[{column:n[e].column,row:i[1].row},{column:n[r].column,row:i[1].row}];return[rotate$1(t,o),rotate$1(t,s)]}function getMaxLines(t,e,r,n,i){const o=[{column:n[i[0]].column,row:n[e].row},{column:n[i[0]].column,row:n[r].row}],s=[{column:n[i[1]].column,row:n[e].row},{column:n[i[1]].column,row:n[r].row}];return[rotate$1(t,o),rotate$1(t,s)]}const leftFirst=(t,e)=>t.column<=e.column?-1:1,topFirst=(t,e)=>t.row>=e.row?-1:1;function getMbrAngle(t){const e=t.slice();e.sort(leftFirst);const r=e.slice(0,2),n=e.slice(2,4);r.sort(topFirst),n.sort(topFirst);return-toDegrees(getAngle(r[0],n[0]))}function getMbrFromPoints(t){if(0===t.length)return{points:[],angle:0,width:0,height:0,surface:0,perimeter:0,aspectRatio:0};if(1===t.length)return{points:[t[0],t[0],t[0],t[0]],perimeter:0,surface:0,angle:0,width:0,height:0,aspectRatio:1};let e=[],r=Number.POSITIVE_INFINITY,n=0,i=[];for(let o=0;o<t.length;o++){const s=getAngle(t[o],t[(o+1)%t.length]);e=rotate$1(-s,t);const a=e[o].column,l=e[o].row,h=e[(o+1)%e.length].column,c=e[(o+1)%e.length].row;let u=!0,f=0,d=0,m=0;for(const t of e){const e=(t.column-a)/(h-a);u?(u=!1,f=e,d=e):(e<f&&(f=e),e>d&&(d=e));const r=(-(h-a)*t.row+h*l-c*a)/(h-a);Math.abs(r)>Math.abs(m)&&(m=r)}const g={column:a+f*(h-a),row:l},p={column:a+d*(h-a),row:l},w=Math.abs(m*(f-d)*(h-a));w<r&&(n=s,r=w,i=[p,g,{column:g.column,row:g.row-m},{column:p.column,row:p.row-m}])}const o=rotate$1(n,i),s=[Math.hypot(i[0].column-i[1].column,i[0].row-i[1].row),Math.hypot(i[0].column-i[3].column,i[0].row-i[3].row)],a=Math.max(...s),l=Math.min(...s);return{points:o,surface:r,angle:getMbrAngle(o),width:a,height:l,perimeter:2*a+2*l,aspectRatio:l/a}}function getMbr(t){return getMbrFromPoints(monotoneChainConvexHull(getExtendedBorderPoints(t)))}function checkKernel(t){if(t.length%2==0||t[0].length%2==0)throw new TypeError("the number of rows and columns of the kernel must be odd")}function erode(t,e={}){let r=!1;void 0===e.kernel&&(r=!0);const{kernel:n=[[1,1,1],[1,1,1],[1,1,1]],iterations:i=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(n);let o=!0;if(!r)t:for(const t of n)for(const e of t)if(1!==e){o=!1;break t}let s=t;for(let e=0;e<i;e++)if(s instanceof Mask)if(o){const t=s.clone();s=erodeMaskOnlyOnes(s,t,n[0].length,n.length)}else{s=erodeMask(s,Mask.createFrom(t),n)}else if(o){s=erodeGreyOnlyOnes(s,Image.createFrom(t),n[0].length,n.length)}else{s=erodeGrey(s,Image.createFrom(t),n)}return s}function erodeGrey(t,e,r){const n=r[0].length,i=r.length,o=(n-1)/2,s=(i-1)/2;for(let a=0;a<t.height;a++)for(let l=0;l<t.width;l++){let h=t.maxValue;for(let e=0;e<i;e++)for(let i=0;i<n;i++){if(1!==r[e][i])continue;const n=i-o+l,c=e-s+a;if(n<0||c<0||n>=t.width||c>=t.height)continue;const u=t.getValue(n,c,0);u<h&&(h=u)}e.setValue(l,a,0,h)}return e}function erodeGreyOnlyOnes(t,e,r,n){const i=(r-1)/2,o=(n-1)/2,s=[];for(let e=0;e<t.width;e++)s.push(0);for(let r=0;r<t.height;r++){for(let e=0;e<t.width;e++){let n=t.maxValue;for(let i=Math.max(0,r-o);i<Math.min(t.height,r+o+1);i++){const r=t.getValue(e,i,0);r<n&&(n=r)}s[e]=n}for(let n=0;n<t.width;n++){let o=t.maxValue;for(let e=Math.max(0,n-i);e<Math.min(t.width,n+i+1);e++)s[e]<o&&(o=s[e]);e.setValue(n,r,0,o)}}return e}function erodeMask(t,e,r){const n=r[0].length,i=r.length,o=(n-1)/2,s=(i-1)/2;for(let a=0;a<t.height;a++)for(let l=0;l<t.width;l++){let h=1;for(let e=0;e<i;e++)for(let i=0;i<n;i++){if(1!==r[e][i])continue;const n=i-o+l,c=e-s+a;if(c<0||n<0||n>=t.width||c>=t.height)continue;if(0===t.getBit(n,c)){h=0;break}}1===h&&e.setBit(l,a,1)}return e}function erodeMaskOnlyOnes(t,e,r,n){const i=(r-1)/2,o=(n-1)/2,s=[];for(let e=0;e<t.width;e++)s.push(0);for(let r=0;r<t.height;r++){for(let e=0;e<t.width;e++){s[e]=1;for(let n=Math.max(0,r-o);n<Math.min(t.height,r+o+1);n++)if(0===t.getBit(e,n)){s[e]=0;break}}for(let n=0;n<t.width;n++)if(0!==e.getBit(n,r))for(let o=Math.max(0,n-i);o<Math.min(t.width,n+i+1);o++)if(0===s[o]){e.setBit(n,r,0);break}}return e}function dilate(t,e={}){let r=!1;void 0===e.kernel&&(r=!0);const{kernel:n=[[1,1,1],[1,1,1],[1,1,1]],iterations:i=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(n);let o=!0;if(!r)t:for(const t of n)for(const e of t)if(1!==e){o=!1;break t}let s=t;for(let t=0;t<i;t++)if(s instanceof Mask)if(o){const t=s.clone();s=dilatMaskOnlyOnes(s,t,n[0].length,n.length)}else{s=dilateMask(s,Mask.createFrom(s),n)}else if(o){s=dilateGreyOnlyOnes(s,Image.createFrom(s),n[0].length,n.length)}else{s=dilateGrey(s,Image.createFrom(s),n)}return s}function dilateGrey(t,e,r){const n=r[0].length,i=r.length,o=(n-1)/2,s=(i-1)/2;for(let a=0;a<t.height;a++)for(let l=0;l<t.width;l++){let h=0;for(let e=0;e<i;e++)for(let i=0;i<n;i++){if(1!==r[e][i])continue;const n=i-o+l,c=e-s+a;if(n<0||c<0||n>=t.width||c>=t.height)continue;const u=t.getValue(n,c,0);u>h&&(h=u)}e.setValue(l,a,0,h)}return e}function dilateGreyOnlyOnes(t,e,r,n){const i=(r-1)/2,o=(n-1)/2,s=[];for(let e=0;e<t.width;e++)s.push(0);for(let r=0;r<t.height;r++){for(let e=0;e<t.width;e++){let n=0;for(let i=Math.max(0,r-o);i<Math.min(t.height,r+o+1);i++){const r=t.getValue(e,i,0);r>n&&(n=r)}s[e]=n}for(let n=0;n<t.width;n++){let o=0;for(let e=Math.max(0,n-i);e<Math.min(t.width,n+i+1);e++)s[e]>o&&(o=s[e]);e.setValue(n,r,0,o)}}return e}function dilateMask(t,e,r){const n=r[0].length,i=r.length,o=(n-1)/2,s=(i-1)/2;for(let a=0;a<t.height;a++)for(let l=0;l<t.width;l++){let h=0;for(let e=0;e<i;e++)for(let i=0;i<n;i++){if(1!==r[e][i])continue;const n=i-o+l,c=e-s+a;if(c<0||n<0||n>=t.width||c>=t.height)continue;if(1===t.getBit(n,c)){h=1;break}}1===h&&e.setBit(l,a,1)}return e}function dilatMaskOnlyOnes(t,e,r,n){const i=(r-1)/2,o=(n-1)/2,s=[];for(let e=0;e<t.width;e++)s.push(1);for(let r=0;r<t.height;r++){for(let e=0;e<t.width;e++){s[e]=0;for(let n=Math.max(0,r-o);n<Math.min(t.height,r+o+1);n++)if(1===t.getBit(e,n)){s[e]=1;break}}for(let n=0;n<t.width;n++)if(1!==e.getBit(n,r))for(let o=Math.max(0,n-i);o<Math.min(t.width,n+i+1);o++)if(1===s[o]){e.setBit(n,r,1);break}}return e}function open(t,e={}){const{kernel:r=[[1,1,1],[1,1,1],[1,1,1]],iterations:n=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(r);let i=t;for(let t=0;t<n;t++)i=i.erode({kernel:r}),i=i.dilate({kernel:r});return i}function close(t,e={}){const{kernel:r=[[1,1,1],[1,1,1],[1,1,1]],iterations:n=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(r);let i=t;for(let t=0;t<n;t++)i=i.dilate({kernel:r}).erode({kernel:r});return i}function topHat(t,e={}){const{kernel:r=[[1,1,1],[1,1,1],[1,1,1]],iterations:n=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(r);let i=t;for(let t=0;t<n;t++){const t=i.open({kernel:r});i=subtract(t,i,{absolute:!0})}return i}function bottomHat(t,e={}){const{kernel:r=[[1,1,1],[1,1,1],[1,1,1]],iterations:n=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(r);let i=t;for(let t=0;t<n;t++){const t=i.close({kernel:r});i=subtract(t,i,{absolute:!0})}return i}function morphologicalGradient(t,e={}){const{kernel:r=[[1,1,1],[1,1,1],[1,1,1]],iterations:n=1}=e;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:1,alpha:!1}),checkKernel(r);let i=t;for(let t=0;t<n;t++){const t=i.dilate({kernel:r}),e=i.erode({kernel:r});i=subtract(t,e,{absolute:!0})}return i}function*borderIterator(t){for(let e=0;e<t.width;e++)yield e;for(let e=2;e<t.height;e++)yield e*t.width-1;for(let e=0;e<t.width;e++)yield t.width*t.height-e-1;for(let e=t.height-2;e>=1;e--)yield e*t.width}const MAX_ARRAY=65536,toProcess=new Uint32Array(MAX_ARRAY);function multipleFloodFill(t,e={}){const{startPixels:r=[0],startPixelValue:n=0,newPixelValue:i=1,allowCorners:o=!1}=e,s=maskToOutputMask(t,e,{clone:!0}),a=Mask.createFrom(t);let l=0,h=0;for(const t of r)s.getBitByIndex(t)===n&&(toProcess[h++%MAX_ARRAY]=t,a.setBitByIndex(t,1),s.setBitByIndex(t,i));for(;l<h;){assert(h-l<=MAX_ARRAY);const e=toProcess[l++%MAX_ARRAY];s.setBitByIndex(e,i);const r=e<t.width,n=e%t.width===0,a=e%t.width===t.width-1,u=e>t.size-t.width;if(!u){c(e+t.width)}if(!n){c(e-1)}if(!r){c(e-t.width)}if(!a){c(e+1)}if(o){if(!r){if(!n){c(e-t.width-1)}if(!a){c(e-t.width+1)}}if(!u){if(!n){c(e+t.width-1)}if(!a){c(e+t.width+1)}}}}function c(t){a.getBitByIndex(t)||s.getBitByIndex(t)===n&&(toProcess[h++%MAX_ARRAY]=t,a.setBitByIndex(t,1))}return s}function clearBorder(t,e={}){const{allowCorners:r=!1,out:n,color:i="white"}=e;return multipleFloodFill(t,{startPixels:borderIterator(t),startPixelValue:"white"===i?1:0,newPixelValue:"white"===i?0:1,allowCorners:r,out:n})}const kernelX=[[-1,0,1],[-2,0,2],[-1,0,1]],kernelY=[[-1,-2,-1],[0,0,0],[1,2,1]];function cannyEdgeDetector(t,e={}){const{hysteresis:r=!0,lowThreshold:n=.04,highThreshold:i=.1,gaussianBlurOptions:o={sigma:1}}=e,s=n*t.maxValue,a=i*t.maxValue;checkProcessable$1(t,{colorModel:"GREY"});const l=t.width,h=t.height,c=t.gaussianBlur(o),u=c.rawDirectConvolution(kernelY),f=c.rawDirectConvolution(kernelX),d=new Float64Array(t.size);for(let e=0;e<t.size;e++)d[e]=Math.hypot(u[e],f[e]);const m=new Float64Array(t.size),g=new Float64Array(t.size),p=imageToOutputMask(t,e);for(let e=1;e<l-1;e++)for(let r=1;r<h-1;r++){const n=getDirection(u[getIndex(e,r,t,0)],f[getIndex(e,r,t,0)]),i=d[getIndex(e,r,t,0)];(0===n&&i>=d[getIndex(e,r-1,t,0)]&&i>=d[getIndex(e,r+1,t,0)]||1===n&&i>=d[getIndex(e-1,r-1,t,0)]&&i>=d[getIndex(e+1,r+1,t,0)]||2===n&&i>=d[getIndex(e-1,r,t,0)]&&i>=d[getIndex(e+1,r,t,0)]||3===n&&i>=d[getIndex(e-1,r+1,t,0)]&&i>=d[getIndex(e+1,r-1,t,0)])&&(m[getIndex(e,r,t,0)]=i)}for(let t=0;t<l*h;++t){const e=m[t];let r=0;e>a&&(r++,p.setBitByIndex(t,1)),e>s&&r++,g[t]=r}if(r){let e=[];for(let r=1;r<l-1;++r)for(let n=1;n<h-1;++n)if(1===g[getIndex(r,n,t,0)])t:for(let i=r-1;i<r+2;++i)for(let o=n-1;o<n+2;++o)if(2===g[getIndex(i,o,t,0)]){e.push([r,n]),p.setValue(r,n,0,1);break t}for(;e.length>0;){const r=[];for(const n of e)for(let e=-1;e<2;++e)for(let i=-1;i<2;++i){if(0===e&&0===i)continue;const o=n[0]+e,s=n[1]+i;1===g[getIndex(s,o,t,0)]&&0===p.getValue(s,o,0)&&(r.push([o,s]),p.setValue(s,o,0,1))}e=r}}return p}function getDirection(t,e){return(Math.round(Math.atan2(e,t)*(4/Math.PI))+4)%4}function floodFill(t,e={}){const{origin:r={row:0,column:0},allowCorners:n=!1,out:i}=e;return multipleFloodFill(t,{startPixels:[getIndex(r.column,r.row,t)],allowCorners:n,out:i})}function solidFill(t,e={}){const{allowCorners:r=!1}=e,n=maskToOutputMask(t,e,{clone:!0}),i=t.invert().clearBorder({allowCorners:r});return n.or(i,{out:n})}function boolToNumber(t){let e;return e="boolean"==typeof t?t?1:0:t,e}class Mask{width;height;size;bitDepth;colorModel;components;channels;alpha;maxValue;origin;data;constructor(t,e,r={}){const{data:n,origin:i={row:0,column:0}}=r;if(t<1||!Number.isInteger(t))throw new RangeError(`width must be an integer and at least 1. Received ${t}`);if(e<1||!Number.isInteger(e))throw new RangeError(`height must be an integer and at least 1. Received ${e}`);this.width=t,this.height=e,this.size=t*e,this.bitDepth=1,this.colorModel="BINARY",this.origin=i;const o=colorModels[this.colorModel];if(this.components=o.components,this.alpha=o.alpha,this.channels=o.channels,this.maxValue=1,void 0===n)this.data=new Uint8Array(this.size);else{const t=this.size*this.channels;if(n.length!==t)throw new RangeError(`incorrect data size: ${n.length}. Expected ${t}`);this.data=n}}static createFrom(t,e={}){const{width:r=t.width,height:n=t.height,origin:i=t.origin}=e;return new Mask(r,n,{origin:i,...e})}getPixel(t,e){const r=[],n=e*this.width+t;return r.push(this.data[n]),r}setPixel(t,e,r){const n=e*this.width+t;this.data[n]=r[0]}setVisiblePixel(t,e,r){t>=0&&t<this.width&&e>=0&&e<this.height&&this.setPixel(t,e,r)}getPixelByIndex(t){return[this.data[t]]}setPixelByIndex(t,e){this.data[t]=e[0]}static fromPoints(t,e,r){const n=new Mask(t,e);for(const t of r)n.setBit(t.column,t.row,1);return n}clone(){return Mask.createFrom(this,{data:this.data.slice()})}getBit(t,e){const r=e*this.width+t;return this.data[r]}setBit(t,e,r){const n=e*this.width+t;this.data[n]=r}getBitByIndex(t){return this.data[t*this.channels]}setBitByIndex(t,e){this.data[t*this.channels]=boolToNumber(e)}getNbNonZeroPixels(){let t=0;for(const e of this.data)e&&t++;return t}getValue(t,e,r){return checkChannel(r),this.getBit(t,e)}setValue(t,e,r,n){checkChannel(r),this.setBit(t,e,n)}getValueByIndex(t,e){return checkChannel(e),this.getBitByIndex(t)}setValueByIndex(t,e,r){checkChannel(e),this.setBitByIndex(t,r)}getValueByPoint(t){return this.getValue(t.column,t.row,0)}setValueByPoint(t,e){this.setValue(t.column,t.row,0,e)}getRawImage(){return{width:this.width,height:this.height,data:this.data}}[Symbol.for("nodejs.util.inspect.custom")](){let t;return t=this.height>20||this.width>20?"[...]":printData$1(this),`Mask {\n  width: ${this.width}\n  height: ${this.height}\n  data: ${t}\n}`}fill(t){const e=boolToNumber(t);return this.data.fill(e),this}convertColor(t){return convertColor(this,t)}invert(t){return invert(this,t)}subtract(t,e){return subtract(this,t,e)}and(t,e){return and(this,t,e)}or(t,e){return or(this,t,e)}getBorderPoints(t){return getBorderPoints$1(this,t)}getConvexHull(){return getConvexHull(this)}getMbr(){return getMbr(this)}getFeret(){return getFeret(this)}erode(t){return erode(this,t)}dilate(t){return dilate(this,t)}open(t){return open(this,t)}close(t){return close(this,t)}topHat(t){return topHat(this,t)}bottomHat(t){return bottomHat(this,t)}morphologicalGradient(t){return morphologicalGradient(this,t)}clearBorder(t){return clearBorder(this,t)}floodFill(t){return floodFill(this,t)}solidFill(t){return solidFill(this,t)}drawPoints(t,e={}){return drawPoints(this,t,e)}drawLine(t,e,r={}){return drawLineOnMask(this,t,e,r)}drawPolyline(t,e={}){return drawPolylineOnMask(this,t,e)}drawPolygon(t,e={}){return drawPolygonOnMask(this,t,e)}drawRectangle(t={}){return drawRectangle(this,t)}copyTo(t,e={}){return copyTo(this,t,e)}paintMask(t,e){return paintMaskOnMask(this,t,e)}}function printData$1(t){const e=[];for(let r=0;r<t.height;r++){const n=[];for(let e=0;e<t.width;e++)n.push(String(t.getBit(e,r)));e.push(`[${n.join(" ")}]`)}return e.join("\n        ")}function checkChannel(t){if(0!==t)throw new RangeError(`channel value must be 0 on type Mask. Received ${t}`)}function subtract(t,e,r={}){const{absolute:n=!1}=r;t instanceof Image&&checkProcessable$1(t,{bitDepth:[1,8,16],components:[1,3],alpha:!1}),validateForComparison(t,e);const i=t.clone();if(i instanceof Image)for(let r=0;r<t.size;r++)for(let o=0;o<t.channels;o++){const s=t.getValueByIndex(r,o)-e.getValueByIndex(r,o);n?s<0?i.setValueByIndex(r,o,-s):i.setValueByIndex(r,o,s):s<0?i.setValueByIndex(r,o,0):i.setValueByIndex(r,o,s)}else if(t instanceof Mask&&e instanceof Mask)for(let r=0;r<t.size;r++){const o=t.getBitByIndex(r)-e.getBitByIndex(r);n?i.setBitByIndex(r,o?1:0):i.setBitByIndex(r,o>0?1:0)}return i}function add(t,e){t instanceof Image&&checkProcessable$1(t,{bitDepth:[8,16],components:[1,3],alpha:!1}),validateForComparison(t,e);const r=t.clone(),n=getClamp(t);for(let i=0;i<t.size;i++)for(let o=0;o<t.channels;o++){const s=t.getValueByIndex(i,o)+e.getValueByIndex(i,o);r.setValueByIndex(i,o,n(s))}return r}function multiply(t,e,r={}){const{channels:n=new Array(t.channels).fill(0).map((t,e)=>e)}=r;validateChannels(n,t);const i=getOutputImage(t,r,{clone:!0});if(0===n.length)return i;for(const t of n)for(let r=0;r<i.height;r++)for(let n=0;n<i.width;n++){const o=i.getValue(n,r,t)*e;i.setClampedValue(n,r,t,o)}return i}function mean(t,e){const r=new Array(t.channels).fill(0),n=e?e.points.length:t.size;if(0===n)throw new RangeError("Array of coordinates is empty.");if(e)for(const n of e.points)for(let e=0;e<t.channels;e++){if(n.column<0||n.column>=t.width||n.row<0||n.row>=t.height)throw new RangeError(`Invalid coordinate: {column: ${n.column}, row: ${n.row}}.`);r[e]+=t.getValueByPoint(n,e)}else for(let e=0;e<t.height;e++)for(let n=0;n<t.width;n++)for(let i=0;i<t.channels;i++)r[i]+=t.getValue(n,e,i);return r.map(t=>t/n)}function histogram$1(t,e={}){let{channel:r}=e;const{slots:n=2**t.bitDepth}=e;if(0===n||n&n-1)throw new RangeError("slots must be a power of 2, for example: 64, 256, 1024");if("number"!=typeof r){if(1!==t.channels)throw new TypeError("channel option is mandatory for multi-channel images");r=0}validateChannel(r,t);const i=new Uint32Array(n);let o=0;const s=Math.log2(n);o=t.bitDepth-s;for(let e=0;e<t.size;e++)i[t.getValueByIndex(e,r)>>o]++;return i}function median(t,e){const r=new Array(t.channels).fill(0);if(e){if(0===e.points.length)throw new RangeError("Array of coordinates is empty.");for(let n=0;n<t.channels;n++){const i=[];for(const r of e.points){if(r.column<0||r.column>=t.width||r.row<0||r.row>=t.height)throw new RangeError(`Invalid coordinate: {column: ${r.column}, row: ${r.row}}.`);i.push(t.getValueByPoint(r,n))}r[n]=quickMedian(i)}}else for(let e=0;e<t.channels;e++){const n=t.getChannel(e);r[e]=quickMedian(n)}return r}function getExtrema(t,e){const{kind:r="maximum",mask:n,algorithm:i="star",maxEquals:o=2}=e;checkProcessable$1(t,{bitDepth:[8,16]});const s="minimum"===r,a=s?0:1,l=[1,0,-1,0,1,1,-1,-1,2,0,-2,0,2,2,-2,-2],h=[0,1,0,-1,1,-1,1,-1,0,2,0,-2,2,-2,2,-2];switch(i){case"cross":l.length=4,h.length=4;break;case"square":l.length=8,h.length=8;break;case"star":break;default:assertUnreachable(i)}const c=l.length<=8?1:2,u=[];for(let e=0;e<t.channels;e++)for(let r=c;r<t.height-c;r++)for(let i=c;i<t.width-c;i++){if(n&&n.getBit(i,r)!==a)continue;let c=0,f=0;const d=t.getValue(i,r,e);for(let n=0;n<l.length;n++){const o=t.getValue(i+l[n],r+h[n],e);s?o>d&&c++:o<d&&c++,o===d&&f++}c+f===l.length&&f<=o&&u.push({column:i,row:r})}return u}function variance(t,e){const r=t.mean(e),n=new Array(t.channels).fill(0);if(e)for(const i of e.points)for(let e=0;e<t.channels;e++)n[e]+=(t.getValue(i.column,i.row,e)-r[e])**2;else for(let e=0;e<t.size;e++)for(let i=0;i<t.channels;i++)n[i]+=(t.getValueByIndex(e,i)-r[i])**2;const i=e?e.points.length*t.channels:t.size*t.channels;return n.map(t=>t/i)}class MultivariateLinearRegression{constructor(t,e,r={}){const{intercept:n=!0,statistics:i=!0}=r;if(this.statistics=i,!0===t)this.weights=e.weights,this.inputs=e.inputs,this.outputs=e.outputs,this.intercept=e.intercept;else{t=new Matrix(t),e=new Matrix(e),n&&t.addColumn(new Array(t.rows).fill(1));let r=t.transpose();const o=r.mmul(t),s=r.mmul(e),a=new SVD(o).inverse(),l=s.transpose().mmul(a).transpose();if(this.weights=l.to2DArray(),this.inputs=t.columns,this.outputs=e.columns,n&&this.inputs--,this.intercept=n,i){const r=t.mmul(l),n=e.clone().addM(r.neg()).to2DArray().map(t=>Math.pow(t[0],2)).reduce((t,e)=>t+e)/(e.rows-t.columns);this.stdError=Math.sqrt(n),this.stdErrorMatrix=pseudoInverse(o).mul(n),this.stdErrors=this.stdErrorMatrix.diagonal().map(t=>Math.sqrt(t)),this.tStats=this.weights.map((t,e)=>0===this.stdErrors[e]?0:t[0]/this.stdErrors[e])}}}predict(t){if(Array.isArray(t)){if("number"==typeof t[0])return this._predict(t);if(Array.isArray(t[0])){const e=new Array(t.length);for(let r=0;r<t.length;r++)e[r]=this._predict(t[r]);return e}}else if(Matrix.isMatrix(t)){const e=new Matrix(t.rows,this.outputs);for(let r=0;r<t.rows;r++)e.setRow(r,this._predict(t.getRow(r)));return e}throw new TypeError("x must be a matrix or array of numbers")}_predict(t){const e=new Array(this.outputs);if(this.intercept)for(let t=0;t<this.outputs;t++)e[t]=this.weights[this.inputs][t];else e.fill(0);for(let r=0;r<this.inputs;r++)for(let n=0;n<this.outputs;n++)e[n]+=this.weights[r][n]*t[r];return e}score(){throw new Error("score method is not implemented yet")}toJSON(){return{name:"multivariateLinearRegression",weights:this.weights,inputs:this.inputs,outputs:this.outputs,intercept:this.intercept,summary:this.statistics?{regressionStatistics:{standardError:this.stdError,observations:this.outputs},variables:this.weights.map((t,e)=>({label:e===this.weights.length-1?"Intercept":`X Variable ${e+1}`,coefficients:t,standardError:this.stdErrors[e],tStat:this.tStats[e]}))}:void 0}}static load(t){if("multivariateLinearRegression"!==t.name)throw new Error("not a MLR model");return new MultivariateLinearRegression(!0,t)}}var r$1={grad:.9,turn:360,rad:360/(2*Math.PI)},t$1=function(t){return"string"==typeof t?t.length>0:"number"==typeof t},n$1=function(t,e,r){return void 0===e&&(e=0),void 0===r&&(r=Math.pow(10,e)),Math.round(r*t)/r+0},e$1=function(t,e,r){return void 0===e&&(e=0),void 0===r&&(r=1),t>r?r:t>e?t:e},u$1=function(t){return(t=isFinite(t)?t%360:0)>0?t:t+360},a$1=function(t){return{r:e$1(t.r,0,255),g:e$1(t.g,0,255),b:e$1(t.b,0,255),a:e$1(t.a)}},o$1=function(t){return{r:n$1(t.r),g:n$1(t.g),b:n$1(t.b),a:n$1(t.a,3)}},i$1=/^#([0-9a-f]{3,8})$/i,s=function(t){var e=t.toString(16);return e.length<2?"0"+e:e},h$1=function(t){var e=t.r,r=t.g,n=t.b,i=t.a,o=Math.max(e,r,n),s=o-Math.min(e,r,n),a=s?o===e?(r-n)/s:o===r?2+(n-e)/s:4+(e-r)/s:0;return{h:60*(a<0?a+6:a),s:o?s/o*100:0,v:o/255*100,a:i}},b$1=function(t){var e=t.h,r=t.s,n=t.v,i=t.a;e=e/360*6,r/=100,n/=100;var o=Math.floor(e),s=n*(1-r),a=n*(1-(e-o)*r),l=n*(1-(1-e+o)*r),h=o%6;return{r:255*[n,a,s,s,l,n][h],g:255*[l,n,n,a,s,s][h],b:255*[s,s,l,n,n,a][h],a:i}},g=function(t){return{h:u$1(t.h),s:e$1(t.s,0,100),l:e$1(t.l,0,100),a:e$1(t.a)}},d=function(t){return{h:n$1(t.h),s:n$1(t.s),l:n$1(t.l),a:n$1(t.a,3)}},f=function(t){return b$1((r=(e=t).s,{h:e.h,s:(r*=((n=e.l)<50?n:100-n)/100)>0?2*r/(n+r)*100:0,v:n+r,a:e.a}));var e,r,n},c=function(t){return{h:(e=h$1(t)).h,s:(i=(200-(r=e.s))*(n=e.v)/100)>0&&i<200?r*n/100/(i<=100?i:200-i)*100:0,l:i/2,a:e.a};var e,r,n,i},l$1=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s*,\s*([+-]?\d*\.?\d+)%\s*,\s*([+-]?\d*\.?\d+)%\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,p$1=/^hsla?\(\s*([+-]?\d*\.?\d+)(deg|rad|grad|turn)?\s+([+-]?\d*\.?\d+)%\s+([+-]?\d*\.?\d+)%\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,v=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*,\s*([+-]?\d*\.?\d+)(%)?\s*(?:,\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,m=/^rgba?\(\s*([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s+([+-]?\d*\.?\d+)(%)?\s*(?:\/\s*([+-]?\d*\.?\d+)(%)?\s*)?\)$/i,y={string:[[function(t){var e=i$1.exec(t);return e?(t=e[1]).length<=4?{r:parseInt(t[0]+t[0],16),g:parseInt(t[1]+t[1],16),b:parseInt(t[2]+t[2],16),a:4===t.length?n$1(parseInt(t[3]+t[3],16)/255,2):1}:6===t.length||8===t.length?{r:parseInt(t.substr(0,2),16),g:parseInt(t.substr(2,2),16),b:parseInt(t.substr(4,2),16),a:8===t.length?n$1(parseInt(t.substr(6,2),16)/255,2):1}:null:null},"hex"],[function(t){var e=v.exec(t)||m.exec(t);return e?e[2]!==e[4]||e[4]!==e[6]?null:a$1({r:Number(e[1])/(e[2]?100/255:1),g:Number(e[3])/(e[4]?100/255:1),b:Number(e[5])/(e[6]?100/255:1),a:void 0===e[7]?1:Number(e[7])/(e[8]?100:1)}):null},"rgb"],[function(t){var e=l$1.exec(t)||p$1.exec(t);if(!e)return null;var r,n,i=g({h:(r=e[1],n=e[2],void 0===n&&(n="deg"),Number(r)*(r$1[n]||1)),s:Number(e[3]),l:Number(e[4]),a:void 0===e[5]?1:Number(e[5])/(e[6]?100:1)});return f(i)},"hsl"]],object:[[function(t){var e=t.r,r=t.g,n=t.b,i=t.a,o=void 0===i?1:i;return t$1(e)&&t$1(r)&&t$1(n)?a$1({r:Number(e),g:Number(r),b:Number(n),a:Number(o)}):null},"rgb"],[function(t){var e=t.h,r=t.s,n=t.l,i=t.a,o=void 0===i?1:i;if(!t$1(e)||!t$1(r)||!t$1(n))return null;var s=g({h:Number(e),s:Number(r),l:Number(n),a:Number(o)});return f(s)},"hsl"],[function(t){var e=t.h,r=t.s,n=t.v,i=t.a,o=void 0===i?1:i;if(!t$1(e)||!t$1(r)||!t$1(n))return null;var s=function(t){return{h:u$1(t.h),s:e$1(t.s,0,100),v:e$1(t.v,0,100),a:e$1(t.a)}}({h:Number(e),s:Number(r),v:Number(n),a:Number(o)});return b$1(s)},"hsv"]]},N=function(t,e){for(var r=0;r<e.length;r++){var n=e[r][0](t);if(n)return[n,e[r][1]]}return[null,void 0]},x=function(t){return"string"==typeof t?N(t.trim(),y.string):"object"==typeof t&&null!==t?N(t,y.object):[null,void 0]},M$1=function(t,e){var r=c(t);return{h:r.h,s:e$1(r.s+100*e,0,100),l:r.l,a:r.a}},H=function(t){return(299*t.r+587*t.g+114*t.b)/1e3/255},$=function(t,e){var r=c(t);return{h:r.h,s:r.s,l:e$1(r.l+100*e,0,100),a:r.a}},j=function(){function t(t){this.parsed=x(t)[0],this.rgba=this.parsed||{r:0,g:0,b:0,a:1}}return t.prototype.isValid=function(){return null!==this.parsed},t.prototype.brightness=function(){return n$1(H(this.rgba),2)},t.prototype.isDark=function(){return H(this.rgba)<.5},t.prototype.isLight=function(){return H(this.rgba)>=.5},t.prototype.toHex=function(){return e=(t=o$1(this.rgba)).r,r=t.g,n=t.b,o=(i=t.a)<1?s(n$1(255*i)):"","#"+s(e)+s(r)+s(n)+o;var t,e,r,n,i,o},t.prototype.toRgb=function(){return o$1(this.rgba)},t.prototype.toRgbString=function(){return e=(t=o$1(this.rgba)).r,r=t.g,n=t.b,(i=t.a)<1?"rgba("+e+", "+r+", "+n+", "+i+")":"rgb("+e+", "+r+", "+n+")";var t,e,r,n,i},t.prototype.toHsl=function(){return d(c(this.rgba))},t.prototype.toHslString=function(){return e=(t=d(c(this.rgba))).h,r=t.s,n=t.l,(i=t.a)<1?"hsla("+e+", "+r+"%, "+n+"%, "+i+")":"hsl("+e+", "+r+"%, "+n+"%)";var t,e,r,n,i},t.prototype.toHsv=function(){return t=h$1(this.rgba),{h:n$1(t.h),s:n$1(t.s),v:n$1(t.v),a:n$1(t.a,3)};var t},t.prototype.invert=function(){return w$1({r:255-(t=this.rgba).r,g:255-t.g,b:255-t.b,a:t.a});var t},t.prototype.saturate=function(t){return void 0===t&&(t=.1),w$1(M$1(this.rgba,t))},t.prototype.desaturate=function(t){return void 0===t&&(t=.1),w$1(M$1(this.rgba,-t))},t.prototype.grayscale=function(){return w$1(M$1(this.rgba,-1))},t.prototype.lighten=function(t){return void 0===t&&(t=.1),w$1($(this.rgba,t))},t.prototype.darken=function(t){return void 0===t&&(t=.1),w$1($(this.rgba,-t))},t.prototype.rotate=function(t){return void 0===t&&(t=15),this.hue(this.hue()+t)},t.prototype.alpha=function(t){return"number"==typeof t?w$1({r:(e=this.rgba).r,g:e.g,b:e.b,a:t}):n$1(this.rgba.a,3);var e},t.prototype.hue=function(t){var e=c(this.rgba);return"number"==typeof t?w$1({h:t,s:e.s,l:e.l,a:e.a}):n$1(e.h)},t.prototype.isEqual=function(t){return this.toHex()===w$1(t).toHex()},t}(),w$1=function(t){return t instanceof j?t:new j(t)},S=[],k=function(t){t.forEach(function(t){S.indexOf(t)<0&&(t(j,y),S.push(t))})},a=function(t){return"string"==typeof t?t.length>0:"number"==typeof t},t=function(t,e,r){return void 0===e&&(e=0),void 0===r&&(r=Math.pow(10,e)),Math.round(r*t)/r+0},o=function(t,e,r){return void 0===e&&(e=0),void 0===r&&(r=1),t>r?r:t>e?t:e},r=function(t){var e=t/255;return e<.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)},h=function(t){return 255*(t>.0031308?1.055*Math.pow(t,1/2.4)-.055:12.92*t)},n=96.422,p=100,M=82.521,u=function(t){var e,r,n=.9555766*(e=t).x+-.0230393*e.y+.0631636*e.z,i=-.0282895*e.x+1.0099416*e.y+.0210077*e.z,s=.0122982*e.x+-.020483*e.y+1.3299098*e.z;return r={r:h(.032404542*n-.015371385*i-.004985314*s),g:h(-.00969266*n+.018760108*i+41556e-8*s),b:h(556434e-9*n-.002040259*i+.010572252*s),a:t.a},{r:o(r.r,0,255),g:o(r.g,0,255),b:o(r.b,0,255),a:o(r.a)}},e=function(t){var e=r(t.r),i=r(t.g),s=r(t.b);return function(t){return{x:o(t.x,0,n),y:o(t.y,0,p),z:o(t.z,0,M),a:o(t.a)}}(function(t){return{x:1.0478112*t.x+.0228866*t.y+-.050127*t.z,y:.0295424*t.x+.9904844*t.y+-.0170491*t.z,z:-.0092345*t.x+.0150436*t.y+.7521316*t.z,a:t.a}}({x:100*(.4124564*e+.3575761*i+.1804375*s),y:100*(.2126729*e+.7151522*i+.072175*s),z:100*(.0193339*e+.119192*i+.9503041*s),a:t.a}))},w=216/24389,b=24389/27,i=function(t){var e=t.l,r=t.a,n=t.b,i=t.alpha,s=void 0===i?1:i;if(!a(e)||!a(r)||!a(n))return null;var h=function(t){return{l:o(t.l,0,400),a:t.a,b:t.b,alpha:o(t.alpha)}}({l:Number(e),a:Number(r),b:Number(n),alpha:Number(s)});return l(h)},l=function(t){var e=(t.l+16)/116,r=t.a/500+e,i=e-t.b/200;return u({x:(Math.pow(r,3)>w?Math.pow(r,3):(116*r-16)/b)*n,y:(t.l>8?Math.pow((t.l+16)/116,3):t.l/b)*p,z:(Math.pow(i,3)>w?Math.pow(i,3):(116*i-16)/b)*M,a:t.alpha})};function labPlugin(r,s){r.prototype.toLab=function(){return s=(i=e(this.rgba)).y/p,a=i.z/M,o=(o=i.x/n)>w?Math.cbrt(o):(b*o+16)/116,r={l:116*(s=s>w?Math.cbrt(s):(b*s+16)/116)-16,a:500*(o-s),b:200*(s-(a=a>w?Math.cbrt(a):(b*a+16)/116)),alpha:i.a},{l:t(r.l,2),a:t(r.a,2),b:t(r.b,2),alpha:t(r.alpha,3)};var r,i,o,s,a},r.prototype.delta=function(e){void 0===e&&(e="#FFF");var n=e instanceof r?e:new r(e),i=function(t,e){var r=t.l,n=t.a,i=t.b,o=e.l,s=e.a,a=e.b,l=180/Math.PI,h=Math.PI/180,c=Math.pow(Math.pow(n,2)+Math.pow(i,2),.5),u=Math.pow(Math.pow(s,2)+Math.pow(a,2),.5),f=(r+o)/2,d=Math.pow((c+u)/2,7),m=.5*(1-Math.pow(d/(d+Math.pow(25,7)),.5)),g=n*(1+m),p=s*(1+m),w=Math.pow(Math.pow(g,2)+Math.pow(i,2),.5),b=Math.pow(Math.pow(p,2)+Math.pow(a,2),.5),_=(w+b)/2,y=0===g&&0===i?0:Math.atan2(i,g)*l,x=0===p&&0===a?0:Math.atan2(a,p)*l;y<0&&(y+=360),x<0&&(x+=360);var M=x-y,E=Math.abs(x-y);E>180&&x<=y?M+=360:E>180&&x>y&&(M-=360);var v=y+x;E<=180?v/=2:v=(y+x<360?v+360:v-360)/2;var I=1-.17*Math.cos(h*(v-30))+.24*Math.cos(2*h*v)+.32*Math.cos(h*(3*v+6))-.2*Math.cos(h*(4*v-63)),A=o-r,S=b-w,R=2*Math.sin(h*M/2)*Math.pow(w*b,.5),k=1+.015*Math.pow(f-50,2)/Math.pow(20+Math.pow(f-50,2),.5),T=1+.045*_,$=1+.015*_*I,C=30*Math.exp(-1*Math.pow((v-275)/25,2)),D=-2*Math.pow(d/(d+Math.pow(25,7)),.5)*Math.sin(2*h*C);return Math.pow(Math.pow(A/1/k,2)+Math.pow(S/1/T,2)+Math.pow(R/1/$,2)+D*S*R/(1*T*1*$),.5)}(this.toLab(),n.toLab())/100;return o(t(i,3))},s.object.push([i,"lab"])}function formatReferenceForMlr(t,e){const r={r:[],g:[],b:[]};for(const n of t)r.r.push([n.r/e]),r.g.push([n.g/e]),r.b.push([n.b/e]);return r}function formatInputForMlr(t,e){const r=[];for(const n of t)r.push(getRegressionVariables(n.r,n.g,n.b,e));return r}function correctColor(t,e,r){if(checkProcessable$1(t,{colorModel:["RGB","RGBA"]}),e.length!==r.length)throw new RangeError("number of measured colors and reference colors must be the same");const n=formatInputForMlr(e,t.maxValue),i=formatReferenceForMlr(r,t.maxValue),o=new MultivariateLinearRegression(n,i.r),s=new MultivariateLinearRegression(n,i.g),a=new MultivariateLinearRegression(n,i.b),l=Image.createFrom(t);for(let e=0;e<t.height;e++)for(let r=0;r<t.width;r++){const n=t.getPixel(r,e),i=getRegressionVariables(n[0],n[1],n[2],t.maxValue),h=getClamp(t),c=[0,0,0],u=o.predict(i)[0]*t.maxValue,f=s.predict(i)[0]*t.maxValue,d=a.predict(i)[0]*t.maxValue;c[0]=h(u),c[1]=h(f),c[2]=h(d),t.alpha&&(c[3]=t.getValue(r,e,3)),l.setPixel(r,e,c)}return l}function getRegressionVariables(t,e,r,n){return[t/=n,e/=n,r/=n,t**2,e**2,r**2,t**3,e**3,r**3,t*e,t*r,r*e]}function getMinMax(t){const e=new Array(t.channels).fill(t.maxValue),r=new Array(t.channels).fill(0);for(let n=0;n<t.height;n++)for(let i=0;i<t.width;i++)for(let o=0;o<t.channels;o++){const s=t.getValue(i,n,o);s<e[o]&&(e[o]=s),s>r[o]&&(r[o]=s)}return{min:e,max:r}}k([labPlugin]);const ImageCoordinates={CENTER:"center",TOP_LEFT:"top-left",TOP_RIGHT:"top-right",BOTTOM_LEFT:"bottom-left",BOTTOM_RIGHT:"bottom-right"};class Image{width;height;size;bitDepth;colorModel;components;channels;alpha;maxValue;origin;originalResolution;meta;data;constructor(t,e,r={}){const{bitDepth:n=8,data:i,colorModel:o="RGB",origin:s={row:0,column:0},meta:a,resolution:l}=r;if(t<1||!Number.isInteger(t))throw new RangeError(`width must be an integer and at least 1. Received ${t}`);if(e<1||!Number.isInteger(e))throw new RangeError(`height must be an integer and at least 1. Received ${e}`);this.width=t,this.height=e,this.size=t*e,this.bitDepth=n,this.colorModel=o,this.origin=s,this.meta=a,this.originalResolution=l;const h=colorModels[o];if(this.components=h.components,this.alpha=h.alpha,this.channels=h.channels,this.maxValue=2**n-1,void 0===i)this.data=createPixelArray(this.size,this.channels,this.alpha,this.bitDepth,this.maxValue);else{if(8===n&&i instanceof Uint16Array)throw new RangeError(`bitDepth is ${n} but data is Uint16Array`);if(16===n&&i instanceof Uint8Array)throw new RangeError(`bitDepth is ${n} but data is Uint8Array`);const t=this.size*this.channels;if(i.length!==t)throw new RangeError(`incorrect data size: ${i.length}. Expected ${t}`);this.data=i}}get normalizedResolution(){if(!this.originalResolution)return;switch(this.originalResolution.unit){case"inch":return{x:this.originalResolution.x/2.54,y:this.originalResolution.y/2.54};case"centimeter":return{x:this.originalResolution.x,y:this.originalResolution.y};case"meter":return{x:this.originalResolution.x/100,y:this.originalResolution.y/100};case"unknown":return null;default:throw new Error("Unknown resolution unit.")}}static createFrom(t,e={}){const{width:r=t.width,height:n=t.height}=e;let i;return i=t instanceof Image?t.bitDepth:8,new Image(r,n,{bitDepth:i,colorModel:t.colorModel,origin:t.origin,...e})}getPixel(t,e){const r=[],n=(e*this.width+t)*this.channels;for(let t=0;t<this.channels;t++)r.push(this.data[n+t]);return r}getColumn(t){const e=[];for(let r=0;r<this.channels;r++){const n=[];for(let e=0;e<this.height;e++)n.push(this.getValue(t,e,r));e.push(n)}return e}getRow(t){const e=[];for(let r=0;r<this.channels;r++){const n=[];for(let e=0;e<this.width;e++)n.push(this.getValue(e,t,r));e.push(n)}return e}setPixel(t,e,r){const n=(e*this.width+t)*this.channels;for(let t=0;t<this.channels;t++)this.data[n+t]=r[t]}setVisiblePixel(t,e,r){t>=0&&t<this.width&&e>=0&&e<this.height&&this.setPixel(t,e,r)}getPixelByIndex(t){const e=[],r=t*this.channels;for(let t=0;t<this.channels;t++)e.push(this.data[r+t]);return e}setPixelByIndex(t,e){const r=t*this.channels;for(let t=0;t<this.channels;t++)this.data[r+t]=e[t]}getValue(t,e,r){return this.data[(e*this.width+t)*this.channels+r]}setValue(t,e,r,n){this.data[(e*this.width+t)*this.channels+r]=n}setClampedValue(t,e,r,n){n<0?n=0:n>this.maxValue&&(n=this.maxValue),this.data[(e*this.width+t)*this.channels+r]=n}getValueByIndex(t,e){return this.data[t*this.channels+e]}setValueByIndex(t,e,r){this.data[t*this.channels+e]=r}setClampedValueByIndex(t,e,r){r<0?r=0:r>this.maxValue&&(r=this.maxValue),this.data[t*this.channels+e]=r}getValueByPoint(t,e){return this.getValue(t.column,t.row,e)}setValueByPoint(t,e,r){this.setValue(t.column,t.row,e,r)}minMax(){return getMinMax(this)}getRawImage(){return{width:this.width,height:this.height,data:this.data,channels:this.channels,bitDepth:this.bitDepth}}[Symbol.for("nodejs.util.inspect.custom")](){let t;return t=this.height>20||this.width>20?"[...]":printData(this),`Image {\n  width: ${this.width}\n  height: ${this.height}\n  bitDepth: ${this.bitDepth}\n  colorModel: ${this.colorModel}\n  channels: ${this.channels}\n  data: ${t}\n}`}fill(t){if("number"==typeof t)return validateValue(t,this),this.data.fill(t),this;if(t.length!==this.channels)throw new RangeError(`the size of value must match the number of channels (${this.channels}). Received ${t.length}`);for(const e of t)validateValue(e,this);for(let e=0;e<this.data.length;e+=this.channels)for(let r=0;r<=this.channels;r++)this.data[e+r]=t[r];return this}fillChannel(t,e){validateChannel(t,this),validateValue(e,this);for(let r=t;r<this.data.length;r+=this.channels)this.data[r]=e;return this}getChannel(t){validateChannel(t,this);const e=new Array(this.size);for(let r=0;r<this.size;r++)e[r]=this.data[t+r*this.channels];return e}fillAlpha(t){if(validateValue(t,this),!this.alpha)throw new TypeError("fillAlpha can only be called if the image has an alpha channel");const e=this.channels-1;return this.fillChannel(e,t)}clone(){return Image.createFrom(this,{data:this.data.slice()})}changeEach(t){for(let e=0;e<this.data.length;e++)this.data[e]=t(this.data[e])}getCoordinates(t,e=!1){return M$2(t).with("center",()=>{const t=(this.width-1)/2,r=(this.height-1)/2;return e?{column:Math.round(t),row:Math.round(r)}:{column:t,row:r}}).with("top-left",()=>({column:0,row:0})).with("top-right",()=>({column:this.width-1,row:0})).with("bottom-left",()=>({column:0,row:this.height-1})).with("bottom-right",()=>({column:this.width-1,row:this.height-1})).exhaustive()}subtract(t,e={}){return subtract(this,t,e)}add(t){return add(this,t)}multiply(t,e={}){return multiply(this,t,e)}divide(t,e={}){return divide(this,t,e)}histogram(t){return histogram$1(this,t)}mean(t){return mean(this,t)}median(t){return median(this,t)}variance(t){return variance(this,t)}drawPoints(t,e={}){return drawPoints(this,t,e)}drawLine(t,e,r={}){return drawLineOnImage(this,t,e,r)}drawRectangle(t={}){return drawRectangle(this,t)}drawPolyline(t,e={}){return drawPolylineOnImage(this,t,e)}drawPolygon(t,e={}){return drawPolygonOnImage(this,t,e)}drawCircle(t,e,r={}){return drawCircleOnImage(this,t,e,r)}drawMarker(t,e={}){return drawMarker(this,t,e)}drawMarkers(t,e={}){return drawMarkers(this,t,e)}split(){return split(this)}convertColor(t,e){return convertColor(this,t,e)}convertBitDepth(t,e){return convertBitDepth(this,t,e)}grey(t){return grey(this,t)}copyTo(t,e={}){return copyTo(this,t,e)}threshold(t={}){return threshold(this,t)}crop(t){return crop(this,t)}cropRectangle(t,e){return cropRectangle(this,t,e)}cropAlpha(t={}){return cropAlpha(this,t)}extract(t,e){return extract(this,t,e)}paintMask(t,e){return paintMaskOnImage(this,t,e)}blur(t){return blur(this,t)}pixelate(t){return pixelate(this,t)}directConvolution(t,e){return directConvolution(this,t,e)}rawDirectConvolution(t,e){return rawDirectConvolution(this,t,e)}separableConvolution(t,e,r){return separableConvolution(this,t,e,r)}gaussianBlur(t){return gaussianBlur(this,t)}flip(t){return flip(this,t)}invert(t){return invert(this,t)}hypotenuse(t,e){return hypotenuse(this,t,e)}gradientFilter(t){return gradientFilter(this,t)}derivativeFilter(t){return derivativeFilter(this,t)}level(t){return level(this,t)}increaseContrast(t={}){return increaseContrast(this,t)}correctColor(t,e){return correctColor(this,t,e)}medianFilter(t){return medianFilter(this,t)}resize(t){return resize(this,t)}rotate(t){return rotate(this,t)}transform(t,e){return transform(this,t,e)}transformRotate(t,e){return transformRotate(this,t,e)}erode(t){return erode(this,t)}dilate(t){return dilate(this,t)}open(t){return open(this,t)}close(t){return close(this,t)}topHat(t){return topHat(this,t)}bottomHat(t){return bottomHat(this,t)}morphologicalGradient(t){return morphologicalGradient(this,t)}cannyEdgeDetector(t){return cannyEdgeDetector(this,t)}}function createPixelArray(t,e,r,n,i){const o=e*t,s=M$2(n).with(8,()=>new Uint8Array(o)).with(16,()=>new Uint16Array(o)).otherwise(()=>{throw new RangeError(`invalid bitDepth: ${n}`)});if(r)for(let t=e-1;t<o;t+=e)s[t]=i;return s}function printData(t){const e=[],r=8===t.bitDepth?3:5;for(let n=0;n<t.height;n++){const i=[];for(let e=0;e<t.width;e++)for(let o=0;o<t.channels;o++)i.push(String(t.getValue(e,n,o)).padStart(r," "));e.push(`[${i.join(" ")}]`)}return`{\n    [\n     ${e.join("\n     ")}\n    ]\n  }`}function copyData(t,e){if(e.width!==t.width||e.height!==t.height||e.colorModel!==t.colorModel)throw new RangeError("images width, height or color model is different");e.data=t.data.slice()}function getOutputImage(t,e={},r={}){const{out:n}=e,{newParameters:i,clone:o}=r;if(void 0===n)return o?t.clone():Image.createFrom(t,i);if(!(n instanceof Image))throw new TypeError("out must be an Image");return checkRequirements({width:t.width,height:t.height,bitDepth:t.bitDepth,colorModel:t.colorModel,...i},n),o&&t!==n&&copyData(t,n),n}function maskToOutputImage(t,e={}){const{out:r}=e;if(void 0===r)return Image.createFrom(t,{colorModel:"GREY"});if(!(r instanceof Image))throw new TypeError("out must be an Image");return checkRequirements({width:t.width,height:t.height,bitDepth:8,colorModel:"GREY"},r),r}function imageToOutputMask(t,e={}){const{out:r}=e;if(void 0===r)return Mask.createFrom(t);if(!(r instanceof Mask))throw new TypeError("out must be a Mask");return checkRequirements({width:t.width,height:t.height,bitDepth:1,colorModel:"BINARY"},r),r}function checkRequirements(t,e){for(const r in t){const n=r;if(e[n]!==t[n])throw new RangeError(`cannot use out image. Its ${r} property must be ${t[n]}. Received ${e[n]}`)}}function maskToOutputMask(t,e={},r={}){const{out:n}=e,{newParameters:i,clone:o}=r;if(void 0===n)return o?t.clone():Mask.createFrom(t,i);if(!(n instanceof Mask))throw new TypeError("out must be a Mask");return checkRequirements({width:t.width,height:t.height,bitDepth:1,colorModel:"BINARY"},n),o&&t!==n&&copyData(t,n),n}function getColors(t,e,r={}){const{nbShades:n=6,minValueFactor:i=.2}=r,o=Math.max(...e),s=o*i,a=Math.floor((o-s)/(n-1)),l=getClampFromTo(0,t.maxValue),h=[];for(let t=0;t<n;t++){const r=[];for(const n of e)r.push(l(n-t*a));h.push(r)}return h}function getKeypointColor(t,e,r){const n=t[0].score,i=t.at(-1).score;if(i===n)return r[0];const o=t[e].score;return r[r.length-1-Math.floor((r.length-1)*(o-i)/(n-i))]}function drawKeypoints(t,e,r={}){const{markerSize:n=10,fill:i=!1,showScore:o=!1,origin:s={row:0,column:0},showScoreOptions:a}=r;let{maxNbKeypoints:l=e.length}=r;const{strokeColor:h=[255,0,0]}=r;l>e.length&&(l=e.length);let c=getOutputImage(t,r,{clone:!0});"RGB"!==t.colorModel&&(c=c.convertColor("RGB"));const u=getColors(t,h,a),f=Math.ceil(n/2);for(let t=0;t<l;t++){const n=e[t];let a=h;o&&(a=getKeypointColor(e,t,u));const l=i?a:void 0,d=sum$1(n.origin,s);if(c.drawCircle(d,f,{fillColor:l,strokeColor:a,out:c}),isOrientedFastKeypoint(n)&&r.showOrientation){const t=d,e=n.angle*Math.PI/180,r={column:t.column+Math.round(f*Math.cos(e)),row:t.row-Math.round(f*Math.sin(e))};c.drawLine(t,r,{strokeColor:a,out:c})}}return c}function isOrientedFastKeypoint(t){return"angle"in t&&"number"==typeof t.angle}function getMatchColor(t,e,r){const n=t.at(-1).distance,i=t[0].distance;if(i===n)return r[0];const o=t[e].distance;return r[Math.floor((r.length-1)*(o-i)/(n-i))]}function sortByDistance(t){const e=t.slice();return e.sort((t,e)=>t.distance-e.distance),e}function scaleKeypoints(t,e){return 1===e?t.slice():t.map(t=>({origin:{row:t.origin.row*e,column:t.origin.column*e},score:t.score}))}function drawMatches(t,e,r,n,i={}){const{circleDiameter:o=10,strokeColor:s=[255,0,0],showDistance:a=!1,showDistanceOptions:l}=i;let{maxNbMatches:h=e.length}=i;h>e.length&&(h=e.length);const c=scaleKeypoints(r,t.scale),u=scaleKeypoints(n,t.scale),f=t.image,d=getColors(f,s,l),m=Math.ceil(o/2),g=sortByDistance(e);for(let r=0;r<h;r++){let n=s;a&&(n=getMatchColor(g,r,d));const i=c[e[r].sourceIndex].origin;f.drawCircle(i,m,{strokeColor:n,out:f});const o=u[e[r].destinationIndex].origin,l={column:o.column+t.destinationOrigin.column,row:o.row+t.destinationOrigin.row};f.drawCircle(l,m,{strokeColor:n,out:f}),f.drawLine(i,l,{out:f,strokeColor:n})}return f}const MontageDisposition={HORIZONTAL:"horizontal",VERTICAL:"vertical"};class Montage{sourceWidth;sourceHeight;destinationWidth;destinationHeight;destinationOrigin;width;height;scale;disposition;image;constructor(t,e,r={}){const{scale:n=1,disposition:i="horizontal"}=r;if(!Number.isInteger(n))throw new TypeError("scale must be an integer");if(this.scale=n,this.disposition=i,this.sourceWidth=n*t.width,this.destinationWidth=n*e.width,this.sourceHeight=n*t.height,this.destinationHeight=n*e.height,"horizontal"===i)this.destinationOrigin={row:0,column:this.sourceWidth},this.width=this.sourceWidth+this.destinationWidth,this.height=Math.max(this.sourceHeight,this.destinationHeight);else{if("vertical"!==i)throw new RangeError(`invalid disposition type: ${i}`);this.destinationOrigin={row:this.sourceHeight,column:0},this.width=Math.max(this.sourceWidth,this.destinationWidth),this.height=this.sourceHeight+this.destinationHeight}"RGB"!==t.colorModel&&(t=t.convertColor("RGB")),"RGB"!==e.colorModel&&(e=e.convertColor("RGB"));const o=new Image(this.width,this.height);t.resize({xFactor:n,yFactor:n}).copyTo(o,{out:o}),e.resize({xFactor:n,yFactor:n}).copyTo(o,{out:o,origin:this.destinationOrigin}),this.image=o}drawKeypoints(t,e={}){const r=scaleKeypoints(t,this.scale);this.image=drawKeypoints(this.image,r,e)}drawMatches(t,e,r,n={}){this.image=drawMatches(this,t,e,r,n)}}function overlapImages(t,e,r={}){const{origin:n={row:0,column:0},angle:i=0,scale:o=1}=r;if(0===o)throw new Error("Scale cannot be 0");t.colorModel!==ImageColorModel.GREY&&(t=t.grey()),e.colorModel!==ImageColorModel.GREY&&(e=e.grey());const s=t.invert(),a=e.invert(),l=s.transformRotate(i,{center:ImageCoordinates.TOP_LEFT}).resize({xFactor:o,yFactor:o}),h=Image.createFrom(a);return merge([l.copyTo(h,{origin:n}),a,h])}function filterEuclideanDistance(t,e,r,n={}){const{origin:i={column:0,row:0}}=n,o=t.slice();o.sort((t,e)=>t.destinationIndex-e.destinationIndex);const s=[];let a=[],l=o[0].destinationIndex;for(const t of o)t.destinationIndex===l?a.push(t):(a.sort((t,e)=>h(t)-h(e)),s.push(...a.slice(0,1)),l=t.destinationIndex,a=[t]);return a.sort((t,e)=>h(t)-h(e)),s.push(...a.slice(0,1)),s;function h(t){return(e[t.sourceIndex].origin.row-(r[t.destinationIndex].origin.row-i.row))**2+(e[t.sourceIndex].origin.column-r[t.destinationIndex].origin.column-i.column)**2}}function decode$4(t,e="utf8"){return new TextDecoder(e).decode(t)}const encoder$1=new TextEncoder;function encode$3(t){return encoder$1.encode(t)}const defaultByteLength=8192,hostBigEndian=(()=>{const t=new Uint8Array(4);return!((new Uint32Array(t.buffer)[0]=1)&t[0])})(),typedArrays={int8:globalThis.Int8Array,uint8:globalThis.Uint8Array,int16:globalThis.Int16Array,uint16:globalThis.Uint16Array,int32:globalThis.Int32Array,uint32:globalThis.Uint32Array,uint64:globalThis.BigUint64Array,int64:globalThis.BigInt64Array,float32:globalThis.Float32Array,float64:globalThis.Float64Array};class IOBuffer{buffer;byteLength;byteOffset;length;offset;lastWrittenByte;littleEndian;_data;_mark;_marks;constructor(t=defaultByteLength,e={}){let r=!1;"number"==typeof t?t=new ArrayBuffer(t):(r=!0,this.lastWrittenByte=t.byteLength);const n=e.offset?e.offset>>>0:0,i=t.byteLength-n;let o=n;(ArrayBuffer.isView(t)||t instanceof IOBuffer)&&(t.byteLength!==t.buffer.byteLength&&(o=t.byteOffset+n),t=t.buffer),this.lastWrittenByte=r?i:0,this.buffer=t,this.length=i,this.byteLength=i,this.byteOffset=o,this.offset=0,this.littleEndian=!0,this._data=new DataView(this.buffer,o,i),this._mark=0,this._marks=[]}available(t=1){return this.offset+t<=this.length}isLittleEndian(){return this.littleEndian}setLittleEndian(){return this.littleEndian=!0,this}isBigEndian(){return!this.littleEndian}setBigEndian(){return this.littleEndian=!1,this}skip(t=1){return this.offset+=t,this}back(t=1){return this.offset-=t,this}seek(t){return this.offset=t,this}mark(){return this._mark=this.offset,this}reset(){return this.offset=this._mark,this}pushMark(){return this._marks.push(this.offset),this}popMark(){const t=this._marks.pop();if(void 0===t)throw new Error("Mark stack empty");return this.seek(t),this}rewind(){return this.offset=0,this}ensureAvailable(t=1){if(!this.available(t)){const e=2*(this.offset+t),r=new Uint8Array(e);r.set(new Uint8Array(this.buffer)),this.buffer=r.buffer,this.length=e,this.byteLength=e,this._data=new DataView(this.buffer)}return this}readBoolean(){return 0!==this.readUint8()}readInt8(){return this._data.getInt8(this.offset++)}readUint8(){return this._data.getUint8(this.offset++)}readByte(){return this.readUint8()}readBytes(t=1){return this.readArray(t,"uint8")}readArray(t,e){const r=typedArrays[e].BYTES_PER_ELEMENT*t,n=this.byteOffset+this.offset,i=this.buffer.slice(n,n+r);if(this.littleEndian===hostBigEndian&&"uint8"!==e&&"int8"!==e){const t=new Uint8Array(this.buffer.slice(n,n+r));t.reverse();const i=new typedArrays[e](t.buffer);return this.offset+=r,i.reverse(),i}const o=new typedArrays[e](i);return this.offset+=r,o}readInt16(){const t=this._data.getInt16(this.offset,this.littleEndian);return this.offset+=2,t}readUint16(){const t=this._data.getUint16(this.offset,this.littleEndian);return this.offset+=2,t}readInt32(){const t=this._data.getInt32(this.offset,this.littleEndian);return this.offset+=4,t}readUint32(){const t=this._data.getUint32(this.offset,this.littleEndian);return this.offset+=4,t}readFloat32(){const t=this._data.getFloat32(this.offset,this.littleEndian);return this.offset+=4,t}readFloat64(){const t=this._data.getFloat64(this.offset,this.littleEndian);return this.offset+=8,t}readBigInt64(){const t=this._data.getBigInt64(this.offset,this.littleEndian);return this.offset+=8,t}readBigUint64(){const t=this._data.getBigUint64(this.offset,this.littleEndian);return this.offset+=8,t}readChar(){return String.fromCharCode(this.readInt8())}readChars(t=1){let e="";for(let r=0;r<t;r++)e+=this.readChar();return e}readUtf8(t=1){return decode$4(this.readBytes(t))}decodeText(t=1,e="utf8"){return decode$4(this.readBytes(t),e)}writeBoolean(t){return this.writeUint8(t?255:0),this}writeInt8(t){return this.ensureAvailable(1),this._data.setInt8(this.offset++,t),this._updateLastWrittenByte(),this}writeUint8(t){return this.ensureAvailable(1),this._data.setUint8(this.offset++,t),this._updateLastWrittenByte(),this}writeByte(t){return this.writeUint8(t)}writeBytes(t){this.ensureAvailable(t.length);for(let e=0;e<t.length;e++)this._data.setUint8(this.offset++,t[e]);return this._updateLastWrittenByte(),this}writeInt16(t){return this.ensureAvailable(2),this._data.setInt16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this}writeUint16(t){return this.ensureAvailable(2),this._data.setUint16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this}writeInt32(t){return this.ensureAvailable(4),this._data.setInt32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this}writeUint32(t){return this.ensureAvailable(4),this._data.setUint32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this}writeFloat32(t){return this.ensureAvailable(4),this._data.setFloat32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this}writeFloat64(t){return this.ensureAvailable(8),this._data.setFloat64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this}writeBigInt64(t){return this.ensureAvailable(8),this._data.setBigInt64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this}writeBigUint64(t){return this.ensureAvailable(8),this._data.setBigUint64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this}writeChar(t){return this.writeUint8(t.charCodeAt(0))}writeChars(t){for(let e=0;e<t.length;e++)this.writeUint8(t.charCodeAt(e));return this}writeUtf8(t){return this.writeBytes(encode$3(t))}toArray(){return new Uint8Array(this.buffer,this.byteOffset,this.lastWrittenByte)}getWrittenByteLength(){return this.lastWrittenByte-this.byteOffset}_updateLastWrittenByte(){this.offset>this.lastWrittenByte&&(this.lastWrittenByte=this.offset)}}class BMPDecoder{bufferData;pixelDataOffset;width;height;bitsPerPixel;xPixelsPerMeter;yPixelsPerMeter;compression;colorMasks;constructor(t){this.bufferData=new IOBuffer(t);const e=this.bufferData.readBytes(2);if(66!==e[0]&&77!==e[1])throw new Error("This is not a BMP image or the encoding is not correct.");if(this.pixelDataOffset=this.bufferData.skip(8).readUint32(),this.width=this.bufferData.skip(4).readUint32(),this.height=this.bufferData.readUint32(),this.bitsPerPixel=this.bufferData.seek(28).readUint16(),1!==this.bitsPerPixel&&8!==this.bitsPerPixel&&24!==this.bitsPerPixel&&32!==this.bitsPerPixel)throw new Error(`Invalid number of bits per pixel. Supported number of bits per pixel: 1, 8, 24, 32. Received: ${this.bitsPerPixel}`);if(this.compression=this.bufferData.readUint32(),0!==this.compression&&3!==this.compression)throw new Error("Only BI_RGB and BI_BITFIELDS compression methods are allowed. ");if(this.colorMasks=[this.bufferData.seek(54).readUint32(),this.bufferData.readUint32(),this.bufferData.readUint32()],32===this.bitsPerPixel&&(16711680!==this.colorMasks[0]||65280!==this.colorMasks[1]||255!==this.colorMasks[2]))throw new Error(`Unsupported color masks detected in 32-bit BMP image. Only standard RGBA (${16711680..toString(16)}, ${65280..toString(16)}, ${255..toString(16)}) masks are supported. Received: ${this.colorMasks[0].toString(16)},${this.colorMasks[1].toString(16)},${this.colorMasks[2].toString(16)}.`);this.bufferData.skip(1),this.xPixelsPerMeter=this.bufferData.seek(38).readInt32(),this.yPixelsPerMeter=this.bufferData.readInt32(),this.bufferData.skip(1)}decode(){this.bufferData.seek(this.pixelDataOffset),this.bufferData.setBigEndian();const t=Math.ceil(this.bitsPerPixel/8),e=t%2==0?t-1:t,r=this.decodePixelData(t,e);return{width:this.width,height:this.height,bitsPerPixel:this.bitsPerPixel,compression:this.compression,colorMasks:this.colorMasks,channels:t,components:e,data:r,yPixelsPerMeter:this.yPixelsPerMeter,xPixelsPerMeter:this.xPixelsPerMeter}}decodePixelData(t,e){const r=new Uint8Array(this.height*this.width*t);return 1===this.bitsPerPixel?this.decodeBitDepth1Pixels(r):t===e?this.decodeStandardPixels(r,t):this.decodePixelsWithAlpha(r,t,e),r}decodeBitDepth1Pixels(t){let e=0;for(let r=0;r<this.height;r++)for(let n=0;n<this.width;n++){const i=n%32;0===i&&(e=this.bufferData.readUint32()),e&1<<31-i&&(t[(this.height-r-1)*this.width+n]=1)}}decodeStandardPixels(t,e){const r=this.calculatePadding(e);for(let n=0;n<this.height;n++){const i=(this.height-n-1)*this.width;for(let r=0;r<this.width;r++)for(let n=e-1;n>=0;n--)t[(i+r)*e+n]=this.bufferData.readByte();this.bufferData.skip(r)}}decodePixelsWithAlpha(t,e,r){for(let n=0;n<this.height;n++){const i=(this.height-n-1)*this.width;for(let n=0;n<this.width;n++){const o=(i+n)*e;for(let e=r-1;e>=0;e--)t[o+e]=this.bufferData.readByte();t[o+r]=this.bufferData.readByte()}}}calculatePadding(t){return this.width*t%4==0?0:4-this.width*t%4}}const BITMAPV5HEADER={LogicalColorSpace:{LCS_sRGB:1934772034},GamutMappingIntent:{LCS_GM_GRAPHICS:2},DEFAULT_PIXELS_PER_METER:2835};class BMPEncoder{width;height;bitsPerPixel;channels;components;data;xPixelsPerMeter;yPixelsPerMeter;encoded=new IOBuffer;compression;colorMasks;constructor(t){if(!t.height||!t.width)throw new Error("ImageData width and height are required.");if(this.data=t.data,this.width=t.width,this.height=t.height,this.data.length!==t.width*t.height*t.channels)throw new Error("Invalid data length.");if(this.bitsPerPixel=t.bitsPerPixel,1!==this.bitsPerPixel&&8!==this.bitsPerPixel&&24!==this.bitsPerPixel&&32!==this.bitsPerPixel)throw new Error(`Invalid number of bits per pixel. Supported number of bits per pixel: 1, 8, 24, 32. Received: ${this.bitsPerPixel}`);this.channels=t.channels,this.components=this.channels%2==0?this.channels-1:this.channels,this.xPixelsPerMeter=t.xPixelsPerMeter??BITMAPV5HEADER.DEFAULT_PIXELS_PER_METER,this.yPixelsPerMeter=t.yPixelsPerMeter??BITMAPV5HEADER.DEFAULT_PIXELS_PER_METER,this.compression=t.compression??0,this.colorMasks=t.colorMasks??[16711680,65280,255]}encode(){this.encoded=new IOBuffer,this.encoded.skip(14),this.writeBitmapV5Header(),this.bitsPerPixel<=8&&this.writeColorTable();const t=this.encoded.offset;this.writePixelArray();const e=this.encoded.getWrittenByteLength();return this.encoded.rewind(),this.writeBitmapFileHeader(t,e),this.encoded.toArray()}writePixelArray(){this.encoded.setBigEndian(),1===this.bitsPerPixel?this.writeBitDepth1Pixels():this.channels===this.components?this.writeStandardPixels():this.writePixelsWithAlpha(),this.encoded.setLittleEndian()}writeBitDepth1Pixels(){let t=0;for(let e=this.height-1;e>=0;e--){for(let r=0;r<this.width;r++)r%32==0&&0!==r&&(this.encoded.writeUint32(t),t=0),t|=this.data[e*this.width+r]<<31-r%32;this.encoded.writeUint32(t),t=0}}writeStandardPixels(){for(let t=0;t<this.height;t++){const e=this.width*(this.height-t-1)*this.channels;for(let t=0;t<this.width;t++)for(let r=this.channels-1;r>=0;r--)this.encoded.writeByte(this.data[e+t*this.channels+r]);this.writePadding()}}writePixelsWithAlpha(){for(let t=0;t<this.height;t++){const e=this.width*(this.height-t-1);for(let t=0;t<this.width;t++){const r=(e+t)*this.channels;this.encoded.writeUint32(this.data[r+2]<<24|this.data[r+1]<<16|this.data[r]<<8|this.data[r+3])}}}writePadding(){const t=this.width*this.channels%4==0?0:4-this.width*this.channels%4;for(let e=0;e<t;e++)this.encoded.writeByte(0)}writeColorTable(){if(1===this.bitsPerPixel)this.encoded.writeUint32(0).writeUint32(16777215);else for(let t=0;t<256;t++)this.encoded.writeUint32(t<<16|t<<8|t)}writeBitmapFileHeader(t,e){this.encoded.writeChars("BM").writeInt32(e).writeUint16(0).writeUint16(0).writeUint32(t)}writeBitmapV5Header(){const t=4*Math.floor((this.bitsPerPixel*this.width+31)/32)*this.height;if(this.encoded.writeUint32(124).writeInt32(this.width).writeInt32(this.height).writeUint16(1).writeUint16(this.bitsPerPixel).writeUint32(this.compression).writeUint32(t).writeInt32(this.xPixelsPerMeter).writeInt32(this.yPixelsPerMeter).writeUint32(this.bitsPerPixel<=8?2**this.bitsPerPixel:0).writeUint32(this.bitsPerPixel<=8?2**this.bitsPerPixel:0),32===this.bitsPerPixel&&(16711680!==this.colorMasks[0]||65280!==this.colorMasks[1]||255!==this.colorMasks[2]))throw new Error(`Unsupported color masks detected in 32-bit BMP image. Only standard RGBA (${16711680..toString(16)}, ${65280..toString(16)}, ${255..toString(16)}) masks are supported. Received: ${this.colorMasks[0].toString(16)},${this.colorMasks[1].toString(16)},${this.colorMasks[2].toString(16)}.`);this.encoded.writeUint32(this.colorMasks[0]).writeUint32(this.colorMasks[1]).writeUint32(this.colorMasks[2]).writeUint32(this.channels===this.components?0:4278190080).writeUint32(BITMAPV5HEADER.LogicalColorSpace.LCS_sRGB).skip(36).skip(12).writeUint32(BITMAPV5HEADER.GamutMappingIntent.LCS_GM_GRAPHICS).skip(12)}}function encode$2(t){return new BMPEncoder(t).encode()}function decode$3(t){return new BMPDecoder(t).decode()}function encodeBmp(t){return encode$2(t instanceof Image?{width:t.width,height:t.height,components:t.components,bitsPerPixel:t.channels*t.bitDepth,channels:t.channels,data:t.getRawImage().data}:{width:t.width,height:t.height,components:1,bitsPerPixel:1,channels:1,data:t.getRawImage().data})}var encoder={exports:{}};!function(t){function e(t){var e,r,n,i,o,s=Math.floor,a=new Array(64),l=new Array(64),h=new Array(64),c=new Array(64),u=new Array(65535),f=new Array(65535),d=new Array(64),m=new Array(64),g=[],p=0,w=7,b=new Array(64),_=new Array(64),y=new Array(64),x=new Array(256),M=new Array(2048),E=[0,1,5,6,14,15,27,28,2,4,7,13,16,26,29,42,3,8,12,17,25,30,41,43,9,11,18,24,31,40,44,53,10,19,23,32,39,45,52,54,20,22,33,38,46,51,55,60,21,34,37,47,50,56,59,61,35,36,48,49,57,58,62,63],v=[0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0],I=[0,1,2,3,4,5,6,7,8,9,10,11],A=[0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125],S=[1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250],R=[0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0],k=[0,1,2,3,4,5,6,7,8,9,10,11],T=[0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119],$=[0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250];function C(t,e){for(var r=0,n=0,i=new Array,o=1;o<=16;o++){for(var s=1;s<=t[o];s++)i[e[n]]=[],i[e[n]][0]=r,i[e[n]][1]=o,n++,r++;r*=2}return i}function D(t){for(var e=t[0],r=t[1]-1;r>=0;)e&1<<r&&(p|=1<<w),r--,--w<0&&(255==p?(B(255),B(0)):B(p),w=7,p=0)}function B(t){g.push(t)}function P(t){B(t>>8&255),B(255&t)}function O(t,e,r,n,i){for(var o,s=i[0],a=i[240],l=function(t,e){var r,n,i,o,s,a,l,h,c,u,f=0;for(c=0;c<8;++c){r=t[f],n=t[f+1],i=t[f+2],o=t[f+3],s=t[f+4],a=t[f+5],l=t[f+6];var m=r+(h=t[f+7]),g=r-h,p=n+l,w=n-l,b=i+a,_=i-a,y=o+s,x=o-s,M=m+y,E=m-y,v=p+b,I=p-b;t[f]=M+v,t[f+4]=M-v;var A=.707106781*(I+E);t[f+2]=E+A,t[f+6]=E-A;var S=.382683433*((M=x+_)-(I=w+g)),R=.5411961*M+S,k=1.306562965*I+S,T=.707106781*(v=_+w),$=g+T,C=g-T;t[f+5]=C+R,t[f+3]=C-R,t[f+1]=$+k,t[f+7]=$-k,f+=8}for(f=0,c=0;c<8;++c){r=t[f],n=t[f+8],i=t[f+16],o=t[f+24],s=t[f+32],a=t[f+40],l=t[f+48];var D=r+(h=t[f+56]),B=r-h,P=n+l,O=n-l,N=i+a,F=i-a,L=o+s,V=o-s,U=D+L,z=D-L,H=P+N,G=P-N;t[f]=U+H,t[f+32]=U-H;var Z=.707106781*(G+z);t[f+16]=z+Z,t[f+48]=z-Z;var Y=.382683433*((U=V+F)-(G=O+B)),K=.5411961*U+Y,q=1.306562965*G+Y,j=.707106781*(H=F+O),X=B+j,W=B-j;t[f+40]=W+K,t[f+24]=W-K,t[f+8]=X+q,t[f+56]=X-q,f++}for(c=0;c<64;++c)u=t[c]*e[c],d[c]=u>0?u+.5|0:u-.5|0;return d}(t,e),h=0;h<64;++h)m[E[h]]=l[h];var c=m[0]-r;r=m[0],0==c?D(n[0]):(D(n[f[o=32767+c]]),D(u[o]));for(var g=63;g>0&&0==m[g];g--);if(0==g)return D(s),r;for(var p,w=1;w<=g;){for(var b=w;0==m[w]&&w<=g;++w);var _=w-b;if(_>=16){p=_>>4;for(var y=1;y<=p;++y)D(a);_&=15}o=32767+m[w],D(i[(_<<4)+f[o]]),D(u[o]),w++}return 63!=g&&D(s),r}function N(t){if(t<=0&&(t=1),t>100&&(t=100),o!=t){(function(t){for(var e=[16,11,10,16,24,40,51,61,12,12,14,19,26,58,60,55,14,13,16,24,40,57,69,56,14,17,22,29,51,87,80,62,18,22,37,56,68,109,103,77,24,35,55,64,81,104,113,92,49,64,78,87,103,121,120,101,72,92,95,98,112,100,103,99],r=0;r<64;r++){var n=s((e[r]*t+50)/100);n<1?n=1:n>255&&(n=255),a[E[r]]=n}for(var i=[17,18,24,47,99,99,99,99,18,21,26,66,99,99,99,99,24,26,56,99,99,99,99,99,47,66,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99],o=0;o<64;o++){var u=s((i[o]*t+50)/100);u<1?u=1:u>255&&(u=255),l[E[o]]=u}for(var f=[1,1.387039845,1.306562965,1.175875602,1,.785694958,.5411961,.275899379],d=0,m=0;m<8;m++)for(var g=0;g<8;g++)h[d]=1/(a[E[d]]*f[m]*f[g]*8),c[d]=1/(l[E[d]]*f[m]*f[g]*8),d++})(t<50?Math.floor(5e3/t):Math.floor(200-2*t)),o=t}}this.encode=function(t,o){var s;(new Date).getTime(),o&&N(o),g=new Array,p=0,w=7,P(65496),P(65504),P(16),B(74),B(70),B(73),B(70),B(0),B(1),B(1),B(0),P(1),P(1),B(0),B(0),void 0!==(s=t.comments)&&s.constructor===Array&&s.forEach(t=>{if("string"==typeof t){P(65534);var e,r=t.length;for(P(r+2),e=0;e<r;e++)B(t.charCodeAt(e))}}),function(t){if(t){P(65505),69===t[0]&&120===t[1]&&105===t[2]&&102===t[3]?P(t.length+2):(P(t.length+5+2),B(69),B(120),B(105),B(102),B(0));for(var e=0;e<t.length;e++)B(t[e])}}(t.exifBuffer),function(){P(65499),P(132),B(0);for(var t=0;t<64;t++)B(a[t]);B(1);for(var e=0;e<64;e++)B(l[e])}(),function(t,e){P(65472),P(17),B(8),P(e),P(t),B(3),B(1),B(17),B(0),B(2),B(17),B(1),B(3),B(17),B(1)}(t.width,t.height),function(){P(65476),P(418),B(0);for(var t=0;t<16;t++)B(v[t+1]);for(var e=0;e<=11;e++)B(I[e]);B(16);for(var r=0;r<16;r++)B(A[r+1]);for(var n=0;n<=161;n++)B(S[n]);B(1);for(var i=0;i<16;i++)B(R[i+1]);for(var o=0;o<=11;o++)B(k[o]);B(17);for(var s=0;s<16;s++)B(T[s+1]);for(var a=0;a<=161;a++)B($[a])}(),P(65498),P(12),B(3),B(1),B(0),B(2),B(17),B(3),B(17),B(0),B(63),B(0);var u=0,f=0,d=0;p=0,w=7,this.encode.displayName="_encode_";for(var m,x,E,C,F,L,V,U,z,H=t.data,G=t.width,Z=t.height,Y=4*G,K=0;K<Z;){for(m=0;m<Y;){for(L=F=Y*K+m,V=-1,U=0,z=0;z<64;z++)L=F+(U=z>>3)*Y+(V=4*(7&z)),K+U>=Z&&(L-=Y*(K+1+U-Z)),m+V>=Y&&(L-=m+V-Y+4),x=H[L++],E=H[L++],C=H[L++],b[z]=(M[x]+M[E+256|0]+M[C+512|0]>>16)-128,_[z]=(M[x+768|0]+M[E+1024|0]+M[C+1280|0]>>16)-128,y[z]=(M[x+1280|0]+M[E+1536|0]+M[C+1792|0]>>16)-128;u=O(b,h,u,e,n),f=O(_,c,f,r,i),d=O(y,c,d,r,i),m+=32}K+=8}if(w>=0){var q=[];q[1]=w+1,q[0]=(1<<w+1)-1,D(q)}return P(65497),Buffer.from(g)},(new Date).getTime(),t||(t=50),function(){for(var t=String.fromCharCode,e=0;e<256;e++)x[e]=t(e)}(),e=C(v,I),r=C(R,k),n=C(A,S),i=C(T,$),function(){for(var t=1,e=2,r=1;r<=15;r++){for(var n=t;n<e;n++)f[32767+n]=r,u[32767+n]=[],u[32767+n][1]=r,u[32767+n][0]=n;for(var i=-(e-1);i<=-t;i++)f[32767+i]=r,u[32767+i]=[],u[32767+i][1]=r,u[32767+i][0]=e-1+i;t<<=1,e<<=1}}(),function(){for(var t=0;t<256;t++)M[t]=19595*t,M[t+256|0]=38470*t,M[t+512|0]=7471*t+32768,M[t+768|0]=-11059*t,M[t+1024|0]=-21709*t,M[t+1280|0]=32768*t+8421375,M[t+1536|0]=-27439*t,M[t+1792|0]=-5329*t}(),N(t),(new Date).getTime()}t.exports=function(t,r){void 0===r&&(r=50);var n=new e(r),i=n.encode(t,r);return{data:i,width:t.width,height:t.height}}}(encoder);var encoderExports=encoder.exports,decoder={exports:{}};!function(t){var e=function(){var t=new Int32Array([0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]),e=4017,r=799,n=3406,i=2276,o=1567,s=3784,a=5793,l=2896;function h(){}function c(t,e){for(var r,n,i=0,o=[],s=16;s>0&&!t[s-1];)s--;o.push({children:[],index:0});var a,l=o[0];for(r=0;r<s;r++){for(n=0;n<t[r];n++){for((l=o.pop()).children[l.index]=e[i];l.index>0;){if(0===o.length)throw new Error("Could not recreate Huffman Table");l=o.pop()}for(l.index++,o.push(l);o.length<=r;)o.push(a={children:[],index:0}),l.children[l.index]=a.children,l=a;i++}r+1<s&&(o.push(a={children:[],index:0}),l.children[l.index]=a.children,l=a)}return o[0].children}function u(e,r,n,i,o,s,a,l,h,c){n.precision,n.samplesPerLine,n.scanLines;var u=n.mcusPerLine,f=n.progressive;n.maxH,n.maxV;var d=r,m=0,g=0;function p(){if(g>0)return g--,m>>g&1;if(255==(m=e[r++])){var t=e[r++];if(t)throw new Error("unexpected marker: "+(m<<8|t).toString(16))}return g=7,m>>>7}function w(t){for(var e,r=t;null!==(e=p());){if("number"==typeof(r=r[e]))return r;if("object"!=typeof r)throw new Error("invalid huffman sequence")}return null}function b(t){for(var e=0;t>0;){var r=p();if(null===r)return;e=e<<1|r,t--}return e}function _(t){var e=b(t);return e>=1<<t-1?e:e+(-1<<t)+1}var y=0;var x,M=0;function E(t,e,r,n,i){var o=r%u,s=(r/u|0)*t.v+n,a=o*t.h+i;void 0===t.blocks[s]&&c.tolerantDecoding||e(t,t.blocks[s][a])}function v(t,e,r){var n=r/t.blocksPerLine|0,i=r%t.blocksPerLine;void 0===t.blocks[n]&&c.tolerantDecoding||e(t,t.blocks[n][i])}var I,A,S,R,k,T,$=i.length;T=f?0===s?0===l?function(t,e){var r=w(t.huffmanTableDC),n=0===r?0:_(r)<<h;e[0]=t.pred+=n}:function(t,e){e[0]|=p()<<h}:0===l?function(e,r){if(y>0)y--;else for(var n=s,i=a;n<=i;){var o=w(e.huffmanTableAC),l=15&o,c=o>>4;if(0!==l)r[t[n+=c]]=_(l)*(1<<h),n++;else{if(c<15){y=b(c)+(1<<c)-1;break}n+=16}}}:function(e,r){for(var n=s,i=a,o=0;n<=i;){var l=t[n],c=r[l]<0?-1:1;switch(M){case 0:var u=w(e.huffmanTableAC),f=15&u;if(o=u>>4,0===f)o<15?(y=b(o)+(1<<o),M=4):(o=16,M=1);else{if(1!==f)throw new Error("invalid ACn encoding");x=_(f),M=o?2:3}continue;case 1:case 2:r[l]?r[l]+=(p()<<h)*c:0===--o&&(M=2==M?3:0);break;case 3:r[l]?r[l]+=(p()<<h)*c:(r[l]=x<<h,M=0);break;case 4:r[l]&&(r[l]+=(p()<<h)*c)}n++}4===M&&0===--y&&(M=0)}:function(e,r){var n=w(e.huffmanTableDC),i=0===n?0:_(n);r[0]=e.pred+=i;for(var o=1;o<64;){var s=w(e.huffmanTableAC),a=15&s,l=s>>4;if(0!==a)r[t[o+=l]]=_(a),o++;else{if(l<15)break;o+=16}}};var C,D,B,P,O=0;for(D=1==$?i[0].blocksPerLine*i[0].blocksPerColumn:u*n.mcusPerColumn,o||(o=D);O<D;){for(A=0;A<$;A++)i[A].pred=0;if(y=0,1==$)for(I=i[0],k=0;k<o;k++)v(I,T,O),O++;else for(k=0;k<o;k++){for(A=0;A<$;A++)for(B=(I=i[A]).h,P=I.v,S=0;S<P;S++)for(R=0;R<B;R++)E(I,T,O,S,R);if(++O===D)break}if(O===D)do{if(255===e[r]&&0!==e[r+1])break;r+=1}while(r<e.length-2);if(g=0,(C=e[r]<<8|e[r+1])<65280)throw new Error("marker was not found");if(!(C>=65488&&C<=65495))break;r+=2}return r-d}function f(t,h){var c,u,f=[],d=h.blocksPerLine,m=h.blocksPerColumn,g=d<<3,w=new Int32Array(64),b=new Uint8Array(64);function _(t,c,u){var f,d,m,g,p,w,b,_,y,x,M=h.quantizationTable,E=u;for(x=0;x<64;x++)E[x]=t[x]*M[x];for(x=0;x<8;++x){var v=8*x;0!=E[1+v]||0!=E[2+v]||0!=E[3+v]||0!=E[4+v]||0!=E[5+v]||0!=E[6+v]||0!=E[7+v]?(f=a*E[0+v]+128>>8,d=a*E[4+v]+128>>8,m=E[2+v],g=E[6+v],p=l*(E[1+v]-E[7+v])+128>>8,_=l*(E[1+v]+E[7+v])+128>>8,w=E[3+v]<<4,b=E[5+v]<<4,y=f-d+1>>1,f=f+d+1>>1,d=y,y=m*s+g*o+128>>8,m=m*o-g*s+128>>8,g=y,y=p-b+1>>1,p=p+b+1>>1,b=y,y=_+w+1>>1,w=_-w+1>>1,_=y,y=f-g+1>>1,f=f+g+1>>1,g=y,y=d-m+1>>1,d=d+m+1>>1,m=y,y=p*i+_*n+2048>>12,p=p*n-_*i+2048>>12,_=y,y=w*r+b*e+2048>>12,w=w*e-b*r+2048>>12,b=y,E[0+v]=f+_,E[7+v]=f-_,E[1+v]=d+b,E[6+v]=d-b,E[2+v]=m+w,E[5+v]=m-w,E[3+v]=g+p,E[4+v]=g-p):(y=a*E[0+v]+512>>10,E[0+v]=y,E[1+v]=y,E[2+v]=y,E[3+v]=y,E[4+v]=y,E[5+v]=y,E[6+v]=y,E[7+v]=y)}for(x=0;x<8;++x){var I=x;0!=E[8+I]||0!=E[16+I]||0!=E[24+I]||0!=E[32+I]||0!=E[40+I]||0!=E[48+I]||0!=E[56+I]?(f=a*E[0+I]+2048>>12,d=a*E[32+I]+2048>>12,m=E[16+I],g=E[48+I],p=l*(E[8+I]-E[56+I])+2048>>12,_=l*(E[8+I]+E[56+I])+2048>>12,w=E[24+I],b=E[40+I],y=f-d+1>>1,f=f+d+1>>1,d=y,y=m*s+g*o+2048>>12,m=m*o-g*s+2048>>12,g=y,y=p-b+1>>1,p=p+b+1>>1,b=y,y=_+w+1>>1,w=_-w+1>>1,_=y,y=f-g+1>>1,f=f+g+1>>1,g=y,y=d-m+1>>1,d=d+m+1>>1,m=y,y=p*i+_*n+2048>>12,p=p*n-_*i+2048>>12,_=y,y=w*r+b*e+2048>>12,w=w*e-b*r+2048>>12,b=y,E[0+I]=f+_,E[56+I]=f-_,E[8+I]=d+b,E[48+I]=d-b,E[16+I]=m+w,E[40+I]=m-w,E[24+I]=g+p,E[32+I]=g-p):(y=a*u[x+0]+8192>>14,E[0+I]=y,E[8+I]=y,E[16+I]=y,E[24+I]=y,E[32+I]=y,E[40+I]=y,E[48+I]=y,E[56+I]=y)}for(x=0;x<64;++x){var A=128+(E[x]+8>>4);c[x]=A<0?0:A>255?255:A}}p(g*m*8);for(var y=0;y<m;y++){var x=y<<3;for(c=0;c<8;c++)f.push(new Uint8Array(g));for(var M=0;M<d;M++){_(h.blocks[y][M],b,w);var E=0,v=M<<3;for(u=0;u<8;u++){var I=f[x+u];for(c=0;c<8;c++)I[v+c]=b[E++]}}}return f}function d(t){return t<0?0:t>255?255:t}h.prototype={load:function(t){var e=new XMLHttpRequest;e.open("GET",t,!0),e.responseType="arraybuffer",e.onload=function(){var t=new Uint8Array(e.response||e.mozResponseArrayBuffer);this.parse(t),this.onload&&this.onload()}.bind(this),e.send(null)},parse:function(e){var r=1e3*this.opts.maxResolutionInMP*1e3,n=0;function i(){var t=e[n]<<8|e[n+1];return n+=2,t}function o(){var t=i(),r=e.subarray(n,n+t-2);return n+=r.length,r}function s(t){var e,r,n=1,i=1;for(r in t.components)t.components.hasOwnProperty(r)&&(n<(e=t.components[r]).h&&(n=e.h),i<e.v&&(i=e.v));var o=Math.ceil(t.samplesPerLine/8/n),s=Math.ceil(t.scanLines/8/i);for(r in t.components)if(t.components.hasOwnProperty(r)){e=t.components[r];var a=Math.ceil(Math.ceil(t.samplesPerLine/8)*e.h/n),l=Math.ceil(Math.ceil(t.scanLines/8)*e.v/i),h=o*e.h,c=s*e.v,u=[];p(256*(c*h));for(var f=0;f<c;f++){for(var d=[],m=0;m<h;m++)d.push(new Int32Array(64));u.push(d)}e.blocksPerLine=a,e.blocksPerColumn=l,e.blocks=u}t.maxH=n,t.maxV=i,t.mcusPerLine=o,t.mcusPerColumn=s}e.length;var a,l,h=null,d=null,m=[],g=[],w=[],b=[],_=i(),y=-1;if(this.comments=[],65496!=_)throw new Error("SOI not found");for(_=i();65497!=_;){switch(_){case 65280:break;case 65504:case 65505:case 65506:case 65507:case 65508:case 65509:case 65510:case 65511:case 65512:case 65513:case 65514:case 65515:case 65516:case 65517:case 65518:case 65519:case 65534:var x=o();if(65534===_){var M=String.fromCharCode.apply(null,x);this.comments.push(M)}65504===_&&74===x[0]&&70===x[1]&&73===x[2]&&70===x[3]&&0===x[4]&&(h={version:{major:x[5],minor:x[6]},densityUnits:x[7],xDensity:x[8]<<8|x[9],yDensity:x[10]<<8|x[11],thumbWidth:x[12],thumbHeight:x[13],thumbData:x.subarray(14,14+3*x[12]*x[13])}),65505===_&&69===x[0]&&120===x[1]&&105===x[2]&&102===x[3]&&0===x[4]&&(this.exifBuffer=x.subarray(5,x.length)),65518===_&&65===x[0]&&100===x[1]&&111===x[2]&&98===x[3]&&101===x[4]&&0===x[5]&&(d={version:x[6],flags0:x[7]<<8|x[8],flags1:x[9]<<8|x[10],transformCode:x[11]});break;case 65499:for(var E=i()+n-2;n<E;){var v=e[n++];p(256);var I=new Int32Array(64);if(v>>4){if(v>>4!=1)throw new Error("DQT: invalid table spec");for(K=0;K<64;K++){I[t[K]]=i()}}else for(K=0;K<64;K++){I[t[K]]=e[n++]}m[15&v]=I}break;case 65472:case 65473:case 65474:i(),(a={}).extended=65473===_,a.progressive=65474===_,a.precision=e[n++],a.scanLines=i(),a.samplesPerLine=i(),a.components={},a.componentsOrder=[];var A=a.scanLines*a.samplesPerLine;if(A>r){var S=Math.ceil((A-r)/1e6);throw new Error(`maxResolutionInMP limit exceeded by ${S}MP`)}var R,k=e[n++];for(Z=0;Z<k;Z++){R=e[n];var T=e[n+1]>>4,$=15&e[n+1],C=e[n+2];if(T<=0||$<=0)throw new Error("Invalid sampling factor, expected values above 0");a.componentsOrder.push(R),a.components[R]={h:T,v:$,quantizationIdx:C},n+=3}s(a),g.push(a);break;case 65476:var D=i();for(Z=2;Z<D;){var B=e[n++],P=new Uint8Array(16),O=0;for(K=0;K<16;K++,n++)O+=P[K]=e[n];p(16+O);var N=new Uint8Array(O);for(K=0;K<O;K++,n++)N[K]=e[n];Z+=17+O,(B>>4?w:b)[15&B]=c(P,N)}break;case 65501:i(),l=i();break;case 65500:i(),i();break;case 65498:i();var F=e[n++],L=[];for(Z=0;Z<F;Z++){q=a.components[e[n++]];var V=e[n++];q.huffmanTableDC=b[V>>4],q.huffmanTableAC=w[15&V],L.push(q)}var U=e[n++],z=e[n++],H=e[n++],G=u(e,n,a,L,l,U,z,H>>4,15&H,this.opts);n+=G;break;case 65535:255!==e[n]&&n--;break;default:if(255==e[n-3]&&e[n-2]>=192&&e[n-2]<=254){n-=3;break}if(224===_||225==_){if(-1!==y)throw new Error(`first unknown JPEG marker at offset ${y.toString(16)}, second unknown JPEG marker ${_.toString(16)} at offset ${(n-1).toString(16)}`);y=n-1;const t=i();if(255===e[n+t-2]){n+=t-2;break}}throw new Error("unknown JPEG marker "+_.toString(16))}_=i()}if(1!=g.length)throw new Error("only single frame JPEGs supported");for(var Z=0;Z<g.length;Z++){var Y=g[Z].components;for(var K in Y)Y[K].quantizationTable=m[Y[K].quantizationIdx],delete Y[K].quantizationIdx}this.width=a.samplesPerLine,this.height=a.scanLines,this.jfif=h,this.adobe=d,this.components=[];for(Z=0;Z<a.componentsOrder.length;Z++){var q=a.components[a.componentsOrder[Z]];this.components.push({lines:f(0,q),scaleX:q.h/a.maxH,scaleY:q.v/a.maxV})}},getData:function(t,e){var r,n,i,o,s,a,l,h,c,u,f,m,g,w,b,_,y,x,M,E,v,I=this.width/t,A=this.height/e,S=0,R=t*e*this.components.length;p(R);var k=new Uint8Array(R);switch(this.components.length){case 1:for(r=this.components[0],u=0;u<e;u++)for(s=r.lines[0|u*r.scaleY*A],c=0;c<t;c++)f=s[0|c*r.scaleX*I],k[S++]=f;break;case 2:for(r=this.components[0],n=this.components[1],u=0;u<e;u++)for(s=r.lines[0|u*r.scaleY*A],a=n.lines[0|u*n.scaleY*A],c=0;c<t;c++)f=s[0|c*r.scaleX*I],k[S++]=f,f=a[0|c*n.scaleX*I],k[S++]=f;break;case 3:for(v=!0,this.adobe&&this.adobe.transformCode?v=!0:void 0!==this.opts.colorTransform&&(v=!!this.opts.colorTransform),r=this.components[0],n=this.components[1],i=this.components[2],u=0;u<e;u++)for(s=r.lines[0|u*r.scaleY*A],a=n.lines[0|u*n.scaleY*A],l=i.lines[0|u*i.scaleY*A],c=0;c<t;c++)v?(f=s[0|c*r.scaleX*I],m=a[0|c*n.scaleX*I],x=d(f+1.402*((g=l[0|c*i.scaleX*I])-128)),M=d(f-.3441363*(m-128)-.71413636*(g-128)),E=d(f+1.772*(m-128))):(x=s[0|c*r.scaleX*I],M=a[0|c*n.scaleX*I],E=l[0|c*i.scaleX*I]),k[S++]=x,k[S++]=M,k[S++]=E;break;case 4:if(!this.adobe)throw new Error("Unsupported color mode (4 components)");for(v=!1,this.adobe&&this.adobe.transformCode?v=!0:void 0!==this.opts.colorTransform&&(v=!!this.opts.colorTransform),r=this.components[0],n=this.components[1],i=this.components[2],o=this.components[3],u=0;u<e;u++)for(s=r.lines[0|u*r.scaleY*A],a=n.lines[0|u*n.scaleY*A],l=i.lines[0|u*i.scaleY*A],h=o.lines[0|u*o.scaleY*A],c=0;c<t;c++)v?(f=s[0|c*r.scaleX*I],m=a[0|c*n.scaleX*I],g=l[0|c*i.scaleX*I],w=h[0|c*o.scaleX*I],b=255-d(f+1.402*(g-128)),_=255-d(f-.3441363*(m-128)-.71413636*(g-128)),y=255-d(f+1.772*(m-128))):(b=s[0|c*r.scaleX*I],_=a[0|c*n.scaleX*I],y=l[0|c*i.scaleX*I],w=h[0|c*o.scaleX*I]),k[S++]=255-b,k[S++]=255-_,k[S++]=255-y,k[S++]=255-w;break;default:throw new Error("Unsupported color mode")}return k},copyToImageData:function(t,e){var r,n,i,o,s,a,l,h,c,u=t.width,f=t.height,m=t.data,g=this.getData(u,f),p=0,w=0;switch(this.components.length){case 1:for(n=0;n<f;n++)for(r=0;r<u;r++)i=g[p++],m[w++]=i,m[w++]=i,m[w++]=i,e&&(m[w++]=255);break;case 3:for(n=0;n<f;n++)for(r=0;r<u;r++)l=g[p++],h=g[p++],c=g[p++],m[w++]=l,m[w++]=h,m[w++]=c,e&&(m[w++]=255);break;case 4:for(n=0;n<f;n++)for(r=0;r<u;r++)s=g[p++],a=g[p++],i=g[p++],l=255-d(s*(1-(o=g[p++])/255)+o),h=255-d(a*(1-o/255)+o),c=255-d(i*(1-o/255)+o),m[w++]=l,m[w++]=h,m[w++]=c,e&&(m[w++]=255);break;default:throw new Error("Unsupported color mode")}}};var m=0,g=0;function p(t=0){var e=m+t;if(e>g){var r=Math.ceil((e-g)/1024/1024);throw new Error(`maxMemoryUsageInMB limit exceeded by at least ${r}MB`)}m=e}return h.resetMaxMemoryUsage=function(t){m=0,g=t},h.getBytesAllocated=function(){return m},h.requestMemoryAllocation=p,h}();t.exports=function(t,r={}){var n={colorTransform:void 0,useTArray:!1,formatAsRGBA:!0,tolerantDecoding:!0,maxResolutionInMP:100,maxMemoryUsageInMB:512,...r},i=new Uint8Array(t),o=new e;o.opts=n,e.resetMaxMemoryUsage(1024*n.maxMemoryUsageInMB*1024),o.parse(i);var s=n.formatAsRGBA?4:3,a=o.width*o.height*s;try{e.requestMemoryAllocation(a);var l={width:o.width,height:o.height,exifBuffer:o.exifBuffer,data:n.useTArray?new Uint8Array(a):Buffer.alloc(a)};o.comments.length>0&&(l.comments=o.comments)}catch(t){if(t instanceof RangeError)throw new Error("Could not allocate enough memory for the image. Required: "+a);if(t instanceof ReferenceError&&"Buffer is not defined"===t.message)throw new Error("Buffer is not globally defined in this environment. Consider setting useTArray to true");throw t}return o.copyToImageData(l,n.formatAsRGBA),l}}(decoder);var decoderExports=decoder.exports,encode$1=encoderExports,decode$2=decoderExports,jpegJs={encode:encode$1,decode:decode$2};function encodeJpeg(t,e={}){const{quality:r=50}=e;("RGBA"!==t.colorModel||t instanceof Mask)&&(t=t.convertColor("RGBA")),8!==t.bitDepth&&(t=t.convertBitDepth(8));const n=jpegJs.encode(t.getRawImage(),r).data;return new Uint8Array(n.buffer,n.byteOffset,n.byteLength)}const Z_FIXED$1=4,Z_BINARY=0,Z_TEXT=1,Z_UNKNOWN$1=2;function zero$1(t){let e=t.length;for(;--e>=0;)t[e]=0}const STORED_BLOCK=0,STATIC_TREES=1,DYN_TREES=2,MIN_MATCH$1=3,MAX_MATCH$1=258,LENGTH_CODES$1=29,LITERALS$1=256,L_CODES$1=LITERALS$1+1+LENGTH_CODES$1,D_CODES$1=30,BL_CODES$1=19,HEAP_SIZE$1=2*L_CODES$1+1,MAX_BITS$1=15,Buf_size=16,MAX_BL_BITS=7,END_BLOCK=256,REP_3_6=16,REPZ_3_10=17,REPZ_11_138=18,extra_lbits=new Uint8Array([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0]),extra_dbits=new Uint8Array([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13]),extra_blbits=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7]),bl_order=new Uint8Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),DIST_CODE_LEN=512,static_ltree=new Array(2*(L_CODES$1+2));zero$1(static_ltree);const static_dtree=new Array(2*D_CODES$1);zero$1(static_dtree);const _dist_code=new Array(DIST_CODE_LEN);zero$1(_dist_code);const _length_code=new Array(MAX_MATCH$1-MIN_MATCH$1+1);zero$1(_length_code);const base_length=new Array(LENGTH_CODES$1);zero$1(base_length);const base_dist=new Array(D_CODES$1);function StaticTreeDesc(t,e,r,n,i){this.static_tree=t,this.extra_bits=e,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=t&&t.length}let static_l_desc,static_d_desc,static_bl_desc;function TreeDesc(t,e){this.dyn_tree=t,this.max_code=0,this.stat_desc=e}zero$1(base_dist);const d_code=t=>t<256?_dist_code[t]:_dist_code[256+(t>>>7)],put_short=(t,e)=>{t.pending_buf[t.pending++]=255&e,t.pending_buf[t.pending++]=e>>>8&255},send_bits=(t,e,r)=>{t.bi_valid>Buf_size-r?(t.bi_buf|=e<<t.bi_valid&65535,put_short(t,t.bi_buf),t.bi_buf=e>>Buf_size-t.bi_valid,t.bi_valid+=r-Buf_size):(t.bi_buf|=e<<t.bi_valid&65535,t.bi_valid+=r)},send_code=(t,e,r)=>{send_bits(t,r[2*e],r[2*e+1])},bi_reverse=(t,e)=>{let r=0;do{r|=1&t,t>>>=1,r<<=1}while(--e>0);return r>>>1},bi_flush=t=>{16===t.bi_valid?(put_short(t,t.bi_buf),t.bi_buf=0,t.bi_valid=0):t.bi_valid>=8&&(t.pending_buf[t.pending++]=255&t.bi_buf,t.bi_buf>>=8,t.bi_valid-=8)},gen_bitlen=(t,e)=>{const r=e.dyn_tree,n=e.max_code,i=e.stat_desc.static_tree,o=e.stat_desc.has_stree,s=e.stat_desc.extra_bits,a=e.stat_desc.extra_base,l=e.stat_desc.max_length;let h,c,u,f,d,m,g=0;for(f=0;f<=MAX_BITS$1;f++)t.bl_count[f]=0;for(r[2*t.heap[t.heap_max]+1]=0,h=t.heap_max+1;h<HEAP_SIZE$1;h++)c=t.heap[h],f=r[2*r[2*c+1]+1]+1,f>l&&(f=l,g++),r[2*c+1]=f,c>n||(t.bl_count[f]++,d=0,c>=a&&(d=s[c-a]),m=r[2*c],t.opt_len+=m*(f+d),o&&(t.static_len+=m*(i[2*c+1]+d)));if(0!==g){do{for(f=l-1;0===t.bl_count[f];)f--;t.bl_count[f]--,t.bl_count[f+1]+=2,t.bl_count[l]--,g-=2}while(g>0);for(f=l;0!==f;f--)for(c=t.bl_count[f];0!==c;)u=t.heap[--h],u>n||(r[2*u+1]!==f&&(t.opt_len+=(f-r[2*u+1])*r[2*u],r[2*u+1]=f),c--)}},gen_codes=(t,e,r)=>{const n=new Array(MAX_BITS$1+1);let i,o,s=0;for(i=1;i<=MAX_BITS$1;i++)s=s+r[i-1]<<1,n[i]=s;for(o=0;o<=e;o++){let e=t[2*o+1];0!==e&&(t[2*o]=bi_reverse(n[e]++,e))}},tr_static_init=()=>{let t,e,r,n,i;const o=new Array(MAX_BITS$1+1);for(r=0,n=0;n<LENGTH_CODES$1-1;n++)for(base_length[n]=r,t=0;t<1<<extra_lbits[n];t++)_length_code[r++]=n;for(_length_code[r-1]=n,i=0,n=0;n<16;n++)for(base_dist[n]=i,t=0;t<1<<extra_dbits[n];t++)_dist_code[i++]=n;for(i>>=7;n<D_CODES$1;n++)for(base_dist[n]=i<<7,t=0;t<1<<extra_dbits[n]-7;t++)_dist_code[256+i++]=n;for(e=0;e<=MAX_BITS$1;e++)o[e]=0;for(t=0;t<=143;)static_ltree[2*t+1]=8,t++,o[8]++;for(;t<=255;)static_ltree[2*t+1]=9,t++,o[9]++;for(;t<=279;)static_ltree[2*t+1]=7,t++,o[7]++;for(;t<=287;)static_ltree[2*t+1]=8,t++,o[8]++;for(gen_codes(static_ltree,L_CODES$1+1,o),t=0;t<D_CODES$1;t++)static_dtree[2*t+1]=5,static_dtree[2*t]=bi_reverse(t,5);static_l_desc=new StaticTreeDesc(static_ltree,extra_lbits,LITERALS$1+1,L_CODES$1,MAX_BITS$1),static_d_desc=new StaticTreeDesc(static_dtree,extra_dbits,0,D_CODES$1,MAX_BITS$1),static_bl_desc=new StaticTreeDesc(new Array(0),extra_blbits,0,BL_CODES$1,MAX_BL_BITS)},init_block=t=>{let e;for(e=0;e<L_CODES$1;e++)t.dyn_ltree[2*e]=0;for(e=0;e<D_CODES$1;e++)t.dyn_dtree[2*e]=0;for(e=0;e<BL_CODES$1;e++)t.bl_tree[2*e]=0;t.dyn_ltree[2*END_BLOCK]=1,t.opt_len=t.static_len=0,t.sym_next=t.matches=0},bi_windup=t=>{t.bi_valid>8?put_short(t,t.bi_buf):t.bi_valid>0&&(t.pending_buf[t.pending++]=t.bi_buf),t.bi_buf=0,t.bi_valid=0},smaller=(t,e,r,n)=>{const i=2*e,o=2*r;return t[i]<t[o]||t[i]===t[o]&&n[e]<=n[r]},pqdownheap=(t,e,r)=>{const n=t.heap[r];let i=r<<1;for(;i<=t.heap_len&&(i<t.heap_len&&smaller(e,t.heap[i+1],t.heap[i],t.depth)&&i++,!smaller(e,n,t.heap[i],t.depth));)t.heap[r]=t.heap[i],r=i,i<<=1;t.heap[r]=n},compress_block=(t,e,r)=>{let n,i,o,s,a=0;if(0!==t.sym_next)do{n=255&t.pending_buf[t.sym_buf+a++],n+=(255&t.pending_buf[t.sym_buf+a++])<<8,i=t.pending_buf[t.sym_buf+a++],0===n?send_code(t,i,e):(o=_length_code[i],send_code(t,o+LITERALS$1+1,e),s=extra_lbits[o],0!==s&&(i-=base_length[o],send_bits(t,i,s)),n--,o=d_code(n),send_code(t,o,r),s=extra_dbits[o],0!==s&&(n-=base_dist[o],send_bits(t,n,s)))}while(a<t.sym_next);send_code(t,END_BLOCK,e)},build_tree=(t,e)=>{const r=e.dyn_tree,n=e.stat_desc.static_tree,i=e.stat_desc.has_stree,o=e.stat_desc.elems;let s,a,l,h=-1;for(t.heap_len=0,t.heap_max=HEAP_SIZE$1,s=0;s<o;s++)0!==r[2*s]?(t.heap[++t.heap_len]=h=s,t.depth[s]=0):r[2*s+1]=0;for(;t.heap_len<2;)l=t.heap[++t.heap_len]=h<2?++h:0,r[2*l]=1,t.depth[l]=0,t.opt_len--,i&&(t.static_len-=n[2*l+1]);for(e.max_code=h,s=t.heap_len>>1;s>=1;s--)pqdownheap(t,r,s);l=o;do{s=t.heap[1],t.heap[1]=t.heap[t.heap_len--],pqdownheap(t,r,1),a=t.heap[1],t.heap[--t.heap_max]=s,t.heap[--t.heap_max]=a,r[2*l]=r[2*s]+r[2*a],t.depth[l]=(t.depth[s]>=t.depth[a]?t.depth[s]:t.depth[a])+1,r[2*s+1]=r[2*a+1]=l,t.heap[1]=l++,pqdownheap(t,r,1)}while(t.heap_len>=2);t.heap[--t.heap_max]=t.heap[1],gen_bitlen(t,e),gen_codes(r,h,t.bl_count)},scan_tree=(t,e,r)=>{let n,i,o=-1,s=e[1],a=0,l=7,h=4;for(0===s&&(l=138,h=3),e[2*(r+1)+1]=65535,n=0;n<=r;n++)i=s,s=e[2*(n+1)+1],++a<l&&i===s||(a<h?t.bl_tree[2*i]+=a:0!==i?(i!==o&&t.bl_tree[2*i]++,t.bl_tree[2*REP_3_6]++):a<=10?t.bl_tree[2*REPZ_3_10]++:t.bl_tree[2*REPZ_11_138]++,a=0,o=i,0===s?(l=138,h=3):i===s?(l=6,h=3):(l=7,h=4))},send_tree=(t,e,r)=>{let n,i,o=-1,s=e[1],a=0,l=7,h=4;for(0===s&&(l=138,h=3),n=0;n<=r;n++)if(i=s,s=e[2*(n+1)+1],!(++a<l&&i===s)){if(a<h)do{send_code(t,i,t.bl_tree)}while(0!==--a);else 0!==i?(i!==o&&(send_code(t,i,t.bl_tree),a--),send_code(t,REP_3_6,t.bl_tree),send_bits(t,a-3,2)):a<=10?(send_code(t,REPZ_3_10,t.bl_tree),send_bits(t,a-3,3)):(send_code(t,REPZ_11_138,t.bl_tree),send_bits(t,a-11,7));a=0,o=i,0===s?(l=138,h=3):i===s?(l=6,h=3):(l=7,h=4)}},build_bl_tree=t=>{let e;for(scan_tree(t,t.dyn_ltree,t.l_desc.max_code),scan_tree(t,t.dyn_dtree,t.d_desc.max_code),build_tree(t,t.bl_desc),e=BL_CODES$1-1;e>=3&&0===t.bl_tree[2*bl_order[e]+1];e--);return t.opt_len+=3*(e+1)+5+5+4,e},send_all_trees=(t,e,r,n)=>{let i;for(send_bits(t,e-257,5),send_bits(t,r-1,5),send_bits(t,n-4,4),i=0;i<n;i++)send_bits(t,t.bl_tree[2*bl_order[i]+1],3);send_tree(t,t.dyn_ltree,e-1),send_tree(t,t.dyn_dtree,r-1)},detect_data_type=t=>{let e,r=4093624447;for(e=0;e<=31;e++,r>>>=1)if(1&r&&0!==t.dyn_ltree[2*e])return Z_BINARY;if(0!==t.dyn_ltree[18]||0!==t.dyn_ltree[20]||0!==t.dyn_ltree[26])return Z_TEXT;for(e=32;e<LITERALS$1;e++)if(0!==t.dyn_ltree[2*e])return Z_TEXT;return Z_BINARY};let static_init_done=!1;const _tr_init$1=t=>{static_init_done||(tr_static_init(),static_init_done=!0),t.l_desc=new TreeDesc(t.dyn_ltree,static_l_desc),t.d_desc=new TreeDesc(t.dyn_dtree,static_d_desc),t.bl_desc=new TreeDesc(t.bl_tree,static_bl_desc),t.bi_buf=0,t.bi_valid=0,init_block(t)},_tr_stored_block$1=(t,e,r,n)=>{send_bits(t,(STORED_BLOCK<<1)+(n?1:0),3),bi_windup(t),put_short(t,r),put_short(t,~r),r&&t.pending_buf.set(t.window.subarray(e,e+r),t.pending),t.pending+=r},_tr_align$1=t=>{send_bits(t,STATIC_TREES<<1,3),send_code(t,END_BLOCK,static_ltree),bi_flush(t)},_tr_flush_block$1=(t,e,r,n)=>{let i,o,s=0;t.level>0?(t.strm.data_type===Z_UNKNOWN$1&&(t.strm.data_type=detect_data_type(t)),build_tree(t,t.l_desc),build_tree(t,t.d_desc),s=build_bl_tree(t),i=t.opt_len+3+7>>>3,o=t.static_len+3+7>>>3,o<=i&&(i=o)):i=o=r+5,r+4<=i&&-1!==e?_tr_stored_block$1(t,e,r,n):t.strategy===Z_FIXED$1||o===i?(send_bits(t,(STATIC_TREES<<1)+(n?1:0),3),compress_block(t,static_ltree,static_dtree)):(send_bits(t,(DYN_TREES<<1)+(n?1:0),3),send_all_trees(t,t.l_desc.max_code+1,t.d_desc.max_code+1,s+1),compress_block(t,t.dyn_ltree,t.dyn_dtree)),init_block(t),n&&bi_windup(t)},_tr_tally$1=(t,e,r)=>(t.pending_buf[t.sym_buf+t.sym_next++]=e,t.pending_buf[t.sym_buf+t.sym_next++]=e>>8,t.pending_buf[t.sym_buf+t.sym_next++]=r,0===e?t.dyn_ltree[2*r]++:(t.matches++,e--,t.dyn_ltree[2*(_length_code[r]+LITERALS$1+1)]++,t.dyn_dtree[2*d_code(e)]++),t.sym_next===t.sym_end);var _tr_init_1=_tr_init$1,_tr_stored_block_1=_tr_stored_block$1,_tr_flush_block_1=_tr_flush_block$1,_tr_tally_1=_tr_tally$1,_tr_align_1=_tr_align$1,trees={_tr_init:_tr_init_1,_tr_stored_block:_tr_stored_block_1,_tr_flush_block:_tr_flush_block_1,_tr_tally:_tr_tally_1,_tr_align:_tr_align_1};const adler32=(t,e,r,n)=>{let i=65535&t,o=t>>>16&65535,s=0;for(;0!==r;){s=r>2e3?2e3:r,r-=s;do{i=i+e[n++]|0,o=o+i|0}while(--s);i%=65521,o%=65521}return i|o<<16};var adler32_1=adler32;const makeTable=()=>{let t,e=[];for(var r=0;r<256;r++){t=r;for(var n=0;n<8;n++)t=1&t?3988292384^t>>>1:t>>>1;e[r]=t}return e},crcTable$1=new Uint32Array(makeTable()),crc32=(t,e,r,n)=>{const i=crcTable$1,o=n+r;t^=-1;for(let r=n;r<o;r++)t=t>>>8^i[255&(t^e[r])];return-1^t};var crc32_1=crc32,messages={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"},constants$2={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_MEM_ERROR:-4,Z_BUF_ERROR:-5,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_UNKNOWN:2,Z_DEFLATED:8};const{_tr_init:_tr_init,_tr_stored_block:_tr_stored_block,_tr_flush_block:_tr_flush_block,_tr_tally:_tr_tally,_tr_align:_tr_align}=trees,{Z_NO_FLUSH:Z_NO_FLUSH$2,Z_PARTIAL_FLUSH:Z_PARTIAL_FLUSH,Z_FULL_FLUSH:Z_FULL_FLUSH$1,Z_FINISH:Z_FINISH$3,Z_BLOCK:Z_BLOCK$1,Z_OK:Z_OK$3,Z_STREAM_END:Z_STREAM_END$3,Z_STREAM_ERROR:Z_STREAM_ERROR$2,Z_DATA_ERROR:Z_DATA_ERROR$2,Z_BUF_ERROR:Z_BUF_ERROR$1,Z_DEFAULT_COMPRESSION:Z_DEFAULT_COMPRESSION$1,Z_FILTERED:Z_FILTERED,Z_HUFFMAN_ONLY:Z_HUFFMAN_ONLY,Z_RLE:Z_RLE,Z_FIXED:Z_FIXED,Z_DEFAULT_STRATEGY:Z_DEFAULT_STRATEGY$1,Z_UNKNOWN:Z_UNKNOWN,Z_DEFLATED:Z_DEFLATED$2}=constants$2,MAX_MEM_LEVEL=9,MAX_WBITS$1=15,DEF_MEM_LEVEL=8,LENGTH_CODES=29,LITERALS=256,L_CODES=LITERALS+1+LENGTH_CODES,D_CODES=30,BL_CODES=19,HEAP_SIZE=2*L_CODES+1,MAX_BITS=15,MIN_MATCH=3,MAX_MATCH=258,MIN_LOOKAHEAD=MAX_MATCH+MIN_MATCH+1,PRESET_DICT=32,INIT_STATE=42,GZIP_STATE=57,EXTRA_STATE=69,NAME_STATE=73,COMMENT_STATE=91,HCRC_STATE=103,BUSY_STATE=113,FINISH_STATE=666,BS_NEED_MORE=1,BS_BLOCK_DONE=2,BS_FINISH_STARTED=3,BS_FINISH_DONE=4,OS_CODE=3,err=(t,e)=>(t.msg=messages[e],e),rank=t=>2*t-(t>4?9:0),zero=t=>{let e=t.length;for(;--e>=0;)t[e]=0},slide_hash=t=>{let e,r,n,i=t.w_size;e=t.hash_size,n=e;do{r=t.head[--n],t.head[n]=r>=i?r-i:0}while(--e);e=i,n=e;do{r=t.prev[--n],t.prev[n]=r>=i?r-i:0}while(--e)};let HASH_ZLIB=(t,e,r)=>(e<<t.hash_shift^r)&t.hash_mask,HASH=HASH_ZLIB;const flush_pending=t=>{const e=t.state;let r=e.pending;r>t.avail_out&&(r=t.avail_out),0!==r&&(t.output.set(e.pending_buf.subarray(e.pending_out,e.pending_out+r),t.next_out),t.next_out+=r,e.pending_out+=r,t.total_out+=r,t.avail_out-=r,e.pending-=r,0===e.pending&&(e.pending_out=0))},flush_block_only=(t,e)=>{_tr_flush_block(t,t.block_start>=0?t.block_start:-1,t.strstart-t.block_start,e),t.block_start=t.strstart,flush_pending(t.strm)},put_byte=(t,e)=>{t.pending_buf[t.pending++]=e},putShortMSB=(t,e)=>{t.pending_buf[t.pending++]=e>>>8&255,t.pending_buf[t.pending++]=255&e},read_buf=(t,e,r,n)=>{let i=t.avail_in;return i>n&&(i=n),0===i?0:(t.avail_in-=i,e.set(t.input.subarray(t.next_in,t.next_in+i),r),1===t.state.wrap?t.adler=adler32_1(t.adler,e,i,r):2===t.state.wrap&&(t.adler=crc32_1(t.adler,e,i,r)),t.next_in+=i,t.total_in+=i,i)},longest_match=(t,e)=>{let r,n,i=t.max_chain_length,o=t.strstart,s=t.prev_length,a=t.nice_match;const l=t.strstart>t.w_size-MIN_LOOKAHEAD?t.strstart-(t.w_size-MIN_LOOKAHEAD):0,h=t.window,c=t.w_mask,u=t.prev,f=t.strstart+MAX_MATCH;let d=h[o+s-1],m=h[o+s];t.prev_length>=t.good_match&&(i>>=2),a>t.lookahead&&(a=t.lookahead);do{if(r=e,h[r+s]===m&&h[r+s-1]===d&&h[r]===h[o]&&h[++r]===h[o+1]){o+=2,r++;do{}while(h[++o]===h[++r]&&h[++o]===h[++r]&&h[++o]===h[++r]&&h[++o]===h[++r]&&h[++o]===h[++r]&&h[++o]===h[++r]&&h[++o]===h[++r]&&h[++o]===h[++r]&&o<f);if(n=MAX_MATCH-(f-o),o=f-MAX_MATCH,n>s){if(t.match_start=e,s=n,n>=a)break;d=h[o+s-1],m=h[o+s]}}}while((e=u[e&c])>l&&0!==--i);return s<=t.lookahead?s:t.lookahead},fill_window=t=>{const e=t.w_size;let r,n,i;do{if(n=t.window_size-t.lookahead-t.strstart,t.strstart>=e+(e-MIN_LOOKAHEAD)&&(t.window.set(t.window.subarray(e,e+e-n),0),t.match_start-=e,t.strstart-=e,t.block_start-=e,t.insert>t.strstart&&(t.insert=t.strstart),slide_hash(t),n+=e),0===t.strm.avail_in)break;if(r=read_buf(t.strm,t.window,t.strstart+t.lookahead,n),t.lookahead+=r,t.lookahead+t.insert>=MIN_MATCH)for(i=t.strstart-t.insert,t.ins_h=t.window[i],t.ins_h=HASH(t,t.ins_h,t.window[i+1]);t.insert&&(t.ins_h=HASH(t,t.ins_h,t.window[i+MIN_MATCH-1]),t.prev[i&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=i,i++,t.insert--,!(t.lookahead+t.insert<MIN_MATCH)););}while(t.lookahead<MIN_LOOKAHEAD&&0!==t.strm.avail_in)},deflate_stored=(t,e)=>{let r,n,i,o=t.pending_buf_size-5>t.w_size?t.w_size:t.pending_buf_size-5,s=0,a=t.strm.avail_in;do{if(r=65535,i=t.bi_valid+42>>3,t.strm.avail_out<i)break;if(i=t.strm.avail_out-i,n=t.strstart-t.block_start,r>n+t.strm.avail_in&&(r=n+t.strm.avail_in),r>i&&(r=i),r<o&&(0===r&&e!==Z_FINISH$3||e===Z_NO_FLUSH$2||r!==n+t.strm.avail_in))break;s=e===Z_FINISH$3&&r===n+t.strm.avail_in?1:0,_tr_stored_block(t,0,0,s),t.pending_buf[t.pending-4]=r,t.pending_buf[t.pending-3]=r>>8,t.pending_buf[t.pending-2]=~r,t.pending_buf[t.pending-1]=~r>>8,flush_pending(t.strm),n&&(n>r&&(n=r),t.strm.output.set(t.window.subarray(t.block_start,t.block_start+n),t.strm.next_out),t.strm.next_out+=n,t.strm.avail_out-=n,t.strm.total_out+=n,t.block_start+=n,r-=n),r&&(read_buf(t.strm,t.strm.output,t.strm.next_out,r),t.strm.next_out+=r,t.strm.avail_out-=r,t.strm.total_out+=r)}while(0===s);return a-=t.strm.avail_in,a&&(a>=t.w_size?(t.matches=2,t.window.set(t.strm.input.subarray(t.strm.next_in-t.w_size,t.strm.next_in),0),t.strstart=t.w_size,t.insert=t.strstart):(t.window_size-t.strstart<=a&&(t.strstart-=t.w_size,t.window.set(t.window.subarray(t.w_size,t.w_size+t.strstart),0),t.matches<2&&t.matches++,t.insert>t.strstart&&(t.insert=t.strstart)),t.window.set(t.strm.input.subarray(t.strm.next_in-a,t.strm.next_in),t.strstart),t.strstart+=a,t.insert+=a>t.w_size-t.insert?t.w_size-t.insert:a),t.block_start=t.strstart),t.high_water<t.strstart&&(t.high_water=t.strstart),s?BS_FINISH_DONE:e!==Z_NO_FLUSH$2&&e!==Z_FINISH$3&&0===t.strm.avail_in&&t.strstart===t.block_start?BS_BLOCK_DONE:(i=t.window_size-t.strstart,t.strm.avail_in>i&&t.block_start>=t.w_size&&(t.block_start-=t.w_size,t.strstart-=t.w_size,t.window.set(t.window.subarray(t.w_size,t.w_size+t.strstart),0),t.matches<2&&t.matches++,i+=t.w_size,t.insert>t.strstart&&(t.insert=t.strstart)),i>t.strm.avail_in&&(i=t.strm.avail_in),i&&(read_buf(t.strm,t.window,t.strstart,i),t.strstart+=i,t.insert+=i>t.w_size-t.insert?t.w_size-t.insert:i),t.high_water<t.strstart&&(t.high_water=t.strstart),i=t.bi_valid+42>>3,i=t.pending_buf_size-i>65535?65535:t.pending_buf_size-i,o=i>t.w_size?t.w_size:i,n=t.strstart-t.block_start,(n>=o||(n||e===Z_FINISH$3)&&e!==Z_NO_FLUSH$2&&0===t.strm.avail_in&&n<=i)&&(r=n>i?i:n,s=e===Z_FINISH$3&&0===t.strm.avail_in&&r===n?1:0,_tr_stored_block(t,t.block_start,r,s),t.block_start+=r,flush_pending(t.strm)),s?BS_FINISH_STARTED:BS_NEED_MORE)},deflate_fast=(t,e)=>{let r,n;for(;;){if(t.lookahead<MIN_LOOKAHEAD){if(fill_window(t),t.lookahead<MIN_LOOKAHEAD&&e===Z_NO_FLUSH$2)return BS_NEED_MORE;if(0===t.lookahead)break}if(r=0,t.lookahead>=MIN_MATCH&&(t.ins_h=HASH(t,t.ins_h,t.window[t.strstart+MIN_MATCH-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),0!==r&&t.strstart-r<=t.w_size-MIN_LOOKAHEAD&&(t.match_length=longest_match(t,r)),t.match_length>=MIN_MATCH)if(n=_tr_tally(t,t.strstart-t.match_start,t.match_length-MIN_MATCH),t.lookahead-=t.match_length,t.match_length<=t.max_lazy_match&&t.lookahead>=MIN_MATCH){t.match_length--;do{t.strstart++,t.ins_h=HASH(t,t.ins_h,t.window[t.strstart+MIN_MATCH-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart}while(0!==--t.match_length);t.strstart++}else t.strstart+=t.match_length,t.match_length=0,t.ins_h=t.window[t.strstart],t.ins_h=HASH(t,t.ins_h,t.window[t.strstart+1]);else n=_tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++;if(n&&(flush_block_only(t,!1),0===t.strm.avail_out))return BS_NEED_MORE}return t.insert=t.strstart<MIN_MATCH-1?t.strstart:MIN_MATCH-1,e===Z_FINISH$3?(flush_block_only(t,!0),0===t.strm.avail_out?BS_FINISH_STARTED:BS_FINISH_DONE):t.sym_next&&(flush_block_only(t,!1),0===t.strm.avail_out)?BS_NEED_MORE:BS_BLOCK_DONE},deflate_slow=(t,e)=>{let r,n,i;for(;;){if(t.lookahead<MIN_LOOKAHEAD){if(fill_window(t),t.lookahead<MIN_LOOKAHEAD&&e===Z_NO_FLUSH$2)return BS_NEED_MORE;if(0===t.lookahead)break}if(r=0,t.lookahead>=MIN_MATCH&&(t.ins_h=HASH(t,t.ins_h,t.window[t.strstart+MIN_MATCH-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),t.prev_length=t.match_length,t.prev_match=t.match_start,t.match_length=MIN_MATCH-1,0!==r&&t.prev_length<t.max_lazy_match&&t.strstart-r<=t.w_size-MIN_LOOKAHEAD&&(t.match_length=longest_match(t,r),t.match_length<=5&&(t.strategy===Z_FILTERED||t.match_length===MIN_MATCH&&t.strstart-t.match_start>4096)&&(t.match_length=MIN_MATCH-1)),t.prev_length>=MIN_MATCH&&t.match_length<=t.prev_length){i=t.strstart+t.lookahead-MIN_MATCH,n=_tr_tally(t,t.strstart-1-t.prev_match,t.prev_length-MIN_MATCH),t.lookahead-=t.prev_length-1,t.prev_length-=2;do{++t.strstart<=i&&(t.ins_h=HASH(t,t.ins_h,t.window[t.strstart+MIN_MATCH-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart)}while(0!==--t.prev_length);if(t.match_available=0,t.match_length=MIN_MATCH-1,t.strstart++,n&&(flush_block_only(t,!1),0===t.strm.avail_out))return BS_NEED_MORE}else if(t.match_available){if(n=_tr_tally(t,0,t.window[t.strstart-1]),n&&flush_block_only(t,!1),t.strstart++,t.lookahead--,0===t.strm.avail_out)return BS_NEED_MORE}else t.match_available=1,t.strstart++,t.lookahead--}return t.match_available&&(n=_tr_tally(t,0,t.window[t.strstart-1]),t.match_available=0),t.insert=t.strstart<MIN_MATCH-1?t.strstart:MIN_MATCH-1,e===Z_FINISH$3?(flush_block_only(t,!0),0===t.strm.avail_out?BS_FINISH_STARTED:BS_FINISH_DONE):t.sym_next&&(flush_block_only(t,!1),0===t.strm.avail_out)?BS_NEED_MORE:BS_BLOCK_DONE},deflate_rle=(t,e)=>{let r,n,i,o;const s=t.window;for(;;){if(t.lookahead<=MAX_MATCH){if(fill_window(t),t.lookahead<=MAX_MATCH&&e===Z_NO_FLUSH$2)return BS_NEED_MORE;if(0===t.lookahead)break}if(t.match_length=0,t.lookahead>=MIN_MATCH&&t.strstart>0&&(i=t.strstart-1,n=s[i],n===s[++i]&&n===s[++i]&&n===s[++i])){o=t.strstart+MAX_MATCH;do{}while(n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&i<o);t.match_length=MAX_MATCH-(o-i),t.match_length>t.lookahead&&(t.match_length=t.lookahead)}if(t.match_length>=MIN_MATCH?(r=_tr_tally(t,1,t.match_length-MIN_MATCH),t.lookahead-=t.match_length,t.strstart+=t.match_length,t.match_length=0):(r=_tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++),r&&(flush_block_only(t,!1),0===t.strm.avail_out))return BS_NEED_MORE}return t.insert=0,e===Z_FINISH$3?(flush_block_only(t,!0),0===t.strm.avail_out?BS_FINISH_STARTED:BS_FINISH_DONE):t.sym_next&&(flush_block_only(t,!1),0===t.strm.avail_out)?BS_NEED_MORE:BS_BLOCK_DONE},deflate_huff=(t,e)=>{let r;for(;;){if(0===t.lookahead&&(fill_window(t),0===t.lookahead)){if(e===Z_NO_FLUSH$2)return BS_NEED_MORE;break}if(t.match_length=0,r=_tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++,r&&(flush_block_only(t,!1),0===t.strm.avail_out))return BS_NEED_MORE}return t.insert=0,e===Z_FINISH$3?(flush_block_only(t,!0),0===t.strm.avail_out?BS_FINISH_STARTED:BS_FINISH_DONE):t.sym_next&&(flush_block_only(t,!1),0===t.strm.avail_out)?BS_NEED_MORE:BS_BLOCK_DONE};function Config(t,e,r,n,i){this.good_length=t,this.max_lazy=e,this.nice_length=r,this.max_chain=n,this.func=i}const configuration_table=[new Config(0,0,0,0,deflate_stored),new Config(4,4,8,4,deflate_fast),new Config(4,5,16,8,deflate_fast),new Config(4,6,32,32,deflate_fast),new Config(4,4,16,16,deflate_slow),new Config(8,16,32,32,deflate_slow),new Config(8,16,128,128,deflate_slow),new Config(8,32,128,256,deflate_slow),new Config(32,128,258,1024,deflate_slow),new Config(32,258,258,4096,deflate_slow)],lm_init=t=>{t.window_size=2*t.w_size,zero(t.head),t.max_lazy_match=configuration_table[t.level].max_lazy,t.good_match=configuration_table[t.level].good_length,t.nice_match=configuration_table[t.level].nice_length,t.max_chain_length=configuration_table[t.level].max_chain,t.strstart=0,t.block_start=0,t.lookahead=0,t.insert=0,t.match_length=t.prev_length=MIN_MATCH-1,t.match_available=0,t.ins_h=0};function DeflateState(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Z_DEFLATED$2,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new Uint16Array(2*HEAP_SIZE),this.dyn_dtree=new Uint16Array(2*(2*D_CODES+1)),this.bl_tree=new Uint16Array(2*(2*BL_CODES+1)),zero(this.dyn_ltree),zero(this.dyn_dtree),zero(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new Uint16Array(MAX_BITS+1),this.heap=new Uint16Array(2*L_CODES+1),zero(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new Uint16Array(2*L_CODES+1),zero(this.depth),this.sym_buf=0,this.lit_bufsize=0,this.sym_next=0,this.sym_end=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}const deflateStateCheck=t=>{if(!t)return 1;const e=t.state;return!e||e.strm!==t||e.status!==INIT_STATE&&e.status!==GZIP_STATE&&e.status!==EXTRA_STATE&&e.status!==NAME_STATE&&e.status!==COMMENT_STATE&&e.status!==HCRC_STATE&&e.status!==BUSY_STATE&&e.status!==FINISH_STATE?1:0},deflateResetKeep=t=>{if(deflateStateCheck(t))return err(t,Z_STREAM_ERROR$2);t.total_in=t.total_out=0,t.data_type=Z_UNKNOWN;const e=t.state;return e.pending=0,e.pending_out=0,e.wrap<0&&(e.wrap=-e.wrap),e.status=2===e.wrap?GZIP_STATE:e.wrap?INIT_STATE:BUSY_STATE,t.adler=2===e.wrap?0:1,e.last_flush=-2,_tr_init(e),Z_OK$3},deflateReset=t=>{const e=deflateResetKeep(t);return e===Z_OK$3&&lm_init(t.state),e},deflateSetHeader=(t,e)=>deflateStateCheck(t)||2!==t.state.wrap?Z_STREAM_ERROR$2:(t.state.gzhead=e,Z_OK$3),deflateInit2=(t,e,r,n,i,o)=>{if(!t)return Z_STREAM_ERROR$2;let s=1;if(e===Z_DEFAULT_COMPRESSION$1&&(e=6),n<0?(s=0,n=-n):n>15&&(s=2,n-=16),i<1||i>MAX_MEM_LEVEL||r!==Z_DEFLATED$2||n<8||n>15||e<0||e>9||o<0||o>Z_FIXED||8===n&&1!==s)return err(t,Z_STREAM_ERROR$2);8===n&&(n=9);const a=new DeflateState;return t.state=a,a.strm=t,a.status=INIT_STATE,a.wrap=s,a.gzhead=null,a.w_bits=n,a.w_size=1<<a.w_bits,a.w_mask=a.w_size-1,a.hash_bits=i+7,a.hash_size=1<<a.hash_bits,a.hash_mask=a.hash_size-1,a.hash_shift=~~((a.hash_bits+MIN_MATCH-1)/MIN_MATCH),a.window=new Uint8Array(2*a.w_size),a.head=new Uint16Array(a.hash_size),a.prev=new Uint16Array(a.w_size),a.lit_bufsize=1<<i+6,a.pending_buf_size=4*a.lit_bufsize,a.pending_buf=new Uint8Array(a.pending_buf_size),a.sym_buf=a.lit_bufsize,a.sym_end=3*(a.lit_bufsize-1),a.level=e,a.strategy=o,a.method=r,deflateReset(t)},deflateInit=(t,e)=>deflateInit2(t,e,Z_DEFLATED$2,MAX_WBITS$1,DEF_MEM_LEVEL,Z_DEFAULT_STRATEGY$1),deflate$2=(t,e)=>{if(deflateStateCheck(t)||e>Z_BLOCK$1||e<0)return t?err(t,Z_STREAM_ERROR$2):Z_STREAM_ERROR$2;const r=t.state;if(!t.output||0!==t.avail_in&&!t.input||r.status===FINISH_STATE&&e!==Z_FINISH$3)return err(t,0===t.avail_out?Z_BUF_ERROR$1:Z_STREAM_ERROR$2);const n=r.last_flush;if(r.last_flush=e,0!==r.pending){if(flush_pending(t),0===t.avail_out)return r.last_flush=-1,Z_OK$3}else if(0===t.avail_in&&rank(e)<=rank(n)&&e!==Z_FINISH$3)return err(t,Z_BUF_ERROR$1);if(r.status===FINISH_STATE&&0!==t.avail_in)return err(t,Z_BUF_ERROR$1);if(r.status===INIT_STATE&&0===r.wrap&&(r.status=BUSY_STATE),r.status===INIT_STATE){let e=Z_DEFLATED$2+(r.w_bits-8<<4)<<8,n=-1;if(n=r.strategy>=Z_HUFFMAN_ONLY||r.level<2?0:r.level<6?1:6===r.level?2:3,e|=n<<6,0!==r.strstart&&(e|=PRESET_DICT),e+=31-e%31,putShortMSB(r,e),0!==r.strstart&&(putShortMSB(r,t.adler>>>16),putShortMSB(r,65535&t.adler)),t.adler=1,r.status=BUSY_STATE,flush_pending(t),0!==r.pending)return r.last_flush=-1,Z_OK$3}if(r.status===GZIP_STATE)if(t.adler=0,put_byte(r,31),put_byte(r,139),put_byte(r,8),r.gzhead)put_byte(r,(r.gzhead.text?1:0)+(r.gzhead.hcrc?2:0)+(r.gzhead.extra?4:0)+(r.gzhead.name?8:0)+(r.gzhead.comment?16:0)),put_byte(r,255&r.gzhead.time),put_byte(r,r.gzhead.time>>8&255),put_byte(r,r.gzhead.time>>16&255),put_byte(r,r.gzhead.time>>24&255),put_byte(r,9===r.level?2:r.strategy>=Z_HUFFMAN_ONLY||r.level<2?4:0),put_byte(r,255&r.gzhead.os),r.gzhead.extra&&r.gzhead.extra.length&&(put_byte(r,255&r.gzhead.extra.length),put_byte(r,r.gzhead.extra.length>>8&255)),r.gzhead.hcrc&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending,0)),r.gzindex=0,r.status=EXTRA_STATE;else if(put_byte(r,0),put_byte(r,0),put_byte(r,0),put_byte(r,0),put_byte(r,0),put_byte(r,9===r.level?2:r.strategy>=Z_HUFFMAN_ONLY||r.level<2?4:0),put_byte(r,OS_CODE),r.status=BUSY_STATE,flush_pending(t),0!==r.pending)return r.last_flush=-1,Z_OK$3;if(r.status===EXTRA_STATE){if(r.gzhead.extra){let e=r.pending,n=(65535&r.gzhead.extra.length)-r.gzindex;for(;r.pending+n>r.pending_buf_size;){let i=r.pending_buf_size-r.pending;if(r.pending_buf.set(r.gzhead.extra.subarray(r.gzindex,r.gzindex+i),r.pending),r.pending=r.pending_buf_size,r.gzhead.hcrc&&r.pending>e&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending-e,e)),r.gzindex+=i,flush_pending(t),0!==r.pending)return r.last_flush=-1,Z_OK$3;e=0,n-=i}let i=new Uint8Array(r.gzhead.extra);r.pending_buf.set(i.subarray(r.gzindex,r.gzindex+n),r.pending),r.pending+=n,r.gzhead.hcrc&&r.pending>e&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending-e,e)),r.gzindex=0}r.status=NAME_STATE}if(r.status===NAME_STATE){if(r.gzhead.name){let e,n=r.pending;do{if(r.pending===r.pending_buf_size){if(r.gzhead.hcrc&&r.pending>n&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending-n,n)),flush_pending(t),0!==r.pending)return r.last_flush=-1,Z_OK$3;n=0}e=r.gzindex<r.gzhead.name.length?255&r.gzhead.name.charCodeAt(r.gzindex++):0,put_byte(r,e)}while(0!==e);r.gzhead.hcrc&&r.pending>n&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending-n,n)),r.gzindex=0}r.status=COMMENT_STATE}if(r.status===COMMENT_STATE){if(r.gzhead.comment){let e,n=r.pending;do{if(r.pending===r.pending_buf_size){if(r.gzhead.hcrc&&r.pending>n&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending-n,n)),flush_pending(t),0!==r.pending)return r.last_flush=-1,Z_OK$3;n=0}e=r.gzindex<r.gzhead.comment.length?255&r.gzhead.comment.charCodeAt(r.gzindex++):0,put_byte(r,e)}while(0!==e);r.gzhead.hcrc&&r.pending>n&&(t.adler=crc32_1(t.adler,r.pending_buf,r.pending-n,n))}r.status=HCRC_STATE}if(r.status===HCRC_STATE){if(r.gzhead.hcrc){if(r.pending+2>r.pending_buf_size&&(flush_pending(t),0!==r.pending))return r.last_flush=-1,Z_OK$3;put_byte(r,255&t.adler),put_byte(r,t.adler>>8&255),t.adler=0}if(r.status=BUSY_STATE,flush_pending(t),0!==r.pending)return r.last_flush=-1,Z_OK$3}if(0!==t.avail_in||0!==r.lookahead||e!==Z_NO_FLUSH$2&&r.status!==FINISH_STATE){let n=0===r.level?deflate_stored(r,e):r.strategy===Z_HUFFMAN_ONLY?deflate_huff(r,e):r.strategy===Z_RLE?deflate_rle(r,e):configuration_table[r.level].func(r,e);if(n!==BS_FINISH_STARTED&&n!==BS_FINISH_DONE||(r.status=FINISH_STATE),n===BS_NEED_MORE||n===BS_FINISH_STARTED)return 0===t.avail_out&&(r.last_flush=-1),Z_OK$3;if(n===BS_BLOCK_DONE&&(e===Z_PARTIAL_FLUSH?_tr_align(r):e!==Z_BLOCK$1&&(_tr_stored_block(r,0,0,!1),e===Z_FULL_FLUSH$1&&(zero(r.head),0===r.lookahead&&(r.strstart=0,r.block_start=0,r.insert=0))),flush_pending(t),0===t.avail_out))return r.last_flush=-1,Z_OK$3}return e!==Z_FINISH$3?Z_OK$3:r.wrap<=0?Z_STREAM_END$3:(2===r.wrap?(put_byte(r,255&t.adler),put_byte(r,t.adler>>8&255),put_byte(r,t.adler>>16&255),put_byte(r,t.adler>>24&255),put_byte(r,255&t.total_in),put_byte(r,t.total_in>>8&255),put_byte(r,t.total_in>>16&255),put_byte(r,t.total_in>>24&255)):(putShortMSB(r,t.adler>>>16),putShortMSB(r,65535&t.adler)),flush_pending(t),r.wrap>0&&(r.wrap=-r.wrap),0!==r.pending?Z_OK$3:Z_STREAM_END$3)},deflateEnd=t=>{if(deflateStateCheck(t))return Z_STREAM_ERROR$2;const e=t.state.status;return t.state=null,e===BUSY_STATE?err(t,Z_DATA_ERROR$2):Z_OK$3},deflateSetDictionary=(t,e)=>{let r=e.length;if(deflateStateCheck(t))return Z_STREAM_ERROR$2;const n=t.state,i=n.wrap;if(2===i||1===i&&n.status!==INIT_STATE||n.lookahead)return Z_STREAM_ERROR$2;if(1===i&&(t.adler=adler32_1(t.adler,e,r,0)),n.wrap=0,r>=n.w_size){0===i&&(zero(n.head),n.strstart=0,n.block_start=0,n.insert=0);let t=new Uint8Array(n.w_size);t.set(e.subarray(r-n.w_size,r),0),e=t,r=n.w_size}const o=t.avail_in,s=t.next_in,a=t.input;for(t.avail_in=r,t.next_in=0,t.input=e,fill_window(n);n.lookahead>=MIN_MATCH;){let t=n.strstart,e=n.lookahead-(MIN_MATCH-1);do{n.ins_h=HASH(n,n.ins_h,n.window[t+MIN_MATCH-1]),n.prev[t&n.w_mask]=n.head[n.ins_h],n.head[n.ins_h]=t,t++}while(--e);n.strstart=t,n.lookahead=MIN_MATCH-1,fill_window(n)}return n.strstart+=n.lookahead,n.block_start=n.strstart,n.insert=n.lookahead,n.lookahead=0,n.match_length=n.prev_length=MIN_MATCH-1,n.match_available=0,t.next_in=s,t.input=a,t.avail_in=o,n.wrap=i,Z_OK$3};var deflateInit_1=deflateInit,deflateInit2_1=deflateInit2,deflateReset_1=deflateReset,deflateResetKeep_1=deflateResetKeep,deflateSetHeader_1=deflateSetHeader,deflate_2$1=deflate$2,deflateEnd_1=deflateEnd,deflateSetDictionary_1=deflateSetDictionary,deflateInfo="pako deflate (from Nodeca project)",deflate_1$2={deflateInit:deflateInit_1,deflateInit2:deflateInit2_1,deflateReset:deflateReset_1,deflateResetKeep:deflateResetKeep_1,deflateSetHeader:deflateSetHeader_1,deflate:deflate_2$1,deflateEnd:deflateEnd_1,deflateSetDictionary:deflateSetDictionary_1,deflateInfo:deflateInfo};const _has=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);var assign=function(t){const e=Array.prototype.slice.call(arguments,1);for(;e.length;){const r=e.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(const e in r)_has(r,e)&&(t[e]=r[e])}}return t},flattenChunks=t=>{let e=0;for(let r=0,n=t.length;r<n;r++)e+=t[r].length;const r=new Uint8Array(e);for(let e=0,n=0,i=t.length;e<i;e++){let i=t[e];r.set(i,n),n+=i.length}return r},common={assign:assign,flattenChunks:flattenChunks};let STR_APPLY_UIA_OK=!0;try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(t){STR_APPLY_UIA_OK=!1}const _utf8len=new Uint8Array(256);for(let t=0;t<256;t++)_utf8len[t]=t>=252?6:t>=248?5:t>=240?4:t>=224?3:t>=192?2:1;_utf8len[254]=_utf8len[254]=1;var string2buf=t=>{if("function"==typeof TextEncoder&&TextEncoder.prototype.encode)return(new TextEncoder).encode(t);let e,r,n,i,o,s=t.length,a=0;for(i=0;i<s;i++)r=t.charCodeAt(i),55296==(64512&r)&&i+1<s&&(n=t.charCodeAt(i+1),56320==(64512&n)&&(r=65536+(r-55296<<10)+(n-56320),i++)),a+=r<128?1:r<2048?2:r<65536?3:4;for(e=new Uint8Array(a),o=0,i=0;o<a;i++)r=t.charCodeAt(i),55296==(64512&r)&&i+1<s&&(n=t.charCodeAt(i+1),56320==(64512&n)&&(r=65536+(r-55296<<10)+(n-56320),i++)),r<128?e[o++]=r:r<2048?(e[o++]=192|r>>>6,e[o++]=128|63&r):r<65536?(e[o++]=224|r>>>12,e[o++]=128|r>>>6&63,e[o++]=128|63&r):(e[o++]=240|r>>>18,e[o++]=128|r>>>12&63,e[o++]=128|r>>>6&63,e[o++]=128|63&r);return e};const buf2binstring=(t,e)=>{if(e<65534&&t.subarray&&STR_APPLY_UIA_OK)return String.fromCharCode.apply(null,t.length===e?t:t.subarray(0,e));let r="";for(let n=0;n<e;n++)r+=String.fromCharCode(t[n]);return r};var buf2string=(t,e)=>{const r=e||t.length;if("function"==typeof TextDecoder&&TextDecoder.prototype.decode)return(new TextDecoder).decode(t.subarray(0,e));let n,i;const o=new Array(2*r);for(i=0,n=0;n<r;){let e=t[n++];if(e<128){o[i++]=e;continue}let s=_utf8len[e];if(s>4)o[i++]=65533,n+=s-1;else{for(e&=2===s?31:3===s?15:7;s>1&&n<r;)e=e<<6|63&t[n++],s--;s>1?o[i++]=65533:e<65536?o[i++]=e:(e-=65536,o[i++]=55296|e>>10&1023,o[i++]=56320|1023&e)}}return buf2binstring(o,i)},utf8border=(t,e)=>{(e=e||t.length)>t.length&&(e=t.length);let r=e-1;for(;r>=0&&128==(192&t[r]);)r--;return r<0||0===r?e:r+_utf8len[t[r]]>e?r:e},strings={string2buf:string2buf,buf2string:buf2string,utf8border:utf8border};function ZStream(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}var zstream=ZStream;const toString$1=Object.prototype.toString,{Z_NO_FLUSH:Z_NO_FLUSH$1,Z_SYNC_FLUSH:Z_SYNC_FLUSH,Z_FULL_FLUSH:Z_FULL_FLUSH,Z_FINISH:Z_FINISH$2,Z_OK:Z_OK$2,Z_STREAM_END:Z_STREAM_END$2,Z_DEFAULT_COMPRESSION:Z_DEFAULT_COMPRESSION,Z_DEFAULT_STRATEGY:Z_DEFAULT_STRATEGY,Z_DEFLATED:Z_DEFLATED$1}=constants$2;function Deflate$1(t){this.options=common.assign({level:Z_DEFAULT_COMPRESSION,method:Z_DEFLATED$1,chunkSize:16384,windowBits:15,memLevel:8,strategy:Z_DEFAULT_STRATEGY},t||{});let e=this.options;e.raw&&e.windowBits>0?e.windowBits=-e.windowBits:e.gzip&&e.windowBits>0&&e.windowBits<16&&(e.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new zstream,this.strm.avail_out=0;let r=deflate_1$2.deflateInit2(this.strm,e.level,e.method,e.windowBits,e.memLevel,e.strategy);if(r!==Z_OK$2)throw new Error(messages[r]);if(e.header&&deflate_1$2.deflateSetHeader(this.strm,e.header),e.dictionary){let t;if(t="string"==typeof e.dictionary?strings.string2buf(e.dictionary):"[object ArrayBuffer]"===toString$1.call(e.dictionary)?new Uint8Array(e.dictionary):e.dictionary,r=deflate_1$2.deflateSetDictionary(this.strm,t),r!==Z_OK$2)throw new Error(messages[r]);this._dict_set=!0}}function deflate$1(t,e){const r=new Deflate$1(e);if(r.push(t,!0),r.err)throw r.msg||messages[r.err];return r.result}Deflate$1.prototype.push=function(t,e){const r=this.strm,n=this.options.chunkSize;let i,o;if(this.ended)return!1;for(o=e===~~e?e:!0===e?Z_FINISH$2:Z_NO_FLUSH$1,"string"==typeof t?r.input=strings.string2buf(t):"[object ArrayBuffer]"===toString$1.call(t)?r.input=new Uint8Array(t):r.input=t,r.next_in=0,r.avail_in=r.input.length;;)if(0===r.avail_out&&(r.output=new Uint8Array(n),r.next_out=0,r.avail_out=n),(o===Z_SYNC_FLUSH||o===Z_FULL_FLUSH)&&r.avail_out<=6)this.onData(r.output.subarray(0,r.next_out)),r.avail_out=0;else{if(i=deflate_1$2.deflate(r,o),i===Z_STREAM_END$2)return r.next_out>0&&this.onData(r.output.subarray(0,r.next_out)),i=deflate_1$2.deflateEnd(this.strm),this.onEnd(i),this.ended=!0,i===Z_OK$2;if(0!==r.avail_out){if(o>0&&r.next_out>0)this.onData(r.output.subarray(0,r.next_out)),r.avail_out=0;else if(0===r.avail_in)break}else this.onData(r.output)}return!0},Deflate$1.prototype.onData=function(t){this.chunks.push(t)},Deflate$1.prototype.onEnd=function(t){t===Z_OK$2&&(this.result=common.flattenChunks(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg};var deflate_2=deflate$1,deflate_1$1={deflate:deflate_2};const BAD$1=16209,TYPE$1=16191;var inffast=function(t,e){let r,n,i,o,s,a,l,h,c,u,f,d,m,g,p,w,b,_,y,x,M,E,v,I;const A=t.state;r=t.next_in,v=t.input,n=r+(t.avail_in-5),i=t.next_out,I=t.output,o=i-(e-t.avail_out),s=i+(t.avail_out-257),a=A.dmax,l=A.wsize,h=A.whave,c=A.wnext,u=A.window,f=A.hold,d=A.bits,m=A.lencode,g=A.distcode,p=(1<<A.lenbits)-1,w=(1<<A.distbits)-1;t:do{d<15&&(f+=v[r++]<<d,d+=8,f+=v[r++]<<d,d+=8),b=m[f&p];e:for(;;){if(_=b>>>24,f>>>=_,d-=_,_=b>>>16&255,0===_)I[i++]=65535&b;else{if(!(16&_)){if(64&_){if(32&_){A.mode=TYPE$1;break t}t.msg="invalid literal/length code",A.mode=BAD$1;break t}b=m[(65535&b)+(f&(1<<_)-1)];continue e}for(y=65535&b,_&=15,_&&(d<_&&(f+=v[r++]<<d,d+=8),y+=f&(1<<_)-1,f>>>=_,d-=_),d<15&&(f+=v[r++]<<d,d+=8,f+=v[r++]<<d,d+=8),b=g[f&w];;){if(_=b>>>24,f>>>=_,d-=_,_=b>>>16&255,16&_){if(x=65535&b,_&=15,d<_&&(f+=v[r++]<<d,d+=8,d<_&&(f+=v[r++]<<d,d+=8)),x+=f&(1<<_)-1,x>a){t.msg="invalid distance too far back",A.mode=BAD$1;break t}if(f>>>=_,d-=_,_=i-o,x>_){if(_=x-_,_>h&&A.sane){t.msg="invalid distance too far back",A.mode=BAD$1;break t}if(M=0,E=u,0===c){if(M+=l-_,_<y){y-=_;do{I[i++]=u[M++]}while(--_);M=i-x,E=I}}else if(c<_){if(M+=l+c-_,_-=c,_<y){y-=_;do{I[i++]=u[M++]}while(--_);if(M=0,c<y){_=c,y-=_;do{I[i++]=u[M++]}while(--_);M=i-x,E=I}}}else if(M+=c-_,_<y){y-=_;do{I[i++]=u[M++]}while(--_);M=i-x,E=I}for(;y>2;)I[i++]=E[M++],I[i++]=E[M++],I[i++]=E[M++],y-=3;y&&(I[i++]=E[M++],y>1&&(I[i++]=E[M++]))}else{M=i-x;do{I[i++]=I[M++],I[i++]=I[M++],I[i++]=I[M++],y-=3}while(y>2);y&&(I[i++]=I[M++],y>1&&(I[i++]=I[M++]))}break}if(64&_){t.msg="invalid distance code",A.mode=BAD$1;break t}b=g[(65535&b)+(f&(1<<_)-1)]}}break}}while(r<n&&i<s);y=d>>3,r-=y,d-=y<<3,f&=(1<<d)-1,t.next_in=r,t.next_out=i,t.avail_in=r<n?n-r+5:5-(r-n),t.avail_out=i<s?s-i+257:257-(i-s),A.hold=f,A.bits=d};const MAXBITS=15,ENOUGH_LENS$1=852,ENOUGH_DISTS$1=592,CODES$1=0,LENS$1=1,DISTS$1=2,lbase=new Uint16Array([3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0]),lext=new Uint8Array([16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78]),dbase=new Uint16Array([1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0]),dext=new Uint8Array([16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64]),inflate_table=(t,e,r,n,i,o,s,a)=>{const l=a.bits;let h,c,u,f,d,m,g=0,p=0,w=0,b=0,_=0,y=0,x=0,M=0,E=0,v=0,I=null;const A=new Uint16Array(MAXBITS+1),S=new Uint16Array(MAXBITS+1);let R,k,T,$=null;for(g=0;g<=MAXBITS;g++)A[g]=0;for(p=0;p<n;p++)A[e[r+p]]++;for(_=l,b=MAXBITS;b>=1&&0===A[b];b--);if(_>b&&(_=b),0===b)return i[o++]=20971520,i[o++]=20971520,a.bits=1,0;for(w=1;w<b&&0===A[w];w++);for(_<w&&(_=w),M=1,g=1;g<=MAXBITS;g++)if(M<<=1,M-=A[g],M<0)return-1;if(M>0&&(t===CODES$1||1!==b))return-1;for(S[1]=0,g=1;g<MAXBITS;g++)S[g+1]=S[g]+A[g];for(p=0;p<n;p++)0!==e[r+p]&&(s[S[e[r+p]]++]=p);if(t===CODES$1?(I=$=s,m=20):t===LENS$1?(I=lbase,$=lext,m=257):(I=dbase,$=dext,m=0),v=0,p=0,g=w,d=o,y=_,x=0,u=-1,E=1<<_,f=E-1,t===LENS$1&&E>ENOUGH_LENS$1||t===DISTS$1&&E>ENOUGH_DISTS$1)return 1;for(;;){R=g-x,s[p]+1<m?(k=0,T=s[p]):s[p]>=m?(k=$[s[p]-m],T=I[s[p]-m]):(k=96,T=0),h=1<<g-x,c=1<<y,w=c;do{c-=h,i[d+(v>>x)+c]=R<<24|k<<16|T}while(0!==c);for(h=1<<g-1;v&h;)h>>=1;if(0!==h?(v&=h-1,v+=h):v=0,p++,0===--A[g]){if(g===b)break;g=e[r+s[p]]}if(g>_&&(v&f)!==u){for(0===x&&(x=_),d+=w,y=g-x,M=1<<y;y+x<b&&(M-=A[y+x],!(M<=0));)y++,M<<=1;if(E+=1<<y,t===LENS$1&&E>ENOUGH_LENS$1||t===DISTS$1&&E>ENOUGH_DISTS$1)return 1;u=v&f,i[u]=_<<24|y<<16|d-o}}return 0!==v&&(i[d+v]=g-x<<24|64<<16),a.bits=_,0};var inftrees=inflate_table;const CODES=0,LENS=1,DISTS=2,{Z_FINISH:Z_FINISH$1,Z_BLOCK:Z_BLOCK,Z_TREES:Z_TREES,Z_OK:Z_OK$1,Z_STREAM_END:Z_STREAM_END$1,Z_NEED_DICT:Z_NEED_DICT$1,Z_STREAM_ERROR:Z_STREAM_ERROR$1,Z_DATA_ERROR:Z_DATA_ERROR$1,Z_MEM_ERROR:Z_MEM_ERROR$1,Z_BUF_ERROR:Z_BUF_ERROR,Z_DEFLATED:Z_DEFLATED}=constants$2,HEAD=16180,FLAGS=16181,TIME=16182,OS=16183,EXLEN=16184,EXTRA=16185,NAME=16186,COMMENT=16187,HCRC=16188,DICTID=16189,DICT=16190,TYPE=16191,TYPEDO=16192,STORED=16193,COPY_=16194,COPY=16195,TABLE=16196,LENLENS=16197,CODELENS=16198,LEN_=16199,LEN=16200,LENEXT=16201,DIST=16202,DISTEXT=16203,MATCH=16204,LIT=16205,CHECK=16206,LENGTH=16207,DONE=16208,BAD=16209,MEM=16210,SYNC=16211,ENOUGH_LENS=852,ENOUGH_DISTS=592,MAX_WBITS=15,DEF_WBITS=MAX_WBITS,zswap32=t=>(t>>>24&255)+(t>>>8&65280)+((65280&t)<<8)+((255&t)<<24);function InflateState(){this.strm=null,this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new Uint16Array(320),this.work=new Uint16Array(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}const inflateStateCheck=t=>{if(!t)return 1;const e=t.state;return!e||e.strm!==t||e.mode<HEAD||e.mode>SYNC?1:0},inflateResetKeep=t=>{if(inflateStateCheck(t))return Z_STREAM_ERROR$1;const e=t.state;return t.total_in=t.total_out=e.total=0,t.msg="",e.wrap&&(t.adler=1&e.wrap),e.mode=HEAD,e.last=0,e.havedict=0,e.flags=-1,e.dmax=32768,e.head=null,e.hold=0,e.bits=0,e.lencode=e.lendyn=new Int32Array(ENOUGH_LENS),e.distcode=e.distdyn=new Int32Array(ENOUGH_DISTS),e.sane=1,e.back=-1,Z_OK$1},inflateReset=t=>{if(inflateStateCheck(t))return Z_STREAM_ERROR$1;const e=t.state;return e.wsize=0,e.whave=0,e.wnext=0,inflateResetKeep(t)},inflateReset2=(t,e)=>{let r;if(inflateStateCheck(t))return Z_STREAM_ERROR$1;const n=t.state;return e<0?(r=0,e=-e):(r=5+(e>>4),e<48&&(e&=15)),e&&(e<8||e>15)?Z_STREAM_ERROR$1:(null!==n.window&&n.wbits!==e&&(n.window=null),n.wrap=r,n.wbits=e,inflateReset(t))},inflateInit2=(t,e)=>{if(!t)return Z_STREAM_ERROR$1;const r=new InflateState;t.state=r,r.strm=t,r.window=null,r.mode=HEAD;const n=inflateReset2(t,e);return n!==Z_OK$1&&(t.state=null),n},inflateInit=t=>inflateInit2(t,DEF_WBITS);let virgin=!0,lenfix,distfix;const fixedtables=t=>{if(virgin){lenfix=new Int32Array(512),distfix=new Int32Array(32);let e=0;for(;e<144;)t.lens[e++]=8;for(;e<256;)t.lens[e++]=9;for(;e<280;)t.lens[e++]=7;for(;e<288;)t.lens[e++]=8;for(inftrees(LENS,t.lens,0,288,lenfix,0,t.work,{bits:9}),e=0;e<32;)t.lens[e++]=5;inftrees(DISTS,t.lens,0,32,distfix,0,t.work,{bits:5}),virgin=!1}t.lencode=lenfix,t.lenbits=9,t.distcode=distfix,t.distbits=5},updatewindow=(t,e,r,n)=>{let i;const o=t.state;return null===o.window&&(o.wsize=1<<o.wbits,o.wnext=0,o.whave=0,o.window=new Uint8Array(o.wsize)),n>=o.wsize?(o.window.set(e.subarray(r-o.wsize,r),0),o.wnext=0,o.whave=o.wsize):(i=o.wsize-o.wnext,i>n&&(i=n),o.window.set(e.subarray(r-n,r-n+i),o.wnext),(n-=i)?(o.window.set(e.subarray(r-n,r),0),o.wnext=n,o.whave=o.wsize):(o.wnext+=i,o.wnext===o.wsize&&(o.wnext=0),o.whave<o.wsize&&(o.whave+=i))),0},inflate$2=(t,e)=>{let r,n,i,o,s,a,l,h,c,u,f,d,m,g,p,w,b,_,y,x,M,E,v=0;const I=new Uint8Array(4);let A,S;const R=new Uint8Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]);if(inflateStateCheck(t)||!t.output||!t.input&&0!==t.avail_in)return Z_STREAM_ERROR$1;r=t.state,r.mode===TYPE&&(r.mode=TYPEDO),s=t.next_out,i=t.output,l=t.avail_out,o=t.next_in,n=t.input,a=t.avail_in,h=r.hold,c=r.bits,u=a,f=l,E=Z_OK$1;t:for(;;)switch(r.mode){case HEAD:if(0===r.wrap){r.mode=TYPEDO;break}for(;c<16;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(2&r.wrap&&35615===h){0===r.wbits&&(r.wbits=15),r.check=0,I[0]=255&h,I[1]=h>>>8&255,r.check=crc32_1(r.check,I,2,0),h=0,c=0,r.mode=FLAGS;break}if(r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&h)<<8)+(h>>8))%31){t.msg="incorrect header check",r.mode=BAD;break}if((15&h)!==Z_DEFLATED){t.msg="unknown compression method",r.mode=BAD;break}if(h>>>=4,c-=4,M=8+(15&h),0===r.wbits&&(r.wbits=M),M>15||M>r.wbits){t.msg="invalid window size",r.mode=BAD;break}r.dmax=1<<r.wbits,r.flags=0,t.adler=r.check=1,r.mode=512&h?DICTID:TYPE,h=0,c=0;break;case FLAGS:for(;c<16;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(r.flags=h,(255&r.flags)!==Z_DEFLATED){t.msg="unknown compression method",r.mode=BAD;break}if(57344&r.flags){t.msg="unknown header flags set",r.mode=BAD;break}r.head&&(r.head.text=h>>8&1),512&r.flags&&4&r.wrap&&(I[0]=255&h,I[1]=h>>>8&255,r.check=crc32_1(r.check,I,2,0)),h=0,c=0,r.mode=TIME;case TIME:for(;c<32;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}r.head&&(r.head.time=h),512&r.flags&&4&r.wrap&&(I[0]=255&h,I[1]=h>>>8&255,I[2]=h>>>16&255,I[3]=h>>>24&255,r.check=crc32_1(r.check,I,4,0)),h=0,c=0,r.mode=OS;case OS:for(;c<16;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}r.head&&(r.head.xflags=255&h,r.head.os=h>>8),512&r.flags&&4&r.wrap&&(I[0]=255&h,I[1]=h>>>8&255,r.check=crc32_1(r.check,I,2,0)),h=0,c=0,r.mode=EXLEN;case EXLEN:if(1024&r.flags){for(;c<16;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}r.length=h,r.head&&(r.head.extra_len=h),512&r.flags&&4&r.wrap&&(I[0]=255&h,I[1]=h>>>8&255,r.check=crc32_1(r.check,I,2,0)),h=0,c=0}else r.head&&(r.head.extra=null);r.mode=EXTRA;case EXTRA:if(1024&r.flags&&(d=r.length,d>a&&(d=a),d&&(r.head&&(M=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Uint8Array(r.head.extra_len)),r.head.extra.set(n.subarray(o,o+d),M)),512&r.flags&&4&r.wrap&&(r.check=crc32_1(r.check,n,d,o)),a-=d,o+=d,r.length-=d),r.length))break t;r.length=0,r.mode=NAME;case NAME:if(2048&r.flags){if(0===a)break t;d=0;do{M=n[o+d++],r.head&&M&&r.length<65536&&(r.head.name+=String.fromCharCode(M))}while(M&&d<a);if(512&r.flags&&4&r.wrap&&(r.check=crc32_1(r.check,n,d,o)),a-=d,o+=d,M)break t}else r.head&&(r.head.name=null);r.length=0,r.mode=COMMENT;case COMMENT:if(4096&r.flags){if(0===a)break t;d=0;do{M=n[o+d++],r.head&&M&&r.length<65536&&(r.head.comment+=String.fromCharCode(M))}while(M&&d<a);if(512&r.flags&&4&r.wrap&&(r.check=crc32_1(r.check,n,d,o)),a-=d,o+=d,M)break t}else r.head&&(r.head.comment=null);r.mode=HCRC;case HCRC:if(512&r.flags){for(;c<16;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(4&r.wrap&&h!==(65535&r.check)){t.msg="header crc mismatch",r.mode=BAD;break}h=0,c=0}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),t.adler=r.check=0,r.mode=TYPE;break;case DICTID:for(;c<32;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}t.adler=r.check=zswap32(h),h=0,c=0,r.mode=DICT;case DICT:if(0===r.havedict)return t.next_out=s,t.avail_out=l,t.next_in=o,t.avail_in=a,r.hold=h,r.bits=c,Z_NEED_DICT$1;t.adler=r.check=1,r.mode=TYPE;case TYPE:if(e===Z_BLOCK||e===Z_TREES)break t;case TYPEDO:if(r.last){h>>>=7&c,c-=7&c,r.mode=CHECK;break}for(;c<3;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}switch(r.last=1&h,h>>>=1,c-=1,3&h){case 0:r.mode=STORED;break;case 1:if(fixedtables(r),r.mode=LEN_,e===Z_TREES){h>>>=2,c-=2;break t}break;case 2:r.mode=TABLE;break;case 3:t.msg="invalid block type",r.mode=BAD}h>>>=2,c-=2;break;case STORED:for(h>>>=7&c,c-=7&c;c<32;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if((65535&h)!=(h>>>16^65535)){t.msg="invalid stored block lengths",r.mode=BAD;break}if(r.length=65535&h,h=0,c=0,r.mode=COPY_,e===Z_TREES)break t;case COPY_:r.mode=COPY;case COPY:if(d=r.length,d){if(d>a&&(d=a),d>l&&(d=l),0===d)break t;i.set(n.subarray(o,o+d),s),a-=d,o+=d,l-=d,s+=d,r.length-=d;break}r.mode=TYPE;break;case TABLE:for(;c<14;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(r.nlen=257+(31&h),h>>>=5,c-=5,r.ndist=1+(31&h),h>>>=5,c-=5,r.ncode=4+(15&h),h>>>=4,c-=4,r.nlen>286||r.ndist>30){t.msg="too many length or distance symbols",r.mode=BAD;break}r.have=0,r.mode=LENLENS;case LENLENS:for(;r.have<r.ncode;){for(;c<3;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}r.lens[R[r.have++]]=7&h,h>>>=3,c-=3}for(;r.have<19;)r.lens[R[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,A={bits:r.lenbits},E=inftrees(CODES,r.lens,0,19,r.lencode,0,r.work,A),r.lenbits=A.bits,E){t.msg="invalid code lengths set",r.mode=BAD;break}r.have=0,r.mode=CODELENS;case CODELENS:for(;r.have<r.nlen+r.ndist;){for(;v=r.lencode[h&(1<<r.lenbits)-1],p=v>>>24,w=v>>>16&255,b=65535&v,!(p<=c);){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(b<16)h>>>=p,c-=p,r.lens[r.have++]=b;else{if(16===b){for(S=p+2;c<S;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(h>>>=p,c-=p,0===r.have){t.msg="invalid bit length repeat",r.mode=BAD;break}M=r.lens[r.have-1],d=3+(3&h),h>>>=2,c-=2}else if(17===b){for(S=p+3;c<S;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}h>>>=p,c-=p,M=0,d=3+(7&h),h>>>=3,c-=3}else{for(S=p+7;c<S;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}h>>>=p,c-=p,M=0,d=11+(127&h),h>>>=7,c-=7}if(r.have+d>r.nlen+r.ndist){t.msg="invalid bit length repeat",r.mode=BAD;break}for(;d--;)r.lens[r.have++]=M}}if(r.mode===BAD)break;if(0===r.lens[256]){t.msg="invalid code -- missing end-of-block",r.mode=BAD;break}if(r.lenbits=9,A={bits:r.lenbits},E=inftrees(LENS,r.lens,0,r.nlen,r.lencode,0,r.work,A),r.lenbits=A.bits,E){t.msg="invalid literal/lengths set",r.mode=BAD;break}if(r.distbits=6,r.distcode=r.distdyn,A={bits:r.distbits},E=inftrees(DISTS,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,A),r.distbits=A.bits,E){t.msg="invalid distances set",r.mode=BAD;break}if(r.mode=LEN_,e===Z_TREES)break t;case LEN_:r.mode=LEN;case LEN:if(a>=6&&l>=258){t.next_out=s,t.avail_out=l,t.next_in=o,t.avail_in=a,r.hold=h,r.bits=c,inffast(t,f),s=t.next_out,i=t.output,l=t.avail_out,o=t.next_in,n=t.input,a=t.avail_in,h=r.hold,c=r.bits,r.mode===TYPE&&(r.back=-1);break}for(r.back=0;v=r.lencode[h&(1<<r.lenbits)-1],p=v>>>24,w=v>>>16&255,b=65535&v,!(p<=c);){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(w&&!(240&w)){for(_=p,y=w,x=b;v=r.lencode[x+((h&(1<<_+y)-1)>>_)],p=v>>>24,w=v>>>16&255,b=65535&v,!(_+p<=c);){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}h>>>=_,c-=_,r.back+=_}if(h>>>=p,c-=p,r.back+=p,r.length=b,0===w){r.mode=LIT;break}if(32&w){r.back=-1,r.mode=TYPE;break}if(64&w){t.msg="invalid literal/length code",r.mode=BAD;break}r.extra=15&w,r.mode=LENEXT;case LENEXT:if(r.extra){for(S=r.extra;c<S;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}r.length+=h&(1<<r.extra)-1,h>>>=r.extra,c-=r.extra,r.back+=r.extra}r.was=r.length,r.mode=DIST;case DIST:for(;v=r.distcode[h&(1<<r.distbits)-1],p=v>>>24,w=v>>>16&255,b=65535&v,!(p<=c);){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(!(240&w)){for(_=p,y=w,x=b;v=r.distcode[x+((h&(1<<_+y)-1)>>_)],p=v>>>24,w=v>>>16&255,b=65535&v,!(_+p<=c);){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}h>>>=_,c-=_,r.back+=_}if(h>>>=p,c-=p,r.back+=p,64&w){t.msg="invalid distance code",r.mode=BAD;break}r.offset=b,r.extra=15&w,r.mode=DISTEXT;case DISTEXT:if(r.extra){for(S=r.extra;c<S;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}r.offset+=h&(1<<r.extra)-1,h>>>=r.extra,c-=r.extra,r.back+=r.extra}if(r.offset>r.dmax){t.msg="invalid distance too far back",r.mode=BAD;break}r.mode=MATCH;case MATCH:if(0===l)break t;if(d=f-l,r.offset>d){if(d=r.offset-d,d>r.whave&&r.sane){t.msg="invalid distance too far back",r.mode=BAD;break}d>r.wnext?(d-=r.wnext,m=r.wsize-d):m=r.wnext-d,d>r.length&&(d=r.length),g=r.window}else g=i,m=s-r.offset,d=r.length;d>l&&(d=l),l-=d,r.length-=d;do{i[s++]=g[m++]}while(--d);0===r.length&&(r.mode=LEN);break;case LIT:if(0===l)break t;i[s++]=r.length,l--,r.mode=LEN;break;case CHECK:if(r.wrap){for(;c<32;){if(0===a)break t;a--,h|=n[o++]<<c,c+=8}if(f-=l,t.total_out+=f,r.total+=f,4&r.wrap&&f&&(t.adler=r.check=r.flags?crc32_1(r.check,i,f,s-f):adler32_1(r.check,i,f,s-f)),f=l,4&r.wrap&&(r.flags?h:zswap32(h))!==r.check){t.msg="incorrect data check",r.mode=BAD;break}h=0,c=0}r.mode=LENGTH;case LENGTH:if(r.wrap&&r.flags){for(;c<32;){if(0===a)break t;a--,h+=n[o++]<<c,c+=8}if(4&r.wrap&&h!==(4294967295&r.total)){t.msg="incorrect length check",r.mode=BAD;break}h=0,c=0}r.mode=DONE;case DONE:E=Z_STREAM_END$1;break t;case BAD:E=Z_DATA_ERROR$1;break t;case MEM:return Z_MEM_ERROR$1;default:return Z_STREAM_ERROR$1}return t.next_out=s,t.avail_out=l,t.next_in=o,t.avail_in=a,r.hold=h,r.bits=c,(r.wsize||f!==t.avail_out&&r.mode<BAD&&(r.mode<CHECK||e!==Z_FINISH$1))&&updatewindow(t,t.output,t.next_out,f-t.avail_out),u-=t.avail_in,f-=t.avail_out,t.total_in+=u,t.total_out+=f,r.total+=f,4&r.wrap&&f&&(t.adler=r.check=r.flags?crc32_1(r.check,i,f,t.next_out-f):adler32_1(r.check,i,f,t.next_out-f)),t.data_type=r.bits+(r.last?64:0)+(r.mode===TYPE?128:0)+(r.mode===LEN_||r.mode===COPY_?256:0),(0===u&&0===f||e===Z_FINISH$1)&&E===Z_OK$1&&(E=Z_BUF_ERROR),E},inflateEnd=t=>{if(inflateStateCheck(t))return Z_STREAM_ERROR$1;let e=t.state;return e.window&&(e.window=null),t.state=null,Z_OK$1},inflateGetHeader=(t,e)=>{if(inflateStateCheck(t))return Z_STREAM_ERROR$1;const r=t.state;return 2&r.wrap?(r.head=e,e.done=!1,Z_OK$1):Z_STREAM_ERROR$1},inflateSetDictionary=(t,e)=>{const r=e.length;let n,i,o;return inflateStateCheck(t)?Z_STREAM_ERROR$1:(n=t.state,0!==n.wrap&&n.mode!==DICT?Z_STREAM_ERROR$1:n.mode===DICT&&(i=1,i=adler32_1(i,e,r,0),i!==n.check)?Z_DATA_ERROR$1:(o=updatewindow(t,e,r,r),o?(n.mode=MEM,Z_MEM_ERROR$1):(n.havedict=1,Z_OK$1)))};var inflateReset_1=inflateReset,inflateReset2_1=inflateReset2,inflateResetKeep_1=inflateResetKeep,inflateInit_1=inflateInit,inflateInit2_1=inflateInit2,inflate_2$1=inflate$2,inflateEnd_1=inflateEnd,inflateGetHeader_1=inflateGetHeader,inflateSetDictionary_1=inflateSetDictionary,inflateInfo="pako inflate (from Nodeca project)",inflate_1$2={inflateReset:inflateReset_1,inflateReset2:inflateReset2_1,inflateResetKeep:inflateResetKeep_1,inflateInit:inflateInit_1,inflateInit2:inflateInit2_1,inflate:inflate_2$1,inflateEnd:inflateEnd_1,inflateGetHeader:inflateGetHeader_1,inflateSetDictionary:inflateSetDictionary_1,inflateInfo:inflateInfo};function GZheader(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}var gzheader=GZheader;const toString=Object.prototype.toString,{Z_NO_FLUSH:Z_NO_FLUSH,Z_FINISH:Z_FINISH,Z_OK:Z_OK,Z_STREAM_END:Z_STREAM_END,Z_NEED_DICT:Z_NEED_DICT,Z_STREAM_ERROR:Z_STREAM_ERROR,Z_DATA_ERROR:Z_DATA_ERROR,Z_MEM_ERROR:Z_MEM_ERROR}=constants$2;function Inflate$1(t){this.options=common.assign({chunkSize:65536,windowBits:15,to:""},t||{});const e=this.options;e.raw&&e.windowBits>=0&&e.windowBits<16&&(e.windowBits=-e.windowBits,0===e.windowBits&&(e.windowBits=-15)),!(e.windowBits>=0&&e.windowBits<16)||t&&t.windowBits||(e.windowBits+=32),e.windowBits>15&&e.windowBits<48&&(15&e.windowBits||(e.windowBits|=15)),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new zstream,this.strm.avail_out=0;let r=inflate_1$2.inflateInit2(this.strm,e.windowBits);if(r!==Z_OK)throw new Error(messages[r]);if(this.header=new gzheader,inflate_1$2.inflateGetHeader(this.strm,this.header),e.dictionary&&("string"==typeof e.dictionary?e.dictionary=strings.string2buf(e.dictionary):"[object ArrayBuffer]"===toString.call(e.dictionary)&&(e.dictionary=new Uint8Array(e.dictionary)),e.raw&&(r=inflate_1$2.inflateSetDictionary(this.strm,e.dictionary),r!==Z_OK)))throw new Error(messages[r])}function inflate$1(t,e){const r=new Inflate$1(e);if(r.push(t),r.err)throw r.msg||messages[r.err];return r.result}Inflate$1.prototype.push=function(t,e){const r=this.strm,n=this.options.chunkSize,i=this.options.dictionary;let o,s,a;if(this.ended)return!1;for(s=e===~~e?e:!0===e?Z_FINISH:Z_NO_FLUSH,"[object ArrayBuffer]"===toString.call(t)?r.input=new Uint8Array(t):r.input=t,r.next_in=0,r.avail_in=r.input.length;;){for(0===r.avail_out&&(r.output=new Uint8Array(n),r.next_out=0,r.avail_out=n),o=inflate_1$2.inflate(r,s),o===Z_NEED_DICT&&i&&(o=inflate_1$2.inflateSetDictionary(r,i),o===Z_OK?o=inflate_1$2.inflate(r,s):o===Z_DATA_ERROR&&(o=Z_NEED_DICT));r.avail_in>0&&o===Z_STREAM_END&&r.state.wrap>0&&0!==t[r.next_in];)inflate_1$2.inflateReset(r),o=inflate_1$2.inflate(r,s);switch(o){case Z_STREAM_ERROR:case Z_DATA_ERROR:case Z_NEED_DICT:case Z_MEM_ERROR:return this.onEnd(o),this.ended=!0,!1}if(a=r.avail_out,r.next_out&&(0===r.avail_out||o===Z_STREAM_END))if("string"===this.options.to){let t=strings.utf8border(r.output,r.next_out),e=r.next_out-t,i=strings.buf2string(r.output,t);r.next_out=e,r.avail_out=n-e,e&&r.output.set(r.output.subarray(t,t+e),0),this.onData(i)}else this.onData(r.output.length===r.next_out?r.output:r.output.subarray(0,r.next_out));if(o!==Z_OK||0!==a){if(o===Z_STREAM_END)return o=inflate_1$2.inflateEnd(this.strm),this.onEnd(o),this.ended=!0,!0;if(0===r.avail_in)break}}return!0},Inflate$1.prototype.onData=function(t){this.chunks.push(t)},Inflate$1.prototype.onEnd=function(t){t===Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=common.flattenChunks(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg};var Inflate_1$1=Inflate$1,inflate_2=inflate$1,inflate_1$1={Inflate:Inflate_1$1,inflate:inflate_2};const{deflate:deflate}=deflate_1$1,{Inflate:Inflate,inflate:inflate}=inflate_1$1;var deflate_1=deflate,Inflate_1=Inflate,inflate_1=inflate;const crcTable=[];for(let t=0;t<256;t++){let e=t;for(let t=0;t<8;t++)1&e?e=3988292384^e>>>1:e>>>=1;crcTable[t]=e}const initialCrc=4294967295;function updateCrc(t,e,r){let n=t;for(let t=0;t<r;t++)n=crcTable[255&(n^e[t])]^n>>>8;return n}function crc(t,e){return(updateCrc(initialCrc,t,e)^initialCrc)>>>0}function checkCrc(t,e,r){const n=t.readUint32(),i=crc(new Uint8Array(t.buffer,t.byteOffset+t.offset-e-4,e),e);if(i!==n)throw new Error(`CRC mismatch for chunk ${r}. Expected ${n}, found ${i}`)}function writeCrc(t,e){t.writeUint32(crc(new Uint8Array(t.buffer,t.byteOffset+t.offset-e,e),e))}function unfilterNone(t,e,r){for(let n=0;n<r;n++)e[n]=t[n]}function unfilterSub(t,e,r,n){let i=0;for(;i<n;i++)e[i]=t[i];for(;i<r;i++)e[i]=t[i]+e[i-n]&255}function unfilterUp(t,e,r,n){let i=0;if(0===r.length)for(;i<n;i++)e[i]=t[i];else for(;i<n;i++)e[i]=t[i]+r[i]&255}function unfilterAverage(t,e,r,n,i){let o=0;if(0===r.length){for(;o<i;o++)e[o]=t[o];for(;o<n;o++)e[o]=t[o]+(e[o-i]>>1)&255}else{for(;o<i;o++)e[o]=t[o]+(r[o]>>1)&255;for(;o<n;o++)e[o]=t[o]+(e[o-i]+r[o]>>1)&255}}function unfilterPaeth(t,e,r,n,i){let o=0;if(0===r.length){for(;o<i;o++)e[o]=t[o];for(;o<n;o++)e[o]=t[o]+e[o-i]&255}else{for(;o<i;o++)e[o]=t[o]+r[o]&255;for(;o<n;o++)e[o]=t[o]+paethPredictor(e[o-i],r[o],r[o-i])&255}}function paethPredictor(t,e,r){const n=t+e-r,i=Math.abs(n-t),o=Math.abs(n-e),s=Math.abs(n-r);return i<=o&&i<=s?t:o<=s?e:r}function applyUnfilter(t,e,r,n,i,o){switch(t){case 0:unfilterNone(e,r,i);break;case 1:unfilterSub(e,r,i,o);break;case 2:unfilterUp(e,r,n,i);break;case 3:unfilterAverage(e,r,n,i,o);break;case 4:unfilterPaeth(e,r,n,i,o);break;default:throw new Error(`Unsupported filter: ${t}`)}}const uint16$1=new Uint16Array([255]),uint8$1=new Uint8Array(uint16$1.buffer),osIsLittleEndian$1=255===uint8$1[0];function decodeInterlaceAdam7(t){const{data:e,width:r,height:n,channels:i,depth:o}=t,s=[{x:0,y:0,xStep:8,yStep:8},{x:4,y:0,xStep:8,yStep:8},{x:0,y:4,xStep:4,yStep:8},{x:2,y:0,xStep:4,yStep:4},{x:0,y:2,xStep:2,yStep:4},{x:1,y:0,xStep:2,yStep:2},{x:0,y:1,xStep:1,yStep:2}],a=Math.ceil(o/8)*i,l=new Uint8Array(n*r*a);let h=0;for(let t=0;t<7;t++){const i=s[t],o=Math.ceil((r-i.x)/i.xStep),c=Math.ceil((n-i.y)/i.yStep);if(o<=0||c<=0)continue;const u=o*a,f=new Uint8Array(u);for(let t=0;t<c;t++){const s=e[h++],c=e.subarray(h,h+u);h+=u;const d=new Uint8Array(u);applyUnfilter(s,c,d,f,u,a),f.set(d);for(let e=0;e<o;e++){const o=i.x+e*i.xStep,s=i.y+t*i.yStep;if(!(o>=r||s>=n))for(let t=0;t<a;t++)l[(s*r+o)*a+t]=d[e*a+t]}}}if(16===o){const t=new Uint16Array(l.buffer);if(osIsLittleEndian$1)for(let e=0;e<t.length;e++)t[e]=swap16$1(t[e]);return t}return l}function swap16$1(t){return(255&t)<<8|t>>8&255}const uint16=new Uint16Array([255]),uint8=new Uint8Array(uint16.buffer),osIsLittleEndian=255===uint8[0],empty=new Uint8Array(0);function decodeInterlaceNull(t){const{data:e,width:r,height:n,channels:i,depth:o}=t,s=Math.ceil(o/8)*i,a=Math.ceil(o/8*i*r),l=new Uint8Array(n*a);let h,c,u=empty,f=0;for(let t=0;t<n;t++){switch(h=e.subarray(f+1,f+1+a),c=l.subarray(t*a,(t+1)*a),e[f]){case 0:unfilterNone(h,c,a);break;case 1:unfilterSub(h,c,a,s);break;case 2:unfilterUp(h,c,u,a);break;case 3:unfilterAverage(h,c,u,a,s);break;case 4:unfilterPaeth(h,c,u,a,s);break;default:throw new Error(`Unsupported filter: ${e[f]}`)}u=c,f+=a+1}if(16===o){const t=new Uint16Array(l.buffer);if(osIsLittleEndian)for(let e=0;e<t.length;e++)t[e]=swap16(t[e]);return t}return l}function swap16(t){return(255&t)<<8|t>>8&255}const pngSignature=Uint8Array.of(137,80,78,71,13,10,26,10);function writeSignature(t){t.writeBytes(pngSignature)}function checkSignature(t){if(!hasPngSignature(t.readBytes(pngSignature.length)))throw new Error("wrong PNG signature")}function hasPngSignature(t){if(t.length<pngSignature.length)return!1;for(let e=0;e<pngSignature.length;e++)if(t[e]!==pngSignature[e])return!1;return!0}const textChunkName="tEXt",NULL=0,latin1Decoder=new TextDecoder("latin1");function validateKeyword(t){if(validateLatin1(t),0===t.length||t.length>79)throw new Error("keyword length must be between 1 and 79")}const latin1Regex=/^[\u0000-\u00FF]*$/;function validateLatin1(t){if(!latin1Regex.test(t))throw new Error("invalid latin1 text")}function decodetEXt(t,e,r){const n=readKeyword(e);t[n]=readLatin1(e,r-n.length-1)}function encodetEXt(t,e,r){validateKeyword(e),validateLatin1(r);const n=e.length+1+r.length;t.writeUint32(n),t.writeChars(textChunkName),t.writeChars(e),t.writeByte(NULL),t.writeChars(r),writeCrc(t,n+4)}function readKeyword(t){for(t.mark();t.readByte()!==NULL;);const e=t.offset;t.reset();const r=latin1Decoder.decode(t.readBytes(e-t.offset-1));return t.skip(1),validateKeyword(r),r}function readLatin1(t,e){return latin1Decoder.decode(t.readBytes(e))}const ColorType={UNKNOWN:-1,GREYSCALE:0,TRUECOLOUR:2,INDEXED_COLOUR:3,GREYSCALE_ALPHA:4,TRUECOLOUR_ALPHA:6},CompressionMethod={UNKNOWN:-1,DEFLATE:0},FilterMethod={UNKNOWN:-1,ADAPTIVE:0},InterlaceMethod={UNKNOWN:-1,NO_INTERLACE:0,ADAM7:1},DisposeOpType={NONE:0,BACKGROUND:1,PREVIOUS:2},BlendOpType={SOURCE:0,OVER:1};class PngDecoder extends IOBuffer{_checkCrc;_inflator;_png;_apng;_end;_hasPalette;_palette;_hasTransparency;_transparency;_compressionMethod;_filterMethod;_interlaceMethod;_colorType;_isAnimated;_numberOfFrames;_numberOfPlays;_frames;_writingDataChunks;constructor(t,e={}){super(t);const{checkCrc:r=!1}=e;this._checkCrc=r,this._inflator=new Inflate_1,this._png={width:-1,height:-1,channels:-1,data:new Uint8Array(0),depth:1,text:{}},this._apng={width:-1,height:-1,channels:-1,depth:1,numberOfFrames:1,numberOfPlays:0,text:{},frames:[]},this._end=!1,this._hasPalette=!1,this._palette=[],this._hasTransparency=!1,this._transparency=new Uint16Array(0),this._compressionMethod=CompressionMethod.UNKNOWN,this._filterMethod=FilterMethod.UNKNOWN,this._interlaceMethod=InterlaceMethod.UNKNOWN,this._colorType=ColorType.UNKNOWN,this._isAnimated=!1,this._numberOfFrames=1,this._numberOfPlays=0,this._frames=[],this._writingDataChunks=!1,this.setBigEndian()}decode(){for(checkSignature(this);!this._end;){const t=this.readUint32(),e=this.readChars(4);this.decodeChunk(t,e)}return this.decodeImage(),this._png}decodeApng(){for(checkSignature(this);!this._end;){const t=this.readUint32(),e=this.readChars(4);this.decodeApngChunk(t,e)}return this.decodeApngImage(),this._apng}decodeChunk(t,e){const r=this.offset;switch(e){case"IHDR":this.decodeIHDR();break;case"PLTE":this.decodePLTE(t);break;case"IDAT":this.decodeIDAT(t);break;case"IEND":this._end=!0;break;case"tRNS":this.decodetRNS(t);break;case"iCCP":this.decodeiCCP(t);break;case textChunkName:decodetEXt(this._png.text,this,t);break;case"pHYs":this.decodepHYs();break;default:this.skip(t)}if(this.offset-r!==t)throw new Error(`Length mismatch while decoding chunk ${e}`);this._checkCrc?checkCrc(this,t+4,e):this.skip(4)}decodeApngChunk(t,e){const r=this.offset;switch("fdAT"!==e&&"IDAT"!==e&&this._writingDataChunks&&this.pushDataToFrame(),e){case"acTL":this.decodeACTL();break;case"fcTL":this.decodeFCTL();break;case"fdAT":this.decodeFDAT(t);break;default:this.decodeChunk(t,e),this.offset=r+t}if(this.offset-r!==t)throw new Error(`Length mismatch while decoding chunk ${e}`);this._checkCrc?checkCrc(this,t+4,e):this.skip(4)}decodeIHDR(){const t=this._png;t.width=this.readUint32(),t.height=this.readUint32(),t.depth=checkBitDepth(this.readUint8());const e=this.readUint8();let r;switch(this._colorType=e,e){case ColorType.GREYSCALE:r=1;break;case ColorType.TRUECOLOUR:r=3;break;case ColorType.INDEXED_COLOUR:r=1;break;case ColorType.GREYSCALE_ALPHA:r=2;break;case ColorType.TRUECOLOUR_ALPHA:r=4;break;case ColorType.UNKNOWN:default:throw new Error(`Unknown color type: ${e}`)}if(this._png.channels=r,this._compressionMethod=this.readUint8(),this._compressionMethod!==CompressionMethod.DEFLATE)throw new Error(`Unsupported compression method: ${this._compressionMethod}`);this._filterMethod=this.readUint8(),this._interlaceMethod=this.readUint8()}decodeACTL(){this._numberOfFrames=this.readUint32(),this._numberOfPlays=this.readUint32(),this._isAnimated=!0}decodeFCTL(){const t={sequenceNumber:this.readUint32(),width:this.readUint32(),height:this.readUint32(),xOffset:this.readUint32(),yOffset:this.readUint32(),delayNumber:this.readUint16(),delayDenominator:this.readUint16(),disposeOp:this.readUint8(),blendOp:this.readUint8(),data:new Uint8Array(0)};this._frames.push(t)}decodePLTE(t){if(t%3!=0)throw new RangeError(`PLTE field length must be a multiple of 3. Got ${t}`);const e=t/3;this._hasPalette=!0;const r=[];this._palette=r;for(let t=0;t<e;t++)r.push([this.readUint8(),this.readUint8(),this.readUint8()])}decodeIDAT(t){this._writingDataChunks=!0;const e=t,r=this.offset+this.byteOffset;if(this._inflator.push(new Uint8Array(this.buffer,r,e)),this._inflator.err)throw new Error(`Error while decompressing the data: ${this._inflator.err}`);this.skip(t)}decodeFDAT(t){this._writingDataChunks=!0;let e=t,r=this.offset+this.byteOffset;if(r+=4,e-=4,this._inflator.push(new Uint8Array(this.buffer,r,e)),this._inflator.err)throw new Error(`Error while decompressing the data: ${this._inflator.err}`);this.skip(t)}decodetRNS(t){switch(this._colorType){case ColorType.GREYSCALE:case ColorType.TRUECOLOUR:if(t%2!=0)throw new RangeError(`tRNS chunk length must be a multiple of 2. Got ${t}`);if(t/2>this._png.width*this._png.height)throw new Error(`tRNS chunk contains more alpha values than there are pixels (${t/2} vs ${this._png.width*this._png.height})`);this._hasTransparency=!0,this._transparency=new Uint16Array(t/2);for(let e=0;e<t/2;e++)this._transparency[e]=this.readUint16();break;case ColorType.INDEXED_COLOUR:{if(t>this._palette.length)throw new Error(`tRNS chunk contains more alpha values than there are palette colors (${t} vs ${this._palette.length})`);let e=0;for(;e<t;e++){const t=this.readByte();this._palette[e].push(t)}for(;e<this._palette.length;e++)this._palette[e].push(255);break}case ColorType.UNKNOWN:case ColorType.GREYSCALE_ALPHA:case ColorType.TRUECOLOUR_ALPHA:default:throw new Error(`tRNS chunk is not supported for color type ${this._colorType}`)}}decodeiCCP(t){const e=readKeyword(this),r=this.readUint8();if(r!==CompressionMethod.DEFLATE)throw new Error(`Unsupported iCCP compression method: ${r}`);const n=this.readBytes(t-e.length-2);this._png.iccEmbeddedProfile={name:e,profile:inflate_1(n)}}decodepHYs(){const t=this.readUint32(),e=this.readUint32(),r=this.readByte();this._png.resolution={x:t,y:e,unit:r}}decodeApngImage(){this._apng.width=this._png.width,this._apng.height=this._png.height,this._apng.channels=this._png.channels,this._apng.depth=this._png.depth,this._apng.numberOfFrames=this._numberOfFrames,this._apng.numberOfPlays=this._numberOfPlays,this._apng.text=this._png.text,this._apng.resolution=this._png.resolution;for(let t=0;t<this._numberOfFrames;t++){const e={sequenceNumber:this._frames[t].sequenceNumber,delayNumber:this._frames[t].delayNumber,delayDenominator:this._frames[t].delayDenominator,data:8===this._apng.depth?new Uint8Array(this._apng.width*this._apng.height*this._apng.channels):new Uint16Array(this._apng.width*this._apng.height*this._apng.channels)},r=this._frames.at(t);if(r){if(r.data=decodeInterlaceNull({data:r.data,width:r.width,height:r.height,channels:this._apng.channels,depth:this._apng.depth}),this._hasPalette&&(this._apng.palette=this._palette),this._hasTransparency&&(this._apng.transparency=this._transparency),0===t||0===r.xOffset&&0===r.yOffset&&r.width===this._png.width&&r.height===this._png.height)e.data=r.data;else{const n=this._apng.frames.at(t-1);this.disposeFrame(r,n,e),this.addFrameDataToCanvas(e,r)}this._apng.frames.push(e)}}return this._apng}disposeFrame(t,e,r){switch(t.disposeOp){case DisposeOpType.NONE:break;case DisposeOpType.BACKGROUND:for(let e=0;e<this._png.height;e++)for(let n=0;n<this._png.width;n++){const i=(e*t.width+n)*this._png.channels;for(let t=0;t<this._png.channels;t++)r.data[i+t]=0}break;case DisposeOpType.PREVIOUS:r.data.set(e.data);break;default:throw new Error("Unknown disposeOp")}}addFrameDataToCanvas(t,e){const r=1<<this._png.depth,n=(t,r)=>({index:((t+e.yOffset)*this._png.width+e.xOffset+r)*this._png.channels,frameIndex:(t*e.width+r)*this._png.channels});switch(e.blendOp){case BlendOpType.SOURCE:for(let r=0;r<e.height;r++)for(let i=0;i<e.width;i++){const{index:o,frameIndex:s}=n(r,i);for(let r=0;r<this._png.channels;r++)t.data[o+r]=e.data[s+r]}break;case BlendOpType.OVER:for(let i=0;i<e.height;i++)for(let o=0;o<e.width;o++){const{index:s,frameIndex:a}=n(i,o);for(let n=0;n<this._png.channels;n++){const i=e.data[a+this._png.channels-1]/r,o=n%(this._png.channels-1)==0?1:e.data[a+n],l=Math.floor(i*o+(1-i)*t.data[s+n]);t.data[s+n]+=l}}break;default:throw new Error("Unknown blendOp")}}decodeImage(){if(this._inflator.err)throw new Error(`Error while decompressing the data: ${this._inflator.err}`);const t=this._isAnimated?(this._frames?.at(0)).data:this._inflator.result;if(this._filterMethod!==FilterMethod.ADAPTIVE)throw new Error(`Filter method ${this._filterMethod} not supported`);if(this._interlaceMethod===InterlaceMethod.NO_INTERLACE)this._png.data=decodeInterlaceNull({data:t,width:this._png.width,height:this._png.height,channels:this._png.channels,depth:this._png.depth});else{if(this._interlaceMethod!==InterlaceMethod.ADAM7)throw new Error(`Interlace method ${this._interlaceMethod} not supported`);this._png.data=decodeInterlaceAdam7({data:t,width:this._png.width,height:this._png.height,channels:this._png.channels,depth:this._png.depth})}this._hasPalette&&(this._png.palette=this._palette),this._hasTransparency&&(this._png.transparency=this._transparency)}pushDataToFrame(){const t=this._inflator.result,e=this._frames.at(-1);e?e.data=t:this._frames.push({sequenceNumber:0,width:this._png.width,height:this._png.height,xOffset:0,yOffset:0,delayNumber:0,delayDenominator:0,disposeOp:DisposeOpType.NONE,blendOp:BlendOpType.SOURCE,data:t}),this._inflator=new Inflate_1,this._writingDataChunks=!1}}function checkBitDepth(t){if(1!==t&&2!==t&&4!==t&&8!==t&&16!==t)throw new Error(`invalid bit depth: ${t}`);return t}const defaultZlibOptions={level:3};class PngEncoder extends IOBuffer{_png;_zlibOptions;_colorType;_interlaceMethod;constructor(t,e={}){super(),this._colorType=ColorType.UNKNOWN,this._zlibOptions={...defaultZlibOptions,...e.zlib},this._png=this._checkData(t),this._interlaceMethod=("Adam7"===e.interlace?InterlaceMethod.ADAM7:InterlaceMethod.NO_INTERLACE)??InterlaceMethod.NO_INTERLACE,this.setBigEndian()}encode(){if(writeSignature(this),this.encodeIHDR(),this._png.palette&&(this.encodePLTE(),4===this._png.palette[0].length&&this.encodeTRNS()),this.encodeData(),this._png.text)for(const[t,e]of Object.entries(this._png.text))encodetEXt(this,t,e);return this.encodeIEND(),this.toArray()}encodeIHDR(){this.writeUint32(13),this.writeChars("IHDR"),this.writeUint32(this._png.width),this.writeUint32(this._png.height),this.writeByte(this._png.depth),this.writeByte(this._colorType),this.writeByte(CompressionMethod.DEFLATE),this.writeByte(FilterMethod.ADAPTIVE),this.writeByte(this._interlaceMethod),writeCrc(this,17)}encodeIEND(){this.writeUint32(0),this.writeChars("IEND"),writeCrc(this,4)}encodePLTE(){const t=3*this._png.palette?.length;this.writeUint32(t),this.writeChars("PLTE");for(const t of this._png.palette)this.writeByte(t[0]),this.writeByte(t[1]),this.writeByte(t[2]);writeCrc(this,4+t)}encodeTRNS(){const t=this._png.palette.filter(t=>255!==t.at(-1));this.writeUint32(t.length),this.writeChars("tRNS");for(const e of t)this.writeByte(e.at(-1));writeCrc(this,4+t.length)}encodeIDAT(t){this.writeUint32(t.length),this.writeChars("IDAT"),this.writeBytes(t),writeCrc(this,t.length+4)}encodeData(){const{width:t,height:e,channels:r,depth:n,data:i}=this._png,o=n<=8?Math.ceil(t*n/8)*r:Math.ceil(t*n/8*r/2),s=(new IOBuffer).setBigEndian();let a=0;if(this._interlaceMethod===InterlaceMethod.NO_INTERLACE)for(let t=0;t<e;t++)s.writeByte(0),a=16===n?writeDataUint16(i,s,o,a):writeDataBytes(i,s,o,a);else this._interlaceMethod===InterlaceMethod.ADAM7&&(a=writeDataInterlaced(this._png,i,s,a));const l=s.toArray(),h=deflate_1(l,this._zlibOptions);this.encodeIDAT(h)}_checkData(t){const{colorType:e,channels:r,depth:n}=getColorType(t,t.palette),i={width:checkInteger(t.width,"width"),height:checkInteger(t.height,"height"),channels:r,data:t.data,depth:n,text:t.text,palette:t.palette};this._colorType=e;const o=n<8?Math.ceil(i.width*n/8)*i.height*r:i.width*i.height*r;if(i.data.length!==o)throw new RangeError(`wrong data size. Found ${i.data.length}, expected ${o}`);return i}}function checkInteger(t,e){if(Number.isInteger(t)&&t>0)return t;throw new TypeError(`${e} must be a positive integer`)}function getColorType(t,e){const{channels:r=4,depth:n=8}=t;if(4!==r&&3!==r&&2!==r&&1!==r)throw new RangeError(`unsupported number of channels: ${r}`);const i={channels:r,depth:n,colorType:ColorType.UNKNOWN};switch(r){case 4:i.colorType=ColorType.TRUECOLOUR_ALPHA;break;case 3:i.colorType=ColorType.TRUECOLOUR;break;case 1:i.colorType=e?ColorType.INDEXED_COLOUR:ColorType.GREYSCALE;break;case 2:i.colorType=ColorType.GREYSCALE_ALPHA;break;default:throw new Error("unsupported number of channels")}return i}function writeDataBytes(t,e,r,n){for(let i=0;i<r;i++)e.writeByte(t[n++]);return n}function writeDataInterlaced(t,e,r,n){const i=[{x:0,y:0,xStep:8,yStep:8},{x:4,y:0,xStep:8,yStep:8},{x:0,y:4,xStep:4,yStep:8},{x:2,y:0,xStep:4,yStep:4},{x:0,y:2,xStep:2,yStep:4},{x:1,y:0,xStep:2,yStep:2},{x:0,y:1,xStep:1,yStep:2}],{width:o,height:s,channels:a,depth:l}=t;let h;h=16===l?a*l/8/2:a*l/8;for(let t=0;t<7;t++){const n=i[t],a=Math.floor((o-n.x+n.xStep-1)/n.xStep),c=Math.floor((s-n.y+n.yStep-1)/n.yStep);if(a<=0||c<=0)continue;const u=a*h;for(let t=0;t<c;t++){const i=n.y+t*n.yStep,c=l<=8?new Uint8Array(u):new Uint16Array(u);let f=0;for(let t=0;t<a;t++){const r=n.x+t*n.xStep;if(r<o&&i<s){const t=(i*o+r)*h;for(let r=0;r<h;r++)c[f++]=e[t+r]}}if(r.writeByte(0),8===l)r.writeBytes(c);else if(16===l)for(const t of c)r.writeByte(t>>8&255),r.writeByte(255&t)}}return n}function writeDataUint16(t,e,r,n){for(let i=0;i<r;i++)e.writeUint16(t[n++]);return n}function decodePng$1(t,e){return new PngDecoder(t,e).decode()}function encodePng$1(t,e){return new PngEncoder(t,e).encode()}function decodeApng(t,e){return new PngDecoder(t,e).decodeApng()}function encodePng(t,e){("RGB"!==t.colorModel&&"RGBA"!==t.colorModel&&"GREY"!==t.colorModel&&"GREYA"!==t.colorModel||t instanceof Mask)&&(t=t.convertColor("GREY"));const{bitDepth:r,...n}=t.getRawImage();return encodePng$1({depth:r,...n},e)}const ImageFormat={PNG:"png",JPG:"jpg",JPEG:"jpeg",BMP:"bmp"},defaultPng={format:"png"};function encode(t,e=defaultPng){return M$2(e).with({format:"png"},e=>encodePng(t,e.encoderOptions)).with({format:z.union("jpg","jpeg")},e=>encodeJpeg(t,e.encoderOptions)).with({format:"bmp"},()=>encodeBmp(t)).exhaustive()}function getNodeApiOrThrow(t){if(!isNode())throw new Error(`${t} is only implemented for Node.js`);return{fs:process.getBuiltinModule("node:fs"),path:process.getBuiltinModule("node:path"),url:process.getBuiltinModule("node:url")}}let CanvasCtorBrowser,CanvasCtorNode,requireFn;function getCanvasContext(t,e){if(isNode())return CanvasCtorNode??=getRequireFn()("skia-canvas").Canvas,new CanvasCtorNode(t,e).getContext("2d");{CanvasCtorBrowser??=globalThis.OffscreenCanvas;const r=new CanvasCtorBrowser(t,e).getContext("2d");if(!r)throw new Error("Failed to create canvas context");return r}}function isNode(){return"undefined"!=typeof process&&"function"==typeof process.getBuiltinModule}function getRequireFn(){return requireFn??=process.getBuiltinModule("node:module").createRequire("undefined"==typeof document&&"undefined"==typeof location?require("url").pathToFileURL(__filename).href:"undefined"==typeof document?location.href:_documentCurrentScript&&"SCRIPT"===_documentCurrentScript.tagName.toUpperCase()&&_documentCurrentScript.src||new URL("image-js.umd.min.js",document.baseURI).href),requireFn}async function write(t,e,r){const n=getNodeApiOrThrow("write");"string"!=typeof t&&(t=n.url.fileURLToPath(t)),e instanceof Mask&&(e=e.convertColor("GREY"));const i=getDataToWrite(t,e,r,n);if(r?.recursive){const e=n.path.dirname(t);await n.fs.promises.mkdir(e,{recursive:!0})}await n.fs.promises.writeFile(t,i)}function writeSync(t,e,r){const n=getNodeApiOrThrow("writeSync");"string"!=typeof t&&(t=n.url.fileURLToPath(t));const i=getDataToWrite(t,e,r,n);if(r?.recursive){const e=n.path.dirname(t);n.fs.mkdirSync(e,{recursive:!0})}n.fs.writeFileSync(t,i)}function getDataToWrite(t,e,r,n){if(r&&"format"in r)return encode(e,r);{const i=n.path.extname(t).slice(1).toLowerCase();if("png"===i||"jpg"===i||"jpeg"===i||"bmp"===i)return encode(e,{...r,format:i});throw new RangeError("image format could not be determined from file extension. Use a supported extension or specify the format option")}}function writeCanvas(t,e,r={}){"RGBA"!==t.colorModel&&(t=t.convertColor("RGBA")),8!==t.bitDepth&&t instanceof Image&&(t=t.convertBitDepth(8));const{resizeCanvas:n=!0,dx:i=0,dy:o=0,dirtyX:s=0,dirtyY:a=0,dirtyWidth:l=t.width,dirtyHeight:h=t.height}=r;n&&(e.width=t.width,e.height=t.height);const c=e.getContext("2d");assert(c);const u=t.getRawImage().data;c.putImageData(new ImageData(new Uint8ClampedArray(u.buffer,u.byteOffset,u.byteLength),t.width,t.height),i,o,s,a,l,h)}Uint8Array.from([255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,62,255,255,255,63,52,53,54,55,56,57,58,59,60,61,255,255,255,0,255,255,255,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,255,255,255,255,255,255,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51]);const base64codes=Uint8Array.from([65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,48,49,50,51,52,53,54,55,56,57,43,47]),base64codes1=new Uint32Array(4096);for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=t<<2|(48&e)>>4|(15&e)<<8;base64codes1[r]=base64codes[t]|base64codes[e]<<8}const base64codes2=new Uint32Array(4096);for(let t=0;t<64;t++)for(let e=0;e<64;e++){const r=t<<6|e;base64codes2[r]=base64codes[t]<<16|base64codes[e]<<24}function encodeFast(t){const e=new Uint32Array(Math.ceil(t.length/3));let r,n;for(r=2,n=0;r<t.length;r+=3,n++)e[n]=base64codes1[t[r-2]|(240&t[r-1])<<4]|base64codes2[t[r]|(15&t[r-1])<<8];r===t.length+1&&(e[n]=base64codes[t[r-2]>>2]|base64codes[(3&t[r-2])<<4]<<8|15677<<16),r===t.length&&(e[n]=base64codes[t[r-2]>>2]|base64codes[(3&t[r-2])<<4|t[r-1]>>4]<<8|base64codes[(15&t[r-1])<<2]<<16|61<<24);return new Uint8Array(e.buffer)}function encodeDataURL(t,e=defaultPng){const r=encodeFast(encode(t,e)),n=(new TextDecoder).decode(r);return`data:image/${e.format};base64,${n}`}function getMatrixFromPoints(t){const e=new Matrix(3,t.length);for(let r=0;r<t.length;r++)e.set(0,r,t[r].column),e.set(1,r,t[r].row),e.set(2,r,1);return e}function affineFitFunction(t,e){const r=getAffineTransform$1(getMatrixFromPoints(t),getMatrixFromPoints(e));return[r.rotation,r.translation.x,r.translation.y,r.scale]}function createAffineTransformModel(t){if(4!==t.length)throw new Error("Transform had wrong number of parameters");return e=>{const r=t[0]*Math.PI/180,n=t[1],i=t[2],o=t[3];return{column:o*(Math.cos(r)*e.column-Math.sin(r)*e.row)+n,row:o*(Math.sin(r)*e.column+Math.cos(r)*e.row)+i}}}function getEuclideanDistance(t,e){return Math.hypot(t.row-e.row,t.column-e.column)}function getSourceWithoutMargins(t,e,r){const n=Math.min(e.width,t.width-r.column),i=Math.min(e.height,t.height-r.row);return t.crop({origin:{row:r.row,column:r.column},width:n,height:i})}function getAffineTransform(t,e,r={}){const{centroidPatchDiameter:n=31,bestKeypointRadius:i=5,enhanceContrast:o=!0,crosscheck:s=!0,destinationOrigin:a={column:0,row:0},maxRansacNbIterations:l,debug:h=!1,debugImagePath:c="undefined/montage.png"}=r;if(t.colorModel!==ImageColorModel.GREY&&(t=t.grey()),e.colorModel!==ImageColorModel.GREY&&(e=e.grey()),o){const r=getMinMax(getSourceWithoutMargins(t,e,a));t.level({inputMin:r.min[0],inputMax:r.max[0],out:t});const n=getMinMax(e);e.level({inputMin:n.min[0],inputMax:n.max[0],out:e})}const u=getBrief(t,{centroidPatchDiameter:n,bestKptRadius:i}),f=getBrief(e,{centroidPatchDiameter:n,bestKptRadius:i}),d=u.keypoints.length,m=f.keypoints.length;let g=[];if(s?g=getCrosscheckMatches(u.descriptors,f.descriptors):(g=bruteForceOneMatch(u.descriptors,f.descriptors),g=filterEuclideanDistance(g,u.keypoints,f.keypoints,{origin:a})),g.length<2)throw new Error("Insufficient number of matches found to compute affine transform (less than 2).");let p=[],w=[];for(const t of g)p.push(u.keypoints[t.sourceIndex].origin),w.push(f.keypoints[t.destinationIndex].origin);let b=p.length,_=0,y=[0,1];if(p.length>2){const t=ransac(p,w,{distanceFunction:getEuclideanDistance,modelFunction:createAffineTransformModel,fitFunction:affineFitFunction,maxNbIterations:l});_=t.nbIterations,y=t.inliers,b=y.length;const e=[],r=[];for(const t of y)e.push(p[t]),r.push(w[t]);p=e,w=r}if(h){const r=new Montage(t,e,{disposition:MontageDisposition.VERTICAL});r.drawMatches(g,u.keypoints,f.keypoints,{showDistance:!0});const n=[];for(const t of y)n.push(g[t]);r.drawMatches(n,u.keypoints,f.keypoints,{strokeColor:[0,0,255]});const i={fill:!0,color:[0,255,0],showScore:!0,markerSize:3};r.drawKeypoints(u.keypoints,i),r.drawKeypoints(f.keypoints,{origin:r.destinationOrigin,...i}),writeSync(c,r.image)}const x=getAffineTransform$1(getMatrixFromPoints(p),getMatrixFromPoints(w));return{transform:{rotation:x.rotation,scale:x.scale,translation:{column:Math.round(x.translation.x),row:Math.round(x.translation.y)}},stats:{nbMatches:g.length,nbInliers:b,nbRansacIterations:_,nbSourceKeypoints:d,nbDestinationKeypoints:m}}}function alignMinDifference(t,e,r={}){checkProcessable$1(t,{bitDepth:[8,16]});const n=e.width-t.width,i=e.height-t.height,{startStep:o=Math.max(Math.round(Math.min(t.width,t.height,Math.max(n,i))/4),1),mask:s}=r;if(n<0||i<0)throw new Error("Source image must fit entirely in destination image");let a=Number.POSITIVE_INFINITY,l=0,h=0,c=o,u=0,f=0,d=n,m=i;if(s&&s.size!==t.size)throw new Error("Mask size must be equal to source size");const g=s?s.getNbNonZeroPixels():t.size;for(;c>=1;){c=Math.round(c);for(let r=u;r<=d;r+=c)for(let n=f;n<=m;n+=c){let i=0;t:for(let o=0;o<t.width;o++)for(let l=0;l<t.height;l++)if(!s||s.getBit(o,l))for(let s=0;s<t.channels;s++){const h=t.getValue(o,l,s)-e.getValue(o+r,l+n,s);if(h<0?i-=h:i+=h,i>a)break t}i<a&&(a=i,l=r,h=n)}c/=2,u=Math.round(Math.max(0,l-c)),f=Math.round(Math.max(0,h-c)),d=Math.round(Math.min(n,l+c)),m=Math.round(Math.min(i,h+c))}return{row:h,column:l,similarity:1-a/(g*t.maxValue)}}function removeClosePoints(t,e,r){const n=r?.distance||0,i=r?.kind||"maximum";if(void 0===r?.channel&&e.channels>1)throw new Error("image channel must be specified or image must have only one channel");const o=r?.channel||0,s="maximum"===i,a=t.slice();if(a.sort(getSort(e,o,s)),n>0)for(let t=0;t<a.length;t++)for(let e=t+1;e<a.length;e++)Math.hypot(a[t].column-a[e].column,a[t].row-a[e].row)<n&&(a.splice(e,1),e--);return a}function getSort(t,e,r){return r?function(r,n){return t.getValue(n.column,n.row,e)-t.getValue(r.column,r.row,e)}:function(r,n){return t.getValue(r.column,r.row,e)-t.getValue(n.column,n.row,e)}}var imageType$2={exports:{}},fileType$1={exports:{}};(function(module){const toBytes=t=>[...t].map(t=>t.charCodeAt(0)),xpiZipFilename=toBytes("META-INF/mozilla.rsa"),oxmlContentTypes=toBytes("[Content_Types].xml"),oxmlRels=toBytes("_rels/.rels");function readUInt64LE(t,e=0){let r=t[e],n=1,i=0;for(;++i<8;)n*=256,r+=t[e+i]*n;return r}const fileType=t=>{if(!(t instanceof Uint8Array||t instanceof ArrayBuffer||Buffer.isBuffer(t)))throw new TypeError(`Expected the \`input\` argument to be of type \`Uint8Array\` or \`Buffer\` or \`ArrayBuffer\`, got \`${typeof t}\``);const e=t instanceof Uint8Array?t:new Uint8Array(t);if(!(e&&e.length>1))return null;const r=(t,r)=>{r=Object.assign({offset:0},r);for(let n=0;n<t.length;n++)if(r.mask){if(t[n]!==(r.mask[n]&e[n+r.offset]))return!1}else if(t[n]!==e[n+r.offset])return!1;return!0},n=(t,e)=>r(toBytes(t),e);if(r([255,216,255]))return{ext:"jpg",mime:"image/jpeg"};if(r([137,80,78,71,13,10,26,10]))return{ext:"png",mime:"image/png"};if(r([71,73,70]))return{ext:"gif",mime:"image/gif"};if(r([87,69,66,80],{offset:8}))return{ext:"webp",mime:"image/webp"};if(r([70,76,73,70]))return{ext:"flif",mime:"image/flif"};if((r([73,73,42,0])||r([77,77,0,42]))&&r([67,82],{offset:8}))return{ext:"cr2",mime:"image/x-canon-cr2"};if(r([73,73,42,0])||r([77,77,0,42]))return{ext:"tif",mime:"image/tiff"};if(r([66,77]))return{ext:"bmp",mime:"image/bmp"};if(r([73,73,188]))return{ext:"jxr",mime:"image/vnd.ms-photo"};if(r([56,66,80,83]))return{ext:"psd",mime:"image/vnd.adobe.photoshop"};if(r([80,75,3,4])){if(r([109,105,109,101,116,121,112,101,97,112,112,108,105,99,97,116,105,111,110,47,101,112,117,98,43,122,105,112],{offset:30}))return{ext:"epub",mime:"application/epub+zip"};if(r(xpiZipFilename,{offset:30}))return{ext:"xpi",mime:"application/x-xpinstall"};if(n("mimetypeapplication/vnd.oasis.opendocument.text",{offset:30}))return{ext:"odt",mime:"application/vnd.oasis.opendocument.text"};if(n("mimetypeapplication/vnd.oasis.opendocument.spreadsheet",{offset:30}))return{ext:"ods",mime:"application/vnd.oasis.opendocument.spreadsheet"};if(n("mimetypeapplication/vnd.oasis.opendocument.presentation",{offset:30}))return{ext:"odp",mime:"application/vnd.oasis.opendocument.presentation"};const t=(t,e=0)=>t.findIndex((t,r,n)=>r>=e&&80===n[r]&&75===n[r+1]&&3===n[r+2]&&4===n[r+3]);let i=0,o=!1,s=null;do{const a=i+30;if(o||(o=r(oxmlContentTypes,{offset:a})||r(oxmlRels,{offset:a})),s||(n("word/",{offset:a})?s={ext:"docx",mime:"application/vnd.openxmlformats-officedocument.wordprocessingml.document"}:n("ppt/",{offset:a})?s={ext:"pptx",mime:"application/vnd.openxmlformats-officedocument.presentationml.presentation"}:n("xl/",{offset:a})&&(s={ext:"xlsx",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})),o&&s)return s;i=t(e,a)}while(i>=0);if(s)return s}if(r([80,75])&&(3===e[2]||5===e[2]||7===e[2])&&(4===e[3]||6===e[3]||8===e[3]))return{ext:"zip",mime:"application/zip"};if(r([117,115,116,97,114],{offset:257}))return{ext:"tar",mime:"application/x-tar"};if(r([82,97,114,33,26,7])&&(0===e[6]||1===e[6]))return{ext:"rar",mime:"application/x-rar-compressed"};if(r([31,139,8]))return{ext:"gz",mime:"application/gzip"};if(r([66,90,104]))return{ext:"bz2",mime:"application/x-bzip2"};if(r([55,122,188,175,39,28]))return{ext:"7z",mime:"application/x-7z-compressed"};if(r([120,1]))return{ext:"dmg",mime:"application/x-apple-diskimage"};if(r([51,103,112,53])||r([0,0,0])&&r([102,116,121,112],{offset:4})&&(r([109,112,52,49],{offset:8})||r([109,112,52,50],{offset:8})||r([105,115,111,109],{offset:8})||r([105,115,111,50],{offset:8})||r([109,109,112,52],{offset:8})||r([77,52,86],{offset:8})||r([100,97,115,104],{offset:8})))return{ext:"mp4",mime:"video/mp4"};if(r([77,84,104,100]))return{ext:"mid",mime:"audio/midi"};if(r([26,69,223,163])){const t=e.subarray(4,4100),r=t.findIndex((t,e,r)=>66===r[e]&&130===r[e+1]);if(-1!==r){const e=r+3,n=r=>[...r].every((r,n)=>t[e+n]===r.charCodeAt(0));if(n("matroska"))return{ext:"mkv",mime:"video/x-matroska"};if(n("webm"))return{ext:"webm",mime:"video/webm"}}}if(r([0,0,0,20,102,116,121,112,113,116,32,32])||r([102,114,101,101],{offset:4})||r([102,116,121,112,113,116,32,32],{offset:4})||r([109,100,97,116],{offset:4})||r([109,111,111,118],{offset:4})||r([119,105,100,101],{offset:4}))return{ext:"mov",mime:"video/quicktime"};if(r([82,73,70,70])){if(r([65,86,73],{offset:8}))return{ext:"avi",mime:"video/vnd.avi"};if(r([87,65,86,69],{offset:8}))return{ext:"wav",mime:"audio/vnd.wave"};if(r([81,76,67,77],{offset:8}))return{ext:"qcp",mime:"audio/qcelp"}}if(r([48,38,178,117,142,102,207,17,166,217])){let t=30;do{const n=readUInt64LE(e,t+16);if(r([145,7,220,183,183,169,207,17,142,230,0,192,12,32,83,101],{offset:t})){if(r([64,158,105,248,77,91,207,17,168,253,0,128,95,92,68,43],{offset:t+24}))return{ext:"wma",mime:"audio/x-ms-wma"};if(r([192,239,25,188,77,91,207,17,168,253,0,128,95,92,68,43],{offset:t+24}))return{ext:"wmv",mime:"video/x-ms-asf"};break}t+=n}while(t+24<=e.length);return{ext:"asf",mime:"application/vnd.ms-asf"}}if(r([0,0,1,186])||r([0,0,1,179]))return{ext:"mpg",mime:"video/mpeg"};if(r([102,116,121,112,51,103],{offset:4}))return{ext:"3gp",mime:"video/3gpp"};for(let t=0;t<2&&t<e.length-16;t++){if(r([73,68,51],{offset:t})||r([255,226],{offset:t,mask:[255,226]}))return{ext:"mp3",mime:"audio/mpeg"};if(r([255,228],{offset:t,mask:[255,228]}))return{ext:"mp2",mime:"audio/mpeg"};if(r([255,248],{offset:t,mask:[255,252]}))return{ext:"mp2",mime:"audio/mpeg"};if(r([255,240],{offset:t,mask:[255,252]}))return{ext:"mp4",mime:"audio/mpeg"}}if(r([102,116,121,112,77,52,65],{offset:4}))return{ext:"m4a",mime:"audio/mp4"};if(r([79,112,117,115,72,101,97,100],{offset:28}))return{ext:"opus",mime:"audio/opus"};if(r([79,103,103,83]))return r([128,116,104,101,111,114,97],{offset:28})?{ext:"ogv",mime:"video/ogg"}:r([1,118,105,100,101,111,0],{offset:28})?{ext:"ogm",mime:"video/ogg"}:r([127,70,76,65,67],{offset:28})?{ext:"oga",mime:"audio/ogg"}:r([83,112,101,101,120,32,32],{offset:28})?{ext:"spx",mime:"audio/ogg"}:r([1,118,111,114,98,105,115],{offset:28})?{ext:"ogg",mime:"audio/ogg"}:{ext:"ogx",mime:"application/ogg"};if(r([102,76,97,67]))return{ext:"flac",mime:"audio/x-flac"};if(r([77,65,67,32]))return{ext:"ape",mime:"audio/ape"};if(r([119,118,112,107]))return{ext:"wv",mime:"audio/wavpack"};if(r([35,33,65,77,82,10]))return{ext:"amr",mime:"audio/amr"};if(r([37,80,68,70]))return{ext:"pdf",mime:"application/pdf"};if(r([77,90]))return{ext:"exe",mime:"application/x-msdownload"};if((67===e[0]||70===e[0])&&r([87,83],{offset:1}))return{ext:"swf",mime:"application/x-shockwave-flash"};if(r([123,92,114,116,102]))return{ext:"rtf",mime:"application/rtf"};if(r([0,97,115,109]))return{ext:"wasm",mime:"application/wasm"};if(r([119,79,70,70])&&(r([0,1,0,0],{offset:4})||r([79,84,84,79],{offset:4})))return{ext:"woff",mime:"font/woff"};if(r([119,79,70,50])&&(r([0,1,0,0],{offset:4})||r([79,84,84,79],{offset:4})))return{ext:"woff2",mime:"font/woff2"};if(r([76,80],{offset:34})&&(r([0,0,1],{offset:8})||r([1,0,2],{offset:8})||r([2,0,2],{offset:8})))return{ext:"eot",mime:"application/vnd.ms-fontobject"};if(r([0,1,0,0,0]))return{ext:"ttf",mime:"font/ttf"};if(r([79,84,84,79,0]))return{ext:"otf",mime:"font/otf"};if(r([0,0,1,0]))return{ext:"ico",mime:"image/x-icon"};if(r([0,0,2,0]))return{ext:"cur",mime:"image/x-icon"};if(r([70,76,86,1]))return{ext:"flv",mime:"video/x-flv"};if(r([37,33]))return{ext:"ps",mime:"application/postscript"};if(r([253,55,122,88,90,0]))return{ext:"xz",mime:"application/x-xz"};if(r([83,81,76,105]))return{ext:"sqlite",mime:"application/x-sqlite3"};if(r([78,69,83,26]))return{ext:"nes",mime:"application/x-nintendo-nes-rom"};if(r([67,114,50,52]))return{ext:"crx",mime:"application/x-google-chrome-extension"};if(r([77,83,67,70])||r([73,83,99,40]))return{ext:"cab",mime:"application/vnd.ms-cab-compressed"};if(r([33,60,97,114,99,104,62,10,100,101,98,105,97,110,45,98,105,110,97,114,121]))return{ext:"deb",mime:"application/x-deb"};if(r([33,60,97,114,99,104,62]))return{ext:"ar",mime:"application/x-unix-archive"};if(r([237,171,238,219]))return{ext:"rpm",mime:"application/x-rpm"};if(r([31,160])||r([31,157]))return{ext:"Z",mime:"application/x-compress"};if(r([76,90,73,80]))return{ext:"lz",mime:"application/x-lzip"};if(r([208,207,17,224,161,177,26,225]))return{ext:"msi",mime:"application/x-msi"};if(r([6,14,43,52,2,5,1,1,13,1,2,1,1,2]))return{ext:"mxf",mime:"application/mxf"};if(r([71],{offset:4})&&(r([71],{offset:192})||r([71],{offset:196})))return{ext:"mts",mime:"video/mp2t"};if(r([66,76,69,78,68,69,82]))return{ext:"blend",mime:"application/x-blender"};if(r([66,80,71,251]))return{ext:"bpg",mime:"image/bpg"};if(r([0,0,0,12,106,80,32,32,13,10,135,10])){if(r([106,112,50,32],{offset:20}))return{ext:"jp2",mime:"image/jp2"};if(r([106,112,120,32],{offset:20}))return{ext:"jpx",mime:"image/jpx"};if(r([106,112,109,32],{offset:20}))return{ext:"jpm",mime:"image/jpm"};if(r([109,106,112,50],{offset:20}))return{ext:"mj2",mime:"image/mj2"}}if(r([70,79,82,77]))return{ext:"aif",mime:"audio/aiff"};if(n("<?xml "))return{ext:"xml",mime:"application/xml"};if(r([66,79,79,75,77,79,66,73],{offset:60}))return{ext:"mobi",mime:"application/x-mobipocket-ebook"};if(r([102,116,121,112],{offset:4})){if(r([109,105,102,49],{offset:8}))return{ext:"heic",mime:"image/heif"};if(r([109,115,102,49],{offset:8}))return{ext:"heic",mime:"image/heif-sequence"};if(r([104,101,105,99],{offset:8})||r([104,101,105,120],{offset:8}))return{ext:"heic",mime:"image/heic"};if(r([104,101,118,99],{offset:8})||r([104,101,118,120],{offset:8}))return{ext:"heic",mime:"image/heic-sequence"}}return r([171,75,84,88,32,49,49,187,13,10,26,10])?{ext:"ktx",mime:"image/ktx"}:r([68,73,67,77],{offset:128})?{ext:"dcm",mime:"application/dicom"}:r([77,80,43])||r([77,80,67,75])?{ext:"mpc",mime:"audio/x-musepack"}:r([66,69,71,73,78,58])?{ext:"ics",mime:"text/calendar"}:r([103,108,84,70,2,0,0,0])?{ext:"glb",mime:"model/gltf-binary"}:r([212,195,178,161])||r([161,178,195,212])?{ext:"pcap",mime:"application/vnd.tcpdump.pcap"}:null};module.exports=fileType,module.exports.default=fileType,Object.defineProperty(fileType,"minimumBytes",{value:4100}),module.exports.stream=readableStream=>new Promise((resolve,reject)=>{const stream=eval("require")("stream");readableStream.once("readable",()=>{const t=new stream.PassThrough,e=readableStream.read(module.exports.minimumBytes)||readableStream.read();try{t.fileType=fileType(e)}catch(t){reject(t)}readableStream.unshift(e),stream.pipeline?resolve(stream.pipeline(readableStream,t,()=>{})):resolve(readableStream.pipe(t))})})})(fileType$1);var fileTypeExports=fileType$1.exports;const fileType=fileTypeExports,imageExts=new Set(["jpg","png","gif","webp","flif","cr2","tif","bmp","jxr","psd","ico","bpg","jp2","jpm","jpx","heic","cur","dcm"]),imageType=t=>{const e=fileType(t);return imageExts.has(e&&e.ext)?e:null};imageType$2.exports=imageType,imageType$2.exports.default=imageType,Object.defineProperty(imageType,"minimumBytes",{value:fileType.minimumBytes});var imageTypeExports=imageType$2.exports,imageType$1=getDefaultExportFromCjs(imageTypeExports);function decodeBmp(t){const e=decode$3(t);if(1===e.bitsPerPixel){return new Mask(e.width,e.height,{data:e.data}).convertColor("GREY")}{let t;switch(e.channels){case 1:t="GREY";break;case 3:t="RGB";break;default:t="RGBA"}return new Image(e.width,e.height,{colorModel:t,data:e.data})}}const tagsById$2={33434:"ExposureTime",33437:"FNumber",34850:"ExposureProgram",34852:"SpectralSensitivity",34855:"ISOSpeedRatings",34856:"OECF",34864:"SensitivityType",34865:"StandardOutputSensitivity",34866:"RecommendedExposureIndex",34867:"ISOSpeed",34868:"ISOSpeedLatitudeyyy",34869:"ISOSpeedLatitudezzz",36864:"ExifVersion",36867:"DateTimeOriginal",36868:"DateTimeDigitized",37121:"ComponentsConfiguration",37122:"CompressedBitsPerPixel",37377:"ShutterSpeedValue",37378:"ApertureValue",37379:"BrightnessValue",37380:"ExposureBiasValue",37381:"MaxApertureValue",37382:"SubjectDistance",37383:"MeteringMode",37384:"LightSource",37385:"Flash",37386:"FocalLength",37396:"SubjectArea",37500:"MakerNote",37510:"UserComment",37520:"SubsecTime",37521:"SubsecTimeOriginal",37522:"SubsecTimeDigitized",40960:"FlashpixVersion",40961:"ColorSpace",40962:"PixelXDimension",40963:"PixelYDimension",40964:"RelatedSoundFile",41483:"FlashEnergy",41484:"SpatialFrequencyResponse",41486:"FocalPlaneXResolution",41487:"FocalPlaneYResolution",41488:"FocalPlaneResolutionUnit",41492:"SubjectLocation",41493:"ExposureIndex",41495:"SensingMethod",41728:"FileSource",41729:"SceneType",41730:"CFAPattern",41985:"CustomRendered",41986:"ExposureMode",41987:"WhiteBalance",41988:"DigitalZoomRatio",41989:"FocalLengthIn35mmFilm",41990:"SceneCaptureType",41991:"GainControl",41992:"Contrast",41993:"Saturation",41994:"Sharpness",41995:"DeviceSettingDescription",41996:"SubjectDistanceRange",42016:"ImageUniqueID",42032:"CameraOwnerName",42033:"BodySerialNumber",42034:"LensSpecification",42035:"LensMake",42036:"LensModel",42037:"LensSerialNumber",42240:"Gamma"},tagsByName$2={};for(const t in tagsById$2)tagsByName$2[tagsById$2[t]]=Number(t);var exif=Object.freeze({__proto__:null,tagsById:tagsById$2,tagsByName:tagsByName$2});const tagsById$1={0:"GPSVersionID",1:"GPSLatitudeRef",2:"GPSLatitude",3:"GPSLongitudeRef",4:"GPSLongitude",5:"GPSAltitudeRef",6:"GPSAltitude",7:"GPSTimeStamp",8:"GPSSatellites",9:"GPSStatus",10:"GPSMeasureMode",11:"GPSDOP",12:"GPSSpeedRef",13:"GPSSpeed",14:"GPSTrackRef",15:"GPSTrack",16:"GPSImgDirectionRef",17:"GPSImgDirection",18:"GPSMapDatum",19:"GPSDestLatitudeRef",20:"GPSDestLatitude",21:"GPSDestLongitudeRef",22:"GPSDestLongitude",23:"GPSDestBearingRef",24:"GPSDestBearing",25:"GPSDestDistanceRef",26:"GPSDestDistance",27:"GPSProcessingMethod",28:"GPSAreaInformation",29:"GPSDateStamp",30:"GPSDifferential",31:"GPSHPositioningError"},tagsByName$1={};for(const t in tagsById$1)tagsByName$1[tagsById$1[t]]=Number(t);var gps=Object.freeze({__proto__:null,tagsById:tagsById$1,tagsByName:tagsByName$1});const tagsById={254:"NewSubfileType",255:"SubfileType",256:"ImageWidth",257:"ImageLength",258:"BitsPerSample",259:"Compression",262:"PhotometricInterpretation",263:"Threshholding",264:"CellWidth",265:"CellLength",266:"FillOrder",270:"ImageDescription",271:"Make",272:"Model",273:"StripOffsets",274:"Orientation",277:"SamplesPerPixel",278:"RowsPerStrip",279:"StripByteCounts",280:"MinSampleValue",281:"MaxSampleValue",282:"XResolution",283:"YResolution",284:"PlanarConfiguration",288:"FreeOffsets",289:"FreeByteCounts",290:"GrayResponseUnit",291:"GrayResponseCurve",296:"ResolutionUnit",305:"Software",306:"DateTime",315:"Artist",316:"HostComputer",320:"ColorMap",338:"ExtraSamples",33432:"Copyright",269:"DocumentName",285:"PageName",286:"XPosition",287:"YPosition",292:"T4Options",293:"T6Options",297:"PageNumber",301:"TransferFunction",317:"Predictor",318:"WhitePoint",319:"PrimaryChromaticities",321:"HalftoneHints",322:"TileWidth",323:"TileLength",324:"TileOffsets",325:"TileByteCounts",326:"BadFaxLines",327:"CleanFaxData",328:"ConsecutiveBadFaxLines",330:"SubIFDs",332:"InkSet",333:"InkNames",334:"NumberOfInks",336:"DotRange",337:"TargetPrinter",339:"SampleFormat",340:"SMinSampleValue",341:"SMaxSampleValue",342:"TransferRange",343:"ClipPath",344:"XClipPathUnits",345:"YClipPathUnits",346:"Indexed",347:"JPEGTables",351:"OPIProxy",400:"GlobalParametersIFD",401:"ProfileType",402:"FaxProfile",403:"CodingMethods",404:"VersionYear",405:"ModeNumber",433:"Decode",434:"DefaultImageColor",512:"JPEGProc",513:"JPEGInterchangeFormat",514:"JPEGInterchangeFormatLength",515:"JPEGRestartInterval",517:"JPEGLosslessPredictors",518:"JPEGPointTransforms",519:"JPEGQTables",520:"JPEGDCTables",521:"JPEGACTables",529:"YCbCrCoefficients",530:"YCbCrSubSampling",531:"YCbCrPositioning",532:"ReferenceBlackWhite",559:"StripRowCounts",700:"XMP",32781:"ImageID",34732:"ImageLayer",32932:"WangAnnotatio",33445:"MDFileTag",33446:"MDScalePixel",33447:"MDColorTable",33448:"MDLabName",33449:"MDSampleInfo",33450:"MDPrepDate",33451:"MDPrepTime",33452:"MDFileUnits",33550:"ModelPixelScaleTag",33723:"IPTC",33918:"INGRPacketDataTag",33919:"INGRFlagRegisters",33920:"IrasBTransformationMatrix",33922:"ModelTiepointTag",34264:"ModelTransformationTag",34377:"Photoshop",34665:"ExifIFD",34675:"ICCProfile",34735:"GeoKeyDirectoryTag",34736:"GeoDoubleParamsTag",34737:"GeoAsciiParamsTag",34853:"GPSIFD",34908:"HylaFAXFaxRecvParams",34909:"HylaFAXFaxSubAddress",34910:"HylaFAXFaxRecvTime",37724:"ImageSourceData",40965:"InteroperabilityIFD",42112:"GDAL_METADATA",42113:"GDAL_NODATA",50215:"OceScanjobDescription",50216:"OceApplicationSelector",50217:"OceIdentificationNumber",50218:"OceImageLogicCharacteristics",50706:"DNGVersion",50707:"DNGBackwardVersion",50708:"UniqueCameraModel",50709:"LocalizedCameraModel",50710:"CFAPlaneColor",50711:"CFALayout",50712:"LinearizationTable",50713:"BlackLevelRepeatDim",50714:"BlackLevel",50715:"BlackLevelDeltaH",50716:"BlackLevelDeltaV",50717:"WhiteLevel",50718:"DefaultScale",50719:"DefaultCropOrigin",50720:"DefaultCropSize",50721:"ColorMatrix1",50722:"ColorMatrix2",50723:"CameraCalibration1",50724:"CameraCalibration2",50725:"ReductionMatrix1",50726:"ReductionMatrix2",50727:"AnalogBalance",50728:"AsShotNeutral",50729:"AsShotWhiteXY",50730:"BaselineExposure",50731:"BaselineNoise",50732:"BaselineSharpness",50733:"BayerGreenSplit",50734:"LinearResponseLimit",50735:"CameraSerialNumber",50736:"LensInfo",50737:"ChromaBlurRadius",50738:"AntiAliasStrength",50740:"DNGPrivateData",50741:"MakerNoteSafety",50778:"CalibrationIlluminant1",50779:"CalibrationIlluminant2",50780:"BestQualityScale",50784:"AliasLayerMetadata"},tagsByName={};for(const t in tagsById)tagsByName[tagsById[t]]=Number(t);var standard=Object.freeze({__proto__:null,tagsById:tagsById,tagsByName:tagsByName});function guessStripByteCounts(t){if(1!==t.compression)throw new Error("missing mandatory StripByteCounts field in compressed image");const e=t.rowsPerStrip*t.width*t.samplesPerPixel*(t.bitsPerSample/8);return new Array(t.stripOffsets.length).fill(e)}function applyHorizontalDifferencing8Bit(t,e,r){let n=0;for(;n<t.length;){for(let i=r;i<e*r;i+=r)for(let e=0;e<r;e++)t[n+i+e]=t[n+i+e]+t[n+i-(r-e)]&255;n+=e*r}}function applyHorizontalDifferencing16Bit(t,e,r){let n=0;for(;n<t.length;){for(let i=r;i<e*r;i+=r)for(let e=0;e<r;e++)t[n+i+e]=t[n+i+e]+t[n+i-(r-e)]&65535;n+=e*r}}const tags={standard:standard,exif:exif,gps:gps};class IFD{kind;data;fields;exif;gps;_hasMap;_map;constructor(t){if(!t)throw new Error("missing kind");this.data=new Uint8Array,this.fields=new Map,this.kind=t,this._hasMap=!1,this._map={}}get(t){if("number"==typeof t)return this.fields.get(t);if("string"==typeof t)return this.fields.get(tags[this.kind].tagsByName[t]);throw new Error("expected a number or string")}get map(){if(!this._hasMap){const t=tags[this.kind].tagsById;for(const e of this.fields.keys())t[e]&&(this._map[t[e]]=this.fields.get(e));this._hasMap=!0}return this._map}}const types=new Map([[1,[1,readByte]],[2,[1,readASCII]],[3,[2,readShort]],[4,[4,readLong]],[5,[8,readRational]],[6,[1,readSByte]],[7,[1,readByte]],[8,[2,readSShort]],[9,[4,readSLong]],[10,[8,readSRational]],[11,[4,readFloat]],[12,[8,readDouble]]]);function getByteLength(t,e){const r=types.get(t);if(!r)throw new Error(`type not found: ${t}`);return r[0]*e}function readData(t,e,r){const n=types.get(e);if(!n)throw new Error(`type not found: ${e}`);return n[1](t,r)}function readByte(t,e){if(1===e)return t.readUint8();const r=new Uint8Array(e);for(let n=0;n<e;n++)r[n]=t.readUint8();return r}function readASCII(t,e){const r=[];let n="";for(let i=0;i<e;i++){const e=String.fromCharCode(t.readUint8());"\0"===e?(r.push(n),n=""):n+=e}return 1===r.length?r[0]:r}function readShort(t,e){if(1===e)return t.readUint16();const r=new Uint16Array(e);for(let n=0;n<e;n++)r[n]=t.readUint16();return r}function readLong(t,e){if(1===e)return t.readUint32();const r=new Uint32Array(e);for(let n=0;n<e;n++)r[n]=t.readUint32();return r}function readRational(t,e){if(1===e)return t.readUint32()/t.readUint32();const r=new Array(e);for(let n=0;n<e;n++)r[n]=t.readUint32()/t.readUint32();return r}function readSByte(t,e){if(1===e)return t.readInt8();const r=new Int8Array(e);for(let n=0;n<e;n++)r[n]=t.readInt8();return r}function readSShort(t,e){if(1===e)return t.readInt16();const r=new Int16Array(e);for(let n=0;n<e;n++)r[n]=t.readInt16();return r}function readSLong(t,e){if(1===e)return t.readInt32();const r=new Int32Array(e);for(let n=0;n<e;n++)r[n]=t.readInt32();return r}function readSRational(t,e){if(1===e)return t.readInt32()/t.readInt32();const r=new Array(e);for(let n=0;n<e;n++)r[n]=t.readInt32()/t.readInt32();return r}function readFloat(t,e){if(1===e)return t.readFloat32();const r=new Float32Array(e);for(let n=0;n<e;n++)r[n]=t.readFloat32();return r}function readDouble(t,e){if(1===e)return t.readFloat64();const r=new Float64Array(e);for(let n=0;n<e;n++)r[n]=t.readFloat64();return r}const CLEAR_CODE=256,EOI_CODE=257,TABLE_START=258,MIN_BIT_LENGTH=9;let stringTable=[];function initializeStringTable(){if(0===stringTable.length){for(let t=0;t<256;t++)stringTable.push([t]);const t=[];for(let e=256;e<4096;e++)stringTable.push(t)}}const andTable=[511,1023,2047,4095],bitJumps=[0,0,0,0,0,0,0,0,0,511,1023,2047,4095];class LzwDecoder{stripArray;nextData=0;nextBits=0;bytePointer=0;tableLength=TABLE_START;currentBitLength=MIN_BIT_LENGTH;outData;constructor(t){this.stripArray=new Uint8Array(t.buffer,t.byteOffset,t.byteLength),this.outData=new IOBuffer(t.byteLength),this.initializeTable()}decode(){let t=0,e=0;for(;(t=this.getNextCode())!==EOI_CODE;)if(t===CLEAR_CODE){if(this.initializeTable(),t=this.getNextCode(),t===EOI_CODE)break;this.writeString(this.stringFromCode(t)),e=t}else if(this.isInTable(t))this.writeString(this.stringFromCode(t)),this.addStringToTable(this.stringFromCode(e).concat(this.stringFromCode(t)[0])),e=t;else{const r=this.stringFromCode(e).concat(this.stringFromCode(e)[0]);this.writeString(r),this.addStringToTable(r),e=t}const r=this.outData.toArray();return new DataView(r.buffer,r.byteOffset,r.byteLength)}initializeTable(){initializeStringTable(),this.tableLength=TABLE_START,this.currentBitLength=MIN_BIT_LENGTH}writeString(t){this.outData.writeBytes(t)}stringFromCode(t){return stringTable[t]}isInTable(t){return t<this.tableLength}addStringToTable(t){if(stringTable[this.tableLength++]=t,stringTable.length>4096)throw stringTable=[],new Error("LZW decoding error. Please open an issue at https://github.com/image-js/tiff/issues/new/choose (include a test image).");this.tableLength===bitJumps[this.currentBitLength]&&this.currentBitLength++}getNextCode(){this.nextData=this.nextData<<8|255&this.stripArray[this.bytePointer++],this.nextBits+=8,this.nextBits<this.currentBitLength&&(this.nextData=this.nextData<<8|255&this.stripArray[this.bytePointer++],this.nextBits+=8);const t=this.nextData>>this.nextBits-this.currentBitLength&andTable[this.currentBitLength-9];return this.nextBits-=this.currentBitLength,this.bytePointer>this.stripArray.length?257:t}}function decompressLzw(t){return new LzwDecoder(t).decode()}const dateTimeRegex=/^(\d{4}):(\d{2}):(\d{2}) (\d{2}):(\d{2}):(\d{2})$/;class TiffIfd extends IFD{constructor(){super("standard")}get size(){return this.width*this.height}get width(){return this.imageWidth}get height(){return this.imageLength}get components(){return this.samplesPerPixel}get date(){const t=new Date,e=dateTimeRegex.exec(this.dateTime);if(null===e)throw new Error(`invalid dateTime: ${this.dateTime}`);return t.setFullYear(Number(e[1]),Number(e[2])-1,Number(e[3])),t.setHours(Number(e[4]),Number(e[5]),Number(e[6])),t}get newSubfileType(){return this.get("NewSubfileType")}get imageWidth(){return this.get("ImageWidth")}get imageLength(){return this.get("ImageLength")}get bitsPerSample(){const t=this.get("BitsPerSample");return t&&"number"!=typeof t?t[0]:t}get alpha(){const t=this.extraSamples;return!!t&&0!==t[0]}get associatedAlpha(){const t=this.extraSamples;return!!t&&1===t[0]}get extraSamples(){return alwaysArray(this.get("ExtraSamples"))}get compression(){return this.get("Compression")||1}get type(){return this.get("PhotometricInterpretation")}get fillOrder(){return this.get("FillOrder")||1}get documentName(){return this.get("DocumentName")}get imageDescription(){return this.get("ImageDescription")}get stripOffsets(){return alwaysArray(this.get("StripOffsets"))}get orientation(){return this.get("Orientation")}get samplesPerPixel(){return this.get("SamplesPerPixel")||1}get rowsPerStrip(){return this.get("RowsPerStrip")||2**32-1}get stripByteCounts(){return alwaysArray(this.get("StripByteCounts"))}get minSampleValue(){return this.get("MinSampleValue")||0}get maxSampleValue(){return this.get("MaxSampleValue")||2**this.bitsPerSample-1}get xResolution(){return this.get("XResolution")}get yResolution(){return this.get("YResolution")}get planarConfiguration(){return this.get("PlanarConfiguration")||1}get resolutionUnit(){return this.get("ResolutionUnit")||2}get dateTime(){return this.get("DateTime")}get predictor(){return this.get("Predictor")||1}get sampleFormat(){return alwaysArray(this.get("SampleFormat")||1)[0]}get sMinSampleValue(){return this.get("SMinSampleValue")||this.minSampleValue}get sMaxSampleValue(){return this.get("SMaxSampleValue")||this.maxSampleValue}get palette(){const t=2**this.bitsPerSample,e=this.get("ColorMap");if(!e)return;if(e.length!==3*t)throw new Error(`ColorMap size must be ${t}`);const r=[];for(let n=0;n<t;n++)r.push([e[n],e[n+t],e[n+2*t]]);return r}get tileWidth(){return this.get("TileWidth")}get tileHeight(){return this.get("TileLength")}get tileOffsets(){return alwaysArray(this.get("TileOffsets"))}get tileByteCounts(){return alwaysArray(this.get("TileByteCounts"))}get tiled(){return void 0!==this.tileWidth&&void 0!==this.tileHeight&&void 0!==this.tileOffsets&&void 0!==this.tileByteCounts}}function alwaysArray(t){return"number"==typeof t?[t]:t}function decompressZlib(t){const e=new Uint8Array(t.buffer,t.byteOffset,t.byteLength),r=inflate_1(e);return new DataView(r.buffer,r.byteOffset,r.byteLength)}const defaultOptions={ignoreImageData:!1};class TIFFDecoder extends IOBuffer{_nextIFD;constructor(t){super(t),this._nextIFD=0}get isMultiPage(){let t=0;for(this.decodeHeader();this._nextIFD;)if(t++,this.decodeIFD({ignoreImageData:!0},!0),2===t)return!0;if(1===t)return!1;throw unsupported("ifdCount",t)}get pageCount(){let t=0;for(this.decodeHeader();this._nextIFD;)t++,this.decodeIFD({ignoreImageData:!0},!0);if(t>0)return t;throw unsupported("ifdCount",t)}decode(t={}){const{pages:e}=t;checkPages(e);const r=e?Math.max(...e):1/0;t={...defaultOptions,...t};const n=[];this.decodeHeader();let i=0;for(;this._nextIFD;){if(e){if(e.includes(i)?n.push(this.decodeIFD(t,!0)):this.decodeIFD({ignoreImageData:!0},!0),i===r)break}else n.push(this.decodeIFD(t,!0));i++}if(i<r&&r!==1/0)throw new RangeError(`Index ${r} is out of bounds. The stack only contains ${i} images.`);return n}decodeHeader(){const t=this.readUint16();if(18761===t)this.setLittleEndian();else{if(19789!==t)throw new Error(`invalid byte order: 0x${t.toString(16)}`);this.setBigEndian()}if(42!==this.readUint16())throw new Error("not a TIFF file");this._nextIFD=this.readUint32()}decodeIFD(t,e){let r;if(this.seek(this._nextIFD),e)r=new TiffIfd;else{if(!t.kind)throw new Error("kind is missing");r=new IFD(t.kind)}const n=this.readUint16();for(let t=0;t<n;t++)this.decodeIFDEntry(r);if(!t.ignoreImageData){if(!(r instanceof TiffIfd))throw new Error("must be a tiff ifd");this.decodeImageData(r)}return this._nextIFD=this.readUint32(),r}decodeIFDEntry(t){const e=this.offset,r=this.readUint16(),n=this.readUint16(),i=this.readUint32();if(n<1||n>12)return void this.skip(4);getByteLength(n,i)>4&&this.seek(this.readUint32());const o=readData(this,n,i);if(t.fields.set(r,o),34665===r||34853===r){const e=this.offset;let n="exif";34665===r?n="exif":34853===r&&(n="gps"),this._nextIFD=o,t[n]=this.decodeIFD({kind:n,ignoreImageData:!0},!1),this.offset=e}this.seek(e),this.skip(12)}decodeImageData(t){const e=t.orientation;if(e&&1!==e)throw unsupported("orientation",e);switch(t.type){case 0:case 1:case 2:case 3:t.tiled?this.readTileData(t):this.readStripData(t);break;default:throw unsupported("image type",t.type)}if(this.applyPredictor(t),this.convertAlpha(t),1===t.bitsPerSample&&this.split1BitData(t),0===t.type){const e=2**t.bitsPerSample-1;for(let r=0;r<t.data.length;r++)t.data[r]=e-t.data[r]}}split1BitData(t){const{imageWidth:e,imageLength:r,samplesPerPixel:n}=t,i=new Uint8Array(r*e*n),o=Math.ceil(e*n/8);let s=0;for(let a=0;a<r;a++){const r=a*o;for(let o=0;o<e*n;o++){const e=r+Math.floor(o/8),n=7-o%8,a=t.data[e]>>n&1;i[s++]=a}}t.data=i}static uncompress(t,e=1){switch(e){case 1:return t;case 5:return decompressLzw(t);case 8:case 32946:return decompressZlib(t);case 2:throw unsupported("Compression","CCITT Group 3");case 32773:throw unsupported("Compression","PackBits");default:throw unsupported("Compression",e)}}createSampleReader(t,e,r){if(8===e||1===e)return(t,e)=>t.getUint8(e);if(16===e)return(t,e)=>t.getUint16(2*e,r);if(32===e&&3===t)return(t,e)=>t.getFloat32(4*e,r);if(64===e&&3===t)return(t,e)=>t.getFloat64(8*e,r);throw unsupported("bitDepth",e)}readStripData(t){const e=t.width,r=t.height,n=1!==t.bitsPerSample?e*t.samplesPerPixel*r:Math.ceil(e*t.samplesPerPixel/8)*r,i=t.stripOffsets,o=t.stripByteCounts||guessStripByteCounts(t),s=this.isLittleEndian(),a=1!==t.bitsPerSample?e*t.samplesPerPixel*t.rowsPerStrip:Math.ceil(e*t.samplesPerPixel/8)*t.rowsPerStrip,l=this.createSampleReader(t.sampleFormat,t.bitsPerSample,s),h=getDataArray(n,t.bitsPerSample,t.sampleFormat);let c=0;for(let e=0;e<i.length;e++){const r=new DataView(this.buffer,this.byteOffset+i[e],o[e]),s=TIFFDecoder.uncompress(r,t.compression),u=Math.min(a,n-c);for(let t=0;t<u;++t){const e=l(s,t);h[c+t]=e}c+=u}t.data=h}readTileData(t){if(!t.tileWidth||!t.tileHeight)return;const e=t.width,r=t.height,n=1!==t.bitsPerSample?e*r*t.samplesPerPixel:Math.ceil(e*t.samplesPerPixel/8)*r,i=t.tileWidth,o=t.tileHeight,s=Math.ceil(e/i),a=Math.ceil(r/o),l=t.tileOffsets,h=t.tileByteCounts,c=this.isLittleEndian(),u=this.createSampleReader(t.sampleFormat,t.bitsPerSample,c),f=getDataArray(n,t.bitsPerSample,t.sampleFormat);for(let n=0;n<s;++n)for(let c=0;c<a;++c){const a=c*s+n,d=new DataView(this.buffer,this.byteOffset+l[a],h[a]),m=TIFFDecoder.uncompress(d,t.compression);if(1===t.bitsPerSample){const t=Math.ceil(e/8),s=Math.ceil(i/8);for(let e=0;e<o&&c*o+e<r;e++){const r=e*s,a=(c*o+e)*t+Math.floor(n*i/8),l=Math.min(s,t-Math.floor(n*i/8));for(let t=0;t<l;t++)f[a+t]=u(m,r+t)}}else for(let s=0;s<o;s++)for(let a=0;a<i;a++){const l=n*i+a,h=c*o+s;if(l>=e||h>=r)continue;const d=u(m,s*i+a);f[(h*e+l)*t.samplesPerPixel]=d}}t.data=f}applyPredictor(t){const e=t.bitsPerSample;switch(t.predictor){case 1:break;case 2:if(8===e)applyHorizontalDifferencing8Bit(t.data,t.width,t.components);else{if(16!==e)throw new Error(`Horizontal differencing is only supported for images with a bit depth of ${e}`);applyHorizontalDifferencing16Bit(t.data,t.width,t.components)}break;default:throw new Error(`invalid predictor: ${t.predictor}`)}}convertAlpha(t){if(t.alpha&&t.associatedAlpha){const{data:e,components:r,maxSampleValue:n}=t;for(let t=0;t<e.length;t+=r){const i=e[t+r-1];for(let o=0;o<r-1;o++)e[t+o]=Math.round(e[t+o]*n/i)}}}}function getDataArray(t,e,r){if(8===e||1===e)return new Uint8Array(t);if(16===e)return new Uint16Array(t);if(32===e&&3===r)return new Float32Array(t);if(64===e&&3===r)return new Float64Array(t);throw unsupported("bit depth / sample format",`${e} / ${r}`)}function unsupported(t,e){return new Error(`Unsupported ${t}: ${e}`)}function checkPages(t){if(t)for(const e of t)if(e<0||!Number.isInteger(e))throw new RangeError(`Index ${e} is invalid. Must be a positive integer.`)}function decodeTIFF(t,e){return new TIFFDecoder(t).decode(e)}function decode$1(t){const e=new IOBuffer(t),r={};e.setBigEndian();if(65496!==e.readUint16())throw new Error("SOI marker not found. Not a valid JPEG file");if(65505===e.readUint16()){e.skip(2);const t=e.readBytes(6);69===t[0]&&120===t[1]&&105===t[2]&&102===t[3]&&0===t[4]&&0===t[5]&&(r.exif=decodeTIFF(new Uint8Array(e.buffer,e.byteOffset+12,e.byteLength-12),{pages:[0],ignoreImageData:!0}))}return r}function getMetadata(t){return{tiff:{fields:t.fields,tags:t.map},exif:t.exif}}function decodeJpeg(t){const e=jpegJs.decode(t,{useTArray:!0,maxMemoryUsageInMB:Number.POSITIVE_INFINITY,maxResolutionInMP:Number.POSITIVE_INFINITY}),r=decode$1(t),n=r.exif?.[0]?getMetadata(r.exif[0]):void 0;return new Image(e.width,e.height,{data:e.data,colorModel:"RGBA",meta:n})}function decodePng(t){const e=decodePng$1(t);let r;const n=e.depth;if(e.palette)return loadPalettePng(e);if(1===n)return new Image(e.width,e.height,{data:decodeBinary(e),colorModel:"GREY"});switch(e.channels){case 1:r="GREY";break;case 2:r="GREYA";break;case 3:r="RGB";break;case 4:r="RGBA";break;default:throw new RangeError(`invalid number of channels: ${e.channels}`)}let i;return e.resolution&&(i=1===e.resolution.unit?{x:e.resolution.x,y:e.resolution.y,unit:"meter"}:{x:e.resolution.x,y:e.resolution.y,unit:"unknown"}),new Image(e.width,e.height,{colorModel:r,bitDepth:n,data:e.data,resolution:i})}function loadPalettePng(t){assert(t.palette);const e=t.width*t.height,r=new Uint8Array(e*t.palette[0].length),n=8/t.depth,i=t.depth<8?n:1,o=Number.parseInt("1".repeat(t.depth),2);let s=0;for(let a=0;a<e;a++){const e=Math.floor(a/i);let l=t.data[e];t.depth<8&&(l=l>>>t.depth*(n-1-a%n)&o);const h=t.palette[l];for(const t of h)r[s++]=t}return new Image(t.width,t.height,{data:r,colorModel:4===t.palette[0].length?"RGBA":"RGB"})}function decodeBinary(t){const e=t.width*t.height,r=new Uint8Array(e),n=t.data,i=t.width%8,o=Math.ceil(t.width/8);let s=0;for(let t=0;t<n.length&&s<e;t++){const a=n[t],l=t%o===0?8-i:0;for(let t=7;t>=l&&s<e;t--){const e=a>>t&1;r[s++]=255*e}}return r}function decodeTiff(t){return getImageFromIFD(decodeTIFF(t,{pages:[0]})[0])}function getImageFromIFD(t){if(t.data instanceof Float32Array||t.data instanceof Float64Array)throw new Error("Float TIFF data is not supported.");const e=getTiffResolution(t);if(3===t.type){const r=2===t.samplesPerPixel,n=new Uint16Array((r?4:3)*t.width*t.height),i=t.palette;let o=0;if(r)for(let e=0;e<t.data.length;e+=t.samplesPerPixel){const r=i[t.data[e]];n[o++]=r[0],n[o++]=r[1],n[o++]=r[2],n[o++]=Math.round(t.data[e+1]/2**t.bitsPerSample*65535)}else for(let e=0;e<t.data.length;e+=t.samplesPerPixel){const r=i[t.data[e]];n[o++]=r[0],n[o++]=r[1],n[o++]=r[2]}return new Image(t.width,t.height,{data:n,colorModel:r?"RGBA":"RGB",bitDepth:16,meta:getMetadata(t),resolution:e})}return 1===t.type||0===t.type?1!==t.bitsPerSample?new Image(t.width,t.height,{data:t.data,bitDepth:t.bitsPerSample,colorModel:t.alpha?"GREYA":"GREY",meta:getMetadata(t),resolution:e}):new Image(t.width,t.height,{data:t.data.map(t=>255*t),bitDepth:8,colorModel:"GREY",meta:getMetadata(t),resolution:e}):new Image(t.width,t.height,{data:t.data,bitDepth:t.bitsPerSample,colorModel:t.alpha?"RGBA":"RGB",meta:getMetadata(t),resolution:e})}function getTiffResolution(t){if(t.xResolution&&t.yResolution)switch(t.resolutionUnit){case 1:return{x:t.xResolution,y:t.yResolution,unit:"unknown"};case 3:return{x:t.xResolution,y:t.yResolution,unit:"centimeter"};default:return{x:t.xResolution,y:t.yResolution,unit:"inch"}}}function decode(t){const e=new Uint8Array(t.buffer,t.byteOffset,t.byteLength),r=imageType$1(e);return M$2(r).with({mime:"image/png"},()=>decodePng(e)).with({mime:"image/jpeg"},()=>decodeJpeg(e)).with({mime:"image/tiff"},()=>decodeTiff(e)).with({mime:"image/bmp"},()=>decodeBmp(e)).otherwise(()=>{throw new RangeError(`invalid data format: ${r?.mime}`)})}async function read(t){const e=getNodeApiOrThrow("read");return decode(await e.fs.promises.readFile(t))}function readSync(t){return decode(getNodeApiOrThrow("readSync").fs.readFileSync(t))}function readCanvas(t){const e=t.getContext("2d");assert(e);const r=e.getImageData(0,0,t.width,t.height);return new Image(r.width,r.height,{data:new Uint8Array(r.data.buffer,r.data.byteOffset,r.data.byteLength),colorModel:"RGBA"})}function readImg(t){const e=document.createElement("canvas");e.width=t.width,e.height=t.height;const r=e.getContext("2d");return assert(r),r.drawImage(t,0,0),readCanvas(e)}async function fetchURL(t){const e=await fetch(t),r=await e.arrayBuffer();return decode(new DataView(r))}function hsvToRgb(t){const e=t[0],r=t[1]/255,n=t[2]/255,i=r*n,o=i*(1-Math.abs(e/60%2-1)),s=n-i;let a,l,h;e>=0&&e<60?(a=i,l=o,h=0):e>=60&&e<120?(a=o,l=i,h=0):e>=120&&e<180?(a=0,l=i,h=o):e>=180&&e<240?(a=0,l=o,h=i):e>=240&&e<300?(a=o,l=0,h=i):(a=i,l=0,h=o);const c=new Uint8Array(3);return c[0]=255*(a+s),c[1]=255*(l+s),c[2]=255*(h+s),c}function rgbToNumber(t){return 4278190080+(t[2]<<16)+(t[1]<<8)+t[0]}function getBinaryMap(t){const{nbNegative:e,nbPositive:r,whiteHue:n=120,blackHue:i=0,roiKind:o="bw"}=t,s=new Uint32Array(e+r+1);if("bw"===o||"black"===o)for(let t=-e;t<0;t++){const r=[i,255,255];s[t+e]=rgbToNumber(hsvToRgb(r))}if("bw"===o||"white"===o)for(let t=1;t<=r;t++){const r=[n,255,255];s[t+e]=rgbToNumber(hsvToRgb(r))}return s}function getRainbowMap(t){const{nbNegative:e,nbPositive:r,roiKind:n="bw"}=t,i=new Uint32Array(e+r+1),o=M$2(n).with("bw",()=>360/(e+r)).with("black",()=>360/e).with("white",()=>360/r).exhaustive();let s=0;if("bw"===n||"black"===n)for(let t=-e;t<0;t++){const r=[s,255,255];i[t+e]=rgbToNumber(hsvToRgb(r)),s+=o}if("bw"===n||"white"===n)for(let t=1;t<=r;t++){const r=[s,255,255];i[t+e]=rgbToNumber(hsvToRgb(r)),s+=o}return i}function getSaturationMap(t){const{nbNegative:e,nbPositive:r,roiKind:n="bw",whiteHue:i=0,blackHue:o=240}=t,s=new Uint32Array(e+r+1),a=192/e,l=192/r;let h=0;if("bw"===n||"black"===n)for(let t=-e;t<0;t++){const r=[o,255-h++*a,255];s[t+e]=rgbToNumber(hsvToRgb(r))}if(h=0,"bw"===n||"white"===n)for(let t=1;t<=r;t++){const r=[i,255-h++*l,255];s[t+e]=rgbToNumber(hsvToRgb(r))}return s}function getColorMap(t){const{mode:e="binary"}=t;return t={roiKind:"bw",...t},M$2(e).with("binary",()=>getBinaryMap(t)).with("saturation",()=>getSaturationMap(t)).with("rainbow",()=>getRainbowMap(t)).exhaustive()}const RoisColorMode={BINARY:"binary",SATURATION:"saturation",RAINBOW:"rainbow"};function colorRois(t,e={}){const{roiKind:r="bw",mode:n="binary"}=e,i=t.getMap(),o=new Image(i.width,i.height,{colorModel:"RGBA"}),s=getColorMap({roiKind:r,mode:n,nbNegative:i.nbNegative,nbPositive:i.nbPositive}),a=new Uint32Array(o.getRawImage().data.buffer);for(let t=0;t<o.size;t++)a[t]=s[i.data[t]+i.nbNegative];return o}function getBorderPoints(t,e={}){return t.getMask().getBorderPoints(e)}function getMask(t,e={}){const{solidFill:r=!1}=e,n=new Mask(t.width,t.height,{origin:t.origin});for(let e=0;e<t.height;e++)for(let r=0;r<t.width;r++)t.getMapValue(t.origin.column+r,t.origin.row+e)===t.id?n.setBit(r,e,1):n.setBit(r,e,0);return r&&n.solidFill({out:n}),n}function getEllipse(t){const e=t.centroid.column,r=t.centroid.row,n=t.relativePoints.map(t=>t.column-e),i=t.relativePoints.map(t=>t.row-r),o=xVariance(n,{unbiased:!1}),s=xVariance(i,{unbiased:!1}),a=xyCovariance({x:n,y:i},{unbiased:!1}),l=new EigenvalueDecomposition([[o,a],[a,s]]),h=l.realEigenvalues,c=l.eigenvectorMatrix;assert(h[0]<=h[1]);let u=Math.sqrt(h[1]),f=Math.sqrt(h[0]);const d=c.getColumn(1),m=c.getColumn(0);let g={column:e+u*d[0],row:r+u*d[1]},p={column:e-u*d[0],row:r-u*d[1]},w={column:e+f*m[0],row:r+f*m[1]},b={column:e-f*m[0],row:r-f*m[1]},_=Math.hypot(g.column-p.column,g.row-p.row),y=Math.hypot(w.column-p.column,w.row-b.row),x=y/2*_/2*Math.PI;if(x!==t.surface){const n=Math.sqrt(t.surface/x);u*=n,f*=n,g={column:e+u*d[0],row:r+u*d[1]},p={column:e-u*d[0],row:r-u*d[1]},w={column:e+f*m[0],row:r+f*m[1]},b={column:e-f*m[0],row:r-f*m[1]},_*=n,y*=n,x*=n**2}return{center:{column:e,row:r},majorAxis:{points:[g,p],length:_,angle:toDegrees(getAngle(g,p))},minorAxis:{points:[w,b],length:y,angle:toDegrees(getAngle(w,b))},surface:x}}class Roi{map;id;origin;width;height;surface;#a;constructor(t,e,r,n,i,o){this.map=t,this.id=e,this.origin=i,this.width=r,this.height=n,this.surface=o,this.#a={}}getMapValue(t,e){return this.map.data[this.map.width*e+t]}getRatio(){return this.width/this.height}getMask(t){return getMask(this,t)}get ped(){return this.perimeter/Math.PI}getBorderPoints(t){return getBorderPoints(this,t)}get internalIDs(){return this.#l("internalIDs",()=>{const t=[this.id],e=this.map,r=e.data;if(this.height>2)for(let n=0;n<this.width;n++){const i=this.#h(0,n);if(t.includes(r[i])){const n=r[i+e.width];t.includes(n)||this.boxIDs.includes(n)||t.push(n)}}const n=new Array(4);for(let i=1;i<this.width-1;i++)for(let o=1;o<this.height-1;o++){const s=this.#h(o,i);if(t.includes(r[s])){n[0]=r[s-1],n[1]=r[s+1],n[2]=r[s-e.width],n[3]=r[s+e.width];for(let e=0;e<4;e++){const r=n[e];t.includes(r)||this.boxIDs.includes(r)||t.push(r)}}}return t})}get externalBorders(){return this.#l("externalBorders",()=>{const t=this.borders,e=[],r=[],n=this.internalIDs;for(const i of t)if(!n.includes(i.connectedID)){const t={connectedID:i.connectedID,length:i.length};r.push(t.connectedID),e.push(t)}return e})}get perimeterInfo(){return this.#l("perimeterInfo",()=>{const t=this.map,e=t.data;let r=0,n=0,i=0,o=0;const s=new Set(this.externalBorders.map(t=>t.connectedID));for(let a=0;a<this.width;a++)for(let l=0;l<this.height;l++){const h=this.#h(l,a);if(e[h]===this.id){let c=0;switch((0===a||s.has(e[h-1]))&&c++,(a===t.width-1||s.has(e[h+1]))&&c++,(0===l||s.has(e[h-t.width]))&&c++,(l===t.height-1||s.has(e[h+t.width]))&&c++,c){case 1:r++;break;case 2:n++;break;case 3:i++;break;case 4:o++}}}return{one:r,two:n,three:i,four:o}})}get perimeter(){const t=this.perimeterInfo,e=2-Math.sqrt(2);return t.one+2*t.two+3*t.three+4*t.four-e*(t.two+2*t.three+t.four)}get relativePoints(){return this.#l("relativePoints",()=>Array.from(this.points(!1)))}get absolutePoints(){return this.#l("absolutePoints",()=>Array.from(this.points(!0)))}get boxIDs(){return this.#l("boxIDs",()=>{const t=new Set,e=this.map,r=e.data;for(const n of[0,this.height-1])for(let i=0;i<this.width;i++){const o=this.#h(n,i);if(i-this.origin.column>0&&r[o]===this.id&&r[o-1]!==this.id){const e=r[o-1];t.add(e)}if(e.width-i-this.origin.column>1&&r[o]===this.id&&r[o+1]!==this.id){const e=r[o+1];t.add(e)}}for(const n of[0,this.width-1])for(let i=0;i<this.height;i++){const o=this.#h(i,n);if(i-this.origin.row>0&&r[o]===this.id&&r[o-e.width]!==this.id){const n=r[o-e.width];t.add(n)}if(e.height-i-this.origin.row>1&&r[o]===this.id&&r[o+e.width]!==this.id){const n=r[o+e.width];t.add(n)}}return Array.from(t)})}get eqpc(){return 2*Math.sqrt(this.surface/Math.PI)}get ellipse(){return this.#l("ellipse",()=>getEllipse(this))}get holesInfo(){return this.#l("holesInfo",()=>{let t=0;const e=this.map.data;for(let r=1;r<this.width-1;r++)for(let n=1;n<this.height-1;n++){const i=this.#h(n,r);this.internalIDs.includes(e[i])&&e[i]!==this.id&&t++}return{number:this.internalIDs.length-1,surface:t}})}get borders(){return this.#l("borders",()=>{const t=this.map,e=t.data,r=new Set,n=new Map,i=new Set,o=[1,0,-1,0],s=[0,1,0,-1];for(let a=this.origin.column;a<=this.origin.column+this.width;a++)for(let l=this.origin.row;l<=this.origin.row+this.height;l++){if(e[a+l*t.width]===this.id)for(let h=0;h<4;h++){const c=a+o[h],u=l+s[h];if(c>=0&&u>=0&&c<t.width&&u<t.height){const o=c+u*t.width;if(e[o]!==this.id&&!i.has(o)){i.add(o),r.add(e[o]);let t=n.get(e[o]);t?n.set(e[o],++t):n.set(e[o],1)}}}}return Array.from(r).map(t=>({connectedID:t,length:n.get(t)}))})}get fillRatio(){return this.surface/(this.surface+this.holesInfo.surface)}get sphericity(){return 2*Math.sqrt(this.surface*Math.PI)/this.perimeter}get filledSurface(){return this.surface+this.holesInfo.surface}get solidity(){return this.surface/this.convexHull.surface}get convexHull(){return this.#l("convexHull",()=>getConvexHull(this.getMask()))}get mbr(){return this.#l("mbr",()=>getMbr(this.getMask()))}get roundness(){return 4*this.surface/(Math.PI*this.feret.maxDiameter.length**2)}get feret(){return this.#l("feret",()=>getFeret(this.getMask()))}toJSON(){return{id:this.id,origin:this.origin,height:this.height,width:this.width,surface:this.surface,eqpc:this.eqpc,ped:this.ped,feret:this.feret,fillRatio:this.fillRatio,sphericity:this.sphericity,roundness:this.roundness,solidity:this.solidity,perimeter:this.perimeter,convexHull:this.convexHull,mbr:this.mbr,filledSurface:this.filledSurface,centroid:this.centroid}}get centroid(){return this.#l("centroid",()=>{const t=this.map.data;let e=0,r=0;for(let n=0;n<this.width;n++)for(let i=0;i<this.height;i++){t[this.#h(i,n)]===this.id&&(e+=n,r+=i)}return{column:e/this.surface+this.origin.column,row:r/this.surface+this.origin.row}})}#l(t,e){if(void 0===this.#a[t]){const r=e();return this.#a[t]=r,r}return this.#a[t]}#h(t,e){const r=this.map;return(t+this.origin.row)*r.width+e+this.origin.column}*points(t){for(let e=0;e<this.height;e++)for(let r=0;r<this.width;r++){const n=(e+this.origin.row)*this.map.width+r+this.origin.column;this.map.data[n]===this.id&&(t?yield{column:this.origin.column+r,row:this.origin.row+e}:yield{column:r,row:e})}}}function computeRois(t){const e=t.getMap(),r=new Array(e.nbPositive),n=new Array(e.nbNegative);for(let t=0;t<e.nbPositive;t++)r[t]={minRow:e.height,minColumn:e.width,maxRow:-1,maxColumn:-1,surface:0,id:t+1};for(let t=0;t<e.nbNegative;t++)n[t]={borderLengths:[],borderIDs:[],minRow:e.height,minColumn:e.width,maxRow:-1,maxColumn:-1,surface:0,id:-t-1};for(let i=0;i<e.height;i++)for(let o=0;o<e.width;o++){const e=t.getMapValue(o,i);if(0===e)continue;let s;s=e<0?n[-e-1]:r[e-1],s.surface++,i<s.minRow&&(s.minRow=i),i>s.maxRow&&(s.maxRow=i),o<s.minColumn&&(s.minColumn=o),o>s.maxColumn&&(s.maxColumn=o)}t.whiteRois=new Array(e.nbPositive),t.blackRois=new Array(e.nbNegative);for(let r=0;r<e.nbNegative;r++){const i=n[r].maxColumn-n[r].minColumn+1,o=n[r].maxRow-n[r].minRow+1,s={row:n[r].minRow,column:n[r].minColumn},a=n[r].id,l=n[r].surface,h=new Roi(e,a,i,o,s,l);t.blackRois[r]=h}for(let n=0;n<e.nbPositive;n++){const i=r[n].maxColumn-r[n].minColumn+1,o=r[n].maxRow-r[n].minRow+1,s={row:r[n].minRow,column:r[n].minColumn},a=r[n].id,l=r[n].surface,h=new Roi(e,a,i,o,s,l);t.whiteRois[n]=h}}const RoiKind={BLACK:"black",WHITE:"white",BW:"bw"};function getRois(t,e={}){const{minSurface:r=0,maxSurface:n=Number.MAX_SAFE_INTEGER,kind:i="white"}=e;0===t.blackRois.length&&0===t.whiteRois.length&&computeRois(t);return M$2(i).with("black",()=>t.blackRois).with("white",()=>t.whiteRois).with("bw",()=>[...t.whiteRois,...t.blackRois]).exhaustive().filter(t=>t.surface>=r&&t.surface<=n)}class RoiMapManager{map;whiteRois;blackRois;constructor(t){this.map=t,this.whiteRois=[],this.blackRois=[]}getMap(){return this.map}getMapValue(t,e){return this.map.data[this.map.width*e+t]}getMapMatrix(){return Matrix.from1DArray(this.map.height,this.map.width,this.map.data).to2DArray()}getRois(t={}){return getRois(this,t)}getRoiById(t){const e=this.getRois({kind:"bw"}).find(e=>e.id===t);if(!e)throw new Error(`invalid ID: ${t}`);return e}static fromMask(t,e={}){return fromMask(t,e)}}function fromMask(t,e={}){const{allowCorners:r=!1}=e,n=65535,i=-2147483647,o=new Int32Array(t.size);let s=0,a=0;const l=new Uint16Array(65536),h=new Uint16Array(65536);for(let e=0;e<t.width;e++)for(let r=0;r<t.height;r++)0===o[r*t.width+e]&&c(e,r);function c(e,c){let u=0,f=0;const d=t.getBit(e,c),m=d?++s:--a;for(assert(s<=2147483647&&a>=i,"too many regions of interest"),l[0]=e,h[0]=c;u<=f;){const e=l[u&n],s=h[u&n];o[s*t.width+e]=m,e>0&&0===o[s*t.width+e-1]&&t.getBit(e-1,s)===d&&(f++,l[f&n]=e-1,h[f&n]=s,o[s*t.width+e-1]=i),s>0&&0===o[(s-1)*t.width+e]&&t.getBit(e,s-1)===d&&(f++,l[f&n]=e,h[f&n]=s-1,o[(s-1)*t.width+e]=i),e<t.width-1&&0===o[s*t.width+e+1]&&t.getBit(e+1,s)===d&&(f++,l[f&n]=e+1,h[f&n]=s,o[s*t.width+e+1]=i),s<t.height-1&&0===o[(s+1)*t.width+e]&&t.getBit(e,s+1)===d&&(f++,l[f&n]=e,h[f&n]=s+1,o[(s+1)*t.width+e]=i),r&&(e>0&&s>0&&0===o[(s-1)*t.width+e-1]&&t.getBit(e-1,s-1)===d&&(f++,l[f&n]=e-1,h[f&n]=s-1,o[(s-1)*t.width+e-1]=i),e<t.width-1&&s>0&&0===o[(s-1)*t.width+e+1]&&t.getBit(e+1,s-1)===d&&(f++,l[f&n]=e+1,h[f&n]=s-1,o[(s-1)*t.width+e+1]=i),e>0&&s<t.height-1&&0===o[(s+1)*t.width+e-1]&&t.getBit(e-1,s+1)===d&&(f++,l[f&n]=e-1,h[f&n]=s+1,o[(s+1)*t.width+e-1]=i),e<t.width-1&&s<t.height-1&&0===o[(s+1)*t.width+e+1]&&t.getBit(e+1,s+1)===d&&(f++,l[f&n]=e+1,h[f&n]=s+1,o[(s+1)*t.width+e+1]=i)),u++,assert(f-u<=n,"fromMask can not finish, the array to manage internal data is not big enough.You could improve mask by changing MAX_ARRAY")}}return new RoiMapManager({width:t.width,height:t.height,data:o,nbNegative:Math.abs(a),nbPositive:s})}function commonjsRequire(t){throw new Error('Could not dynamically require "'+t+'". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.')}var priorityQueue={exports:{}};!function(t,e){t.exports=function t(e,r,n){function i(s,a){if(!r[s]){if(!e[s]){var l="function"==typeof commonjsRequire&&commonjsRequire;if(!a&&l)return l(s,!0);if(o)return o(s,!0);var h=new Error("Cannot find module '"+s+"'");throw h.code="MODULE_NOT_FOUND",h}var c=r[s]={exports:{}};e[s][0].call(c.exports,function(t){var r=e[s][1][t];return i(r||t)},c,c.exports,t,e,r,n)}return r[s].exports}for(var o="function"==typeof commonjsRequire&&commonjsRequire,s=0;s<n.length;s++)i(n[s]);return i}({1:[function(t,e,r){var n,i,o,s,a,l=function(t,e){for(var r in e)h.call(e,r)&&(t[r]=e[r]);function n(){this.constructor=t}return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},h={}.hasOwnProperty;n=t("./PriorityQueue/AbstractPriorityQueue"),i=t("./PriorityQueue/ArrayStrategy"),s=t("./PriorityQueue/BinaryHeapStrategy"),o=t("./PriorityQueue/BHeapStrategy"),a=function(t){function e(t){t||(t={}),t.strategy||(t.strategy=s),t.comparator||(t.comparator=function(t,e){return(t||0)-(e||0)}),e.__super__.constructor.call(this,t)}return l(e,t),e}(n),a.ArrayStrategy=i,a.BinaryHeapStrategy=s,a.BHeapStrategy=o,e.exports=a},{"./PriorityQueue/AbstractPriorityQueue":2,"./PriorityQueue/ArrayStrategy":3,"./PriorityQueue/BHeapStrategy":4,"./PriorityQueue/BinaryHeapStrategy":5}],2:[function(t,e,r){e.exports=function(){function t(t){var e;if(null==(null!=t?t.strategy:void 0))throw"Must pass options.strategy, a strategy";if(null==(null!=t?t.comparator:void 0))throw"Must pass options.comparator, a comparator";this.priv=new t.strategy(t),this.length=(null!=t&&null!=(e=t.initialValues)?e.length:void 0)||0}return t.prototype.queue=function(t){this.length++,this.priv.queue(t)},t.prototype.dequeue=function(t){if(!this.length)throw"Empty queue";return this.length--,this.priv.dequeue()},t.prototype.peek=function(t){if(!this.length)throw"Empty queue";return this.priv.peek()},t.prototype.clear=function(){return this.length=0,this.priv.clear()},t}()},{}],3:[function(t,e,r){var n;n=function(t,e,r){var n,i,o;for(i=0,n=t.length;i<n;)r(t[o=i+n>>>1],e)>=0?i=o+1:n=o;return i},e.exports=function(){function t(t){var e;this.options=t,this.comparator=this.options.comparator,this.data=(null!=(e=this.options.initialValues)?e.slice(0):void 0)||[],this.data.sort(this.comparator).reverse()}return t.prototype.queue=function(t){var e;e=n(this.data,t,this.comparator),this.data.splice(e,0,t)},t.prototype.dequeue=function(){return this.data.pop()},t.prototype.peek=function(){return this.data[this.data.length-1]},t.prototype.clear=function(){this.data.length=0},t}()},{}],4:[function(t,e,r){e.exports=function(){function t(t){var e,r,n,i,o,s,a,l;for(this.comparator=(null!=t?t.comparator:void 0)||function(t,e){return t-e},this.pageSize=(null!=t?t.pageSize:void 0)||512,this.length=0,a=0;1<<a<this.pageSize;)a+=1;if(1<<a!==this.pageSize)throw"pageSize must be a power of two";for(this._shift=a,this._emptyMemoryPageTemplate=e=[],r=0,o=this.pageSize;0<=o?r<o:r>o;0<=o?++r:--r)e.push(null);if(this._memory=[],this._mask=this.pageSize-1,t.initialValues)for(n=0,i=(s=t.initialValues).length;n<i;n++)l=s[n],this.queue(l)}return t.prototype.queue=function(t){this.length+=1,this._write(this.length,t),this._bubbleUp(this.length,t)},t.prototype.dequeue=function(){var t,e;return t=this._read(1),e=this._read(this.length),this.length-=1,this.length>0&&(this._write(1,e),this._bubbleDown(1,e)),t},t.prototype.peek=function(){return this._read(1)},t.prototype.clear=function(){this.length=0,this._memory.length=0},t.prototype._write=function(t,e){var r;for(r=t>>this._shift;r>=this._memory.length;)this._memory.push(this._emptyMemoryPageTemplate.slice(0));return this._memory[r][t&this._mask]=e},t.prototype._read=function(t){return this._memory[t>>this._shift][t&this._mask]},t.prototype._bubbleUp=function(t,e){var r,n,i,o;for(r=this.comparator;t>1&&(n=t&this._mask,t<this.pageSize||n>3?i=t&~this._mask|n>>1:n<2?(i=t-this.pageSize>>this._shift,i+=i&~(this._mask>>1),i|=this.pageSize>>1):i=t-2,!(r(o=this._read(i),e)<0));)this._write(i,e),this._write(t,o),t=i},t.prototype._bubbleDown=function(t,e){var r,n,i,o,s;for(s=this.comparator;t<this.length;)if(t>this._mask&&!(t&this._mask-1)?r=n=t+2:t&this.pageSize>>1?(r=(t&~this._mask)>>1,n=1+(r=1+(r|=t&this._mask>>1)<<this._shift)):n=(r=t+(t&this._mask))+1,r!==n&&n<=this.length)if(i=this._read(r),o=this._read(n),s(i,e)<0&&s(i,o)<=0)this._write(r,e),this._write(t,i),t=r;else{if(!(s(o,e)<0))break;this._write(n,e),this._write(t,o),t=n}else{if(!(r<=this.length))break;if(!(s(i=this._read(r),e)<0))break;this._write(r,e),this._write(t,i),t=r}},t}()},{}],5:[function(t,e,r){e.exports=function(){function t(t){var e;this.comparator=(null!=t?t.comparator:void 0)||function(t,e){return t-e},this.length=0,this.data=(null!=(e=t.initialValues)?e.slice(0):void 0)||[],this._heapify()}return t.prototype._heapify=function(){var t,e,r;if(this.data.length>0)for(t=e=1,r=this.data.length;1<=r?e<r:e>r;t=1<=r?++e:--e)this._bubbleUp(t)},t.prototype.queue=function(t){this.data.push(t),this._bubbleUp(this.data.length-1)},t.prototype.dequeue=function(){var t,e;return e=this.data[0],t=this.data.pop(),this.data.length>0&&(this.data[0]=t,this._bubbleDown(0)),e},t.prototype.peek=function(){return this.data[0]},t.prototype.clear=function(){this.length=0,this.data.length=0},t.prototype._bubbleUp=function(t){for(var e,r;t>0&&(e=t-1>>>1,this.comparator(this.data[t],this.data[e])<0);)r=this.data[e],this.data[e]=this.data[t],this.data[t]=r,t=e},t.prototype._bubbleDown=function(t){var e,r,n,i,o;for(e=this.data.length-1;i=1+(r=1+(t<<1)),n=t,r<=e&&this.comparator(this.data[r],this.data[n])<0&&(n=r),i<=e&&this.comparator(this.data[i],this.data[n])<0&&(n=i),n!==t;)o=this.data[n],this.data[n]=this.data[t],this.data[t]=o,t=n},t}()},{}]},{},[1])(1)}(priorityQueue);var priorityQueueExports=priorityQueue.exports,PriorityQueue=getDefaultExportFromCjs(priorityQueueExports);function waterShed(t,e){let{points:r}=e;const{mask:n,threshold:i=1}=e,o=t;checkProcessable$1(t,{bitDepth:[8,16],components:1});const s=i*t.maxValue;r||(r=getExtrema(t,{kind:"minimum",mask:n}));const a=new Int32Array(o.size),l=o.width,h=o.height,c=new PriorityQueue({comparator:(t,e)=>t.intensity-e.intensity,strategy:PriorityQueue.BinaryHeapStrategy});for(let t=0;t<r.length;t++){const e=r[t].column+r[t].row*l;a[e]=-t-1;const n=o.getValueByIndex(e,0);n<=s&&c.queue({column:r[t].column,row:r[t].row,intensity:n})}const u=[1,0,-1,0,1,1,-1,-1],f=[0,1,0,-1,1,-1,1,-1];for(;c.length>0;){const t=c.dequeue(),e=t.column+t.row*l;for(let r=0;r<4;r++){const i=t.column+u[r],d=t.row+f[r];if(i>=0&&d>=0&&i<l&&d<h){const h=i+d*l;if(!n||0===n.getBitByIndex(h)){const n=o.getValueByIndex(h,0);n<=s&&0===a[h]&&(a[h]=a[e],c.queue({column:t.column+u[r],row:t.row+f[r],intensity:n}))}}}}const d=r.length;return new RoiMapManager({data:a,nbPositive:0,nbNegative:d,width:t.width,height:t.height})}function checkProcessable(t,e={}){const{sameDimensions:r=!1,alpha:n}=e;let{bitDepth:i}=e;if(r){const e=t.getImage(0).width,r=t.getImage(0).height;for(let n=1;n<t.size;n++){const i=t.getImage(n);if(i.width!==e||i.height!==r)throw new RangeError("images must all have same dimensions to apply this algorithm")}}if(void 0!==n&&n!==t.alpha)throw new RangeError(`stack images ${n?"should":"should not"} have an alpha channel to apply this algorithm`);if(i&&(Array.isArray(i)||(i=[i]),!i.includes(t.bitDepth)))throw new RangeError(`image bitDepth must be ${format(i)} to apply this algorithm`)}function histogram(t,e){checkProcessable(t,{bitDepth:[8,16]});const{slots:r=2**t.bitDepth,channel:n=0}=e,i=new Uint32Array(r);for(let e=0;e<t.size;e++){const o=t.getImage(e).histogram({channel:n,slots:r});for(const[t,e]of o.entries())i[t]+=e}return i}function maxImage(t){checkProcessable(t,{sameDimensions:!0});const e=Image.createFrom(t.getImage(0)),r=e.channels;for(let n=0;n<t.size;n++)for(let i=0;i<e.size;i++)for(let o=0;o<r;o++)e.setValueByIndex(i,o,Math.max(e.getValueByIndex(i,o),t.getValueByIndex(n,i,o)));return e}function meanImage(t){checkProcessable(t,{sameDimensions:!0,bitDepth:[8,16]});const e=t.getImage(0),r=e.size*t.channels,n=new Uint32Array(r).fill(0);for(let r=0;r<t.size;r++)for(let i=0;i<e.size;i++)for(let e=0;e<t.channels;e++)n[i*t.channels+e]+=t.getValueByIndex(r,i,e);const i=Image.createFrom(e);for(let r=0;r<e.size;r++)for(let e=0;e<t.channels;e++){const o=r*t.channels+e;i.setValueByIndex(r,e,n[o]/t.size)}return i}function medianImage(t){checkProcessable(t,{sameDimensions:!0,bitDepth:[8,16]});const e=t.getImage(0),r=Image.createFrom(e);for(let n=0;n<e.size;n++)for(let e=0;e<t.channels;e++){const i=new Array(t.size);for(let r=0;r<t.size;r++)i[r]=t.getValueByIndex(r,n,e);r.setValueByIndex(n,e,quickMedian(i))}return r}function decodeStackFromApng(t){const e=decodeApng(t),r=[];let n;switch(e.channels){case 1:n=e.palette?3===e.palette[0].length?"RGB":"RGBA":"GREY";break;case 2:n="GREYA";break;case 3:n="RGB";break;default:n="RGBA"}if(e.palette)for(const t of e.frames)r.push(new Image(e.width,e.height,{data:convertIndexedData(t.data,e.palette),colorModel:n}));else for(const t of e.frames)r.push(new Image(e.width,e.height,{data:t.data,colorModel:n}));return new Stack(r)}function convertIndexedData(t,e){const r=new Uint8Array(t.length*e[0].length);for(let n=0;n<t.length;n++)for(let i=0;i<e[0].length;i++)r[n*e[0].length+i]=e[t[n]][i];return r}function decodeStackFromTiff(t){const e=decodeTIFF(t),r=[];for(const t of e)r.push(getImageFromIFD(t));return new Stack(r)}function decodeStack(t){const e=new Uint8Array(t.buffer,t.byteOffset,t.byteLength),r=imageType$1(e);return M$2(r).with({mime:"image/tiff"},()=>decodeStackFromTiff(e)).with({mime:"image/png"},()=>decodeStackFromApng(e)).otherwise(()=>{throw new RangeError(`invalid data format: ${r?.mime}`)})}function minImage(t){checkProcessable(t,{sameDimensions:!0});const e=Image.createFrom(t.getImage(0));e.fill(e.maxValue);const r=e.channels;for(let n=0;n<t.size;n++)for(let i=0;i<e.size;i++)for(let o=0;o<r;o++)e.setValueByIndex(i,o,Math.min(e.getValueByIndex(i,o),t.getValueByIndex(n,i,o)));return e}function sum(t){if(checkProcessable(t,{sameDimensions:!0,bitDepth:8}),t.size>257)throw new Error("Maximal valid stack size is 257");const e=t.getImage(0),r=e.size*t.channels,n=new Uint16Array(r).fill(0);for(let r=0;r<t.size;r++)for(let i=0;i<e.size;i++)for(let e=0;e<t.channels;e++)n[i*t.channels+e]+=t.getValueByIndex(r,i,e);return new Image(e.width,e.height,{data:n,colorModel:t.colorModel,bitDepth:16})}function checkImagesValid(t){const e=t[0].colorModel,r=t[0].bitDepth;for(const n of t)if(n.colorModel!==e||n.bitDepth!==r)throw new RangeError("images must all have the same bit depth and color model")}function verifySameDimensions(t){const e=t[0].width,r=t[0].height;for(const n of t)if(n.width!==e||n.height!==r)return!1;return!0}class Stack{images;size;alpha;colorModel;bitDepth;sameDimensions;channels;constructor(t){checkImagesValid(t),this.images=t,this.size=t.length,this.alpha=t[0].alpha,this.colorModel=t[0].colorModel,this.channels=t[0].channels,this.bitDepth=t[0].bitDepth,this.sameDimensions=verifySameDimensions(t)}*[Symbol.iterator](){for(const t of this.images)yield t}clone(){return new Stack(this.images.map(t=>t.clone()))}getImages(){return this.images}getImage(t){return this.images[t]}getValue(t,e,r,n){return this.images[t].getValue(e,r,n)}getValueByIndex(t,e,r){return this.images[t].getValueByIndex(e,r)}minImage(){return minImage(this)}maxImage(){return maxImage(this)}medianImage(){return medianImage(this)}meanImage(){return meanImage(this)}sum(){return sum(this)}histogram(t={}){return histogram(this,t)}map(t){return new Stack(this.images.map(t))}filter(t){return new Stack(this.images.filter(t))}}const channelLabels={GREY:["Grey"],GREYA:["Grey","Alpha"],RGB:["Red","Green","Blue"],RGBA:["Red","Green","Blue","Alpha"],BINARY:["Mask"]};function drawText(t,e,r){if(Array.isArray(e)&&0===e.length)throw new Error("At least one text element must be provided");const n=getOutputImage(t,r,{clone:!0}),i=r?.font??"12px Helvetica",o=r?.fontColor??[255,255,255,255],s=getCanvasContext(t.width,t.height);if(Array.isArray(e))for(const r of e)drawTextElement(t,s,r,i,o);else drawTextElement(t,s,e,i,o);return layerCanvas(n.getRawImage().data,s.getImageData(0,0,t.width,t.height).data,t.channels,t.bitDepth),n}function drawTextElement(t,e,r,n,i){e.font=r.font??n;const o=r.fontColor??i;validateValues(o,t);const s=o[3]?o[3]/255:1,a=[o[0]??0,o[1]??0,o[2]??0,s];e.fillStyle=`rgba(${a.join(",")})`,e.fillText(String(r.content),r.position.column,r.position.row)}function layerCanvas(t,e,r,n){const i=CHANNEL_CONFIGS[r]||CHANNEL_CONFIGS[1],o=e.length>>>2,s=n-8;let a=0,l=0;for(let n=0;n<o;n++){const n=e[l+3]/255;if(0===n){a+=r,l+=4;continue}const o=1-n;for(const r of i.channelOffsets){const i=a+r;t[i]=Math.round(e[l+r]*n+t[i]*o)<<s}if(i.hasAlpha){const e=a+i.alphaOffset,r=n+(t[e]>>>s)/255*(1-n);t[e]=Math.round(255*r)<<s}a+=r,l+=4}}const CHANNEL_CONFIGS={1:{channelOffsets:[0],hasAlpha:!1,alphaOffset:void 0},2:{channelOffsets:[0],hasAlpha:!0,alphaOffset:1},3:{channelOffsets:[0,1,2],hasAlpha:!1,alphaOffset:void 0},4:{channelOffsets:[0,1,2],hasAlpha:!0,alphaOffset:3}};exports.BorderType=BorderType,exports.DerivativeFilter=DerivativeFilter,exports.GreyAlgorithm=GreyAlgorithm,exports.Image=Image,exports.ImageColorModel=ImageColorModel,exports.ImageCoordinates=ImageCoordinates,exports.ImageFormat=ImageFormat,exports.InterpolationType=InterpolationType,exports.Mask=Mask,exports.Montage=Montage,exports.MontageDisposition=MontageDisposition,exports.Roi=Roi,exports.RoiKind=RoiKind,exports.RoiMapManager=RoiMapManager,exports.RoisColorMode=RoisColorMode,exports.Stack=Stack,exports.ThresholdAlgorithm=ThresholdAlgorithm,exports.add=add,exports.alignMinDifference=alignMinDifference,exports.and=and,exports.blur=blur,exports.bottomHat=bottomHat,exports.bruteForceOneMatch=bruteForceOneMatch,exports.cannyEdgeDetector=cannyEdgeDetector,exports.channelLabels=channelLabels,exports.clearBorder=clearBorder,exports.close=close,exports.colorModels=colorModels,exports.colorRois=colorRois,exports.computeConvolutionValue=computeConvolutionValue,exports.computeMse=computeMse,exports.computePsnr=computePsnr,exports.computeRmse=computeRmse,exports.computeRois=computeRois,exports.computeThreshold=computeThreshold,exports.convertBinaryToGrey=convertBinaryToGrey,exports.convertBinaryToRgb=convertBinaryToRgb,exports.convertBitDepth=convertBitDepth,exports.convertColor=convertColor,exports.copyAlpha=copyAlpha,exports.copyTo=copyTo,exports.correctBackground=correctBackground,exports.correctColor=correctColor,exports.crop=crop,exports.cropAlpha=cropAlpha,exports.cropRectangle=cropRectangle,exports.crosscheck=crosscheck,exports.decode=decode,exports.decodeJpeg=decodeJpeg,exports.decodePng=decodePng,exports.decodeStack=decodeStack,exports.decodeTiff=decodeTiff,exports.defaultPng=defaultPng,exports.derivativeFilter=derivativeFilter,exports.dilate=dilate,exports.directConvolution=directConvolution,exports.divide=divide,exports.drawCircleOnImage=drawCircleOnImage,exports.drawKeypoints=drawKeypoints,exports.drawLineOnImage=drawLineOnImage,exports.drawLineOnMask=drawLineOnMask,exports.drawMarker=drawMarker,exports.drawMarkers=drawMarkers,exports.drawMatches=drawMatches,exports.drawPoints=drawPoints,exports.drawPolygonOnImage=drawPolygonOnImage,exports.drawPolygonOnMask=drawPolygonOnMask,exports.drawPolylineOnImage=drawPolylineOnImage,exports.drawPolylineOnMask=drawPolylineOnMask,exports.drawRectangle=drawRectangle,exports.drawText=drawText,exports.encode=encode,exports.encodeDataURL=encodeDataURL,exports.encodeJpeg=encodeJpeg,exports.encodePng=encodePng,exports.erode=erode,exports.extendBorders=extendBorders,exports.extract=extract,exports.fetchURL=fetchURL,exports.flip=flip,exports.floodFill=floodFill,exports.fromMask=fromMask,exports.gaussianBlur=gaussianBlur,exports.getAffineTransform=getAffineTransform,exports.getBestKeypointsInRadius=getBestKeypointsInRadius,exports.getBorderPoints=getBorderPoints,exports.getBriefDescriptors=getBriefDescriptors,exports.getCrosscheckMatches=getCrosscheckMatches,exports.getDirection=getDirection,exports.getExtrema=getExtrema,exports.getFastKeypoints=getFastKeypoints,exports.getImageFromIFD=getImageFromIFD,exports.getIntensityCentroid=getIntensityCentroid,exports.getMask=getMask,exports.getOrientedFastKeypoints=getOrientedFastKeypoints,exports.getPerspectiveWarp=getPerspectiveWarp,exports.getRegressionVariables=getRegressionVariables,exports.getRois=getRois,exports.gradientFilter=gradientFilter,exports.grey=grey,exports.histogram=histogram$1,exports.hypotenuse=hypotenuse,exports.increaseContrast=increaseContrast,exports.invert=invert,exports.level=level,exports.mean=mean,exports.median=median,exports.medianFilter=medianFilter,exports.merge=merge,exports.morphologicalGradient=morphologicalGradient,exports.multiply=multiply,exports.open=open,exports.or=or,exports.order4Points=order4Points,exports.overlapImages=overlapImages,exports.paintMaskOnImage=paintMaskOnImage,exports.paintMaskOnMask=paintMaskOnMask,exports.pixelate=pixelate,exports.rawDirectConvolution=rawDirectConvolution,exports.read=read,exports.readCanvas=readCanvas,exports.readImg=readImg,exports.readSync=readSync,exports.removeClosePoints=removeClosePoints,exports.resize=resize,exports.rotate=rotate,exports.separableConvolution=separableConvolution,exports.solidFill=solidFill,exports.split=split,exports.subtract=subtract,exports.threshold=threshold,exports.topHat=topHat,exports.transform=transform,exports.transformRotate=transformRotate,exports.variance=variance,exports.waterShed=waterShed,exports.write=write,exports.writeCanvas=writeCanvas,exports.writeSync=writeSync});
//# sourceMappingURL=image-js.umd.min.js.map
