/* ml-gsd 13.1.0 | MIT | https://github.com/mljs/global-spectral-deconvolution */
const t=Object.prototype.toString;function e(e){const r=t.call(e);return r.endsWith("Array]")&&!r.includes("Big")}function r(t,r,o={}){const{windowSize:n=9,derivative:a=0,polynomial:h=3}=o;if(n%2==0||n<5||!Number.isInteger(n))throw new RangeError("Invalid window size (should be odd and at least 5 integer number)");if(!e(t))throw new TypeError("Y values must be an array");if(void 0===r)throw new TypeError("X must be defined");if(n>t.length)throw new RangeError(`Window size is higher than the data length ${n}>${t.length}`);if(a<0||!Number.isInteger(a))throw new RangeError("Derivative should be a positive integer");if(h<1||!Number.isInteger(h))throw new RangeError("Polynomial should be a positive integer");h>=6&&console.warn("You should not use polynomial grade higher than 5 if you are not sure that your data arises from such a model. Possible polynomial oscillation problems");const l=Math.floor(n/2),u=t.length,f=new Float64Array(u),c=function(t,e,r){const s=new Array(t),o=Math.floor(t/2);for(let n=-o;n<=o;n++){s[n+o]=new Float64Array(t);for(let t=-o;t<=o;t++)s[n+o][t+o]=i(t,n,o,e,r)}return s}(n,h,a);let m=0,g=!0;e(r)?g=!1:m=r**a;for(let e=0;e<l;e++){const o=c[l-e-1],i=c[l+e+1];let h=0,w=0;for(let e=0;e<n;e++)h+=o[e]*t[e],w+=i[e]*t[u-n+e];g?(f[l-e-1]=h/m,f[u-l+e]=w/m):(m=s(r,l-e-1,l,a),f[l-e-1]=h/m,m=s(r,u-l+e,l,a),f[u-l+e]=w/m)}const w=c[l];for(let e=n;e<=u;e++){let o=0;for(let r=0;r<n;r++)o+=w[r]*t[r+e-n];g||(m=s(r,e-l-1,l,a)),f[e-l-1]=o/m}return f}function s(t,e,r,s){let o=0,n=0;for(let s=e-r;s<e+r;s++)s>=0&&s<t.length-1&&(o+=t[s+1]-t[s],n++);return(o/n)**s}function o(t,e,r,s){let n=0;return n=r>0?(4*r-2)/(r*(2*e-r+1))*(t*o(t,e,r-1,s)+s*o(t,e,r-1,s-1))-(r-1)*(2*e+r)/(r*(2*e-r+1))*o(t,e,r-2,s):0===r&&0===s?1:0,n}function n(t,e){let r=1;if(t>=e)for(let s=t-e+1;s<=t;s++)r*=s;return r}function i(t,e,r,s,i){let a=0;for(let h=0;h<=s;h++)a+=(2*h+1)*(n(2*r,h)/n(2*r+h+1,h+1))*o(t,r,h,0)*o(e,r,h,i);return a}function a(t,r={}){if(!e(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");const{exact:s=!1}=r||{},o=t.slice(),n=u(0,o.length-1),i=h(o,n);if(o.length%2==1||!s)return i;return(i+h(o,n+1))/2}function h(t,e){let r=0,s=t.length-1,o=0,n=0,i=0;for(;;){if(s<=r)return t[e];if(s===r+1)return t[r]>t[s]&&l(t,r,s),t[e];for(o=u(r,s),t[o]>t[s]&&l(t,o,s),t[r]>t[s]&&l(t,r,s),t[o]>t[r]&&l(t,o,r),l(t,o,r+1),n=r+1,i=s;;){do{n++}while(t[r]>t[n]);do{i--}while(t[i]>t[r]);if(i<n)break;l(t,n,i)}l(t,r,i),i<=e&&(r=n),i>=e&&(s=i-1)}}function l(t,e,r){const s=t[r];t[r]=t[e],t[e]=s}function u(t,e){return Math.floor((t+e)/2)}function f(t,r={}){const{minLength:s}=r;if(!e(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if("number"!=typeof t[0])throw new TypeError("input must contain numbers");if(s&&t.length<s)throw new Error(`input must have a length of at least ${s}`)}function c(t,e,r={}){const{sorted:s=!0}=r;if(s){let r=0,s=t.length-1,o=0;for(;s-r>1;)if(o=r+(s-r>>1),t[o]<e)r=o;else{if(!(t[o]>e))return o;s=o}return r<t.length-1?Math.abs(e-t[r])<Math.abs(t[r+1]-e)?r:r+1:r}{let r=0,s=Number.POSITIVE_INFINITY;for(let o=0;o<t.length;o++){const n=Math.abs(t[o]-e);n<s&&(s=n,r=o)}return r}}function m(t,e={}){let{fromIndex:r,toIndex:s}=e;const{from:o,to:n}=e;return void 0===r&&(r=void 0!==o?c(t,o):0),void 0===s&&(s=void 0!==n?c(t,n):t.length-1),r<0&&(r=0),s<0&&(s=0),r>=t.length&&(r=t.length-1),s>=t.length&&(s=t.length-1),r>s&&([r,s]=[s,r]),{fromIndex:r,toIndex:s}}function g(t){if(Object.prototype.hasOwnProperty.call(t,"__esModule"))return t;var e=t.default;if("function"==typeof e){var r=function t(){var r=!1;try{r=this instanceof t}catch{}return r?Reflect.construct(e,arguments,this.constructor):e.apply(this,arguments)};r.prototype=e.prototype}else r={};return Object.defineProperty(r,"__esModule",{value:!0}),Object.keys(t).forEach(function(e){var s=Object.getOwnPropertyDescriptor(t,e);Object.defineProperty(r,e,s.get?s:{enumerable:!0,get:function(){return t[e]}})}),r}var w={},p=g(Object.freeze({__proto__:null,isAnyArray:e}));var d=g(Object.freeze({__proto__:null,default:function(t){var r,s=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!e(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");if(void 0!==s.output){if(!e(s.output))throw new TypeError("output option must be an array if specified");r=s.output}else r=new Array(t.length);var o=function(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!e(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var s=r.fromIndex,o=void 0===s?0:s,n=r.toIndex,i=void 0===n?t.length:n;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[o],h=o+1;h<i;h++)t[h]<a&&(a=t[h]);return a}(t),n=function(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(!e(t))throw new TypeError("input must be an array");if(0===t.length)throw new TypeError("input must not be empty");var s=r.fromIndex,o=void 0===s?0:s,n=r.toIndex,i=void 0===n?t.length:n;if(o<0||o>=t.length||!Number.isInteger(o))throw new Error("fromIndex must be a positive integer smaller than length");if(i<=o||i>t.length||!Number.isInteger(i))throw new Error("toIndex must be an integer greater than fromIndex and at most equal to length");for(var a=t[o],h=o+1;h<i;h++)t[h]>a&&(a=t[h]);return a}(t);if(o===n)throw new RangeError("minimum and maximum input values are equal. Cannot rescale a constant array");var i=s.min,a=void 0===i?s.autoMinMax?o:0:i,h=s.max,l=void 0===h?s.autoMinMax?n:1:h;if(a>=l)throw new RangeError("min option must be smaller than max option");for(var u=(l-a)/(n-o),f=0;f<t.length;f++)r[f]=(t[f]-o)*u+a;return r}}));Object.defineProperty(w,"__esModule",{value:!0});var y=p,x=d;const M=" ".repeat(2),b=" ".repeat(4);function v(t,e={}){const{maxRows:r=15,maxColumns:s=10,maxNumSize:o=8,padMinus:n="auto"}=e;return`${t.constructor.name} {\n${M}[\n${b}${function(t,e,r,s,o){const{rows:n,columns:i}=t,a=Math.min(n,e),h=Math.min(i,r),l=[];if("auto"===o){o=!1;t:for(let e=0;e<a;e++)for(let r=0;r<h;r++)if(t.get(e,r)<0){o=!0;break t}}for(let e=0;e<a;e++){let r=[];for(let n=0;n<h;n++)r.push(E(t.get(e,n),s,o));l.push(`${r.join(" ")}`)}h!==i&&(l[l.length-1]+=` ... ${i-r} more columns`);a!==n&&l.push(`... ${n-e} more rows`);return l.join(`\n${b}`)}(t,r,s,o,n)}\n${M}]\n${M}rows: ${t.rows}\n${M}columns: ${t.columns}\n}`}function E(t,e,r){return(t>=0&&r?` ${S(t,e-1)}`:S(t,e)).padEnd(e)}function S(t,e){let r=t.toString();if(r.length<=e)return r;let s=t.toFixed(e);if(s.length>e&&(s=t.toFixed(Math.max(0,e-(s.length-e)))),s.length<=e&&!s.startsWith("0.000")&&!s.startsWith("-0.000"))return s;let o=t.toExponential(e);return o.length>e&&(o=t.toExponential(Math.max(0,e-(o.length-e)))),o.slice(0)}function I(t,e,r){let s=r?t.rows:t.rows-1;if(e<0||e>s)throw new RangeError("Row index out of range")}function R(t,e,r){let s=r?t.columns:t.columns-1;if(e<0||e>s)throw new RangeError("Column index out of range")}function T(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.columns)throw new RangeError("vector size must be the same as the number of columns");return e}function A(t,e){if(e.to1DArray&&(e=e.to1DArray()),e.length!==t.rows)throw new RangeError("vector size must be the same as the number of rows");return e}function D(t,e){if(!y.isAnyArray(e))throw new TypeError("row indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.rows)throw new RangeError("row indices are out of range")}function N(t,e){if(!y.isAnyArray(e))throw new TypeError("column indices must be an array");for(let r=0;r<e.length;r++)if(e[r]<0||e[r]>=t.columns)throw new RangeError("column indices are out of range")}function V(t,e,r,s,o){if(5!==arguments.length)throw new RangeError("expected 4 arguments");if(F("startRow",e),F("endRow",r),F("startColumn",s),F("endColumn",o),e>r||s>o||e<0||e>=t.rows||r<0||r>=t.rows||s<0||s>=t.columns||o<0||o>=t.columns)throw new RangeError("Submatrix indices are out of range")}function k(t,e=0){let r=[];for(let s=0;s<t;s++)r.push(e);return r}function F(t,e){if("number"!=typeof e)throw new TypeError(`${t} must be a number`)}function C(t){if(t.isEmpty())throw new Error("Empty matrix has no elements to index")}class q{static from1DArray(t,e,r){if(t*e!==r.length)throw new RangeError("data length does not match given dimensions");let s=new L(t,e);for(let o=0;o<t;o++)for(let t=0;t<e;t++)s.set(o,t,r[o*e+t]);return s}static rowVector(t){let e=new L(1,t.length);for(let r=0;r<t.length;r++)e.set(0,r,t[r]);return e}static columnVector(t){let e=new L(t.length,1);for(let r=0;r<t.length;r++)e.set(r,0,t[r]);return e}static zeros(t,e){return new L(t,e)}static ones(t,e){return new L(t,e).fill(1)}static rand(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{random:s=Math.random}=r;let o=new L(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++)o.set(r,t,s());return o}static randInt(t,e,r={}){if("object"!=typeof r)throw new TypeError("options must be an object");const{min:s=0,max:o=1e3,random:n=Math.random}=r;if(!Number.isInteger(s))throw new TypeError("min must be an integer");if(!Number.isInteger(o))throw new TypeError("max must be an integer");if(s>=o)throw new RangeError("min must be smaller than max");let i=o-s,a=new L(t,e);for(let r=0;r<t;r++)for(let t=0;t<e;t++){let e=s+Math.round(n()*i);a.set(r,t,e)}return a}static eye(t,e,r){void 0===e&&(e=t),void 0===r&&(r=1);let s=Math.min(t,e),o=this.zeros(t,e);for(let t=0;t<s;t++)o.set(t,t,r);return o}static diag(t,e,r){let s=t.length;void 0===e&&(e=s),void 0===r&&(r=e);let o=Math.min(s,e,r),n=this.zeros(e,r);for(let e=0;e<o;e++)n.set(e,e,t[e]);return n}static min(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,s=t.columns,o=new L(r,s);for(let n=0;n<r;n++)for(let r=0;r<s;r++)o.set(n,r,Math.min(t.get(n,r),e.get(n,r)));return o}static max(t,e){t=this.checkMatrix(t),e=this.checkMatrix(e);let r=t.rows,s=t.columns,o=new this(r,s);for(let n=0;n<r;n++)for(let r=0;r<s;r++)o.set(n,r,Math.max(t.get(n,r),e.get(n,r)));return o}static checkMatrix(t){return q.isMatrix(t)?t:new L(t)}static isMatrix(t){return null!=t&&"Matrix"===t.klass}get size(){return this.rows*this.columns}apply(t){if("function"!=typeof t)throw new TypeError("callback must be a function");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.call(this,e,r);return this}to1DArray(){let t=[];for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.push(this.get(e,r));return t}to2DArray(){let t=[];for(let e=0;e<this.rows;e++){t.push([]);for(let r=0;r<this.columns;r++)t[e].push(this.get(e,r))}return t}toJSON(){return this.to2DArray()}isRowVector(){return 1===this.rows}isColumnVector(){return 1===this.columns}isVector(){return 1===this.rows||1===this.columns}isSquare(){return this.rows===this.columns}isEmpty(){return 0===this.rows||0===this.columns}isSymmetric(){if(this.isSquare()){for(let t=0;t<this.rows;t++)for(let e=0;e<=t;e++)if(this.get(t,e)!==this.get(e,t))return!1;return!0}return!1}isDistance(){if(!this.isSymmetric())return!1;for(let t=0;t<this.rows;t++)if(0!==this.get(t,t))return!1;return!0}isEchelonForm(){let t=0,e=0,r=-1,s=!0,o=!1;for(;t<this.rows&&s;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(o=!0,r=e):(s=!1,o=!0);t++}return s}isReducedEchelonForm(){let t=0,e=0,r=-1,s=!0,o=!1;for(;t<this.rows&&s;){for(e=0,o=!1;e<this.columns&&!1===o;)0===this.get(t,e)?e++:1===this.get(t,e)&&e>r?(o=!0,r=e):(s=!1,o=!0);for(let r=e+1;r<this.rows;r++)0!==this.get(t,r)&&(s=!1);t++}return s}echelonForm(){let t=this.clone(),e=0,r=0;for(;e<t.rows&&r<t.columns;){let s=e;for(let o=e;o<t.rows;o++)t.get(o,r)>t.get(s,r)&&(s=o);if(0===t.get(s,r))r++;else{t.swapRows(e,s);let o=t.get(e,r);for(let s=r;s<t.columns;s++)t.set(e,s,t.get(e,s)/o);for(let s=e+1;s<t.rows;s++){let o=t.get(s,r)/t.get(e,r);t.set(s,r,0);for(let n=r+1;n<t.columns;n++)t.set(s,n,t.get(s,n)-t.get(e,n)*o)}e++,r++}}return t}reducedEchelonForm(){let t=this.echelonForm(),e=t.columns,r=t.rows,s=r-1;for(;s>=0;)if(0===t.maxRow(s))s--;else{let o=0,n=!1;for(;o<r&&!1===n;)1===t.get(s,o)?n=!0:o++;for(let r=0;r<s;r++){let n=t.get(r,o);for(let i=o;i<e;i++){let e=t.get(r,i)-n*t.get(s,i);t.set(r,i,e)}}s--}return t}set(){throw new Error("set method is unimplemented")}get(){throw new Error("get method is unimplemented")}repeat(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{rows:e=1,columns:r=1}=t;if(!Number.isInteger(e)||e<=0)throw new TypeError("rows must be a positive integer");if(!Number.isInteger(r)||r<=0)throw new TypeError("columns must be a positive integer");let s=new L(this.rows*e,this.columns*r);for(let t=0;t<e;t++)for(let e=0;e<r;e++)s.setSubMatrix(this,this.rows*t,this.columns*e);return s}fill(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,t);return this}neg(){return this.mulS(-1)}getRow(t){I(this,t);let e=[];for(let r=0;r<this.columns;r++)e.push(this.get(t,r));return e}getRowVector(t){return L.rowVector(this.getRow(t))}setRow(t,e){I(this,t),e=T(this,e);for(let r=0;r<this.columns;r++)this.set(t,r,e[r]);return this}swapRows(t,e){I(this,t),I(this,e);for(let r=0;r<this.columns;r++){let s=this.get(t,r);this.set(t,r,this.get(e,r)),this.set(e,r,s)}return this}getColumn(t){R(this,t);let e=[];for(let r=0;r<this.rows;r++)e.push(this.get(r,t));return e}getColumnVector(t){return L.columnVector(this.getColumn(t))}setColumn(t,e){R(this,t),e=A(this,e);for(let r=0;r<this.rows;r++)this.set(r,t,e[r]);return this}swapColumns(t,e){R(this,t),R(this,e);for(let r=0;r<this.rows;r++){let s=this.get(r,t);this.set(r,t,this.get(r,e)),this.set(r,e,s)}return this}addRowVector(t){t=T(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[r]);return this}subRowVector(t){t=T(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[r]);return this}mulRowVector(t){t=T(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[r]);return this}divRowVector(t){t=T(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[r]);return this}addColumnVector(t){t=A(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t[e]);return this}subColumnVector(t){t=A(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t[e]);return this}mulColumnVector(t){t=A(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t[e]);return this}divColumnVector(t){t=A(this,t);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t[e]);return this}mulRow(t,e){I(this,t);for(let r=0;r<this.columns;r++)this.set(t,r,this.get(t,r)*e);return this}mulColumn(t,e){R(this,t);for(let r=0;r<this.rows;r++)this.set(r,t,this.get(r,t)*e);return this}max(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.NEGATIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)>t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}maxIndex(){C(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let s=0;s<this.columns;s++)this.get(r,s)>t&&(t=this.get(r,s),e[0]=r,e[1]=s);return e}min(t){if(this.isEmpty())return NaN;switch(t){case"row":{const t=new Array(this.rows).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[e]&&(t[e]=this.get(e,r));return t}case"column":{const t=new Array(this.columns).fill(Number.POSITIVE_INFINITY);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t[r]&&(t[r]=this.get(e,r));return t}case void 0:{let t=this.get(0,0);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.get(e,r)<t&&(t=this.get(e,r));return t}default:throw new Error(`invalid option: ${t}`)}}minIndex(){C(this);let t=this.get(0,0),e=[0,0];for(let r=0;r<this.rows;r++)for(let s=0;s<this.columns;s++)this.get(r,s)<t&&(t=this.get(r,s),e[0]=r,e[1]=s);return e}maxRow(t){if(I(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)>e&&(e=this.get(t,r));return e}maxRowIndex(t){I(this,t),C(this);let e=this.get(t,0),r=[t,0];for(let s=1;s<this.columns;s++)this.get(t,s)>e&&(e=this.get(t,s),r[1]=s);return r}minRow(t){if(I(this,t),this.isEmpty())return NaN;let e=this.get(t,0);for(let r=1;r<this.columns;r++)this.get(t,r)<e&&(e=this.get(t,r));return e}minRowIndex(t){I(this,t),C(this);let e=this.get(t,0),r=[t,0];for(let s=1;s<this.columns;s++)this.get(t,s)<e&&(e=this.get(t,s),r[1]=s);return r}maxColumn(t){if(R(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)>e&&(e=this.get(r,t));return e}maxColumnIndex(t){R(this,t),C(this);let e=this.get(0,t),r=[0,t];for(let s=1;s<this.rows;s++)this.get(s,t)>e&&(e=this.get(s,t),r[0]=s);return r}minColumn(t){if(R(this,t),this.isEmpty())return NaN;let e=this.get(0,t);for(let r=1;r<this.rows;r++)this.get(r,t)<e&&(e=this.get(r,t));return e}minColumnIndex(t){R(this,t),C(this);let e=this.get(0,t),r=[0,t];for(let s=1;s<this.rows;s++)this.get(s,t)<e&&(e=this.get(s,t),r[0]=s);return r}diag(){let t=Math.min(this.rows,this.columns),e=[];for(let r=0;r<t;r++)e.push(this.get(r,r));return e}norm(t="frobenius"){switch(t){case"max":return this.max();case"frobenius":return Math.sqrt(this.dot(this));default:throw new RangeError(`unknown norm type: ${t}`)}}cumulativeSum(){let t=0;for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t+=this.get(e,r),this.set(e,r,t);return this}dot(t){q.isMatrix(t)&&(t=t.to1DArray());let e=this.to1DArray();if(e.length!==t.length)throw new RangeError("vectors do not have the same size");let r=0;for(let s=0;s<e.length;s++)r+=e[s]*t[s];return r}mmul(t){t=L.checkMatrix(t);let e=this.rows,r=this.columns,s=t.columns,o=new L(e,s),n=new Float64Array(r);for(let i=0;i<s;i++){for(let e=0;e<r;e++)n[e]=t.get(e,i);for(let t=0;t<e;t++){let e=0;for(let s=0;s<r;s++)e+=this.get(t,s)*n[s];o.set(t,i,e)}}return o}mpow(t){if(!this.isSquare())throw new RangeError("Matrix must be square");if(!Number.isInteger(t)||t<0)throw new RangeError("Exponent must be a non-negative integer");let e=L.eye(this.rows),r=this;for(let s=t;s>=1;s/=2)1&s&&(e=e.mmul(r)),r=r.mmul(r);return e}strassen2x2(t){t=L.checkMatrix(t);let e=new L(2,2);const r=this.get(0,0),s=t.get(0,0),o=this.get(0,1),n=t.get(0,1),i=this.get(1,0),a=t.get(1,0),h=this.get(1,1),l=t.get(1,1),u=(r+h)*(s+l),f=(i+h)*s,c=r*(n-l),m=h*(a-s),g=(r+o)*l,w=u+m-g+(o-h)*(a+l),p=c+g,d=f+m,y=u-f+c+(i-r)*(s+n);return e.set(0,0,w),e.set(0,1,p),e.set(1,0,d),e.set(1,1,y),e}strassen3x3(t){t=L.checkMatrix(t);let e=new L(3,3);const r=this.get(0,0),s=this.get(0,1),o=this.get(0,2),n=this.get(1,0),i=this.get(1,1),a=this.get(1,2),h=this.get(2,0),l=this.get(2,1),u=this.get(2,2),f=t.get(0,0),c=t.get(0,1),m=t.get(0,2),g=t.get(1,0),w=t.get(1,1),p=t.get(1,2),d=t.get(2,0),y=t.get(2,1),x=t.get(2,2),M=(r-n)*(-c+w),b=(-r+n+i)*(f-c+w),v=(n+i)*(-f+c),E=r*f,S=(-r+h+l)*(f-m+p),I=(-r+h)*(m-p),R=(h+l)*(-f+m),T=(-o+l+u)*(w+d-y),A=(o-u)*(w-y),D=o*d,N=(l+u)*(-d+y),V=(-o+i+a)*(p+d-x),k=(o-a)*(p-x),F=(i+a)*(-d+x),C=E+D+s*g,q=(r+s+o-n-i-l-u)*w+b+v+E+T+D+N,z=E+S+R+(r+s+o-i-a-h-l)*p+D+V+F,P=M+i*(-f+c+g-w-p-d+x)+b+E+D+V+k,$=M+b+v+E+a*y,j=D+V+k+F+n*m,O=E+S+I+l*(-f+m+g-w-p-d+y)+T+A+D,_=T+A+D+N+h*c,U=E+S+I+R+u*x;return e.set(0,0,C),e.set(0,1,q),e.set(0,2,z),e.set(1,0,P),e.set(1,1,$),e.set(1,2,j),e.set(2,0,O),e.set(2,1,_),e.set(2,2,U),e}mmulStrassen(t){t=L.checkMatrix(t);let e=this.clone(),r=e.rows,s=e.columns,o=t.rows,n=t.columns;function i(t,e,r){let s=t.rows,o=t.columns;if(s===e&&o===r)return t;{let s=q.zeros(e,r);return s=s.setSubMatrix(t,0,0),s}}s!==o&&console.warn(`Multiplying ${r} x ${s} and ${o} x ${n} matrix: dimensions do not match.`);let a=Math.max(r,o),h=Math.max(s,n);return e=i(e,a,h),function t(e,r,s,o){if(s<=512||o<=512)return e.mmul(r);s%2==1&&o%2==1?(e=i(e,s+1,o+1),r=i(r,s+1,o+1)):s%2==1?(e=i(e,s+1,o),r=i(r,s+1,o)):o%2==1&&(e=i(e,s,o+1),r=i(r,s,o+1));let n=parseInt(e.rows/2,10),a=parseInt(e.columns/2,10),h=e.subMatrix(0,n-1,0,a-1),l=r.subMatrix(0,n-1,0,a-1),u=e.subMatrix(0,n-1,a,e.columns-1),f=r.subMatrix(0,n-1,a,r.columns-1),c=e.subMatrix(n,e.rows-1,0,a-1),m=r.subMatrix(n,r.rows-1,0,a-1),g=e.subMatrix(n,e.rows-1,a,e.columns-1),w=r.subMatrix(n,r.rows-1,a,r.columns-1),p=t(q.add(h,g),q.add(l,w),n,a),d=t(q.add(c,g),l,n,a),y=t(h,q.sub(f,w),n,a),x=t(g,q.sub(m,l),n,a),M=t(q.add(h,u),w,n,a),b=t(q.sub(c,h),q.add(l,f),n,a),v=t(q.sub(u,g),q.add(m,w),n,a),E=q.add(p,x);E.sub(M),E.add(v);let S=q.add(y,M),I=q.add(d,x),R=q.sub(p,d);R.add(y),R.add(b);let T=q.zeros(2*E.rows,2*E.columns);return T=T.setSubMatrix(E,0,0),T=T.setSubMatrix(S,E.rows,0),T=T.setSubMatrix(I,0,E.columns),T=T.setSubMatrix(R,E.rows,E.columns),T.subMatrix(0,s-1,0,o-1)}(e,t=i(t,a,h),a,h)}scaleRows(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let s=new L(this.rows,this.columns);for(let t=0;t<this.rows;t++){const o=this.getRow(t);o.length>0&&x(o,{min:e,max:r,output:o}),s.setRow(t,o)}return s}scaleColumns(t={}){if("object"!=typeof t)throw new TypeError("options must be an object");const{min:e=0,max:r=1}=t;if(!Number.isFinite(e))throw new TypeError("min must be a number");if(!Number.isFinite(r))throw new TypeError("max must be a number");if(e>=r)throw new RangeError("min must be smaller than max");let s=new L(this.rows,this.columns);for(let t=0;t<this.columns;t++){const o=this.getColumn(t);o.length&&x(o,{min:e,max:r,output:o}),s.setColumn(t,o)}return s}flipRows(){const t=Math.ceil(this.columns/2);for(let e=0;e<this.rows;e++)for(let r=0;r<t;r++){let t=this.get(e,r),s=this.get(e,this.columns-1-r);this.set(e,r,s),this.set(e,this.columns-1-r,t)}return this}flipColumns(){const t=Math.ceil(this.rows/2);for(let e=0;e<this.columns;e++)for(let r=0;r<t;r++){let t=this.get(r,e),s=this.get(this.rows-1-r,e);this.set(r,e,s),this.set(this.rows-1-r,e,t)}return this}kroneckerProduct(t){t=L.checkMatrix(t);let e=this.rows,r=this.columns,s=t.rows,o=t.columns,n=new L(e*s,r*o);for(let i=0;i<e;i++)for(let e=0;e<r;e++)for(let r=0;r<s;r++)for(let a=0;a<o;a++)n.set(s*i+r,o*e+a,this.get(i,e)*t.get(r,a));return n}kroneckerSum(t){if(t=L.checkMatrix(t),!this.isSquare()||!t.isSquare())throw new Error("Kronecker Sum needs two Square Matrices");let e=this.rows,r=t.rows,s=this.kroneckerProduct(L.eye(r,r)),o=L.eye(e,e).kroneckerProduct(t);return s.add(o)}transpose(){let t=new L(this.columns,this.rows);for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)t.set(r,e,this.get(e,r));return t}sortRows(t=z){for(let e=0;e<this.rows;e++)this.setRow(e,this.getRow(e).sort(t));return this}sortColumns(t=z){for(let e=0;e<this.columns;e++)this.setColumn(e,this.getColumn(e).sort(t));return this}subMatrix(t,e,r,s){V(this,t,e,r,s);let o=new L(e-t+1,s-r+1);for(let n=t;n<=e;n++)for(let e=r;e<=s;e++)o.set(n-t,e-r,this.get(n,e));return o}subMatrixRow(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.columns-1),e>r||e<0||e>=this.columns||r<0||r>=this.columns)throw new RangeError("Argument out of range");let s=new L(t.length,r-e+1);for(let o=0;o<t.length;o++)for(let n=e;n<=r;n++){if(t[o]<0||t[o]>=this.rows)throw new RangeError(`Row index out of range: ${t[o]}`);s.set(o,n-e,this.get(t[o],n))}return s}subMatrixColumn(t,e,r){if(void 0===e&&(e=0),void 0===r&&(r=this.rows-1),e>r||e<0||e>=this.rows||r<0||r>=this.rows)throw new RangeError("Argument out of range");let s=new L(r-e+1,t.length);for(let o=0;o<t.length;o++)for(let n=e;n<=r;n++){if(t[o]<0||t[o]>=this.columns)throw new RangeError(`Column index out of range: ${t[o]}`);s.set(n-e,o,this.get(n,t[o]))}return s}setSubMatrix(t,e,r){if((t=L.checkMatrix(t)).isEmpty())return this;V(this,e,e+t.rows-1,r,r+t.columns-1);for(let s=0;s<t.rows;s++)for(let o=0;o<t.columns;o++)this.set(e+s,r+o,t.get(s,o));return this}selection(t,e){D(this,t),N(this,e);let r=new L(t.length,e.length);for(let s=0;s<t.length;s++){let o=t[s];for(let t=0;t<e.length;t++){let n=e[t];r.set(s,t,this.get(o,n))}}return r}trace(){let t=Math.min(this.rows,this.columns),e=0;for(let r=0;r<t;r++)e+=this.get(r,r);return e}clone(){return this.constructor.copy(this,new L(this.rows,this.columns))}static copy(t,e){for(const[r,s,o]of t.entries())e.set(r,s,o);return e}sum(t){switch(t){case"row":return function(t){let e=k(t.rows);for(let r=0;r<t.rows;++r)for(let s=0;s<t.columns;++s)e[r]+=t.get(r,s);return e}(this);case"column":return function(t){let e=k(t.columns);for(let r=0;r<t.rows;++r)for(let s=0;s<t.columns;++s)e[s]+=t.get(r,s);return e}(this);case void 0:return function(t){let e=0;for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)e+=t.get(r,s);return e}(this);default:throw new Error(`invalid option: ${t}`)}}product(t){switch(t){case"row":return function(t){let e=k(t.rows,1);for(let r=0;r<t.rows;++r)for(let s=0;s<t.columns;++s)e[r]*=t.get(r,s);return e}(this);case"column":return function(t){let e=k(t.columns,1);for(let r=0;r<t.rows;++r)for(let s=0;s<t.columns;++s)e[s]*=t.get(r,s);return e}(this);case void 0:return function(t){let e=1;for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)e*=t.get(r,s);return e}(this);default:throw new Error(`invalid option: ${t}`)}}mean(t){const e=this.sum(t);switch(t){case"row":for(let t=0;t<this.rows;t++)e[t]/=this.columns;return e;case"column":for(let t=0;t<this.columns;t++)e[t]/=this.rows;return e;case void 0:return e/this.size;default:throw new Error(`invalid option: ${t}`)}}variance(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{unbiased:r=!0,mean:s=this.mean(t)}=e;if("boolean"!=typeof r)throw new TypeError("unbiased must be a boolean");switch(t){case"row":if(!y.isAnyArray(s))throw new TypeError("mean must be an array");return function(t,e,r){const s=t.rows,o=t.columns,n=[];for(let i=0;i<s;i++){let s=0,a=0,h=0;for(let e=0;e<o;e++)h=t.get(i,e)-r[i],s+=h,a+=h*h;e?n.push((a-s*s/o)/(o-1)):n.push((a-s*s/o)/o)}return n}(this,r,s);case"column":if(!y.isAnyArray(s))throw new TypeError("mean must be an array");return function(t,e,r){const s=t.rows,o=t.columns,n=[];for(let i=0;i<o;i++){let o=0,a=0,h=0;for(let e=0;e<s;e++)h=t.get(e,i)-r[i],o+=h,a+=h*h;e?n.push((a-o*o/s)/(s-1)):n.push((a-o*o/s)/s)}return n}(this,r,s);case void 0:if("number"!=typeof s)throw new TypeError("mean must be a number");return function(t,e,r){const s=t.rows,o=t.columns,n=s*o;let i=0,a=0,h=0;for(let e=0;e<s;e++)for(let s=0;s<o;s++)h=t.get(e,s)-r,i+=h,a+=h*h;return e?(a-i*i/n)/(n-1):(a-i*i/n)/n}(this,r,s);default:throw new Error(`invalid option: ${t}`)}}standardDeviation(t,e){"object"==typeof t&&(e=t,t=void 0);const r=this.variance(t,e);if(void 0===t)return Math.sqrt(r);for(let t=0;t<r.length;t++)r[t]=Math.sqrt(r[t]);return r}center(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");const{center:r=this.mean(t)}=e;switch(t){case"row":if(!y.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)t.set(r,s,t.get(r,s)-e[r])}(this,r),this;case"column":if(!y.isAnyArray(r))throw new TypeError("center must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)t.set(r,s,t.get(r,s)-e[s])}(this,r),this;case void 0:if("number"!=typeof r)throw new TypeError("center must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)t.set(r,s,t.get(r,s)-e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}scale(t,e={}){if("object"==typeof t&&(e=t,t=void 0),"object"!=typeof e)throw new TypeError("options must be an object");let r=e.scale;switch(t){case"row":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.rows;r++){let s=0;for(let e=0;e<t.columns;e++)s+=t.get(r,e)**2/(t.columns-1);e.push(Math.sqrt(s))}return e}(this);else if(!y.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)t.set(r,s,t.get(r,s)/e[r])}(this,r),this;case"column":if(void 0===r)r=function(t){const e=[];for(let r=0;r<t.columns;r++){let s=0;for(let e=0;e<t.rows;e++)s+=t.get(e,r)**2/(t.rows-1);e.push(Math.sqrt(s))}return e}(this);else if(!y.isAnyArray(r))throw new TypeError("scale must be an array");return function(t,e){for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)t.set(r,s,t.get(r,s)/e[s])}(this,r),this;case void 0:if(void 0===r)r=function(t){const e=t.size-1;let r=0;for(let s=0;s<t.columns;s++)for(let o=0;o<t.rows;o++)r+=t.get(o,s)**2/e;return Math.sqrt(r)}(this);else if("number"!=typeof r)throw new TypeError("scale must be a number");return function(t,e){for(let r=0;r<t.rows;r++)for(let s=0;s<t.columns;s++)t.set(r,s,t.get(r,s)/e)}(this,r),this;default:throw new Error(`invalid option: ${t}`)}}toString(t){return v(this,t)}[Symbol.iterator](){return this.entries()}*entries(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield[t,e,this.get(t,e)]}*values(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)yield this.get(t,e)}}function z(t,e){return t-e}function P(t){return t.every(t=>"number"==typeof t)}q.prototype.klass="Matrix","undefined"!=typeof Symbol&&(q.prototype[Symbol.for("nodejs.util.inspect.custom")]=function(){return v(this)}),q.random=q.rand,q.randomInt=q.randInt,q.diagonal=q.diag,q.prototype.diagonal=q.prototype.diag,q.identity=q.eye,q.prototype.negate=q.prototype.neg,q.prototype.tensorProduct=q.prototype.kroneckerProduct;let L=class t extends q{data;#t(t,e){if(this.data=[],!(Number.isInteger(e)&&e>=0))throw new TypeError("nColumns must be a positive integer");for(let r=0;r<t;r++)this.data.push(new Float64Array(e));this.rows=t,this.columns=e}constructor(e,r){if(super(),t.isMatrix(e))this.#t(e.rows,e.columns),t.copy(e,this);else if(Number.isInteger(e)&&e>=0)this.#t(e,r);else{if(!y.isAnyArray(e))throw new TypeError("First argument must be a positive number or an array");{const t=e;if("number"!=typeof(r=(e=t.length)?t[0].length:0))throw new TypeError("Data must be a 2D array with at least one element");this.data=[];for(let s=0;s<e;s++){if(t[s].length!==r)throw new RangeError("Inconsistent array dimensions");if(!P(t[s]))throw new TypeError("Input data contains non-numeric values");this.data.push(Float64Array.from(t[s]))}this.rows=e,this.columns=r}}}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}removeRow(t){return I(this,t),this.data.splice(t,1),this.rows-=1,this}addRow(t,e){return void 0===e&&(e=t,t=this.rows),I(this,t,!0),e=Float64Array.from(T(this,e)),this.data.splice(t,0,e),this.rows+=1,this}removeColumn(t){R(this,t);for(let e=0;e<this.rows;e++){const r=new Float64Array(this.columns-1);for(let s=0;s<t;s++)r[s]=this.data[e][s];for(let s=t+1;s<this.columns;s++)r[s-1]=this.data[e][s];this.data[e]=r}return this.columns-=1,this}addColumn(t,e){void 0===e&&(e=t,t=this.columns),R(this,t,!0),e=A(this,e);for(let r=0;r<this.rows;r++){const s=new Float64Array(this.columns+1);let o=0;for(;o<t;o++)s[o]=this.data[r][o];for(s[o++]=e[r];o<this.columns+1;o++)s[o]=this.data[r][o-1];this.data[r]=s}return this.columns+=1,this}};!function(t,e){t.prototype.add=function(t){return"number"==typeof t?this.addS(t):this.addM(t)},t.prototype.addS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t);return this},t.prototype.addM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)+t.get(e,r));return this},t.add=function(t,r){return new e(t).add(r)},t.prototype.sub=function(t){return"number"==typeof t?this.subS(t):this.subM(t)},t.prototype.subS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t);return this},t.prototype.subM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)-t.get(e,r));return this},t.sub=function(t,r){return new e(t).sub(r)},t.prototype.subtract=t.prototype.sub,t.prototype.subtractS=t.prototype.subS,t.prototype.subtractM=t.prototype.subM,t.subtract=t.sub,t.prototype.mul=function(t){return"number"==typeof t?this.mulS(t):this.mulM(t)},t.prototype.mulS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t);return this},t.prototype.mulM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)*t.get(e,r));return this},t.mul=function(t,r){return new e(t).mul(r)},t.prototype.multiply=t.prototype.mul,t.prototype.multiplyS=t.prototype.mulS,t.prototype.multiplyM=t.prototype.mulM,t.multiply=t.mul,t.prototype.div=function(t){return"number"==typeof t?this.divS(t):this.divM(t)},t.prototype.divS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t);return this},t.prototype.divM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)/t.get(e,r));return this},t.div=function(t,r){return new e(t).div(r)},t.prototype.divide=t.prototype.div,t.prototype.divideS=t.prototype.divS,t.prototype.divideM=t.prototype.divM,t.divide=t.div,t.prototype.mod=function(t){return"number"==typeof t?this.modS(t):this.modM(t)},t.prototype.modS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t);return this},t.prototype.modM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)%t.get(e,r));return this},t.mod=function(t,r){return new e(t).mod(r)},t.prototype.modulus=t.prototype.mod,t.prototype.modulusS=t.prototype.modS,t.prototype.modulusM=t.prototype.modM,t.modulus=t.mod,t.prototype.and=function(t){return"number"==typeof t?this.andS(t):this.andM(t)},t.prototype.andS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t);return this},t.prototype.andM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)&t.get(e,r));return this},t.and=function(t,r){return new e(t).and(r)},t.prototype.or=function(t){return"number"==typeof t?this.orS(t):this.orM(t)},t.prototype.orS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t);return this},t.prototype.orM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)|t.get(e,r));return this},t.or=function(t,r){return new e(t).or(r)},t.prototype.xor=function(t){return"number"==typeof t?this.xorS(t):this.xorM(t)},t.prototype.xorS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t);return this},t.prototype.xorM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)^t.get(e,r));return this},t.xor=function(t,r){return new e(t).xor(r)},t.prototype.leftShift=function(t){return"number"==typeof t?this.leftShiftS(t):this.leftShiftM(t)},t.prototype.leftShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t);return this},t.prototype.leftShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)<<t.get(e,r));return this},t.leftShift=function(t,r){return new e(t).leftShift(r)},t.prototype.signPropagatingRightShift=function(t){return"number"==typeof t?this.signPropagatingRightShiftS(t):this.signPropagatingRightShiftM(t)},t.prototype.signPropagatingRightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t);return this},t.prototype.signPropagatingRightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>t.get(e,r));return this},t.signPropagatingRightShift=function(t,r){return new e(t).signPropagatingRightShift(r)},t.prototype.rightShift=function(t){return"number"==typeof t?this.rightShiftS(t):this.rightShiftM(t)},t.prototype.rightShiftS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t);return this},t.prototype.rightShiftM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)>>>t.get(e,r));return this},t.rightShift=function(t,r){return new e(t).rightShift(r)},t.prototype.zeroFillRightShift=t.prototype.rightShift,t.prototype.zeroFillRightShiftS=t.prototype.rightShiftS,t.prototype.zeroFillRightShiftM=t.prototype.rightShiftM,t.zeroFillRightShift=t.rightShift,t.prototype.not=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,~this.get(t,e));return this},t.not=function(t){return new e(t).not()},t.prototype.abs=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.abs(this.get(t,e)));return this},t.abs=function(t){return new e(t).abs()},t.prototype.acos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acos(this.get(t,e)));return this},t.acos=function(t){return new e(t).acos()},t.prototype.acosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.acosh(this.get(t,e)));return this},t.acosh=function(t){return new e(t).acosh()},t.prototype.asin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asin(this.get(t,e)));return this},t.asin=function(t){return new e(t).asin()},t.prototype.asinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.asinh(this.get(t,e)));return this},t.asinh=function(t){return new e(t).asinh()},t.prototype.atan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atan(this.get(t,e)));return this},t.atan=function(t){return new e(t).atan()},t.prototype.atanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.atanh(this.get(t,e)));return this},t.atanh=function(t){return new e(t).atanh()},t.prototype.cbrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cbrt(this.get(t,e)));return this},t.cbrt=function(t){return new e(t).cbrt()},t.prototype.ceil=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.ceil(this.get(t,e)));return this},t.ceil=function(t){return new e(t).ceil()},t.prototype.clz32=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.clz32(this.get(t,e)));return this},t.clz32=function(t){return new e(t).clz32()},t.prototype.cos=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cos(this.get(t,e)));return this},t.cos=function(t){return new e(t).cos()},t.prototype.cosh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.cosh(this.get(t,e)));return this},t.cosh=function(t){return new e(t).cosh()},t.prototype.exp=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.exp(this.get(t,e)));return this},t.exp=function(t){return new e(t).exp()},t.prototype.expm1=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.expm1(this.get(t,e)));return this},t.expm1=function(t){return new e(t).expm1()},t.prototype.floor=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.floor(this.get(t,e)));return this},t.floor=function(t){return new e(t).floor()},t.prototype.fround=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.fround(this.get(t,e)));return this},t.fround=function(t){return new e(t).fround()},t.prototype.log=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log(this.get(t,e)));return this},t.log=function(t){return new e(t).log()},t.prototype.log1p=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log1p(this.get(t,e)));return this},t.log1p=function(t){return new e(t).log1p()},t.prototype.log10=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log10(this.get(t,e)));return this},t.log10=function(t){return new e(t).log10()},t.prototype.log2=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.log2(this.get(t,e)));return this},t.log2=function(t){return new e(t).log2()},t.prototype.round=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.round(this.get(t,e)));return this},t.round=function(t){return new e(t).round()},t.prototype.sign=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sign(this.get(t,e)));return this},t.sign=function(t){return new e(t).sign()},t.prototype.sin=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sin(this.get(t,e)));return this},t.sin=function(t){return new e(t).sin()},t.prototype.sinh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sinh(this.get(t,e)));return this},t.sinh=function(t){return new e(t).sinh()},t.prototype.sqrt=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.sqrt(this.get(t,e)));return this},t.sqrt=function(t){return new e(t).sqrt()},t.prototype.tan=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tan(this.get(t,e)));return this},t.tan=function(t){return new e(t).tan()},t.prototype.tanh=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.tanh(this.get(t,e)));return this},t.tanh=function(t){return new e(t).tanh()},t.prototype.trunc=function(){for(let t=0;t<this.rows;t++)for(let e=0;e<this.columns;e++)this.set(t,e,Math.trunc(this.get(t,e)));return this},t.trunc=function(t){return new e(t).trunc()},t.pow=function(t,r){return new e(t).pow(r)},t.prototype.pow=function(t){return"number"==typeof t?this.powS(t):this.powM(t)},t.prototype.powS=function(t){for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t);return this},t.prototype.powM=function(t){if(t=e.checkMatrix(t),this.rows!==t.rows||this.columns!==t.columns)throw new RangeError("Matrices dimensions must be equal");for(let e=0;e<this.rows;e++)for(let r=0;r<this.columns;r++)this.set(e,r,this.get(e,r)**t.get(e,r));return this}}(q,L);class $ extends q{#e;get size(){return this.#e.size}get rows(){return this.#e.rows}get columns(){return this.#e.columns}get diagonalSize(){return this.rows}static isSymmetricMatrix(t){return L.isMatrix(t)&&"SymmetricMatrix"===t.klassType}static zeros(t){return new this(t)}static ones(t){return new this(t).fill(1)}constructor(t){if(super(),L.isMatrix(t)){if(!t.isSymmetric())throw new TypeError("not symmetric data");this.#e=L.copy(t,new L(t.rows,t.rows))}else if(Number.isInteger(t)&&t>=0)this.#e=new L(t,t);else if(this.#e=new L(t),!this.isSymmetric())throw new TypeError("not symmetric data")}clone(){const t=new $(this.diagonalSize);for(const[e,r,s]of this.upperRightEntries())t.set(e,r,s);return t}toMatrix(){return new L(this)}get(t,e){return this.#e.get(t,e)}set(t,e,r){return this.#e.set(t,e,r),this.#e.set(e,t,r),this}removeCross(t){return this.#e.removeRow(t),this.#e.removeColumn(t),this}addCross(t,e){void 0===e&&(e=t,t=this.diagonalSize);const r=e.slice();return r.splice(t,1),this.#e.addRow(t,r),this.#e.addColumn(t,e),this}applyMask(t){if(t.length!==this.diagonalSize)throw new RangeError("Mask size do not match with matrix size");const e=[];for(const[r,s]of t.entries())s||e.push(r);e.reverse();for(const t of e)this.removeCross(t);return this}toCompact(){const{diagonalSize:t}=this,e=new Array(t*(t+1)/2);for(let r=0,s=0,o=0;o<e.length;o++)e[o]=this.get(s,r),++r>=t&&(r=++s);return e}static fromCompact(t){const e=t.length,r=(Math.sqrt(8*e+1)-1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a Symmetric Matrix, ${JSON.stringify(t)}`);const s=new $(r);for(let o=0,n=0,i=0;i<e;i++)s.set(o,n,t[i]),++o>=r&&(o=++n);return s}*upperRightEntries(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield[t,e,r],++e>=this.diagonalSize&&(e=++t)}}*upperRightValues(){for(let t=0,e=0;t<this.diagonalSize;void 0){const r=this.get(t,e);yield r,++e>=this.diagonalSize&&(e=++t)}}}$.prototype.klassType="SymmetricMatrix";class j extends ${static isDistanceMatrix(t){return $.isSymmetricMatrix(t)&&"DistanceMatrix"===t.klassSubType}constructor(t){if(super(t),!this.isDistance())throw new TypeError("Provided arguments do no produce a distance matrix")}set(t,e,r){return t===e&&(r=0),super.set(t,e,r)}addCross(t,e){return void 0===e&&(e=t,t=this.diagonalSize),(e=e.slice())[t]=0,super.addCross(t,e)}toSymmetricMatrix(){return new $(this)}clone(){const t=new j(this.diagonalSize);for(const[e,r,s]of this.upperRightEntries())e!==r&&t.set(e,r,s);return t}toCompact(){const{diagonalSize:t}=this,e=new Array((t-1)*t/2);for(let r=1,s=0,o=0;o<e.length;o++)e[o]=this.get(s,r),++r>=t&&(r=1+ ++s);return e}static fromCompact(t){const e=t.length;if(0===e)return new this(0);const r=(Math.sqrt(8*e+1)+1)/2;if(!Number.isInteger(r))throw new TypeError(`This array is not a compact representation of a DistanceMatrix, ${JSON.stringify(t)}`);const s=new this(r);for(let o=1,n=0,i=0;i<e;i++)s.set(o,n,t[i]),++o>=r&&(o=1+ ++n);return s}}j.prototype.klassSubType="DistanceMatrix";class O extends q{constructor(t,e,r){super(),this.matrix=t,this.rows=e,this.columns=r}}class _ extends O{constructor(t,e,r){D(t,e),N(t,r),super(t,e.length,r.length),this.rowIndices=e,this.columnIndices=r}set(t,e,r){return this.matrix.set(this.rowIndices[t],this.columnIndices[e],r),this}get(t,e){return this.matrix.get(this.rowIndices[t],this.columnIndices[e])}}class U extends q{constructor(t,e={}){const{rows:r=1}=e;if(t.length%r!==0)throw new Error("the data length is not divisible by the number of rows");super(),this.rows=r,this.columns=t.length/r,this.data=t}set(t,e,r){let s=this._calculateIndex(t,e);return this.data[s]=r,this}get(t,e){let r=this._calculateIndex(t,e);return this.data[r]}_calculateIndex(t,e){return t*this.columns+e}}class Y extends q{constructor(t){super(),this.data=t,this.rows=t.length,this.columns=t[0].length}set(t,e,r){return this.data[t][e]=r,this}get(t,e){return this.data[t][e]}}class W{constructor(t){let e,r,s,o,n,i,a,h,l,u=(t=Y.checkMatrix(t)).clone(),f=u.rows,c=u.columns,m=new Float64Array(f),g=1;for(e=0;e<f;e++)m[e]=e;for(h=new Float64Array(f),r=0;r<c;r++){for(e=0;e<f;e++)h[e]=u.get(e,r);for(e=0;e<f;e++){for(l=Math.min(e,r),n=0,s=0;s<l;s++)n+=u.get(e,s)*h[s];h[e]-=n,u.set(e,r,h[e])}for(o=r,e=r+1;e<f;e++)Math.abs(h[e])>Math.abs(h[o])&&(o=e);if(o!==r){for(s=0;s<c;s++)i=u.get(o,s),u.set(o,s,u.get(r,s)),u.set(r,s,i);a=m[o],m[o]=m[r],m[r]=a,g=-g}if(r<f&&0!==u.get(r,r))for(e=r+1;e<f;e++)u.set(e,r,u.get(e,r)/u.get(r,r))}this.LU=u,this.pivotVector=m,this.pivotSign=g}isSingular(){let t=this.LU,e=t.columns;for(let r=0;r<e;r++)if(0===t.get(r,r))return!0;return!1}solve(t){t=L.checkMatrix(t);let e=this.LU;if(e.rows!==t.rows)throw new Error("Invalid matrix dimensions");if(this.isSingular())throw new Error("LU matrix is singular");let r,s,o,n=t.columns,i=t.subMatrixRow(this.pivotVector,0,n-1),a=e.columns;for(o=0;o<a;o++)for(r=o+1;r<a;r++)for(s=0;s<n;s++)i.set(r,s,i.get(r,s)-i.get(o,s)*e.get(r,o));for(o=a-1;o>=0;o--){for(s=0;s<n;s++)i.set(o,s,i.get(o,s)/e.get(o,o));for(r=0;r<o;r++)for(s=0;s<n;s++)i.set(r,s,i.get(r,s)-i.get(o,s)*e.get(r,o))}return i}get determinant(){let t=this.LU;if(!t.isSquare())throw new Error("Matrix must be square");let e=this.pivotSign,r=t.columns;for(let s=0;s<r;s++)e*=t.get(s,s);return e}get lowerTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,s=new L(e,r);for(let o=0;o<e;o++)for(let e=0;e<r;e++)o>e?s.set(o,e,t.get(o,e)):o===e?s.set(o,e,1):s.set(o,e,0);return s}get upperTriangularMatrix(){let t=this.LU,e=t.rows,r=t.columns,s=new L(e,r);for(let o=0;o<e;o++)for(let e=0;e<r;e++)o<=e?s.set(o,e,t.get(o,e)):s.set(o,e,0);return s}get pivotPermutationVector(){return Array.from(this.pivotVector)}}function H(t,e){let r=0;return Math.abs(t)>Math.abs(e)?(r=e/t,Math.abs(t)*Math.sqrt(1+r*r)):0!==e?(r=t/e,Math.abs(e)*Math.sqrt(1+r*r)):0}class X{constructor(t){let e,r,s,o,n=(t=Y.checkMatrix(t)).clone(),i=t.rows,a=t.columns,h=new Float64Array(a);for(s=0;s<a;s++){let t=0;for(e=s;e<i;e++)t=H(t,n.get(e,s));if(0!==t){for(n.get(s,s)<0&&(t=-t),e=s;e<i;e++)n.set(e,s,n.get(e,s)/t);for(n.set(s,s,n.get(s,s)+1),r=s+1;r<a;r++){for(o=0,e=s;e<i;e++)o+=n.get(e,s)*n.get(e,r);for(o=-o/n.get(s,s),e=s;e<i;e++)n.set(e,r,n.get(e,r)+o*n.get(e,s))}}h[s]=-t}this.QR=n,this.Rdiag=h}solve(t){t=L.checkMatrix(t);let e=this.QR,r=e.rows;if(t.rows!==r)throw new Error("Matrix row dimensions must agree");if(!this.isFullRank())throw new Error("Matrix is rank deficient");let s,o,n,i,a=t.columns,h=t.clone(),l=e.columns;for(n=0;n<l;n++)for(o=0;o<a;o++){for(i=0,s=n;s<r;s++)i+=e.get(s,n)*h.get(s,o);for(i=-i/e.get(n,n),s=n;s<r;s++)h.set(s,o,h.get(s,o)+i*e.get(s,n))}for(n=l-1;n>=0;n--){for(o=0;o<a;o++)h.set(n,o,h.get(n,o)/this.Rdiag[n]);for(s=0;s<n;s++)for(o=0;o<a;o++)h.set(s,o,h.get(s,o)-h.get(n,o)*e.get(s,n))}return h.subMatrix(0,l-1,0,a-1)}isFullRank(){let t=this.QR.columns;for(let e=0;e<t;e++)if(0===this.Rdiag[e])return!1;return!0}get upperTriangularMatrix(){let t,e,r=this.QR,s=r.columns,o=new L(s,s);for(t=0;t<s;t++)for(e=0;e<s;e++)t<e?o.set(t,e,r.get(t,e)):t===e?o.set(t,e,this.Rdiag[t]):o.set(t,e,0);return o}get orthogonalMatrix(){let t,e,r,s,o=this.QR,n=o.rows,i=o.columns,a=new L(n,i);for(r=i-1;r>=0;r--){for(t=0;t<n;t++)a.set(t,r,0);for(a.set(r,r,1),e=r;e<i;e++)if(0!==o.get(r,r)){for(s=0,t=r;t<n;t++)s+=o.get(t,r)*a.get(t,e);for(s=-s/o.get(r,r),t=r;t<n;t++)a.set(t,e,a.get(t,e)+s*o.get(t,r))}}return a}}class B{constructor(t,e={}){if((t=Y.checkMatrix(t)).isEmpty())throw new Error("Matrix must be non-empty");let r=t.rows,s=t.columns;const{computeLeftSingularVectors:o=!0,computeRightSingularVectors:n=!0,autoTranspose:i=!1}=e;let a,h=Boolean(o),l=Boolean(n),u=!1;if(r<s)if(i){a=t.transpose(),r=a.rows,s=a.columns,u=!0;let e=h;h=l,l=e}else a=t.clone(),console.warn("Computing SVD on a matrix with more columns than rows. Consider enabling autoTranspose");else a=t.clone();let f=Math.min(r,s),c=Math.min(r+1,s),m=new Float64Array(c),g=new L(r,f),w=new L(s,s),p=new Float64Array(s),d=new Float64Array(r),y=new Float64Array(c);for(let t=0;t<c;t++)y[t]=t;let x=Math.min(r-1,s),M=Math.max(0,Math.min(s-2,r)),b=Math.max(x,M);for(let t=0;t<b;t++){if(t<x){m[t]=0;for(let e=t;e<r;e++)m[t]=H(m[t],a.get(e,t));if(0!==m[t]){a.get(t,t)<0&&(m[t]=-m[t]);for(let e=t;e<r;e++)a.set(e,t,a.get(e,t)/m[t]);a.set(t,t,a.get(t,t)+1)}m[t]=-m[t]}for(let e=t+1;e<s;e++){if(t<x&&0!==m[t]){let s=0;for(let o=t;o<r;o++)s+=a.get(o,t)*a.get(o,e);s=-s/a.get(t,t);for(let o=t;o<r;o++)a.set(o,e,a.get(o,e)+s*a.get(o,t))}p[e]=a.get(t,e)}if(h&&t<x)for(let e=t;e<r;e++)g.set(e,t,a.get(e,t));if(t<M){p[t]=0;for(let e=t+1;e<s;e++)p[t]=H(p[t],p[e]);if(0!==p[t]){p[t+1]<0&&(p[t]=0-p[t]);for(let e=t+1;e<s;e++)p[e]/=p[t];p[t+1]+=1}if(p[t]=-p[t],t+1<r&&0!==p[t]){for(let e=t+1;e<r;e++)d[e]=0;for(let e=t+1;e<r;e++)for(let r=t+1;r<s;r++)d[e]+=p[r]*a.get(e,r);for(let e=t+1;e<s;e++){let s=-p[e]/p[t+1];for(let o=t+1;o<r;o++)a.set(o,e,a.get(o,e)+s*d[o])}}if(l)for(let e=t+1;e<s;e++)w.set(e,t,p[e])}}let v=Math.min(s,r+1);if(x<s&&(m[x]=a.get(x,x)),r<v&&(m[v-1]=0),M+1<v&&(p[M]=a.get(M,v-1)),p[v-1]=0,h){for(let t=x;t<f;t++){for(let e=0;e<r;e++)g.set(e,t,0);g.set(t,t,1)}for(let t=x-1;t>=0;t--)if(0!==m[t]){for(let e=t+1;e<f;e++){let s=0;for(let o=t;o<r;o++)s+=g.get(o,t)*g.get(o,e);s=-s/g.get(t,t);for(let o=t;o<r;o++)g.set(o,e,g.get(o,e)+s*g.get(o,t))}for(let e=t;e<r;e++)g.set(e,t,-g.get(e,t));g.set(t,t,1+g.get(t,t));for(let e=0;e<t-1;e++)g.set(e,t,0)}else{for(let e=0;e<r;e++)g.set(e,t,0);g.set(t,t,1)}}if(l)for(let t=s-1;t>=0;t--){if(t<M&&0!==p[t])for(let e=t+1;e<s;e++){let r=0;for(let o=t+1;o<s;o++)r+=w.get(o,t)*w.get(o,e);r=-r/w.get(t+1,t);for(let o=t+1;o<s;o++)w.set(o,e,w.get(o,e)+r*w.get(o,t))}for(let e=0;e<s;e++)w.set(e,t,0);w.set(t,t,1)}let E=v-1,S=Number.EPSILON;for(;v>0;){let t,e;for(t=v-2;t>=-1&&-1!==t;t--){const e=Number.MIN_VALUE+S*Math.abs(m[t]+Math.abs(m[t+1]));if(Math.abs(p[t])<=e||Number.isNaN(p[t])){p[t]=0;break}}if(t===v-2)e=4;else{let r;for(r=v-1;r>=t&&r!==t;r--){let e=(r!==v?Math.abs(p[r]):0)+(r!==t+1?Math.abs(p[r-1]):0);if(Math.abs(m[r])<=S*e){m[r]=0;break}}r===t?e=3:r===v-1?e=1:(e=2,t=r)}switch(t++,e){case 1:{let e=p[v-2];p[v-2]=0;for(let r=v-2;r>=t;r--){let o=H(m[r],e),n=m[r]/o,i=e/o;if(m[r]=o,r!==t&&(e=-i*p[r-1],p[r-1]=n*p[r-1]),l)for(let t=0;t<s;t++)o=n*w.get(t,r)+i*w.get(t,v-1),w.set(t,v-1,-i*w.get(t,r)+n*w.get(t,v-1)),w.set(t,r,o)}break}case 2:{let e=p[t-1];p[t-1]=0;for(let s=t;s<v;s++){let o=H(m[s],e),n=m[s]/o,i=e/o;if(m[s]=o,e=-i*p[s],p[s]=n*p[s],h)for(let e=0;e<r;e++)o=n*g.get(e,s)+i*g.get(e,t-1),g.set(e,t-1,-i*g.get(e,s)+n*g.get(e,t-1)),g.set(e,s,o)}break}case 3:{const e=Math.max(Math.abs(m[v-1]),Math.abs(m[v-2]),Math.abs(p[v-2]),Math.abs(m[t]),Math.abs(p[t])),o=m[v-1]/e,n=m[v-2]/e,i=p[v-2]/e,a=m[t]/e,u=p[t]/e,f=((n+o)*(n-o)+i*i)/2,c=o*i*(o*i);let d=0;0===f&&0===c||(d=f<0?0-Math.sqrt(f*f+c):Math.sqrt(f*f+c),d=c/(f+d));let y=(a+o)*(a-o)+d,x=a*u;for(let e=t;e<v-1;e++){let o=H(y,x);0===o&&(o=Number.MIN_VALUE);let n=y/o,i=x/o;if(e!==t&&(p[e-1]=o),y=n*m[e]+i*p[e],p[e]=n*p[e]-i*m[e],x=i*m[e+1],m[e+1]=n*m[e+1],l)for(let t=0;t<s;t++)o=n*w.get(t,e)+i*w.get(t,e+1),w.set(t,e+1,-i*w.get(t,e)+n*w.get(t,e+1)),w.set(t,e,o);if(o=H(y,x),0===o&&(o=Number.MIN_VALUE),n=y/o,i=x/o,m[e]=o,y=n*p[e]+i*m[e+1],m[e+1]=-i*p[e]+n*m[e+1],x=i*p[e+1],p[e+1]=n*p[e+1],h&&e<r-1)for(let t=0;t<r;t++)o=n*g.get(t,e)+i*g.get(t,e+1),g.set(t,e+1,-i*g.get(t,e)+n*g.get(t,e+1)),g.set(t,e,o)}p[v-2]=y;break}case 4:if(m[t]<=0&&(m[t]=m[t]<0?-m[t]:0,l))for(let e=0;e<=E;e++)w.set(e,t,-w.get(e,t));for(;t<E&&!(m[t]>=m[t+1]);){let e=m[t];if(m[t]=m[t+1],m[t+1]=e,l&&t<s-1)for(let r=0;r<s;r++)e=w.get(r,t+1),w.set(r,t+1,w.get(r,t)),w.set(r,t,e);if(h&&t<r-1)for(let s=0;s<r;s++)e=g.get(s,t+1),g.set(s,t+1,g.get(s,t)),g.set(s,t,e);t++}v--}}if(u){let t=w;w=g,g=t}this.m=r,this.n=s,this.s=m,this.U=g,this.V=w}solve(t){let e=t,r=this.threshold,s=this.s.length,o=L.zeros(s,s);for(let t=0;t<s;t++)Math.abs(this.s[t])<=r?o.set(t,t,0):o.set(t,t,1/this.s[t]);let n=this.U,i=this.rightSingularVectors,a=i.mmul(o),h=i.rows,l=n.rows,u=L.zeros(h,l);for(let t=0;t<h;t++)for(let e=0;e<l;e++){let r=0;for(let o=0;o<s;o++)r+=a.get(t,o)*n.get(e,o);u.set(t,e,r)}return u.mmul(e)}solveForDiagonal(t){return this.solve(L.diag(t))}inverse(){let t=this.V,e=this.threshold,r=t.rows,s=t.columns,o=new L(r,this.s.length);for(let n=0;n<r;n++)for(let r=0;r<s;r++)Math.abs(this.s[r])>e&&o.set(n,r,t.get(n,r)/this.s[r]);let n=this.U,i=n.rows,a=n.columns,h=new L(r,i);for(let t=0;t<r;t++)for(let e=0;e<i;e++){let r=0;for(let s=0;s<a;s++)r+=o.get(t,s)*n.get(e,s);h.set(t,e,r)}return h}get condition(){return this.s[0]/this.s[Math.min(this.m,this.n)-1]}get norm2(){return this.s[0]}get rank(){let t=Math.max(this.m,this.n)*this.s[0]*Number.EPSILON,e=0,r=this.s;for(let s=0,o=r.length;s<o;s++)r[s]>t&&e++;return e}get diagonal(){return Array.from(this.s)}get threshold(){return Number.EPSILON/2*Math.max(this.m,this.n)*this.s[0]}get leftSingularVectors(){return this.U}get rightSingularVectors(){return this.V}get diagonalMatrix(){return L.diag(this.s)}}function Q(t,e,r=!1){return t=Y.checkMatrix(t),e=Y.checkMatrix(e),r?new B(t).solve(e):t.isSquare()?new W(t).solve(e):new X(t).solve(e)}function G(t,e){let r=[];for(let s=0;s<t;s++)s!==e&&r.push(s);return r}function J(t,e,r,s=1e-9,o=1e-9){if(t>o)return new Array(e.rows+1).fill(0);{let t=e.addRow(r,[0]);for(let e=0;e<t.rows;e++)Math.abs(t.get(e,0))<s&&t.set(e,0,0);return t.to1DArray()}}class K{constructor(t,e={}){const{assumeSymmetric:r=!1}=e;if(!(t=Y.checkMatrix(t)).isSquare())throw new Error("Matrix is not a square matrix");if(t.isEmpty())throw new Error("Matrix must be non-empty");let s,o,n=t.columns,i=new L(n,n),a=new Float64Array(n),h=new Float64Array(n),l=t,u=!1;if(u=!!r||t.isSymmetric(),u){for(s=0;s<n;s++)for(o=0;o<n;o++)i.set(s,o,l.get(s,o));!function(t,e,r,s){let o,n,i,a,h,l,u,f;for(h=0;h<t;h++)r[h]=s.get(t-1,h);for(a=t-1;a>0;a--){for(f=0,i=0,l=0;l<a;l++)f+=Math.abs(r[l]);if(0===f)for(e[a]=r[a-1],h=0;h<a;h++)r[h]=s.get(a-1,h),s.set(a,h,0),s.set(h,a,0);else{for(l=0;l<a;l++)r[l]/=f,i+=r[l]*r[l];for(o=r[a-1],n=Math.sqrt(i),o>0&&(n=-n),e[a]=f*n,i-=o*n,r[a-1]=o-n,h=0;h<a;h++)e[h]=0;for(h=0;h<a;h++){for(o=r[h],s.set(h,a,o),n=e[h]+s.get(h,h)*o,l=h+1;l<=a-1;l++)n+=s.get(l,h)*r[l],e[l]+=s.get(l,h)*o;e[h]=n}for(o=0,h=0;h<a;h++)e[h]/=i,o+=e[h]*r[h];for(u=o/(i+i),h=0;h<a;h++)e[h]-=u*r[h];for(h=0;h<a;h++){for(o=r[h],n=e[h],l=h;l<=a-1;l++)s.set(l,h,s.get(l,h)-(o*e[l]+n*r[l]));r[h]=s.get(a-1,h),s.set(a,h,0)}}r[a]=i}for(a=0;a<t-1;a++){if(s.set(t-1,a,s.get(a,a)),s.set(a,a,1),i=r[a+1],0!==i){for(l=0;l<=a;l++)r[l]=s.get(l,a+1)/i;for(h=0;h<=a;h++){for(n=0,l=0;l<=a;l++)n+=s.get(l,a+1)*s.get(l,h);for(l=0;l<=a;l++)s.set(l,h,s.get(l,h)-n*r[l])}}for(l=0;l<=a;l++)s.set(l,a+1,0)}for(h=0;h<t;h++)r[h]=s.get(t-1,h),s.set(t-1,h,0);s.set(t-1,t-1,1),e[0]=0}(n,h,a,i),function(t,e,r,s){let o,n,i,a,h,l,u,f,c,m,g,w,p,d,y,x;for(i=1;i<t;i++)e[i-1]=e[i];e[t-1]=0;let M=0,b=0,v=Number.EPSILON;for(l=0;l<t;l++){for(b=Math.max(b,Math.abs(r[l])+Math.abs(e[l])),u=l;u<t&&!(Math.abs(e[u])<=v*b);)u++;if(u>l)do{for(o=r[l],f=(r[l+1]-o)/(2*e[l]),c=H(f,1),f<0&&(c=-c),r[l]=e[l]/(f+c),r[l+1]=e[l]*(f+c),m=r[l+1],n=o-r[l],i=l+2;i<t;i++)r[i]-=n;for(M+=n,f=r[u],g=1,w=g,p=g,d=e[l+1],y=0,x=0,i=u-1;i>=l;i--)for(p=w,w=g,x=y,o=g*e[i],n=g*f,c=H(f,e[i]),e[i+1]=y*c,y=e[i]/c,g=f/c,f=g*r[i]-y*o,r[i+1]=n+y*(g*o+y*r[i]),h=0;h<t;h++)n=s.get(h,i+1),s.set(h,i+1,y*s.get(h,i)+g*n),s.set(h,i,g*s.get(h,i)-y*n);f=-y*x*p*d*e[l]/m,e[l]=y*f,r[l]=g*f}while(Math.abs(e[l])>v*b);r[l]=r[l]+M,e[l]=0}for(i=0;i<t-1;i++){for(h=i,f=r[i],a=i+1;a<t;a++)r[a]<f&&(h=a,f=r[a]);if(h!==i)for(r[h]=r[i],r[i]=f,a=0;a<t;a++)f=s.get(a,i),s.set(a,i,s.get(a,h)),s.set(a,h,f)}}(n,h,a,i)}else{let t=new L(n,n),e=new Float64Array(n);for(o=0;o<n;o++)for(s=0;s<n;s++)t.set(s,o,l.get(s,o));!function(t,e,r,s){let o,n,i,a,h,l,u,f=0,c=t-1;for(l=f+1;l<=c-1;l++){for(u=0,a=l;a<=c;a++)u+=Math.abs(e.get(a,l-1));if(0!==u){for(i=0,a=c;a>=l;a--)r[a]=e.get(a,l-1)/u,i+=r[a]*r[a];for(n=Math.sqrt(i),r[l]>0&&(n=-n),i-=r[l]*n,r[l]=r[l]-n,h=l;h<t;h++){for(o=0,a=c;a>=l;a--)o+=r[a]*e.get(a,h);for(o/=i,a=l;a<=c;a++)e.set(a,h,e.get(a,h)-o*r[a])}for(a=0;a<=c;a++){for(o=0,h=c;h>=l;h--)o+=r[h]*e.get(a,h);for(o/=i,h=l;h<=c;h++)e.set(a,h,e.get(a,h)-o*r[h])}r[l]=u*r[l],e.set(l,l-1,u*n)}}for(a=0;a<t;a++)for(h=0;h<t;h++)s.set(a,h,a===h?1:0);for(l=c-1;l>=f+1;l--)if(0!==e.get(l,l-1)){for(a=l+1;a<=c;a++)r[a]=e.get(a,l-1);for(h=l;h<=c;h++){for(n=0,a=l;a<=c;a++)n+=r[a]*s.get(a,h);for(n=n/r[l]/e.get(l,l-1),a=l;a<=c;a++)s.set(a,h,s.get(a,h)+n*r[a])}}}(n,t,e,i),function(t,e,r,s,o){let n,i,a,h,l,u,f,c,m,g,w,p,d,y,x,M=t-1,b=0,v=t-1,E=Number.EPSILON,S=0,I=0,R=0,T=0,A=0,D=0,N=0,V=0;for(n=0;n<t;n++)for((n<b||n>v)&&(r[n]=o.get(n,n),e[n]=0),i=Math.max(n-1,0);i<t;i++)I+=Math.abs(o.get(n,i));for(;M>=b;){for(h=M;h>b&&(D=Math.abs(o.get(h-1,h-1))+Math.abs(o.get(h,h)),0===D&&(D=I),!(Math.abs(o.get(h,h-1))<E*D));)h--;if(h===M)o.set(M,M,o.get(M,M)+S),r[M]=o.get(M,M),e[M]=0,M--,V=0;else if(h===M-1){if(f=o.get(M,M-1)*o.get(M-1,M),R=(o.get(M-1,M-1)-o.get(M,M))/2,T=R*R+f,N=Math.sqrt(Math.abs(T)),o.set(M,M,o.get(M,M)+S),o.set(M-1,M-1,o.get(M-1,M-1)+S),c=o.get(M,M),T>=0){for(N=R>=0?R+N:R-N,r[M-1]=c+N,r[M]=r[M-1],0!==N&&(r[M]=c-f/N),e[M-1]=0,e[M]=0,c=o.get(M,M-1),D=Math.abs(c)+Math.abs(N),R=c/D,T=N/D,A=Math.sqrt(R*R+T*T),R/=A,T/=A,i=M-1;i<t;i++)N=o.get(M-1,i),o.set(M-1,i,T*N+R*o.get(M,i)),o.set(M,i,T*o.get(M,i)-R*N);for(n=0;n<=M;n++)N=o.get(n,M-1),o.set(n,M-1,T*N+R*o.get(n,M)),o.set(n,M,T*o.get(n,M)-R*N);for(n=b;n<=v;n++)N=s.get(n,M-1),s.set(n,M-1,T*N+R*s.get(n,M)),s.set(n,M,T*s.get(n,M)-R*N)}else r[M-1]=c+R,r[M]=c+R,e[M-1]=N,e[M]=-N;M-=2,V=0}else{if(c=o.get(M,M),m=0,f=0,h<M&&(m=o.get(M-1,M-1),f=o.get(M,M-1)*o.get(M-1,M)),10===V){for(S+=c,n=b;n<=M;n++)o.set(n,n,o.get(n,n)-c);D=Math.abs(o.get(M,M-1))+Math.abs(o.get(M-1,M-2)),c=m=.75*D,f=-.4375*D*D}if(30===V&&(D=(m-c)/2,D=D*D+f,D>0)){for(D=Math.sqrt(D),m<c&&(D=-D),D=c-f/((m-c)/2+D),n=b;n<=M;n++)o.set(n,n,o.get(n,n)-D);S+=D,c=m=f=.964}for(V+=1,l=M-2;l>=h&&(N=o.get(l,l),A=c-N,D=m-N,R=(A*D-f)/o.get(l+1,l)+o.get(l,l+1),T=o.get(l+1,l+1)-N-A-D,A=o.get(l+2,l+1),D=Math.abs(R)+Math.abs(T)+Math.abs(A),R/=D,T/=D,A/=D,l!==h)&&!(Math.abs(o.get(l,l-1))*(Math.abs(T)+Math.abs(A))<E*(Math.abs(R)*(Math.abs(o.get(l-1,l-1))+Math.abs(N)+Math.abs(o.get(l+1,l+1)))));)l--;for(n=l+2;n<=M;n++)o.set(n,n-2,0),n>l+2&&o.set(n,n-3,0);for(a=l;a<=M-1&&(y=a!==M-1,a!==l&&(R=o.get(a,a-1),T=o.get(a+1,a-1),A=y?o.get(a+2,a-1):0,c=Math.abs(R)+Math.abs(T)+Math.abs(A),0!==c&&(R/=c,T/=c,A/=c)),0!==c);a++)if(D=Math.sqrt(R*R+T*T+A*A),R<0&&(D=-D),0!==D){for(a!==l?o.set(a,a-1,-D*c):h!==l&&o.set(a,a-1,-o.get(a,a-1)),R+=D,c=R/D,m=T/D,N=A/D,T/=R,A/=R,i=a;i<t;i++)R=o.get(a,i)+T*o.get(a+1,i),y&&(R+=A*o.get(a+2,i),o.set(a+2,i,o.get(a+2,i)-R*N)),o.set(a,i,o.get(a,i)-R*c),o.set(a+1,i,o.get(a+1,i)-R*m);for(n=0;n<=Math.min(M,a+3);n++)R=c*o.get(n,a)+m*o.get(n,a+1),y&&(R+=N*o.get(n,a+2),o.set(n,a+2,o.get(n,a+2)-R*A)),o.set(n,a,o.get(n,a)-R),o.set(n,a+1,o.get(n,a+1)-R*T);for(n=b;n<=v;n++)R=c*s.get(n,a)+m*s.get(n,a+1),y&&(R+=N*s.get(n,a+2),s.set(n,a+2,s.get(n,a+2)-R*A)),s.set(n,a,s.get(n,a)-R),s.set(n,a+1,s.get(n,a+1)-R*T)}}}if(0===I)return;for(M=t-1;M>=0;M--)if(R=r[M],T=e[M],0===T)for(h=M,o.set(M,M,1),n=M-1;n>=0;n--){for(f=o.get(n,n)-R,A=0,i=h;i<=M;i++)A+=o.get(n,i)*o.get(i,M);if(e[n]<0)N=f,D=A;else if(h=n,0===e[n]?o.set(n,M,0!==f?-A/f:-A/(E*I)):(c=o.get(n,n+1),m=o.get(n+1,n),T=(r[n]-R)*(r[n]-R)+e[n]*e[n],u=(c*D-N*A)/T,o.set(n,M,u),o.set(n+1,M,Math.abs(c)>Math.abs(N)?(-A-f*u)/c:(-D-m*u)/N)),u=Math.abs(o.get(n,M)),E*u*u>1)for(i=n;i<=M;i++)o.set(i,M,o.get(i,M)/u)}else if(T<0)for(h=M-1,Math.abs(o.get(M,M-1))>Math.abs(o.get(M-1,M))?(o.set(M-1,M-1,T/o.get(M,M-1)),o.set(M-1,M,-(o.get(M,M)-R)/o.get(M,M-1))):(x=Z(0,-o.get(M-1,M),o.get(M-1,M-1)-R,T),o.set(M-1,M-1,x[0]),o.set(M-1,M,x[1])),o.set(M,M-1,0),o.set(M,M,1),n=M-2;n>=0;n--){for(g=0,w=0,i=h;i<=M;i++)g+=o.get(n,i)*o.get(i,M-1),w+=o.get(n,i)*o.get(i,M);if(f=o.get(n,n)-R,e[n]<0)N=f,A=g,D=w;else if(h=n,0===e[n]?(x=Z(-g,-w,f,T),o.set(n,M-1,x[0]),o.set(n,M,x[1])):(c=o.get(n,n+1),m=o.get(n+1,n),p=(r[n]-R)*(r[n]-R)+e[n]*e[n]-T*T,d=2*(r[n]-R)*T,0===p&&0===d&&(p=E*I*(Math.abs(f)+Math.abs(T)+Math.abs(c)+Math.abs(m)+Math.abs(N))),x=Z(c*A-N*g+T*w,c*D-N*w-T*g,p,d),o.set(n,M-1,x[0]),o.set(n,M,x[1]),Math.abs(c)>Math.abs(N)+Math.abs(T)?(o.set(n+1,M-1,(-g-f*o.get(n,M-1)+T*o.get(n,M))/c),o.set(n+1,M,(-w-f*o.get(n,M)-T*o.get(n,M-1))/c)):(x=Z(-A-m*o.get(n,M-1),-D-m*o.get(n,M),N,T),o.set(n+1,M-1,x[0]),o.set(n+1,M,x[1]))),u=Math.max(Math.abs(o.get(n,M-1)),Math.abs(o.get(n,M))),E*u*u>1)for(i=n;i<=M;i++)o.set(i,M-1,o.get(i,M-1)/u),o.set(i,M,o.get(i,M)/u)}for(n=0;n<t;n++)if(n<b||n>v)for(i=n;i<t;i++)s.set(n,i,o.get(n,i));for(i=t-1;i>=b;i--)for(n=b;n<=v;n++){for(N=0,a=b;a<=Math.min(i,v);a++)N+=s.get(n,a)*o.get(a,i);s.set(n,i,N)}}(n,h,a,i,t)}this.n=n,this.e=h,this.d=a,this.V=i}get realEigenvalues(){return Array.from(this.d)}get imaginaryEigenvalues(){return Array.from(this.e)}get eigenvectorMatrix(){return this.V}get diagonalMatrix(){let t,e,r=this.n,s=this.e,o=this.d,n=new L(r,r);for(t=0;t<r;t++){for(e=0;e<r;e++)n.set(t,e,0);n.set(t,t,o[t]),s[t]>0?n.set(t,t+1,s[t]):s[t]<0&&n.set(t,t-1,s[t])}return n}}function Z(t,e,r,s){let o,n;return Math.abs(r)>Math.abs(s)?(o=s/r,n=r+o*s,[(t+o*e)/n,(e-o*t)/n]):(o=r/s,n=s+o*r,[(o*t+e)/n,(o*e-t)/n])}class tt{constructor(t){if(!(t=Y.checkMatrix(t)).isSymmetric())throw new Error("Matrix is not symmetric");let e,r,s,o=t,n=o.rows,i=new L(n,n),a=!0;for(r=0;r<n;r++){let t=0;for(s=0;s<r;s++){let n=0;for(e=0;e<s;e++)n+=i.get(s,e)*i.get(r,e);n=(o.get(r,s)-n)/i.get(s,s),i.set(r,s,n),t+=n*n}for(t=o.get(r,r)-t,a&&=t>0,i.set(r,r,Math.sqrt(Math.max(t,0))),s=r+1;s<n;s++)i.set(r,s,0)}this.L=i,this.positiveDefinite=a}isPositiveDefinite(){return this.positiveDefinite}solve(t){t=Y.checkMatrix(t);let e=this.L,r=e.rows;if(t.rows!==r)throw new Error("Matrix dimensions do not match");if(!1===this.isPositiveDefinite())throw new Error("Matrix is not positive definite");let s,o,n,i=t.columns,a=t.clone();for(n=0;n<r;n++)for(o=0;o<i;o++){for(s=0;s<n;s++)a.set(n,o,a.get(n,o)-a.get(s,o)*e.get(n,s));a.set(n,o,a.get(n,o)/e.get(n,n))}for(n=r-1;n>=0;n--)for(o=0;o<i;o++){for(s=n+1;s<r;s++)a.set(n,o,a.get(n,o)-a.get(s,o)*e.get(s,n));a.set(n,o,a.get(n,o)/e.get(n,n))}return a}get lowerTriangularMatrix(){return this.L}}class et{constructor(t,e={}){t=Y.checkMatrix(t);let{Y:r}=e;const{scaleScores:s=!1,maxIterations:o=1e3,terminationCriteria:n=1e-10}=e;let i;if(r){if(r=y.isAnyArray(r)&&"number"==typeof r[0]?L.columnVector(r):Y.checkMatrix(r),r.rows!==t.rows)throw new Error("Y should have the same number of rows as X");i=r.getColumnVector(0)}else i=t.getColumnVector(0);let a,h,l,u,f=1;for(let e=0;e<o&&f>n;e++)l=t.transpose().mmul(i).div(i.transpose().mmul(i).get(0,0)),l=l.div(l.norm()),a=t.mmul(l).div(l.transpose().mmul(l).get(0,0)),e>0&&(f=a.clone().sub(u).pow(2).sum()),u=a.clone(),r?(h=r.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),h=h.div(h.norm()),i=r.mmul(h).div(h.transpose().mmul(h).get(0,0))):i=a;if(r){let e=t.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0));e=e.div(e.norm());let s=t.clone().sub(a.clone().mmul(e.transpose())),o=i.transpose().mmul(a).div(a.transpose().mmul(a).get(0,0)),n=r.clone().sub(a.clone().mulS(o.get(0,0)).mmul(h.transpose()));this.t=a,this.p=e.transpose(),this.w=l.transpose(),this.q=h,this.u=i,this.s=a.transpose().mmul(a),this.xResidual=s,this.yResidual=n,this.betas=o}else this.w=l.transpose(),this.s=a.transpose().mmul(a).sqrt(),this.t=s?a.clone().div(this.s.get(0,0)):a,this.xResidual=t.sub(a.mmul(l.transpose()))}}w.AbstractMatrix=q,w.CHO=tt,w.CholeskyDecomposition=tt,w.DistanceMatrix=j,w.EVD=K,w.EigenvalueDecomposition=K,w.LU=W,w.LuDecomposition=W;var rt=w.Matrix=L;w.MatrixColumnSelectionView=class extends O{constructor(t,e){N(t,e),super(t,t.rows,e.length),this.columnIndices=e}set(t,e,r){return this.matrix.set(t,this.columnIndices[e],r),this}get(t,e){return this.matrix.get(t,this.columnIndices[e])}},w.MatrixColumnView=class extends O{constructor(t,e){R(t,e),super(t,t.rows,1),this.column=e}set(t,e,r){return this.matrix.set(t,this.column,r),this}get(t){return this.matrix.get(t,this.column)}},w.MatrixFlipColumnView=class extends O{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(t,this.columns-e-1,r),this}get(t,e){return this.matrix.get(t,this.columns-e-1)}},w.MatrixFlipRowView=class extends O{constructor(t){super(t,t.rows,t.columns)}set(t,e,r){return this.matrix.set(this.rows-t-1,e,r),this}get(t,e){return this.matrix.get(this.rows-t-1,e)}},w.MatrixRowSelectionView=class extends O{constructor(t,e){D(t,e),super(t,e.length,t.columns),this.rowIndices=e}set(t,e,r){return this.matrix.set(this.rowIndices[t],e,r),this}get(t,e){return this.matrix.get(this.rowIndices[t],e)}},w.MatrixRowView=class extends O{constructor(t,e){I(t,e),super(t,1,t.columns),this.row=e}set(t,e,r){return this.matrix.set(this.row,e,r),this}get(t,e){return this.matrix.get(this.row,e)}},w.MatrixSelectionView=_,w.MatrixSubView=class extends O{constructor(t,e,r,s,o){V(t,e,r,s,o),super(t,r-e+1,o-s+1),this.startRow=e,this.startColumn=s}set(t,e,r){return this.matrix.set(this.startRow+t,this.startColumn+e,r),this}get(t,e){return this.matrix.get(this.startRow+t,this.startColumn+e)}},w.MatrixTransposeView=class extends O{constructor(t){super(t,t.columns,t.rows)}set(t,e,r){return this.matrix.set(e,t,r),this}get(t,e){return this.matrix.get(e,t)}},w.NIPALS=et,w.Nipals=et,w.QR=X,w.QrDecomposition=X,w.SVD=B,w.SingularValueDecomposition=B,w.SymmetricMatrix=$,w.WrapperMatrix1D=U,w.WrapperMatrix2D=Y,w.correlation=function(t,e=t,r={}){t=new L(t);let s=!1;if("object"!=typeof e||L.isMatrix(e)||y.isAnyArray(e)?e=new L(e):(r=e,e=t,s=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:o=!0,scale:n=!0}=r;o&&(t.center("column"),s||e.center("column")),n&&(t.scale("column"),s||e.scale("column"));const i=t.standardDeviation("column",{unbiased:!0}),a=s?i:e.standardDeviation("column",{unbiased:!0}),h=t.transpose().mmul(e);for(let e=0;e<h.rows;e++)for(let r=0;r<h.columns;r++)h.set(e,r,h.get(e,r)*(1/(i[e]*a[r]))*(1/(t.rows-1)));return h},w.covariance=function(t,e=t,r={}){t=new L(t);let s=!1;if("object"!=typeof e||L.isMatrix(e)||y.isAnyArray(e)?e=new L(e):(r=e,e=t,s=!0),t.rows!==e.rows)throw new TypeError("Both matrices must have the same number of rows");const{center:o=!0}=r;o&&(t=t.center("column"),s||(e=e.center("column")));const n=t.transpose().mmul(e);for(let e=0;e<n.rows;e++)for(let r=0;r<n.columns;r++)n.set(e,r,n.get(e,r)*(1/(t.rows-1)));return n};var st=w.default=L;w.determinant=function t(e){if((e=L.checkMatrix(e)).isSquare()){if(0===e.columns)return 1;let r,s,o,n;if(2===e.columns)return r=e.get(0,0),s=e.get(0,1),o=e.get(1,0),n=e.get(1,1),r*n-s*o;if(3===e.columns){let n,i,a;return n=new _(e,[1,2],[1,2]),i=new _(e,[1,2],[0,2]),a=new _(e,[1,2],[0,1]),r=e.get(0,0),s=e.get(0,1),o=e.get(0,2),r*t(n)-s*t(i)+o*t(a)}return new W(e).determinant}throw Error("determinant can only be calculated for a square matrix")};var ot=w.inverse=function(t,e=!1){return t=Y.checkMatrix(t),e?new B(t).inverse():Q(t,L.eye(t.rows))};w.linearDependencies=function(t,e={}){const{thresholdValue:r=1e-9,thresholdError:s=1e-9}=e;let o=(t=L.checkMatrix(t)).rows,n=new L(o,o);for(let e=0;e<o;e++){let i=L.columnVector(t.getRow(e)),a=t.subMatrixRow(G(o,e)).transpose(),h=new B(a).solve(i),l=L.sub(i,a.mmul(h)).abs().max();n.setRow(e,J(l,h,e,r,s))}return n},w.pseudoInverse=function(t,e=Number.EPSILON){if((t=L.checkMatrix(t)).isEmpty())return t.transpose();let r=new B(t,{autoTranspose:!0}),s=r.leftSingularVectors,o=r.rightSingularVectors,n=r.diagonal;for(let t=0;t<n.length;t++)Math.abs(n[t])>e?n[t]=1/n[t]:n[t]=0;return o.mmul(L.diag(n).mmul(s.transpose()))},w.solve=Q,w.wrap=function(t,e){if(y.isAnyArray(t))return t[0]&&y.isAnyArray(t[0])?new Y(t):new U(t,e);throw new Error("the argument is not an array")};const nt=rt;st.Matrix&&st.Matrix;const it=ot;function at(t,e={}){f(t);const{fromIndex:r,toIndex:s}=m(t,e);let o=t[r];for(let e=r+1;e<=s;e++)t[e]>o&&(o=t[e]);return o}function ht(t,e={}){f(t);const{fromIndex:r,toIndex:s}=m(t,e);let o=t[r];for(let e=r+1;e<=s;e++)t[e]<o&&(o=t[e]);return o}function lt(t){f(t);let e=t[0],r=t[0];for(const s of t)s<e&&(e=s),s>r&&(r=s);return{min:e,max:r}}function ut(t){const{mad:e,median:r}=function(t){const e=a(t),r=new Float64Array(t.length);for(let s=0;s<t.length;s++)r[s]=Math.abs(t[s]-e);return{median:e,mad:a(r)}}(t);return{sd:e/.6744897501960817,mad:e,median:r}}function ft(t){let e=0;for(const r of t)e+=r**2;return Math.sqrt(e)}function ct(t,e,r,s){let o=null,n=null;const i=[],a=[];for(let h=1;h<t.length-1;++h)(r[h]<r[h-1]&&r[h]<=r[h+1]||r[h]<=r[h-1]&&r[h]<r[h+1])&&(n={x:e[h],index:h},s>0&&null!==o&&(i.push(o),a.push(n))),(r[h]>=r[h-1]&&r[h]>r[h+1]||r[h]>r[h-1]&&r[h]>=r[h+1])&&(o={x:e[h],index:h},s<0&&null!==n&&(i.push(o),a.push(n)));return{intervalL:i,intervalR:a}}function mt(t){const{x:e,lastK:r,minData:s,yThreshold:o,intervalWidth:n,intervalCenter:i,yData:a}=t;let h=Number.POSITIVE_INFINITY,l=-1,u=r;for(let t=u+1;t<s.length;t++){const r=s[t];if(a[r]<=o)continue;const f=e[r],c=Math.abs(f-i);if(c<n&&(c<h&&(l=t),u=t),c>=h)break;h=c}return{lastIndex:u,possible:l}}function gt(t){let e=-1;const r=[],{x:s,ddY:o,yData:n,yThreshold:i,intervalR:a,intervalL:h,minData:l}=t;for(let t=0;t<h.length;t++){const u=(a[t].x-h[t].x)/2,f=(a[t].x+h[t].x)/2,{possible:c=-1,lastIndex:m}=mt({x:s,lastK:e,minData:l,yThreshold:i,intervalWidth:u,intervalCenter:f,yData:n});if(-1!==c){const e=l[c],i=Math.abs(a[t].x-h[t].x);r.push({id:crypto.randomUUID(),x:s[e],y:n[e],width:i,index:e,ddY:o[e],inflectionPoints:{from:h[t],to:a[t]}})}e=m}return r}function wt(t,e={}){let{noiseLevel:s}=e;const{sgOptions:o={windowSize:9,polynomial:3},smoothY:n=!1,maxCriteria:i=!0,minMaxRatio:a=25e-5,realTopDetection:h=!1,peakDetectionAlgorithm:l="second"}=e,{x:u}=t;let{y:f}=t;if(1!==function(t){if(t.length<=2)return 1;if(t[0]===t[1]){for(let e=1;e<t.length-1;e++)if(t[e]!==t[e+1])return 0;return 1}if(t[0]<t.at(-1)){for(let e=0;e<t.length-1;e++)if(t[e]>=t[e+1])return 0;return 1}for(let e=0;e<t.length-1;e++)if(t[e]<=t[e+1])return 0;return-1}(u))throw new Error("GSD only accepts monotone increasing x values");f=f.slice();const c=function(t,e={}){if(t.length<3)return!0;const{tolerance:r=.05}=e;let s=0,o=Number.MAX_SAFE_INTEGER;for(let e=0;e<t.length-1;++e){const r=t[e+1]-t[e];r<o&&(o=r),r>s&&(s=r)}return(s-o)/s<r}(u);if(void 0===s)if(c){const t=ut(f);s=i?t.median+1.5*t.sd:-t.median+1.5*t.sd}else s=0;else i||(s*=-1);if(!i)for(let t=0;t<f.length;t++)f[t]*=-1;if(void 0!==s)for(let t=0;t<f.length;t++)f[t]<s&&(f[t]=s);const m=c?u[1]-u[0]:u,g=n?r(f,m,{...o,derivative:0}):f,{min:w,max:p}=lt(g);if(w>p||w===p)return[];const d=w+(p-w)*a,y={x:u,y:f,yData:g,dY:r(f,m,{...o,derivative:1}),ddY:r(f,m,{...o,derivative:2}),dX:u[1]-u[0],yThreshold:d};let x=[];return x="first"===l?function(t){const{x:e,y:r,yData:s,dY:o,ddY:n,dX:i,yThreshold:a}=t,h=[],{intervalL:l,intervalR:u}=ct(r,e,o,i);for(let t=1;t<r.length-1;++t)(o[t]<0&&o[t+1]>0||o[t]>0&&o[t+1]<0)&&h.push(Math.abs(o[t])<Math.abs(o[t+1])?t:t+1),0===o[t]&&o[t]<Math.abs(o[t+1])&&o[t]<Math.abs(o[t-1])&&h.push(t);return gt({minData:h,intervalL:l,intervalR:u,x:e,yData:s,yThreshold:a,ddY:n})}(y):"second"===l?function(t){const{x:e,y:r,yData:s,dY:o,ddY:n,dX:i,yThreshold:a}=t,h=[],{intervalL:l,intervalR:u}=ct(r,e,o,i);for(let t=1;t<r.length-1;++t)n[t]<n[t-1]&&n[t]<n[t+1]&&h.push(t);return gt({minData:h,intervalL:l,intervalR:u,x:e,yData:s,yThreshold:a,ddY:n})}(y):function(t){const{x:e,y:r,yData:s,dY:o,ddY:n,dX:i,yThreshold:a}=t,h=[],l=[],{intervalL:u,intervalR:f}=ct(r,e,o,i);for(let t=1;t<r.length-1;++t)(o[t]<0&&o[t+1]>0||o[t]>0&&o[t+1]<0)&&l.push(Math.abs(o[t])<Math.abs(o[t+1])?t:t+1),0===o[t]&&o[t]<Math.abs(o[t+1])&&o[t]<Math.abs(o[t-1])&&l.push(t),n[t]<n[t-1]&&n[t]<n[t+1]&&h.push(t);const c=[];let[m,g]=[-1,-1];for(let t=0;t<u.length;t++){const o=(f[t].x-u[t].x)/2,i=(f[t].x+u[t].x)/2;let w=-1,p=mt({x:e,yData:s,lastK:m,yThreshold:a,intervalWidth:o,intervalCenter:i,minData:l});if(m=p.lastIndex,-1!==p.possible?w=l[p.possible]:(p=mt({x:e,yData:s,yThreshold:a,lastK:g,intervalWidth:o,intervalCenter:i,minData:h}),-1!==p.possible&&(w=h[p.possible]),g=p.lastIndex),-1!==w){const s=Math.abs(f[t].x-u[t].x);c.push({id:crypto.randomUUID(),x:e[w],y:r[w],width:s,index:w,ddY:n[w],inflectionPoints:{from:u[t],to:f[t]}})}}return c}(y),h&&function(t,e){const{x:r,y:s}=t;for(const t of e){let e=t.index;if(s[e-1]>=s[e-2]&&s[e-1]>=s[e]?e--:s[e+1]>=s[e]&&s[e+1]>=s[e+2]?e++:s[e-2]>=s[e-3]&&s[e-2]>=s[e-1]?e-=2:s[e+2]>=s[e+1]&&s[e+2]>=s[e+3]&&(e+=2),s[e-1]>0&&s[e+1]>0&&s[e]>=s[e-1]&&s[e]>=s[e+1]&&(s[e]!==s[e-1]||s[e]!==s[e+1])){const o=20*Math.log10(s[e-1]),n=20*Math.log10(s[e]),i=20*Math.log10(s[e+1]),a=.5*(o-i)/(o-2*n+i),h=r[e],l=r[e-1];t.x=h+(h-l)*a,t.y=s[e]-.25*(s[e-1]-s[e+1])*a}}}({x:u,y:g},x),x.forEach(t=>{i||(t.y*=-1,t.ddY=-1*t.ddY)}),x.sort((t,e)=>t.x-e.x),x}const pt=-4*Math.LN2,dt=Math.sqrt(Math.PI/Math.LN2),yt=Math.sqrt(3),xt=Math.sqrt(2*Math.LN2),Mt=Math.sqrt(2*Math.LN2)-1;class bt{constructor(t={}){const{fwhm:e=500,sd:r}=t;this.fwhm=r?St(2*r):e}fwhmToWidth(t=this.fwhm){return function(t){return t/xt}(t)}widthToFWHM(t){return St(t)}fct(t){return Et(t,this.fwhm)}getArea(t=vt({fwhm:this.fwhm})){return function(t){let{fwhm:e=500,sd:r,height:s=1}=t;r&&(e=St(2*r));return s*dt*e/2}({fwhm:this.fwhm,height:t})}getFactor(t){return It(t)}getData(t={}){return function(t={},e={}){let{fwhm:r=500,sd:s}=t;s&&(r=St(2*s));let{length:o,factor:n=It(),height:i=vt({fwhm:r})}=e;o||(o=Math.min(Math.ceil(r*n),Math.pow(2,25)-1),o%2==0&&o++);const a=(o-1)/2,h=new Float64Array(o);for(let t=0;t<=a;t++)h[t]=Et(t-a,r)*i,h[o-1-t]=h[t];return h}(this,t)}calculateHeight(t=1){return vt({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}function vt(t){let{fwhm:e=500,area:r=1,sd:s}=t;return s&&(e=St(2*s)),2*r/dt/e}function Et(t,e){return Math.exp(pt*Math.pow(t/e,2))}function St(t){return t*xt}function It(t=.9999){return Math.sqrt(2)*function(t){if(0===t)return 0;let e=Math.log(1-t*t),r=e/2+2/(.147*Math.PI),s=Math.sqrt(r**2-e/.147);return Math.sqrt(s-r)*(t>0?1:-1)}(t)}class Rt{constructor(t={}){const{fwhm:e=500}=t;this.fwhm=e}fwhmToWidth(t=this.fwhm){return Vt(t)}widthToFWHM(t){return Nt(t)}fct(t){return Dt(t,this.fwhm)}getArea(t=1){return At({fwhm:this.fwhm,height:t})}getFactor(t){return kt(t)}getData(t={}){return Ft(this,t)}calculateHeight(t=1){return Tt({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}const Tt=({fwhm:t=1,area:e=1})=>2*e/Math.PI/t,At=t=>{const{fwhm:e=500,height:r=1}=t;return r*Math.PI*e/2},Dt=(t,e)=>e**2/(4*t**2+e**2),Nt=t=>t*yt,Vt=t=>t/yt,kt=(t=.9999)=>{if(t>=1)throw new Error("area should be (0 - 1)");const e=.5*(1-t),r=t=>Math.tan(Math.PI*(t-.5));return(r(1-e)-r(e))/2},Ft=(t={},e={})=>{let{fwhm:r=500}=t,{length:s,factor:o=kt(),height:n=Tt({fwhm:r,area:1})}=e;s||(s=Math.min(Math.ceil(r*o),Math.pow(2,25)-1),s%2==0&&s++);const i=(s-1)/2,a=new Float64Array(s);for(let t=0;t<=i;t++)a[t]=Dt(t-i,r)*n,a[s-1-t]=a[t];return a};class Ct{constructor(t={}){const{fwhm:e=500}=t;this.fwhm=e}fwhmToWidth(t=this.fwhm){return Vt(t)}widthToFWHM(t){return Nt(t)}fct(t){return qt(t,this.fwhm)}getArea(t){return 0}getFactor(t){return kt(t)}getData(t={}){return zt(this,t)}calculateHeight(t=1){return Tt({fwhm:this.fwhm,area:t})}getParameters(){return["fwhm"]}}const qt=(t,e)=>2*e*t/(4*t**2+e**2),zt=(t={},e={})=>{let{fwhm:r=500}=t,{length:s,factor:o=kt(),height:n=Tt({fwhm:r,area:1})}=e;s||(s=Math.min(Math.ceil(r*o),Math.pow(2,25)-1),s%2==0&&s++);const i=(s-1)/2,a=new Float64Array(s);for(let t=0;t<=i;t++)a[t]=qt(t-i,r)*n,a[s-1-t]=-a[t];return a};class Pt{constructor(t={}){const{fwhm:e=500,mu:r=.5}=t;this.mu=r,this.fwhm=e}fwhmToWidth(t=this.fwhm,e=this.mu){return Ot(t,e)}widthToFWHM(t,e=this.mu){return jt(t,e)}fct(t){return $t(t,this.fwhm,this.mu)}getArea(t=1){return _t({fwhm:this.fwhm,height:t,mu:this.mu})}getFactor(t){return Ut(t)}getData(t={}){const{length:e,factor:r,height:s=Lt({fwhm:this.fwhm,mu:this.mu,area:1})}=t;return Yt(this,{factor:r,length:e,height:s})}calculateHeight(t=1){return Lt({fwhm:this.fwhm,mu:this.mu,area:t})}getParameters(){return["fwhm","mu"]}}const Lt=(t={})=>{let{fwhm:e=1,mu:r=.5,area:s=1}=t;return 2*s/(e*(r*dt+(1-r)*Math.PI))},$t=(t,e,r)=>(1-r)*Dt(t,e)+r*Et(t,e),jt=(t,e=.5)=>t*(e*Mt+1),Ot=(t,e=.5)=>t/(e*Mt+1),_t=t=>{const{fwhm:e=500,height:r=1,mu:s=.5}=t;return e*r*(s*dt+(1-s)*Math.PI)/2},Ut=(t=.9999,e=.5)=>e<1?kt(t):It(t),Yt=(t={},e={})=>{let{fwhm:r=500,mu:s=.5}=t,{length:o,factor:n=Ut(.999,s),height:i=Lt({fwhm:r,mu:s,area:1})}=e;i||(i=1/(s/Math.sqrt(-pt/Math.PI)*r+(1-s)*r*Math.PI/2)),o||(o=Math.min(Math.ceil(r*n),Math.pow(2,25)-1),o%2==0&&o++);const a=(o-1)/2,h=new Float64Array(o);for(let t=0;t<=a;t++)h[t]=$t(t-a,r,s)*i,h[o-1-t]=h[t];return h};class Wt{constructor(t={}){const{fwhm:e=500,gamma:r=.5}=t;this.fwhm=e,this.gamma=r}fwhmToWidth(t=this.fwhm){return Gt(t)}widthToFWHM(t){return Qt(t)}fct(t){return Bt(t,this.fwhm,this.gamma)}getArea(t=1){return Xt({fwhm:this.fwhm,height:t,gamma:this.gamma})}getFactor(t){return Jt(t)}getData(t={}){return Kt(this,t)}calculateHeight(t=1){const{gamma:e,fwhm:r}=this;return Ht({fwhm:r,area:t,gamma:e})}getParameters(){return["fwhm","gamma"]}}const Ht=({fwhm:t=1,gamma:e=1,area:r=1})=>r/t/(3.14159-.420894*e)*2,Xt=t=>{const{fwhm:e=500,height:r=1,gamma:s=1}=t;return r*e*(3.14159-.420894*s)/2},Bt=(t,e,r)=>{const s=(2*t/e)**2;return(1-r)/(1+s)+r*(1+s/2)/(1+s+s**2)},Qt=t=>t*yt,Gt=t=>t/yt,Jt=(t=.9999)=>{if(t>=1)throw new Error("area should be (0 - 1)");const e=.5*(1-t),r=t=>Math.tan(Math.PI*(t-.5));return(r(1-e)-r(e))/2},Kt=(t={},e={})=>{let{fwhm:r=500,gamma:s=1}=t,{length:o,factor:n=Jt(),height:i=Ht({fwhm:r,area:1,gamma:s})}=e;o||(o=Math.min(Math.ceil(r*n),Math.pow(2,25)-1),o%2==0&&o++);const a=(o-1)/2,h=new Float64Array(o);for(let t=0;t<=a;t++)h[t]=Bt(t-a,r,s)*i,h[o-1-t]=h[t];return h};function Zt(t){const{kind:e}=t;switch(e){case"gaussian":return new bt(t);case"lorentzian":return new Rt(t);case"pseudoVoigt":return new Pt(t);case"lorentzianDispersive":return new Ct(t);case"generalizedLorentzian":return new Wt(t);default:throw Error(`Unknown distribution ${e}`)}}function te(t,e){if(!t)throw new Error(e||"unreachable")}const ee={x:{init:t=>t.x,min:(t,e)=>t.x-2*e.fwhm,max:(t,e)=>t.x+2*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},y:{init:t=>t.y,min:t=>t.y<0?-1.1:0,max:t=>t.y<0?0:1.1,gradientDifference:()=>.001},fwhm:{init:(t,e)=>e.fwhm,min:(t,e)=>.25*e.fwhm,max:(t,e)=>4*e.fwhm,gradientDifference:(t,e)=>.002*e.fwhm},mu:{init:(t,e)=>e.mu,min:()=>0,max:()=>1,gradientDifference:()=>.01},gamma:{init:(t,e)=>e.gamma||.5,min:()=>-1,max:()=>2,gradientDifference:()=>.01}},re=["init","min","max","gradientDifference"];function se(t,e,r,s,o){return"y"===e?"gradientDifference"===r?t:void 0!==o?(t-o)/s.range:(t-s.min)/s.range:t}function oe(t,r){const{timeout:s,initialValues:o,weights:n=1,damping:i=.01,dampingStepUp:a=11,dampingStepDown:h=9,maxIterations:l=100,errorTolerance:u=1e-7,centralDifference:f=!1,gradientDifference:c=.1,improvementThreshold:m=.001}=r;let{minValues:g,maxValues:w}=r;if(i<=0)throw new Error("The damping option must be a positive number");if(!t.x||!t.y)throw new Error("The data parameter must have x and y elements");if(!e(t.x)||t.x.length<2||!e(t.y)||t.y.length<2)throw new Error("The data parameter elements must be an array with more than 2 points");if(t.x.length!==t.y.length)throw new Error("The data parameter elements must have the same size");if(!(o&&o.length>0))throw new Error("The initialValues option is mandatory and must be an array");const p=Array.from(o),d=p.length;if(w=w||new Array(d).fill(Number.MAX_SAFE_INTEGER),g=g||new Array(d).fill(Number.MIN_SAFE_INTEGER),w.length!==g.length)throw new Error("minValues and maxValues must be the same size");const y=function(t,r){if("number"==typeof t)return new Array(r.length).fill(t);if(e(t)){const e=r.length;return t.length!==e?new Array(e).fill(t[0]):Array.from(t)}throw new Error("gradientDifference should be a number or array with length equal to the number of parameters")}(c,p),x=function(t,r){if("number"==typeof t){const e=1/t**2;return()=>e}if(e(t)){if(t.length<r){const e=1/t[0]**2;return()=>e}return e=>1/t[e]**2}throw new Error("weights should be a number or array with length equal to the number of data points")}(n,t.x.length),M=function(t){if(void 0!==t){if("number"!=typeof t)throw new Error("timeout should be a number");const e=Date.now()+1e3*t;return()=>Date.now()>e}return()=>!1}(s);return{checkTimeout:M,minValues:g,maxValues:w,parameters:p,weightSquare:Array.from({length:t.x.length},(t,e)=>x(e)),damping:i,dampingStepUp:a,dampingStepDown:h,maxIterations:l,errorTolerance:u,centralDifference:f,gradientDifference:y,improvementThreshold:m}}function ne(t,e,r,s){let o=0;const n=r(e);for(let e=0;e<t.x.length;e++)o+=(t.y[e]-n(t.x[e]))**2/s[e];return o}function ie(t,e,r,s,o,n,i){const a=nt.eye(e.length,e.length,r),h=o(e),l=new Float64Array(t.x.length);for(let e=0;e<t.x.length;e++)l[e]=h(t.x[e]);const u=function(t,e,r,s,o,n){const i=r.length,a=t.x.length,h=nt.zeros(i,a);let l=0;for(let u=0;u<i;u++){if(0===s[u])continue;let i=s[u],f=r.slice();f[u]+=i;const c=o(f);if(n){f=r.slice(),f[u]-=i,i*=2;const e=o(f);for(let r=0;r<a;r++)h.set(l,r,(e(t.x[r])-c(t.x[r]))/i)}else for(let r=0;r<a;r++)h.set(l,r,(e[r]-c(t.x[r]))/i);l++}return h}(t,l,e,s,o,n),f=function(t,e){const r=t.x.length,s=new nt(r,1);for(let o=0;o<r;o++)s.set(o,0,t.y[o]-e[o]);return s}(t,l),c=it(a.add(u.mmul(u.transpose().scale("row",{scale:i})))),m=u.mmul(f.scale("row",{scale:i}));return{perturbations:c.mmul(m),jacobianWeightResidualError:m}}function ae(t,e,r){const s=oe(t,r),{checkTimeout:o,minValues:n,maxValues:i,parameters:a,weightSquare:h,dampingStepUp:l,dampingStepDown:u,maxIterations:f,errorTolerance:c,centralDifference:m,gradientDifference:g,improvementThreshold:w}=s;let p=s.damping,d=ne(t,a,e,h),y=d,x=a.slice(),M=d<=c,b=0;for(;b<f&&!M;b++){const s=d,{perturbations:f,jacobianWeightResidualError:b}=ie(t,a,p,g,e,m,h);for(let t=0;t<a.length;t++)a[t]=Math.min(Math.max(n[t],a[t]-f.get(t,0)),i[t]);if(d=ne(t,a,e,h),isNaN(d))break;d<y-c&&(y=d,x=a.slice());if(p=(s-d)/f.transpose().mmul(f.mul(p).add(b)).get(0,0)>w?Math.max(p/u,1e-7):Math.min(p*l,1e7),o())throw new Error(`The execution time is over to ${r.timeout} seconds`);M=d<=c}return{parameterValues:x,parameterError:y,iterations:b}}function he(t,e){if(t.length!==e.length)throw new RangeError("X and Y vectors has different dimensions");const r=t.length-1;if(0===r)return[0];if(1===r)return[0,1];let s=0,o=new Array(t.length).fill(!0);for(;;){const n=s,i=ue(s,r,o),a=ue(ue(s,r,o),r,o);if(t[a]*(e[n]-e[i])+t[n]*(e[i]-e[a])+t[i]*(e[a]-e[n])>=0?s=i:(o[i]=!1,s=le(s,r,o)),a===r)break}return o.map((t,e)=>!1!==t&&e).filter(t=>!1!==t)}function le(t,e,r){let s=t-1;for(;!1===r[s];)s--;return 0===t?e:s}function ue(t,e,r){let s=t+1;for(;!1===r[s];)s++;return t===e?0:s}function fe(t,e,r,s){let o=[];for(let n=0;n<t.length;n++)o[n]=Math.abs(t[n]-(s+r))/e[n];const n=ht(o);return o.findIndex(t=>t===n)}function ce(t,e,r){const{minValues:s,maxValues:o,maxIterations:n,epsilon:i,tolerance:a,tolerance2:h,initialState:l}=r,u=function(t,e){const{x:r,y:s}=t,o=r.length;return t=>{const n=e(t);let i=0;for(let t=0;t<o;t++)i+=(s[t]-n(r[t]))**2;return i}}(t,e),f=function(t,e,r,s={}){const{iterations:o=50,epsilon:n=1e-4,tolerance:i=1e-16,tolerance2:a=1e-12,initialState:h={}}=s;if(void 0===t||void 0===e||void 0===r)throw new RangeError("There is something undefined");if(e=new Float64Array(e),r=new Float64Array(r),e.length!==r.length)throw new Error("Lower bounds and Upper bounds for x are not of the same length");let l=e.length,u=r.map((t,r)=>t-e[r]),{numberOfRectangles:f=0,totalIterations:c=0,unitaryCoordinates:m=[new Float64Array(l).fill(.5)],middlePoint:g=new Float64Array(l).map((t,r)=>e[r]+m[0][r]*u[r]),bestCurrentValue:w=t(g),fCalls:p=1,smallerDistance:d=0,edgeSizes:y=[new Float64Array(l).fill(.5)],diagonalDistances:x=[Math.sqrt(.25*l)],functionValues:M=[w],differentDistances:b=x,smallerValuesByDistance:v=[w],choiceLimit:E}=h;if(h.originalCoordinates&&h.originalCoordinates.length>0){w=ht(M),E=n*Math.abs(w)>1e-8?n*Math.abs(w):1e-8,d=fe(M,x,E,w),m=h.originalCoordinates.slice();for(let t=0;t<m.length;t++)for(let r=0;r<e.length;r++)m[t][r]=(m[t][r]-e[r])/u[r]}let S=0;for(;S<o;){let r,s,o=[],h=b.findIndex(t=>t===x[d]),l=0;for(let t=h;t<b.length;t++)for(let e=0;e<M.length;e++)M[e]===v[t]&x[e]===b[t]&&(o[l++]=e);if(b.length-h>1){let t=x[d],e=M[d],r=b[b.length-1],n=(v[b.length-1]-e)/(r-t),i=e-n*t,h=new Uint32Array(l);l=0;for(let t=0;t<h.length;t++){let e=o[t];M[e]<=n*x[e]+i+a&&(h[l++]=e)}let u=[],f=[];for(let t=0;t<l;t++)u.push(x[h[t]]),f.push(M[h[t]]);let c=he(u,f);s=[];for(let t=0;t<c.length;t++)s.push(h[c[t]])}else s=o.slice(0,l);r=s;for(let s=0;s<r.length;s++){let o=r[s],n=at(y[o]),a=new Uint32Array(y[o].length);l=0;for(let t=0;t<y[o].length;t++)Math.abs(y[o][t]-n)<i&&(a[l++]=t);let h=2*n/3,c=[];for(let r=0;r<l;r++){let s=a[r],n=m[o].slice(),i=m[o].slice();n[s]+=h,i[s]-=h;let l=new Float64Array(n.length),f=new Float64Array(i.length);for(let t=0;t<n.length;t++)l[t]=e[t]+n[t]*u[t],f[t]=e[t]+i[t]*u[t];let g=t(l),w=t(f);p+=2,c.push({minValue:Math.min(g,w),index:r}),m.push(n,i),M.push(g,w)}let g=c.sort((t,e)=>t.minValue-e.minValue);for(let t=0;t<l;t++){let e=a[g[t].index],r=f+2*(g[t].index+1)-1,s=f+2*(g[t].index+1);y[o][e]=h/2,y[r]=y[o].slice(),y[s]=y[o].slice(),x[o]=ft(y[o]),x[r]=x[o],x[s]=x[o]}f+=2*l}w=ht(M),E=n*Math.abs(w)>1e-8?n*Math.abs(w):1e-8,d=fe(M,x,E,w),b=Array.from(new Set(x)),b=b.sort((t,e)=>t-e),v=[];for(let t=0;t<b.length;t++){let e,r=Number.POSITIVE_INFINITY;for(let s=0;s<x.length;s++)x[s]===b[t]&&M[s]<r&&(r=M[s],e=s);v.push(M[e])}for(let t=0;t<M.length;t++)if(M[t]===w){let r=[];for(let s=0;s<e.length;s++)r.push(e[s]+m[t][s]*u[s])}S+=1}let I={};I.minFunctionValue=w,I.iterations=S;let R=[];for(let t=0;t<f+1;t++){let r=[];for(let s=0;s<e.length;s++)r.push(e[s]+m[t][s]*u[s]);R.push(r)}I.finalState={numberOfRectangles:f,totalIterations:c+=o,originalCoordinates:R,middlePoint:g,fCalls:p,smallerDistance:d,edgeSizes:y,diagonalDistances:x,functionValues:M,differentDistances:b,smallerValuesByDistance:v,choiceLimit:E};let T=[];for(let t=0;t<M.length;t++)M[t]===w&&T.push(R[t]);return I.optima=T,I}(u,s,o,{iterations:n,epsilon:i,tolerance:a,tolerance2:h,initialState:l}),{optima:c}=f;return{parameterError:f.minFunctionValue,iterations:f.iterations,parameterValues:c[0]}}function me(t,e,r={}){const s=lt(t.y),o={...s,range:s.max-s.min},n=function(t,e,r={}){let s=0;const o=[],{baseline:n=e.min}=r,i=t.map(t=>({...t,y:(t.y-n)/e.range}));for(const t of i){const{id:n,shape:i=(r.shape?r.shape:{kind:"gaussian"})}=t,a=Zt(i),h=["x","y",...a.getParameters()],l={min:[],max:[],init:[],gradientDifference:[]};for(const s of h)for(const o of re){let n=t?.parameters?.[s]?.[o];if(n){n=se(n,s,o,e,r.baseline),l[o].push(n);continue}let i=r?.parameters?.[s]?.[o];if(i){if("number"==typeof i){i=se(i,s,o,e,r.baseline),l[o].push(i);continue}{let n=i(t);n=se(n,s,o,e,r.baseline),l[o].push(n);continue}}te(ee[s],`No default parameter for ${s}`);const h=ee[s][o];l[o].push(h(t,a))}const u=s,f=u+h.length-1;s+=f-u+1,o.push({id:n,shape:i,shapeFct:a,parameters:h,propertiesValues:l,fromIndex:u,toIndex:f})}return o}(e,o,r),{baseline:i=o.min}=r,a=new Float64Array(t.y.length);for(let e=0;e<t.y.length;e++)a[e]=(t.y[e]-i)/o.range;const h=n[n.length-1].toIndex+1,l=new Float64Array(h),u=new Float64Array(h),f=new Float64Array(h),c=new Float64Array(h);let m=0;for(const t of n)for(let e=0;e<t.parameters.length;e++)l[m]=t.propertiesValues.min[e],u[m]=t.propertiesValues.max[e],f[m]=t.propertiesValues.init[e],c[m]=t.propertiesValues.gradientDifference[e],m++;const{algorithm:g,optimizationOptions:w}=function(t={}){const{kind:e="lm",options:r}=t;switch(e){case"lm":case"levenbergMarquardt":return{algorithm:ae,optimizationOptions:{damping:1.5,maxIterations:100,errorTolerance:1e-8,...r}};case"direct":return{algorithm:ce,optimizationOptions:{iterations:20,epsilon:1e-4,tolerance:1e-16,tolerance2:1e-12,initialState:{},...r}};default:throw new Error("Unknown fitting algorithm")}}(r.optimization),p=function(t){return function(e){return r=>{let s=0;for(const o of t){const t=e[o.fromIndex],n=e[o.fromIndex+1];for(let t=2;t<e.length;t++){const r=o.parameters[t];o.shapeFct[r]=e[o.fromIndex+t]}s+=n*o.shapeFct.fct(r-t)}return s}}}(n),d=g({x:t.x,y:a},p,{minValues:l,maxValues:u,initialValues:f,gradientDifference:c,...w}),y=d.parameterValues,x=[];for(const t of n){const{id:e,shape:r,parameters:s,fromIndex:n}=t;let a={x:0,y:0,shape:r};e&&(a={...a,id:e}),a.x=y[n],a.y=y[n+1]*o.range+i;for(let t=2;t<s.length;t++)a.shape[s[t]]=y[n+t];x.push(a)}return{error:d.parameterError,iterations:d.iterations,peaks:x}}function ge(t,e={}){const{shape:r={kind:"gaussian"},output:s=structuredClone(t)}=e,o=Zt(r);return s.map(t=>{if(function(t){return"shape"in t}(t)){if(!("fwhm"in t.shape)){const e=Zt(t.shape);t.shape.fwhm=e.widthToFWHM(t.width)}return t}return{...t,shape:{fwhm:o.widthToFWHM(t.width),...r}}})}function we(t,e,r={}){const{fromTo:s={},baseline:o,shape:n={kind:"gaussian"},groupingFactor:i=1,factorLimits:a=2,optimization:h={kind:"lm",options:{timeout:10}}}=r,l=function(t,e={}){if(t&&0===t.length)return[];const{factor:r=1}=e;(t=JSON.parse(JSON.stringify(t))).sort((t,e)=>t.x-e.x);let s=t[0],o=[s];const n=[o];for(let e=1;e<t.length;e++){const i=t[e];(i.x-s.x)/((i.width+s.width)/2)<=r?o.push(i):(o=[i],n.push(o)),s=i}return n}(e,{factor:i}),u=[],f=[];return l.forEach(e=>{const r=Date.now(),i=ge(e,{shape:n}),l=i[0],c=i[i.length-1],{from:g=l.x-l.width*a,to:w=c.x+c.width*a}=s,{fromIndex:p,toIndex:d}=m(t.x,{from:g,to:w}),y=t.x instanceof Float64Array?t.x.subarray(p,d):t.x.slice(p,d),x=t.y instanceof Float64Array?t.y.subarray(p,d):t.y.slice(p,d),M={range:{from:g,to:w},parameters:h,groupSize:e.length,time:Date.now()-r};if(y.length>5){const{iterations:t,error:e,peaks:r}=me({x:y,y:x},i,{shape:n,baseline:o,optimization:h});for(let t=0;t<i.length;t++)f.push({...r[t],width:Zt(i[t].shape).fwhmToWidth(r[t].shape.fwhm)});u.push({...M,iterations:t,error:e,message:"optimization successful"})}else f.push(...i),u.push({...M,iterations:0,message:"x length too small for optimization"})}),{logs:u,optimizedPeaks:f}}function pe(t,e,r={}){return we(t,e,r).optimizedPeaks}function de(t,e={}){const{output:r=structuredClone(t)}=e;for(const t of r)"id"in t||(t.id=crypto.randomUUID());return r}function ye(t,e={}){const{shape:r={kind:"gaussian"},optimization:s={kind:"lm",options:{timeout:10}},broadWidth:o=.25,broadRatio:n=.0025}=e;let i=0,a=0,h=1;const l=[];if(t.length<2)return de(ge(t.map(Me),{shape:r}));let u=t[0].ddY;for(let e=1;e<t.length;e++)Math.abs(t[e].ddY)>u&&(u=Math.abs(t[e].ddY));const f=[];for(const e of t)Math.abs(e.ddY)<=n*u?l.push(e):f.push(Me(e));l.push({x:Number.MAX_VALUE,y:0});let c={x:[l[0].x],y:[l[0].y]},m=[0];for(let t=1;t<l.length;t++)if(Math.abs(l[t-1].x-l[t].x)<o)c.x.push(l[t].x),c.y.push(l[t].y),l[t].y>i&&(i=l[t].y,a=t),m.push(t),h++;else{if(h>2){const t=Math.abs(c.x[c.x.length-1]-c.x[0]),{logs:e,optimizedPeaks:r}=we(c,[{id:crypto.randomUUID(),x:l[a].x,y:i,width:t,parameters:{width:{max:4*t,min:.8*t}}}],{shape:{kind:"pseudoVoigt"},optimization:s});[i,a]=[0,0];const o=e.find(t=>"optimization successful"===t.message);if(o){const{error:t}=o;t<.2?f.push(r[0]):xe(l,m,f)}else xe(l,m,f)}else xe(l,m,f);c={x:[l[t].x],y:[l[t].y]},m=[t],i=l[t].y,a=t,h=1}return f.sort((t,e)=>t.x-e.x),de(f,{output:f})}function xe(t,e,r){for(const s of e)r.push(Me(t[s]))}function Me(t){const{id:e,shape:r,x:s,y:o,width:n}=t,i={x:s,y:o,width:n,shape:r};return e&&(i.id=e),i}function be(t,e={}){const{factor:r=2,overlap:s=!1}=e,o=function(t,e){return t.map(t=>{const{id:r,shape:s}=t,o=t.x-(t.x-t.inflectionPoints.from.x)*e,n=t.x+(t.inflectionPoints.to.x-t.x)*e;let i={x:t.x,y:t.y,index:t.index,width:n-o,from:{x:o},to:{x:n}};return r&&(i={...i,id:r}),s&&(i={...i,shape:s}),i})}(t,r);if(!s)for(let t=0;t<o.length-1;t++){const e=o[t],r=o[t+1];e.to.x>r.from.x&&(e.to.x=e.width/(r.width+e.width)*(r.x-e.x)+e.x,r.from.x=e.to.x)}for(const t of o)if(t.width=t.to.x-t.from.x,t.shape){const{shape:e,width:r}=t;if(void 0!==e.fwhm){const s=Zt(e);t.shape.fwhm=s.widthToFWHM(r)}}return o}const{parse:ve,stringify:Ee}=JSON;function Se(t,e={}){const{shape:r={kind:"gaussian"},output:s=ve(Ee(t))}=e,o=Zt(r);return s.map(t=>({...t,shape:{fwhm:o.widthToFWHM(t.width),...r}}))}export{ge as addMissingShape,be as broadenPeaks,wt as gsd,ye as joinBroadPeaks,pe as optimizePeaks,we as optimizePeaksWithLogs,Se as setShape};
//# sourceMappingURL=ml-gsd.esm.min.js.map
